;========================================================================================
;  rapidcleartest.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;	rapidcleartest.x
;
;	OtBbNʂ̍NAeXg܂B
;	GAeXgƃ|[geXg𓯎ɍs܂B
;	GAeXgVRAM̃NAꂽׂ͈͂܂B
;	|[geXgCRTC̓|[gbit1̕ωׂ܂B
;
;	LCD̓gIĂƂꎞICRTɕύX܂B
;
;----------------------------------------------------------------

	.include	bioswork.equ
	.include	control2.mac
	.include	crtc.equ
	.include	doscall.mac
	.include	iocscall.mac
	.include	mfp.equ
	.include	misc.mac
	.include	push2.mac
	.include	vicon.equ


NAME	reg	'rapidcleartest.x'
VERSION	reg	'(2025-09-26)'


;萔
MASK	equ	%0110		;ʃTCY512x512̂ƂNA4bity[W̃}XN
PAINTED	equ	$5432		;hׂpbg
T0	equ	(((.not.MASK)&%0001)*$000F)&PAINTED
T1	equ	(((.not.MASK)&%0010)*$0078)&PAINTED
T2	equ	(((.not.MASK)&%0100)*$03C0)&PAINTED
T3	equ	(((.not.MASK)&%1000)*$1E00)&PAINTED
CLEARED	equ	T3|T2|T1|T0	;NAꂽpbg


;WX^
dPAGE	reg	d4			;y[W
dSCROLL	reg	d5			;XN[ʒu̔ԍ
dSCRLX	reg	d6			;X̃XN[ʒu
dSCRLY	reg	d7			;ỸXN[ʒu
aINFO	reg	a5			;ʃ[h̏
aBASE	reg	a6			;΃ANZXx[XAhX


;΃ANZXx[XAhX
base:
	lea.l	base(pc),aBASE
r	reg	-base(aBASE)

;X^bNGAݒ肷
	move.l	#stack_tail-base,d0
	lea.l	(aBASE,d0.l),sp

;mF
	addq.l	#1,a2
;ʃ[h
	moveq.l	#-2,d1			;-3=G[,-2=wȂ,-1=all,0`18=ʃ[h
	lea.l	(str_buffer)r,a0
	movea.l	a2,a1
	jbsr	argcpy
	movea.l	a1,a2
	if	ne
		lea.l	(str_buffer)r,a0
		movestr	<'all'>,a1
		jbsr	stricmp
		if	eq
			moveq.l	#-1,d1			;-1=all
		else
			jbsr	stou
			ifand	<>,cc,<cmp.l #18,d0>,ls
				move.w	d0,d1			;0`18=ʃ[h
			else
				moveq.l	#-3,d1			;-3=G[
			endif
		endif
	endif
;XN[ʒu̔ԍ
	moveq.l	#-2,d2			;-3=G[,-2=wȂ,-1=all,0`3=XN[ʒu̔ԍ
	lea.l	(str_buffer)r,a0
	movea.l	a2,a1
	jbsr	argcpy
	movea.l	a1,a2
	if	ne
		lea.l	(str_buffer)r,a0
		movestr	<'all'>,a1
		jbsr	stricmp
		if	eq
			moveq.l	#-1,d2			;-1=all
		else
			jbsr	stou
			ifand	<>,cc,<cmp.l #3,d0>,ls
				move.w	d0,d2			;0`3=XN[ʒu̔ԍ
			else
				moveq.l	#-3,d2			;-3=G[
			endif
		endif
	endif
;
	ifor	<cmp.w #-2,d1>,le,<cmp.w #-3,d2>,le
		movestr	<NAME,' ',VERSION,13,10,'  ',NAME,' mode(0-18,all) scroll(0-3,[all])',13,10>,a0
		jbsr	print
		move.w	#1,-(sp)
		DOS	_EXIT2
	endif
	move.w	d1,(specified_mode)r
	move.w	d2,(specified_scroll)r

;eXg̒ʉߐƑ
	clr.l	(area_passed)r
	clr.l	(area_tested)r
	clr.l	(port_passed)r
	clr.l	(port_tested)r

;ʃ[hۑ
	move.l	#$000E_FFFF,-(sp)
	DOS	_CONCTRL
	move.w	d0,2(sp)
	move.l	#$0010_FFFF,-(sp)
	DOS	_CONCTRL
	move.w	d0,2(sp)

;LCDۑCRTɕύX
	moveq.l	#0,d0
	move.w	#$16FF,d1
	IOCS	_CRTMOD
	rol.l	#8,d0
	moveq.l	#0,d1
	if	<cmp.b #$96,d0>,eq	;LCD
		move.w	#$43FF,d1		;CRT
		IOCS	_CRTMOD
		moveq.l	#1,d1
	endif
	move.w	d1,-(sp)

;A{[gۑ
	move.w	#_ERRJVC,-(sp)
	DOS	_INTVCG
	addq.l	#2,sp
	move.l	d0,-(sp)
	move.w	#_CTRLVC,-(sp)
	DOS	_INTVCG
	addq.l	#2,sp
	move.l	d0,-(sp)

;A{[gύX
	pea.l	(abort_process)r
	move.w	#_CTRLVC,-(sp)
	DOS	_INTVCS
	addq.l	#6,sp
	move.l	sp,(abort_sp)r

;X[p[oCU[hֈڍs
	supervisormode

;ʃ[h̃[v
	lea.l	(info_array)r,aINFO	;ʃ[h̏
	do
		move.w	(specified_mode)r,d0	;w肳ꂽʃ[h
		ifor	<>,mi,<cmp.w i_crtmod(aINFO),d0>,eq	;all܂͈v
			bsr	test_mode		;ʃ[h̃eXg
		endif
		lea.l	i_sizeof(aINFO),aINFO	;̉ʃ[h̏
	while	<tst.w i_crtmod(aINFO)>,pl

;[U[h֕A
	usermode

;A{[g𕜌
abort_process:
	lea.l	base(pc),aBASE
	movea.l	(abort_sp)r,sp
	move.w	#_CTRLVC,-(sp)
	DOS	_INTVCS
	addq.l	#6,sp
	move.w	#_ERRJVC,-(sp)
	DOS	_INTVCS
	addq.l	#6,sp

;LCD𕜌
	tst.w	(sp)+
	if	ne			;LCD
		move.w	#$4CFF,d1		;LCD
		IOCS	_CRTMOD
	endif

;ʃ[h𕜌
	DOS	_CONCTRL
	addq.l	#4,sp
	DOS	_CONCTRL
	addq.l	#4,sp

;eXǧʂ\
	lea.l	(str_buffer)r,a0
;GAeXg
	movestr	<'area test passed '>,a1
	jbsr	strcpy
	move.l	(area_passed)r,d0
	move.l	(area_tested)r,d1
	bsr	ratio
	jbsr	crlf
;|[geXg
	movestr	<'port test passed '>,a1
	jbsr	strcpy
	move.l	(port_passed)r,d0
	move.l	(port_tested)r,d1
	bsr	ratio
	jbsr	crlf
;
	lea.l	(str_buffer)r,a0
	jbsr	print

;I
exit:
	DOS	_EXIT


;ʃ[h̃eXg
;<aINFO.l:ʃ[h̏
test_mode:

;ʃ[hύX
	move.w	i_crtmod(aINFO),d1
	IOCS	_CRTMOD
	IOCS	_G_CLR_ON

;ʃ[h\
	lea.l	(str_buffer)r,a0
	movestr	<'testing in mode '>,a1
	jbsr	strcpy
	moveq.l	#0,d0
	move.w	i_crtmod(aINFO),d0
	jbsr	utos
	move.b	#':',(a0)+
	move.b	#' ',(a0)+
	moveq.l	#0,d0
	move.w	i_width(aINFO),d0
	jbsr	utos
	move.b	#'x',(a0)+
	moveq.l	#0,d0
	move.w	i_height(aINFO),d0
	jbsr	utos
	if	<tst.w i_memory(aINFO)>,eq
		movestr	<'/512x512 16-color'>,a1
	elif	<cmpi.w #3,i_memory(aINFO)>,lo
		movestr	<'/512x512 256-color'>,a1
	elif	eq
		movestr	<'/512x512 65536-color'>,a1
	else
		movestr	<'/1024x1024 16-color'>,a1
	endif
	jbsr	strcpy
	if	<tst.w i_interlaced(aINFO)>,eq
		movestr	<' progressive'>,a1
	else
		movestr	<' interlaced'>,a1
	endif
	jbsr	strcpy
	jbsr	crlf
	lea.l	(str_buffer)r,a0
	jbsr	print

;0.5b҂
	moveq.l	#30-1,d0
	for	d0
		bsr	wait_vdisp_0
		bsr	wait_vdisp_1
	next

;OtBbNy[W̗D揇ʂύX
;	y[W02ւ2>1>0>3ɂ
;	NAɉeȂ
;		     SP TX GR G4 G3 G2 G1
	move.w	#%00_00_01_10_11_00_01_10,VICON_PRIORITY

;XN[ʒũ[v
	moveq.l	#0,dSCROLL		;XN[ʒu̔ԍB0=(0,0),1=(-1,0),2=(0,-1),3=(-1,-1)
	do
		move.w	(specified_scroll)r,d0	;w肳ꂽXN[ʒu̔ԍ
		ifor	<>,mi,<cmp.w dSCROLL,d0>,eq	;all܂͈v
			bsr	test_scroll		;XN[ʒũeXg
		endif
		addq.w	#1,dSCROLL		;̃XN[ʒu̔ԍ
	while	<cmp.w #4,dSCROLL>,lo

	rts


;XN[ʒũeXg
;<dSCROLL.w:XN[ʒu̔ԍB0`3
;<aINFO.l:ʃ[h̏
test_scroll:

;XN[ʒu߂
	move.w	dSCROLL,dSCRLY		;dSCRLY 0  1  2  3
	lsr.w	#1,dSCRLY		;dSCRLY 0  0  1  1
					;     x 0  1  0  1
	subx.w	dSCRLX,dSCRLX		;dSCRLX 0 -1  0 -1
	neg.w	dSCRLY			;dSCRLY 0  0 -1 -1
	and.w	#1023,dSCRLX
	and.w	#1023,dSCRLY
;<dSCRLX.w:X̃XN[ʒu
;<dSCRLY.w:ỸXN[ʒu

;XN[ʒu\
	lea.l	(str_buffer)r,a0
	movestr	<'scroll to '>,a1
	jbsr	strcpy
	moveq.l	#0,d0
	move.w	dSCRLX,d0
	jbsr	utos
	move.b	#',',(a0)+
	moveq.l	#0,d0
	move.w	dSCRLY,d0
	jbsr	utos
	jbsr	crlf
	lea.l	(str_buffer)r,a0
	jbsr	print

;XN[ʒuݒ肷
;	y[W0ȊO͍NAɉeȂ
	move.w	dSCRLX,d0
	move.w	dSCRLY,d1
	move.w	d0,CRTC_GRAPHIC_X_0	;y[W0
	move.w	d1,CRTC_GRAPHIC_Y_0
	not.b	d0
	not.b	d1
	move.w	d0,CRTC_GRAPHIC_X_1	;y[W1
	move.w	d1,CRTC_GRAPHIC_Y_1
	not.w	d0
	not.w	d1
	move.w	d0,CRTC_GRAPHIC_X_2	;y[W2
	move.w	d1,CRTC_GRAPHIC_Y_2
	not.b	d0
	not.b	d1
	move.w	d0,CRTC_GRAPHIC_X_3	;y[W3
	move.w	d1,CRTC_GRAPHIC_Y_3

;[h̃eXg
	move.w	i_memory(aINFO),d0	;[h
	if	eq			;[h0
		bsr	test_body_0
	elif	<subq.w #3,d0>,lo	;[h1
		bsr	test_body_1
	elif	eq			;[h3
		bsr	test_body_3
	else				;[h4
		bsr	test_body_4
	endif

	rts


;[h0̃eXg
;	ʃTCY512x512A16FA4y[W
;<dSCRLX.w:X̃XN[ʒu
;<dSCRLY.w:ỸXN[ʒu
;<aINFO.l:ʃ[h̏
test_body_0:

;ʂhׂ
	move.l	#PAINTED<<16|PAINTED,d3
	lea.l	$00C00000,a0
	moveq.l	#4-1,d2
	for	d2
		move.l	#$F<<16|$F,d0
		and.l	d3,d0
		moveq.l	#-1,d1			;512*512/4-1=65535
		for	d1
			move.l	d0,(a0)+
			move.l	d0,(a0)+
		next
		lsr.l	#4,d3
	next

;NAs
	bsr	rapid_clear

;y[W̃[v
	moveq.l	#0,dPAGE		;y[WB0,1,2,3
	do
	;<dPAGE.w:y[W

	;pbgpӂ
		move.w	#PAINTED,d0
		move.w	#CLEARED,d1
		move.w	dPAGE,d2
		lsl.w	#2,d2
		lsr.w	d2,d0
		lsr.w	d2,d1
		and.w	#$F,d0
		and.w	#$F,d1
		movea.w	d0,a2
		movea.w	d1,a3
	;<a2.w:hׂꂽpbg
	;<a3.w:NAꂽpbg

	;r̂߂̃C
		bsr	make_line

	;512x512̉ʂr
		bsr	compare_screen_512

		addq.w	#1,dPAGE
	while	<cmp.w	#4,dPAGE>,lo

	rts


;[h1̃eXg
;	ʃTCY512x512A256FA2y[W
;<dSCRLX.w:X̃XN[ʒu
;<dSCRLY.w:ỸXN[ʒu
;<aINFO.l:ʃ[h̏
test_body_1:

;ʂhׂ
	move.l	#PAINTED<<16|PAINTED,d3
	lea.l	$00C00000,a0
	moveq.l	#2-1,d2
	for	d2
		move.l	#$FF<<16|$FF,d0
		and.l	d3,d0
		moveq.l	#-1,d1			;512*512/4-1=65535
		for	d1
			move.l	d0,(a0)+
			move.l	d0,(a0)+
		next
		lsr.l	#8,d3
	next

;NAs
	bsr	rapid_clear

;y[W̃[v
	moveq.l	#0,dPAGE		;y[WB0,1
	do
	;<dPAGE.w:y[W

	;pbgpӂ
		move.w	#PAINTED,d0
		move.w	#CLEARED,d1
		move.w	dPAGE,d2
		lsl.w	#3,d2
		lsr.w	d2,d0
		lsr.w	d2,d1
		and.w	#$FF,d0
		and.w	#$FF,d1
		movea.w	d0,a2
		movea.w	d1,a3
	;<a2.w:hׂꂽpbg
	;<a3.w:NAꂽpbg

	;r̂߂̃C
		bsr	make_line

	;512x512̉ʂr
		bsr	compare_screen_512

		addq.w	#1,dPAGE
	while	<cmp.w	#2,dPAGE>,lo

	rts


;[h3̃eXg
;	ʃTCY512x512A65536FA1y[W
;<dSCRLX.w:X̃XN[ʒu
;<dSCRLY.w:ỸXN[ʒu
;<aINFO.l:ʃ[h̏
test_body_3:

;ʂhׂ
	move.l	#PAINTED<<16|PAINTED,d0
	lea.l	$00C00000,a0
	moveq.l	#-1,d1			;512*512/4-1=65535
	for	d1
		move.l	d0,(a0)+
		move.l	d0,(a0)+
	next

;NAs
	bsr	rapid_clear

;y[W
	moveq.l	#0,dPAGE		;y[WB0
;<dPAGE.w:y[W

;pbgpӂ
	movea.w	#PAINTED,a2
	movea.w	#CLEARED,a3
;<a2.w:hׂꂽpbg
;<a3.w:NAꂽpbg

;r̂߂̃C
	bsr	make_line

;512x512̉ʂr
	bsr	compare_screen_512

	rts


;[h4̃eXg
;	ʃTCY1024x1024A16FA1y[W
;<dSCRLX.w:X̃XN[ʒu
;<dSCRLY.w:ỸXN[ʒu
;<aINFO.l:ʃ[h̏
test_body_4:

;ʂhׂ
	move.l	#(PAINTED&$F)<<16|(PAINTED&$F),d0
	lea.l	$00C00000,a0
	move.l	#1024*1024/4-1,d1
	forlong	d1
		move.l	d0,(a0)+
		move.l	d0,(a0)+
	next

;NAs
	bsr	rapid_clear

;pbgpӂ
	movea.w	#PAINTED&$F,a2
	suba.l	a3,a3
;<a2.w:hׂꂽpbg
;<a3.w:NAꂽpbg

;r̂߂̃C
	bsr	make_line

;1024x1024̉ʂr
	bsr	compare_screen_1024

	rts


;NAs
;<aINFO.l:ʃ[h̏
rapid_clear:
	move.w	CRTC_ACCESS,-(sp)
	move.w	#MASK,CRTC_ACCESS	;ʃTCY512x512̂ƂNA4bity[W̃}XN
	if	<tst.w i_interlaced(aINFO)>,eq	;vObVu
		bsr	wait_vdisp_0
		bsr	wait_vdisp_1
		bsr	check_port_0
		move.w	#$0002,CRTC_ACTION	;\
		bsr	check_port_0
		bsr	wait_vdisp_0
		bsr	check_port_0
		bsr	wait_vdisp_1		;Jn
		bsr	check_port_1
		bsr	wait_vdisp_0
		bsr	check_port_1
		bsr	wait_vdisp_1		;I
		bsr	check_port_0
	else				;C^[[X
		bsr	wait_vdisp_0
		bsr	wait_vdisp_1
		bsr	check_port_0
		move.w	#$0002,CRTC_ACTION	;\
		bsr	check_port_0
		bsr	wait_vdisp_0
		bsr	check_port_0
		bsr	wait_vdisp_1		;Jn(t[)
		moveq.l	#$0002,d0
		and.w	CRTC_ACTION,d0
		if	eq			;JnĂȂBt[
			bsr	wait_vdisp_0
			bsr	check_port_0
			bsr	wait_vdisp_1		;Jn(t[)
		else
			bsr	check_port_1		;킹
		endif
		bsr	check_port_1
		bsr	wait_vdisp_0
		bsr	check_port_1
		bsr	wait_vdisp_1		;Jn(t[)
		bsr	check_port_1
		bsr	wait_vdisp_0
		bsr	check_port_1
		bsr	wait_vdisp_1		;I
		bsr	check_port_0
	endif
	move.w	(sp)+,CRTC_ACCESS
	rts


;r̂߂̃C
;<dSCRLX.w:X̃XN[ʒu
;<a2.w:hׂꂽpbg
;<a3.w:NAꂽpbg
;<aINFO.l:ʃ[h̏
;?d1-d3/a0-a1
make_line:
	move.w	dSCRLX,d2		;X̃XN[ʒu
	and.w	#512-2,d2		;XWJnʒuB
	move.w	i_width(aINFO),d3	;\ʂ̕
	if	<cmp.w #512,d3>,hs
		clr.w	d2
		move.w	#512,d3
	endif
	add.w	d2,d3			;XWIʒu
;<d2.w:XWJnʒuB0`510
;<d3.w:XWIʒuB0`1022
	lea.l	(line_painted)r,a0		;hׂꂽԂ̃Cobt@
	lea.l	(line_cleared)r,a1		;NAꂽԂ̃Cobt@
	moveq.l	#0,d1			;XW
	if	<cmp.w #512,d3>,ls	;512ׂȂƂ
	;0	d2	d3	512
	;.......********........
		docontinue
			move.w	a2,(a0)+
			move.w	a2,(a1)+
			addq.w	#1,d1
		while	<cmp.w d2,d1>,lo
		docontinue
			move.w	a2,(a0)+
			move.w	a3,(a1)+
			addq.w	#1,d1
		while	<cmp.w d3,d1>,lo
		docontinue
			move.w	a2,(a0)+
			move.w	a2,(a1)+
			addq.w	#1,d1
		while	<cmp.w #512,d1>,lo
	else				;512ׂƂ
		sub.w	#512,d3
	;0	d3	d2	512
	;*******........********
		docontinue
			move.w	a2,(a0)+
			move.w	a3,(a1)+
			addq.w	#1,d1
		while	<cmp.w d3,d1>,lo
		docontinue
			move.w	a2,(a0)+
			move.w	a2,(a1)+
			addq.w	#1,d1
		while	<cmp.w d2,d1>,lo
		docontinue
			move.w	a2,(a0)+
			move.w	a3,(a1)+
			addq.w	#1,d1
		while	<cmp.w #512,d1>,lo
	endif
	rts


;512x512̉ʂr
;<dPAGE.w:y[W
;<dSCRLY.w:ỸXN[ʒu
;<aINFO.l:ʃ[h̏
;?d0-d3/a0-a1
compare_screen_512:
	move.w	dSCRLY,d2		;ỸXN[ʒu
	and.w	#511,d2			;YWJnʒu
	move.w	i_height(aINFO),d3	;\ʂ̍
	if	<cmp.w #512,d3>,hs
		clr.w	d2
		move.w	#512,d3
	endif
	add.w	d2,d3			;YWIʒu
;<d2.w:YWJnʒuB0`511
;<d3.w:YWIʒuB0`1023
	moveq.l	#$00C00000>>19,d0
	add.w	dPAGE,d0		;y[W
	lsl.w	#3,d0
	swap.w	d0			;$00C00000+2*512*512*y[Wԍ
	movea.l	d0,a0			;y[W̐擪
	moveq.l	#0,d1			;YW
	if	<cmp.w #512,d3>,ls	;512ׂȂƂ
	;0	d2	d3	512
	;.......********........
		docontinue
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w d2,d1>,lo
		docontinue
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w d3,d1>,lo
		docontinue
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w #512,d1>,lo
	else				;512ׂƂ
		sub.w	#512,d3
	;0	d3	d2	512
	;*******........********
		docontinue
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w d3,d1>,lo
		docontinue
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w d2,d1>,lo
		docontinue
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w #512,d1>,lo
	endif
	rts


;1024x1024̉ʂr
;<dSCRLY.w:ỸXN[ʒu
;<aINFO.l:ʃ[h̏
;?d0-d3/a0-a1
compare_screen_1024:
	move.w	dSCRLY,d2		;ỸXN[ʒu
	and.w	#1023,d2		;YWJnʒu
	move.w	i_height(aINFO),d3	;\ʂ̍
	add.w	d2,d3			;YWIʒu
;<d2.w:YWJnʒuB0`1023
;<d3.w:YWIʒuB0`2047
	lea.l	$00C00000,a0
	moveq.l	#0,d1			;YW
	if	<cmp.w #1024,d3>,ls	;1024ׂȂƂ
	;0	d2	d3	1024
	;.......********........
		docontinue
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w d2,d1>,lo
		docontinue
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w d3,d1>,lo
		docontinue
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w #1024,d1>,lo
	else				;1024ׂƂ
		sub.w	#1024,d3
	;0	d3	d2	1024
	;*******........********
		docontinue
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w d3,d1>,lo
		docontinue
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			lea.l	(line_painted)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w d2,d1>,lo
		docontinue
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			lea.l	(line_cleared)r,a1
			bsr	compare_line		;Cr
			addq.w	#1,d1
		while	<cmp.w #1024,d1>,lo
	endif
	rts


;Cr
;<a0.l:VRAM̃C̐擪
;<a1.l:Cobt@̐擪
;>a0.l:VRAM̃C̖
;>a1.l:Cobt@̖
;?d0
compare_line:
	move.w	#512-1,d0
	for	d0
		cmpm.w	(a0)+,(a1)+
		if	eq
			addq.l	#1,(area_passed)r
		endif
		addq.l	#1,(area_tested)r
	next
	rts


;䗦̕
;	sprintf(str,"%d%% (%d/%d)",100*num/den,num,den)
;<d0.l:numBnum<=den
;<d1.l:denB0<den
;<a0.l:str
;>a0.l:str
;?d0-d1
ratio:
	move.l	d1,-(sp)
	move.l	d0,-(sp)
	docontinue
		lsr.l	#1,d0
		lsr.l	#1,d1
	while	<cmp.l #$0000FFFF,d1>,hi
	mulu.w	#100,d0
	divu.w	d1,d0
	and.l	#$0000FFFF,d0
	jbsr	utos
	move.b	#'%',(a0)+
	move.b	#' ',(a0)+
	move.b	#'(',(a0)+
	move.l	(sp)+,d0
	jbsr	utos
	move.b	#'/',(a0)+
	move.l	(sp)+,d0
	jbsr	utos
	move.b	#')',(a0)+
	clr.b	(a0)
	rts


;VDISP=0҂
wait_vdisp_0:
	do
	while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,ne
	rts


;VDISP=1҂
wait_vdisp_1:
	do
	while	<btst.b #MFP_G_VDISP_BIT,MFP_GPDR>,eq
	rts


;|[gbit10ł邱ƂmF
;?d0
check_port_0:
	moveq.l	#$0002,d0
	and.w	CRTC_ACTION,d0
	if	eq
		addq.l	#1,(port_passed)r
	endif
	addq.l	#1,(port_tested)r
	rts


;|[gbit11ł邱ƂmF
;?d0
check_port_1:
	moveq.l	#$0002,d0
	and.w	CRTC_ACTION,d0
	if	ne
		addq.l	#1,(port_passed)r
	endif
	addq.l	#1,(port_tested)r
	rts


;ʃ[h̏̔z
	.offset	0
i_crtmod:	.ds.w	1		;ʃ[h
i_width:	.ds.w	1		;\ʂ̕
i_height:	.ds.w	1		;\ʂ̍
i_memory:	.ds.w	1		;[hB0,1,3,4
i_interlaced:	.ds.w	1		;0=vObVu,1=C^[[X
i_sizeof:
	.text
info_array:
	.dc.w	0,512,512,4,0
	.dc.w	1,512,480,4,1
	.dc.w	2,256,256,4,0
	.dc.w	3,256,240,4,0
	.dc.w	4,512,512,0,0
	.dc.w	5,512,480,0,1
	.dc.w	6,256,256,0,0
	.dc.w	7,256,240,0,0
	.dc.w	8,512,512,1,0
	.dc.w	9,512,480,1,1
	.dc.w	10,256,256,1,0
	.dc.w	11,256,240,1,0
	.dc.w	12,512,512,3,0
	.dc.w	13,512,480,3,1
	.dc.w	14,256,256,3,0
	.dc.w	15,256,240,3,0
	.dc.w	16,768,512,4,0
	.dc.w	17,1024,424,4,0
	.dc.w	18,1024,848,4,1
;	.dc.w	19,640,480,4,0		;Compactȍ~
	.dc.w	-1


	.bss
	.even
specified_mode:
	.ds.w	1			;w肳ꂽʃ[hB-1=all,0`18=ʃ[h
specified_scroll:
	.ds.w	1			;w肳ꂽXN[ʒu̔ԍB-2=wȂ,-1=all,0`3=XN[ʒu̔ԍ
area_passed:
	.ds.l	1			;GAeXg̒ʉߐ
area_tested:
	.ds.l	1			;GAeXg̑
port_passed:
	.ds.l	1			;|[geXg̒ʉߐ
port_tested:
	.ds.l	1			;|[geXg̑
abort_sp:
	.ds.l	1			;A{[g𕜌Ƃsp
line_painted:
	.ds.w	512			;hׂꂽԂ̃Cobt@
line_cleared:
	.ds.w	512			;NAꂽԂ̃Cobt@
str_buffer:
	.ds.b	256			;obt@
	.ds.b	65536			;X^bNGA
stack_tail:



	.text

;----------------------------------------------------------------
;Rs[
;	󔒂ǂݔ΂Ă玟̋󔒂̎O܂ŃRs[
;	"`"܂'`'ň͂ނƈɋ󔒂܂߂邱Ƃł
;	""܂''Əƒ0̈^邱Ƃł
;<a0.l:Rs[̃obt@̐擪
;<a1.l:Rs[̐̕擪
;>d0.l:0=Ȃ,1=
;>a0.l:Rs[̖̕0̈ʒu
;>a1.l:Rs[̈̒BȂ΃Rs[̖̕0̈ʒu
;>eq=Ȃ,ne=
argcpy::
	exg.l	a0,a1
	jbsr	nextword		;󔒂ǂݔ΂
	exg.l	a0,a1
	if	eq			;Ȃ
		clr.b	(a0)
		moveq.l	#0,d0
		rts
	endif
	dostart
		if	<cmp.b #'"',d0>,eq	;"`"
			dostart
				move.b	d0,(a0)+		;
			start
				move.b	(a1)+,d0		;̕
				break2	eq			;I
			while	<cmp.b #'"',d0>,ne
		elif	<cmp.b #39,d0>,eq	;'`'
			dostart
				move.b	d0,(a0)+		;
			start
				move.b	(a1)+,d0		;̕
				break2	eq			;I
			while	<cmp.b #$39,d0>,ne
		else
			move.b	d0,(a0)+		;
		endif
	start
		move.b	(a1)+,d0		;̕
		break	eq			;I
		breakand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\rȂΏI
	while	<cmp.b #' ',d0>,ne	;󔒂łȂΌJԂ
	subq.l	#1,a1			;i݉߂߂
	clr.b	(a0)
	moveq.l	#1,d0
	rts

;----------------------------------------------------------------
;sRs[
;<a0.l:Rs[
;>a0.l:Rs[0̈ʒu
crlf::
	move.b	#13,(a0)+
	move.b	#10,(a0)+
	clr.b	(a0)
	rts

;----------------------------------------------------------------
;󔒕 \s
;<d0.b:
;>z:eq=󔒕,ne=󔒕ł͂Ȃ(0܂)
isspace::
	if	<cmp.b #' ',d0>,ne
		ifand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\r
			cmp.b	d0,d0
		endif
	endif
	rts

;----------------------------------------------------------------
;󔒂ǂݔ΂
;<a0.l:
;>d0.l:ŏ̋󔒈ȊO̕܂0
;>a0.l:ŏ̋󔒈ȊO̕܂0̈ʒu
;>z:ne=󔒈ȊO̕,eq=󔒈ȊO̕Ȃ
nextword::
	moveq.l	#0,d0
	do
		move.b	(a0)+,d0		;̕
		break	eq			;0ȂΏI
		jbsr	isspace			;󔒂
	while	eq			;󔒂ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	tst.l	d0
	rts

;----------------------------------------------------------------
;\
;<a0.l:
print::
	push	d0
	jbsr	strlen
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	(10,sp),sp
	pop
	rts

;----------------------------------------------------------------
;10i̕𕄍Ȃɕϊ
;<a0.l:10i̕B擪̋󔒂͔F߂Ȃ
;>d0.l:(cĉƂ)ȂB(cŝƂ)0=10i̕Ȃ,-1=I[o[t[
;>a0.l:(cĉƂ)10i̎̈̕ʒuB(cŝƂ)ωȂ
;>z:(cĉƂ)eq=Ȃ0
;>v:(cŝƂ)vc=10i̕Ȃ,vs=I[o[t[
;>c:cs=10i̕Ȃ܂̓I[o[t[
stou::
	push	d1-d2/a1
	moveq.l	#0,d0			;Ȃ
	moveq.l	#0,d1			;
	movea.l	a0,a1			;Jnʒu
	dostart
		goto	<cmp.l #$1999999A,d0>,hs,20f	;10{I[o[t[
		move.l	d0,d2			;1{
		lsl.l	#2,d0			;4{
		add.l	d2,d0			;5{
		add.l	d0,d0			;10{
		add.l	d1,d0			;1
		goto	cs,20f			;I[o[t[
	start
		move.b	(a0)+,d1		;̕
		sub.b	#'0',d1			;ɂ
	whileand	<>,hs,<cmp.b #10,d1>,lo	;10i̕ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	goto	<cmpa.l a1,a0>,eq,30f	;iłȂB10i̕Ȃ
	tst.l	d0			;ne/eq,vc,cc
10:	pop
	rts

;I[o[t[
20:
  .if 0
	do
		move.b	(a0)+,d1		;̕
		sub.b	#'0',d1			;ɂ
	whileand	<>,hs,<cmp.b #10,d1>,lo	;10i̕ǂݔ΂
	subq.l	#1,a0			;i݉߂߂
  .else
	movea.l	a1,a0			;Jnʒuɖ߂
  .endif
	moveq.l	#-1,d0			;I[o[t[
	move.w	#%00011,ccr		;ne,vs,cs
	goto	10b

;10i̕Ȃ
30:
;	moveq.l	#0,d0			;10i̕Ȃ
	move.w	#%00101,ccr		;eq,vc,cs
	goto	10b

;----------------------------------------------------------------
;Rs[
;<a0.l:Rs[
;<a1.l:Rs[
;>a0.l:Rs[0̈ʒu
;>a1.l:Rs[0̎̈ʒu
strcpy::
	do
		move.b	(a1)+,(a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	rts

;----------------------------------------------------------------
;Ȃ當r
;	'['<'A'ƂȂ邱ƂɒӁBSJIS͐rłȂƂɒ
;<a0.l:0B
;<a1.l:1B
;>ccr:eq=0==1,lo=0<1,hi=1<0
stricmp::
	push	d0-d1/a0-a1
	do
		move.b	(a0)+,d0
		if	eq
			cmp.b	(a1)+,d0
			break
		endif
		move.b	(a1)+,d1
		ifand	<cmp.b #'A',d0>,hs,<cmp.b #'Z',d0>,ls
			or.b	#$20,d0
		endif
		ifand	<cmp.b #'A',d1>,hs,<cmp.b #'Z',d1>,ls
			or.b	#$20,d1
		endif
		cmp.b	d1,d0
	while	eq
	pop
	rts

;----------------------------------------------------------------
;̒𐔂
;<a0.l:
;>d0.l:
strlen::
	move.l	a0,d0			;d0=擪
	do
		tst.b (a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂Ba0=
	exg.l	d0,a0			;d0=,a0=擪
	sub.l	a0,d0			;d0=-擪=
	rts

;----------------------------------------------------------------
;32rbgȂ10i̕ɕϊ
;<d0.l:Ȃ
;<a0.l:obt@B10i̐̕擪
;>a0.l:10i̖̕0̈ʒu
utos::
	if	<tst.l d0>,eq		;0
		move.b	#'0',(a0)+
	else				;0ȊO
		push	d0-d2/a1
		lea.l	utos_table(pc),a1
		do
			move.l	(a1)+,d1
		while	<cmp.l d1,d0>,lo	;Ƃ܂ŐiށB[TvX
		do
			moveq.l	#'0'-1,d2
			do
				addq.b	#1,d2
				sub.l	d1,d0
			while	hs			;񐔂𐔂
			move.b	d2,(a0)+
			add.l	d1,d0			;߂߂
			move.l	(a1)+,d1
		while	ne
		pop
	endif
	clr.b	(a0)
	rts

utos_table::
	.dc.l	1000000000
	.dc.l	100000000
	.dc.l	10000000
	.dc.l	1000000
	.dc.l	100000
	.dc.l	10000
	.dc.l	1000
	.dc.l	100
	.dc.l	10
	.dc.l	1
	.dc.l	0

