;========================================================================================
;  rom16pat.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;
;	rom16pat.x
;		IPLROM 1.3IPLROM 1.6邽߂̃pb`f[^
;
;	ŏIXV
;		2025-08-03
;
;	
;		has060 -i include -o rom16pat.o -w rom16pat.s
;		lk -b fea000 -o rom16pat.x rom16pat.o
;
;	SASI IOCS
;		IPLROM 1.2SASI IOCS͈̔͂$00FF95B6`$00FF9E7D(2248oCg)
;		IPLROM 1.3SCSI IOCS͈̔͂$00FFCCB8`$00FFDCE3(4140oCg)
;		IPLROM 1.3SCSI IOCS̏ꏊIPLROM 1.2SASI IOCSRs[Ă炱̃pb`Kp
;
;	6x12tHg
;		IPLROM 1.26x12 ANKtHg͈̔͂$00FFD45E`$00FFE045(3048oCg)
;		IPLROM 1.66x12 ANKtHg͈̔͂$00FEF400`$00FEFFFF(3072oCg)
;		Rs[āA24oCg$00ŏ[U
;
;	SHARPS
;		X68000S傫ł悤SHARPS
;		$00FF138C`$00FF144F(196oCg)
;		$00FFD680`$00FFD743(196oCg)ֈړ
;		$00FFD580`$00FFD67F(256oCg)SASI IOCS̃pb`pɋ󂯂Ă
;
;----------------------------------------------------------------

	.include	bioswork.equ
	.include	control2.mac
	.include	crtc.equ
	.include	dmac.equ
	.include	dosconst.equ
	.include	hdc.equ
	.include	iocscall.mac
	.include	key.equ
	.include	mfp.equ
	.include	misc.mac
	.include	ppi.equ
	.include	push2.mac
	.include	rtc.equ
	.include	scsicall.mac
	.include	spc.equ
	.include	sprc.equ
	.include	sram.equ
	.include	sysport.equ
	.include	vector.equ
	.include	vicon.equ

	.include	patch.mac



VERSION_NUMBER	equ	$16_250803	;o[WƓt
VERSION_STRING	reg	'1.6 (2025-08-03)'
CRTMOD_VERSION	equ	$16_250629	;_CRTMOD̃o[W

TEXT_START	equ	$00FEA000	;eLXgZNV̐擪
TEXT_END	equ	$00FEF3FF	;eLXgZNV̖

REMOVE_CRTMOD_G_CLR_ON	equ	0	;1=_CRTMOD_G_CLR_ONO
USE_PROPORTIONAL_IOCS	equ	0	;1=IOCSŃv|[VitHgg



;----------------------------------------------------------------
;
;	pb`f[^̐擪
;
;----------------------------------------------------------------

	PATCH_START	TEXT_START,TEXT_END

	.cpu	68000



;----------------------------------------------------------------
;	_ROMVER
;		00FF0030 203C13921127           move.l	#$13921127,d0
;		00FF0036
;----------------------------------------------------------------
	PATCH_DATA	iocs_romver,$00FF0030,$00FF0035,$203C1392
	move.l	#VERSION_NUMBER,d0
	PATCH_TEXT
	.dc.b	'XEiJ IPLROM ',VERSION_STRING,13,10
	.dc.b	'CAUTION: Distribution is prohibited.',13,10
	.dc.b	26,0

;----------------------------------------------------------------
;bZ[W̃X^C
;	bit0	0=m[}sb`,1=v|[Visb`
;	bit1	0=,1=
;	bit2	0=ԂȂ,1=Ԃ
message_style::
	.dc.b	7
	.even



;----------------------------------------------------------------
;	䃌WX^̏MPU/MMU/FPŨ`FbN
;		Tu[`AhXϊ𖳌ɂƃX^bNGAړĖ߂ĂȂȂ̂jsrł͂Ȃjmpg
;		00FF005A 61000CE2               bsr.w	$00FF0D3E		;MPU,MMU,FPU/FPCP`FbN
;		00FF005E 2E00                   move.l	d0,d7
;		00FF0060 4A07                   tst.b	d7
;		00FF0062 6710                   beq.s	$00FF0074		;68000
;		00FF0064 7000                   moveq.l	#$00,d0
;		00FF0066 4E7B0801               movec.l	d0,vbr
;		00FF006A 0C070001               cmpi.b	#$01,d7
;		00FF006E 6704                   beq.s	$00FF0074		;68010
;		00FF0070 4E7B0002               movec.l	d0,cacr			;LbVOFF
;		00FF0074
;----------------------------------------------------------------
	PATCH_DATA	mpu_check,$00FF005A,$00FF0073,$61000CE2
	jmp	mpu_check
	PATCH_TEXT
;----------------------------------------------------------------
;MPU`FbN
;	NɊ荞݋֎~AX^bNgp̏ԂŃWvĂ
;	IPLROM 1.3TRAP#10̓zbgX^[gƂMMŨAhXϊ̏ԂmF$00FF0038ɃWvĂ
;	060turbo.sysTRAP#10tbNĂ̂ŃzbgX^[gꍇAhXϊ͊ɖĂ͂A
;	Ô߃AhXϊLɂȂĂꍇl
;	ROM̃R[h͕ωȂ̂ŖȂA
;	xN^e[uƃX^bNGAƃ[NGA̓e̓AhXϊ𖳌ɂuԂɎ
;	zbgX^[gX^bNGA⃏[NGAgOɃAhXϊ𖳌ɂȂ΂ȂȂ
;<d5.l:0=R[hX^[g(d0d1!='HotStart'),-1=zbgX^[g(d0d1=='HotStart')
;<d6.l:G~[^荞݃xN^([OFFSET_EMULATOR_INTERRUPT.w].l)&$00FFFFFFBR[hX^[ĝƂ`O[`wĂȂΓdONAwĂ΃Zbg
;>d7.l:MPU̎ނFPU/FPCP̗LMMU̗L
;	bit31	MMU̗LB0=Ȃ,1=
;	bit15	FPU/FPCP̗LB0=Ȃ,1=
;	bit7-0	MPU̎ށB0=68000,1=68010,2=68020,3=68030,4=68040,6=68060
;?d0/a1
mpu_check:
	movea.l	sp,a1

;----------------------------------------------------------------
;MOVEC to VBR(-12346)ȂMC68000
;	MC68000ǂ̃eXgVBR̃NA𓯎ɍs
;	sߗOxN^$0010.wɂ̂MC68000̏ꍇMC68010ȏVBR0̏ꍇ
;	MC68010ȏVBR0łȂƂ$0010.wĂsߗO𑨂Ȃ̂ŁA
;	MC68010ȏ̂Ƃ͍ŏVBRNAKv
;	VBRNA閽߂MC68000ŕs߂Ȃ̂MC68000ǂ̃eXg˂
	lea.l	dummy_trap(pc),a0
	move.l	a0,OFFSET_ILLEGAL_INSTRUCTION.w	;OxN^$04 s
	lea.l	mpu_check_done(pc),a0
	moveq.l	#0,d7			;MC68000
	moveq.l	#0,d0
	.cpu	68010
	movec.l	d0,vbr
	.cpu	68000
	lea.l	dummy_trap(pc),a0
	move.l	a0,OFFSET_ILLEGAL_INSTRUCTION.w	;OxN^$04 s
	move.l	a0,OFFSET_LINE_1111_EMULATOR.w	;OxN^$0B C1111G~[^

;----------------------------------------------------------------
;MOVEC to VBR(-12346)ăXP[t@N^(--2346)ȂMC68010
	moveq.l	#1,d7			;MC68010
@@:	moveq.l	#1,d0			;$70,$01
	.cpu	68020
	and.b	(@b-1,pc,d0.w*2),d0	;XP[t@N^Ȃ(([@b-1+1].b==$70)&1)==0,XP[t@N^(([@b-1+1*2].b=$01)&1)==1
	.cpu	68000
	beq	mpu_check_done

;----------------------------------------------------------------
;CALLM(--2---)MC68020
	.cpu	68020
	lea.l	9f(pc),a0
	callm	#0,1f(pc)
	moveq.l	#2,d7			;MC68020
;		  3  2 1 0
;		  C CE F E
	move.l	#%1__0_0_0,d0
	movec.l	d0,cacr			;߃LbVNAA߃LbVOFF
	lea.l	@f(pc),a0
	fnop
	bset.l	#15,d7			;FPU
@@:
;MC68851̃`FbN͏ȗ
	bra	mpu_check_done

;W[fXNv^
1:	.dc.l	%0<<13|0<<24|0<<16	;option=0,type=0,accesslevel=0
	.dc.l	2f			;W[Gg|C^
	.dc.l	0			;W[f[^̈|C^
	.dc.l	0
;W[Gg
2:	.dc.w	15<<12			;Rn=sp
	rtm	sp

9:	movea.l	a1,sp
	.cpu	68000

;----------------------------------------------------------------
;CALLM(--2---)ȂMOVEC from CAAR(--23--)MC68030
	.cpu	68030
	lea.l	9f(pc),a0
	movec.l	caar,d0
	moveq.l	#3,d7			;MC68030
;		   D   C  B   A  9  8 765   4  3   2  1  0
;		  WA DBE CD CED FD ED     IBE CI CEI FI EI
	move.l	#%_0___0__1___0__0__0_000___0__1___0__0__0,d0
	movec.l	d0,cacr			;f[^LbVNAAf[^LbVOFFA߃LbVNAA߃LbVOFF
;		  F ECDBA   9   8 7654 3210 FEDC BA98 7654 3210
;		  E       SRE FCL   PS   IS  TIA  TIB  TIC  TID
	move.l	#%0_00000___0___0_1101_1000_0011_0100_0100_0000,-(sp)
	pmove.l	(sp),tc			;AhXϊOFF
;		  FEDCBA98 76543210 F EDCB  A   9   8 7    654 3    210
;		      BASE     MASK E      CI R/W RWM   FCBASE   FCMASK
	move.l	#%00000000_00000000_0_0000__0___0___0_0____000_0____000,(sp)
	pmove.l	(sp),tt0		;ߕϊOFF
	pmove.l	(sp),tt1
	addq.l	#4,sp
	lea.l	@f(pc),a0
	fnop
	bset.l	#15,d7			;FPU
@@:	bsr	mmu_check_3		;MMU`FbN(MC68030)
	bra	mpu_check_done

9:
	.cpu	68000

;----------------------------------------------------------------
;MOVEC from MMUSR(----4-)MC68040
	.cpu	68040
	lea.l	9f(pc),a0
	movec.l	mmusr,d0
	moveq.l	#4,d7			;MC68040
;		   F EDCBA9876543210  F EDCBA9876543210
;		  DE 000000000000000 IE 000000000000000
	move.l	#%_0_000000000000000__0_000000000000000,d0
	movec.l	d0,cacr			;f[^LbVOFFA߃LbVOFF
	cinva	bc			;f[^LbVNAA߃LbVNA
;		  F E DCBA9876543210
;		  E P 00000000000000
	move.l	#%0_0_00000000000000,d0
	movec.l	d0,tc			;AhXϊ
	pflusha				;AhXϊLbVNA
;		  FEDCBA98 76543210 F     ED CBA  9  8 7 65 43 2 10
;		      BASE     MASK E SFIELD     U1 U0   CM    W
	move.l	#%00000000_00000000_0_____00_000__0__0_0_00_00_0_00,d0
	movec.l	d0,itt0			;ߕϊOFF
	movec.l	d0,itt1
	movec.l	d0,dtt0
	movec.l	d0,dtt1
	lea.l	@f(pc),a0
	fnop
	bset.l	#15,d7			;FPU
@@:	bsr	mmu_check_46		;MMU`FbN(MC68040/MC68060)
	bra	mpu_check_done

9:
	.cpu	68000

;----------------------------------------------------------------
;MOVEC from PCR(-----6)MC68060
	.cpu	68060
	lea.l	9f(pc),a0
	movec.l	pcr,d1
	moveq.l	#6,d7			;MC68060
;		    F   E   D   C   B A98   7    6    5 43210   F   E   D CBA9876543210
;		  EDC NAD ESB DPI FOC     EBC CABC CUBC       EIC NAI FIC
	move.l	#%__0___0___0___0___0_000___1____0____0_00000___0___0___0_0000000000000,d0
	movec.l	d0,cacr			;f[^LbVOFFAXgAobt@OFFALbVONA߃LbVOFF
;	ZbgŃLbV̓NAȂ
;	ZbgꂽLbVLɂOɃLbVNAȂ΂ȂȂ(MC68060UM 5.3)
	cinva	bc			;f[^LbVNAA߃LbVNA
;		  F E   D   C    B    A  98  76   5  43  21 0
;		  E P NAD NAI FOTC FITC DCO DUO DWO DCI DUI
	move.l	#%0_0___0___0____0____0__10__00___0__10__00_0,d0
	movec.l	d0,tc			;AhXϊOFFAf[^LbVOFFvTCX[hA߃LbVOFFvTCX[h
;	ZbgŃAhXϊLbV̓NAȂ
;	ZbgꂽAhXϊLɂOɃAhXϊLbVNAȂ΂ȂȂ(MC68060UM 4.6.1)
	pflusha				;AhXϊLbVNA
;		  FEDCBA98 76543210 F     ED CBA  9  8 7 65 43 2 10
;		      BASE     MASK E SFIELD     U1 U0   CM    W
	move.l	#%00000000_00000000_0_____00_000__0__0_0_00_00_0_00,d0
	movec.l	d0,itt0			;ߕϊOFF
	movec.l	d0,itt1
	movec.l	d0,dtt0
	movec.l	d0,dtt1
;		  FEDCBA9876543210 FEDCBA98      7 65432   1   0
;		  0000010000110000 REVISION EDEBUG       DFP ESS
	move.l	#%0000000000000000_00000000______0_00000___0___1,d0
	movec.l	d0,pcr			;FPU ON,X[p[XJON
	lea.l	@f(pc),a0
	fnop
	bset.l	#15,d7			;FPU
@@:	bsr	mmu_check_46		;MMU`FbN(MC68040/MC68060)
	bra	mpu_check_done

9:
	.cpu	68000

;----------------------------------------------------------------
;s
	moveq.l	#0,d7

;----------------------------------------------------------------
;I
mpu_check_done:
	jmp	$00FF0074

;----------------------------------------------------------------
;_~[̗O
;	a1spɃRs[a0ɃWv
dummy_trap:
	movea.l	a1,sp
	jmp	(a0)

;----------------------------------------------------------------
;MMU`FbN(MC68030)
mmu_check_3:
	.cpu	68030
	lea.l	-128(sp),sp
	movea.l	sp,a0
;		L/U           LIMIT                DT
	move.l	#%0_111111111111111_00000000000000_10,(a0)+
	move.l	sp,d0
	lsr.l	#4,d0
	addq.l	#2,d0
	lsl.l	#4,d0
	move.l	d0,(a0)
;			     CI   M U WP DT
	lea.l	$00000000|%0__0_0_0_0__0_01.w,a0
	movea.l	d0,a1
	moveq.l	#8-1,d0
	for	d0
		move.l	a0,(a1)+
		adda.l	#$00200000,a0
	next
;AhXϊLɂ
;			      CI   M U WP DT
	move.l	#$00F00000|%0__0_0_0_0__0_01,-4*8+4(a1)	;$00200000$00F00000ɕϊ
	pmove.q	(sp),crp
;		  E       SRE FCL   PS   IS  TIA  TIB  TIC  TID
	move.l	#%1_00000___0___0_1101_1000_0011_0100_0100_0000,-(sp)
	pflusha
	pmove.l	(sp),tc
;8KBr
	lea.l	$00F00000,a1
	lea.l	$00200000,a0
	move.w	#2048-1,d0
@@:	cmpm.l	(a1)+,(a0)+
	dbne	d0,@b
	bne	@f
	bset.l	#31,d7			;MMU
@@:
;AhXϊ
	bclr.b	#7,(sp)			;E=0
	pmove.l	(sp),tc			;AhXϊ
	pflusha
	lea.l	4+128(sp),sp
	.cpu	68000
	rts

;----------------------------------------------------------------
;MMU`FbN(MC68040/MC68060)
mmu_check_46:
	.cpu	68040
	lea.l	$2000.w,a1
;[ge[u
;			   U W UDT
	lea.l	512|%00000_0_0__10(a1),a0
	moveq.l	#128-1,d0
	for	d0
		move.l	a0,(a1)+
	next
;|C^e[u
;			   U W UDT
	lea.l	512|%00000_0_0__10(a1),a0
	moveq.l	#128-1,d0
	for	d0
		move.l	a0,(a1)+
	next
;y[We[u
	moveq.l	#32-1,d0
	for	d0
	;			    UR G U1 U0 S CM M U W PDT
		move.l	#$00FF0000|%00_1__0__0_0_10_0_0_0__01,(a1)+
	next
;$80000000`$FFFFFFFF𓧉ߕϊɂ
;		      BASE     MASK E SFIELD     U1 U0   CM    W
	movea.l	#%00000000_01111111_1_____10_000__0__0_0_10_00_0_00,a1
	movec.l	a1,itt0
	movec.l	a1,dtt0
	movec.l	a1,itt1
	movec.l	a1,dtt1
;AhXϊLɂ
	lea.l	$2000.w,a1
	movec.l	a1,srp			;MMUȂĂG[ɂȂȂ(MC68060UM B.2)
	movec.l	a1,urp
;		  E P NAD NAI FOTC FITC DCO DUO DWO DCI DUI
	movea.l	#%1_1___0___0____0____0__00__00___0__00__00_0,a1
	pflusha
	cinva	bc
	movec.l	a1,tc
;8KBr
	lea.l	$80FF0000,a0
	lea.l	$80F00000,a1
	move.w	#2048-1,d0
@@:	cmpm.l	(a0)+,(a1)+
	dbne	d0,@b
	bne	@f
	bset.l	#31,d7			;MMU
@@:
;AhXϊƃgXyAgϊ
	if	<cmp.b #6,d7>,lo	;68040
;			  E P
		movea.l	#%0_0___0___0____0____0__00__00___0__00__00_0,a1
	else				;68060
;			  E P NAD NAI FOTC FITC DCO DUO DWO DCI DUI
		movea.l	#%0_0___0___0____0____0__10__00___0__00__00_0,a1
	endif
	movec.l	a1,tc
	pflusha
	cinva	bc
	suba.l	a1,a1
	movec.l	a1,itt0
	movec.l	a1,dtt0
	movec.l	a1,itt1
	movec.l	a1,dtt1
	.cpu	68000
	rts



;----------------------------------------------------------------
;	`OxN^Ɩ`IOCSR[xN^̃nC΍
;		68060̂Ƃ
;			`OxN^Ɩ`IOCSR[xN^bit281̂ƂxN^ԍ
;				$01xxxxxxɃnCƂ`xN^𓥂ł\Ȃ悤ɂ
;				060turboROMɍ킹ănC̗LɊ֌WȂ68060̂Ƃs
;				TRAP#n($002x)AMFP($004x)AIOI/DMA/SPC($006x)Ȃǂ̓xN^ԍȂ
;				SCC($005x)A_OPMDRV($01F0)Ȃǂ̓xN^ԍ
;			ߗOxN^ݒ肷
;		XvAX荞݃xN^ݒ肷
;	ύXO
;		00FF008E 41FAFF70_00000000	lea.l	$00FF0000(pc),a0
;		00FF0092 2408             	move.l	a0,d2
;		00FF0094
;----------------------------------------------------------------
	PATCH_DATA	p008E,$00FF008E,$00FF0093,$41FAFF70
	jsr	p008E
	PATCH_TEXT
;<d7.l:MPU̎ނFPU/FPCP̗LMMU̗L
;	bit31	MMU̗LB0=Ȃ,1=
;	bit15	FPU/FPCP̗LB0=Ȃ,1=
;	bit7-0	MPU̎ށB0=68000,1=68010,2=68020,3=68030,4=68040,6=68060
;>d6.l:$00FF0000
;?a0-a1
p008E:
	if	<cmpi.b #6,d7>,eq	;68060̂Ƃ
	;`OxN^Ɩ`IOCSR[xN^bit281̂ƂxN^ԍ
	;NMIxN^`ł͂ȂȂ
		suba.l	a0,a0			;OxN^e[u̐擪
		do
			if	<btst.b #4,(a0)>,ne	;bit281̂Ƃ
				clr.b	(a0)			;xN^ԍ
			endif
			addq.l	#4,a0
		while	<cmpa.w	#$0800,a0>,lo	;IOCSR[xN^e[u̖܂
	;ߗOxN^ݒ肷
		lea.l	uii(pc),a1		;ߗO[`
		move.l	a1,OFFSET_INTEGER_INSTRUCTION.w	;OxN^$3D 
	endif
;XvAX荞݃xN^ݒ肷
	lea.l	uii_rte(pc),a1		;ߗO[`rte
	move.l	a1,OFFSET_SPURIOUS_INTERRUPT.w	;OxN^$18 XvAX荞
;IOCSR[xN^̐ݒɖ߂
	move.l	#$00FF0000,d2
	rts

;----------------------------------------------------------------
;ߗO[`
	.cpu	68060
uii:
	pea.l	(8,sp)			;Ossp
	movem.l	d0-d7/a0-a6,-(sp)
	moveq.l	#5,d2			;X[p[oCUf[^ANZX̃t@NVR[h
	btst.b	#5,(4*16,sp)		;OsrS
	bne	1f			;X[p[oCU[h
;[U[h
	moveq.l	#1,d2			;[Uf[^ANZX̃t@NVR[h
	move.l	usp,a0			;Ousp
	move.l	a0,(4*15,sp)		;Osp
;߃R[hǂݎ
1:	movea.l	(4*16+2,sp),a0		;a0=Opc
	move.w	(a0)+,d1		;d1=߃R[h,a1=pc+2
;MOVEPǂׂ
	move.w	d1,d0
;		  0000qqq1ws001rrr
	and.w	#%1111000100111000,d0
	cmp.w	#%0000000100001000,d0
	beq	2f			;MOVEP
;MOVEPȊO
	movem.l	(sp),d0-d2		;d0/d1/d2𕜌
	movea.l	(4*8,sp),a0		;a0𕜌
	lea.l	(4*16,sp),sp		;j󂳂ĂȂWX^̕ȗ
	jmp	$00FF0770		;`O

;MOVEP
;AhX߂
2:	moveq.l	#7,d0			;d0=0000000000000111
	and.w	d1,d0			;d0=0000000000000rrr
	movea.l	(4*8,sp,d0.w*4),a1	;a1=Ar
	adda.w	(a0)+,a1		;a0=pc+4,a1=d16+Ar=AhX
;AAhXXV
	move.l	a0,(4*16+2,sp)		;pc=pc+4
;Dq̃AhX߂
	move.w	d1,d0			;d0=0000qqq1ws001rrr
	lsr.w	#8,d0			;d0=000000000000qqq1
	lea.l	(-2,sp,d0.w*2),a0	;d0*2=00000000000qqq10,a0=Dq̃AhX
;[h/Cg,[h/Oŕ򂷂
	add.b	d1,d1			;c=w,d1=s001rrr0
	bcs	5f			;Cg
;[h
	movec.l	sfc,d1			;t@NVR[hۑ
	movec.l	d2,sfc			;t@NVR[hύX
	bmi	3f			;[hO
;[h[h
;MOVEP.W (d16,Ar),Dq
	moves.b	(a1),d0			;ʃoCg[h
	lsl.w	#8,d0
	moves.b	(2,a1),d0		;牺ʃoCg[h
	move.w	d0,(2,a0)		;f[^WX^̉ʃ[hփCg
	bra	4f

;[hO
;MOVEP.L (d16,Ar),Dq
3:	moves.b	(a1),d0			;ʃ[h̏ʃoCg[h
	lsl.l	#8,d0
	moves.b	(2,a1),d0		;ʃ[h̉ʃoCg[h
	lsl.l	#8,d0
	moves.b	(4,a1),d0		;牺ʃ[h̏ʃoCg[h
	lsl.l	#8,d0
	moves.b	(6,a1),d0		;牺ʃ[h̉ʃoCg[h
	move.l	d0,(a0)			;f[^WX^փCg
4:	movec.l	d1,sfc			;t@NVR[h𕜌
	movem.l	(sp),d0-d7		;f[^WX^̂ǂꂩ1XVĂ
	bra	8f

;Cg
5:	movec.l	dfc,d1			;t@NVR[hۑ
	movec.l	d2,dfc			;t@NVR[hύX
	bmi	6f			;CgO
;Ch[h
;MOVEP.W Dq,(d16,Ar)
	move.w	(2,a0),d0		;f[^WX^̉ʃ[h烊[h
	rol.w	#8,d0
	moves.b	d0,(a1)			;֏ʃoCgCg
	rol.w	#8,d0
	moves.b	d0,(2,a1)		;։ʃoCgCg
	bra	7f

;CgO
;MOVEP.L Dq,(d16,Ar)
6:	move.l	(a0),d0			;f[^WX^烊[h
	rol.l	#8,d0
	moves.b	d0,(a1)			;֏ʃ[h̏ʃoCgCg
	rol.l	#8,d0
	moves.b	d0,(2,a1)		;֏ʃ[h̉ʃoCgCg
	rol.l	#8,d0
	moves.b	d0,(4,a1)		;։ʃ[h̏ʃoCgCg
	rol.l	#8,d0
	moves.b	d0,(6,a1)		;։ʃ[h̉ʃoCgCg
7:	movec.l	d1,dfc			;t@NVR[h𕜌
	movem.l	(sp),d0-d2		;d0/d1/d2𕜌
8:	movem.l	(4*8,sp),a0-a1		;a0/a1𕜌
	lea.l	(4*16,sp),sp		;j󂳂ĂȂWX^̕ȗ
	tst.b	(sp)			;OsrT
	bpl	9f			;g[XȂ
;g[X
	ori.w	#$8000,sr		;RTȆOsrTZbgMOVEPg[X悤ɐU镑
9:
;ߗO[`rte
uii_rte:
	rte

	.cpu	68000



;----------------------------------------------------------------
;	IOCS $F5xN^̐ݒ
;		000000C4 2039(01)0000934E 	move.l	device_installer_parameter,d0	;ROMN[`-12 SCSIfoCXhCogݍ݃[`̃p[^
;		000000CA 21C007D4         	move.l	d0,4*($100+_SCSIDRV).w	;IOCSR[$F5 _SCSIDRV
;		폜BSCSI@̂Ƃscsi_init_routineŐݒ肷̂ł͍폜
;----------------------------------------------------------------
	PATCH_DATA	p00C4,$00FF00C4,$00FF00C4+9,$203900FF
	bra.s	(*)-$00C4+$00CE



;----------------------------------------------------------------
;	SRAM̏
;		SRAMƂC̃TCY𓋍ڂĂTCYɍ킹
;		SASI@̂ƂAROMNnh$00E80400ɁAn[hfBXN̑䐔1ɂ
;		SCSI@̂ƂAROMNnh$00FC0000ɁAn[hfBXN̑䐔0ɂ
;			ROMNnhW$00BFFFFCɂƃC12MBɑ݂Ƃɓ삵ȂȂ
;			$00E80400ׂ͂Ă̋@ŃoXG[ɂȂ͂
;		TCY̔ʂSASI@SCSI@̔ʂōs
;	ύXO
;		000000CE 41F900ED0000     	lea.l	SRAM_MAGIC,a0
;			:
;		0000010C*423900E8E00D     	locksram			;SRAM݋֎~
;----------------------------------------------------------------
	PATCH_DATA	p00ce,$00FF00CE,$00FF0111,$41F900ED
	jsr	p00ce
	bra.s	(*)-$00D4+$0112
	PATCH_TEXT
p00ce:
	bsr	check_memory_size
	bsr	check_hard_disk_interface
	bsr	check_sram
	rts

;C̃TCYmF
check_memory_size:
	push	d2-d3/a2/a5
	suba.l	a2,a2
	move.l	#$55AAAA55,d3		;eXgf[^
	di				;srۑA荞݋֎~
	move.l	OFFSET_BUS_ERROR.w,-(sp)	;oXG[xN^ۑ
	movea.l	sp,a5			;spۑ
	move.l	#@f,OFFSET_BUS_ERROR.w	;oXG[Ń[vI
	do
		move.l	(a2),d2			;ۑ
		nop
		move.l	d3,(a2)			;eXgf[^
		nop
		cmp.l	(a2),d3			;eXgf[^ǂݏoAr
		nop
		break	ne
		nop
		move.l	d2,(a2)			;
		nop
		adda.l	#$00100000,a2		;1MB
	while	<cmpa.l #$00C00000,a2>,lo	;ő12MB
@@:	movea.l	a5,sp			;sp
	move.l	(sp)+,OFFSET_BUS_ERROR.w	;oXG[xN^
	ei				;sr
	move.l	a2,BIOS_MEMORY_SIZE.w	;NɊmFC̃TCY
	pop
	rts

;SASI@SCSI@𔻕ʂ
check_hard_disk_interface:
	isSASI
	sne.b	BIOS_BUILTIN_SCSI.w	;0=SASI@,-1=SCSI@
	rts

check_sram:
	push	d0/a0-a3
	lea.l	SRAM_MAGIC,a2		;SRAM}WbN
	lea.l	$00FF09E8,a3		;SRAMf[^
	movea.l	a2,a0
	movea.l	a3,a1
	ifor	<cmpm.l (a0)+,(a1)+>,ne,<cmpm.l (a0)+,(a1)+>,ne	;SRAM͉Ă
	;SRAM݋
		unlocksram
	;SRAM̐擪256oCgNA
		movea.l	a2,a0
		moveq.l	#256/4-1,d0
		for	d0
			clr.l	(a0)+
		next
	;SRAMf[^
		movea.l	a2,a0
		movea.l	a3,a1
		moveq.l	#$00FF0A43-$00FF09E8-1,d0	;SRAMf[^̒-1
		for	d0
			move.b	(a1)+,(a0)+
		next
	;TCYC
		move.l	BIOS_MEMORY_SIZE.w,SRAM_MEMORY_SIZE-SRAM_MAGIC(a2)
	;ROMNnhƃn[hfBXN̑䐔C
		if	<tst.b BIOS_BUILTIN_SCSI.w>,eq	;SASI@
			move.l	#$00E80400,SRAM_ROM_BOOT_HANDLE-SRAM_MAGIC(a2)
			move.b	#1,SRAM_HDMAX-SRAM_MAGIC(a2)
		else				;SCSI@
			move.l	#$00FC0000,SRAM_ROM_BOOT_HANDLE-SRAM_MAGIC(a2)
			clr.b	SRAM_HDMAX-SRAM_MAGIC(a2)
		endif
	;SRAM풓vO𖳌ɂ
		clr.w	SRAM_PROGRAM_START-SRAM_MAGIC(a2)
	;SRAM݋֎~
		locksram
	endif
	pop
	rts



;----------------------------------------------------------------
;	mF
;		SCSIINROM̐mF
;		ʂꂽTCYSRAM̐ݒlĂȂƂSRAM̐ݒlC邩₢킹
;		CLRL[ĂSRAM̈ʒuɉ
;	ύXO
;		00FF01D4 083800070807     	btst.b	#7,BIOS_BITSNS+7.w	;CLR|||||UNDO|ROLL DOWN|ROLL UP
;----------------------------------------------------------------
	PATCH_DATA	p01d4,$00FF01D4,$00FF01D4+5,$08380007
	jsr	p01d4
	PATCH_TEXT
p01d4:
	if	<btst.b #KEY_TENCLR&7,BIOS_BITSNS+(KEY_TENCLR>>3).w>,eq	;CLRL[ĂȂBĂƂneŕA邽tst.bł͂Ȃbtst.bg
		bsr	check_memory_size
		bsr	check_hard_disk_interface
		bsr	test_scsiinrom
		bsr	confirm_memory_size
		moveq.l	#0,d0			;eqŕA
	endif
	rts

;SCSIINROM̐mF
;	SASI@̂ƂSCSIINROM΃G[񍐂Ē~
;	SCSI@̂ƂSCSIINROM 16Ȃ΃G[񍐂Ē~
test_scsiinrom:
	push	d0-d1/a0
	lea.l	$00FC0024,a0		;'SCSIIN'
	clr.w	d1			;0=SCSIINROMȂ
	bsr	read_long
	if	<cmp.l #'SCSI',d0>,eq
		bsr	read_word
		if	<cmp.w #'IN',d0>,eq
			addq.w	#1,d1		;1=SCSIINROM
			bsr	read_word
			if	<cmp.w #16,d0>,eq
				addq.w	#1,d1		;2=SCSIINROM 16
			endif
		endif
	endif
;<d1.w:0=SCSIINROMȂ,1=SCSIINROM,2=SCSIINROM 16
	if	<tst.b BIOS_BUILTIN_SCSI.w>,eq	;SASI@̂Ƃ
		if	<tst.w d1>,ne		;SCSIINROM
			lea.l	100f(pc),a1		;13,10,'  SCSIINROM is not required'
			goto	20f
		endif
	else				;SCSI@̂Ƃ
		if	<cmp.w #2,d1>,ne	;SCSIINROM 16Ȃ
			lea.l	101f(pc),a1		;13,10,'  SCSIINROM 16 is required'
			goto	20f
		endif
	endif
	pop
	rts

20:	bsr	iocs_21_B_PRINT
	do
	while	t

100:	.dc.b	13,10,'  SCSIINROM is not required',0
101:	.dc.b	13,10,'  SCSIINROM 16 is required',0
	.even

;ʂꂽTCYSRAM̐ݒlĂȂƂSRAM̐ݒlC邩₢킹
confirm_memory_size:
	push	d0-d1/a0-a1
	move.l	SRAM_MEMORY_SIZE,d0	;SRAM̐ݒl̃TCY
	if	<cmp.l BIOS_MEMORY_SIZE.w,d0>,ne	;NɊmFC̃TCYBĂȂ
		lea.l	-128(sp),sp
		movea.l	sp,a0
		lea.l	100f(pc),a1		;13,10,'  Modify memory size setting from '
		bsr	strcpy
	;	move.l	SRAM_MEMORY_SIZE,d0	;SRAM̐ݒl̃TCY
		moveq.l	#20,d1
		lsr.l	d1,d0
		bsr	utos
		lea.l	101f(pc),a1		;'MB to '
		bsr	strcpy
		move.l	BIOS_MEMORY_SIZE.w,d0	;NɊmFC̃TCY
	;	moveq.l	#20,d1
		lsr.l	d1,d0
		bsr	utos
		lea.l	102f(pc),a1		;'MB? (Y/N)'
		bsr	strcpy
		movea.l	sp,a1
		bsr	iocs_21_B_PRINT
		bsr	kflush
		do
			bsr	inkey
			bsr	toupper
		whileand	<cmp.b #'Y',d0>,ne,<cmp.b #'N',d0>,ne
		if	<cmp.b #'Y',d0>,eq
			unlocksram
				move.l	BIOS_MEMORY_SIZE.w,SRAM_MEMORY_SIZE
			locksram
		endif
		lea.l	103f(pc),a1		;26
		bsr	iocs_21_B_PRINT
		lea.l	128(sp),sp
	endif
	pop
	rts

100:	.dc.b	13,10
	.dc.b	'  Modify memory size setting from ',0
101:	.dc.b	'MB to ',0
102:	.dc.b	'MB? (y/n)',0
103:	.dc.b	26,0
	.even



;----------------------------------------------------------------
;sRs[
;<a0.l:Rs[
;>a0.l:Rs[0̈ʒu
crlf:
	move.b	#13,(a0)+
	move.b	#10,(a0)+
	clr.b	(a0)
	rts

;----------------------------------------------------------------
;Ȃ16i4̕ɕϊ
;<d0.w:Ȃ
;<a0.l:obt@
;>a0.l:obt@0̈ʒu
h4tos:
	push	d1-d2
	moveq.l	#4-1,d1
	for	d1
		rol.w	#4,d0
		moveq.l	#15,d2
		and.w	d0,d2
		move.b	100f(pc,d2.w),(a0)+
	next
	clr.b	(a0)
	pop
	rts

100:	.dc.b	'0123456789ABCDEF'
	.even

;----------------------------------------------------------------
;Ȃ16i8̕ɕϊ
;<d0.l:Ȃ
;<a0.l:obt@
;>a0.l:obt@0̈ʒu
h8tos:
	push	d1-d2
	moveq.l	#8-1,d1
	for	d1
		rol.l	#4,d0
		moveq.l	#15,d2
		and.w	d0,d2
		move.b	100f(pc,d2.w),(a0)+
	next
	clr.b	(a0)
	pop
	rts

100:	.dc.b	'0123456789ABCDEF'
	.even

;----------------------------------------------------------------
;R[h0łȂL[܂ő҂
;>d0.b:R[h
inkey:
	do
		IOCS	_B_KEYINP
	while	<tst.b d0>,eq
	rts

;----------------------------------------------------------------
;L[̓obt@ɂ
kflush:
	push	d0
	IOCS	_B_KEYSNS
	while	<tst.l d0>,ne
		IOCS	_B_KEYINP
		IOCS	_B_KEYSNS
	endwhile
	pop
	rts

;----------------------------------------------------------------
;Rs[
;<a0.l:Rs[
;<a1.l:Rs[
;>a0.l:Rs[0̈ʒu
;>a1.l:Rs[0̎̈ʒu
strcpy:
	do
		move.b	(a1)+,(a0)+
	while	ne
	subq.l	#1,a0
	rts

;----------------------------------------------------------------
;啶ɂ
;<d0.b:R[h
;>d0.b:R[h
toupper:
	ifand	<cmp.b #'a',d0>,hs,<cmp.b #'z',d0>,ls
		add.b	#'A'-'a',d0
	endif
	rts

;----------------------------------------------------------------
;Ȃ10i̕ɕϊ
;<d0.l:Ȃ
;<a0.l:obt@
;>a0.l:obt@0̈ʒu
utos:
	push	d0-d2/a1
	if	<tst.l d0>,eq
		move.b	#'0',(a0)+
	else
		lea.l	utos_table(pc),a1
		do
			move.l	(a1)+,d1
		while	<cmp.l d1,d0>,lo	;Ƃ܂Ői
		do
			moveq.l	#'0'-1,d2
			do
				addq.b	#1,d2
				sub.l	d1,d0
			while	hs			;񐔂𐔂
			move.b	d2,(a0)+
			add.l	d1,d0			;߂
			move.l	(a1)+,d1
		while	ne
	endif
	clr.b	(a0)
	pop
	rts

utos_table:
	.dc.l	1000000000
	.dc.l	100000000
	.dc.l	10000000
	.dc.l	1000000
	.dc.l	100000
	.dc.l	10000
	.dc.l	1000
	.dc.l	100
	.dc.l	10
	.dc.l	1
	.dc.l	0

;----------------------------------------------------------------
;Ȃ10i̕ɕϊ([[U)
;<d0.l:Ȃ
;<d1.l:ŏ
;<a0.l:obt@
;>a0.l:obt@0̈ʒu
utosz:
	push	d0-d2/a1
	moveq.l	#10,d2
	sub.l	d1,d2
	if	lo
		do
			move.b	#'0',(a0)+
			addq.l	#1,d2
		while	ne			;Ȃ0ׂ
	endif
	lea.l	utos_table(pc),a1
	for	d2
		move.l	(a1)+,d1
	next	<cmp.l d1,d0>,lo	;ŏ܂͈Ƃ܂Ői
	do
		moveq.l	#'0'-1,d2
		do
			addq.b	#1,d2
			sub.l	d1,d0
		while	hs			;񐔂𐔂
		move.b	d2,(a0)+
		add.l	d1,d0			;߂
		move.l	(a1)+,d1
	while	ne
	clr.b	(a0)
	pop
	rts



  .if 0
;----------------------------------------------------------------
;oXG[𖳎1oCgǂݏo
;<a0.l:AhX
;>d0.b:f[^BoXG[̂Ƃ0
;>a0.l:AhX+1
;>c:cc=oXG[Ȃ,cs=oXG[
read_byte:
	push	d1/a1
	di				;srۑA荞݋֎~
	move.l	OFFSET_BUS_ERROR.w,-(sp)	;oXG[xN^ۑ
	lea.l	@f(pc),a1
	move.l	a1,OFFSET_BUS_ERROR.w
	movea.l	sp,a1			;spۑ
	moveq.l	#0,d0
;		  XNZVC
	moveq.l	#%00001,d1		;c=1
	nop
	move.b	(a0)+,d0		;1oCgǂݏo
	nop
	moveq.l	#%00000,d1		;c=0
@@:	movea.l	a1,sp			;sp
	move.l	(sp)+,OFFSET_BUS_ERROR.w	;oXG[xN^
	ei				;sr
	move.w	d1,ccr
	pop
	rts
  .endif

;----------------------------------------------------------------
;oXG[𖳎1[hǂݏo
;<a0.l:AhXB͕s
;>d0.w:f[^BoXG[̂Ƃ0
;>a0.l:AhX+2
;>c:cc=oXG[Ȃ,cs=oXG[
read_word:
	push	d1/a1
	di				;srۑA荞݋֎~
	move.l	OFFSET_BUS_ERROR.w,-(sp)	;oXG[xN^ۑ
	lea.l	@f(pc),a1
	move.l	a1,OFFSET_BUS_ERROR.w
	movea.l	sp,a1			;spۑ
	moveq.l	#0,d0
;		  XNZVC
	moveq.l	#%00001,d1		;c=1
	nop
	move.w	(a0)+,d0		;1[hǂݏo
	nop
	moveq.l	#%00000,d1		;c=0
@@:	movea.l	a1,sp			;sp
	move.l	(sp)+,OFFSET_BUS_ERROR.w	;oXG[xN^
	ei				;sr
	move.w	d1,ccr
	pop
	rts

;----------------------------------------------------------------
;oXG[𖳎1Oǂݏo
;<a0.l:AhXB͕s
;>d0.l:f[^BoXG[̂Ƃ0
;>a0.l:AhX+2
;>c:cc=oXG[Ȃ,cs=oXG[
read_long:
	push	d1/a1
	di				;srۑA荞݋֎~
	move.l	OFFSET_BUS_ERROR.w,-(sp)	;oXG[xN^ۑ
	lea.l	@f(pc),a1
	move.l	a1,OFFSET_BUS_ERROR.w
	movea.l	sp,a1			;spۑ
	moveq.l	#0,d0
;		  XNZVC
	moveq.l	#%00001,d1		;c=1
	nop
	move.l	(a0)+,d0		;1Oǂݏo
	nop
	moveq.l	#%00000,d1		;c=0
@@:	movea.l	a1,sp			;sp
	move.l	(sp)+,OFFSET_BUS_ERROR.w	;oXG[xN^
	ei				;sr
	move.w	d1,ccr
	pop
	rts



;----------------------------------------------------------------
;	NłȂSCSI-ID̃tO̕ۑ
;		̂܂
;			_B_SCSǏ̃xN^ړ邱Ƃɂ̂ŋNłȂSCSI-ID̃tO͈ړĂȂ
;			SASI@̂ƂՓ˂邱Ƃ͂Ȃ͂
;		00000112 1A380CC3         	move.b	BIOS_SCSI_UNBOOTABLE.w,d5
;		00000138 11C50CC3         	move.b	d5,BIOS_SCSI_UNBOOTABLE.w
;----------------------------------------------------------------



;----------------------------------------------------------------
;	NbNv
;		00FF013C 0C3800010CBC           cmpi.b	#$01,BIOS_MPU_TYPE.w
;			:
;		00FF019C
;----------------------------------------------------------------
	PATCH_DATA	clock_check,$00FF013C,$00FF019B,$0C380001
	jsr	clock_check
	bra	($00FF019C)PATCH_ZL
	PATCH_TEXT
;----------------------------------------------------------------
;NbNv
clock_check:

;VXeNbN̊mF
	moveq.l	#0,d0
	move.b	SYSPORT_MODEL,d0	;@픻ʁB$DC=X68030,$FE=XVI16MHz,$FF=XVIȑO10MHz
					;$00FF=10MHz,$00FE=16MHz,$00DC=25MHz
	not.b	d0			;$0000=10MHz,$0001=16MHz,$0023=25MHz
	lsl.w	#4,d0			;$0000=10MHz,$0010=16MHz,$0230=25MHz
	lsr.b	#4,d0			;$0000=10MHz,$0001=16MHz,$0203=25MHz
	move.w	d0,BIOS_CLOCK_SWITCH.w	;NbNXCb`B$0000=10MHz,$0001=16MHz,$0203=25MHz

;NbNv̂߂̃LbVON
;	68030̂Ƃ͖߃LbVƃf[^LbVONɂ
;	68040/68060̃f[^LbV68060̃XgAobt@MMULɂ܂ONɂłȂ̂Ŗ߃LbVONɂ
;	SRAM̃LbV̐ݒ͂Ŕf
	if	<cmpi.b #2,BIOS_MPU_TYPE.w>,hs	;68000/68010̓LbVȂ
		move.l	#$00002101,d0		;68020/68030͖߃LbVON(bit0)A68030̓f[^LbVON(bit8)
		if	<cmpi.b #4,BIOS_MPU_TYPE.w>,hs
			if	hi
				.cpu	68060
				movec.l	pcr,d0
				bset.l	#0,d0			;68060̓X[p[XJON(bit0)
				movec.l	d0,pcr
				.cpu	68000
				move.l	#$00800000,d0		;68060̓XgAobt@OFF(bit29),LbVON(bit23)
			endif
			move.w	#$8000,d0		;68040/68060̓f[^LbVOFF(bit31),߃LbVON(bit15)
		endif
		.cpu	68030
		movec.l	d0,cacr
		.cpu	68000
		clr.b	SYSPORT_WAIT
	endif

;NbNv
;ROMv
	lea.l	clock_loop(pc),a0	;v[v
	bsr	clock_sub		;vTu
	move.l	d0,BIOS_MPU_SPEED_ROM_LONG.w
	if	<cmp.l #$0000FFFF,d0>,hi
		moveq.l	#-1,d0
	endif
	move.w	d0,BIOS_MPU_SPEED_ROM.w
;RAMv
	lea.l	-30(sp),sp
	move.l	sp,d0
	add.w	#14,d0
	and.w	#-16,d0
	movea.l	d0,a0			;16oCgEn܂16oCg̃[NGA
	movem.l	clock_loop(pc),d0-d2/a1	;v[v[NGAɃRs[
	movem.l	d0-d2/a1,(a0)
;	X^bNGA߃LbVɏĂ邱Ƃ͂Ȃ̂ŃLbVtbV͏ȗ
	bsr	clock_sub		;vTu
	lea.l	30(sp),sp
	move.l	d0,BIOS_MPU_SPEED_RAM_LONG.w
	if	<cmp.l #$0000FFFF,d0>,hi
		moveq.l	#-1,d0
	endif
	move.w	d0,BIOS_MPU_SPEED_RAM.w
	rts

;vTu
;>d0.l:vlB0=s
;?d1-d2/a1
clock_sub:
aTCDCR	reg	a1
	lea.l	MFP_TCDCR,aTCDCR
;񐔏
	moveq.l	#22-8+1,d2
	do
		subq.w	#1,d2
		move.l	#1<<22,d0
		lsr.l	d2,d0
		subq.l	#1,d0
	;荞݋֎~
		di
	;^C}ۑ
		move.b	MFP_IERB-MFP_TCDCR(aTCDCR),-(sp)
		move.b	MFP_IMRB-MFP_TCDCR(aTCDCR),-(sp)
		move.b	MFP_TCDCR-MFP_TCDCR(aTCDCR),-(sp)
	;^C}ݒ
		andi.b	#.notb.(MFP_B_TIMERC_MASK|MFP_B_TIMERD_MASK),MFP_IMRB-MFP_TCDCR(aTCDCR)	;Timer-C/D荞݋֎~
		andi.b	#.notb.(MFP_B_TIMERC_MASK|MFP_B_TIMERD_MASK),MFP_IERB-MFP_TCDCR(aTCDCR)	;Timer-C/D荞ݒ~BIPRBNA
	;JEg~
		move.b	#0,(aTCDCR)		;Timer-C/DJEg~
		do
		while	<tst.b (aTCDCR)>,ne	;Sɒ~܂ő҂
	;JEgJn
		move.b	#0,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^NA
		move.b	#0,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
		move.b	#MFP_50US<<4|MFP_1US,(aTCDCR)	;Timer-C/DJEgJn
						;Timer-C1/200vXP[(50us)
						;Timer-D1/4vXP[(1us)
	;v
		jsr	(a0)
	;JEg~
		move.b	#0,(aTCDCR)		;Timer-C/DJEg~
		do
		while	<tst.b (aTCDCR)>,ne	;Sɒ~܂ő҂
	;^C}擾
		moveq.l	#0,d0
		moveq.l	#0,d1
		sub.b	MFP_TCDR-MFP_TCDCR(aTCDCR),d0	;Timer-CJEg
		sub.b	MFP_TDDR-MFP_TCDCR(aTCDCR),d1	;Timer-DJEg(I[o[t[)
	;^C}
		move.b	#200,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^
		move.b	#0,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
		move.b	(sp)+,(aTCDCR)
		move.b	(sp)+,MFP_IMRB-MFP_TCDCR(aTCDCR)
		move.b	(sp)+,MFP_IERB-MFP_TCDCR(aTCDCR)
	;荞݋
		ei
	;JE^
		mulu.w	#50,d0
		if	<cmp.b d1,d0>,hi
			add.w	#256,d0
		endif
		move.b	d1,d0			;0|us
	whileand	<tst.w d2>,ne,<cmp.w #5000,d0>,lo	;5000usɖȂΉ񐔂2{ɂČv
	if	<tst.w d0>,ne
	;␳
		lea.l	clock_scale(pc),a1
		moveq.l	#0,d1
		move.b	BIOS_MPU_TYPE.w,d1
		if	<cmp.w #6,d1>,ls
			lsl.w	#2,d1
			adda.w	d1,a1
		endif
		move.l	(a1),d1
		lsr.l	d2,d1			;d1=H|L
		divu.w	d0,d1			;d1=vc?(H|L)%us|(H|L)/us:H|L
		if	vc
			move.w	d1,d0			;d0=0|(H|L)/us
		else
			move.l	d1,d2			;d2=H|L
			clr.w	d2			;d2=H|0
			swap.w	d2			;d2=0|H
			divu.w	d0,d2			;d2=(0|H)%us|(0|H)/us
			swap.w	d0			;d0=us|0
			move.w	d2,d0			;d0=us|(0|H)/us
			swap.w	d0			;d0=(0|H)/us|us
			move.w	d1,d2			;d2=(0|H)%us|L
			divu.w	d0,d2			;d2=((0|H)%us|L)%us|((0|H)%us|L)/us
			move.w	d2,d0			;d0=(0|H)/us|((0|H)%us|L)/us
		endif
	endif
	rts

;v[v
	.align	16,$2048		;dbra.align 4ɂBRAMv.align 16Ȃ̂ROMv.align 16ɂ
clock_loop:
	forlong	d0
	next
	rts

	.align	4
clock_scale:
	.dc.l	4194304000	;68000
	.dc.l	4194304000	;68010
	.dc.l	4194304000	;68020
	.dc.l	4194304000	;68030
	.dc.l	2796202667	;68040
	.dc.l	0
	.dc.l	699050667	;68060

;  +-----------+---+-------+---------+----+--------+-----+------------------------+-----------------------------------------+-----------------------+
;  |           |c/n|   f   |u/n=c/n/f|  n | u=u/n*n|  J  |      K=c/n/J*2^22      |             CB8=K/(2^22/n)/u            |        f=CB8*J        |
;  +-----------+---+-------+---------+----+--------+-----+------------------------+-----------------------------------------+-----------------------+
;  |68000/68010| 12| 10.000|  1.200  |2^13|9830.400|0.012|4194304000=12/0.012*2^22|  833.333=4194304000/(2^22/2^13)/9830.400| 10.000=  833.333*0.012|
;  |           |   | 16.667|  0.720  |2^13|5898.240|     |                        | 1388.889=4194304000/(2^22/2^13)/5898.240| 16.667= 1388.889*0.012|
;  |           |   | 25.000|  0.480  |2^14|7864.320|     |                        | 2083.333=4194304000/(2^22/2^14)/7864.320| 25.000= 2083.333*0.012|
;  |           |   | 33.333|  0.360  |2^14|5898.240|     |                        | 2777.778=4194304000/(2^22/2^14)/5898.240| 33.333= 2777.778*0.012|
;  |           |   | 50.000|  0.240  |2^15|7864.320|     |                        | 4166.667=4194304000/(2^22/2^15)/7864.320| 50.000= 4166.667*0.012|
;  |           |   | 66.666|  0.180  |2^15|5898.240|     |                        | 5555.556=4194304000/(2^22/2^15)/5898.240| 66.667= 5555.556*0.012|
;  |           |   |100.000|  0.120  |2^16|7864.320|     |                        | 8333.333=4194304000/(2^22/2^16)/7864.320|100.000= 8333.333*0.012|
;  |           |   |750.000|  0.016  |2^19|8388.608|     |                        |62500.000=4194304000/(2^22/2^19)/8388.608|750.000=62500.000*0.012|
;  +-----------+---+-------+---------+----+--------+-----+------------------------+-----------------------------------------+-----------------------+
;  |68020/68030|  6| 25.000|  0.240  |2^15|7864.320|0.006|4194304000= 6/0.006*2^22| 4166.667=4194304000/(2^22/2^15)/7864.320| 25.000= 4166.667*0.006|
;  |           |   | 33.333|  0.180  |2^15|5898.240|     |                        | 5555.556=4194304000/(2^22/2^15)/5898.240| 33.333= 5555.556*0.006|
;  |           |   | 50.000|  0.120  |2^16|7864.320|     |                        | 8333.333=4194304000/(2^22/2^16)/7864.320| 50.000= 8333.333*0.006|
;  |           |   |375.000|  0.016  |2^19|8388.608|     |                        |62500.000=4194304000/(2^22/2^19)/8388.608|375.000=62500.000*0.006|
;  +-----------+---+-------+---------+----+--------+     +------------------------+-----------------------------------------+-----------------------+
;  |   68040   |  4| 25.000|  0.160  |2^15|5242.880|     |2796202667= 4/0.006*2^22| 4166.667=2796202667/(2^22/2^15)/5242.880| 25.000= 4166.667*0.006|
;  +-----------+---+-------+---------+----+--------+     +------------------------+-----------------------------------------+-----------------------+
;  |   68060   |  1| 33.333|  0.030  |2^18|7864.320|     | 699050667= 1/0.006*2^22| 5555.556= 699050667/(2^22/2^18)/7864.320| 33.333= 5555.556*0.006|
;  |           |   | 50.000|  0.020  |2^18|5242.880|     |                        | 8333.333= 699050667/(2^22/2^18)/5242.880| 50.000= 8333.333*0.006|
;  |           |   | 66.667|  0.015  |2^19|7864.320|     |                        |11111.111= 699050667/(2^22/2^19)/7864.320| 66.667=11111.111*0.006|
;  |           |   | 75.000|  0.013  |2^19|6990.507|     |                        |12500.000= 699050667/(2^22/2^19)/6990.507| 75.000=12500.000*0.006|
;  +-----------+---+-------+---------+----+--------+-----+------------------------+-----------------------------------------+-----------------------+
;  }
;    c/n  dbra[v1̃TCN
;    f    g(MHz)
;    u/n  dbra[v1̏v(}CNb)
;    n    dbra[v񐔁B2̗ݏu5000ȏ10000ɂȂ悤ɒ
;    u    dbra[vn̏v(}CNb)
;    J    68000/68010̂Ƃ0.012A68020/68030/68030/680600.006
;         dbraŕ򂷂Ƃ̃TCN6800012TCNA680306TCNł邱ƂɗR
;    K    c/n/J*2^22Be[uoB2^22K2^32ōőɂČ덷炷߂̌W
;    CB8  [$0CB8].w̒lBROMŌvgBX68000f*250/3AX68030f*500/3B12{܂6{邱Ƃf*1000Ƃėp
;  ⑫
;    68000/68010dbra10TCNROM̂Ƃ̓EGCĝ12TCNɂȂ
;    RAM̂ƂDRAM̃tbV̉e(1+0.22/f){炢ɂȂ



;----------------------------------------------------------------
;	s
;		MC68000̂ƂGAZbg̃|[g[h悤ƂċNłȂ
;	
;		IPLROM 1.2܂MOVE.B $00,$00E86001Ƃ낪IPLROM 1.3CLR.B $00E86001ɕύXꂽ
;		MC68000CLR.B̓Cg̑OɃ[h
;		GAZbg̃|[g$00E86001͐^ɃCgI[Ń[hƃoXG[ɂȂ
;		MC68000łCLR.B $00E86001oXG[ɂȂ
;		X68000X68030ROM悹ƋNłȂ1
;		G~[^CLR.B̃[hȗĂꍇ͋Nł
;	΍
;		SF.B[ĥCLR.BSF.BɕύXĂʖ
;		ÕA[N̏$00FF05BE畜AƂA0͏RTC̃AhX$00E8A000wĂ̂łg
;	Ql
;		ӂĂ̈A̍l@
;		https://twitter.com/futtyt/status/1332591514963197953
;	ύXO
;		00FF01B2  423900E86001          clr.b   $00E86001
;		00FF01B8
;----------------------------------------------------------------
	PATCH_DATA	area_set,$00FF01B2,$00FF01B7,$423900E8
;<a0.l:$00E8A000
	move.b	#$00,$00E86001-$00E8A000(a0)



;----------------------------------------------------------------
;	LCDΉL[
;	ύXO
;		00FF0252  7213                  moveq.l	#$13,d1
;		00FF0254  43F80800              lea.l	BIOS_BITSNS.w,a1
;		00FF0258  082900050005          btst.b	#5,5(a1)		;VL[BN|B|V|C|X|Z|]}|:*
;		00FF025E  660A                  bne.s	$00FF026A
;		00FF0260  7210                  moveq.l	#$10,d1
;		00FF0262  082900070005          btst.b	#7,5(a1)		;NL[BN|B|V|C|X|Z|]}|:*
;		00FF0268  6718                  beq.s	$00FF0282
;		00FF026A  13FC003100E8E00D      move.b	#$31,$00E8E00D		;SRAM݋
;		00FF0272  13C100ED001D          move.b	d1,$00ED001D		;N̉ʃ[h
;		00FF0278  423900E8E00D          clr.b	$00E8E00D		;SRAM݋֎~
;		00FF027E  70104E4F              IOCS	_CRTMOD
;		00FF0282
;----------------------------------------------------------------
	PATCH_DATA	lcd_key,$00FF0252,$00FF0281,$721343F8
	jsr	lcd_key
	bra	($00FF0282)PATCH_ZL
	PATCH_TEXT
lcd_key:
	moveq.l	#0,d1
	if	<btst.b #KEY_L&7,BIOS_BITSNS+(KEY_L>>3).w>,ne	;LL[Ă
		move.w	#$4C00+16,d1		;ʃ[h16(768x512)LCD
;	elif	<btst.b #KEY_N&7,BIOS_BITSNS+(KEY_N>>3).w>,mi	;NL[Ă
	elif	<tst.b BIOS_BITSNS+(KEY_N>>3).w>,mi	;NL[Ă
		move.w	#$4300+16,d1		;ʃ[h16(768x512)CRT
	elif	<btst.b #KEY_T&7,BIOS_BITSNS+(KEY_T>>3).w>,ne	;TL[Ă
		move.w	#$4300+3,d1		;ʃ[h3(256x240mC^[[X)CRT
	elif	<btst.b #KEY_V&7,BIOS_BITSNS+(KEY_V>>3).w>,ne	;VL[Ă
		move.w	#$4C00+19,d1		;ʃ[h19(640x480)LCD
	endif
	bclr.b	#0,BIOS_STARTUP_FLAGS.w	;HITANYKEY=0
	if	<tst.w d1>,ne
		bset.b	#0,BIOS_STARTUP_FLAGS.w	;HITANYKEY=1
		unlocksram
		move.b	d1,SRAM_CRTMOD		;N̉ʃ[h
		locksram
		IOCS	_CRTMOD
	endif
	rts



;----------------------------------------------------------------
;	ROMfobK
;		OPT.2L[ĂƂASRAMɂROMfobKNtOOFF܂CON̂ƂAUXɁAAUX̂ƂOFFɕύX܂
;		DL[ĂƂASRAMɂROMfobKNtOOFF܂AUX̂ƂCONɁACON̂ƂOFFɕύX܂
;		OPT.2L[̌ʂꎞIȂ̂iIȂ̂ɕύXĂ邱ƂɒӂĂ
;	ύXO
;		00FF0286 423809DE		clr.b	$09DE.w
;		00FF028A 1038080E		move.b	$080E.w,d0
;		00FF028E 123900ED0058		move.b	$00ED0058,d1
;		00FF0294 B300			eor.b	d1,d0
;		00FF0296 08000003		btst.l	#3,d0
;		00FF029A 670C			beq	$00FF02A8
;		00FF029C 11FC000109DE		move.b	#1,$09DE.w
;		00FF02A2 207AFD64		movea.l	$00FF0008(pc),a0
;		00FF02A6 4E90			jsr	(a0)
;		00FF02A8
;----------------------------------------------------------------
	PATCH_DATA	p0286,$00FF0286,$00FF02A7,$423809DE
	jsr	p0286
	bra	($00FF02A8)PATCH_ZL
	PATCH_TEXT
p0286:
	lea.l	SRAM_ROMDB,a0
	move.b	(a0),d0			;0=OFF,-1=AUX,1=CON
	do
		moveq.l	#1,d1			;1=CON
		if	<btst.b #KEY_D&7,BIOS_BITSNS+(KEY_D>>3).w>,eq	;DL[ĂȂ
			neg.b	d1			;-1=AUX
			break	<btst.b #KEY_OPT2&7,BIOS_BITSNS+(KEY_OPT2>>3).w>,eq	;OPT.2L[ĂȂ
		endif
	;DL[܂OPT.2L[Ă
		if	<cmp.b d0,d1>,eq	;tOƓL[Ă
			clr.b	d1			;0=OFF
		endif
		if	<cmp.b d0,d1>,ne	;tOω
			move.b	d1,d0
			lea.l	SYSPORT_SRAM,a1
			move.b	#$31,(a1)
			move.b	d0,(a0)
			clr.b	(a1)
		endif
	while	f
	neg.b	d0			;0=OFF,1=AUX,-1=CON
	move.b	d0,BIOS_ROMDB.w
	if	ne			;1=AUX,-1=CON
		movea.l	$00FF0008,a0		;ROMfobK̊JnAhX
		jsr	(a0)			;ROMfobKN
	endif
	rts



;----------------------------------------------------------------
;	68040/68060̂ƂfoCXhCoMMULɂ܂Ńf[^LbVOFFɂ
;	ύXO
;		00FF02A8 7202                   moveq.l	#$02,d1
;		00FF02AA 70AC                   moveq.l	#_SYS_STAT,d0
;		00FF02AC 4E4F                   trap	#15
;		00FF02AE
;----------------------------------------------------------------
	PATCH_DATA	cache_start,$00FF02A8,$00FF02AD,$720270AC
	jsr	cache_start
	PATCH_TEXT
cache_start:
	push	d2
	moveq.l	#0,d2
	move.b	SRAM_CACHE,d2		;LbVݒB------|f[^|
	if	<cmpi.b #4,BIOS_MPU_TYPE.w>,hs	;68040/68060
		and.b	#.notb.%10,d2		;f[^LbVOFF
	endif
	bsr	cache_set		;LbVݒ
	pop
	rts



;----------------------------------------------------------------
;	Hit any key
;	ύXO
;		00FF02B2 43FA08D4               lea.l	$00FF0B88(pc),a1	;$1A
;		00FF02B6 61000470               bsr.w	$00FF0728		;\
;		00FF02BA
;----------------------------------------------------------------
	PATCH_DATA	hitanykey,$00FF02B2,$00FF02B9,$43FA08D4
	jsr	hitanykey
	PATCH_TEXT
hitanykey:
	if	<btst.b #0,BIOS_STARTUP_FLAGS.w>,ne	;HITANYKEY
		lea.l	-64(sp),sp
		movea.l	sp,a0
		bsr	crlf
		bsr	start_proportional
		lea.l	100f(pc),a1		;'  Hit any key'
		bsr	strcpy
		bsr	end_proportional
		bsr	crlf
		movea.l	sp,a1
		bsr	iocs_21_B_PRINT
		lea.l	64(sp),sp
		do
			redo	<btst.b #KEY_L&7,BIOS_BITSNS+(KEY_L>>3).w>,ne	;LL[Ă
		;	redo	<btst.b #KEY_N&7,BIOS_BITSNS+(KEY_N>>3).w>,ne	;NL[Ă
			redo	<tst.b BIOS_BITSNS+(KEY_N>>3).w>,mi	;NL[Ă
			redo	<btst.b #KEY_T&7,BIOS_BITSNS+(KEY_T>>3).w>,ne	;TL[Ă
			redo	<btst.b #KEY_V&7,BIOS_BITSNS+(KEY_V>>3).w>,ne	;VL[Ă
		while	f			;L/N/T/VL[܂ő҂
		bsr	kflush			;L[obt@ɂ
		bsr	inkey			;L[܂ő҂
	endif
	rts

100:	.dc.b	'  Hit any key',0
	.even

;----------------------------------------------------------------
;v|[Visb`Jn
start_proportional:
	lea.l	100f(pc),a1
	bra	10f

;v|[Visb`I
end_proportional:
	lea.l	101f(pc),a1
10:
	goto	<btst.b #0,message_style(pc)>,ne,strcpy	;v|[Visb`
	clr.b	(a0)
	rts

100:	.dc.b	27,'[26m',0
101:	.dc.b	27,'[50m',0
	.even



;----------------------------------------------------------------
;	XF3,XF4,XF5ȂNƂ̃LbVOFF
;	ύXO
;		00FF0336 7000                   moveq.l	#$00,d0
;		00FF0338 4E7B0002               movec.l	d0,cacr			;LbVOFF
;		00FF033C
;----------------------------------------------------------------
	PATCH_DATA	xf345_cache_off,$00FF0336,$00FF033B,$70004E7B
	jsr	cache_off		;LbVOFF



;----------------------------------------------------------------
;	XF1,XF2ȂNƂ̃LbVOFF
;	ύXO
;		00FF0380 7000                   moveq.l	#$00,d0
;		00FF0382 4E7B0002               movec.l	d0,cacr			;LbVOFF
;		00FF0386
;----------------------------------------------------------------
	PATCH_DATA	xf12_cache_off,$00FF0380,$00FF0385,$70004E7B
	jsr	cache_off		;LbVOFF



;----------------------------------------------------------------
;	`O
;		68000̂ƂoXG[ƃAhXG[̗OX^bNt[@NȂ
;			TRAP#14(G[\)SSWACCESS ADDRESSINSTRUCTION REGISTERɃANZXł
;		68000ȊÔƂPC̍ŏʃoCg$02`$0FȂ΂xN^ԍƂĎg
;			X68030Ŗ`FC߂sƂuG[($000B)܂vł͂Ȃ
;			uȖ߂s܂vƕ\
;	ύXO
;		00FF0762 7E00             	moveq.l	#$00,d7
;		00FF0764 3E2F0006         	move.w	$0006(sp),d7
;		00FF0768 CE7C0FFF         	and.w	#$0FFF,d7		;xN^ItZbg
;		00FF076C E44F             	lsr.w	#2,d7			;xN^ԍ
;		00FF076E 6042_000007B2    	bra	$00FF07B2		;\
;		00FF0770 61000002_00000774	bsr	$00FF0774
;		00FF0774 2E1F             	move.l	(sp)+,d7		;$00FF0774̂
;		00FF0776 4A380CBC         	tst.b	BIOS_MPU_TYPE.w
;		00FF077A 66E6_00000762    	bne	$00FF0762
;		00FF077C 4247             	clr.w	d7
;		00FF077E 4847             	swap.w	d7
;		00FF0780 E04F             	lsr.w	#8,d7
;		00FF0782 BE7C0003         	cmp.w	#$0003,d7
;		00FF0786 622A_000007B2    	bhi	$00FF07B2
;		00FF0788 5C8F             	addq.l	#6,sp
;		00FF078A 4847             	swap.w	d7
;		00FF078C 3E1F             	move.w	(sp)+,d7		;߃R[h
;		00FF078E 2C6F0002         	movea.l	$0002(sp),a6		;PC
;		00FF0792 BE56             	cmp.w	(a6),d7
;		00FF0794 6714_000007AA    	beq	$00FF07AA
;		00FF0796 BE66             	cmp.w	-(a6),d7
;		00FF0798 6710_000007AA    	beq	$00FF07AA
;		00FF079A BE66             	cmp.w	-(a6),d7
;		00FF079C 670C_000007AA    	beq	$00FF07AA
;		00FF079E BE66             	cmp.w	-(a6),d7
;		00FF07A0 6708_000007AA    	beq	$00FF07AA
;		00FF07A2 BE66             	cmp.w	-(a6),d7
;		00FF07A4 6704_000007AA    	beq	$00FF07AA
;		00FF07A6 BE66             	cmp.w	-(a6),d7
;		00FF07A8 6604_000007AE    	bne	$00FF07AE
;		00FF07AA 2F4E0002         	move.l	a6,$0002(sp)		;PCG[߂܂Ŗ߂
;		00FF07AE 4247             	clr.w	d7
;		00FF07B0 4847             	swap.w	d7
;		00FF07B2 2C4F             	movea.l	sp,a6
;		00FF07B4 4E4E             	trap	#14
;		00FF07B6 303C00FF         	move.w	#_ABORTJOB,d0
;		00FF07BA 4E4F             	trap	#15
;		00FF07BC 60F8_000007B6    	bra	$00FF07B6		;[v
;		00FF07BE
;----------------------------------------------------------------
	PATCH_DATA	p0770,$00FF0770,$00FF0775,$61000002
	jsr	p0770			;PCvbVBjmpPC̍ŏʃoCgĂ܂̂ŕs
	PATCH_TEXT
p0770:
	moveq.l	#0,d7
	move.b	(sp),d7			;PC̍ŏʃoCg
	addq.l	#4,sp
	movea.l	sp,a6			;SR̈ʒuB68000̃oXG[ƃAhXG[
	if	<tst.b BIOS_MPU_TYPE.w>,eq	;68000
		ifor	<cmp.b #$02,d7>,eq,<cmp.b #$03,d7>,eq	;oXG[ƃAhXG[
		;	MC68000UM 6-17
		;	0.w
		;	  15-5 4   3   2-0
		;	  X    R/W I/N FC
		;	  R/W  0=Write,1=Read
		;	  I/N  0=Instruction,1=Not
		;	2.l  ACCESS ADDRESS
		;	6.w  INSTRUCTION REGISTER
		;	8.w  STATUS REGISTER
		;	10.l  PROGRAM COUNTER
			swap.w	d7
			move.w	6(sp),d7		;߃R[h
			movea.l	10(sp),a6		;PC
			do
				if	<cmp.w (a6),d7>,ne
					if	<cmp.w -(a6),d7>,ne
						if	<cmp.w -(a6),d7>,ne
							if	<cmp.w -(a6),d7>,ne
								if	<cmp.w -(a6),d7>,ne
									break	<cmp.w -(a6),d7>,ne
								endif
							endif
						endif
					endif
					move.l	a6,10(sp)		;PCG[߂܂Ŗ߂
				endif
			while	f
			clr.w	d7
			swap.w	d7
			lea.l	8(sp),a6		;SR̈ʒuBSP@NȂ
		endif
	else				;68000ȊO
		ifor	<cmp.b #$02,d7>,lo,<cmp.b #$0F,d7>,hi	;$02`$0FȊO
			move.w	6(sp),d7		;tH[}bgƃxN^ItZbg
			and.w	#$0FFF,d7		;xN^ItZbg
			lsr.w	#2,d7			;xN^ԍ
		endif
	endif
	trap	#14			;TRAP#14(G[\)
10:	IOCS	_ABORTJOB
	goto	10b			;[v



;----------------------------------------------------------------
;	IOCS _ABORTJOB
;		TRAP#14(G[\)̕ύXɍ킹ĕ\ύX
;	ύXO
;		00FF07BE 6128			bsr	$00FF07E8		;ʃ[hɂăeLXgʂ̕\ʒu𒲐߂
;		00FF07C0 43F900FF0B53		lea.l	$00FF0B53,a1		;G[܂BZbgĂB
;		00FF07C6 6100FF60		bsr	$00FF0728		;\
;		00FF07CA 60FE			bra	$00FF07CA		;[v
;----------------------------------------------------------------
	PATCH_DATA	p07BE,$00FF07BE,$00FF07CB,$612843F9
	jsr	p07BE
	PATCH_TEXT
p07BE:
	lea.l	-64(sp),sp
	movea.l	sp,a0
	bsr	start_proportional
	lea.l	100f(pc),a1		;'  Press the RESET switch'
	bsr	strcpy
	bsr	end_proportional
	movea.l	sp,a1
	bsr	iocs_21_B_PRINT
	lea.l	64(sp),sp
10:
	goto	10b			;[v

100:	.dc.b	'  Press the RESET switch',0
	.even



;----------------------------------------------------------------
;	N
;	ύXO
;		00FF0E76 48E7F0E0       	movem.l	d0-d3/a0-a2,-(sp)
;		00FF0E7A 6100025C       	bsr	$00FF10D8		;N
;		00FF0E7E 6120           	bsr	$00FF0EA0		;S
;		00FF0E80 7200           	moveq.l	#$00,d1
;		00FF0E82 70AC4E4F       	IOCS	_SYS_STAT
;		00FF0E86 2600           	move.l	d0,d3
;		00FF0E88 61000182       	bsr	$00FF100C		;ROM̃o[W
;		00FF0E8C 615C           	bsr	$00FF0EEA		;MPU̎ނƓg
;		00FF0E8E 610000EE       	bsr	$00FF0F7E		;FPU/FPCP̗L
;		00FF0E92 610000F8       	bsr	$00FF0F8C		;MMU̗L
;		00FF0E96 61000104       	bsr	$00FF0F9C		;C̃TCY
;		00FF0E9A 4CDF070F       	movem.l	(sp)+,d0-d3/a0-a2
;		00FF0E9E 4E75           	rts
;		00FF0EA0
;----------------------------------------------------------------
	PATCH_DATA	ipl_message,$00FF0E76,$00FF0E9F,$48E7F0E0
	jmp	ipl_message
	PATCH_TEXT
;----------------------------------------------------------------
;Nʂ\
ipl_message:
	push	d0-d7/a0-a6,128
;L[mF
;	SRAM_XEIJ_CRTMODŏς
	lea.l	SRAM_XEIJ,a0
	lea.l	SYSPORT_SRAM,a1
	moveq.l	#$31,d2
	if	<btst.b #0,BIOS_STARTUP_FLAGS.w>,ne	;HITANYKEY
		move.b	d2,(a1)			;unlocksram
		bclr.b	#SRAM_XEIJ_QUIET_BIT,(a0)	;Nʂ\
		clr.b	(a1)			;locksram
	elif	<btst.b #KEY_Q&7,BIOS_BITSNS+(KEY_Q>>3).w>,ne	;QL[Ă
		move.b	d2,(a1)			;unlocksram
		bset.b	#SRAM_XEIJ_QUIET_BIT,(a0)	;Nʂ\Ȃ
		clr.b	(a1)			;locksram
	endif
	if	<btst.b #SRAM_XEIJ_QUIET_BIT,(a0)>,eq	;Nʂ\
		jsr	$00FF10D8		;N
		jsr	$00FF0EA0		;S
		moveq.l	#0,d1
		IOCS	_SYS_STAT
		move.l	d0,d7			;MPUXe[^X
	;<d7.l:MPUXe[^X
		movea.l	sp,a6			;obt@
	;<a6.l:obt@
		movea.l	a6,a0
		if	<btst.b #2,message_style(pc)>,ne	;Ԃ
			bsr	crlf
		endif
		bsr	start_proportional
		movea.l	a6,a1
		bsr	iocs_21_B_PRINT
	;bZ[W
		bsr	ipl_message_romver	;ROM̃o[W\
		bsr	ipl_message_model	;@\
		bsr	ipl_message_series	;V[Y\
		bsr	ipl_message_mpu		;MPU̎ނƓg\
		bsr	ipl_message_mmu		;MMU̗L\
		bsr	ipl_message_fpu		;FPU/FPCP̗LƎނ\
		bsr	ipl_message_memory	;C͈̔͂Ɨeʂ\
		bsr	ipl_message_exmemory	;g͈̔͂Ɨeʂ\
		bsr	ipl_message_coprocessor	;RvZbT̗LƎނ\
		bsr	ipl_message_dmac_clock	;DMAC̓g\
		bsr	ipl_message_rtc_dttm	;RTC̓\
		bsr	ipl_message_hd_type	;n[hfBXNC^[tFCX̎ނ\
		bsr	ipl_message_boot_device	;NfoCX\
	;eLXgJ[\7sڂɈړ
		movea.l	a6,a0
		move.b	#27,(a0)+
		move.b	#'=',(a0)+
		moveq.l	#' '-6,d0
		add.w	BIOS_CONSOLE_BOTTOM.w,d0
		move.b	d0,(a0)+		;s
		move.b	#' '+0,(a0)+		;
		bsr	end_proportional
		movea.l	a6,a1
		bsr	iocs_21_B_PRINT
	endif
	pop
	rts

;----------------------------------------------------------------
;̗\
;<a1.l:BR܂܂Ȃ
;<a6.l:obt@
print_left_column:
	push	d0/a0-a1
	movea.l	a6,a0			;obt@
	if	<btst.b #1,message_style(pc)>,ne	;
		move.b	#27,(a0)+
		move.b	#'[',(a0)+
		moveq.l	#1,d0
		add.w	BIOS_CONSOLE_RIGHT.w,d0
		lsl.w	#2,d0			;R\[̕(px)/2
		bsr	utos
		move.b	#'r',(a0)+		;̗𒆉܂ł̉E񂹂ŕ\
		bsr	strcpy
		lea.l	100f(pc),a1		;' : ',1
		bsr	strcpy
	else				;
		move.l	a1,d0
		if	<btst.b #0,message_style(pc)>,ne	;v|[Visb`
			lea.l	101f(pc),a1		;27,'[320l'B40
		else				;m[}sb`
			lea.l	102f(pc),a1		;27,'[304l'B38
		endif
		bsr	strcpy
		movea.l	d0,a1
		bsr	strcpy
		lea.l	103f(pc),a1		;1,' : '
		bsr	strcpy
	endif
	movea.l	a6,a1			;obt@
	bsr	iocs_21_B_PRINT
	pop
	rts

100:	.dc.b	' : ',1,0
101:	.dc.b	27,'[320l',0
102:	.dc.b	27,'[304l',0
103:	.dc.b	1,' : ',0
	.even

;----------------------------------------------------------------
;ROM̃o[W\
;<a6.l:obt@
;?d0-d1/a0-a1
ipl_message_romver:
	lea.l	100f(pc),a1		;'ROM version'
	bsr	print_left_column
	IOCS	_ROMVER
;BCDϊ
	move.l	d0,d1			;abcdefgh
	clr.w	d0			;abcd0000
	sub.l	d0,d1			;0000efgh
	swap.w	d0			;0000abcd
	lsl.l	#4,d0			;000abcd0
	lsl.l	#4,d1			;000efgh0
	lsr.w	#4,d0			;000a0bcd
	lsr.w	#4,d1			;000e0fgh
	lsl.l	#8,d0			;0a0bcd00
	lsl.l	#8,d1			;0e0fgh00
	lsr.w	#4,d0			;0a0b0cd0
	lsr.w	#4,d1			;0e0f0gh0
	lsr.b	#4,d0			;0a0b0c0d
	lsr.b	#4,d1			;0e0f0g0h
	or.l	#$30303030,d0		;3a3b3c3d
	or.l	#$30303030,d1		;3e3f3g3h
;o[W
	movea.l	a6,a0			;obt@
	rol.l	#8,d0
	move.b	d0,(a0)+
	move.b	#'.',(a0)+
	rol.l	#8,d0
	move.b	d0,(a0)+
;t
	move.b	#' ',(a0)+
	move.b	#'(',(a0)+
	rol.l	#8,d0
	if	<cmp.b #'8',d0>,hs
		move.b	#'1',(a0)+
		move.b	#'9',(a0)+
	else
		move.b	#'2',(a0)+
		move.b	#'0',(a0)+
	endif
	move.b	d0,(a0)+
	rol.l	#8,d0
	move.b	d0,(a0)+
	move.b	#'-',(a0)+
	rol.l	#8,d1
	move.b	d1,(a0)+
	rol.l	#8,d1
	move.b	d1,(a0)+
	move.b	#'-',(a0)+
	rol.l	#8,d1
	move.b	d1,(a0)+
	rol.l	#8,d1
	move.b	d1,(a0)+
	move.b	#')',(a0)+
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'ROM Version',0
	.even

;----------------------------------------------------------------
;@\
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?a0-a1
ipl_message_model:
	if	<cmpi.l #'NAME',$00FFFFE0>,ne	;@햼Ȃ
		rts
	endif
	lea.l	100f(pc),a1		;'Model'
	bsr	print_left_column
	movea.l	a6,a0			;obt@
	lea.l	$00FFFFE4,a1
	bsr	strcpy
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Model',0
	.even

;----------------------------------------------------------------
;V[Y\
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?a0-a1
ipl_message_series:
	lea.l	100f(pc),a1		;'Series'
	bsr	print_left_column
	movea.l	a6,a0			;obt@
	lea.l	101f(pc),a1		;'X68000'
	if	<isX68030>,eq
		lea.l	102f(pc),a1		;'X68030'
	endif
	bsr	strcpy
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Series',0
101:	.dc.b	'X68000',0
102:	.dc.b	'X68030',0
	.even

;----------------------------------------------------------------
;MPU̎ނƓg\
;	XCMC
;		000/010/020/030/040MC
;		060̓rW5܂XCArW6MC
;			http://www.ppa.pl/forum/amiga/29981/68060-pcr
;			?	rW0
;			F43G	rW1
;			G65V	rW5
;			G59Y	?
;			E41J	rW6
;	ECLC
;		000/010/020͖
;		030MMUȂƂECAMMUƂ
;		040/060MMUȂƂECAMMUFPUȂƂLCAMMUFPUƂ
;	rWio[
;		060̂Ƃ-dddŃrWio[\
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0-d2/a0-a1
ipl_message_mpu:
	lea.l	100f(pc),a1		;'Microprocessor'
	bsr	print_left_column
	movea.l	a6,a0			;obt@
;^
	moveq.l	#-1,d2			;rWio[B-1=rWio[Ȃ
	moveq.l	#'M',d1
	if	<cmp.b #6,d7>,eq	;060
		.cpu	68060
		movec.l	pcr,d0
		.cpu	68000
		lsr.l	#8,d0
		moveq.l	#0,d2
		move.b	d0,d2			;rWio[
		if	<cmp.b #6,d2>,lo
			moveq.l	#'X',d1		;060̓rW5܂XC
		endif
	endif
	move.b	d1,(a0)+		;'M'܂'X'
	lea.l	101f(pc),a1		;'C68'
	bsr	strcpy
	do
		break	<cmp.b #3,d7>,lo	;000/010/020͖
		moveq.l	#'E',d1			;030/040/060MMUȂƂEC
		if	<btst.l #14,d7>,ne	;030/040/060MMUƂ
			break	<cmp.b #3,d7>,eq	;030MMUƂ
			break	<tst.w d7>,mi		;040/060MMUFPUƂ
			moveq.l	#'L',d1			;040/060MMUFPUȂƂLC
		endif
		move.b	d1,(a0)+		;'E'܂'L'
		move.b	#'C',(a0)+		;'C'
	while	f
	move.b	#'0',(a0)+		;'0'
	moveq.l	#'0',d1
	add.b	d7,d1
	move.b	d1,(a0)+		;'0'`'6'
	move.b	#'0',(a0)+		;'0'
	move.l	d2,d0			;rWio[
	if	pl
		move.b	#'-',(a0)+
		moveq.l	#3,d1
		bsr	utosz
	endif
;g
	move.b	#' ',(a0)+
	move.b	#'(',(a0)+
	move.l	d7,d0
	clr.w	d0
	swap.w	d0			;g(MHz)*10
	bsr	utos
	move.b	-1(a0),(a0)+		;_ȉ1ڂɂ炷
	move.b	#'.',-2(a0)		;_
	lea.l	102f(pc),a1		;'MHz)'
	bsr	strcpy
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Microprocessor',0
101:	.dc.b	'C68',0
102:	.dc.b	'MHz)',0
	.even

;----------------------------------------------------------------
;FPU/FPCP̗LƎނ\
;	030fmovecr.x #1,fp00̂ƂMC68881AȂMC68882
;	040/060on-chip
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0/a0-a1
ipl_message_fpu:
	if	<tst.w d7>,pl		;FPU/FPCPȂ
		rts
	endif
	lea.l	100f(pc),a1		;'Floating-Point Unit (FPU)'
	if	<cmp.b #4,d7>,lo	;020/030
		lea.l	101f(pc),a1		;'Floating-Point Coprocessor (FPCP)'
	endif
	bsr	print_left_column
	movea.l	a6,a0			;obt@
	lea.l	102f(pc),a1		;'on-chip'
	if	<cmp.b #4,d7>,lo	;020/030
		lea.l	103f(pc),a1		;'MC68881'
		.cpu	68030
		fmovecr.x	#1,fp0		;0=MC68881,0ȊO=MC68882
		fmove.x	fp0,-(sp)
		.cpu	68000
		move.l	(sp)+,d0
		or.l	(sp)+,d0
		or.l	(sp)+,d0
		if	ne
			lea.l	104f(pc),a1		;'MC68882'
		endif
	endif
	bsr	strcpy
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Floating-Point Unit (FPU)',0
101:	.dc.b	'Floating-Point Coprocessor (FPCP)',0
102:	.dc.b	'on-chip',0
103:	.dc.b	'MC68881',0
104:	.dc.b	'MC68882',0
	.even

;----------------------------------------------------------------
;MMU̗L\
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0/a0-a1
ipl_message_mmu:
	if	<btst.l #14,d7>,eq	;MMUȂ
		rts
	endif
	lea.l	100f(pc),a1		;'Memory Management Unit (MMU)'
	bsr	print_left_column
	movea.l	a6,a0			;obt@
	lea.l	101f(pc),a1		;'on-chip'
	if	<cmp.b #3,d7>,lo	;020
		lea.l	102f(pc),a1		;'MC68851'
	endif
	bsr	strcpy
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Memory Management Unit (MMU)',0
101:	.dc.b	'on-chip',0
102:	.dc.b	'MC68851',0
	.even

;----------------------------------------------------------------
;C͈̔͂Ɨeʂ\
;	$00100000-$00BFFFFFɂ1MBPʂŃC̗LmFAC݂͈͂\
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0-d1/a0-a1
ipl_message_memory:
	lea.l	100f(pc),a1		;'Main Memory'
	bsr	print_left_column
	moveq.l	#0,d0			;JnAhX
	move.l	BIOS_MEMORY_SIZE.w,d1	;IAhX(܂܂Ȃ)
;----------------------------------------------------------------
;͈̔͂Ɨeʂ\
;<d0.l:JnAhX
;<d1.l:IAhX(܂܂Ȃ)
;<a6.l:obt@
;?d0/a0-a1
ipl_message_memory_sub:
	movea.l	a6,a0			;obt@
	move.b	#'$',(a0)+
	bsr	h8tos			;JnAhX
	move.b	#'-',(a0)+
	move.b	#'$',(a0)+
	move.l	d0,-(sp)		;JnAhX
	move.l	d1,d0			;IAhX(܂܂Ȃ)
	subq.l	#1,d0			;IAhX(܂)
	bsr	h8tos
	move.b	#' ',(a0)+
	move.b	#'(',(a0)+
	move.l	d1,d0			;IAhX(܂܂Ȃ)
	sub.l	(sp)+,d0		;IAhX(܂܂Ȃ)-JnAhX=e
	clr.w	d0
	swap.w	d0
	lsr.w	#4,d0			;e(16MBP)
	bsr	utos
	lea.l	101f(pc),a1		;'MB)'
	bsr	strcpy
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Main Memory',0
101:	.dc.b	'MB)',0
	.even

;----------------------------------------------------------------
;g͈̔͂Ɨeʂ\
;	$01000000-$FFFFFFFFɂ16MBPʂœƗg̗LmFAg݂͈͂\
;	菇
;		ey[W̓ItZbgɏʂ̃y[W珇ɈقȂf[^
;		ʂ̃y[Wɏ񂾂Ƃŏʂ̃y[W̃f[^ωꍇ͏ʂ̃y[W݂͑ȂƔf
;		$2000-$21FF[NƂĎgp
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0-d1/a0-a3/a5
ipl_message_exmemory:
;	if	<cmp.b #2,d7>,lo	;000/010
;		rts
;	endif
;mFJn
	di				;srۑA荞݋֎~
	move.l	OFFSET_BUS_ERROR.w,-(sp)	;oXG[xN^ۑ
	movea.l	sp,a5			;spۑ
;ǂݏoAۑ
	move.l	#@f,OFFSET_BUS_ERROR.w
	suba.l	a2,a2			;y[W̐擪Ba2=page<<24
	lea.l	$2200.w,a1		;ۑ̈Ba1=$2100+page
	lea.l	$2100.w,a0		;ʗ̈Ba0=$2000+page
	move.w	#$00FF,d1		;y[WԍBd1=page
	for	d1
		suba.l	#$01000000,a2
		subq.l	#1,a1
		st.b	-(a0)			;$FF=ǂݏos
		nop
		move.b	(a2),(a1)		;ǂݏoAۑB-(a1)̓oXG[̂Ƃ̂ŕs
		nop
		sf.b	(a0)			;$00=ǂݏo
	@@:	movea.l	a5,sp			;sp
	next
;
	move.l	#@f,OFFSET_BUS_ERROR.w
	suba.l	a2,a2
	lea.l	$2100.w,a0
	move.w	#$00FF,d1
	for	d1
		suba.l	#$01000000,a2
		if	<tst.b -(a0)>,eq	;$00=ǂݏôƂ
			st.b	(a0)			;$FF=ݎs
			nop
			move.b	d1,(a2)			;
			nop
			sf.b	(a0)			;$00=ǂݏoݐ,$FF=ǂݏos܂͏ݎs
		@@:	movea.l	a5,sp			;sp
		endif
	next
;r
	move.l	#@f,OFFSET_BUS_ERROR.w
	suba.l	a2,a2
	lea.l	$2100.w,a0
	move.w	#$00FF,d1
	for	d1
		suba.l	#$01000000,a2
		if	<tst.b -(a0)>,eq	;$00=ǂݏoݐ̂Ƃ
			nop
			cmp.b	(a2),d1			;r
			nop
			sne.b	(a0)			;$00=v,$FF=ǂݏos܂͏ݎs܂͕sv
		@@:	movea.l	a5,sp			;sp
		endif
	next
;
	move.l	#@f,OFFSET_BUS_ERROR.w
	suba.l	a2,a2
	lea.l	$2200.w,a1
	move.w	#$00FF,d1
	for	d1
		suba.l	#$01000000,a2
		nop
		move.b	-(a1),(a2)		;
		nop
	@@:	movea.l	a5,sp			;sp
	next
;mFI
	move.l	(sp)+,OFFSET_BUS_ERROR.w	;oXG[xN^
	ei				;sr
;\
	suba.l	a2,a2			;JnʒuBa2=$2000+pageB0=page-1Ɋg͂Ȃ
	lea.l	$2000+1.w,a3		;IʒuBa3=$2000+page
	do
		if	<tst.b (a3)>,eq		;
			continue	<move.l a2,d0>,ne	;遨
		;Ȃ
			movea.l	a3,a2			;Jnʒu
		else				;Ȃ
			continue	<move.l a2,d0>,eq	;ȂȂ
		;遨Ȃ
			bsr	ipl_message_exmemory_sub	;g͈̔͂Ɨeʂ1\
			suba.l	a2,a2			;Jnʒu
		endif
	while	<addq.l #1,a3>,<cmpa.w #$20FF,a3>,ls
	if	<move.l a2,d0>,ne	;遨Ȃ
		bsr	ipl_message_exmemory_sub	;g͈̔͂Ɨeʂ1\
	endif
;n
	lea.l	$2000.w,a0
	moveq.l	#($2200-$2000)/4-1,d0
	for	d0
		clr.l	(a0)+
	next
	rts

;----------------------------------------------------------------
;g͈̔͂Ɨeʂ1\
;<a2.l:$2000+pageBJnʒu
;<a3.l:$2000+pageBIʒu(܂܂Ȃ)
;<a6.l:obt@
;?d0-d1/a0-a1
ipl_message_exmemory_sub:
	lea.l	100f(pc),a1		;'Extension Memory'
	bsr	print_left_column
	move.l	a2,d0
	swap.w	d0
	lsl.l	#8,d0			;JnAhX
	move.l	a3,d1
	swap.w	d1
	lsl.l	#8,d1			;IAhX(܂܂Ȃ)
	goto	ipl_message_memory_sub

100:	.dc.b	'Extension Memory',0
	.even

;----------------------------------------------------------------
;RvZbT̗LƎނ\
;	}U[{[hRvZbT
;		040/060FC=7$00022000CIR
;	lZvZbT{[h1
;		$00E9E000CIR
;	lZvZbT{[h2
;		$00E9E080CIR
;<d7.l:MPUXe[^X
;<a6.l:obt@
ipl_message_coprocessor:
;}U[{[hRvZbT
	if	<cmp.b #4,d7>,hs	;040/060
		bsr	copro_check_1
		if	<tst.l d0>,pl		;}U[{[hRvZbT
			lea.l	105f(pc),a1		;'Motherboard Coprocessor'
			bsr	print_left_column
			movea.l	a6,a0			;obt@
			lea.l	103f(pc),a1		;'MC68881'
			if	<tst.l d0>,ne
				lea.l	104f(pc),a1		;'MC68882'
			endif
			bsr	strcpy
			bsr	crlf
			movea.l	a6,a1			;obt@
			bsr	iocs_21_B_PRINT
		endif
	endif
;lZvZbT{[h1
	moveq.l	#0,d0
	bsr	copro_check_2
	if	<tst.l d0>,pl		;lZvZbT{[h1
		lea.l	106f(pc),a1		;'Extension Coprocessor #1'
		bsr	print_left_column
		movea.l	a6,a0			;obt@
		lea.l	103f(pc),a1		;'MC68881'
		if	<tst.l d0>,ne
			lea.l	104f(pc),a1		;'MC68882'
		endif
		bsr	strcpy
		bsr	crlf
		movea.l	a6,a1			;obt@
		bsr	iocs_21_B_PRINT
	endif
;lZvZbT{[h2
	moveq.l	#1,d0
	bsr	copro_check_2
	if	<tst.l d0>,pl		;lZvZbT{[h2
		lea.l	107f(pc),a1		;'Extension Coprocessor #2'
		bsr	print_left_column
		movea.l	a6,a0			;obt@
		lea.l	103f(pc),a1		;'MC68881',13,10
		if	<tst.l d0>,ne
			lea.l	104f(pc),a1		;'MC68882',13,10
		endif
		bsr	strcpy
		bsr	crlf
		movea.l	a6,a1			;obt@
		bsr	iocs_21_B_PRINT
	endif
	rts

105:	.dc.b	'Motherboard Coprocessor',0
106:	.dc.b	'Extension Coprocessor #1',0
107:	.dc.b	'Extension Coprocessor #2',0
103:	.dc.b	'MC68881',0
104:	.dc.b	'MC68882',0
	.even

;----------------------------------------------------------------
;}U[{[hRvZbT̗LƎނ𒲂ׂ
;	1msȓɔʂłȂΒ߂BTimer-C삵Ă邱
;>d0.l:-1=Ȃ,0=MC68881,1=MC68882
	.cpu	68060
copro_check_1:
	moveq.l	#-1,d0			;-1=Ȃ
	if	<cmpi.b #4,BIOS_MPU_TYPE.w>,lo	;000/010/020/030
		rts
	endif
	push	d1-d5/a0-a3
	lea.l	$00022000,a0		;}U[{[hRvZbTCIR
;<a0.l:FPCP_CIR
	lea.l	MFP_TCDR,a3
;<a3.l:MFP_TCDR
	move.w	sr,d2			;srۑ
;<d2.w:sř̒l
	ori.w	#$0700,sr		;荞݋֎~
	move.b	(a3),d3
	sub.b	#20,d3			;50us*20=1ms
	if	ls
		add.b	#200,d3
	endif
;<d3.b:1msMFP_TCDR̒l
	movec.l	dfc,d4			;dfcۑ
;<d4.l:dfč̒l
	movec.l	sfc,d5			;sfcۑ
;<d5.l:sfč̒l
	moveq.l	#7,d1			;CPU
	movec.l	d1,dfc
	movec.l	d1,sfc
	movea.l	OFFSET_BUS_ERROR.w,a2	;oXG[ۑ
;<a2.l:oXG[̌̃xN^
	lea.l	copro_check_1_abort(pc),a1
	move.l	a1,OFFSET_BUS_ERROR.w
	movea.l	sp,a1			;spۑ
;<a1.l:sp̌̒l
	clr.w	d1			;null
	moves.w	d1,$06(a0)		;restore
	moves.w	$06(a0),d1		;restore
	do
		goto	<cmp.b (a3),d3>,eq,copro_check_1_abort	;^CAEg
		moves.w	(a0),d1			;response
	;	and.w	#$7FFF,d1		;clear CA
	while	<cmp.w #$0802,d1>,ne	;idle
	move.w	#$5C01,d1		;fmovecr.x #$01,fp0
	moves.w	d1,$0A(a0)		;command
	do
		goto	<cmp.b (a3),d3>,eq,copro_check_1_abort	;^CAEg
		moves.w	(a0),d1			;response
	;	and.w	#$7FFF,d1		;clear CA
	while	<cmp.w #$0802,d1>,ne	;idle
	move.w	#$6800,d1		;fmove.x fp0,<mem>
	moves.w	d1,$0A(a0)		;command
	do
		goto	<cmp.b (a3),d3>,eq,copro_check_1_abort	;^CAEg
		moves.w	(a0),d1			;response
	;	and.w	#$7FFF,d1		;clear CA
;	while	<cmp.w #$320C,d1>,ne	;extended to mem
	while	<cmp.w #$8900,d1>,eq	;busy
	moves.l	$10(a0),d0		;operand
	moves.l	$10(a0),d1		;operand
	or.l	d1,d0
	moves.l	$10(a0),d1		;operand
	or.l	d1,d0			;0=MC68881
	if	ne
		moveq.l	#1,d0			;1=MC68882
	endif
copro_check_1_abort:
	movea.l	a1,sp			;sp
	move.l	a2,OFFSET_BUS_ERROR.w	;oXG[
	movec.l	d5,sfc			;sfc
	movec.l	d4,dfc			;dfc
	move.w	d2,sr			;sr
	pop
	rts
	.cpu	68000

;----------------------------------------------------------------
;lZvZbT{[h̗LƎނ𒲂ׂ
;	1msȓɔʂłȂΒ߂BTimer-C삵Ă邱
;<d0.l:0=lZvZbT{[h1,1=lZvZbT{[h2
;>d0.l:-1=Ȃ,0=MC68881,1=MC68882
copro_check_2:
	push	d1-d3/a0-a3
	lea.l	$00E9E000,a0		;lZvZbT{[h1CIR
	if	<tst.l d0>,ne
		lea.l	$00E9E080-$00E9E000(a0),a0	;lZvZbT{[h2CIR
	endif
;<a0.l:FPCP_CIR
	lea.l	MFP_TCDR,a3
;<a3.l:MFP_TCDR
	moveq.l	#-1,d0			;-1=Ȃ
;<d0.l:-1=Ȃ,0=MC68881,1=MC68882
	move.w	sr,d2			;srۑ
;<d2.w:sř̒l
	ori.w	#$0700,sr		;荞݋֎~
	move.b	(a3),d3
	sub.b	#20,d3			;50us*20=1ms
	if	ls
		add.b	#200,d3
	endif
;<d3.b:1msMFP_TCDR̒l
	movea.l	OFFSET_BUS_ERROR.w,a2	;oXG[ۑ
;<a2.l:oXG[̌̃xN^
	lea.l	copro_check_2_abort(pc),a1
	move.l	a1,OFFSET_BUS_ERROR.w
	movea.l	sp,a1			;spۑ
;<a1.l:sp̌̒l
	move.w	#$0000,$06(a0)		;restore,null
	tst.w	$06(a0)			;restore
	do
		goto	<cmp.b (a3),d3>,eq,copro_check_2_abort	;^CAEg
		move.w	(a0),d1			;response
	;	and.w	#$7FFF,d1		;clear CA
	while	<cmp.w #$0802,d1>,ne	;idle
	move.w	#$5C01,$0A(a0)		;command,fmovecr.x #$01,fp0
	do
		goto	<cmp.b (a3),d3>,eq,copro_check_2_abort	;^CAEg
		move.w	(a0),d1			;response
	;	and.w	#$7FFF,d1		;clear CA
	while	<cmp.w #$0802,d1>,ne	;idle
	move.w	#$6800,$0A(a0)		;command,fmove.x fp0,<mem>
	do
		goto	<cmp.b (a3),d3>,eq,copro_check_2_abort	;^CAEg
		move.w	(a0),d1			;response
	;	and.w	#$7FFF,d1		;clear CA
;	while	<cmp.w #$320C,d1>,ne	;extended to mem
	while	<cmp.w #$8900,d1>,eq	;busy
	move.l	$10(a0),d0		;operand
	move.l	$10(a0),d1		;operand
	or.l	d1,d0
	move.l	$10(a0),d1		;operand
	or.l	d1,d0			;0=MC68881
	if	ne
		moveq.l	#1,d0			;1=MC68882
	endif
copro_check_2_abort:
	movea.l	a1,sp			;sp
	move.l	a2,OFFSET_BUS_ERROR.w	;oXG[
	move.w	d2,sr			;srB荞݋
	pop
	rts

;----------------------------------------------------------------
;DMAC̓g\
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0-d2/a0-a1
ipl_message_dmac_clock:
	lea.l	100f(pc),a1		;'Direct Memory Access Controller (DMAC)'
	bsr	print_left_column
	movea.l	a6,a0			;obt@
	lea.l	101f(pc),a1		;'HD63450 (Main Memory:'
	bsr	strcpy
	lea.l	$6800.w,a2
	bsr	measure_dmac_clock
	bsr	utos
	lea.l	102f(pc),a1		;'%, SRAM:'
	bsr	strcpy
	lea.l	$00ED0000,a2
	bsr	measure_dmac_clock
	bsr	utos
	lea.l	103f(pc),a1		;'%)',13,10
	bsr	strcpy
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Direct Memory Access Controller (DMAC)',0
101:	.dc.b	'HD63450 (Main Memory:',0
102:	.dc.b	'%, SRAM:',0
103:	.dc.b	'%)',13,10,0
	.even

;----------------------------------------------------------------
;DMAC̓gv
;	DMAC(a2)(a2)5000[h]̂ɂ鎞ԂusPʂŌv
;	10MHz10TCN/[h100%Ƃ%lԂ
;<a2.l:AhX
;>d0.l:DMAC̓쑬xB10MHz10TCN/[h100%Ƃ%l
measure_dmac_clock:
	push	d1-d2/a0-a1
aDMAC	reg	a0
	lea.l	DMAC_2_BASE,aDMAC
aTCDCR	reg	a1
	lea.l	MFP_TCDCR,aTCDCR
;LbV֎~
	bsr	cache_off
	move.l	d0,d2
;荞݋֎~
	di
;SRAM݋
	unlocksram
;DMACۑ
	move.b	DMAC_DCR(aDMAC),-(sp)
	move.b	DMAC_OCR(aDMAC),-(sp)
	move.b	DMAC_SCR(aDMAC),-(sp)
	move.b	DMAC_MFC(aDMAC),-(sp)
	move.b	DMAC_CPR(aDMAC),-(sp)
	move.b	DMAC_DFC(aDMAC),-(sp)
;DMACݒ
	st.b	DMAC_CSR(aDMAC)		;CSRNA
	move.b	#DMAC_BURST_TRANSFER|DMAC_HD68000_COMPATIBLE|DMAC_16_BIT_PORT|DMAC_STATUS_INPUT,DMAC_DCR(aDMAC)
	move.b	#DMAC_MEMORY_TO_DEVICE|DMAC_16_BIT_OPERAND|DMAC_NO_CHAINING|DMAC_AUTO_REQUEST_MAX,DMAC_OCR(aDMAC)
	move.b	#DMAC_INCREMENT_MEMORY|DMAC_INCREMENT_DEVICE,DMAC_SCR(aDMAC)
	move.b	#DMAC_HIGHEST_PRIORITY,DMAC_CPR(aDMAC)
	move.b	#DMAC_SUPERVISOR_DATA,DMAC_MFC(aDMAC)
	move.b	#DMAC_SUPERVISOR_DATA,DMAC_DFC(aDMAC)
	move.l	a2,DMAC_MAR(aDMAC)	;]
	move.l	a2,DMAC_DAR(aDMAC)	;]
	move.w	#5000,DMAC_MTC(aDMAC)	;]Iyh
;^C}ۑ
	move.b	MFP_IERB-MFP_TCDCR(aTCDCR),-(sp)
	move.b	MFP_IMRB-MFP_TCDCR(aTCDCR),-(sp)
	move.b	(aTCDCR),-(sp)
;^C}ݒ
	andi.b	#.notb.(MFP_B_TIMERC_MASK|MFP_B_TIMERD_MASK),MFP_IERB-MFP_TCDCR(aTCDCR)	;Timer-C/D荞ݒ~
	andi.b	#.notb.(MFP_B_TIMERC_MASK|MFP_B_TIMERD_MASK),MFP_IMRB-MFP_TCDCR(aTCDCR)	;Timer-C/D荞݋֎~
	move.b	#0,(aTCDCR)		;Timer-C/DJEg~
	do
	while	<tst.b (aTCDCR)>,ne	;Sɒ~܂ő҂
	move.b	#0,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^NA
	move.b	#0,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
;JEgJn
	move.b	#MFP_50US<<4|MFP_1US,(aTCDCR)	;Timer-C/DJEgJn
						;Timer-C1/200vXP[(50us)
						;Timer-D1/4vXP[(1us)
;DMA]s
;	DMA]MPŨoXANZX邱Ƃɒ
	move.b	#DMAC_CCR_STR,DMAC_CCR(aDMAC)	;DMA]Jn
  .rept 8
	nop				;12.5MHz7TCN(560ns)҂
  .endm
	do
	while	<tst.b DMAC_CSR(aDMAC)>,pl	;DMA]I҂
;JEg~
	move.b	#0,(aTCDCR)		;Timer-C/DJEg~
	do
	while	<tst.b (aTCDCR)>,ne	;Sɒ~܂ő҂
;^C}擾
	moveq.l	#0,d0
	sub.b	MFP_TCDR-MFP_TCDCR(aTCDCR),d0	;Timer-CJEg
	moveq.l	#0,d1
	sub.b	MFP_TDDR-MFP_TCDCR(aTCDCR),d1	;Timer-DJEg(I[o[t[)
;^C}
	move.b	#200,MFP_TCDR-MFP_TCDCR(aTCDCR)	;Timer-CJE^
	move.b	#0,MFP_TDDR-MFP_TCDCR(aTCDCR)	;Timer-DJE^NA
	move.b	(sp)+,(aTCDCR)
	move.b	(sp)+,MFP_IMRB-MFP_TCDCR(aTCDCR)
	move.b	(sp)+,MFP_IERB-MFP_TCDCR(aTCDCR)
;DMAC
	st.b	DMAC_CSR(aDMAC)		;CSRNA
	move.b	(sp)+,DMAC_DFC(aDMAC)
	move.b	(sp)+,DMAC_CPR(aDMAC)
	move.b	(sp)+,DMAC_MFC(aDMAC)
	move.b	(sp)+,DMAC_SCR(aDMAC)
	move.b	(sp)+,DMAC_OCR(aDMAC)
	move.b	(sp)+,DMAC_DCR(aDMAC)
;SRAM݋֎~
	locksram
;荞݋
	ei
;JE^
	mulu.w	#50,d0
	if	<cmp.b d1,d0>,hi
		add.w	#256,d0
	endif
	move.b	d1,d0
	subq.w	#1,d0
;<d0.l:SRAMSRAM5000[hDMA]̂ɂ(us)B0`12799
;10TCN/[h10MHz100%Ƃ%l߂
;	10(TCN/[h)/(d0/5000)(us/[h)/10(MHz)*100 = 10*5000/d0*10
	move.l	#10*5000*10,d1		;d1=폜
	divu.w	d0,d1			;d1=]<<16|
	swap.w	d1			;d1=<<16|]
	lsr.w	#1,d0			;d0=/2
	sub.w	d1,d0			;d0=/2-]Bx=/2<]?1:0
	swap.w	d1			;d1=]<<16|
	moveq.l	#0,d0
	addx.w	d1,d0
;<d0.l:10MHz10TCN/[h100%Ƃ%l
;LbV
	move.l	d0,d1
	bsr	cache_set
	move.l	d1,d0
	pop
	rts


;----------------------------------------------------------------
;RTC̓\
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0-d2/a0-a1
ipl_message_rtc_dttm:
	lea.l	100f(pc),a1		;'Real Time Clock (RTC)'
	bsr	print_left_column
	movea.l	a6,a0			;obt@
	lea.l	101f(pc),a1		;'RP5C15 ('
	bsr	strcpy
;RTCǂݏo
	bsr	readrtc
	if	pl
		bsr	checkdttm
	endif
;<d0.l:0=,-1=ُ
;<d1.l:j<<28|N<<16|<<8|ʓ
;<d2.l:<<16|<<8|b
;ُ̂ƂJn
	if	<tst.l d0>,mi
		lea.l	102f(pc),a1		;27,'[9m'
		bsr	strcpy
	endif
;𕶎ɕϊ
	bsr	dttmtos
;ُ̂ƂI
	if	<tst.l d0>,mi
		lea.l	103f(pc),a1		;27,'[29m'
		bsr	strcpy
	endif
	lea.l	104f(pc),a1		;')',13,10
	bsr	strcpy
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Real Time Clock (RTC)',0
101:	.dc.b	'RP5C15 (',0
102:	.dc.b	27,'[9m',0
103:	.dc.b	27,'[29m',0
104:	.dc.b	')',13,10,0
	.even

;--------------------------------------------------------------------------------
;𕶎ɕϊ
;<d1.l:j<<28|N<<16|<<8|ʓ
;<d2.l:<<16|<<8|b
;<a0.l:obt@
;>a0.l:0̈ʒu
dttmtos:
	push	d0-d2
	swap.w	d1			;d1.l:<<24|ʓ<<16|j<<12|N
	move.l	#$00000FFF,d0
	and.w	d1,d0			;d0.l:N
	bsr	utos
	move.b	#'-',(a0)+
	rol.l	#8,d1			;d1.l:ʓ<<24|j<<20|N<<8|
	moveq.l	#0,d0
	move.b	d1,d0			;d0.l:
	bsr	50f
	move.b	#'-',(a0)+
	rol.l	#8,d1			;d1.l:j<<28|N<<16|<<8|ʓ
	moveq.l	#0,d0
	move.b	d1,d0			;d0.l:ʓ
	bsr	50f
	move.b	#' ',(a0)+
	move.b	#'(',(a0)+
	rol.l	#4,d1			;d1.l:N<<20|<<12|ʓ<<4|j
	moveq.l	#$0F,d0
	and.b	d1,d0			;d0.l:j
	if	<cmp.b #7,d0>,hi
		moveq.l	#7,d0
	endif
	lsl.b	#2,d0			;4*j
	lea.l	100f(pc,d0.w),a1
	bsr	strcpy
	move.b	#')',(a0)+
	move.b	#' ',(a0)+
	swap.w	d2			;d2.l:<<24|b<<16|
	moveq.l	#0,d0
	move.b	d2,d0			;d0.l:
	bsr	50f
	move.b	#':',(a0)+
	rol.l	#8,d2			;d2.l:b<<24|<<8|
	moveq.l	#0,d0
	move.b	d2,d0			;d0.l:
	bsr	50f
	move.b	#':',(a0)+
	rol.l	#8,d2			;d2.l:|<<16|<<8|b
	moveq.l	#0,d0
	move.b	d2,d0			;d0.l:b
	bsr	50f
	pop
	rts

50:	if	<cmp.b #10,d0>,lo
		move.b	#'0',(a0)+
	endif
	goto	utos

100:	.dc.b	'Sun',0
	.dc.b	'Mon',0
	.dc.b	'Tue',0
	.dc.b	'Wed',0
	.dc.b	'Thu',0
	.dc.b	'Fri',0
	.dc.b	'Sat',0
	.dc.b	'???',0
	.even

;--------------------------------------------------------------------------------
;RTCǂݏo
;	X[p[oCU[hŌĂяo
;>d0.l:0=,-1=ُ
;>d1.l:j<<28|N<<16|<<8|ʓ
;>d2.l:<<16|<<8|b
;	j	̂Ƃ0`6B0=j,c,6=yj
;	N	̂Ƃ1980`2079
;		̂Ƃ1`12
;	ʓ	̂Ƃ1`̓
;		̂Ƃ0`23
;		̂Ƃ0`59
;	b	̂Ƃ0`59
;	ُ̂Ƃ͈͊O̒lԂ邱Ƃ
;>ccr:pl=,mi=ُ
;	ُ̓e
;	EBCDُ
readrtc:
	push	d3-d4/d7/a0-a2
	moveq.l	#0,d7			;
aRTC	reg	a1
rtc	reg	-RTC_MODE(aRTC)
	lea.l	RTC_MODE,aRTC
aPPIA	reg	a2
	lea.l	PPI_PORT_A,aPPIA
;------------------------------------------------
;RTC̃WX^ǂݏo
;	̃WX^ǂݏoĂԂɎvi݃WX^̓eωꍇ
;	ʂǂōŉʂ0̂Ƃ(Jオɂ鎞ԑ҂Ă)ǂݒ
	moveq.l	#2-1,d4
	for	d4
		moveq.l	#RTC_MODE_BANK_MASK,d0
		or.b	(RTC_MODE)rtc,d0
		tst.b	(aPPIA)
		tst.b	(aPPIA)
		move.b	d0,(RTC_MODE)rtc	;oN1
		tst.b	(aPPIA)
		tst.b	(aPPIA)
		moveq.l	#$01,d2
		and.b	(RTC_1_TWENTY_FOUR)rtc,d2	;0=12Ԍv,1=24Ԍv
		subq.b	#1,d0
		tst.b	(aPPIA)
		tst.b	(aPPIA)
		move.b	d0,(RTC_MODE)rtc	;oN0
		tst.b	(aPPIA)
		tst.b	(aPPIA)
		moveq.l	#$07,d1
		and.b	(RTC_0_DAY_OF_WEEK)rtc,d1	;jJE^
		lea.l	(RTC_0_TEN_YEARS+1)rtc,a0	;10NJE^̒
		moveq.l	#6-1,d3
		for	d3
			moveq.l	#$0F,d0
			and.w	-(a0),d0		;10NJE^1JE^
			lsl.l	#4,d1
			or.b	d0,d1
		next
		subq.l	#2,a0			;jJE^ׂB10JE^̒
		moveq.l	#6-1,d3
		for	d3
			moveq.l	#$0F,d0
			and.w	-(a0),d0		;10JE^1bJE^
			lsl.l	#4,d2
			or.b	d0,d2
		next
		moveq.l	#$0F,d0
		and.b	d2,d0			;ŉ
	next	eq			;0łȂΏI
;<d1.l:j<<24|(N-1980)(BCD)<<16|(BCD)<<8|ʓ(BCD)
;<d2.l:(BCD)<<16|(BCD)<<8|b(BCD)
;------------------------------------------------
;tfR[h
	move.l	d1,d0
	bsr	decode3bcd		;2*3gBCDfR[h
;<d0.l:j<<24|(N-1980)<<16|<<8|ʓ
	if	mi			;ُ
		moveq.l	#-1,d7			;ُ
	endif
;j炵ĐN1980
	swap.w	d0			;mmdd0wyy
	ror.w	#8,d0			;mmddyy0w
	lsl.b	#4,d0			;mmddyyw0
	rol.w	#8,d0			;mmddw0yy
	add.w	#1980,d0		;mmddwyyy
	swap.w	d0			;wyyymmdd
	move.l	d0,d1
;<d1.l:j<<28|N<<16|<<8|ʓ
;------------------------------------------------
;fR[h
	move.l	d2,d0
	bsr	decode3bcd		;2*3gBCDfR[h
;<d0.l:<<16|<<8|b
	if	mi			;ُ
		moveq.l	#-1,d7			;ُ
	endif
	move.l	d0,d2
;<d2.l:<<16|<<8|b
;------------------------------------------------
;I
	move.l	d7,d0
	pop
	rts

;--------------------------------------------------------------------------------
;RTCǂݏoɈُ킪ȂmF
;<d1.l:j<<28|N<<16|<<8|ʓ
;<d2.l:<<16|<<8|b
;>d0.l:0=,-1=ُ
;>ccr:pl=,mi=ُ
;	ُ̓e
;	E202322931Ȃǂ݂̑Ȃ
;	E_ROMVER̓tO̖炩ɉߋ̓t
;	EjႤ
checkdttm:
	push	d3-d5/a0
;------------------------------------------------
;t𕪉
	move.l	d1,d5			;d5.l:j<<28|N<<16|<<8|ʓ
	moveq.l	#0,d3
	move.b	d5,d3			;d3.l:ʓB̂Ƃ1`̓
	lsr.w	#8,d5			;d5.l:j<<28|N<<16|
	moveq.l	#0,d4
	move.b	d5,d4			;d4.l:B̂Ƃ1`12
	swap.w	d5			;d5.l:<<16|j<<12|N
	and.l	#$00000FFF,d5		;d5.l:NB̂Ƃ1980`2079
;<d3.l:ʓB̂Ƃ1`̓
;<d4.l:B̂Ƃ1`12
;<d5.l:NB̂Ƃ1980`2079
;------------------------------------------------
;N͈̔͂mF
	gotoor	<cmp.w #1980,d5>,lo,<cmp.w #2079,d5>,hi,90f	;N1980菬܂2079傫
;------------------------------------------------
;͈̔͂mF
	gotoor	<tst.w d4>,eq,<cmp.w #12,d4>,hi,90f	;0܂12傫
;------------------------------------------------
;ʓ͈̔͂mF
	moveq.l	#0,d0
	if	<cmp.b #2,d4>,eq	;2
		moveq.l	#3,d0
		and.b	d5,d0			;N&3
		seq.b	d0			;0=[Nł͂ȂN2,-1=[N2
		neg.b	d0			;0=[Nł͂ȂN2,1=[N2
	endif
	lea.l	daysofmonth(pc),a0
	add.b	-1(a0,d4.w),d0		;d0.l:̓
	gotoor	<tst.w d3>,eq,<cmp.w d0,d3>,hi,90f	;ʓ0܂͌̓傫
;------------------------------------------------
;_ROMVER̓tƔr
	IOCS	_ROMVER
	bsr	decode3bcd		;2*3gBCDfR[h
;<d0.l:_ROMVER̃o[W<<24|_ROMVER̐N̉2<<16|_ROMVEŘ<<8|_ROMVEŘʓ
;_ROMVER̐NƔr
	swap.w	d0			;d0.w:_ROMVER̃o[W<<24|_ROMVER̐N̉2
	and.w	#$00FF,d0		;d0.w:_ROMVER̐N̉2
	add.w	#1900,d0
	if	<cmp.w #1950,d0>,lo
		add.w	#2000-1900,d0	;d0.w:_ROMVER̐N
	endif
	goto	<cmp.w d0,d5>,lo,90f	;_ROMVER̐NO
	if	eq			;_ROMVER̐NƓ
	;_ROMVEŘƔr
		swap.w	d0			;d0.w:_ROMVEŘ<<8|_ROMVEŘʓ
		ror.w	#8,d0			;d0.w:_ROMVEŘʓ<<8|_ROMVEŘ
		goto	<cmp.b d0,d4>,lo,90f	;_ROMVEŘO
		if	eq			;_ROMVEŘƓ
		;_ROMVEŘʓƔr
			rol.w	#8,d0			;d0.w:_ROMVEŘ<<8|_ROMVEŘʓ
			goto	<cmp.b d0,d3>,lo,90f	;_ROMVEŘʓO
		endif
	endif
;------------------------------------------------
;jmF
	if	<cmp.w #2,d4>,ls	;12
		subq.w	#1,d5			;ON
		add.w	#12,d4			;1314ɂ
	endif
	move.l	d5,d0			;d0.l:N
	mulu.w	#365,d0			;d0.l:365*N
	lsr.w	#2,d5			;d5.l:floor(N/4)
	add.l	d5,d0			;d0.l:365*N+floor(N/4)
	addq.w	#1,d4			;d4.l:+1
	mulu.w	#306,d4			;d4.l:306*(+1)
  .if 1
	divu.w	#10,d4			;d4.w:floor(306*(+1))/10B폜306*4=1224`306*15=4590
	ext.l	d4			;d4.l:floor(306*(+1))/10
  .else
	mulu.w	#3277,d4
	add.l	d4,d4
	clr.w	d4
	swap.w	d4			;d4.l:floor(306*(+1))/10
  .endif
	add.l	d4,d0			;d0.l:365*N+floor(N/4)+floor(306*(+1))/10
	add.l	d3,d0			;d0.l:365*N+floor(N/4)+floor(306*(+1))/10+ʓ
	sub.l	#723256,d0		;d0.l:365*N+floor(N/4)+floor(306*(+1))/10+ʓ-723256B1980N112A2079N123136526
	divu.w	#7,d0
	swap.w	d0			;d0.w:t̗jB0`6
	move.l	d1,d3			;d3.l:j<<28|N<<16|<<8|ʓ
	rol.l	#4,d3			;d3.l:N<<20|<<12|ʓ<<4|j
	and.w	#$000F,d3		;d3.w:RTCԂj
	goto	<cmp.w d0,d3>,ne,90f	;jႤ
;------------------------------------------------
;͈̔͂mF
	move.l	d2,d0
	goto	<cmp.b #59,d0>,hi,90f	;b͈͊O
	lsr.w	#8,d0
	goto	<cmp.b #59,d0>,hi,90f	;͈͊O
	swap.w	d0
	goto	<cmp.b #23,d0>,hi,90f	;͈͊O
;------------------------------------------------
;I
	moveq.l	#0,d0
80:	pop
	rts

;------------------------------------------------
;ُI
90:	moveq.l	#-1,d0
	goto	80b

;------------------------------------------------
;[NłȂŇ̓
daysofmonth:
	.dc.b	31,28,31,30,31,30,31,31,30,31,30,31
	.even

;--------------------------------------------------------------------------------
;2*3gBCDfR[h
;<d0.l:$WWXXYYZZ
;>d0.l:$WW<<24|x<<16|y<<8|z
;	8rbg͕ωȂ
;	x,y,z̍ől͐̂Ƃ9*10+9=99ÂُƂ15*10+15=165
;>ccr:pl=,mi=ُ
decode3bcd:
	push	d1-d4/d7
	moveq.l	#0,d7			;d7.l:0=,-1=ُ
	moveq.l	#10,d4			;d4.l:10
	moveq.l	#3-1,d3			;d3.w:2,1,0
	for	d3
		moveq.l	#$0F,d1
		and.b	d0,d1			;d1.b:4bit
		lsr.b	#4,d0			;d0.b:4bit
		ifor	<cmp.b d4,d1>,hs,<cmp.b d4,d0>,hs	;4bit10ȏ܂͏4bit10ȏ
			moveq.l	#-1,d7			;ُ
		endif
		move.b	d0,d2			;d2.b:4bit
		lsl.b	#2,d0			;d0.b:4bit*4
		add.b	d2,d0			;d0.b:4bit*5
		add.b	d0,d0			;d0.b:4bit*10
		add.b	d1,d0			;d0.b:4bit*10+4bit
		ror.l	#8,d0			;$ZZ,$YY,$XX̏
	next
	ror.l	#8,d0			;$WW͂̂܂
	tst.l	d7
	pop
	rts


;----------------------------------------------------------------
;n[hfBXNC^[tFCX̎ނ\
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0/a0-a1
ipl_message_hd_type:
	lea.l	100f(pc),a1		;'Built-in Hard Disk Interface'
	bsr	print_left_column
	movea.l	a6,a0			;obt@
	lea.l	101f(pc),a1		;'SASI'
	if	<isSASI>,ne
		lea.l	102f(pc),a1		;'SCSI'
	endif
	bsr	strcpy
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Built-in Hard Disk Interface',0
101:	.dc.b	'SASI',0
102:	.dc.b	'SCSI',0
	.even

;----------------------------------------------------------------
;NfoCX\
;	SRAM_ROM_BOOT_HANDLE	ROMNnh
;	SRAM_SRAM_BOOT_ADDRESS	SRAMNAhX
;	SRAM_BOOT_DEVICE	NfoCXB$0000=STD,$8xxx=HD,$9xxx=FD,$Axxx=ROM,$Bxxx=SRAM
;		$0000	STD
;		$8xxx	HD n
;		$9xxx	FD n
;		$A000	ROM $xxxxxxxx
;			$00E9F020	XEiJ HFS
;			$00EA0020-	Expansion SCSI n
;			$00EA9000-	PhantomX VDISK n
;			$00FC0000-	Built-in SCSI n
;		$B000	SRAM $xxxxxxxx
;<d7.l:MPUXe[^X
;<a6.l:obt@
;?d0-d1/a0-a1
ipl_message_boot_device:
	lea.l	100f(pc),a1		;'Boot Device'
	bsr	print_left_column
	movea.l	a6,a0			;obt@
	move.w	SRAM_BOOT_DEVICE,d0	;NfoCX
	if	eq			;$0000
		lea.l	101f(pc),a1		;'STD'
		bsr	strcpy
	elifor	<cmp.w #$8000,d0>,lo,<cmp.w #$C000,d0>,hs
		lea.l	102f(pc),a1		;'Unknown $'
		bsr	h4tos
	elif	<cmp.w #$9000,d0>,lo	;$8xxx
		lea.l	103f(pc),a1		;'SASI HD '
		bsr	strcpy
		lsr.w	#8,d0
		moveq.l	#$0F,d1
		and.l	d1,d0
		bsr	utos
	elif	<cmp.w #$A000,d0>,lo	;$9xxx
		lea.l	104f(pc),a1		;'FD '
		bsr	strcpy
		lsr.w	#8,d0
		moveq.l	#$07,d1
		and.l	d1,d0
		bsr	utos
	elif	<cmp.w #$B000,d0>,lo	;$Axxx
		move.l	SRAM_ROM_BOOT_HANDLE,d0	;ROMNnh
		moveq.l	#3,d1
		and.w	d0,d1
		if	<cmp.l #$00E9F020,d0>,eq
			lea.l	105f(pc),a1		;'XEiJ HFS'
			bsr	strcpy
		elifand	<cmp.l #$00EA0020,d0>,hs,<cmp.l #$00EA0020+4*8,d0>,lo,<tst.l d1>,eq
			lea.l	106f(pc),a1		;'Expansion SCSI '
			bsr	strcpy
			lsr.w	#2,d0
			moveq.l	#7,d1
			and.l	d1,d0
			bsr	utos
		elifand	<cmp.l #$00EA9000,d0>,hs,<cmp.l #$00EA9000+4*8,d0>,lo,<tst.l d1>,eq
			lea.l	107f(pc),a1		;'PhantomX VDISK '
			bsr	strcpy
			lsr.w	#2,d0
			moveq.l	#7,d1
			and.l	d1,d0
			bsr	utos
		elifand	<cmp.l #$00FC0000,d0>,hs,<cmp.l #$00FC0000+4*8,d0>,lo,<tst.l d1>,eq
			lea.l	108f(pc),a1		;'Built-in SCSI '
			bsr	strcpy
			lsr.w	#2,d0
			moveq.l	#7,d1
			and.l	d1,d0
			bsr	utos
		else
			lea.l	109f(pc),a1		;'ROM $'
			bsr	strcpy
			bsr	h8tos
		endif
	else				;$Bxxx
		lea.l	110f(pc),a1		;'SRAM $'
		bsr	strcpy
		move.l	SRAM_SRAM_BOOT_ADDRESS,d0	;SRAMNAhX
		bsr	h8tos
	endif
	bsr	crlf
	movea.l	a6,a1			;obt@
	goto	iocs_21_B_PRINT

100:	.dc.b	'Boot Device',0
101:	.dc.b	'STD',0
102:	.dc.b	'Unknown $',0
103:	.dc.b	'SASI HD ',0
104:	.dc.b	'FD ',0
105:	.dc.b	'XEiJ HFS',0
106:	.dc.b	'Expansion SCSI ',0
107:	.dc.b	'PhantomX VDISK ',0
108:	.dc.b	'Built-in SCSI ',0
109:	.dc.b	'ROM $',0
110:	.dc.b	'SRAM $',0
	.even



;----------------------------------------------------------------
;	SHARPS
;	ύXO
;		00FF0EC0 43FA04CA		lea.l	$00FF138C(pc),a1	;SHARPS
;		00FF0EC4 343C0000		move.w	#$0000,d2
;		00FF0EC8
;----------------------------------------------------------------
	PATCH_DATA	sharp_logo,$00FF0EC0,$00FF0EC7,$43FA04CA
	lea.l	$00FFD680,a1
	clr.w	d2



;----------------------------------------------------------------
;	s
;		NbN\[`A6WX^̍ŏʃoCgj󂳂
;		https://stdkmd.net/bugsx68k/#rom_clocka6
;	ύXO
;		00000F0C 4E56FFFC         	link.w	a6,#-4
;		00000F10 1D7C00000000     	move.b	#$00,$0000.w(a6)
;----------------------------------------------------------------



;----------------------------------------------------------------
;	s
;		C9MB̂ƂN19MBƕ\
;	ύXO
;		00000FD4 6A0A_00000FE0    	bpl	~FF0FE0			;9MBȏ
;----------------------------------------------------------------



;----------------------------------------------------------------
;	N
;		N炷FMhCo듮삷邱ƂsC
;		https://stdkmd.net/bugsx68k/#rom_chime
;		ÑL[R[hύXł悤ɂ
;----------------------------------------------------------------
	PATCH_DATA	play_stupsnd,$00FF10D8,$00FF118F,$4A3900ED

CH	equ	0

KC	equ	76
KF	equ	5
TM	equ	2500/100

FLCON	equ	(1<<3)|3		;|FL###|CON###|
SLOT	equ	%1101			;|C2|M2|C1|M1|
WAVE	equ	0
SYNC	equ	1
SPEED	equ	0
PMD	equ	0
AMD	equ	0
PMS	equ	0
AMS	equ	0
PAN	equ	%11			;|R|L|

M1AR	equ	6
M1D1R	equ	11
M1D2R	equ	4
M1RR	equ	4
M1D1L	equ	0
M1TL	equ	29
M1KS	equ	0
M1MUL	equ	0
M1DT1	equ	0
M1DT2	equ	3
M1AMSEN	equ	1

C1AR	equ	31
C1D1R	equ	6
C1D2R	equ	0
C1RR	equ	2
C1D1L	equ	2
C1TL	equ	40
C1KS	equ	2
C1MUL	equ	1
C1DT1	equ	0
C1DT2	equ	3
C1AMSEN	equ	1

M2AR	equ	3
M2D1R	equ	2
M2D2R	equ	7
M2RR	equ	2
M2D1L	equ	3
M2TL	equ	28
M2KS	equ	1
M2MUL	equ	3
M2DT1	equ	0
M2DT2	equ	1
M2AMSEN	equ	1

C2AR	equ	31
C2D1R	equ	21
C2D2R	equ	6
C2RR	equ	4
C2D1L	equ	2
C2TL	equ	2
C2KS	equ	1
C2MUL	equ	1
C2DT1	equ	0
C2DT2	equ	0
C2AMSEN	equ	1

play_stupsnd:
	push	d0-d4/a0
	move.b	SRAM_STARTUP_SOUND,d3	;0=off,1..255=on,2..127=kc
	if	ne			;on
		moveq.l	#$08,d1			;KeyOff
		moveq.l	#(0<<3)|CH,d2		;|-|C2|M2|C1|M1|CH###|
		bsr	stupsnd_opmset
		lea.l	stupsnd_data(pc),a0	;WX^f[^̔z
		moveq.l	#$20+CH,d1		;WX^AhX
		moveq.l	#28-1,d4		;0..27
		for	d4
			move.b	(a0)+,d2		;WX^f[^
			ifand	<cmp.b #$28+CH,d1>,eq,<cmp.b #2,d3>,ge	;2..127=kcBL[R[hw肳Ă
				move.b	d3,d2
			endif
			bsr	stupsnd_opmset
			addq.b	#8,d1			;̃WX^AhX
		next
		moveq.l	#6-1,d4			;28..39
		for	d4
			move.b	(a0)+,d1		;WX^AhX
			move.b	(a0)+,d2		;WX^f[^
			bsr	stupsnd_opmset
		next
		moveq.l	#$08,d1			;KeyOn
		moveq.l	#(SLOT<<3)|CH,d2	;|-|C2|M2|C1|M1|CH###|
		bsr	stupsnd_opmset
		moveq.l	#0,d0
		move.w	(a0)+,d0		;40..41Btm@100us
		add.l	d0,d0			;tm@50us
		jsr	wait_50us		;50usPʂ̃EFCg
	;	moveq.l	#$08,d1			;KeyOff
		moveq.l	#(0<<3)|CH,d2		;|-|C2|M2|C1|M1|CH###|
		bsr	stupsnd_opmset
	endif
	pop
	rts

stupsnd_opmset:
	IOCS	_OPMSET
	rts

;WX^f[^(42oCg)BAhXɔzu邱
	.even
stupsnd_data:
  .ifdef STUPSNDDAT
	.insert	stupsnd.dat
  .else
	.dc.b	(PAN<<6)|FLCON		;0 $20+CH |PAN##|FL###|CON###|
	.dc.b	KC			;1 $28+CH |-|KC#######|
	.dc.b	KF<<2			;2 $30+CH |KF######|--|
	.dc.b	(PMS<<4)|AMS		;3 $38+CH |-|PMS###|--|AMS##|
	.dc.b	(M1DT1<<4)|M1MUL	;4 $40+CH M1 |-|DT1###|MUL####|
	.dc.b	(M2DT1<<4)|M2MUL	;5 $48+CH M2
	.dc.b	(C1DT1<<4)|C1MUL	;6 $50+CH C1
	.dc.b	(C2DT1<<4)|C2MUL	;7 $58+CH C2
	.dc.b	M1TL			;8 $60+CH M1 |-|TL#######|
	.dc.b	M2TL			;9 $68+CH M2
	.dc.b	C1TL			;10 $70+CH C1
	.dc.b	C2TL			;11 $78+CH C2
	.dc.b	(M1KS<<6)|M1AR		;12 $80+CH M1 |KS##|-|AR#####|
	.dc.b	(M2KS<<6)|M2AR		;13 $88+CH M2
	.dc.b	(C1KS<<6)|C1AR		;14 $90+CH C1
	.dc.b	(C2KS<<6)|C2AR		;15 $98+CH C2
	.dc.b	(M1AMSEN<<7)|M1D1R	;16 $A0+CH M1 |AMSEN|--|D1R#####|
	.dc.b	(M2AMSEN<<7)|M2D1R	;17 $A8+CH M2
	.dc.b	(C1AMSEN<<7)|C1D1R	;18 $B0+CH C1
	.dc.b	(C2AMSEN<<7)|C2D1R	;19 $B8+CH C2
	.dc.b	(M1DT2<<6)|M1D2R	;20 $C0+CH M1 |DT2##|-|D2R#####|
	.dc.b	(M2DT2<<6)|M2D2R	;21 $C8+CH M2
	.dc.b	(C1DT2<<6)|C1D2R	;22 $D0+CH C1
	.dc.b	(C2DT2<<6)|C2D2R	;23 $D8+CH C2
	.dc.b	(M1D1L<<4)|M1RR		;24 $E0+CH M1 |D1L####|RR####|
	.dc.b	(M2D1L<<4)|M2RR		;25 $E8+CH M2
	.dc.b	(C1D1L<<4)|C1RR		;26 $F0+CH C1
	.dc.b	(C2D1L<<4)|C2RR		;27 $F8+CH C2
	.dc.b	$18,SPEED		;28,29 $18 |LFRQ########|
	.dc.b	$19,(0<<7)|AMD		;30,31 $19 |0|AMD#######|
	.dc.b	$19,(1<<7)|PMD		;32,33 $19 |1|PMD#######|
	.dc.b	$1B,WAVE		;34,35 $1B |CT1|CT2|----|WAVE##|
	.dc.b	$01,SYNC<<1		;36,37 $01 |------|LFORESET|-|
	.dc.b	$01,0<<1		;38,39 $01 |------|LFORESET|-|
	.dc.w	TM			;40,41 tm@100us
					;42
	.even
  .endif



;----------------------------------------------------------------
;	s
;		NbZ[WMemory Managiment Unit̃XyԈĂ
;		https://stdkmd.net/bugsx68k/#rom_mmu
;	΍
;		Memory Management Unit
;	ύXO
;		00001254 4D656D6F7279204D 	.dc.b	'Memory Managiment Unit(MMU) : On-Chip MMU',$0D,$0A,$00
;		         616E6167696D656E 
;		         7420556E6974284D 
;		         4D5529203A204F6E 
;		         2D43686970204D4D 
;		         550D0A00         
;----------------------------------------------------------------



;----------------------------------------------------------------
;	TRAP#14(G[\)
;		uG[܂BZbgĂBvł͕ȂG[̓e\
;	ύXO
;		00FF1458 41FAF364		lea.l	$00FF07BE(pc),a0	;TRAP#14(G[\)
;		00FF145C 21C800B8		move.l	a0,OFFSET_TRAP_14.w
;----------------------------------------------------------------
	PATCH_DATA	trap14,$00FF1458,$00FF145F,$41FAF364
	move.l	#trap14,OFFSET_TRAP_14.w
	PATCH_TEXT
;<d7.w:G[ԍ
;	$00xx	`O
;	$01xx	`IOCSR[
;	$301F	NMI
;	$7009	v^ItC
;<a6.l:SR̈ʒuB$7009̂ƂZbgȂ
trap14:
;obt@mۂ
	lea.l	-128(sp),sp		;obt@
;G[bZ[W
;	Bus error on writing to $XXXXXXXX at $XXXXXXXX
;	Bus error on reading from $XXXXXXXX at $XXXXXXXX
;	Address error on writing to $XXXXXXXX at $XXXXXXXX
;	Address error on reading from $XXXXXXXX at $XXXXXXXX
;	Error $XXXX at $XXXXXXXX
	movea.l	sp,a0			;obt@
	bsr	start_proportional
	move.b	#' ',(a0)+
	move.b	#' ',(a0)+
	moveq.l	#-2,d0
	and.w	d7,d0
	subq.w	#2,d0
	if	eq			;oXG[ƃAhXG[
		move.b	BIOS_MPU_TYPE.w,d0
		if	eq			;68000
		;	MC68000UM 6-17
		;	0.w
		;	  15-5 4   3   2-0
		;	  X    R/W I/N FC
		;	  R/W  0=Write,1=Read
		;	  I/N  0=Instruction,1=Not
		;	2.l  ACCESS ADDRESS
		;	6.w  INSTRUCTION REGISTER
		;	8.w  STATUS REGISTER
		;	10.l  PROGRAM COUNTER
			moveq.l	#$10,d0
			and.b	1-8(a6),d0		;0=Write,̑=Read
			movea.l	2-8(a6),a2		;Address
		elif	<subq.b #1,d0>,eq	;68010
		;	MC68000UM 6-18
		;	0.w  STATUS REGISTER
		;	2.l  PROGRAM COUNTER
		;	6.w  FORMAT $A VECTOR OFFSET
		;	8.w  SPECIAL STATUS WORD
		;	  15 14 13 12 11 10 9  8  7-3 2-0
		;	  RR X  IF DF RM HB BY RW X   FC
		;	  RW  0=Write,1=Read
		;	10.l  FAULT ADDRESS
		;	14.w  UNUSED, RESERVED
		;	16.w  DATA OUTPUT BUFFER
		;	18.w  UNUSED, RESERVED
		;	20.w  DATA INPUT BUFFER
		;	22.w  UNUSED, RESERVED
		;	24.w  INSTRUCTION INPUT BUFFER
		;	26.w  VERSION NUMBER INTERNAL INFORMATION, 16 WORDS
		;	58oCgBۂɏ܂̂52oCg
			moveq.l	#$01,d0
			and.b	8(a6),d0		;0=Write,̑=Read
			movea.l	10(a6),a2		;Address
		elif	<subq.b #4-1,d0>,lo	;68020/68030
		;68020/68030
		;	MC68020UM 6-23/MC68030UM 8-28
		;	10.w  SPECIAL STATUS WORD
		;	  15 14 13 12 11-9 8  7  6  5-4  3 2-0
		;	  FC FB RC RB X    DF RM RW SIZE X FC
		;	  RW  0=Write,1=Read
		;	16.l  DATA CYCLE FAULT ADDRESS
			moveq.l	#$40,d0
			and.b	11(a6),d0		;0=Write,̑=Read
			movea.l	16(a6),a2		;Address
		elif	eq			;68040
		;	MC68040UM 8-24
		;	12.w  SPECIAL STATUS WORD
		;	  15 14 13 12 11 10  9  8  7 6-5  4-3 2-0
		;	  CP CU CT CM MA ATC LK RW X SIZE TT  TM
		;	  RW  0=Write,1=Read
		;	20.l  FAULT ADDRESS
			moveq.l	#$01,d0
			and.b	12(a6),d0		;0=Write,̑=Read
			movea.l	20(a6),a2		;Address
		elif	<cmp.w #2,d7>,eq	;68060̃oXG[
		;	MC68060UM 8-21
		;	8.l  FAULT ADDRESS
		;	12.l  FAULT STATUS LONG WORD
		;	  31-28 27 26 25 24-23 22-21 20-19 18-16 15 14  13  12  11  10 9  8  7  6   5  4  3   2   1 0
		;	  X     MA X  LK RW    SIZE  TT    TM    IO PBE SBE PTA PTB IL PF SP WP TWE RE WE TTR BPE X SEE
		;	  RW  00=Undefined,Reserved,01=Write,10=Read,11=Read-Modify-Write
		;	  SIZE  00=Byte,01=Word,10=Long,11=Double Precision or MOVE16
			moveq.l	#$01,d0
			and.b	12(a6),d0		;0=Write,̑=Read
			if	ne			;Read or Read-Modify-Write
				ifand	<tst.b 13(a6)>,mi,<btst.b #4,15(a6)>,ne	;Read-Modify-Write and Bus Error on Write
					moveq.l	#0,d0		;0=Write,̑=Read
				endif
			endif
			movea.l	8(a6),a2		;Address
		else				;68060̃AhXG[
		;	MC68060UM 8-7
		;	8.l  FAULT ADDRESS
			moveq.l	#1,d0			;Read
			movea.l	8(a6),a2		;Address
			addq.l	#1,a2			;bit00ɂȂĂ̂1ɖ߂
		endif
		lea.l	101f(pc),a1		;'Bus'
		subq.w	#2,d7
		if	ne
			lea.l	102f-101f(a1),a1	;'Address'
		endif
		bsr	strcpy
		lea.l	103f(pc),a1		;' error on '
		bsr	strcpy
		lea.l	104f(pc),a1		;'writing to $'
		if	<tst.b d0>,ne
			lea.l	105f-104f(a1),a1	;'reading from $'
		endif
		bsr	strcpy
		move.l	a2,d0
		bsr	h8tos			;XXXXXXXX
	elif	<cmp.w #12,d7>,lo		;4`11
		PATCH_lea	sysstat,trap14_message,a1
		move.w	d7,d0
		add.w	d0,d0
		adda.w	-2*4(a1,d0.w),a1
		bsr	strcpy
	elif	<cmp.w #$301F,d7>,eq		;NMI
		lea.l	106f(pc),a1		;'NMI'
		bsr	strcpy
	else				;̑`OƖ`IOCSR[
		lea.l	107f(pc),a1		;'Error $'
		bsr	strcpy
		move.w	d7,d0
		bsr	h4tos			;XXXX
	endif
	if	<cmp.w #$7009,d7>,ne
		lea.l	108f(pc),a1		;' at $'
		bsr	strcpy
		move.l	2(a6),d0		;PC
		bsr	h8tos
	endif
	bsr	end_proportional
	bsr	crlf
;G[bZ[W\
	movea.l	sp,a1
	bsr	iocs_21_B_PRINT
;obt@J
	lea.l	128(sp),sp
;ɒ~
;	L[͂҂ɃZbg҂ɂ
10:	IOCS	_ABORTJOB
	goto	10b			;[v

101:	.dc.b	'Bus',0
102:	.dc.b	'Address',0
103:	.dc.b	' error on ',0
104:	.dc.b	'writing to $',0
105:	.dc.b	'reading from $',0
106:	.dc.b	'NMI',0
107:	.dc.b	'Error $',0
108:	.dc.b	' at $',0
	.even



;----------------------------------------------------------------
;	IOI HDCINTxN^̐ݒ
;		̂܂܁BIPLROM 1.2IPLROM 1.3œBSPCINTƂ͊֌WȂ
;	ύXO
;		000017FC 047E             	.dc.w	~FF1C76-~FF17F8		;[$0188.w].l:[$0062]:HDCINT n[hfBXÑXe[^X荞
;		00001C76 4E73             	rte
;----------------------------------------------------------------



;----------------------------------------------------------------
;	DMAC 1̏
;		̂܂܁BIPLROM 1.2IPLROM 1.3œ
;	ύXO
;		0000180A 4480             	.dc.b	$00E84044-$00E84000,$80	;[$00E84044].b:DMA 1 DCR(XRM##|DTYP##|DPS|-|PCL##)
;		0000180C 4604             	.dc.b	$00E84046-$00E84000,$04	;[$00E84046].b:DMA 1 SCR(----|MAC##|DAC##)
;		0000180E 6905             	.dc.b	$00E84069-$00E84000,$05	;[$00E84069].b:DMA 1 MFC
;		00001810 6D02             	.dc.b	$00E8406D-$00E84000,$02	;[$00E8406D].b:DMA 1 CPR
;		00001812 7105             	.dc.b	$00E84071-$00E84000,$05	;[$00E84071].b:DMA 1 DFC
;----------------------------------------------------------------



;----------------------------------------------------------------
;	DMAC 1 DAȐ
;		SASI@̂ƂHDC_DATAݒ肷
;		SCSI@̂Ƃ폜BIPLROM 1.3͖ӖȒlݒ肵Ă
;	ύXO
;		00001788 237A7BB2_0000933C	move.l	spc_base_handle(pc),DMAC_DAR+DMAC_1_BASE-DMAC_0_BASE(a1)
;		         0054             
;----------------------------------------------------------------
	PATCH_DATA	p1788,$00FF1788,$00FF1788+5,$237A7BB2
	jsr	p1788
	PATCH_TEXT
p1788:
	if	<tst.b BIOS_BUILTIN_SCSI.w>,eq	;SASI@
		move.l	#HDC_DATA,DMAC_DAR+DMAC_1_BASE-DMAC_0_BASE(a1)
	else				;SCSI@
		clr.l	DMAC_DAR+DMAC_1_BASE-DMAC_0_BASE(a1)
	endif
	rts



;----------------------------------------------------------------
;	SASI|[g܂SCSI|[g̏
;		SASI@̂ƂSASI|[g
;		SCSI@ŊgSCSIȂƂSCSIINROMscsi_init_routineĂяo
;	ύXO
;		000017D6 70F5             	moveq.l	#_SCSIDRV,d0
;		000017D8 7200             	moveq.l	#_S_RESET,d1
;		000017DA 4E4F             	trap	#15
;----------------------------------------------------------------
	PATCH_DATA	p17D6,$00FF17D6,$00FF17D6+5,$70F57200
	jsr	p17d6
	PATCH_TEXT
p17d6:
	push	d0-d1/a0-a1
	if	<tst.b BIOS_BUILTIN_SCSI.w>,eq	;SASI@
	;SASI|[g
		do
			break	<tst.l BIOS_ALARM_MINUTE.l>,ne
		while	<cmpi.w #6000-100*1,BIOS_TC_MINUTE_COUNTER.l>,cc	;N1b܂ő҂
		move.w	#$8000,d1
		do
			suba.l	a1,a1
			IOCS	_B_DSKINI
			if	<cmpi.w #100*30,BIOS_TC_MINUTE_COUNTER.l>,cc	;N30b܂ł
				redo	<cmp.b #$04,d0>,eq	;$04ŃgC
			endif
			break	<tst.b d0>,ne
			add.w	#$0100,d1
		while	<cmp.w #$9000,d1>,ne
	else				;SCSI@
		lea.l	$00EA0044,a0		;'SCSIEX'
		bsr	read_long
		if	<cmp.l #'SCSI',d0>,eq
			bsr	read_word
			goto	<cmp.w #'EX',d0>,eq,@f	;gSCSI
		endif
	;gSCSIȂ
	;SCSIINROMscsi_init_routineĂяo
		movea.l	$00FC0020,a1		;scsi_init_handle
		jsr	(a1)
	@@:
	endif
	pop
	rts



;----------------------------------------------------------------
;	s
;		dgƎs̃vO듮삷邱Ƃ
;		https://stdkmd.net/bugsx68k/#rom_dentakud3
;	ύXO
;		00FF3BFC 48E76000               movem.l	d1-d2,-(sp)
;		00FF3C00
;----------------------------------------------------------------
	PATCH_DATA	dentaku_d3_1st,$00FF3BFC,$00FF3BFF,$48E76000
	movem.l	d1-d3,-(sp)
;----------------------------------------------------------------
;	ύXO
;		00FF3C16 4CDF0006               movem.l	(sp)+,d1-d2
;		00FF3C1A
;----------------------------------------------------------------
	PATCH_DATA	dentaku_d3_2nd,$00FF3C16,$00FF3C19,$4CDF0006
	movem.l	(sp)+,d1-d3
;----------------------------------------------------------------
;	ύXO
;		00FF3C1C 4CDF0006               movem.l	(sp)+,d1-d2
;		00FF3C20
;----------------------------------------------------------------
	PATCH_DATA	dentaku_d3_3rd,$00FF3C1C,$00FF3C1F,$4CDF0006
	movem.l	(sp)+,d1-d3
;----------------------------------------------------------------
;	ύXO
;		00FF3C5A 48E76000               movem.l	d1-d2,-(sp)
;		00FF3C5E
;----------------------------------------------------------------
	PATCH_DATA	dentaku_d3_4th,$00FF3C5A,$00FF3C5D,$48E76000
	movem.l	d1-d3,-(sp)
;----------------------------------------------------------------
;	ύXO
;		00FF3C76 4CDF0006               movem.l	(sp)+,d1-d2
;		00FF3C7A
;----------------------------------------------------------------
	PATCH_DATA	dentaku_d3_5th,$00FF3C76,$00FF3C79,$4CDF0006
	movem.l	(sp)+,d1-d3



;----------------------------------------------------------------
;	s
;		J[\ʂ̍ŉsɂƓd삪ʊOɕ\
;		https://stdkmd.net/bugsx68k/#rom_dentaku64
;	΍
;		d̕\ʒu߂鏈YW𒲐R[hǉ
;		OɂdOFF[`l߂ĂłԂYW𒲐R[hłĂяo
;	ύXO
;		00FF4444 3F00                   move.w	d0,-(sp)
;		00FF4446 3F3C0010               move.w	#$0010,-(sp)
;		00FF444A 3F3C00B8               move.w	#$00B8,-(sp)
;		00FF444E 3F380BFE               move.w	BIOS_DEN_Y.w,-(sp)	;d\YW
;		00FF4452 3F380BFC               move.w	BIOS_DEN_X.w,-(sp)	;d\XW
;		00FF4456 3F3C0002               move.w	#$0002,-(sp)
;		00FF445A 61002368               bsr.w	$00FF67C4		;_TXFILLs
;		00FF445E 4FEF000C               lea.l	$000C(sp),sp
;		00FF4462 4267                   clr.w	-(sp)
;		00FF4464 3F3C0010               move.w	#$0010,-(sp)
;		00FF4468 3F3C00B8               move.w	#$00B8,-(sp)
;		00FF446C 3F380BFE               move.w	BIOS_DEN_Y.w,-(sp)	;d\YW
;		00FF4470 3F380BFC               move.w	BIOS_DEN_X.w,-(sp)	;d\XW
;		00FF4474 3F3C0003               move.w	#$0003,-(sp)
;		00FF4478 6100234A               bsr.w	$00FF67C4		;_TXFILLs
;		00FF447C 4FEF000C               lea.l	$000C(sp),sp
;		00FF4480 301F                   move.w	(sp)+,d0
;		00FF4482 6704                   beq.s	$00FF4488
;		00FF4484 610065D6               bsr.w	$00FFAA5C		;IOCS _MS_CURON
;		00FF4488 4CDF7FFE               movem.l	(sp)+,d1-d7/a0-a6
;		00FF448C 4E75                   rts
;		00FF448E
;----------------------------------------------------------------
	PATCH_DATA	dentaku64_1st,$00FF4444,$00FF448D,$3F003F3C
;dOFF
	move.w	d0,-(sp)
	move.l	#184<<16|16,-(sp)
	move.l	BIOS_DEN_X.w,-(sp)	;d\XWBBIOS_DEN_Y d\YW
	move.w	#2,-(sp)
	bsr	($00FF67C4)PATCH_ZL	;_TXFILLs
	clr.w	10(sp)
	addq.w	#1,(sp)			;3
	bsr	($00FF67C4)PATCH_ZL	;_TXFILLs
	lea.l	12(sp),sp
	move.w	(sp)+,d0
	if	ne
		bsr	($00FFAA5C)PATCH_ZL	;IOCS _MS_CURON
	endif
	movem.l	(sp)+,d1-d7/a0-a6
	rts

dentaku64:
	addq.w	#1,d1			;J[\̎̍s
	ifand	<cmp.w #32,d1>,hs,<cmp.w BIOS_CONSOLE_BOTTOM.w,d1>,hi	;32ȏォR\[͈̔͊O
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;R\[̍ŉs
		if	ne			;R\[2sȏ゠
			subq.w	#1,d1			;R\[̉2Ԗڂ̍s
		endif
	endif
	rts
;----------------------------------------------------------------
;	ύXO
;		00FF44A6 5241                   addq.w	#1,d1			;J[\̎̍s
;		00FF44A8 E941                   asl.w	#4,d1
;----------------------------------------------------------------
	PATCH_DATA	dentaku64_2nd,$00FF44A6,$00FF44A7,$5241E941
	PATCH_bsr	dentaku64_1st,dentaku64



;----------------------------------------------------------------
;	s
;		\tgL[{[h́L[̑ܕĂȂ
;		https://stdkmd.net/bugsx68k/#rom_softkeyboard
;	ύXO
;		00005AA8 2B80             	.dc.b	__M_M_MM,M_______
;----------------------------------------------------------------
	PATCH_DATA	softkeyboard,$00FF5AA8,$00FF5AA9,$2B800A00
	.dc.b	__MMM_MM,M_______



;----------------------------------------------------------------
;	s
;		_DEFCHRŃtHgTCY0w肳ꂽƂ8ɓǂݑւ鏈R[h0̂Ƃ@\ĂȂ
;		_DEFCHRŃtHgTCY6włȂ
;		_DEFCHR_FNTADRtHgp^[BIOS_FNTADR_BUFFER.wɍ쐬ĕԂƂɏ㏑ĂۑȂ̂ɃG[ɂȂȂ
;		_DEFCHRŃtHgAhXX68030̃nC060turbõ[JwĂROMƌFăG[ɂȂ
;	ύXO
;		00FF6ADA 70FF                   moveq.l	#$FF,d0
;		00FF6ADC 48E76040               movem.l	d1-d2/a1,-(sp)
;		00FF6AE0 2401                   move.l	d1,d2
;		00FF6AE2 4842                   swap.w	d2
;		00FF6AE4 6604                   bne.s	$00FF6AEA
;		00FF6AE6 343C0008               move.w	#$0008,d2
;		00FF6AEA B47C0006               cmp.w	#$0006,d2
;		00FF6AEE 6722                   beq.s	$00FF6B12
;		00FF6AF0 20780458               movea.l	$0458.w,a0		;[$0458.w].l:[$0116]_FNTADR
;		00FF6AF4 4E90                   jsr	(a0)
;		00FF6AF6 2040                   movea.l	d0,a0
;		00FF6AF8 70FF                   moveq.l	#$FF,d0
;		00FF6AFA B1FC00F00000           cmpa.l	#$00F00000,a0		;ROMȂLZ
;		00FF6B00 6410                   bcc.s	$00FF6B12
;		00FF6B02 5242                   addq.w	#1,d2
;		00FF6B04 5241                   addq.w	#1,d1
;		00FF6B06 C4C1                   mulu.w	d1,d2
;		00FF6B08 5342                   subq.w	#1,d2
;		00FF6B0A 10D9                   move.b	(a1)+,(a0)+
;		00FF6B0C 51CAFFFC               dbra.w	d2,$00FF6B0A
;		00FF6B10 4280                   clr.l	d0
;		00FF6B12 4CDF0206               movem.l	(sp)+,d1-d2/a1
;		00FF6B16 4E75                   rts
;		00FF6B18
;----------------------------------------------------------------
	PATCH_DATA	defchr,$00FF6ADA,$00FF6B17,$70FF48E7
;----------------------------------------------------------------
;IOCSR[$0F _DEFCHR tHgp^[ݒ
;<d1.l:tHgTCY<<16|R[h
;	tHgTCY
;		0,8	8x16,16x16
;		12,24	12x24,24x24
;<a1.l:tHgp^[̐擪AhX
;>d0.l:0=I,-1=G[
iocs_0F_DEFCHR:
	push	d1/d2/a0/a1
	move.l	d1,d2
	swap.w	d2
	movea.l	4*($100+_FNTADR).w,a0	;IOCSR[$16 _FNTADR tHgAhX̎擾
	jsr	(a0)
;<d0.l:tHgAhX
;<d1.w:̃oCg-1
;<d2.w:c̃hbg-1
	movea.l	d0,a0			;tHgAhX
	moveq.l	#-1,d0
;tHgAhXROMwĂƂ͏㏑łȂ̂Ŏs
	ifor	<cmpa.l #$00F00000,a0>,lo,<cmpa.l #$01000000,a0>,hs
	;tHgAhXBIOS_FNTADR_BUFFER.wwĂƂ͏㏑ĂۑȂ̂Ŏs
		if	<cmpa.w #BIOS_FNTADR_BUFFER.w,a0>,ne
		;tHgp^[Rs[
			addq.w	#1,d1
			addq.w	#1,d2
			mulu.w	d2,d1
			subq.w	#1,d1
			for	d1
				move.b	(a1)+,(a0)+
			next
			moveq.l	#0,d0
		endif
	endif
	pop
	rts



  .if REMOVE_CRTMOD_G_CLR_ON=0

;----------------------------------------------------------------
;	_CRTMOD
;	ύXO
;		00006B18 48E77060         	movem.l	d1-d3/a1-a2,-(sp)
;			:
;		00006B8C                  iocs_10_CRTMOD:
;		00006B8C 41F900E80028     	lea.l	CRTC_MODE_RESOLUTION,a0	;[hƉ𑜓x
;			:
;		00007042 0400028001E00001 	.dc.w	1024,640,480,1
;----------------------------------------------------------------
	PATCH_DATA	crtmod,$00FF6B8C,$00FF6B91,$41F900E8
	jmp	iocs_10_CRTMOD
	PATCH_TEXT
;----------------------------------------------------------------
;IOCSR[$10 _CRTMOD ʃ[h̎擾Ɛݒ
;<d1.w:ݒ̉ʃ[h
;	$16FF	o[W̊mFB$16xxxxxx(CRT)܂$96xxxxxx(LCD)Ԃ
;	$56FF	o[W̊mFB$16xxxxxxԂ
;	$76FF	ʃ[h̍ől̊mFB$160000xxԂ
;	$43xx	CRTBSRAMɕۑB$43FFSRAM̕ύX̂
;	$4Cxx	LCDBSRAMɕۑB$4CFFSRAM̕ύX̂
;	$xxFF	擾̂
;	$01xx	Ȃ
;>d0.l:ݒỎʃ[hB-1=ݒ̉ʃ[h͈͊O,-2=gOtBbNʂȂ
;	o[W̊mF̂Ƃ$16xxxxxx܂$96xxxxxx
;	ʃ[h̍ől̊mF̂Ƃ$160000xx
;----------------------------------------------------------------
;	ʃ[h
;
;	ʃ[h	𑜓x	ʃTCY	ʃTCY	F	y[W
;	0			512x512		1024x1024	16	1
;	1			512x512		1024x1024	16	1
;	2			256x256		1024x1024	16	1
;	3			256x256		1024x1024	16	1
;	4			512x512		512x512		16	4
;	5			512x512		512x512		16	4
;	6			256x256		512x512		16	4
;	7			256x256		512x512		16	4
;	8			512x512		512x512		256	2
;	9			512x512		512x512		256	2
;	10			256x256		512x512		256	2
;	11			256x256		512x512		256	2
;	12			512x512		512x512		65536	1
;	13			512x512		512x512		65536	1
;	14			256x256		512x512		65536	1
;	15			256x256		512x512		65536	1
;	16			768x512		1024x1024	16	1
;	17			1024x424	1024x1024	16	1
;	18			1024x848	1024x1024	16	1
;	19		VGA	640x480		1024x1024	16	1
;	20			768x512		512x512		256	2
;	21			1024x424	512x512		256	2
;	22			1024x848	512x512		256	2
;	23		VGA	640x480		512x512		256	2
;	24			768x512		512x512		65536	1
;	25			1024x424	512x512		65536	1
;	26			1024x848	512x512		65536	1
;	27		VGA	640x480		512x512		65536	1
;	$100+(0`27)	Ȃ
;	-1	擾̂
;
;	ȉ͊g
;	28			384x256		1024x1024	16	1
;	29			384x256		512x512		16	4
;	30			384x256		512x512		256	2
;	31			384x256		512x512		65536	1
;	32			512x512(`)	1024x1024	16	1
;	33			512x512(`)	512x512		16	4
;	34			512x512(`)	512x512		256	2
;	35			512x512(`)	512x512		65536	1
;	36			256x256(`)	1024x1024	16	1
;	37			256x256(`)	512x512		16	4
;	38			256x256(`)	512x512		256	2
;	39			256x256(`)	512x512		65536	1
;	40			512x256		1024x1024	16	1
;	41			512x256		512x512		16	4
;	42			512x256		512x512		256	2
;	43			512x256		512x512		65536	1
;	44			512x256()	1024x1024	16	1
;	45			512x256()	512x512		16	4
;	46			512x256()	512x512		256	2
;	47			512x256()	512x512		65536	1
;	XvCg512x512
;
;	ȉ͊gOtBbNʂKv
;	0,1,2,3,16,17,18,19,28,32,36,40,44256Fɂ
;	48			512x512		1024x1024	256	1
;	49			512x512		1024x1024	256	1
;	50			256x256		1024x1024	256	1
;	51			256x256		1024x1024	256	1
;	52			768x512		1024x1024	256	1
;	53			1024x424	1024x1024	256	1
;	54			1024x848	1024x1024	256	1
;	55		VGA	640x480		1024x1024	256	1
;	56			384x256		1024x1024	256	1
;	57			512x512(`)	1024x1024	256	1
;	58			256x256(`)	1024x1024	256	1
;	59			512x256		1024x1024	256	1
;	60			512x256()	1024x1024	256	1
;	0,1,2,3,16,17,18,19,28,32,36,40,4465536Fɂ
;	61			512x512		1024x1024	65536	1
;	62			512x512		1024x1024	65536	1
;	63			256x256		1024x1024	65536	1
;	64			256x256		1024x1024	65536	1
;	65			768x512		1024x1024	65536	1
;	66			1024x424	1024x1024	65536	1
;	67			1024x848	1024x1024	65536	1
;	68		VGA	640x480		1024x1024	65536	1
;	69			384x256		1024x1024	65536	1
;	70			512x512(`)	1024x1024	65536	1
;	71			256x256(`)	1024x1024	65536	1
;	72			512x256		1024x1024	65536	1
;	73			512x256()	1024x1024	65536	1
;
;----------------------------------------------------------------
;	낢
;
;	CRTLCD
;		eʃ[h̓gꂼCRTLCDɕ
;		SRAM_XEIJSRAM_XEIJ_LCD_BIT0̂ƂCRTA1̂ƂLCD̓gŏo͂
;
;	ʃ[h17
;		24.699kHzA53.116HzA1024x424A1024x1024A16F
;		X68000ォ炠邪J
;		LCD̂Ƃ͉ʃ[h16̏㉺
;
;	ʃ[h18
;		24.699kHzA53.116HzA1024x848(C^[[X)A1024x1024A16F
;		X68000ォ炠邪J
;		LCD̂Ƃ͉ʃ[h16̏㉺ăC^[[Xɂ
;
;	ʃ[h19(VGA[h)
;		31.469kHzA59.940HzA640x480A1024x1024A16F
;		X68000 CompactŒǉꂽ
;		CRT̂Ƃ͉ʃ[h16̎͂
;		LCD̂Ƃ͂̂܂
;
;	ʃ[h20`23
;		ʃ[h16`19512x512A256FɕύX
;		X68030ŒǉꂽBJ
;
;	ʃ[h24`27
;		ʃ[h16`19512x512A65536FɕύX
;		X68030ŒǉꂽBJ
;
;	OtBbNpbg̃oO(IPLROM 1.0`1.3)
;		_CRTMODw肳ꂽʃ[hƈقȂFŃOtBbNpbg
;			https://stdkmd.net/bugsx68k/#rom_crtmod_gpalet
;		256x25616FA512x512256FAȊO65536FɂȂ
;
;	ʃ[h20`27̃oO(IPLROM 1.3)
;		ʃ[h20`27w肳ꂽƂʃ[h16`19ɂĂ256F܂65536FɕύXĂ邪A
;		̂ƂBIOS[NGẢʃ[h16`19̂܂ܕuĂ
;		_G_CLR_ONĂяoƉʃ[h16`19Ȃ̂16Fɖ߂Ă܂
;
;	NbsOGÃoO(IPLROM 1.3)
;		_CRTMODŉʃ[h22܂26ɂƃNbsOGA512x848ɂȂ
;
;	VGAIV[^̖
;		`XVIɂVGAIV[^Ȃ̂VGA[hgŏo͂Ȃ
;		VGAIV[^ꍇ
;			(50.350MHz/2)/(8*100)=31.469kHz
;			(50.350MHz/2)/(8*100*525)=59.940Hz
;		VGAIV[^Ȃꍇ
;			(69.552MHz/3)/(8*100)=28.980kHz
;			(69.552MHz/3)/(8*100*525)=55.200Hz
;		傫O킯ł͂Ȃ̂Ń}`XLj^͒Ǐ]ł邪C
;
;	VGAIV[^̗L̔
;		VGA[h̐VGAIV[^Ƃ16.683msAȂƂ18.116ms
;		荞݂̊ԂTimer-C110ms7.5msi񂾂ǂVGAIV[^̗L𔻕ʂł͂
;		ŎH
;
;----------------------------------------------------------------
;	MCRTCݒl̊֌W
;
;	HT	J
;	HS	pXJ
;	HB	obN|[`J
;	HD	fԃJ
;	HF	tg|[`J
;	VT	X^
;	VS	pXX^
;	VB	obN|[`X^
;	VD	fԃX^
;	VF	tg|[`X^
;
;	R00	HT-1=HS+HB+HD+HF-1	tg|[`IJ
;	R01	HS-1			pXIJ
;	R02	HS+HB-5			obN|[`IJ-4
;	R03	HS+HB+HD-5		fԏIJ-4
;	R04	VT-1=VS+VB+VD+VF-1	tg|[`IX^
;	R05	VS-1			pXIX^
;	R06	VS+VB-1			obN|[`IX^
;	R07	VS+VB+VD-1		fԏIX^
;
;----------------------------------------------------------------
;	IV[^ƕR20LHRL̊֌W
;
;	OSC/DIV	R20L	HRL
;	38/8	%0**00	*
;	38/4	%0**01	*
;	38/8	%0**1*	*
;	69/6	%1**00	0
;	69/8	%1**00	1
;	69/3	%1**01	0
;	69/4	%1**01	1
;	69/2	%1**10	*	XvCgs
;	50/2	%1**11	*	XvCgsBCompact
;
;----------------------------------------------------------------
;	CRTCݒl(CRT)
;
;	CRT 0/4/8/12/48/61: 512x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   91   9  17  81      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   92  10  12  64   6  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*92)=31.500kHz (69.552MHz/3)/(8*92*568)=55.458Hz
;	  64/92=0.696 512/568=0.901 (0.696/0.901)/(512/512)=0.772
;	  31k
;
;	CRT 1/5/9/13/49/62: 512x512 15.980kHz 61.463Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %00101   0   75   3   5  69      259   2  16 256     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 38.864   4   76   4   6  64   2  260   3  14 240   3 |
;	  +------------------------------------------------------+
;	  (38.864MHz/4)/(8*76)=15.980kHz (38.864MHz/4)/(8*76*260)=61.463Hz
;	  64/76=0.842 240/260=0.923 (0.842/0.923)/(512/512)=0.912
;	  15k C^[[X
;
;	CRT 2/6/10/14/50/63: 256x256 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   45   4   6  38      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   46   5   6  32   3  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*46)=31.500kHz (69.552MHz/6)/(8*46*568)=55.458Hz
;	  32/46=0.696 512/568=0.901 (0.696/0.901)/(256/256)=0.772
;	  31k X^2xǂ
;
;	CRT 3/7/11/15/51/64: 256x256 15.980kHz 61.463Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %00000   0   37   1   0  32      259   2  16 256     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 38.864   8   38   2   3  32   1  260   3  14 240   3 |
;	  +------------------------------------------------------+
;	  (38.864MHz/8)/(8*38)=15.980kHz (38.864MHz/8)/(8*38*260)=61.463Hz
;	  32/38=0.842 240/260=0.923 (0.842/0.923)/(256/256)=0.912
;	  15k
;
;	CRT 16/20/24/52/65: 768x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  28 124      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  18  96   9  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  96/138=0.696 512/568=0.901 (0.696/0.901)/(768/512)=0.514
;	  31k
;
;	CRT 17/21/25/53/66: 1024x424 24.699kHz 53.116Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  175  15  31 159      464   7  32 456     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  176  16  20 128  12  465   8  25 424   8 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*176)=24.699kHz (69.552MHz/2)/(8*176*465)=53.116Hz
;	  128/176=0.727 424/465=0.912 (0.727/0.912)/(1024/424)=0.330
;	  24k
;
;	CRT 18/22/26/54/67: 1024x848 24.699kHz 53.116Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %11010   0  175  15  31 159      464   7  32 456     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  176  16  20 128  12  465   8  25 424   8 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*176)=24.699kHz (69.552MHz/2)/(8*176*465)=53.116Hz
;	  128/176=0.727 424/465=0.912 (0.727/0.912)/(1024/848)=0.661
;	  24k C^[[X
;
;	CRT 19/23/27/55/68: 640x480 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  36 116      567   5  56 536     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  26  80  17  568   6  51 480  31 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  80/138=0.580 480/568=0.845 (0.580/0.845)/(640/480)=0.514
;	  31k
;
;	CRT 28/29/30/31/56/69: 384x256 31.963kHz 56.273Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  11  59      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7   9  48   4  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*568)=56.273Hz
;	  48/68=0.706 512/568=0.901 (0.706/0.901)/(384/256)=0.522
;	  31k X^2xǂ
;
;	CRT 32/33/34/35/57/70: 512x512 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  137  14  44 108      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  138  15  34  64  25  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*138)=31.500kHz (69.552MHz/2)/(8*138*568)=55.458Hz
;	  64/138=0.464 512/568=0.901 (0.464/0.901)/(512/512)=0.514
;	  31k
;
;	CRT 36/37/38/39/58/71: 256x256 31.963kHz 56.273Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  19  51      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7  17  32  12  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*568)=56.273Hz
;	  32/68=0.471 512/568=0.901 (0.471/0.901)/(256/256)=0.522
;	  31k X^2xǂ
;
;	CRT 40/41/42/43/44/45/46/47/59/60/72/73: 512x256 31.500kHz 55.458Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   0   91   9  17  81      567   5  40 552     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   92  10  12  64   6  568   6  35 512  15 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*92)=31.500kHz (69.552MHz/3)/(8*92*568)=55.458Hz
;	  64/92=0.696 512/568=0.901 (0.696/0.901)/(512/256)=0.386
;	  31k
;
;----------------------------------------------------------------
;	CRTCݒl(LCD)
;
;	LCD 0/4/8/12/48/61: 512x512 35.341kHz 56.546Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   81   5  11  75      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   82   6  10  64   2  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*82)=35.341kHz (69.552MHz/3)/(8*82*625)=56.546Hz
;	  64/82=0.780 512/625=0.819 (0.780/0.819)/(512/512)=0.953
;	  SVGA
;
;	LCD 1/5/9/13/49/62: 512x512 35.341kHz 56.546Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10101   0   81   5  11  75      624   1  83 563     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   82   6  10  64   2  625   2  82 480  61 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*82)=35.341kHz (69.552MHz/3)/(8*82*625)=56.546Hz
;	  64/82=0.780 480/625=0.768 (0.780/0.768)/(512/512)=1.016
;	  SVGA
;
;	LCD 2/6/10/14/50/63: 256x256 34.500kHz 55.200Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   41   2   3  35      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   42   3   5  32   2  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*42)=34.500kHz (69.552MHz/6)/(8*42*625)=55.200Hz
;	  32/42=0.762 512/625=0.819 (0.762/0.819)/(256/256)=0.930
;	  SVGA X^2xǂ
;
;	LCD 3/7/11/15/51/64: 256x256 34.500kHz 55.200Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10000   0   41   2   3  35      624   1  83 563     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   6   42   3   5  32   2  625   2  82 480  61 |
;	  +------------------------------------------------------+
;	  (69.552MHz/6)/(8*42)=34.500kHz (69.552MHz/6)/(8*42*625)=55.200Hz
;	  32/42=0.762 480/625=0.768 (0.762/0.768)/(256/256)=0.992
;	  SVGA X^2xǂ
;
;	LCD 16/20/24/52/65: 768x512 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  19 115      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 512/625=0.819 (0.774/0.819)/(768/512)=0.630
;	  SVGA
;
;	LCD 17/21/25/53/66: 768x600 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  19 115      624   1  23 623     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  22 600   1 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 600/625=0.960 (0.774/0.960)/(768/600)=0.630
;	  SVGA
;
;	LCD 18/22/26/54/67: 768x1024 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %11010   0  123   8  19 115      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  15  96   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  96/124=0.774 512/625=0.819 (0.774/0.819)/(768/1024)=1.260
;	  SVGA C^[[X
;
;	LCD 19/23/27/55/68: 640x480 31.469kHz 59.940Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10111   0   99  11  13  93      524   1  34 514     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 50.350   2  100  12   6  80   2  525   2  33 480  10 |
;	  +------------------------------------------------------+
;	  (50.350MHz/2)/(8*100)=31.469kHz (50.350MHz/2)/(8*100*525)=59.940Hz
;	  80/100=0.800 480/525=0.914 (0.800/0.914)/(640/480)=0.656
;	  VGA
;
;	LCD 28/29/30/31/56/69: 384x256 31.963kHz 51.141Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  11  59      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7   9  48   4  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*625)=51.141Hz
;	  48/68=0.706 512/625=0.819 (0.706/0.819)/(384/256)=0.574
;	  X^2xǂ
;
;	LCD 32/33/34/35/57/70: 512x512 35.056kHz 56.090Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10110   0  123   8  35  99      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   2  124   9  31  64  20  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/2)/(8*124)=35.056kHz (69.552MHz/2)/(8*124*625)=56.090Hz
;	  64/124=0.516 512/625=0.819 (0.516/0.819)/(512/512)=0.630
;	  SVGA
;
;	LCD 36/37/38/39/58/71: 256x256 31.963kHz 51.141Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   1   67   6  19  51      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   4   68   7  17  32  12  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/4)/(8*68)=31.963kHz (69.552MHz/4)/(8*68*625)=51.141Hz
;	  32/68=0.471 512/625=0.819 (0.471/0.819)/(256/256)=0.574
;	  X^2xǂ
;
;	LCD 40/41/42/43/44/45/46/47/59/60/72/73: 512x256 35.341kHz 56.546Hz
;	  +------------------------------------------------------+
;	  |   R20L HRL  R00 R01 R02 R03      R04 R05 R06 R07     |
;	  | %10001   0   81   5  11  75      624   1  67 579     |
;	  +------------------------------------------------------+
;	  |    OSC DIV   HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 69.552   3   82   6  10  64   2  625   2  66 512  45 |
;	  +------------------------------------------------------+
;	  (69.552MHz/3)/(8*82)=35.341kHz (69.552MHz/3)/(8*82*625)=56.546Hz
;	  64/82=0.780 512/625=0.819 (0.780/0.819)/(512/256)=0.476
;	  SVGA
;
;	yQlzVGA: 640x480 31.469kHz 59.940Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 25.175      100  12   6  80   2  525   2  33 480  10 |
;	  +------------------------------------------------------+
;	  25.175MHz/(8*100)=31.469kHz (25.175MHz/1)/(8*100*525)=59.940Hz
;	  80/100=0.800 480/525=0.914 (0.800/0.914)/(640/480)=0.656
;
;	yQlzSVGA: 800x600 35.156kHz 56.250Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 36.000      128   9  16 100   3  625   2  22 600   1 |
;	  +------------------------------------------------------+
;	  36.000MHz/(8*128)=35.156kHz (36.000MHz/1)/(8*128*625)=56.250Hz
;	  100/128=0.781 600/625=0.960 (0.781/0.960)/(800/600)=0.610
;
;	yQlzSVGA: 800x600 37.879kHz 60.317Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 40.000      132  16  11 100   5  628   4  23 600   1 |
;	  +------------------------------------------------------+
;	  40.000MHz/(8*132)=37.879kHz (40.000MHz/1)/(8*132*628)=60.317Hz
;	  100/132=0.758 600/628=0.955 (0.758/0.955)/(800/600)=0.595
;
;	yQlzSVGA: 800x600 46.875kHz 75.000Hz
;	  +------------------------------------------------------+
;	  |    OSC       HT  HS  HB  HD  HF   VT  VS  VB  VD  VF |
;	  | 49.500      132  10  20 100   2  625   3  21 600   1 |
;	  +------------------------------------------------------+
;	  49.500MHz/(8*132)=46.875kHz (49.500MHz/1)/(8*132*625)=75.000Hz
;	  100/132=0.758 600/625=0.960 (0.758/0.960)/(800/600)=0.592
;
;----------------------------------------------------------------

;p[^1
	.offset	0
crtmod_param_1_width:	.ds.w	1
crtmod_param_1_height:	.ds.w	1
crtmod_param_1_r20h:	.ds.b	1
			.ds.b	1
crtmod_param_1_2nd:	.ds.w	1
crtmod_param_1_size:
	.text

;p[^2
	.offset	0
crtmod_param_2_r20l:	.ds.b	1
crtmod_param_2_hrl:	.ds.b	1
crtmod_param_2_r00:	.ds.w	1
crtmod_param_2_r01:	.ds.w	1
crtmod_param_2_r02:	.ds.w	1
crtmod_param_2_r03:	.ds.w	1
crtmod_param_2_r04:	.ds.w	1
crtmod_param_2_r05:	.ds.w	1
crtmod_param_2_r06:	.ds.w	1
crtmod_param_2_r07:	.ds.w	1
crtmod_param_2_r08:	.ds.w	1
crtmod_param_2_size:
	.text

crtmod_param_1	.macro	width,height,r20h,offset2nd
	.dc.w	width
	.dc.w	height
	.dc.b	r20h			;R20H
	.dc.b	0
	.dc.w	crtmod_param_2_size*offset2nd
	.endm

crtmod_param_2	.macro	r20l,hrl,ht,hs,hb,hd,hf,vt,vs,vb,vd,vf,r08
	.fail	(ht.and.1)!=0
	.fail	ht!=hs+hb+hd+hf
	.fail	vt!=vs+vb+vd+vf
	.dc.b	r20l			;R20L
	.dc.b	hrl			;HRL
	.dc.w	hs+hb+hd+hf-1		;R00
	.dc.w	hs-1			;R01
	.dc.w	hs+hb-5			;R02
	.dc.w	hs+hb+hd-5		;R03
	.dc.w	vs+vb+vd+vf-1		;R04
	.dc.w	vs-1			;R05
	.dc.w	vs+vb-1			;R06
	.dc.w	vs+vb+vd-1		;R07
	.dc.w	r08			;R08
	.endm

crtmod_modes	equ	(crtmod_table_1_crt_end-crtmod_table_1_crt)/crtmod_param_1_size	;ʃ[h̐

iocs_10_CRTMOD:
dMM	reg	d3			;[h
dPM	reg	d4			;ݒỎʃ[h
dGVRAM	reg	d5			;$00C00000
aE8	reg	a2			;(`)E8̃x[XAhX
aEB	reg	a3			;(`)EB̃x[XAhX
aED	reg	a4			;(`)ED̃x[XAhX
aP1	reg	a5			;p[^1̃AhX
aP2	reg	a6			;p[^2̃AhX
	push	d1-d2/dMM/dPM/dGVRAM/a0-a1/aE8/aEB/aED/aP1/aP2
	move.l	#$00C00000,dGVRAM

;(`)E8ŃANZX
;	$00E80000	CRTC
;	$00E82000	VICON
;	$00E84000	DMAC
;	$00E86000	SUPERAREA
;	$00E88000	MFP
;	$00E8A000	RTC
;	$00E8C000	PRNPORT
;	$00E8E000	SYSPORT
	lea.l	$00E88000,aE8
E8	reg	-$00E88000(aE8)

;(`)EBŃANZX
;	$00EB0000	SPRC
	lea.l	$00EB8000,aEB
EB	reg	-$00EB8000(aEB)

;(`)EDŃANZX
;	$00ED0000	SRAM
	lea.l	$00ED8000,aED
ED	reg	-$00ED8000(aED)

;SRAM
	moveq.l	#$60,d0
	moveq.l	#$F0,d2
	and.b	(SRAM_XEIJ)ED,d2
	if	<cmp.b d0,d2>,ne	;ĂȂ
		move.b	#$31,(SYSPORT_SRAM)E8	;unlocksram
		move.b	d0,(SRAM_XEIJ)ED	;
		clr.b	(SYSPORT_SRAM)E8	;locksram
	endif

;o[W̊mF
	move.l	#CRTMOD_VERSION,d0
	goto	<cmp.w #$56FF,d1>,eq,@f
	if	<cmp.w #$16FF,d1>,eq
		if	<btst.b #SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED>,ne
			bset.l	#31,d0
		endif
@@:		goto	crtmod_pop
	endif

;ʃ[h̍ől̊mF
	if	<cmp.w #$76FF,d1>,eq
		move.l	#$16000000+crtmod_modes-1,d0
	;	goto	crtmod_pop
		goto	@b
	endif

;ݒỎʃ[hmF
	moveq.l	#0,dPM
	move.b	BIOS_CRTMOD.w,dPM	;ݒỎʃ[h
	swap.w	dPM
;<dPM.l:ݒỎʃ[h<<16

;邩
	move.w	d1,dPM
	clr.b	dPM
	sub.w	dPM,d1
;<d1.w:ʃ[h
;<dPM.w:$0000=,$0100=Ȃ,$4300=CRT,$4C00=LCD

;CRTLCD̃XCb`̐؂ւ
	if	<cmp.w #$4300,dPM>,eq	;CRT
		move.b	#$31,(SYSPORT_SRAM)E8	;unlocksram
		bclr.b	#SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED
		clr.b	(SYSPORT_SRAM)E8	;locksram
		clr.w	dPM			;
	elif	<cmp.w #$4C00,dPM>,eq	;LCD
		move.b	#$31,(SYSPORT_SRAM)E8	;unlocksram
		bset.b	#SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED
		clr.b	(SYSPORT_SRAM)E8	;locksram
		clr.w	dPM			;
	endif
;<dPM.w:$0000=,$0100=Ȃ

;擾݂̂
;	IPLROM 1.0`1.3$FFFF擾̂
;	ł$xxFF擾݂̂Ƃ
;	$43FF$4CFFCRTLCD̃XCb`̐؂ւs
	goto	<cmp.w #$00FF,d1>,eq,crtmod_end	;擾̂

;ݒ̉ʃ[h͈͊O
;	IPLROM 1.0`1.3$FFFFĐݒ̉ʃ[h͈͊ÔƂԂȂ
;	ł$xxFFĐݒ̉ʃ[h͈͊ÔƂ-1Ԃ
	if	<cmp.w #crtmod_modes,d1>,hs
		moveq.l	#-1,d0		;ݒ̉ʃ[h͈͊O
		goto	crtmod_pop
	endif

;ݒ肷

;p[^1̃AhX߂
	lea.l	crtmod_table_1_crt(pc),aP1
	if	<btst.b #SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED>,ne	;LCD
		lea.l	crtmod_table_1_lcd(pc),aP1
	endif
	move.w	d1,d0
  .if crtmod_param_1_size=8
	lsl.w	#3,d0
  .else
	mulu.w	#crtmod_param_1_size,d0
  .endif
	adda.w	d0,aP1
;<aP1.l:p[^1̃AhX

;p[^2̃AhX߂
	lea.l	crtmod_table_2(pc),aP2
	adda.w	crtmod_param_1_2nd(aP1),aP2
;<aP2.l:p[^2̃AhX

;[hmF
	moveq.l	#7,dMM
	and.b	crtmod_param_1_r20h(aP1),dMM	;[hB0`7
;<dMM.w:[hB0`7

;gOtBbNʂmF
;	gOtBbNʂȂ̂ɊgOtBbNʂKvȉʃ[hw肳ꂽƂ-2Ԃ
;		              76543210
	if	<btst.b dMM,#%10100000>,ne	;[h5,7BgOtBbNʂKv
		move.b	(CRTC_MODE_BYTE)E8,-(sp)	;[hۑ
		move.b	#7,(CRTC_MODE_BYTE)E8	;[h7ɕύX
		movea.l	dGVRAM,a0
		move.w	(a0),d2			;ۑ
		not.w	(a0)			;]
		move.w	(a0),d0			;d0=]Ăǂݏo
		move.w	d2,(a0)			;
		move.b	(sp)+,(CRTC_MODE_BYTE)E8	;[h𕜌
		not.w	d2			;d2=ǂݏoĂ甽]
		if	<cmp.w d2,d0>,ne	;]łĂȂ
			moveq.l	#-2,d0			;gOtBbNʂȂ
			goto	crtmod_pop
		endif
	endif

;邩
	if	<tst.w dPM>,eq

	;

	;ݒ̉ʃ[hۑ
		move.b	d1,BIOS_CRTMOD.w	;ݒ̉ʃ[h

	;OtBbNOFFAeLXgOFFAXvCgOFF
		clr.w	(VICON_VISIBLE)E8

	;eLXgJ[\OFF
		IOCS	_B_CUROFF

	;eLXgv[0`1NA
	;	X^Rs[gƑR[hȂ
	;	CRTCĂȂ̂ŃX^Rs[IȂ
		move.w	#$0133,(CRTC_ACCESS)E8	;ANZXJn
		moveq.l	#0,d0
		lea.l	$00E00000,a0		;eLXgVRAM
		move.w	#($00E20000-$00E00000)/(4*2)-1,d1	;16384
		for	d1
			move.l	d0,(a0)+
			move.l	d0,(a0)+
		next
		move.w	#$0033,(CRTC_ACCESS)E8	;ANZXI

	;OtBbNʎgps
		clr.w	BIOS_GRAPHIC_PALETS.w	;OtBbNʂ̐F-1B0=OtBbNʎgps

	;/Ȃ
		bsr	crtmod_common

	;CRTCR}h~
		clr.w	(CRTC_ACTION)E8

	;OtBbNpbg
  .ifdef CRTMOD_REPRODUCE_BUG		;oOČ
		moveq.l	#3,d0
		and.b	crtmod_param_2_r20l(aP2),d0	;𑜓xB256x256=256F,512x512=512F,768x512=65536F
  .else
		move.w	dMM,d0			;[hB0`7
  .endif
		PATCH_jsr	g_clr_on,initialize_gpalet	;OtBbNpbg

	;OtBbNXg[WON
	;	IPLROM 1.0`1.3_CRTMOD̓OtBbNXg[WON̏ԂŕA
		bset.b	#CRTC_GRAPHIC_STORAGE_BIT,(CRTC_MODE_BYTE)E8	;OtBbNXg[WON

	;eLXgJ[\ON
		IOCS	_B_CURON

	;eLXgpbg
		lea.l	(SRAM_TEXT_PALET_0)ED,a0
		lea.l	(VICON_TSPALET)E8,a1
		move.l	(a0)+,(a1)+		;0,1
		move.l	(a0)+,(a1)+		;2,3
		move.l	(a0),d0			;d0=4|8
		move.l	d0,d1			;d1=4|8
		swap.w	d0			;d0=8|4
		move.w	d0,(a1)+		;4
		move.w	d0,(a1)+		;5
		move.w	d0,(a1)+		;6
		move.w	d0,(a1)+		;7
		move.w	d1,d0			;d0=8|8
		move.l	d0,(a1)+		;8,9
		move.l	d0,(a1)+		;10,11
		move.l	d0,(a1)+		;12,13
		move.l	d0,(a1)+		;14,15

	;RgXg
		move.b	(SRAM_CONTRAST)ED,(SYSPORT_CONTRAST)E8

	;XvCgRg[ݒ肷
~i = SPRC_SPRITE_OFF|SPRC_BG_1_TEXT_1|SPRC_BG_1_OFF|SPRC_BG_0_TEXT_0|SPRC_BG_0_OFF
		move.w	#~i,(SPRC_CONTROL)EB

	;eLXgON
		move.w	#VICON_TXON_MASK,(VICON_VISIBLE)E8

	;D揇ʂݒ肷
~i = 0<<VICON_SPPR_BIT|1<<VICON_TXPR_BIT|2<<VICON_GRPR_BIT			;SP>TX>GR
~j = 3<<VICON_G4TH_BIT|2<<VICON_G3RD_BIT|1<<VICON_G2ND_BIT|0<<VICON_G1ST_BIT	;G1>G2>G3>G4
		move.w	#~i|~j,(VICON_PRIORITY)E8

	else

	;Ȃ

	;ݒ̉ʃ[hۑ
		move.b	d1,BIOS_CRTMOD.w	;ݒ̉ʃ[h

	;OtBbNʎgps
		clr.w	BIOS_GRAPHIC_PALETS.w	;OtBbNʂ̐F-1B0=OtBbNʎgps

	;/Ȃ
		bsr	crtmod_common

	;OtBbNʂ\Ă邩
		moveq.l	#VICON_GXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,d0
		and.w	(VICON_VISIBLE)E8,d0
		if	ne			;OtBbNʂ\ĂƂ

		;[hݒ肷
		;	Xg[W͕ωȂ
			moveq.l	#.not.7,d0
			and.b	(CRTC_MODE_BYTE)E8,d0
			or.b	dMM,d0
			move.b	d0,(CRTC_MODE_BYTE)E8
			move.w	dMM,(VICON_MEMORY_MODE)E8

		;BIOS[NGA
			lea.l	BIOS_GRAPHIC_PAGE.w,a0	;BIOS_GRAPHIC_Y_OFFSET,BIOS_GRAPHIC_PALETS
			move.l	dGVRAM,(a0)+		;`y[W擪AhX
			move.l	#2*512,d0
			if	<cmp.w #4,dMM>,hs	;4`7
				add.w	d0,d0			;2*1024
			endif
			move.l	d0,(a0)+		;YItZbg
			moveq.l	#16-1,d0
		;		              76543210
			if	<btst.b dMM,#%00100010>,ne	;1,5
				st.b	d0			;256-1
		;		              76543210
			elif	<btst.b dMM,#%10001100>,ne	;2,3,7
				moveq.l	#-1,d0			;65536-1
			endif
			move.w	d0,(a0)			;F-1

		endif

	endif

;I
;<dPM.l:ݒỎʃ[h<<16
crtmod_end:
	clr.w	dPM
	swap.w	dPM			;ݒỎʃ[h
	move.l	dPM,d0
crtmod_pop:
	pop
	rts

;/Ȃ
crtmod_common:

;CRTCƃVXe|[gR20,HRL,R00`R07ݒ肷
;	ׂẲʃ[h[h3ɂȂ
;	Xg[WOFFɂȂ
	move.w	#3<<8,d2		;R20H(V)
	move.b	crtmod_param_2_r20l(aP2),d2	;R20L(V)
;<d2.w:R20(V)
	lea.l	dot_clock_rank(pc),a0
	moveq.l	#%00011111,d0
	and.b	(CRTC_RESOLUTION_BYTE)E8,d0	;R20L()
	moveq.l	#SYSPORT_HRL,d1
	and.b	(SYSPORT_MISC)E8,d1
	neg.b	d1
	addx.b	d0,d0				;R20L<<1|HRL()
	move.b	(a0,d0.w),d0			;ÂhbgNbÑN
	moveq.l	#%00011111,d1
	and.b	d2,d1				;R20L(V)
	add.b	d1,d1
	add.b	crtmod_param_2_hrl(aP2),d1	;R20L<<1|HRL(V)
	move.b	(a0,d1.w),d1			;VhbgNbÑN
	if	<cmp.b d0,d1>,lo	;hbgNbN
		move.w	d2,(CRTC_MODE_RESOLUTION)E8	;R20
		tst.b	crtmod_param_2_hrl(aP2)
		bsne.b	#SYSPORT_HRL_BIT,(SYSPORT_MISC)E8	;HRL
		lea.l	(CRTC_H_SYNC_END)E8,a0	;R01
		lea.l	crtmod_param_2_r01(aP2),a1
		move.w	(a1)+,(a0)+		;R01
		move.l	(a1)+,(a0)+		;R02,R03
		move.l	(a1)+,(a0)+		;R04,R05
		move.l	(a1)+,(a0)+		;R06,R07
		move.w	crtmod_param_2_r00(aP2),(CRTC_H_FRONT_END)E8	;R00
	else				;hbgNbNオ
		lea.l	(CRTC_H_FRONT_END)E8,a0	;R00
		lea.l	crtmod_param_2_r00(aP2),a1
		move.l	(a1)+,(a0)+		;R00,R01
		move.l	(a1)+,(a0)+		;R02,R03
		move.l	(a1)+,(a0)+		;R04,R05
		move.l	(a1)+,(a0)+		;R06,R07
		move.w	d2,(CRTC_MODE_RESOLUTION)E8	;R20
		tst.b	crtmod_param_2_hrl(aP2)
		bsne.b	#SYSPORT_HRL_BIT,(SYSPORT_MISC)E8	;HRL
	endif

;CRTCR08ݒ肷
;	OAWXg
;	X[p[C|[YƂrfỈfX68000̉fd˂邽߂ɁA
;	rfIX68000̐pX̐擪̎ԍ38.863632MHz̃TCNŎw肷
;	𑜓x512x512̂Ƃ
;		pX4LN^BR01=4-1=3
;		obN|[`6LN^BR02=4+6-5=5
;		OAWXg44
;		perl -e "print((4.7+4.7)*38.863632-(4*8*(4+6))-1)"
;		44.3181408
;	𑜓x256x256̂ƂB1hbgǉ
;		pX2LN^BR01=2-1=1
;		obN|[`3LN^BR02=2+3-5=0
;		OAWXg36
;		perl -e "print((4.7+4.7)*38.863632-(8*(8*(2+3)+1))-1)"
;		36.3181408
	move.w	crtmod_param_2_r08(aP2),(CRTC_ADJUST)E8	;R08

;CRTCR09`R19,R21`R24
	moveq.l	#0,d0
	lea.l	(CRTC_RASTER)E8,a0	;R09
	move.w	d0,(a0)+		;R09
	move.l	d0,(a0)+		;R10,R11
	move.l	d0,(a0)+		;R12,R13
	move.l	d0,(a0)+		;R14,R15
	move.l	d0,(a0)+		;R16,R17
	move.l	d0,(a0)+		;R18,R19
	addq.l	#2,a0
	move.w	#$0033,(a0)+		;R21
	move.l	d0,(a0)+		;R22,R23
	move.w	d0,(a0)+		;R24

;rfIRg[̃[hݒ肷
;	ׂẲʃ[h[h3ɂȂ
	move.w	#3,(VICON_MEMORY_MODE)E8

;XvCgRg[
;𑜓x
	moveq.l	#%1_11_11,d1
	and.b	crtmod_param_2_r20l(aP2),d1	;R20L
;<d1.w:𑜓x
;obN|[`IJ
	moveq.l	#4,d0
	add.w	crtmod_param_2_r02(aP2),d0
	move.w	d0,(SPRC_H_BACK_END)EB	;XvCgobN|[`IJBR02+4
;tg|[`IJ
;	obN|[`IJݒ130us҂Ă琅tg|[`IJݒ肷
;	tg|[`IJ͐256hbĝƂR00ƓlAȊO255
;		Inside X68000ɒ𑜓x256x256̂ƂR00ƓlAȊO255ݒ肷ƏĂ邪A
;		𑜓x256x256̂Ƃ255ɂƃXvCgꍇ
;		512hbĝƂ255ɂȂƐ256hbg琅512hbgɐ؂ւƂXvCg̐̈ʒu邱Ƃ
;	IPLROM 1.3dbraX68030 25MHẑƂ500us҂ĂB060turbôƂEGCgs
	moveq.l	#500/50,d0		;500us
	bsr	wait_50us		;50usPʂ̃EFCg
	moveq.l	#%0_00_11,d0
	and.b	d1,d0
	if	eq			;256hbg
		move.w	crtmod_param_2_r00(aP2),(SPRC_H_FRONT_END)EB	;XvCgtg|[`IJBR00
	else				;256hbgȊO
		move.w	#255,(SPRC_H_FRONT_END)EB	;XvCgtg|[`IJB255
	endif
;obN|[`IX^
	move.w	crtmod_param_2_r06(aP2),(SPRC_V_BACK_END)EB	;XvCgobN|[`IX^BR06
;𑜓x
	move.b	BIOS_CRTMOD.w,d0
	if	<cmp.b #36,d0>,hs	;36`
		if	<cmp.b #40,d0>,lo	;36/37/38/39 256x256(`)
			moveq.l	#%10000,d1		;XvCg256x256
		elif	<cmp.b #44,d0>,hs	;44`
			ifor	<cmp.b #48,d0>,lo,<cmp.b #60,d0>,eq,<cmp.b #73,d0>,eq	;44/45/46/47/60/73 512x256()
				moveq.l	#%10101,d1		;XvCg512x512
			endif
		endif
	endif
	move.w	d1,(SPRC_RESOLUTION)EB	;XvCg𑜓xB--------|---|𑜓x|TCY##|TCY##

;OtBbNʂ̃NbsOGA
;	ʃ[h20`27͕\ʂʂ傫Ƃɒӂ
	move.w	crtmod_param_1_width(aP1),d0	;
	move.w	crtmod_param_1_height(aP1),d1	;
	if	<cmp.w #4,dMM>,lo	;[h0`3B512x512܂
		move.w	#512,d2
		if	<cmp.w d2,d0>,hi
			move.w	d2,d0
		endif
		if	<cmp.w d2,d1>,hi
			move.w	d2,d1
		endif
	endif
	subq.w	#1,d0			;Xő
	subq.w	#1,d1			;Yő
	clr.l	BIOS_GRAPHIC_LEFT.w	;BIOS_GRAPHIC_TOP
	move.w	d0,BIOS_GRAPHIC_RIGHT.w
	move.w	d1,BIOS_GRAPHIC_BOTTOM.w

;OtBbNVRAMỸItZbg
					;dMM=   0    1    2    3    4    5    6    7
	moveq.l	#4,d0			; d0=   4    4    4    4    4    4    4    4
	and.w	dMM,d0			; d0=   0    0    0    0    4    4    4    4
	addq.w	#4,d0			; d0=   4    4    4    4    8    8    8    8
	lsl.w	#8,d0			; d0=1024 1024 1024 1024 2048 2048 2048 2048
	move.l	d0,BIOS_GRAPHIC_Y_OFFSET.w

;OtBbNʂ̃y[W
					;dMM=0 1 2  3  4  5  6  7
	moveq.l	#4,d0			; d0=4 4 4  4  4  4  4  4
	lsr.b	dMM,d0			; d0=4 2 1  0  0  0  0  0
	seq.b	d1			; d1=0 0 0 -1 -1 -1 -1 -1
	sub.b	d1,d0			; d0=4 2 1  1  1  1  1  1
	move.b	d0,BIOS_GRAPHIC_PAGES.w

;eLXgʂ̈ʒu
	move.l	#$00E00000,BIOS_TEXT_PLANE.w
	clr.l	BIOS_CONSOLE_OFFSET.w

;eLXgʂ̑傫
	move.w	crtmod_param_1_width(aP1),d0	;
	move.w	crtmod_param_1_height(aP1),d1	;
	lsr.w	#3,d0			;/8
	lsr.w	#4,d1			;/16B42416Ŋ؂ȂƂɒ
	subq.w	#1,d0			;/8-1
	subq.w	#1,d1			;/16-1
	move.w	d0,BIOS_CONSOLE_RIGHT.w
	move.w	d1,BIOS_CONSOLE_BOTTOM.w

;eLXgJ[\̈ʒu
	clr.l	BIOS_CURSOR_COLUMN.w	;BIOS_CURSOR_ROW

;}EXJ[\̈ړ͈
	clr.l	d1
	move.l	BIOS_GRAPHIC_RIGHT,d2	;BIOS_GRAPHIC_BOTTOM
	IOCS	_MS_LIMIT		;IOCSR[$77 _MS_LIMIT }EXJ[\̈ړ͈͂ݒ肷

	rts

;p[^1(CRT)
crtmod_table_1_crt:
;			 WIDTH HEIGHT R20H  2ND    1ST
	crtmod_param_1	   512,   512,   4,   0  ; CRT 0
	crtmod_param_1	   512,   512,   4,   1  ; CRT 1
	crtmod_param_1	   256,   256,   4,   2  ; CRT 2
	crtmod_param_1	   256,   256,   4,   3  ; CRT 3
	crtmod_param_1	   512,   512,   0,   0  ; CRT 4
	crtmod_param_1	   512,   512,   0,   1  ; CRT 5
	crtmod_param_1	   256,   256,   0,   2  ; CRT 6
	crtmod_param_1	   256,   256,   0,   3  ; CRT 7
	crtmod_param_1	   512,   512,   1,   0  ; CRT 8
	crtmod_param_1	   512,   512,   1,   1  ; CRT 9
	crtmod_param_1	   256,   256,   1,   2  ; CRT 10
	crtmod_param_1	   256,   256,   1,   3  ; CRT 11
	crtmod_param_1	   512,   512,   3,   0  ; CRT 12
	crtmod_param_1	   512,   512,   3,   1  ; CRT 13
	crtmod_param_1	   256,   256,   3,   2  ; CRT 14
	crtmod_param_1	   256,   256,   3,   3  ; CRT 15
	crtmod_param_1	   768,   512,   4,   4  ; CRT 16
	crtmod_param_1	  1024,   424,   4,   5  ; CRT 17
	crtmod_param_1	  1024,   848,   4,   6  ; CRT 18
	crtmod_param_1	   640,   480,   4,   7  ; CRT 19
	crtmod_param_1	   768,   512,   1,   4  ; CRT 20
	crtmod_param_1	  1024,   424,   1,   5  ; CRT 21
	crtmod_param_1	  1024,   848,   1,   6  ; CRT 22
	crtmod_param_1	   640,   480,   1,   7  ; CRT 23
	crtmod_param_1	   768,   512,   3,   4  ; CRT 24
	crtmod_param_1	  1024,   424,   3,   5  ; CRT 25
	crtmod_param_1	  1024,   848,   3,   6  ; CRT 26
	crtmod_param_1	   640,   480,   3,   7  ; CRT 27
	crtmod_param_1	   384,   256,   4,   8  ; CRT 28
	crtmod_param_1	   384,   256,   0,   8  ; CRT 29
	crtmod_param_1	   384,   256,   1,   8  ; CRT 30
	crtmod_param_1	   384,   256,   3,   8  ; CRT 31
	crtmod_param_1	   512,   512,   4,   9  ; CRT 32
	crtmod_param_1	   512,   512,   0,   9  ; CRT 33
	crtmod_param_1	   512,   512,   1,   9  ; CRT 34
	crtmod_param_1	   512,   512,   3,   9  ; CRT 35
	crtmod_param_1	   256,   256,   4,  10  ; CRT 36
	crtmod_param_1	   256,   256,   0,  10  ; CRT 37
	crtmod_param_1	   256,   256,   1,  10  ; CRT 38
	crtmod_param_1	   256,   256,   3,  10  ; CRT 39
	crtmod_param_1	   512,   256,   4,  22  ; CRT 40
	crtmod_param_1	   512,   256,   0,  22  ; CRT 41
	crtmod_param_1	   512,   256,   1,  22  ; CRT 42
	crtmod_param_1	   512,   256,   3,  22  ; CRT 43
	crtmod_param_1	   512,   256,   4,  22  ; CRT 44
	crtmod_param_1	   512,   256,   0,  22  ; CRT 45
	crtmod_param_1	   512,   256,   1,  22  ; CRT 46
	crtmod_param_1	   512,   256,   3,  22  ; CRT 47
	crtmod_param_1	   512,   512,   5,   0  ; CRT 48
	crtmod_param_1	   512,   512,   5,   1  ; CRT 49
	crtmod_param_1	   256,   256,   5,   2  ; CRT 50
	crtmod_param_1	   256,   256,   5,   3  ; CRT 51
	crtmod_param_1	   768,   512,   5,   4  ; CRT 52
	crtmod_param_1	  1024,   424,   5,   5  ; CRT 53
	crtmod_param_1	  1024,   848,   5,   6  ; CRT 54
	crtmod_param_1	   640,   480,   5,   7  ; CRT 55
	crtmod_param_1	   384,   256,   5,   8  ; CRT 56
	crtmod_param_1	   512,   512,   5,   9  ; CRT 57
	crtmod_param_1	   256,   256,   5,  10  ; CRT 58
	crtmod_param_1	   512,   256,   5,  22  ; CRT 59
	crtmod_param_1	   512,   256,   5,  22  ; CRT 60
	crtmod_param_1	   512,   512,   7,   0  ; CRT 61
	crtmod_param_1	   512,   512,   7,   1  ; CRT 62
	crtmod_param_1	   256,   256,   7,   2  ; CRT 63
	crtmod_param_1	   256,   256,   7,   3  ; CRT 64
	crtmod_param_1	   768,   512,   7,   4  ; CRT 65
	crtmod_param_1	  1024,   424,   7,   5  ; CRT 66
	crtmod_param_1	  1024,   848,   7,   6  ; CRT 67
	crtmod_param_1	   640,   480,   7,   7  ; CRT 68
	crtmod_param_1	   384,   256,   7,   8  ; CRT 69
	crtmod_param_1	   512,   512,   7,   9  ; CRT 70
	crtmod_param_1	   256,   256,   7,  10  ; CRT 71
	crtmod_param_1	   512,   256,   7,  22  ; CRT 72
	crtmod_param_1	   512,   256,   7,  22  ; CRT 73
crtmod_table_1_crt_end:

;p[^1(LCD)
crtmod_table_1_lcd:
;			 WIDTH HEIGHT R20H  2ND    1ST
	crtmod_param_1	   512,   512,   4,  11  ; LCD 0
	crtmod_param_1	   512,   512,   4,  12  ; LCD 1
	crtmod_param_1	   256,   256,   4,  13  ; LCD 2
	crtmod_param_1	   256,   256,   4,  14  ; LCD 3
	crtmod_param_1	   512,   512,   0,  11  ; LCD 4
	crtmod_param_1	   512,   512,   0,  12  ; LCD 5
	crtmod_param_1	   256,   256,   0,  13  ; LCD 6
	crtmod_param_1	   256,   256,   0,  14  ; LCD 7
	crtmod_param_1	   512,   512,   1,  11  ; LCD 8
	crtmod_param_1	   512,   512,   1,  12  ; LCD 9
	crtmod_param_1	   256,   256,   1,  13  ; LCD 10
	crtmod_param_1	   256,   256,   1,  14  ; LCD 11
	crtmod_param_1	   512,   512,   3,  11  ; LCD 12
	crtmod_param_1	   512,   512,   3,  12  ; LCD 13
	crtmod_param_1	   256,   256,   3,  13  ; LCD 14
	crtmod_param_1	   256,   256,   3,  14  ; LCD 15
	crtmod_param_1	   768,   512,   4,  15  ; LCD 16
	crtmod_param_1	   768,   600,   4,  16  ; LCD 17
	crtmod_param_1	   768,  1024,   4,  17  ; LCD 18
	crtmod_param_1	   640,   480,   4,  18  ; LCD 19
	crtmod_param_1	   768,   512,   1,  15  ; LCD 20
	crtmod_param_1	   768,   600,   1,  16  ; LCD 21
	crtmod_param_1	   768,  1024,   1,  17  ; LCD 22
	crtmod_param_1	   640,   480,   1,  18  ; LCD 23
	crtmod_param_1	   768,   512,   3,  15  ; LCD 24
	crtmod_param_1	   768,   600,   3,  16  ; LCD 25
	crtmod_param_1	   768,  1024,   3,  17  ; LCD 26
	crtmod_param_1	   640,   480,   3,  18  ; LCD 27
	crtmod_param_1	   384,   256,   4,  19  ; LCD 28
	crtmod_param_1	   384,   256,   0,  19  ; LCD 29
	crtmod_param_1	   384,   256,   1,  19  ; LCD 30
	crtmod_param_1	   384,   256,   3,  19  ; LCD 31
	crtmod_param_1	   512,   512,   4,  20  ; LCD 32
	crtmod_param_1	   512,   512,   0,  20  ; LCD 33
	crtmod_param_1	   512,   512,   1,  20  ; LCD 34
	crtmod_param_1	   512,   512,   3,  20  ; LCD 35
	crtmod_param_1	   256,   256,   4,  21  ; LCD 36
	crtmod_param_1	   256,   256,   0,  21  ; LCD 37
	crtmod_param_1	   256,   256,   1,  21  ; LCD 38
	crtmod_param_1	   256,   256,   3,  21  ; LCD 39
	crtmod_param_1	   512,   256,   4,  23  ; LCD 40
	crtmod_param_1	   512,   256,   0,  23  ; LCD 41
	crtmod_param_1	   512,   256,   1,  23  ; LCD 42
	crtmod_param_1	   512,   256,   3,  23  ; LCD 43
	crtmod_param_1	   512,   256,   4,  23  ; LCD 44
	crtmod_param_1	   512,   256,   0,  23  ; LCD 45
	crtmod_param_1	   512,   256,   1,  23  ; LCD 46
	crtmod_param_1	   512,   256,   3,  23  ; LCD 47
	crtmod_param_1	   512,   512,   5,  11  ; LCD 48
	crtmod_param_1	   512,   512,   5,  12  ; LCD 49
	crtmod_param_1	   256,   256,   5,  13  ; LCD 50
	crtmod_param_1	   256,   256,   5,  14  ; LCD 51
	crtmod_param_1	   768,   512,   5,  15  ; LCD 52
	crtmod_param_1	   768,   600,   5,  16  ; LCD 53
	crtmod_param_1	   768,  1024,   5,  17  ; LCD 54
	crtmod_param_1	   640,   480,   5,  18  ; LCD 55
	crtmod_param_1	   384,   256,   5,  19  ; LCD 56
	crtmod_param_1	   512,   512,   5,  20  ; LCD 57
	crtmod_param_1	   256,   256,   5,  21  ; LCD 58
	crtmod_param_1	   512,   256,   5,  23  ; LCD 59
	crtmod_param_1	   512,   256,   5,  23  ; LCD 60
	crtmod_param_1	   512,   512,   7,  11  ; LCD 61
	crtmod_param_1	   512,   512,   7,  12  ; LCD 62
	crtmod_param_1	   256,   256,   7,  13  ; LCD 63
	crtmod_param_1	   256,   256,   7,  14  ; LCD 64
	crtmod_param_1	   768,   512,   7,  15  ; LCD 65
	crtmod_param_1	   768,   600,   7,  16  ; LCD 66
	crtmod_param_1	   768,  1024,   7,  17  ; LCD 67
	crtmod_param_1	   640,   480,   7,  18  ; LCD 68
	crtmod_param_1	   384,   256,   7,  19  ; LCD 69
	crtmod_param_1	   512,   512,   7,  20  ; LCD 70
	crtmod_param_1	   256,   256,   7,  21  ; LCD 71
	crtmod_param_1	   512,   256,   7,  23  ; LCD 72
	crtmod_param_1	   512,   256,   7,  23  ; LCD 73

;p[^2
crtmod_table_2:
;			   R20L  HRL    HT   HS   HB   HD   HF    VT   VS   VB   VD   VF   R08    2ND  1ST
	crtmod_param_2	 %10101,   0,   92,  10,  12,  64,   6,  568,   6,  35, 512,  15,   27  ;   0  CRT 0/4/8/12/48/61
	crtmod_param_2	 %00101,   0,   76,   4,   6,  64,   2,  260,   3,  14, 240,   3,   44  ;   1  CRT 1/5/9/13/49/62
	crtmod_param_2	 %10000,   0,   46,   5,   6,  32,   3,  568,   6,  35, 512,  15,   27  ;   2  CRT 2/6/10/14/50/63
	crtmod_param_2	 %00000,   0,   38,   2,   3,  32,   1,  260,   3,  14, 240,   3,   36  ;   3  CRT 3/7/11/15/51/64
	crtmod_param_2	 %10110,   0,  138,  15,  18,  96,   9,  568,   6,  35, 512,  15,   27  ;   4  CRT 16/20/24/52/65
	crtmod_param_2	 %10110,   0,  176,  16,  20, 128,  12,  465,   8,  25, 424,   8,   27  ;   5  CRT 17/21/25/53/66
	crtmod_param_2	 %11010,   0,  176,  16,  20, 128,  12,  465,   8,  25, 424,   8,   27  ;   6  CRT 18/22/26/54/67
	crtmod_param_2	 %10110,   0,  138,  15,  26,  80,  17,  568,   6,  51, 480,  31,   27  ;   7  CRT 19/23/27/55/68
	crtmod_param_2	 %10001,   1,   68,   7,   9,  48,   4,  568,   6,  35, 512,  15,   27  ;   8  CRT 28/29/30/31/56/69
	crtmod_param_2	 %10110,   0,  138,  15,  34,  64,  25,  568,   6,  35, 512,  15,   27  ;   9  CRT 32/33/34/35/57/70
	crtmod_param_2	 %10001,   1,   68,   7,  17,  32,  12,  568,   6,  35, 512,  15,   27  ;  10  CRT 36/37/38/39/58/71
	crtmod_param_2	 %10101,   0,   82,   6,  10,  64,   2,  625,   2,  66, 512,  45,   27  ;  11  LCD 0/4/8/12/48/61
	crtmod_param_2	 %10101,   0,   82,   6,  10,  64,   2,  625,   2,  82, 480,  61,   27  ;  12  LCD 1/5/9/13/49/62
	crtmod_param_2	 %10000,   0,   42,   3,   5,  32,   2,  625,   2,  66, 512,  45,   27  ;  13  LCD 2/6/10/14/50/63
	crtmod_param_2	 %10000,   0,   42,   3,   5,  32,   2,  625,   2,  82, 480,  61,   27  ;  14  LCD 3/7/11/15/51/64
	crtmod_param_2	 %10110,   0,  124,   9,  15,  96,   4,  625,   2,  66, 512,  45,   27  ;  15  LCD 16/20/24/52/65
	crtmod_param_2	 %10110,   0,  124,   9,  15,  96,   4,  625,   2,  22, 600,   1,   27  ;  16  LCD 17/21/25/53/66
	crtmod_param_2	 %11010,   0,  124,   9,  15,  96,   4,  625,   2,  66, 512,  45,   27  ;  17  LCD 18/22/26/54/67
	crtmod_param_2	 %10111,   0,  100,  12,   6,  80,   2,  525,   2,  33, 480,  10,   27  ;  18  LCD 19/23/27/55/68
	crtmod_param_2	 %10001,   1,   68,   7,   9,  48,   4,  625,   2,  66, 512,  45,   27  ;  19  LCD 28/29/30/31/56/69
	crtmod_param_2	 %10110,   0,  124,   9,  31,  64,  20,  625,   2,  66, 512,  45,   27  ;  20  LCD 32/33/34/35/57/70
	crtmod_param_2	 %10001,   1,   68,   7,  17,  32,  12,  625,   2,  66, 512,  45,   27  ;  21  LCD 36/37/38/39/58/71
	crtmod_param_2	 %10001,   0,   92,  10,  12,  64,   6,  568,   6,  35, 512,  15,   27  ;  22  CRT 40/41/42/43/44/45/46/47/59/60/72/73
	crtmod_param_2	 %10001,   0,   82,   6,  10,  64,   2,  625,   2,  66, 512,  45,   27  ;  23  LCD 40/41/42/43/44/45/46/47/59/60/72/73

;R20L<<1|HRLhbgNbÑN
;	rank	R20L	HRL	osc	div	dotclk	mode
;	7	1**10	*	69.552	2	34.776	768x512()
;	6	1**11	*	50.350	2	25.175	640x480
;	5	1**01	0	69.552	3	23.184	512x512()
;	4	1**01	1	69.552	4	17.388	384x256
;	3	1**00	0	69.552	6	11.592	256x256()
;	2	0**01	*	38.864	4	9.716	512x512()
;	1	1**00	1	69.552	8	8.694
;	0	0**00	*	38.864	8	4.858	256x256()
;	0	0**1*	*	38.864	8	4.858
dot_clock_rank:
  .rept 4
	.dc.b	0	;0**00 0
	.dc.b	0	;0**00 1
	.dc.b	2	;0**01 0
	.dc.b	2	;0**01 1
	.dc.b	0	;0**10 0
	.dc.b	0	;0**10 1
	.dc.b	0	;0**11 0
	.dc.b	0	;0**11 1
  .endm
  .rept 4
	.dc.b	3	;1**00 0
	.dc.b	1	;1**00 1
	.dc.b	5	;1**01 0
	.dc.b	4	;1**01 1
	.dc.b	7	;1**10 0
	.dc.b	7	;1**10 1
	.dc.b	6	;1**11 0
	.dc.b	6	;1**11 1
  .endm

  .endif  ;REMOVE_CRTMOD_G_CLR_ON



;----------------------------------------------------------------
;	6x12 ANKtHg
;		X68000CGROMIPLROM 1.3gݍ킹6x12 ANKtHg\łȂ
;		IPLROM 1.66x12 ANKtHg$00FEF400`$00FEFFFF(3072oCg)ɒu
;	ύXO
;		000073F6 203C00FBF400     	move.l	#$00FBF400,d0
;----------------------------------------------------------------
	PATCH_DATA	p73F6,$00FF73F6,$00FF73F6+5,$203C00FB
		move.l	#$00FEF400,d0



;----------------------------------------------------------------
;	IOCS _SET232C
;	{[[g8=19200bpsg悤ɂ
;		IPLROM 1.3IOCS _SET232C̓{[[g8=19200bpsIł邪ASCC WR13:WR12̒lԈĂA
;		X^[grbgœĂXgbvrbg܂łɂ悻1rbgĂ܂̂ŎgȂ
;		(5000000/2/16)/19200-2=6.138
;		(5000000/2/16)/(7+2)=17361.111=19200*0.904  
;		(5000000/2/16)/(6+2)=19531.250=19200*1.017  
;	{[[g9=38400bps10=76800bpsIł悤ɂ
;		gƂ͌Ȃ
;		RTS/CTSɑΉĂȂ̂Ŏp͕s
;		SCC̓g7.5MHẑƂ9=57600bps10=115200bpsɂȂ
;	RTS/CTS̑Imɖ
;		RTS/CTSɂ͑ΉĂȂIĂ邾Ń{[[g4=1200bpsɂȂĂ܂肪
;
;					ύXO				ύX
;		00FF7A1A 4240		clr.w	d0			=
;		00FF7A1C 1001		move.b	d1,d0			=
;	A	00FF7A1E B03C		cmp.b	#$09,d0			movea.l	d1,a0
;		00FF7A20 0009						and.b	#$7F,d1
;		00FF7A22 6504		bcs	$00FF7A28
;		00FF7A24 303C		move.w	#$0004,d0		cmp.b	#11,d1
;		00FF7A26 0004
;		00FF7A28 D040		add.w	d0,d0			blo	$00FF7A2C
;		00FF7A2A 41FA		lea.l	$00FF7AE2(pc),a0	moveq.l	#4,d1
;		00FF7A2C 00B6						bsr.w	$00FF7AE2
;		00FF7A2E 3030		move.w	$00(a0,d0.w),d0
;		00FF7A30 0000						move.l	a0,d1
;		00FF7A32
;	B	00FF7AE2 0821		.dc.w	$0821			move.w	#2083,d0
;		00FF7AE4 0410		.dc.w	$0410
;		00FF7AE6 0207		.dc.w	$0207			lsr.w	d1,d0
;		00FF7AE8 0102		.dc.w	$0102			moveq.l	#-2,d1
;		00FF7AEA 0080		.dc.w	$0080			addx.w	d1,d0
;		00FF7AEC 003F		.dc.w	$003F			rts
;		00FF7AEE 001F		.dc.w	$001F			=
;		00FF7AF0 000E		.dc.w	$000E			=
;		00FF7AF2 0007		.dc.w	$0007	;6	=
;		00FF7AF4
;----------------------------------------------------------------
	PATCH_DATA	p7a1e,$00FF7A1E,$00FF7A31,$B03C0009
;A
;<d1.b:{[[g̔ԍ
;	0=75bps,1=150bps,2=300bps,3=600bps,4=1200bps,5=2400bps,6=4800bps,7=9600bps,8=19200bps,9=38400bps,10=76800bps
	movea.l	d1,a0			;d1ۑ
	and.b	#$7F,d1			;RTS/CTS̑Imɖ
	if	<cmp.b #11,d1>,hs	;{[[g̔ԍ0`10͈̔͊ÔƂ
		moveq.l	#4,d1			;{[[g4=1200bpsɂ
	endif
	bsr.w	($00FF7AE2)PATCH_ZL	;BĂяo
	move.l	a0,d1			;d1𕜌
;<d0.w:SCC WR13:WR12̒l

	PATCH_DATA	p7ae2,$00FF7AE2,$00FF7AED,$08210410
;B
	move.w	#2083,d0		;(5000000Hz/2/16)/75bps=2083.333
	lsr.w	d1,d0			;{[[g̔ԍ̕EɃVtg
	moveq.l	#-2,d1			;2
	addx.w	d1,d0			;ľܓ
	rts				;02081,11040,2519,3258,4128,563,631,714,86,92,100



;----------------------------------------------------------------
;	DMA]JnÕLbVtbV
;	ύXO
;		00FF8284 2F00                   move.l	d0,-(sp)
;		00FF8286 0C3800010CBC           cmpi.b	#$01,BIOS_MPU_TYPE.w
;		00FF828C 6314                   bls.s	$00FF82A2
;		00FF828E 4E7A0002               movec.l	cacr,d0
;		00FF8292 807C0808               or.w	#$0808,d0
;		00FF8296 4E7B0002               movec.l	d0,cacr
;		00FF829A C07CF7F7               and.w	#$F7F7,d0
;		00FF829E 4E7B0002               movec.l	d0,cacr
;		00FF82A2 201F                   move.l	(sp)+,d0
;		00FF82A4 4E75                   rts
;		00FF82A6
;----------------------------------------------------------------
	PATCH_DATA	dma_cache_flush,$00FF8284,$00FF82A5,$2F000C38
	jmp	cache_flush



;----------------------------------------------------------------
;	荞݊֌WIOCSR[̃nC΍
;		荞݊֌WIOCSR[͊荞݂gpǂxN^$01000000ȏォǂŔfĂ
;		xN^nCwĂƖgpƌF
;		xN^̏8bitxN^ԍƈvĂ邩ǂɕύX
;		ȉIOCSR[Y
;			$43	iocs_6A_OPMINTST
;			$44	iocs_6B_TIMERDST
;			$4D	iocs_6C_VDISPST
;			$4E	iocs_6D_CRTCRAS
;			$4F	iocs_6E_HSYNCST
;			$63	iocs_6F_PRNINTST
;	ύXO
;		00FF85D4 007C0700         	ori.w	#$0700,sr		;荞݋֎~
;		00FF85D8 E548             	lsl.w	#2,d0			;xN^ItZbg
;		00FF85DA 3040             	movea.w	d0,a0			;a0.l:xN^ItZbg
;		00FF85DC 2009             	move.l	a1,d0			;ύX̃xN^
;		00FF85DE 670C_000085EC    	beq.s	$00FF85EC		;
;		00FF85E0 2010             	move.l	(a0),d0			;d0.l:ύXÕxN^
;	>>>>>	00FF85E2 0C8001000000     	cmpi.l	#$01000000,d0		;ύXÕxN^ɃxN^ԍtĂ邩
;		00FF85E8 6504_000085EE    	bcs.s	$00FF85EE		;ύXÕxN^ɃxN^ԍtĂȂ̂Ŏgp
;		00FF85EA                  ;ύXÕxN^ɃxN^ԍtĂ̂Ŗgp
;		00FF85EA 2089             	move.l	a1,(a0)			;xN^ύX
;		00FF85EC 4E75             	rts				;XIOCSR[֖߂
;		00FF85EE                  ;ύXÕxN^ɃxN^ԍtĂȂ̂Ŏgp
;		00FF85EE 4A9F             	tst.l	(sp)+			;XIOCSR[֖߂Ȃ
;		00FF85F0                  ;gp̂ƂTRAP#15rte܂Ŋ荞݋֎~̂܂܂ɂȂ
;		00FF85F0 4E75             	rts				;IOCSR[畜A
;		00FF85F2
;		
;----------------------------------------------------------------
	PATCH_DATA	p85E2,$00FF85E2,$00FF85E7,$0C800100
	jsr	p85E2
	PATCH_TEXT
;<d0.l:ύXÕxN^
;<a0.l:xN^ItZbg
;>c:cc=gp,cs=gp
p85E2:
	push	d0-d1
	move.w	a0,d1			;d1.w:xN^ItZbg
	lsr.w	#2,d1			;d1.b:xN^ԍ
	rol.l	#8,d0			;d0.b:ύXÕxN^̏8bit
	cmp.b	d1,d0			;eq=gp,ne=gp
	sne.b	d0			;d1.b:$00=gp,$FF=gp
	add.b	d0,d0			;cc=gp,cs=gp
	pop
	rts



;----------------------------------------------------------------
;	s
;		_MS_LIMITY͈̔͂1007܂łݒłȂ
;		https://stdkmd.net/bugsx68k/#rom_mslimit
;	ύXO
;		00FFABA4 B27C03F0               cmp.w	#$03F0,d1
;		00FFABA8
;----------------------------------------------------------------
	PATCH_DATA	mslimit_1st,$00FFABA4,$00FFABA7,$B27C03F0
	cmp.w	#$0400,d1
;----------------------------------------------------------------
;	ύXO
;		00FFABB4 B47C03F0               cmp.w	#$03F0,d2
;		00FFABB8
;----------------------------------------------------------------
	PATCH_DATA	mslimit_2nd,$00FFABB4,$00FFABB7,$B47C03F0
	cmp.w	#$0400,d2



;----------------------------------------------------------------
;	_MS_ONTM̃LbV
;	ύXO
;		00FFAC72 0C3800010CBC           cmpi.b	#$01,BIOS_MPU_TYPE.w
;		00FFAC78 630C                   bls.s	$00FFAC86
;		00FFAC7A 4E7A0002               movec.l	cacr,d0
;		00FFAC7E 2F00                   move.l	d0,-(sp)
;		00FFAC80 7001                   moveq.l	#$01,d0			;EI=1,ED=0
;		00FFAC82 4E7B0002               movec.l	d0,cacr
;		00FFAC86
;----------------------------------------------------------------
	PATCH_DATA	ms_ontm_cache_1st,$00FFAC72,$00FFAC85,$0C380001
	jsr	cache_on_i	;f[^LbVOFF,߃LbVON
	move.l	d0,-(sp)
	bra	($00FFAC86)PATCH_ZL
;----------------------------------------------------------------
;	ύXO
;		00FFACE8 0C3800010CBC           cmpi.b	#$01,BIOS_MPU_TYPE.w
;		00FFACEE 6306                   bls.s	$00FFACF6
;		00FFACF0 201F                   move.l	(sp)+,d0
;		00FFACF2 4E7B0002               movec.l	d0,cacr
;		00FFACF6
;----------------------------------------------------------------
	PATCH_DATA	ms_ontm_cache_2nd,$00FFACE8,$00FFACF5,$0C380001
	move.l	(sp)+,d2
	jsr	cache_set	;LbVݒ
	bra	($00FFACF6)PATCH_ZL



  .if REMOVE_CRTMOD_G_CLR_ON=0

;----------------------------------------------------------------
;	_G_CLR_ON
;	ύXO
;		0000B326*48E76040         	movem.l	~pushrl,-(sp)
;			:
;		0000B660*FFFE             	.dc.w	(31<<11)|(31<<6)|(31<<1)
;----------------------------------------------------------------
	PATCH_DATA	g_clr_on,$00FFB326,$00FFB661,$48E76040
;----------------------------------------------------------------
;IOCSR[$90 _G_CLR_ON OtBbNʂ̏ƃpbgƕ\ON
;>d0.l:0
;----------------------------------------------------------------
iocs_90_G_CLR_ON:
dMM	reg	d3			;[h
dGVRAM	reg	d5			;$00C00000
aE8	reg	a2			;(`)E8̃x[XAhX
aED	reg	a4			;(`)ED̃x[XAhX
aP1	reg	a5			;p[^1̃AhX
	push	d0-d2/dMM/dGVRAM/a0/aE8/aED/aP1
	move.l	#$00C00000,dGVRAM

;(`)E8ŃANZX
;	$00E80000	CRTC
;	$00E82000	VICON
;	$00E84000	DMAC
;	$00E86000	SUPERAREA
;	$00E88000	MFP
;	$00E8A000	RTC
;	$00E8C000	PRNPORT
;	$00E8E000	SYSPORT
	lea.l	$00E88000,aE8
E8	reg	-$00E88000(aE8)

;(`)EDŃANZX
;	$00ED0000	SRAM
	lea.l	$00ED8000,aED
ED	reg	-$00ED8000(aED)

;݂̉ʃ[hmF
	moveq.l	#0,d1
	move.b	BIOS_CRTMOD.w,d1	;݂̉ʃ[h
	if	<cmp.w #crtmod_modes,d1>,hs	;݂̉ʃ[h͈͊ÔƂ
		move.b	(SRAM_CRTMOD)ED,d1		;N̉ʃ[hg
		if	<cmp.w #crtmod_modes,d1>,hs	;N̉ʃ[h͈͊ÔƂ
			moveq.l	#16,d1			;16g
  .if 0
			move.b	#$31,(SYSPORT_SRAM)E8	;unlocksram
			move.b	d1,(SRAM_CRTMOD)ED
			clr.b	(SYSPORT_SRAM)E8	;locksram
  .endif
		endif
	endif

;<d1.l:ʃ[h

;p[^1̃AhX߂
	lea.l	crtmod_table_1_crt,aP1
	if	<btst.b #SRAM_XEIJ_LCD_BIT,(SRAM_XEIJ)ED>,ne	;LCD
		lea.l	crtmod_table_1_lcd,aP1
	endif
	move.w	d1,d0
  .if crtmod_param_1_size=8
	lsl.w	#3,d0
  .else
	mulu.w	#crtmod_param_1_size,d0
  .endif
	adda.w	d0,aP1
;<aP1.l:p[^1̃AhX

;[hmF
	moveq.l	#7,dMM
	and.b	crtmod_param_1_r20h(aP1),dMM	;[hB0`7
;<dMM.w:[hB0`7

;eLXgʂ̂ON
	move.w	#VICON_TXON_MASK,(VICON_VISIBLE)E8

;[hݒ肷
	move.b	dMM,(CRTC_MODE_BYTE)E8
	move.w	dMM,(VICON_MEMORY_MODE)E8

;OtBbNVRAMNA
	bset.b	#CRTC_GRAPHIC_STORAGE_BIT,(CRTC_MODE_BYTE)E8	;OtBbNXg[WON
	movea.l	dGVRAM,a0
	moveq.l	#0,d0
	moveq.l	#1-1,d2
;		              76543210
	if	<btst.b dMM,#%10100000>,ne	;5,7
	;[hŃNA͈͂߂Ă
	;gOtBbNʂȂƂgOtBbNʂKvȉʃ[hCRTMODêłʂ邱Ƃ͂Ȃ͂
		moveq.l	#4-1,d2
	endif
	for	d2
		moveq.l	#-1,d1			;2*512*512/8=65536
		for	d1
			move.l	d0,(a0)+
			move.l	d0,(a0)+
		next
	next
	bclr.b	#CRTC_GRAPHIC_STORAGE_BIT,(CRTC_MODE_BYTE)E8	;OtBbNXg[WOFF

;BIOS[NGA
	lea.l	BIOS_GRAPHIC_PAGE.w,a0	;BIOS_GRAPHIC_Y_OFFSET,BIOS_GRAPHIC_PALETS
	move.l	dGVRAM,(a0)+		;`y[W擪AhX
	move.l	#2*512,d0
	if	<cmp.w #4,dMM>,hs	;4`7
		add.w	d0,d0			;2*1024
	endif
	move.l	d0,(a0)+		;YItZbg
	moveq.l	#16-1,d0
;		              76543210
	if	<btst.b dMM,#%00100010>,ne	;1,5
		st.b	d0			;256-1
;		              76543210
	elif	<btst.b dMM,#%10001100>,ne	;2,3,7
		moveq.l	#-1,d0			;65536-1
	endif
	move.w	d0,(a0)			;F-1

;OtBbNpbg
	move.w	dMM,d0
	bsr	initialize_gpalet

;eLXgONAOtBbNON
;	if	<cmp.w #4,dMM>,lo	;[h0`3B512x512hbg
;		move.w	#VICON_TXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,(VICON_VISIBLE)E8
;	else				;[h4`7B1024x1024hbg
;		move.w	#VICON_TXON_MASK|VICON_GXON_MASK,(VICON_VISIBLE)E8
;	endif
;	IPLROM 1.0`1.31024x1024hbg512x512hbg𗼕ONɂĂ
	move.w	#VICON_TXON_MASK|VICON_GXON_MASK|VICON_G4ON_MASK|VICON_G3ON_MASK|VICON_G2ON_MASK|VICON_G1ON_MASK,(VICON_VISIBLE)E8

	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;OtBbNpbg
;<d0.w:[hB0`7
initialize_gpalet:
	push	d0-d4/a0-a1
	lea.l	VICON_GPALET,a0
	ifor	<tst.w d0>,eq,<cmp.w #4,d0>,eq,<cmp.w #6,d0>,eq	;[h0,4,6B16F
		lea.l	gpalet_16_array(pc),a1
		moveq.l	#16/2-1,d0
		for	d0
			move.l	(a1)+,(a0)+
		next
	elifor	<cmp.w #1,d0>,eq,<cmp.w #5,d0>,eq	;[h1,5B256F
	;green͑10.54K(10.5*3=31.5)Aredblue͑4.58K(4.5*7=31.5)A[͐؂̂
		move.l	#((9<<1)<<16)|(9<<1),d1	;bluȇ4.5+4.5
		moveq.l	#0,d3			;green=0
		do
			moveq.l	#(4<<1),d2		;red=0,blue=(0,4.5)
			moveq.l	#8-1,d4
			for	d4
				move.l	d3,d0			;green
				and.l	#.not.(((1<<10)<<16)|(1<<10)),d0	;green̒[؂̂Ă
				add.l	d2,d0			;red,blue=(0,4.5)
				and.l	#.not.(((1<<5)<<16)|(1<<5)),d0	;red̒[؂̂Ă
				move.l	d0,(a0)+
				add.l	d1,d0			;blue+=4.5+4.5
				move.l	d0,(a0)+
				add.l	d1,d0			;blue+=4.5+4.5
				move.l	d0,(a0)+
				add.l	d1,d0			;blue+=4.5+4.5
				move.l	d0,(a0)+
				add.l	#((9<<5)<<16)|(9<<5),d2	;red+=4.5
			next
			add.l	#((21<<10)<<16)|(21<<10),d3	;green+=10.5
		while	cc
	else				;[h2,3,7B65536F
		move.l	#$00_01_00_01,d0	;(L00,L01,H00,H01),(L02,L03,H02,H03),c,(LFE,LFF,HFE,HFF)
		move.l	#$02_02_02_02,d2
		moveq.l	#256/2-1,d1
		for	d1
			move.l	d0,(a0)+
			add.l	d2,d0
		next
	endif
	pop
	rts

;OtBbN16Fpbg
gpalet_16_array:
	dcrgb	0,0,0
	dcrgb	10,10,10
	dcrgb	0,0,16
	dcrgb	0,0,31
	dcrgb	16,0,0
	dcrgb	31,0,0
	dcrgb	16,0,16
	dcrgb	31,0,31
	dcrgb	0,16,0
	dcrgb	0,31,0
	dcrgb	0,16,16
	dcrgb	0,31,31
	dcrgb	16,16,0
	dcrgb	31,31,0
	dcrgb	21,21,21
	dcrgb	31,31,31

	PATCH_TEXT

;----------------------------------------------------------------
;50usPʂ̃EFCg
;<d0.l:(50usP)
	.text
	.even
wait_50us:
  .if 0
;Timer-Cg
;	Timer-C1/200vXP[(50us)œ삵ĂȂ΂ȂȂ
aTCDR	reg	a0
	push	d0-d2/aTCDR
	lea.l	MFP_TCDR,aTCDR
	moveq.l	#0,d1
	move.b	(aTCDR),d1
	move.b	(aTCDR),d1
	do
		moveq.l	#0,d2
		move.b	(aTCDR),d2
		redo	<cmp.b (aTCDR),d2>,cs
		sub.w	d2,d1
		if	cs
			add.w	#200,d1
		endif
		exg.l	d1,d2
		sub.l	d2,d0
	while	hi
	pop
	rts
  .else
;dbra󃋁[vg
;	BIOS_MPU_SPEED_ROM.wBIOS_MPU_TYPE.wݒ肳ĂȂ΂ȂȂ
	push	d0-d3
	subq.l	#1,d0
	if	cc
		move.l	BIOS_MPU_SPEED_ROM_LONG.w,d1
		if	eq
			move.w	BIOS_MPU_SPEED_ROM.w,d1
		endif
	;	20bitƂ50usdbrả񐔂߂
		if	<cmpi.b #4,BIOS_MPU_TYPE.w>,lo	;000/010/020/030
			move.w	#205,d2			;2**12*50/1000=204.8
		elif	eq			;040
			move.w	#307,d2			;2**12*50/1000*6/4=307.2
		else				;060
			move.w	#1229,d2		;2**12*50/1000*6/1=1228.8
		endif
		move.l	d1,d3			;d3=H|L
		swap.w	d3			;d3=L|H
		mulu.w	d2,d3			;d3=c*H
		mulu.w	d2,d1			;d1=c*L
		swap.w	d3
		clr.w	d3			;d3=c*H|0
		add.l	d3,d1			;d1=c*(H|L)
		and.w	#$F000,d1		;43210___
		rol.l	#4,d1			;3210___4
		swap.w	d1			;___43210  50usdbrả
		subq.l	#1,d1
		move.l	d1,d2
		forlong	d0
			move.l	d2,d1
			.align	16,$2048
			forlong	d1
			next
		next
	endif
	pop
	rts
  .endif

  .endif  ;REMOVE_CRTMOD_G_CLR_ON



;----------------------------------------------------------------
;	s
;		_GPALET65536F[h̃pbg𐳂擾łȂ
;		https://stdkmd.net/bugsx68k/#rom_gpalet
;	ύXO
;		00FFB740 16300000               move.b	$00(a0,d0.w),d3
;		00FFB744
;----------------------------------------------------------------
	PATCH_DATA	gpalet,$00FFB740,$00FFB743,$16300000
	move.b	2(a0,d0.w),d3



;----------------------------------------------------------------
;	s
;		_SYS_STAT̃R[hԈĂ
;		https://stdkmd.net/bugsx68k/#rom_sysstat
;	ύXO
;		00FFC75A 48E76000               movem.l	d1-d2,-(sp)
;			:
;		00FFC818
;----------------------------------------------------------------
	PATCH_DATA	sysstat,$00FFC75A,$00FFC817,$48E76000
	jmp	iocs_AC_SYS_STAT

;]̈trap#14Ŏg
trap14_message:
200:
	.dc.w	204f-200b
	.dc.w	205f-200b
	.dc.w	206f-200b
	.dc.w	207f-200b
	.dc.w	208f-200b
	.dc.w	209f-200b
	.dc.w	210f-200b
	.dc.w	211f-200b
204:	.dc.b	'Illegal instruction',0
205:	.dc.b	'Zero divide',0
206:	.dc.b	'CHK instruction',0
207:	.dc.b	'TRAPV instruction',0
208:	.dc.b	'Privilege violation',0
209:	.dc.b	'Trace',0
210:	.dc.b	'Line 1010 emulator',0
211:	.dc.b	'Line 1111 emulator',0
	.even

	PATCH_TEXT
;----------------------------------------------------------------
;IOCSR[$AC _SYS_STAT VXe̎擾Ɛݒ
;<d1.w:[h
;	0	MPUXe[^X擾
;		>d0.l:MPUXe[^X
;			bit31-16	MPU̓gBMHzl*10
;			bit15		FPU/FPCP̗LB0=Ȃ,1=
;			bit14		MMU̗LB0=Ȃ,1=
;			bit7-0		MPU̎ށB0=68000,1=68010,2=68020,3=68030,4=68040,6=68060
;	1	LbV擾
;		>d0.l:݂̃LbV̏
;			bit1	f[^LbV0=OFF,1=ON
;			bit0	߃LbV0=OFF,1=ON
;	2	LbVݒ(SRAMݒl)
;		>d0.l:ݒ̃LbV̏
;			bit1	f[^LbV0=OFF,1=ONɂ
;			bit0	߃LbV0=OFF,1=ONɂ
;	3	LbVtbV
;	4	LbVݒ
;		<d2.l:ݒ̃LbV̏
;			bit1	f[^LbV0=OFF,1=ONɂ
;			bit0	߃LbV0=OFF,1=ONɂ
;		>d0.l:ݒÕLbV̏
;			bit1	f[^LbV0=OFF,1=ON
;			bit0	߃LbV0=OFF,1=ON
iocs_AC_SYS_STAT:
	moveq.l	#-1,d0
	ifor	<cmpi.b #2,BIOS_MPU_TYPE.w>,hs,<tst.w d1>,eq	;000/010̓[h0ȊO̓G[
		if	<cmp.w #5,d1>,lo		;[h5ȏ̓G[
			push	d1
			add.w	d1,d1
			move.w	100f(pc,d1.w),d1
			jsr	100f(pc,d1.w)
			pop
		endif
	endif
	rts

100:
	.dc.w	mpu_status-100b		;0 MPUXe[^X擾
	.dc.w	cache_get-100b		;1 LbV擾
	.dc.w	cache_default-100b	;2 LbVݒ(SRAMݒl)
	.dc.w	cache_flush-100b	;3 LbVtbV
	.dc.w	cache_set-100b		;4 LbVݒ

;----------------------------------------------------------------
;MPUXe[^X擾
;>d0.l:MPUXe[^X
;	bit31-16	MPU̓gBMHzl*10
;	bit15		FPU/FPCP̗LB0=Ȃ,1=
;	bit14		MMU̗LB0=Ȃ,1=
;	bit7-0		MPU̎ށB0=68000,1=68010,2=68020,3=68030,4=68040,6=68060
mpu_status:
	move.l	BIOS_MPU_SPEED_ROM_LONG.w,d0
;	if	eq			;IPLROM 1.6ȊOŎgƂKv
;		move.w	BIOS_MPU_SPEED_ROM.w,d0
;	endif
	move.l	d0,-(sp)		;x1
	add.l	d0,d0			;x2
	add.l	(sp)+,d0		;x3
	add.l	d0,d0			;x6
	if	<cmpi.b #2,BIOS_MPU_TYPE.w>,lo	;68000/68010
		add.l	d0,d0			;x12
	endif
	add.l	#50,d0
	divu.w	#100,d0			;MHzl*10
;	if	vs			;6553.6MHzȏ
;		moveq.l	#-1,d0
;	endif
	swap.w	d0			;ssssssss ssssssss ........ ........
	clr.w	d0			;ssssssss ssssssss 00000000 00000000
	tst.b	BIOS_MMU_TYPE.w
	sne.b	d0			;ssssssss ssssssss 00000000 mmmmmmmm
	ror.w	#1,d0			;ssssssss ssssssss m0000000 0mmmmmmm
	tst.b	BIOS_FPU_TYPE.w
	sne.b	d0			;ssssssss ssssssss m0000000 ffffffff
	ror.w	#1,d0			;ssssssss ssssssss fm000000 0fffffff
	move.b	BIOS_MPU_TYPE.w,d0	;ssssssss ssssssss fm000000 pppppppp
	rts

;----------------------------------------------------------------
;LbV擾
;>d0.l:݂̃LbV̏
;	bit1	f[^LbV0=OFF,1=ON
;	bit0	߃LbV0=OFF,1=ON
;	000/010̂Ƃ0Ԃ
cache_get:
	moveq.l	#0,d0
	if	<cmpi.b #2,BIOS_MPU_TYPE.w>,hs	;020/030/040/060
		.cpu	68030
		movec.l	cacr,d0
		if	<cmpi.b #4,BIOS_MPU_TYPE.w>,lo	;020/030
							;........ ........ .......d .......i
			ror.l	#1,d0			;i....... ........ ........ d.......
			rol.b	#1,d0			;i....... ........ ........ .......d
		else				;040/060
							;d....... ........ i....... ........
			swap.w	d0			;i....... ........ d....... ........
			rol.w	#1,d0			;i....... ........ ........ .......d
		endif
		rol.l	#1,d0			;........ ........ ........ ......di
		and.l	#3,d0			;00000000 00000000 00000000 000000di
		.cpu	68000
	endif
	rts

;----------------------------------------------------------------
;LbVݒ(SRAMݒl)
;>d0.l:ݒ̃LbV̏
;	bit1	f[^LbV0=OFF,1=ONɂ
;	bit0	߃LbV0=OFF,1=ONɂ
;	000/010̂Ƃ0Ԃ
cache_default:
	push	d2
	moveq.l	#0,d2
	move.b	SRAM_CACHE,d2		;LbVݒB------|f[^|
	bsr	cache_set		;LbVݒ
	pop
	rts

;----------------------------------------------------------------
;LbVtbV
cache_flush:
	if	<cmpi.b #2,BIOS_MPU_TYPE.w>,hs	;020/030/040/060
		.cpu	68030
		if	<cmpi.b #4,BIOS_MPU_TYPE.w>,lo	;020/030
			push	d0
			movec.l	cacr,d0
			or.w	#$0808,d0
			movec.l	d0,cacr
		;	and.w	#$F7F7,d0
		;	movec.l	d0,cacr
			pop
		else				;040/060
			.cpu	68040
			cpusha	bc
		endif
		.cpu	68000
	endif
	rts

;----------------------------------------------------------------
;LbVݒ
;<d2.l:ݒ̃LbV̏
;	bit1	f[^LbV0=OFF,1=ONɂ
;	bit0	߃LbV0=OFF,1=ONɂ
;	000/010̂Ƃ͉Ȃ
;>d0.l:ݒÕLbV̏
;	bit1	f[^LbV0=OFF,1=ON
;	bit0	߃LbV0=OFF,1=ON
;	000/010̂Ƃ0Ԃ
cache_set:
	moveq.l	#0,d0
	if	<cmpi.b #2,BIOS_MPU_TYPE.w>,hs	;020/030/040/060
		.cpu	68030
		push	d1-d3
		moveq.l	#3,d3			;d3 00000000 00000000 00000000 00000011
		and.l	d3,d2			;d2 00000000 00000000 00000000 000000di
		ror.l	#1,d2			;   i0000000 00000000 00000000 0000000d
		movec.l	cacr,d0
		if	<cmpi.b #4,BIOS_MPU_TYPE.w>,lo	;020/030
							;d0 ........ ........ .......d .......i
			neg.w	d2			;d2 i0000000 00000000 dddddddd dddddddd
			and.w	#$2101.shr.1,d2		;   i0000000 00000000 000d0000 d0000000
			rol.l	#1,d2			;   00000000 00000000 00d0000d 0000000i
			move.l	d0,d1			;d1 ........ ........ .......d .......i
			and.w	#.notw.$2101,d1		;   ........ ........ ..0....0 .......0
			or.w	d2,d1			;   ........ ........ ..d....d .......i
			movec.l	d1,cacr
			ror.l	#1,d0			;d0 i....... ........ ........ d.......
			rol.b	#1,d0			;   i....... ........ ........ .......d
		else				;040/060
							;d0 d....... ........ i....... ........
			.cpu	68040
			ror.w	#1,d2			;d2 i0000000 00000000 d0000000 00000000
			swap.w	d2			;   d0000000 00000000 i0000000 00000000
			move.l	d0,d1			;d1 d....... ........ i....... ........
			and.l	#.not.$80008000,d1	;   0....... ........ 0....... ........
			or.l	d2,d1			;   d....... ........ i....... ........
			movec.l	d1,cacr
			not.l	d2
			and.l	d0,d2			;ݒO&~ݒ
			if	mi			;f[^LbVONOFF
				cpusha	dc			;f[^LbVvbVĖ
			endif
			if	<tst.w d2>,mi		;߃LbVONOFF
				cinva	ic			;߃LbVƕLbV𖳌
			endif
			swap.w	d0			;d0 i....... ........ d....... ........
			rol.w	#1,d0			;   i....... ........ ........ .......d
		endif
		rol.l	#1,d0			;   ........ ........ ........ ......di
		and.l	d3,d0			;   00000000 00000000 00000000 000000di
		pop
		.cpu	68000
	endif
	rts

;----------------------------------------------------------------
;LbVOFF
;>d0.l:ݒÕLbV̏
;	bit1	f[^LbV0=OFF,1=ON
;	bit0	߃LbV0=OFF,1=ON
;	000/010̂Ƃ0Ԃ
cache_off:
	push	d2
	moveq.l	#0,d2
	bsr	cache_set		;LbVݒ
	pop
	rts

;----------------------------------------------------------------
;f[^LbVOFF,߃LbVON
;>d0.l:ݒÕLbV̏
;	bit1	f[^LbV0=OFF,1=ON
;	bit0	߃LbV0=OFF,1=ON
;	000/010̂Ƃ0Ԃ
cache_on_i:
	push	d2
	moveq.l	#1,d2			;f[^LbVOFF,߃LbVON
	bsr	cache_set		;LbVݒ
	pop
	rts



;----------------------------------------------------------------
;
;	_SP_INIT ŃoXG[ (IPLROM 1.0/1.1/1.2/1.3)
;	https://stdkmd.net/bugsx68k/#rom_spinit
;
;	Ǐ
;	XvCg\łȂƂ _SP_INIT  -1 ԂoXG[Ŏ~܂邱ƂB
;
;	
;	ʃ[h 18 (1024x848) ܂͉ʃ[h 19 (640x480; VGA [h)  _SP_INIT ĂяoƂB
;
;	
;	n[hEFA̐ŁACRTC  R20 ($00E80028) ̉ 5 rbg %1??1? ̂ƂAXvCg\łȂB
;	XvCg\łȂƂAXvCgXN[WX^ ($00EB0000`$00EB07FF) ܂
;	XvCg PCGEeLXgGA ($00EB8000`$00EBFFFF) ɃANZXƁAoXG[B
;	XvCg֘A IOCS R[́Aʃ[h 16 (768x512) Ɖʃ[h 17 (1024x424)  %10110 ̂ƂAXvCg\łȂƔfB
;	ʃ[h 18  %11010 Ɖʃ[h 19  %10111 ܂ %1001?  %10111  %11?1? ̓XvCg\łƌĔfA
;	_SP_INIT ANZXłȂXvCgXN[WX^悤ƂăoXG[B
;
;	⑫
;	ʃ[h 17 (1024x424) Ɖʃ[h 18 (1024x848)  IPLROM 1.0 炠邪JB
;	ʃ[h 19 (640x480; VGA [h)  X68000 Compact  IPLROM 1.2 ŒǉꂽB
;
;	
;	̃oXG[̓G~[^ł͍ČȂƂB
;
;----------------------------------------------------------------

;----------------------------------------------------------------
;	ύXO
;		00FFCC9E 303900E80028           move.w	$00E80028,d0		;[$00E80028].w:CRTC R20 [h/𑜓x(𑜓x|𑜓x|𑜓x)
;		00FFCCA4 024000FF               andi.w	#$00FF,d0
;		00FFCCA8 0C400016               cmpi.w	#$0016,d0
;		00FFCCAC 6606                   bne.s	$00FFCCB4
;		00FFCCAE 70FF                   moveq.l	#$FF,d0
;		00FFCCB0 588F                   addq.l	#4,sp
;		00FFCCB2 4E75                   rts
;
;		00FFCCB4 7000                   moveq.l	#$00,d0
;		00FFCCB6 4E75                   rts
;
;		00FFCCB8
;----------------------------------------------------------------

	PATCH_DATA	spinit,$00FFCC9E,$00FFCCB7,$303900E8
;XvCg\ł邩
;	XvCg֘AIOCSR[̐擪ŌĂяo
;	\łȂƂ-1ԂIOCSR[畜A
;>d0.l:0=XvCg\ł,-1=XvCg\łȂ
	moveq.l	#%10010,d0
	and.w	$00E80028,d0		;CRTC R20
	if	<cmp.w #%10010,d0>,eq	;%1??1?BXvCg\łȂ
		moveq.l	#-1,d0			;XvCg\łȂ
		addq.l	#4,sp			;IOCSR[畜A
	else				;̑BXvCg\ł
		moveq.l	#0,d0			;XvCg\ł
	endif
	rts



;----------------------------------------------------------------
;
;	OtBbN֌WIOCSR[o[X[hɂȂ܂܂ɂȂ
;	https://stdkmd.net/bugsx68k/#rom_drawmode
;
;----------------------------------------------------------------

;----------------------------------------------------------------
;	ύXO
;		00FFDCEA B07CFFFF               cmp.w	#$FFFF,d0
;		00FFDCEE
;----------------------------------------------------------------

	PATCH_DATA	drawmode,$00FFDCEA,$00FFDCED,$B07CFFFF
	cmp.w	#-1,d1



;----------------------------------------------------------------
;
;	v|[Visb`R\[
;	ǂƂ薂
;	͒xAҏW͍ɂȂ
;
;----------------------------------------------------------------

  .if USE_PROPORTIONAL_IOCS

	PATCH_DATA	timer_c_cursor,$00FF1D8C,$00FF1D91,$4A380992
	jmp	timer_c_cursor

	PATCH_DATA	iocs_1E_B_CURON,$00FF79CE,$00FF79D3,$4A380993
	jmp	iocs_1E_B_CURON

	PATCH_DATA	iocs_1F_B_CUROFF,$00FF79EA,$00FF79EF,$4A380993
	jmp	iocs_1F_B_CUROFF

	PATCH_DATA	iocs_20_B_PUTC,$00FF96AE,$00FF96B3,$2F016100
	jmp	iocs_20_B_PUTC

	PATCH_DATA	iocs_21_B_PRINT,$00FF96BC,$00FF96C3,$48E74020
	jmp	iocs_21_B_PRINT

	PATCH_DATA	iocs_22_B_COLOR,$00FF96D8,$00FF96DD,$700041F8
	jmp	iocs_22_B_COLOR

	PATCH_DATA	iocs_23_B_LOCATE,$00FF96F4,$00FF96FB,$20380974
	jmp	iocs_23_B_LOCATE

	PATCH_DATA	iocs_24_B_DOWN_S,$00FF9724,$00FF972B,$6100E2C4
	jmp	iocs_24_B_DOWN_S

	PATCH_DATA	iocs_25_B_UP_S,$00FF9730,$00FF9737,$6100E2B8
	jmp	iocs_25_B_UP_S

	PATCH_DATA	iocs_26_B_UP,$00FF973C,$00FF9741,$2F016100
	jmp	iocs_26_B_UP

	PATCH_DATA	iocs_27_B_DOWN,$00FF9748,$00FF974D,$2F016100
	jmp	iocs_27_B_DOWN

	PATCH_DATA	iocs_28_B_RIGHT,$00FF9754,$00FF9759,$2F016100
	jmp	iocs_28_B_RIGHT

	PATCH_DATA	iocs_29_B_LEFT,$00FF9760,$00FF9765,$2F016100
	jmp	iocs_29_B_LEFT

	PATCH_DATA	iocs_2A_B_CLR_ST,$00FF9772,$00FF9779,$48E77848
	jmp	iocs_2A_B_CLR_ST

	PATCH_DATA	iocs_2B_B_ERA_ST,$00FF9780,$00FF9787,$48E77848
	jmp	iocs_2B_B_ERA_ST

	PATCH_DATA	iocs_2C_B_INS,$00FF9796,$00FF979D,$48E77F78
	jmp	iocs_2C_B_INS

	PATCH_DATA	iocs_2D_B_DEL,$00FF97A4,$00FF97AB,$48E77F78
	jmp	iocs_2D_B_DEL

	PATCH_DATA	iocs_2E_B_CONSOL,$00FF97BA,$00FF97C1,$6100E22E
	jmp	iocs_2E_B_CONSOL

	PATCH_DATA	iocs_AE_OS_CURON,$00FFC87E,$00FFC883,$31F809BA
	jmp	iocs_AE_OS_CURON

	PATCH_DATA	iocs_AF_OS_CUROF,$00FFC8AC,$00FFC8B1,$4EB900FF
	jmp	iocs_AF_OS_CUROF

  .endif

	PATCH_TEXT



;R\[g
BIOS_ATTRIBUTE_2	equ	$0D30		;.b 2B-|t|t||ۈ͂|lp͂|v|[Vi|g
BIOS_SUPERSCRIPT_BIT	equ	 6		;t
BIOS_SUPERSCRIPT	equ	%01000000
BIOS_SUBSCRIPT_BIT	equ	  5		;t
BIOS_SUBSCRIPT		equ	%00100000
BIOS_OVERLINE_BIT	equ	    4		;
BIOS_OVERLINE		equ	%00010000
BIOS_ENCIRCLE_BIT	equ	     3		;ۈ͂
BIOS_ENCIRCLE		equ	%00001000
BIOS_FRAME_BIT		equ	      2		;lp͂
BIOS_FRAME		equ	%00000100
BIOS_PROPORTIONAL_BIT	equ	       1	;v|[Vi
BIOS_PROPORTIONAL	equ	%00000010
BIOS_WAVELINE_BIT	equ	        0	;g
BIOS_WAVELINE		equ	%00000001
BIOS_CURSOR_FRACTION	equ	$0D31		;.b J[\̌W̒[B0`7
BIOS_SAVED_ATTRIBUTE_2	equ	$0D32		;.b ESC [sŕۑꂽ2
BIOS_SAVED_FRACTION	equ	$0D33		;.b ESC [sŕۑꂽJ[\̌W̒[
BIOS_BUFFER_REQUEST	equ	$0D34		;.w obt@̕\̈̃hbgB0=obt@o͒ł͂Ȃ
BIOS_BUFFER_WIDTH	equ	$0D36		;.w obt@̃̕hbg
BIOS_BUFFER_POINTER	equ	$0D38		;.l obt@݈̏ʒu
BIOS_BUFFER_ARRAY	equ	$0D3C		;.w[64] obt@BE񂹁A񂹂Ŏg
BIOS_CONSOLE_STATUS	equ	$0DBC		;.b R\[̏ԁB----|||E|A
BIOS_ALIGN_LEFT_BIT	equ	     3		;
BIOS_ALIGN_LEFT		equ	%00001000
BIOS_ALIGN_CENTER_BIT	equ	      2		;
BIOS_ALIGN_CENTER	equ	%00000100
BIOS_ALIGN_RIGHT_BIT	equ	       1	;E
BIOS_ALIGN_RIGHT	equ	%00000010
BIOS_CONNECTION_BIT	equ	        0	;ABŌɕ`悵͎Α̂ł̌J[\𓮂ĂȂBΑ̂Ȃ΋l߂ĕ`悷
BIOS_CONNECTION		equ	%00000001
;				$0DBD		;.b[3]

;----------------------------------------------------------------
;J[\_ŏ[`
;	Timer-C荞݃[`500msԊuŌĂ΂
timer_c_cursor:
	if	<tst.b BIOS_CURSOR_ON.w>,ne	;J[\\Ƃ
		ifor	<tst.w BIOS_CURSOR_NOT_BLINK.w>,eq,<tst.b BIOS_CURSOR_DRAWN.w>,eq	;_ł邩A`ĂȂƂ
			if	<btst.b #1,CRTC_ACCESS>,eq	;CRTC̃}XNgpłȂƂ
				bsr	toggle_cursor		;J[\𔽓]
				not.b	BIOS_CURSOR_DRAWN.w	;J[\`Ă邩B0=`ĂȂ,-1=`Ă
			endif
		endif
	endif
	rts

;----------------------------------------------------------------
;J[\𔽓]
toggle_cursor:
	push	d0-d2/a0-a2
	move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW
	swap.w	d0
	clr.w	d0			;65536*sW
	lsr.l	#5,d0			;128*16*sW
	move.w	BIOS_CURSOR_COLUMN.w,d1	;J[\̌W
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d1>,hi
		move.w	BIOS_CONSOLE_RIGHT.w,d1	;E[Ŏ~܂
	endif
	add.w	d1,d0
	add.l	BIOS_CONSOLE_OFFSET.w,d0
	add.l	#$00E00000,d0		;J[\̃AhX
	movea.l	d0,a2
	move.w	CRTC_ACCESS,-(sp)
	bclr.b	#0,CRTC_ACCESS		;ANZXOFF
***	move.w	BIOS_CURSOR_PATTERN.w,d1
***	if	eq
***		moveq.l	#-1,d1
***	endif
	moveq.l	#$80,d1
	move.b	BIOS_CURSOR_FRACTION.w,d0
	lsr.b	d0,d1
	bsr	toggle_cursor_1		;v[0𔽓]
***	lsr.w	#8,d1
	adda.l	#$00020000,a2
	bsr	toggle_cursor_1		;v[1𔽓]
	move.w	(sp)+,CRTC_ACCESS
	pop
	rts

toggle_cursor_1:
	move.w	BIOS_CURSOR_START.w,d2	;J[\`JnC*4
	jmp	@f(pc,d2.w)
@@:	eor.b	d1,(a2)
	movea.l	a0,a0			;nop
  .irp row,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
	eor.b	d1,128*row(a2)
  .endm
	rts

;----------------------------------------------------------------
;IOCSR[$1E _B_CURON J[\\
iocs_1E_B_CURON:
	ifand	<tst.b BIOS_CURSOR_PROHIBITED.w>,eq,<tst.b BIOS_CURSOR_ON.w>,eq	;Ăĕ\ĂȂƂ
		move.w	#5,BIOS_TC_CURSOR_COUNTER.w	;^C}JE^B1ڂ10ms*5=50msɔ
		st.b	BIOS_CURSOR_ON.w	;\Ă
		clr.b	BIOS_CURSOR_DRAWN.w	;`ĂȂ
	endif
	rts

;----------------------------------------------------------------
;IOCSR[$1F _B_CUROFF J[\\Ȃ
iocs_1F_B_CUROFF:
	if	<tst.b BIOS_CURSOR_PROHIBITED.w>,eq	;ĂƂ
		move.w	#5,BIOS_TC_CURSOR_COUNTER.w	;^C}JE^B1ڂ10ms*5=50msɔ
		clr.b	BIOS_CURSOR_ON.w	;\ĂȂ
		if	<tst.b BIOS_CURSOR_DRAWN.w>,ne	;`ĂƂ
			bsr	toggle_cursor		;J[\𔽓]
			clr.b	BIOS_CURSOR_DRAWN.w	;`ĂȂ
		endif
	endif
	rts

;----------------------------------------------------------------
;IOCSR[$20 _B_PUTC \
;<d1.w:R[h
;>d0.l:\̃J[\̌W<<16|J[\̍sW
iocs_20_B_PUTC:
	bsr	putc			;1\
	move.l	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W<<16|J[\̍sW
	rts

;----------------------------------------------------------------
;IOCSR[$21 _B_PRINT \
;<a1.l:̃AhX
;>d0.l:\̃J[\̌W<<16|J[\̍sW
;>a1.l:̖0̎̃AhXB}jAɏĂBύXs
iocs_21_B_PRINT:
	push	d1
	dostart
		bsr	putc			;1\
	start
		moveq.l	#0,d1
		move.b	(a1)+,d1
	while	ne
	pop
	move.l	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W<<16|J[\̍sW
	rts

;----------------------------------------------------------------
;IOCSR[$22 _B_COLOR ݒ肷
;<d1.w:B-1=擾̂
;	0	
;	1	F
;	2	F
;	3	
;	4+	
;	8+	]
;>d0.l:ݒO̕B-1=ݒl͈͊O
iocs_22_B_COLOR:
	push	d1
	moveq.l	#0,d0
	move.b	BIOS_ATTRIBUTE_1.w,d0	;2B-|t|t||ۈ͂|lp͂|v|[Vi|g
	lsl.w	#8,d0
	move.b	BIOS_ATTRIBUTE_1.w,d0	;1B||Α|׎|]||v[##
	if	<cmp.w #-1,d1>,ne	;ݒ肷Ƃ
		if	<cmp.w #$7FFF,d1>,ls	;ݒl͈͓̂Ƃ
			move.b	d1,BIOS_ATTRIBUTE_1.w
			lsr.w	#8,d1
			move.b	d1,BIOS_ATTRIBUTE_2.w
		else				;ݒl͈͊ÔƂ
			moveq.l	#-1,d0
		endif
	endif
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$23 _B_LOCATE J[\̍Wݒ肷
;<d1.w:J[\̌W̒[<<8|J[\̌WB-1=擾̂
;<d2.w:J[\̍sW
;>d0.l:ݒÕJ[\̍WBJ[\̌W̒[<<24|J[\̌W<<16|J[\̍sWB-1=ݒl͈͊O
;>d1.l:(IOCS.X,1.3ȏ)擾݂̂̂Ƃd0.lƓ
iocs_23_B_LOCATE:
	moveq.l	#0,d0
	move.b	BIOS_CURSOR_FRACTION.w,d0
	ror.l	#8,d0
	or.l	BIOS_CURSOR_COLUMN.w,d0	;BIOS_CURSOR_ROWBJ[\̌W̒[<<24|J[\̌W<<16|J[\̍sW
	if	<cmp.w #-1,d1>,eq	;擾̂
		move.l	d0,d1
		rts
	endif
	push	d1/d3
	move.w	d1,d3
	and.w	#$00FF,d1		;J[\̌W
	lsr.w	#8,d3			;J[\̌W̒[
	ifand	<cmp.w BIOS_CONSOLE_RIGHT.w,d1>,ls,<cmp.w BIOS_CONSOLE_BOTTOM.w,d2>,ls,<cmp.w #7,d3>,ls	;ݒl͈͓̂Ƃ
;		push	d0
		bsr	iocs_1F_B_CUROFF
		move.w	d1,BIOS_CURSOR_COLUMN.w
		move.w	d2,BIOS_CURSOR_ROW.w
		move.b	d3,BIOS_CURSOR_FRACTION.w
		bsr	iocs_1E_B_CURON
;		pop	d0
	else				;ݒl͈͊ÔƂ
		moveq.l	#-1,d0
	endif
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$24 _B_DOWN_S J[\1sցB[ł̓XN[Abv
;>d0.l:0
iocs_24_B_DOWN_S:
	push	d1-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
		addq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		moveq.l	#0,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$25 _B_UP_S J[\1sցB[ł̓XN[_E
;>d0.l:0
iocs_25_B_UP_S:
	push	d1-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<tst.w d0>,hi	;[ł͂ȂƂ
		subq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#0,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1
		subq.w	#1,d1			;Rs[̉[̍sW
		moveq.l	#1,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		moveq.l	#0,d0			;[̍sW
		moveq.l	#0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$26 _B_UP J[\nsցB[𒴂Ƃ͓Ȃ
;<d1.b:ړsB0=1s
;>d0.l:0=,-1=sB[𒴂B̂ƂJ[\͓Ȃ
iocs_26_B_UP:
	push	d1
	bsr	iocs_1F_B_CUROFF
	and.w	#$00FF,d1
	if	eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW
	sub.w	d1,d0			;ns
	if	mi			;[𒴂
		moveq.l	#-1,d1
	else				;[𒴂Ȃ
		move.w	d0,BIOS_CURSOR_ROW.w
		moveq.l	#0,d1
	endif
	bsr	iocs_1E_B_CURON
	move.l	d1,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$27 _B_DOWN J[\nsցB[Ŏ~܂
;<d1.b:ړsB0=1s
;>d0.l:0
iocs_27_B_DOWN:
	push	d1
	bsr	iocs_1F_B_CUROFF
	and.w	#$00FF,d1
	if	eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW
	add.w	d1,d0			;ns
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,hi	;[𒴂
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_ROW.w
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$28 _B_RIGHT J[\nEցBE[Ŏ~܂
;<d1.w:ړ錅B0=1
;>d0.l:0
iocs_28_B_RIGHT:
	push	d1
	bsr	iocs_1F_B_CUROFF
	and.w	#$00FF,d1
	if	eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W
	add.w	d1,d0			;nsE
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,hi	;E[𒴂
		move.w	BIOS_CONSOLE_RIGHT.w,d0	;E[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_COLUMN.w
	clr.b	BIOS_CURSOR_FRACTION.w
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$29 _B_LEFT J[\nցB[Ŏ~܂
;<d1.w:ړ錅B0=1
;>d0.l:0
iocs_29_B_LEFT:
	push	d1
	bsr	iocs_1F_B_CUROFF
	and.w	#$00FF,d1
	if	eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W
	sub.w	d1,d0			;ns
	if	mi			;[𒴂
		clr.w	d0			;[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_COLUMN.w
	clr.b	BIOS_CURSOR_FRACTION.w
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$2A _B_CLR_ST ͈͂Iĉʂ
;<d1.b:͈́B0=J[\E܂,1=ォJ[\܂,2=ォE܂ŁBJ[\
;>d0.l:0=,-1=sB
iocs_2A_B_CLR_ST:
	push	d1
	bsr	iocs_1F_B_CUROFF
	if	<subq.b #1,d1>,lo	;0=J[\E܂
		bsr	putc_csi_0J		;ESC [0J J[\E܂ŏ
		moveq.l	#0,d1
	elif	eq			;1=ォJ[\܂
		bsr	putc_csi_1J		;ESC [1J ォJ[\܂ŏ
		moveq.l	#0,d1
	elif	<subq.b #3-1,d1>,lo	;2=ォE܂
		bsr	putc_csi_2J		;ESC [2J ォE܂ŏBJ[\
		moveq.l	#0,d1
	else
		moveq.l	#-1,d1
	endif
	bsr	iocs_1E_B_CURON
	move.l	d1,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$2B _B_ERA_ST ͈͂Ičs
;<d1.b:͈́B0=J[\E[܂,1=[J[\܂,2=[E[܂
;>d0.l:0=,-1=sB
iocs_2B_B_ERA_ST:
	push	d1
	bsr	iocs_1F_B_CUROFF
	if	<subq.b #1,d1>,lo	;0=J[\E[܂
		bsr	putc_csi_0K		;ESC [0K J[\E[܂ŏ
		moveq.l	#0,d1
	elif	eq			;1=[J[\܂
		bsr	putc_csi_1K		;ESC [1K [J[\܂ŏ
		moveq.l	#0,d1
	elif	<subq.b #3-1,d1>,lo	;2=[E[܂
		bsr	putc_csi_2K		;ESC [2K [E[܂ŏ
		moveq.l	#0,d1
	else				;
		moveq.l	#-1,d1
	endif
	bsr	iocs_1E_B_CURON
	move.l	d1,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$2C _B_INS J[\牺ns}BJ[\[
;<d1.w:}sB0=1s
;>d0.l:0
iocs_2C_B_INS:
	push	d1
	bsr	iocs_1F_B_CUROFF
	bsr	putc_csi_L		;ESC [nL J[\牺ns}BJ[\[
	bsr	iocs_1E_B_CURON
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$2D _B_DEL J[\牺ns폜BJ[\[
;<d1.w:폜sB0=1s
;>d0.l:0
iocs_2D_B_DEL:
	push	d1
	bsr	iocs_1F_B_CUROFF
	bsr	putc_csi_M		;ESC [nM J[\牺ns폜BJ[\[
	bsr	iocs_1E_B_CURON
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$2E _B_CONSOL R\[͈̔͂ݒBJ[\
;<d1.l:XhbgW<<16|YhbgWB-1=擾̂݁BXhbgW8̔{AYhbgW4̔{
;<d2.l:E[̌W<<16|[̍sWB-1=擾̂
;>d0.l:0
;>d1.l:ݒO̍XhbgW<<16|YhbgW
;>d2.l:ݒỎE[̌W<<16|[̍sW
iocs_2E_B_CONSOL:
	bsr	iocs_1F_B_CUROFF
	move.l	BIOS_CONSOLE_OFFSET.w,d0
	if	<cmp.l #-1,d1>,ne
		and.l	#($03F8<<16)|$03FC,d1
		move.l	d1,d0
		swap.w	d0		;XhbgW
		lsr.w	#3,d0		;XhbgW/8
		ext.l	d1
		lsl.l	#7,d1		;YhbgW*128
		add.w	d0,d1
		move.l	BIOS_CONSOLE_OFFSET.w,d0
		move.l	d1,BIOS_CONSOLE_OFFSET.w
		clr.l	BIOS_CURSOR_COLUMN.w	;BIOS_CURSOR_ROW.wBJ[\
	endif
	moveq.l	#127,d1
	and.w	d0,d1			;XhbgW/8
	lsl.w	#3,d1			;XhbgW
	swap.w	d1
	lsr.l	#7,d0			;YhbgW
	move.w	d0,d1			;ݒO̍XhbgW<<16|YhbgW
	move.l	BIOS_CONSOLE_RIGHT.w,d0	;BIOS_CONSOLE_BOTTOM.w
	if	<cmp.l #-1,d2>,ne
		and.l	#127<<16|63,d2
		move.l	d2,BIOS_CONSOLE_RIGHT.w	;BIOS_CONSOLE_BOTTOM.w
		clr.l	BIOS_CURSOR_COLUMN.w	;BIOS_CURSOR_ROW.wBJ[\
	endif
	move.l	d0,d2			;ݒỎE[̌W<<16|[̍sW
	bsr	iocs_1E_B_CURON
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$AE _OS_CURON J[\̕\
iocs_AE_OS_CURON:
	move.w	BIOS_TC_CURSOR_PERIOD.w,BIOS_TC_CURSOR_COUNTER.w	;^C}JE^lɂ
	di				;݋֎~
	ifor	<tst.b BIOS_CURSOR_PROHIBITED.w>,ne,<tst.b BIOS_CURSOR_DRAWN.w>,eq	;֎~Ă邩`ĂȂƂ
		bsr	toggle_cursor		;J[\𔽓]
		st.b	BIOS_CURSOR_DRAWN.w	;`Ă
	endif
	st.b	BIOS_CURSOR_ON.w		;\Ă
	sf.b	BIOS_CURSOR_PROHIBITED.w	;Ă
	ei				;荞݋
	rts

;----------------------------------------------------------------
;IOCSR[$AF _OS_CUROF J[\̕\֎~
iocs_AF_OS_CUROF:
	bsr	iocs_1F_B_CUROFF
	st.b	BIOS_CURSOR_PROHIBITED.w	;֎~Ă
	rts

;----------------------------------------------------------------
;1\
;<d1.w:R[h
putc:
	push	d0-d1
	if	<move.b BIOS_PUTC_POOL.w,d0>,eq	;1oCgڂ̂Ƃ
		if	<cmp.w #$001F,d1>,ls	;$0000`$001F̂Ƃ
			bsr	putc_control		;䕶
		elif	<cmp.w #$007F,d1>,ls	;$0020`$007F̂Ƃ
			if	<cmp.w #$005C,d1>,eq	;$005ĈƂ
				if	<btst.b #0,SRAM_XCHG>,ne	;ϊtOB-----|$7Cb/$82U|$7EP/$81`|$5C/$80_
					move.w	#$0080,d1		;$5C$80
				endif
			elif	<cmp.w #$007E,d1>,eq	;$007ÊƂ
				if	<btst.b #1,SRAM_XCHG>,ne	;ϊtOB-----|$7Cb/$82U|$7EP/$81`|$5C/$80_
					move.w	#$0081,d1		;$7E$81
				endif
			elif	<cmp.w #$007C,d1>,eq	;$007ĈƂ
				if	<btst.b #2,SRAM_XCHG>,ne	;ϊtOB-----|$7Cb/$82U|$7EP/$81`|$5C/$80_
					move.w	#$0082,d1		;$7C$82
				endif
			endif
			bsr	putc_output		;ʂɕ`܂̓obt@ɏo͂
		elif	<cmp.w #$009F,d1>,ls	;$0080`$009F̂Ƃ
			move.b	d1,BIOS_PUTC_POOL.w	;1oCgڂ̃v[
		elif	<cmp.w #$00DF,d1>,ls	;$00A0`$00DF̂Ƃ
			bsr	putc_output		;ʂɕ`܂̓obt@ɏo͂
		elif	<cmp.w #$00FF,d1>,ls	;$00E0`$00FF̂Ƃ
			move.b	d1,BIOS_PUTC_POOL.w	;1oCgڂ̃v[
		else				;$0100`$FFFF̂Ƃ
			bsr	putc_output		;ʂɕ`܂̓obt@ɏo͂
		endif
	else				;2oCgڂ̂Ƃ
		if	<cmp.b #$1B,d0>,eq	;1oCgڂ$1B̂ƂBGXP[vV[PX̏o͒
			bsr	putc_escape		;GXP[vV[PX
		else				;1oCgڂ$1Bł͂ȂƂ
			clr.b	BIOS_PUTC_POOL.w	;1oCgڂ
			lsl.w	#8,d0			;1oCg<<8
			move.b	d1,d0			;1oCg<<8|2oCg
			move.w	d0,d1			;1oCg<<8|2oCgځB1oCgڂƂd1.w̏ʃoCg͖
			bsr	putc_output		;ʂɕ`܂̓obt@ɏo͂
		endif
	endif
	pop
	rts

;----------------------------------------------------------------
;obt@o͂I
putc_finish_buffer:
	push	d0-d6/a0-a1
	move.w	BIOS_BUFFER_REQUEST.w,d0
	goto	eq,putc_finish_buffer_end	;obt@o͒ł͂Ȃ
;<d0.w:obt@̕\̈̃hbg
	move.w	BIOS_BUFFER_WIDTH.w,d1
;<d1.w:obt@̃̕hbg
	movea.l	BIOS_BUFFER_POINTER.w,a0
;<a0.l:obt@݈̏ʒu=̒
	lea.l	BIOS_BUFFER_ARRAY.w,a1
;<a1.l:obt@=̐擪
	clr.w	BIOS_BUFFER_REQUEST.w	;obt@o͏IBċAĂяoŕ\̂ł̑OɏI邱
	clr.w	BIOS_BUFFER_WIDTH.w
	move.l	a1,BIOS_BUFFER_POINTER.w
	sub.w	d1,d0			;]hbg
;<d0.w:]hbg
	if	ls			;]ȂƂ
	;\
		do
			move.w	(a1)+,d1
			bsr	putc_output
		while	<cmpa.w a0,a1>,lo
	elif	<bclr.b #BIOS_ALIGN_LEFT_BIT,BIOS_CONSOLE_STATUS.w>,ne	;񂹂ŗ]Ƃ
	;\
		do
			move.w	(a1)+,d1
			bsr	putc_output
		while	<cmpa.w a0,a1>,lo
	;E̗]͈͂
		moveq.l	#0,d4
		move.b	BIOS_CURSOR_FRACTION.w,d4	;d4=[̌W̒[
		add.w	d4,d0
		subq.w	#1,d0
		moveq.l	#7,d5
		and.w	d0,d5				;d5=E[̌W̒[
		lsr.w	#3,d0
		move.w	BIOS_CURSOR_COLUMN.w,d2		;d2=[̌W
		add.w	d2,d0
		move.w	d0,d3				;d3=E[̌W
		move.w	BIOS_CURSOR_ROW.w,d0		;d0=[̍sW
		move.w	d0,d1				;d1=[̍sW
		bsr	putc_clear
	;J[\𓮂
		addq.w	#1,d5
		if	<cmp.w #8,d5>,hs
			subq.w	#8,d5
			addq.w	#1,d3
		endif
		move.w	d3,BIOS_CURSOR_COLUMN.w
		move.b	d5,BIOS_CURSOR_FRACTION.w
	elif	<bclr.b #BIOS_ALIGN_RIGHT_BIT,BIOS_CONSOLE_STATUS.w>,ne	;E񂹂ŗ]Ƃ
	;̗]͈͂
		moveq.l	#0,d4
		move.b	BIOS_CURSOR_FRACTION.w,d4	;d4=[̌W̒[
		add.w	d4,d0
		subq.w	#1,d0
		moveq.l	#7,d5
		and.w	d0,d5				;d5=E[̌W̒[
		lsr.w	#3,d0
		move.w	BIOS_CURSOR_COLUMN.w,d2		;d2=[̌W
		add.w	d2,d0
		move.w	d0,d3				;d3=E[̌W
		move.w	BIOS_CURSOR_ROW.w,d0		;d0=[̍sW
		move.w	d0,d1				;d1=[̍sW
		bsr	putc_clear
	;J[\𓮂
		addq.w	#1,d5
		if	<cmp.w #8,d5>,hs
			subq.w	#8,d5
			addq.w	#1,d3
		endif
		move.w	d3,BIOS_CURSOR_COLUMN.w
		move.b	d5,BIOS_CURSOR_FRACTION.w
	;\
		do
			move.w	(a1)+,d1
			bsr	putc_output
		while	<cmpa.w a0,a1>,lo
	elif	<bclr.b #BIOS_ALIGN_CENTER_BIT,BIOS_CONSOLE_STATUS.w>,ne	;񂹂ŗ]Ƃ
	;̗]͈͂
		move.w	d0,d6
		lsr.w	#1,d0			;̗]͈͂̃hbg
		sub.w	d0,d6			;E̗]͈͂̃hbg
		moveq.l	#0,d4
		move.b	BIOS_CURSOR_FRACTION.w,d4	;d4=[̌W̒[
		add.w	d4,d0
		subq.w	#1,d0
		moveq.l	#7,d5
		and.w	d0,d5				;d5=E[̌W̒[
		lsr.w	#3,d0
		move.w	BIOS_CURSOR_COLUMN.w,d2		;d2=[̌W
		add.w	d2,d0
		move.w	d0,d3				;d3=E[̌W
		move.w	BIOS_CURSOR_ROW.w,d0		;d0=[̍sW
		move.w	d0,d1				;d1=[̍sW
		bsr	putc_clear
	;J[\𓮂
		addq.w	#1,d5
		if	<cmp.w #8,d5>,hs
			subq.w	#8,d5
			addq.w	#1,d3
		endif
		move.w	d3,BIOS_CURSOR_COLUMN.w
		move.b	d5,BIOS_CURSOR_FRACTION.w
	;\
		do
			move.w	(a1)+,d1
			bsr	putc_output
		while	<cmpa.w a0,a1>,lo
	;E̗]͈͂
		move.w	d6,d0
		moveq.l	#0,d4
		move.b	BIOS_CURSOR_FRACTION.w,d4	;d4=[̌W̒[
		add.w	d4,d0
		subq.w	#1,d0
		moveq.l	#7,d5
		and.w	d0,d5				;d5=E[̌W̒[
		lsr.w	#3,d0
		move.w	BIOS_CURSOR_COLUMN.w,d2		;d2=[̌W
		add.w	d2,d0
		move.w	d0,d3				;d3=E[̌W
		move.w	BIOS_CURSOR_ROW.w,d0		;d0=[̍sW
		move.w	d0,d1				;d1=[̍sW
		bsr	putc_clear
	;J[\𓮂
		addq.w	#1,d5
		if	<cmp.w #8,d5>,hs
			subq.w	#8,d5
			addq.w	#1,d3
		endif
		move.w	d3,BIOS_CURSOR_COLUMN.w
		move.b	d5,BIOS_CURSOR_FRACTION.w
	endif
putc_finish_buffer_end:
	pop
	rts

;----------------------------------------------------------------
;䕶
;<d1.w:R[h
putc_control:
	push	d0-d1
;obt@o͂I
	if	<tst.w BIOS_BUFFER_REQUEST.w>,ne	;obt@o͒
		bsr	putc_finish_buffer	;obt@o͂I
	endif
;J[\E[͂ݏoĂƂBSłȂΉs
	move.w	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W
	ifand	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,hi,<cmp.w #$0008,d1>,ne	;J[\E[͂ݏoĂ邩BSł͂ȂƂ
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
;䕶
	add.w	d1,d1
	move.w	putc_control_jump_table(pc,d1.w),d1
	jsr	putc_control_jump_table(pc,d1.w)
	pop
	rts

putc_control_jump_table:
	.dc.w	putc_00_NL-putc_control_jump_table	;䕶$00 NL 
	.dc.w	putc_01_SH-putc_control_jump_table	;䕶$01 SH 
	.dc.w	putc_02_SX-putc_control_jump_table	;䕶$02 SX 
	.dc.w	putc_03_EX-putc_control_jump_table	;䕶$03 EX 
	.dc.w	putc_04_ET-putc_control_jump_table	;䕶$04 ET 
	.dc.w	putc_05_EQ-putc_control_jump_table	;䕶$05 EQ 
	.dc.w	putc_06_AK-putc_control_jump_table	;䕶$06 AK 
	.dc.w	putc_07_BL-putc_control_jump_table	;䕶$07 BL x炷
	.dc.w	putc_08_BS-putc_control_jump_table	;䕶$08 BS J[\1ցB[ł1s̉E[ցB[ł͉Ȃ
	.dc.w	putc_09_HT-putc_control_jump_table	;䕶$09 HT J[\̃^uցBȂ1s̍[ցB[ł̓XN[Abvč[
	.dc.w	putc_0A_LF-putc_control_jump_table	;䕶$0A LF J[\1sցB[ł̓XN[Abv
	.dc.w	putc_0B_VT-putc_control_jump_table	;䕶$0B VT J[\1sցB[ł͉Ȃ
	.dc.w	putc_0C_FF-putc_control_jump_table	;䕶$0C FF J[\1EցBE[ł1s̍[ցB[ł̓XN[Abvč[
	.dc.w	putc_0D_CR-putc_control_jump_table	;䕶$0D CR J[\[
	.dc.w	putc_0E_SO-putc_control_jump_table	;䕶$0E SO 
	.dc.w	putc_0F_SI-putc_control_jump_table	;䕶$0F SI 
	.dc.w	putc_10_DE-putc_control_jump_table	;䕶$10 DE 
	.dc.w	putc_11_D1-putc_control_jump_table	;䕶$11 D1 
	.dc.w	putc_12_D2-putc_control_jump_table	;䕶$12 D2 
	.dc.w	putc_13_D3-putc_control_jump_table	;䕶$13 D3 
	.dc.w	putc_14_D4-putc_control_jump_table	;䕶$14 D4 
	.dc.w	putc_15_NK-putc_control_jump_table	;䕶$15 NK 
	.dc.w	putc_16_SN-putc_control_jump_table	;䕶$16 SN 
	.dc.w	putc_17_EB-putc_control_jump_table	;䕶$17 EB 
	.dc.w	putc_18_CN-putc_control_jump_table	;䕶$18 CN 
	.dc.w	putc_19_EM-putc_control_jump_table	;䕶$19 EM 
	.dc.w	putc_1A_SB-putc_control_jump_table	;䕶$1A SB ォE܂ŏBJ[\
	.dc.w	putc_1B_EC-putc_control_jump_table	;䕶$1B EC GXP[vV[PXJn
	.dc.w	putc_1C_FS-putc_control_jump_table	;䕶$1C FS 
	.dc.w	putc_1D_GS-putc_control_jump_table	;䕶$1D GS 
	.dc.w	putc_1E_RS-putc_control_jump_table	;䕶$1E RS J[\
	.dc.w	putc_1F_US-putc_control_jump_table	;䕶$1F US 

;----------------------------------------------------------------
;䕶$00 NL 
putc_00_NL:
	rts

;----------------------------------------------------------------
;䕶$01 SH 
putc_01_SH:
	rts

;----------------------------------------------------------------
;䕶$02 SX 
putc_02_SX:
	rts

;----------------------------------------------------------------
;䕶$03 EX 
putc_03_EX:
	rts

;----------------------------------------------------------------
;䕶$04 ET 
putc_04_ET:
	rts

;----------------------------------------------------------------
;䕶$05 EQ 
putc_05_EQ:
	rts

;----------------------------------------------------------------
;䕶$06 AK 
putc_06_AK:
	rts

;----------------------------------------------------------------
;䕶$07 BL x炷
putc_07_BL:
	push	d0-d2/a0-a1
	move.l	BIOS_BEEP_DATA.w,d0	;BEEPADPCMf[^̃AhXB-1=BIOS_BEEP_EXTENSIONg
	moveq.l	#-1,d1
	if	<cmp.l d1,d0>,eq
		movea.l	BIOS_BEEP_EXTENSION.w,a0	;BEEP܂邲ƍ[`̃AhXBBIOS_BEEP_DATA=-1̂ƂL
		jsr	(a0)
	else
		move.w	#4<<8|3,d1
		moveq.l	#0,d2
		move.w	BIOS_BEEP_LENGTH.w,d2	;BEEPADPCMf[^̃oCgB0=
		movea.l	d0,a1
		IOCS	_ADPCMOUT
	endif
	pop
	rts

;----------------------------------------------------------------
;䕶$08 BS J[\1ցB[ł1s̉E[ցB[ł͉Ȃ
putc_08_BS:
	push	d0
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_COLUMN.w,d0
	if	ne
		subq.w	#1,d0			;1
		move.w	d0,BIOS_CURSOR_COLUMN.w
		clr.b	BIOS_CURSOR_FRACTION.w
	else
		move.w	BIOS_CURSOR_ROW.w,d0
		if	ne
			subq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
			move.w	BIOS_CONSOLE_RIGHT.w,BIOS_CURSOR_COLUMN.w	;E[
			clr.b	BIOS_CURSOR_FRACTION.w
		endif
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$09 HT J[\̃^uցBȂ1s̍[ցB[ł̓XN[Abvč[
putc_09_HT:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_COLUMN.w,d0
	addq.w	#8,d0
	and.w	#-8,d0			;̃^u
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,ls	;͈͓
		move.w	d0,BIOS_CURSOR_COLUMN.w
		clr.b	BIOS_CURSOR_FRACTION.w
	else				;͈͊O
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0A LF J[\1sցB[ł̓XN[Abv
putc_0A_LF:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
		addq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		moveq.l	#0,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0B VT J[\1sցB[ł͉Ȃ
putc_0B_VT:
	push	d0
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	hi
		subq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0C FF J[\1EցBE[ł1s̍[ցB[ł̓XN[Abvč[
putc_0C_FF:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_COLUMN.w,d0
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,lo	;E[ł͂ȂƂ
		addq.w	#1,d0			;1E
		move.w	d0,BIOS_CURSOR_COLUMN.w
		clr.b	BIOS_CURSOR_FRACTION.w
	else				;E[̂Ƃ
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0D CR J[\[
putc_0D_CR:
	push	d0
	bsr	iocs_1F_B_CUROFF
	clr.w	BIOS_CURSOR_COLUMN.w	;[
	clr.b	BIOS_CURSOR_FRACTION.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0E SO 
putc_0E_SO:
	rts

;----------------------------------------------------------------
;䕶$0F SI 
putc_0F_SI:
	rts

;----------------------------------------------------------------
;䕶$10 DE 
putc_10_DE:
	rts

;----------------------------------------------------------------
;䕶$11 D1 
putc_11_D1:
	rts

;----------------------------------------------------------------
;䕶$12 D2 
putc_12_D2:
	rts

;----------------------------------------------------------------
;䕶$13 D3 
putc_13_D3:
	rts

;----------------------------------------------------------------
;䕶$14 D4 
putc_14_D4:
	rts

;----------------------------------------------------------------
;䕶$15 NK 
putc_15_NK:
	rts

;----------------------------------------------------------------
;䕶$16 SN 
putc_16_SN:
	rts

;----------------------------------------------------------------
;䕶$17 EB 
putc_17_EB:
	rts

;----------------------------------------------------------------
;䕶$18 CN 
putc_18_CN:
	rts

;----------------------------------------------------------------
;䕶$19 EM 
putc_19_EM:
	rts

;----------------------------------------------------------------
;䕶$1A SB ォE܂ŏBJ[\
putc_1A_SB:
	push	d0-d1
	bsr	iocs_1F_B_CUROFF
	clr.w	d0			;[̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
	bsr	putc_clear_rows		;s
	clr.l	BIOS_CURSOR_COLUMN.w	;
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$1B EC GXP[vV[PXJn
putc_1B_EC:
	move.b	#$1B,BIOS_PUTC_POOL.w	;1oCgڂ̃v[
	move.l	#BIOS_ESCAPE_BUFFER,BIOS_ESCAPE_POINTER.w	;GXP[vV[PXobt@݈̏ʒu
	rts

;----------------------------------------------------------------
;䕶$1C FS 
putc_1C_FS:
	rts

;----------------------------------------------------------------
;䕶$1D GS 
putc_1D_GS:
	rts

;----------------------------------------------------------------
;䕶$1E RS J[\
putc_1E_RS:
	bsr	iocs_1F_B_CUROFF
	clr.l	BIOS_CURSOR_COLUMN.w
	bsr	iocs_1E_B_CURON
	rts

;----------------------------------------------------------------
;䕶$1F US 
putc_1F_US:
	rts

;----------------------------------------------------------------
;GXP[vV[PX
;<d1.w:R[h
putc_escape:
	push	d0/a0
	movea.l	BIOS_ESCAPE_POINTER.w,a0
	move.b	d1,(a0)+
	if	<cmpa.l #BIOS_ESCAPE_BUFFER+10,a0>,lo
		move.l	a0,BIOS_ESCAPE_POINTER.w
	endif
	move.b	BIOS_ESCAPE_BUFFER.w,d0	;GXP[vV[PX̍ŏ̕
	if	<cmp.b #'[',d0>,eq	;ESC [
		moveq.l	#$20,d0
		or.b	d1,d0
		ifand	<cmp.b #'`',d0>,hs,<cmp.b #'z',d0>,ls	;'@'`'Z','`'`'z'
			bsr	putc_csi
		endif
	elif	<cmp.b #'*',d0>,eq	;ESC *
		bsr	putc_esc_ast
	elif	<cmp.b #'=',d0>,eq	;ESC =
		if	<cmpa.l #BIOS_ESCAPE_BUFFER+3,a0>,eq
			bsr	putc_esc_equ
		endif
	elif	<cmp.b #'D',d0>,eq	;ESC D
		bsr	putc_esc_D
	elif	<cmp.b #'E',d0>,eq	;ESC E
		bsr	putc_esc_E
	elif	<cmp.b #'M',d0>,eq	;ESC M
		bsr	putc_esc_M
	else				;̑
		clr.b	BIOS_PUTC_POOL.w
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC *
;	ォE܂ŏBJ[\
putc_esc_ast:
	push	d0-d1
	bsr	iocs_1F_B_CUROFF
	clr.w	d0			;[̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
	bsr	putc_clear_rows		;s
	clr.l	BIOS_CURSOR_COLUMN.w	;J[\
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC = r c
;	J[\r-' 's,c-' 'ցBrc͕
putc_esc_equ:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	moveq.l	#0,d1
	moveq.l	#0,d2
	move.b	BIOS_ESCAPE_BUFFER+2.w,d1	;B' '=0
	move.b	BIOS_ESCAPE_BUFFER+1.w,d2	;sB' '=0
	moveq.l	#' ',d0
	sub.w	d0,d1			;W
	sub.w	d0,d2			;sW
	ifand	<cmp.w BIOS_CONSOLE_RIGHT.w,d1>,ls,<cmp.w BIOS_CONSOLE_BOTTOM.w,d2>,ls	;R\[͈͓̔̂Ƃ
		move.w	d1,BIOS_CURSOR_COLUMN.w
		move.w	d2,BIOS_CURSOR_ROW.w
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC D
;	J[\1sցB[ł̓XN[Abv
;	_B_DOWN_SƓ
putc_esc_D:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
		addq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		moveq.l	#0,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC E
;	J[\1s̍[ցB[ł̓XN[Abv
putc_esc_E:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
		addq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		moveq.l	#0,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.w	BIOS_CURSOR_COLUMN.w	;[
	clr.b	BIOS_CURSOR_FRACTION.w
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC M
;	J[\1sցB[ł̓XN[_E
;	_B_UP_SƓ
putc_esc_M:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<tst.w d0>,hi		;[ł͂ȂƂ
		subq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#0,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1
		subq.w	#1,d1			;Rs[̉[̍sW
		moveq.l	#1,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		moveq.l	#0,d0			;[̍sW
		moveq.l	#0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC [
;	https://en.wikipedia.org/wiki/ANSI_escape_code
;	http://nanno.dip.jp/softlib/man/rlogin/ctrlcode.html
putc_csi:
	push	d0-d3/a0
	bsr	iocs_1F_B_CUROFF
	move.l	BIOS_CSI_EXTENSION.w,d0	;GXP[vV[PXۂƍւ[`
	if	ne
		lea.l	BIOS_ESCAPE_BUFFER.w,a0
		movejsr	d0
	else
		lea.l	BIOS_ESCAPE_BUFFER.w,a0
		move.w	(a0)+,d0
		if	<cmp.w #'[>',d0>,eq	;ESC [>
			move.w	(a0)+,d0
			if	<cmp.w #'5l',d0>,eq	;ESC [>5l J[\ON
				sf.b	BIOS_CURSOR_PROHIBITED.w
			elif	<cmp.w #'5h',d0>,eq	;ESC [>5h J[\OFF
				st.b	BIOS_CURSOR_PROHIBITED.w
			else
				bsr	putc_csi_extension
			endif
		elif	<cmp.w #'[?',d0>,eq	;ESC [?
			move.w	(a0)+,d0
			if	<cmp.w #'4l',d0>,eq	;ESC [?4l WvXN[
				clr.w	BIOS_SMOOTH_SCROLL.w
			elif	<cmp.w #'4h',d0>,eq	;ESC [?4h 8hbgX[XXN[
				move.w	#2,BIOS_SMOOTH_SCROLL.w
			else
				bsr	putc_csi_extension
			endif
		else
			lea.l	BIOS_ESCAPE_BUFFER+1.w,a0	;[̎
			moveq.l	#0,d0
			moveq.l	#-1,d1			;1Ԗڂ̐l
			moveq.l	#-1,d2			;2Ԗڂ̐l
			moveq.l	#-1,d3			;3Ԗڂ̐l
			do
				move.b	(a0)+,d0
			while	<cmp.b #' ',d0>,eq
			ifand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
				moveq.l	#0,d1
				do
					sub.b	#'0',d0
					mulu.w	#10,d1
					add.w	d0,d1
					move.b	(a0)+,d0
				whileand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
				if	<cmp.b #';',d0>,eq
					do
						move.b	(a0)+,d0
					while	<cmp.b #' ',d0>,eq
					ifand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
						moveq.l	#0,d2
						do
							sub.b	#'0',d0
							mulu.w	#10,d2
							add.w	d0,d2
							move.b	(a0)+,d0
						whileand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
						if	<cmp.b #';',d0>,eq
							do
								move.b	(a0)+,d0
							while	<cmp.b #' ',d0>,eq
							ifand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
								moveq.l	#0,d3
								do
									sub.b	#'0',d0
									mulu.w	#10,d3
									add.w	d0,d3
									move.b	(a0)+,d0
								whileand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
							endif
						endif
					endif
				endif
			endif
			if	<cmp.b #'@',d0>,eq
				bsr	putc_csi_at		;ESC [n@ J[\En}
			elif	<cmp.b #'A',d0>,eq
				bsr	putc_csi_A		;ESC [nA J[\nsցB[𒴂Ƃ͓Ȃ
			elif	<cmp.b #'B',d0>,eq
				bsr	putc_csi_B		;ESC [nB J[\nsցB[Ŏ~܂
			elif	<cmp.b #'C',d0>,eq
				bsr	putc_csi_C		;ESC [nC J[\nEցBE[Ŏ~܂
			elif	<cmp.b #'D',d0>,eq
				bsr	putc_csi_D		;ESC [nD J[\nցB[Ŏ~܂
			elif	<cmp.b #'H',d0>,eq
				bsr	putc_csi_H		;ESC [r;cH J[\r-1s,c-1
			elif	<cmp.b #'J',d0>,eq
				bsr	putc_csi_J		;ESC [nJ ʂ
			elif	<cmp.b #'K',d0>,eq
				bsr	putc_csi_K		;ESC [nK s
			elif	<cmp.b #'L',d0>,eq
				bsr	putc_csi_L		;ESC [nL J[\牺ns}BJ[\[
			elif	<cmp.b #'M',d0>,eq
				bsr	putc_csi_M		;ESC [nM J[\牺ns폜BJ[\[
			elif	<cmp.b #'P',d0>,eq
				bsr	putc_csi_P		;ESC [nP J[\En폜
			elif	<cmp.b #'R',d0>,eq
				bsr	putc_csi_R		;ESC [r;cR CSR(Cursor Position Report)
			elif	<cmp.b #'X',d0>,eq
				bsr	putc_csi_X		;ESC [nX J[\En
			elif	<cmp.b #'c',d0>,eq
				bsr	putc_csi_c		;ESC [nc 
			elif	<cmp.b #'f',d0>,eq
				bsr	putc_csi_f		;ESC [r;cf J[\r-1s,c-1
			elif	<cmp.b #'l',d0>,eq
				bsr	putc_csi_l		;ESC [nl 
			elif	<cmp.b #'m',d0>,eq
				bsr	putc_csi_m		;ESC [nm ݒ肷
			elif	<cmp.b #'n',d0>,eq
				bsr	putc_csi_n		;ESC [nn DSR(Device Status Report)
			elif	<cmp.b #'r',d0>,eq
				bsr	putc_csi_r		;ESC [nr E
			elif	<cmp.b #'s',d0>,eq
				bsr	putc_csi_s		;ESC [ns J[\̍Wƕۑ
			elif	<cmp.b #'u',d0>,eq
				bsr	putc_csi_u		;ESC [nu J[\̍Wƕ𕜌
			else
				bsr	putc_csi_extension
			endif
		endif
	endif
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;gGXP[vV[PX[`Ăяo
putc_csi_extension:
	push	d0/a0
	move.l	BIOS_ESCAPE_EXTENSION.w,d0
	if	ne
		lea.l	BIOS_ESCAPE_BUFFER.w,a0
		movejsr	d0
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [n@ J[\En}
;<d1.w:}錅B0=1
putc_csi_at:
	push	d0-d5/a0-a3
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
;
;	`abcdefgh
;	`ab@@@@cd
;
	move.w	BIOS_CURSOR_COLUMN.w,d4
	add.w	d1,d4			;J[\̌W+}錅=ړ̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3
	sub.w	d4,d3			;R\[̉E[-ړ̌W=ړ镔̌-1
	if	lo			;ׂĉo
		bsr	putc_csi_0K		;ESC [0K J[\E[܂ŏ
	else				;ړ镔
		move.w	BIOS_CURSOR_ROW.w,d0	;sW
		swap.w	d0
		clr.w	d0			;65536*sW
		lsr.l	#5,d0			;128*16*sW
		add.l	BIOS_CONSOLE_OFFSET.w,d0
		add.l	#$00E00000,d0
		movea.l	d0,a2			;s̍[̃AhX
		movea.l	a2,a3
		adda.w	BIOS_CURSOR_COLUMN.w,a2	;J[\̃AhX
		adda.w	d3,a2			;ړ̉E[̃AhX
		adda.w	BIOS_CONSOLE_RIGHT.w,a3	;s̉E[̃AhX=ړ̉E[̃AhX
		do				;v[̃[v
			moveq.l	#16-1,d2
			for	d2			;X^̃[v
				lea.l	1(a2),a0		;ړ̉E[̃AhX+1
				lea.l	1(a3),a1		;ړ̉E[̃AhX+1
				move.w	d3,d1			;ړ镔̌-1
				for	d1			;̃[v
					move.b	-(a0),-(a1)
				next
				lea.l	128(a2),a2		;̃X^
				lea.l	128(a3),a3
			next
			adda.l	#-128*16+128*1024,a2	;̃v[
			adda.l	#-128*16+128*1024,a3
		while	<cmpa.l #$00E40000,a2>,lo
		move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
		move.w	d4,d3
		subq.w	#1,d3			;E[̌W
		moveq.l	#0,d4			;[̌W̒[
		moveq.l	#7,d5			;E[̌W̒[
		bsr	putc_clear		;s
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [nA J[\nsցB[𒴂Ƃ͓Ȃ
;<d1.w:ړsB0=1s
putc_csi_A:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0
	sub.w	d1,d0			;ns
	if	hs			;[𒴂ȂƂ
		move.w	d0,BIOS_CURSOR_ROW.w
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [nB J[\nsցB[Ŏ~܂
;<d1.w:ړsB0=1
putc_csi_B:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0
	add.w	d1,d0			;ns
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,hi	;[𒴂Ƃ
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_ROW.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nC J[\nEցBE[Ŏ~܂
;<d1.w:ړ錅B0=1
putc_csi_C:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d0
	add.w	d1,d0			;nE
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,hi	;E[𒴂Ƃ
		move.w	BIOS_CONSOLE_RIGHT.w,d0	;E[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_COLUMN.w
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nD J[\nցB[Ŏ~܂
;<d1.w:ړ錅B0=1
putc_csi_D:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d0
	sub.w	d1,d0			;n
	if	lo			;[𒴂Ƃ
		moveq.l	#0,d0			;[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_COLUMN.w
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [r;cf J[\r-1s,c-1
;<d1.w:ړ̍sW+1B0=[B[Ŏ~܂
;<d2.w:ړ̌W+1B0=[BE[Ŏ~܂
putc_csi_f:
;----------------------------------------------------------------
;ESC [r;cH J[\r-1s,c-1
;<d1.w:ړ̍sW+1B0=[B[Ŏ~܂
;<d2.w:ړ̌W+1B0=[BE[Ŏ~܂
putc_csi_H:
	push	d1-d2
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=[
	endif
	subq.w	#1,d1
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d1>,hi
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[Ŏ~܂
	endif
	ifor	<cmp.w #-1,d2>,eq,<tst.w d2>,eq
		moveq.l	#1,d2			;0=[
	endif
	subq.w	#1,d2
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d2>,hi
		move.w	BIOS_CONSOLE_RIGHT.w,d2	;E[Ŏ~܂
	endif
	move.w	d2,BIOS_CURSOR_COLUMN.w
	move.w	d1,BIOS_CURSOR_ROW.w
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nJ ʂ
;<d1.w:0=J[\E܂,1=ォJ[\܂,2=ォE܂ŁBJ[\
putc_csi_J:
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		bsr	putc_csi_0J		;ESC [0J J[\E܂ŏ
	elif	<cmp.w #1,d1>,eq
		bsr	putc_csi_1J		;ESC [1J ォJ[\܂ŏ
	elif	<cmp.w #2,d1>,eq
		bsr	putc_csi_2J		;ESC [2J ォE܂ŏBJ[\
	endif
	rts

;----------------------------------------------------------------
;ESC [0J J[\E܂ŏ
putc_csi_0J:
	push	d0-d5
	move.w	BIOS_CURSOR_ROW.w,d0
	move.w	BIOS_CONSOLE_BOTTOM.w,d1
	if	<cmp.w d1,d0>,lo		;[ł͂ȂƂ
	;	move.w	BIOS_CURSOR_ROW.w,d0
		addq.w	#1,d0			;[̍sW
	;	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
		bsr	putc_clear_rows		;s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[̌W
	moveq.l	#0,d4
	move.b	BIOS_CURSOR_FRACTION.w,d4	;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [1J ォJ[\܂ŏ
putc_csi_1J:
	push	d0-d5
	move.w	BIOS_CURSOR_ROW.w,d1
	if	<tst.w d1>,hi			;[ł͂ȂƂ
		clr.w	d0			;[̍sW
	;	move.w	BIOS_CURSOR_ROW.w,d1
		subq.w	#1,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	moveq.l	#0,d2			;[̌W
	move.w	BIOS_CURSOR_COLUMN.w,d3	;E[̌W
	moveq.l	#0,d4			;[̌W̒[
	moveq.l	#7,d5
	add.b	BIOS_CURSOR_FRACTION.w,d5	;E[̌W̒[
	if	<cmp.w #7,d5>,hi	;̌̂Ƃ
		if	<cmp.w BIOS_CONSOLE_RIGHT.w,d3>,lo	;E[ł͂ȂƂ
			addq.w	#1,d3
			subq.w	#8,d5
		else				;E[̂Ƃ
			moveq.l	#7,d5
		endif
	endif
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [2J ォE܂ŏBJ[\
putc_csi_2J:
	push	d0-d1
	moveq.l	#0,d0			;[̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
	bsr	putc_clear_rows		;s
	clr.l	BIOS_CURSOR_COLUMN.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nK s
;<d1.w:0=J[\E[܂,1=[J[\܂,2=[E[܂
putc_csi_K:
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		bsr	putc_csi_0K		;ESC [0K J[\E[܂ŏ
	elif	<cmp.w #1,d1>,eq
		bsr	putc_csi_1K		;ESC [1K [J[\܂ŏ
	elif	<cmp.w #2,d1>,eq
		bsr	putc_csi_2K		;ESC [2K [E[܂ŏ
	endif
	rts

;----------------------------------------------------------------
;ESC [0K J[\E[܂ŏ
putc_csi_0K:
	push	d0-d5
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[̌W
	moveq.l	#0,d4			;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [1K [J[\܂ŏ
putc_csi_1K:
	push	d0-d5
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	moveq.l	#0,d2			;[̌W
	move.w	BIOS_CURSOR_COLUMN.w,d3	;E[̌W
	moveq.l	#0,d4			;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [2K [E[܂ŏ
putc_csi_2K:
	push	d0-d1
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	bsr	putc_clear_rows		;s
	pop
	rts

;----------------------------------------------------------------
;ESC [nL J[\牺ns}BJ[\[
;<d1.w:}sB0=1s
putc_csi_L:
	push	d0-d2
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0
;<d0.w:J[\̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d2	;R\[̍s-1
	addq.w	#1,d2			;R\[̍s
	sub.w	d0,d2			;J[\牺̍s
	sub.w	d1,d2			;ʓɎcs
;<d2.w:ʓɎcs
	if	ls			;ʓɎcsȂBׂĉʊOɉo
	;    
	;                
	;                
	;d0
	;    
	;    
	;    
	;;;	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
		bsr	putc_clear_rows		;s
	else				;ʓɎcs
	;    
	;                
	;                
	;d0\d1
	;    /
	;    )d2
	;    
		add.w	d0,d2
		subq.w	#1,d2			;Rs[̉[̍sW
		add.w	d0,d1			;Rs[̏[̍sW
		exg.l	d1,d2
	;;;	move.w	BIOS_CURSOR_ROW.w,d0	;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		exg.l	d1,d2
		subq.w	#1,d1			;[̍sW
	;;;	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.w	BIOS_CURSOR_COLUMN.w	;[
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nM J[\牺ns폜BJ[\[
;<d1.w:폜sB0=1s
putc_csi_M:
	push	d0-d3
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0
;<d0.w:J[\̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d3	;R\[̍s-1
	addq.w	#1,d3			;R\[̍s
	sub.w	d0,d3			;J[\牺̍s
	sub.w	d1,d3			;ʓɎcs
;<d3.w:ʓɎcs
	if	ls			;ʓɎcsȂBׂč폜
	;    
	;                
	;                
	;d0
	;    
	;    
	;    
	;;;	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
		bsr	putc_clear_rows		;s
	else				;ʓɎcs
	;    
	;                
	;                
	;d0)d3
	;    \d1
	;    /
	;    
	;;;	move.w	BIOS_CURSOR_ROW.w,d0
		move.w	d0,d2			;Rs[̏[̍sW
		add.w	d1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	d2,d0
		add.w	d3,d0			;[̍sW
	;;;	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.w	BIOS_CURSOR_COLUMN.w	;[
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nP J[\En폜
;<d1.w:폜錅B0=1
putc_csi_P:
	push	d0-d5/a0-a3
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
;
;	`abcdefgh
;	`abgh@@@@
;
	move.w	BIOS_CURSOR_COLUMN.w,d4	;J[\̌W
	add.w	d1,d4			;J[\̌W+폜錅=ړ̍[̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3	;R\[̉E[̌W=ړ̉E[̌W
	sub.w	d4,d3			;ړ̉E[̌W-ړ̍[̌W=ړ镔̌-1
	if	lo			;ׂč폜
		bsr	putc_csi_0K		;ESC [0K J[\E[܂ŏ
	else				;ړ镔
		move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW
		swap.w	d0
		clr.w	d0			;65536*J[\̍sW
		lsr.l	#5,d0			;128*16*J[\̍sW
		add.l	BIOS_CONSOLE_OFFSET.w,d0
		add.l	#$00E00000,d0
		movea.l	d0,a2			;J[\̍s̍[̃AhX
		movea.l	a2,a3
		adda.w	d4,a2			;J[\̍s̍[̃AhX+ړ̍[̌W=ړ̍[̃AhX
		adda.w	BIOS_CURSOR_COLUMN.w,a3	;J[\̍s̍[̃AhX+J[\̌W=J[\̃AhX=ړ̍[̃AhX
		do				;v[̃[v
			moveq.l	#16-1,d2
			for	d2			;X^̃[v
				movea.l	a2,a0			;ړ̍[̃AhX
				movea.l	a3,a1			;ړ̍[̃AhX
				move.w	d3,d1			;ړ镔̌-1
				for	d1			;̃[v
					move.b	(a0)+,(a1)+
				next
				lea.l	128(a2),a2		;̃X^
				lea.l	128(a3),a3
			next
			adda.l	#-128*16+128*1024,a2	;̃v[
			adda.l	#-128*16+128*1024,a3
		while	<cmpa.l #$00E40000,a2>,lo
		move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW=͈͂̏[̍sW
		move.w	d0,d1			;J[\̍sW=͈͂̉[̍sW
		move.w	BIOS_CURSOR_COLUMN.w,d2	;J[\̌W
		add.w	d3,d2			;J[\̌W+ړ͈͂̌-1
		addq.w	#1,d2			;J[\̌W+ړ͈͂̌=͈͂̍[̌W
		move.w	BIOS_CONSOLE_RIGHT.w,d3	;R\[̉E[̌W=͈͂̉E[̌W
		moveq.l	#0,d4			;͈͂̍[̌W̒[
		moveq.l	#7,d5			;͈͂̉E[̌W̒[
		bsr	putc_clear		;s
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [r;cR CPR(Cursor Position Report)
;	DSR(Device Status Report)̕ԓBł͉Ȃ
putc_csi_R:
	rts

;----------------------------------------------------------------
;ESC [nX J[\En
;<d1.w:錅B0=1
putc_csi_X:
	push	d0-d5
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
	move.w	d2,d3
	add.w	d1,d3
	subq.w	#1,d3			;E[̌W
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d3>,hi	;E[𒴂Ƃ
		move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[Ŏ~܂
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	moveq.l	#7,d4
	and.b	BIOS_CURSOR_FRACTION.w,d4	;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [nc 
;<d1.w:hbg
putc_csi_c:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CONSOLE_RIGHT.w,d0
	addq.w	#1,d0
	lsl.w	#3,d0			;R\[̃hbg
	if	<cmp.w d0,d1>,ls	;傫Ȃ
		bset.b	#BIOS_ALIGN_CENTER_BIT,BIOS_CONSOLE_STATUS.w	;
		move.l	#BIOS_BUFFER_ARRAY,BIOS_BUFFER_POINTER.w
		clr.w	BIOS_BUFFER_WIDTH.w
		move.w	d1,BIOS_BUFFER_REQUEST.w	;obt@o͊Jn
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [nl 
;<d1.w:hbg
putc_csi_l:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CONSOLE_RIGHT.w,d0
	addq.w	#1,d0
	lsl.w	#3,d0			;R\[̃hbg
	if	<cmp.w d0,d1>,ls	;傫Ȃ
		bset.b	#BIOS_ALIGN_LEFT_BIT,BIOS_CONSOLE_STATUS.w	;
		move.l	#BIOS_BUFFER_ARRAY,BIOS_BUFFER_POINTER.w
		clr.w	BIOS_BUFFER_WIDTH.w
		move.w	d1,BIOS_BUFFER_REQUEST.w	;obt@o͊Jn
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [nm ݒ肷
;	0	Zbg
;	1	
;	2	׎
;	3	Α
;	4	
;	5	(x_)
;	6	(_)
;	7	]
;	8	(閧)
;	9	
;	11`19	(փtHg1`9)
;	20	(ubN^[)
;	21	g
;	22	A׎
;	23	Α̉A(ubN^[)
;	24	Ag
;	25	(x_ŉA_ŉ)
;	26	v|[Vi
;	27	]
;	28	(閧)
;	29	
;	30	
;	31	F
;	32	F
;	33	
;	34	A
;	35	AF
;	36	AF
;	37	A
;	40	]A
;	41	]AF
;	42	]AF
;	43	]A
;	44	]AA
;	45	]AAF
;	46	]AAF
;	47	]AA
;	50	v|[Vi
;	51	lp͂
;	52	ۈ͂
;	53	
;	54	lp͂݁Aۈ͂݉
;	55	
;	73	t
;	74	t
;	75	tAt
;<d1.w:B-1=wȂ
;<d2.w:B-1=wȂ
;<d3.w:B-1=wȂ
putc_csi_m:
	push	d1
	bsr	putc_csi_m_1
	if	<cmp.w #-1,d2>,ne
		move.w	d2,d1
		bsr	putc_csi_m_1
	endif
	if	<cmp.w #-1,d3>,ne
		move.w	d3,d1
		bsr	putc_csi_m_1
	endif
	pop
	rts

;?d1
putc_csi_m_1:
;Ɣ]̂݃gOB̑ON܂OFF̂ǂ炩
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		move.b	#3,BIOS_ATTRIBUTE_1.w	;1B||Α|׎|]||v[##
		clr.b	BIOS_ATTRIBUTE_2.w	;2B-|t|t||ۈ͂|lp͂|v|[Vi|g
	elif	<cmp.w #1,d1>,eq
		bchg.b	#BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w	;
		if	eq			;OFFON̂Ƃ
			bclr.b	#BIOS_FAINT_BIT,BIOS_ATTRIBUTE_1.w	;׎
		endif
	elif	<cmp.w #2,d1>,eq
		bclr.b	#BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w	;
		bset.b	#BIOS_FAINT_BIT,BIOS_ATTRIBUTE_1.w	;׎
	elif	<cmp.w #3,d1>,eq
		bset.b	#BIOS_ITALIC_BIT,BIOS_ATTRIBUTE_1.w	;Α
	elif	<cmp.w #4,d1>,eq
		bset.b	#BIOS_UNDERLINE_BIT,BIOS_ATTRIBUTE_1.w	;
		bclr.b	#BIOS_WAVELINE_BIT,BIOS_ATTRIBUTE_2.w	;g
	elif	<cmp.w #7,d1>,eq
		bchg.b	#BIOS_REVERSE_BIT,BIOS_ATTRIBUTE_1.w	;]
	elif	<cmp.w #9,d1>,eq
		bset.b	#BIOS_STRIKETHROUGH_BIT,BIOS_ATTRIBUTE_1.w	;
	elif	<cmp.w #21,d1>,eq
		bclr.b	#BIOS_UNDERLINE_BIT,BIOS_ATTRIBUTE_1.w	;
		bset.b	#BIOS_WAVELINE_BIT,BIOS_ATTRIBUTE_2.w	;g
	elif	<cmp.w #22,d1>,eq
		bclr.b	#BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w	;
		bclr.b	#BIOS_FAINT_BIT,BIOS_ATTRIBUTE_1.w	;׎
	elif	<cmp.w #23,d1>,eq
		bclr.b	#BIOS_ITALIC_BIT,BIOS_ATTRIBUTE_1.w	;Α̉
	elif	<cmp.w #24,d1>,eq
		bclr.b	#BIOS_UNDERLINE_BIT,BIOS_ATTRIBUTE_1.w	;
		bclr.b	#BIOS_WAVELINE_BIT,BIOS_ATTRIBUTE_2.w	;g
	elif	<cmp.w #26,d1>,eq
		bset.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w	;v|[Vi
	elif	<cmp.w #27,d1>,eq
		bclr.b	#BIOS_REVERSE_BIT,BIOS_ATTRIBUTE_1.w	;]
	elif	<cmp.w #29,d1>,eq
		bclr.b	#BIOS_STRIKETHROUGH_BIT,BIOS_ATTRIBUTE_1.w	;
	elifand	<cmp.w #30,d1>,hs,<cmp.w #37,d1>,ls
		sub.w	#30,d1
		andi.b	#$F0,BIOS_ATTRIBUTE_1.w
		or.b	d1,BIOS_ATTRIBUTE_1.w
	elifand	<cmp.w #40,d1>,hs,<cmp.w #47,d1>,ls
		sub.w	#40,d1
		addq.b	#8,d1
		andi.b	#$F0,BIOS_ATTRIBUTE_1.w
		or.b	d1,BIOS_ATTRIBUTE_1.w
	elif	<cmp.w #50,d1>,eq
		bclr.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w	;v|[Vi
	elif	<cmp.w #51,d1>,eq
		bset.b	#BIOS_FRAME_BIT,BIOS_ATTRIBUTE_2.w	;lp͂
		bclr.b	#BIOS_ENCIRCLE_BIT,BIOS_ATTRIBUTE_2.w	;ۈ͂݉
	elif	<cmp.w #52,d1>,eq
		bclr.b	#BIOS_FRAME_BIT,BIOS_ATTRIBUTE_2.w	;lp͂݉
		bset.b	#BIOS_ENCIRCLE_BIT,BIOS_ATTRIBUTE_2.w	;ۈ͂
	elif	<cmp.w #53,d1>,eq
		bset.b	#BIOS_OVERLINE_BIT,BIOS_ATTRIBUTE_2.w	;
	elif	<cmp.w #54,d1>,eq
		bclr.b	#BIOS_FRAME_BIT,BIOS_ATTRIBUTE_2.w	;lp͂݉
		bclr.b	#BIOS_ENCIRCLE_BIT,BIOS_ATTRIBUTE_2.w	;ۈ͂݉
	elif	<cmp.w #55,d1>,eq
		bclr.b	#BIOS_OVERLINE_BIT,BIOS_ATTRIBUTE_2.w	;
	elif	<cmp.w #73,d1>,eq
		bset.b	#BIOS_SUPERSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
		bclr.b	#BIOS_SUBSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
	elif	<cmp.w #74,d1>,eq
		bclr.b	#BIOS_SUPERSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
		bset.b	#BIOS_SUBSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
	elif	<cmp.w #75,d1>,eq
		bclr.b	#BIOS_SUPERSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
		bclr.b	#BIOS_SUBSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
	endif
	rts

;----------------------------------------------------------------
;ESC [nn DSR(Device Status Report)
;<d1.w:6
putc_csi_n:
	push	d0-d2/a0
	if	<cmp.w #6,d1>,eq	;CPR(Cursor Position Report)
		move.w	#$0100+27,d2
		bsr	20f
		move.w	#$1C00+'[',d2
		bsr	20f
		move.w	BIOS_CURSOR_ROW.w,d0
		bsr	10f
		move.w	#$2700+';',d2
		bsr	20f
		move.w	BIOS_CURSOR_COLUMN.w,d0
		bsr	10f
		move.w	#$1400+'R',d2
		bsr	20f
	endif
	pop
	rts

;l+1𕶎ɕϊăL[̓obt@ɏ
;<d0.b:lB255͕sBł1ȗȂ
;?d0-d2/a0
10:	addq.b	#1,d0
	move.l	#(1<<24)+(10<<16)+(100<<8),d1
	do
		lsr.l	#8,d1
	while	<cmp.b d1,d0>,lo
	do
		moveq.l	#-2,d2
		do
			addq.w	#2,d2
			sub.b	d1,d0
		while	hs
		move.w	15f(pc,d2.w),d2
		bsr	20f
		add.b	d1,d0
		lsr.l	#8,d1
	while	<tst.b d1>,ne
	rts

15:	.dc.w	$0B00+'0'
	.dc.w	$0200+'1'
	.dc.w	$0300+'2'
	.dc.w	$0400+'3'
	.dc.w	$0500+'4'
	.dc.w	$0600+'5'
	.dc.w	$0700+'6'
	.dc.w	$0800+'7'
	.dc.w	$0900+'8'
	.dc.w	$0A00+'9'

;L[̓obt@ɏ
;<d2.w:(XLR[h<<8)+R[h
;?a0
20:	di
	if	<cmpi.w #64,BIOS_KEY_REMAINING.w>,lo	;L[̓obt@ɎcĂf[^̐64̂Ƃ
		movea.l	BIOS_KEY_WRITTEN.w,a0	;Ōɏ񂾈ʒu
		addq.l	#2,a0			;񏑂ވʒu
		if	<cmpa.w #BIOS_KEY_BUFFER+2*64.w,a0>,hs	;𒴂
			lea.l	BIOS_KEY_BUFFER.w,a0	;擪ɖ߂
		endif
		move.w	d2,(a0)			;
		move.l	a0,BIOS_KEY_WRITTEN.w	;Ōɏ񂾈ʒu
		addq.w	#1,BIOS_KEY_REMAINING.w	;L[̓obt@ɎcĂf[^̐
	endif
	ei
	rts

;----------------------------------------------------------------
;ESC [nr E
;<d1.w:hbg
putc_csi_r:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CONSOLE_RIGHT.w,d0
	addq.w	#1,d0
	lsl.w	#3,d0			;R\[̃hbg
	if	<cmp.w d0,d1>,ls	;傫Ȃ
		bset.b	#BIOS_ALIGN_RIGHT_BIT,BIOS_CONSOLE_STATUS.w	;E
		move.l	#BIOS_BUFFER_ARRAY,BIOS_BUFFER_POINTER.w
		clr.w	BIOS_BUFFER_WIDTH.w
		move.w	d1,BIOS_BUFFER_REQUEST.w	;obt@o͊Jn
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [ns J[\̍Wƕۑ
;<d1.w:-1
putc_csi_s:
	if	<cmp.w #-1,d1>,eq
		move.w	BIOS_CURSOR_ROW.w,BIOS_SAVED_ROW.w
		move.w	BIOS_CURSOR_COLUMN.w,BIOS_SAVED_COLUMN.w
		move.b	BIOS_CURSOR_FRACTION.w,BIOS_SAVED_FRACTION.w
		move.b	BIOS_ATTRIBUTE_1.w,BIOS_SAVED_ATTRIBUTE_1.w
		move.b	BIOS_ATTRIBUTE_2.w,BIOS_SAVED_ATTRIBUTE_2.w
	endif
	rts

;----------------------------------------------------------------
;ESC [nu J[\̍Wƕ𕜌
;<d1.w:-1
putc_csi_u:
	if	<cmp.w #-1,d1>,eq
		move.w	BIOS_SAVED_ROW.w,BIOS_CURSOR_ROW.w
		move.w	BIOS_SAVED_COLUMN.w,BIOS_CURSOR_COLUMN.w
		move.b	BIOS_SAVED_FRACTION.w,BIOS_CURSOR_FRACTION.w
		move.b	BIOS_SAVED_ATTRIBUTE_1.w,BIOS_ATTRIBUTE_1.w
		move.b	BIOS_SAVED_ATTRIBUTE_2.w,BIOS_ATTRIBUTE_2.w
	endif
	rts

;----------------------------------------------------------------
;ʂɕ`܂̓obt@ɏo͂
;<d1.w:R[h
putc_output:
	push	d0-d7/a0-a2
	lea.l	-4*16-4*16(sp),sp	;tHgf[^ƃ}XNf[^
;<(sp).l[16]:tHgf[^
;<4*16(sp).l[16]:}XNf[^
	move.w	d1,d7
;<d7.w:R[h
;----------------
;tHgAhXƃhbg߂
	ifand	<btst.b #BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w>,ne,<cmp.w #$0020,d1>,hs,<cmp.w #$0082,d1>,ls	;v|[Viɂ
		lea.l	proportional_font(pc),a0	;v|[VitHg($20`$82)
		sub.w	#$0020,d1
		mulu.w	#2+2*16,d1
		adda.l	d1,a0			;tHgAhX
		move.w	(a0)+,d6		;hbgB1`16
		moveq.l	#1,d2			;16hbgf[^
	else				;v|[ViɂȂ
		moveq.l	#8,d2
		IOCS	_FNTADR
	;<d0.l:tHgAhX
	;<d1.w:̃hbg<<16|̃oCg-1
	;<d2.w:c̃hbg-1
		movea.l	d0,a0			;tHgAhX
		move.w	d1,d2			;0=8hbgf[^,1=16hbgf[^
		swap.w	d1
		move.w	d1,d6			;hbgB1`16
	endif
;<d2.w:0=8hbgf[^,1=16hbgf[^
;<d6.w:hbgB1`16
;<(a0).b[16]:8hbgf[^
;܂
;<(a0).w[16]:16hbgf[^
;----------------
;obt@ɏo͂邩
	if	<tst.w BIOS_BUFFER_REQUEST.w>,ne	;obt@o͒
		movea.l	BIOS_BUFFER_POINTER.w,a0	;obt@݈̏ʒu
		goto	<cmpa.l #BIOS_BUFFER_ARRAY+2*64,a0>,hs,putc_output_end	;obt@t̂Ƃ͖
		move.w	d7,(a0)+		;R[h
		move.l	a0,BIOS_BUFFER_POINTER.w	;݈ʒui߂
		if	<btst.b #BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w>,ne	;v|[VîƂ
			if	<btst.b #BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w>,ne	;̂Ƃ
				addq.w	#1,d6			;1hbg
			endif
			if	<btst.b #BIOS_ITALIC_BIT,BIOS_ATTRIBUTE_1.w>,ne	;Α̂̂Ƃ
				addq.w	#3,d6			;3hbg
				bset.b #BIOS_CONNECTION_BIT,BIOS_CONSOLE_STATUS.w
				if	ne	;ÂƂ
					subq.w	#3,BIOS_BUFFER_WIDTH.w	;3hbgl߂
					if	cs
						clr.w	BIOS_BUFFER_WIDTH.w	;Ö
					endif
				endif
			else				;Α̂ł͂ȂƂ
				bclr.b	#BIOS_CONNECTION_BIT,BIOS_CONSOLE_STATUS.w
			endif
		endif
		add.w	d6,BIOS_BUFFER_WIDTH.w	;
		goto	putc_output_end
	endif
;----------------
;J[\OFF
;	Α̂̂Ƃʒûł̑OɃJ[\
	bsr	iocs_1F_B_CUROFF
;----------------
;tHgf[^
	movea.l	sp,a1			;tHgf[^
	moveq.l	#0,d0
	if	<tst.w d2>,eq		;8hbgf[^̂Ƃ
		moveq.l	#16-1,d3
		for	d3
			move.b	(a0)+,(a1)+
			move.b	d0,(a1)+		;clr
			move.w	d0,(a1)+		;clr
		next
	else				;16hbgf[^̂Ƃ
		moveq.l	#16-1,d3
		for	d3
			move.w	(a0)+,(a1)+
			move.w	d0,(a1)+		;clr
		next
	endif
;<(sp).l[16]:tHgf[^
;----------------
;
;	ŜE1hbg炵OR
;	v|[VîƂ͕1hbg
;<d6.w:hbgB1`16
;<(sp).l[16]:tHgf[^
;>d6.w:hbgB1`17
	if	<btst.b #BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w>,ne	;̂Ƃ
		movea.l	sp,a1			;tHgf[^
		if	<btst.b #BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w>,ne	;v|[VîƂ
			moveq.l	#16-1,d3
			for	d3
				move.l	(a1),d0
				move.l	d0,d1
				lsr.l	#1,d0			;E1hbg炵
				or.l	d1,d0			;OR
				move.l	d0,(a1)+
			next
			addq.w	#1,d6			;1hbg
		else				;v|[Vił͂ȂƂ
			moveq.l	#1,d2
			ror.l	d6,d2
			neg.l	d2
			moveq.l	#16-1,d3
			for	d3
				move.l	(a1),d0
				move.l	d0,d1
				lsr.l	#1,d0			;E1hbg炵
				or.l	d1,d0			;OR
				and.l	d2,d0			;𑝂₳Ȃ
				move.l	d0,(a1)+
			next
		endif
	endif
;----------------
;׎
;	㉺Êꂩ1ŁAbV1̂ƂA10ɂ
;<d6.w:hbgB1`16
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_FAINT_BIT,BIOS_ATTRIBUTE_1.w>,ne	;׎̂Ƃ
		movea.l	sp,a1			;tHgf[^
		move.l	#$AAAAAAAA,d2
		moveq.l	#1,d0
		and.b	BIOS_CURSOR_FRACTION.w,d0
		rol.l	d0,d2
		moveq.l	#16-1,d3
		for	d3
			move.l	(a1),d0
			move.l	d0,d1
			lsr.l	#1,d1			;
			lsl.l	#1,d0			;E
			or.l	d1,d0
			if	<cmpa.l sp,a1>,ne
				or.l	-4(a1),d0	;
			endif
			if	<tst.w d3>,ne
				or.l	4(a1),d0	;
			endif
			and.l	d2,d0			;bV
			not.l	d0
			and.l	d0,(a1)+
			rol.l	#1,d2
		next
	endif
;----------------
;
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_UNDERLINE_BIT,BIOS_ATTRIBUTE_1.w>,ne	;̂Ƃ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d0
		ror.l	d6,d0
		neg.l	d0
		or.l	d0,4*15(a1)
	endif
;----------------
;
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_STRIKETHROUGH_BIT,BIOS_ATTRIBUTE_1.w>,ne	;̂Ƃ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d0
		ror.l	d6,d0
		neg.l	d0
		or.l	d0,4*8(a1)
	endif
;----------------
;g
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_WAVELINE_BIT,BIOS_ATTRIBUTE_2.w>,ne	;ĝƂ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d2
		ror.l	d6,d2
		neg.l	d2
		moveq.l	#3,d0
		and.b	BIOS_CURSOR_FRACTION.w,d0
  .if 0
		move.l	#$CCCCCCCC,d1
		rol.l	d0,d1
		move.l	d1,d0			;11001100
		not.l	d1			;00110011
		and.l	d2,d0
		and.l	d2,d1
		or.l	d0,4*14(a1)
		or.l	d1,4*15(a1)
  .else
		move.l	#$88888888,d1
		move.l	#$55555555,d3
		rol.l	d0,d1			;10001000
		rol.l	d0,d3			;01010101
		move.l	d1,d0
		rol.l	#2,d0			;00100010
		and.l	d2,d0
		and.l	d2,d1
		and.l	d2,d3
		or.l	d0,4*13(a1)
		or.l	d3,4*14(a1)
		or.l	d1,4*15(a1)
  .endif
	endif
;----------------
;lp͂
	if	<btst.b #BIOS_FRAME_BIT,BIOS_ATTRIBUTE_2.w>,ne	;lp݂͂̂Ƃ
	;16x16̒Ɋ񂹂
		moveq.l	#16,d1
		sub.w	d6,d1
		if	hs
			lsr.w	#1,d1
			movea.l	sp,a1
			moveq.l	#16-1,d3
			for	d3
				move.l	(a1),d0
				lsr.l	d1,d0
				move.l	d0,(a1)+
			next
			moveq.l	#16,d6
		endif
	;16x1612x12ɏk
		lea.l	subscript_pattern(pc),a2
		lea.l	4*0(sp),a0
		lea.l	4*0(sp),a1
		moveq.l	#0,d0
		moveq.l	#4-1,d3
		for	d3
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.b	4(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#6,d2
			move.b	5(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#2,d2
			or.w	d2,d1
			move.w	d1,(a1)
			addq.l	#8,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		next
		clr.l	4*12(sp)
		clr.l	4*13(sp)
		clr.l	4*14(sp)
		clr.l	4*15(sp)
	;16x16̒Ɋ񂹂
		lea.l	4*12(sp),a0
		lea.l	4*14(sp),a1
		moveq.l	#12-1,d3
		for	d3
			move.l	-(a0),d0
			lsr.l	#2,d0
			move.l	d0,-(a1)
		next
		clr.l	4*0(sp)
		clr.l	4*1(sp)
	;lpt
		movea.l	sp,a0
		or.l	#$FFFF0000,(a0)+
		moveq.l	#14-1,d3
		for	d3
			or.l	#$80010000,(a0)+
		next
		or.l	#$FFFF0000,(a0)+
	endif
;----------------
;ۈ͂
	if	<btst.b #BIOS_ENCIRCLE_BIT,BIOS_ATTRIBUTE_2.w>,ne	;ۈ݂͂̂Ƃ
	;16x16̒Ɋ񂹂
		moveq.l	#16,d1
		sub.w	d6,d1
		if	hs
			lsr.w	#1,d1
			movea.l	sp,a1
			moveq.l	#16-1,d3
			for	d3
				move.l	(a1),d0
				lsr.l	d1,d0
				move.l	d0,(a1)+
			next
			moveq.l	#16,d6
		endif
	;16x1612x12ɏk
		lea.l	subscript_pattern(pc),a2
		lea.l	4*0(sp),a0
		lea.l	4*0(sp),a1
		moveq.l	#0,d0
		moveq.l	#4-1,d3
		for	d3
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.b	4(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#6,d2
			move.b	5(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#2,d2
			or.w	d2,d1
			move.w	d1,(a1)
			addq.l	#8,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		next
		clr.l	4*12(sp)
		clr.l	4*13(sp)
		clr.l	4*14(sp)
		clr.l	4*15(sp)
	;16x16̒Ɋ񂹂
		lea.l	4*12(sp),a0
		lea.l	4*14(sp),a1
		moveq.l	#12-1,d3
		for	d3
			move.l	-(a0),d0
			lsr.l	#2,d0
			move.l	d0,-(a1)
		next
		clr.l	4*0(sp)
		clr.l	4*1(sp)
	;ۂt
		movea.l	sp,a0
	;	perl -e "for$y(0..15){print qq(\t\tandi.l\t#%);for$x(0..15){$t=($x-7.5)*($x-7.5)+($y-7.5)*($y-7.5);print($t<=8**2?'1':'0');}print qq(_0000000000000000,(a0)+\n);}"
		andi.l	#%0000011111100000_0000000000000000,(a0)+
		andi.l	#%0001111111111000_0000000000000000,(a0)+
		andi.l	#%0011111111111100_0000000000000000,(a0)+
		andi.l	#%0111111111111110_0000000000000000,(a0)+
		andi.l	#%0111111111111110_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%0111111111111110_0000000000000000,(a0)+
		andi.l	#%0111111111111110_0000000000000000,(a0)+
		andi.l	#%0011111111111100_0000000000000000,(a0)+
		andi.l	#%0001111111111000_0000000000000000,(a0)+
		andi.l	#%0000011111100000_0000000000000000,(a0)+
		movea.l	sp,a0
	;	perl -e "for$y(0..15){print qq(\t\tori.l\t#%);for$x(0..15){$t=($x-7.5)*($x-7.5)+($y-7.5)*($y-7.5);print(7**2<=$t&&$t<=8**2?'1':'0');}print qq(_0000000000000000,(a0)+\n);}"
		ori.l	#%0000011111100000_0000000000000000,(a0)+
		ori.l	#%0001100000011000_0000000000000000,(a0)+
		ori.l	#%0011000000001100_0000000000000000,(a0)+
		ori.l	#%0110000000000110_0000000000000000,(a0)+
		ori.l	#%0100000000000010_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%0100000000000010_0000000000000000,(a0)+
		ori.l	#%0110000000000110_0000000000000000,(a0)+
		ori.l	#%0011000000001100_0000000000000000,(a0)+
		ori.l	#%0001100000011000_0000000000000000,(a0)+
		ori.l	#%0000011111100000_0000000000000000,(a0)+
	endif
;----------------
;
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_OVERLINE_BIT,BIOS_ATTRIBUTE_2.w>,ne	;̂Ƃ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d0
		ror.l	d6,d0
		neg.l	d0
		or.l	d0,4*0(a1)
	endif
;----------------
;t
;	4x4̏2hbgƍ2hbgꂼOR1hbgɂ邱ƂŁA4x43x3ɏk
;	SX-WindowƓ@
;	c16hbg12hbgɏkA1hbg̍ɔzu
;<d6.w:hbgB1`16
;<(sp).l[16]:tHgf[^
;>d6.w:hbgB1`12
	if	<btst.b #BIOS_SUBSCRIPT_BIT,BIOS_ATTRIBUTE_2.w>,ne	;t̂Ƃ
		lea.l	subscript_pattern(pc),a2
		lea.l	4*16(sp),a0
		lea.l	4*15(sp),a1
		moveq.l	#0,d0
		moveq.l	#4-1,d3
		for	d3
			subq.l	#8,a0
			subq.l	#4,a1
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.b	4(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#6,d2
			move.b	5(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#2,d2
			or.w	d2,d1
			move.w	d1,(a1)
		;
			subq.l	#4,a0
			subq.l	#4,a1
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
		;
			subq.l	#4,a0
			subq.l	#4,a1
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
		next
		clr.l	4*0(sp)
		clr.l	4*1(sp)
		clr.l	4*2(sp)
		clr.l	4*15(sp)
		moveq.l	#3,d0
		and.w	d6,d0
		lsr.w	#2,d6
		move.w	d6,d1
		add.w	d6,d6
		add.w	d1,d6
		add.w	d0,d6
	endif
;----------------
;t
;	4x4̏2hbgƍ2hbgꂼOR1hbgɂ邱ƂŁA4x43x3ɏk
;	SX-WindowƓ@
;	c16hbg12hbgɏkAォ0hbg̍ɔzu
;<d6.w:hbgB1`16
;<(sp).l[16]:tHgf[^
;>d6.w:hbgB1`12
	if	<btst.b #BIOS_SUPERSCRIPT_BIT,BIOS_ATTRIBUTE_2.w>,ne	;t̂Ƃ
		lea.l	subscript_pattern(pc),a2
		lea.l	4*0(sp),a0
		lea.l	4*0(sp),a1
		moveq.l	#0,d0
		moveq.l	#4-1,d3
		for	d3
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.b	4(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#6,d2
			move.b	5(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#2,d2
			or.w	d2,d1
			move.w	d1,(a1)
			addq.l	#8,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		next
		clr.l	4*12(sp)
		clr.l	4*13(sp)
		clr.l	4*14(sp)
		clr.l	4*15(sp)
		moveq.l	#3,d0
		and.w	d6,d0
		lsr.w	#2,d6
		move.w	d6,d1
		add.w	d6,d6
		add.w	d1,d6
		add.w	d0,d6
	endif
;----------------
;]
;	Ŝ𔽓]
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_REVERSE_BIT,BIOS_ATTRIBUTE_1.w>,ne	;]̂Ƃ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d0
		ror.l	d6,d0
		neg.l	d0
		moveq.l	#16-1,d3
		for	d3
			eor.l	d0,(a1)+
		next
	endif
;----------------
;}XNf[^
;<d6.w:hbgB1`17
;>4*16(sp).l[16]:}XNf[^
	lea.l	4*16(sp),a1		;}XNf[^
	moveq.l	#1,d0
	ror.l	d6,d0
	neg.l	d0
	moveq.l	#16-1,d3
	for	d3
		move.l	d0,(a1)+
	next
;----------------
;Α
;	ŜE0`3hbg炷
;	v|[VîƂ3hbg
;	Α̂𑱂ĕ`悷ƂJ[\Ȃ3hbgl߂
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
;<4*16(sp).l[16]:}XNf[^
;>d6.w:hbgB1`20
	if	<btst.b #BIOS_ITALIC_BIT,BIOS_ATTRIBUTE_1.w>,ne	;Α̂̂Ƃ
		movea.l	sp,a0			;tHgf[^
		lea.l	4*16(sp),a1		;}XNf[^
*		if	<btst.b #BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w>,ne	;v|[VîƂ
			moveq.l	#3,d3
			do
				moveq.l	#4-1,d2
				for	d2
					move.l	(a0),d0
					lsr.l	d3,d0
					move.l	d0,(a0)+
					move.l	(a1),d0
					lsr.l	d3,d0
					move.l	d0,(a1)+
				next
				subq.w	#1,d3
			while	ne
			addq.w	#3,d6			;3hbg
			bset.b #BIOS_CONNECTION_BIT,BIOS_CONSOLE_STATUS.w
			if	ne			;ÂƂ
				subq.b	#3,BIOS_CURSOR_FRACTION.w	;3hbgl߂
				if	cs
					addq.b	#8,BIOS_CURSOR_FRACTION.w
					subq.w	#1,BIOS_CURSOR_COLUMN.w
					if	cs
						clr.w	BIOS_CURSOR_COLUMN.w	;Ö
						clr.b	BIOS_CURSOR_FRACTION.w
					endif
				endif
			endif
*		else				;v|[Vił͂ȂƂ
*			moveq.l	#1,d4
*			ror.l	d6,d4
*			neg.l	d4
*			moveq.l	#4-1,d2
*			for	d2
*				move.l	(a0),d0
*				lsr.l	#2,d0
*				and.l	d4,d0			;𑝂₳Ȃ
*				move.l	d0,(a0)+
*				move.l	(a1),d0
*				lsr.l	#2,d0
*				and.l	d4,d0			;𑝂₳Ȃ
*				move.l	d0,(a1)+
*			next
*			moveq.l	#4-1,d2
*			for	d2
*				move.l	(a0),d0
*				lsr.l	#1,d0
*				and.l	d4,d0			;𑝂₳Ȃ
*				move.l	d0,(a0)+
*				move.l	(a1),d0
*				lsr.l	#1,d0
*				and.l	d4,d0			;𑝂₳Ȃ
*				move.l	d0,(a1)+
*			next
*			lea.l	4*4(a0),a0
*			lea.l	4*4(a1),a1
*			moveq.l	#4-1,d2
*			for	d2
*				move.l	(a0),d0
*				lsl.l	#1,d0
*				move.l	d0,(a0)+
*				move.l	(a1),d0
*				lsl.l	#1,d0
*				move.l	d0,(a1)+
*			next
*		endif
	else				;Α̂ł͂ȂƂ
		bclr.b	#BIOS_CONNECTION_BIT,BIOS_CONSOLE_STATUS.w
	endif
;----------------
;݂̍sɓ؂ȂΉs
;<d6.w:hbg
	move.w	BIOS_CONSOLE_RIGHT.w,d0
	addq.w	#1,d0
	lsl.w	#3,d0			;R\[̃hbg
	move.w	BIOS_CURSOR_COLUMN.w,d1
	lsl.w	#3,d1
	add.b	BIOS_CURSOR_FRACTION.w,d1	;J[\XhbgW
	sub.w	d1,d0			;R\[̃hbg-J[\XhbgW=chbg
	if	le			;chbg<=0Bɂ͂ݏoĂ
	;s
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	elif	<cmp.w d6,d0>,lt	;chbg<hbgB؂Ȃ
	;c󔒂Ŗ߂
		move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
		move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[̌W
		moveq.l	#7,d4
		and.b	BIOS_CURSOR_FRACTION.w,d4	;[̌W̒[
		moveq.l	#7,d5			;E[̌W̒[
		bsr	putc_clear		;
		;s
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
;----------------
;`
;<d6.w:hbg
;<(sp).l[16]:tHgf[^
;<4*16(sp).l[16]:}XNf[^
	move.w	BIOS_CURSOR_ROW.w,d0	;sW
	move.w	BIOS_CURSOR_COLUMN.w,d1	;W
	moveq.l	#7,d2
	and.b	BIOS_CURSOR_FRACTION.w,d2	;W̒[
	move.w	d6,d3			;hbg
	moveq.l	#3,d4
	and.b	BIOS_ATTRIBUTE_1.w,d4	;v[
	movea.l	sp,a0			;tHgf[^
	lea.l	4*16(sp),a1		;}XNf[^
	bsr	putc_draw		;`
;----------------
;J[\i߂
;<d6.w:hbg
	add.b	BIOS_CURSOR_FRACTION.w,d6	;J[\̌W̒[+hbg
	moveq.l	#7,d0
	and.w	d6,d0
	move.b	d0,BIOS_CURSOR_FRACTION.w	;J[\̌W̒[
	lsr.w	#3,d6
	add.w	d6,BIOS_CURSOR_COLUMN.w	;J[\̌WB傤ǉE[ɂȂꍇ邪ł͉sȂ
;----------------
;J[\ON
	bsr	iocs_1E_B_CURON
;----------------
putc_output_end:
	lea.l	4*16+4*16(sp),sp	;tHgf[^ƃ}XNf[^
	pop
	rts

;----------------------------------------------------------------
;tŎgp^[
;	
subscript_pattern:
  .irp ff,%00000000,%10000000,%10000000,%10000000
    .irp ee,%00000000,%01000000
      .irp dd,%00000000,%00100000
        .irp cc,%00000000,%00010000,%00010000,%00010000
          .irp bb,%00000000,%00001000
            .irp aa,%00000000,%00000100
	.dc.b	ff+ee+dd+cc+bb+aa
            .endm
          .endm
        .endm
      .endm
    .endm
  .endm

;----------------------------------------------------------------
;`
;<d0.l:sW
;<d1.l:W
;<d2.l:W̒[
;<d3.l:hbg
;<d4.l:v[B1̉2rbg
;<(a0).l[16]:tHgf[^B񂹁Bo[X܂߂ĉHς
;<(a1).l[16]:}XNf[^B񂹁Bރrbg1
putc_draw:
	push	d0-d5/a0-a4
;----------------
;AhX߂
	swap.w	d0
	clr.w	d0			;65536*sW
	lsr.l	#5,d0			;128*16*sW
	add.w	d1,d0			;128*16*sW+W
	add.l	BIOS_CONSOLE_OFFSET.w,d0	;`n߂AhX̃ItZbg
	add.l	#$00E00000,d0		;`n߂AhX
	bclr.l	#0,d0			;ɂ
	if	ne
		addq.w	#8,d2
	endif
;<d2.w:W̒[B0`15
	movea.l	d0,a4
;<a4.l:`n߂AhXB
;?d0-d1
;----------------
	add.w	d2,d3			;W̒[+hbg
;<d3.w:W̒[+hbg
;----------------
;1[hɎ܂邩A2[hɌׂ邩A3[hɌׂ邩
	if	<cmp.w #16,d3>,ls
	;----------------
	;1[hɎ܂Ƃ
		do				;v[̃[v
			lsr.b	#1,d4
			if	cs			;v[ɕ`悷Ƃ
				movea.l	a0,a2			;tHgf[^
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.w	(a2)+,d0		;tHg
					move.w	(a3)+,d1		;}XN
					lsr.w	d2,d0
					lsr.w	d2,d1
					not.w	d1
					and.w	(a4),d1			;蔲
					or.w	d1,d0			;킹
					move.w	d0,(a4)+		;
					addq.l	#4-2,a2
					addq.l	#4-2,a3
					lea.l	128-2(a4),a4		;̃X^
				next
			else				;v[Ƃ
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.w	(a3)+,d1		;}XN
					lsr.w	d2,d1
					not.w	d1
					and.w	d1,(a4)+		;蔲
					addq.l	#4-2,a3
					lea.l	128-2(a4),a4		;̃X^
				next
			endif
			adda.l	#-128*16+128*1024,a4	;̃v[
		while	<cmpa.l #$00E40000,a4>,lo
	elif	<cmp.w #32,d3>,ls
	;----------------
	;2[hɌׂƂ
		do				;v[̃[v
			lsr.b	#1,d4
			if	cs			;v[ɕ`悷Ƃ
				movea.l	a0,a2			;tHgf[^
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.l	(a2)+,d0		;tHg
					move.l	(a3)+,d1		;}XN
					lsr.l	d2,d0
					lsr.l	d2,d1
					not.l	d1
					and.l	(a4),d1			;蔲
					or.l	d1,d0			;킹
					move.l	d0,(a4)+		;
				;	addq.l	#4-4,a2
				;	addq.l	#4-4,a3
					lea.l	128-4(a4),a4		;̃X^
				next
			else				;v[Ƃ
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.l	(a3)+,d1		;}XN
					lsr.l	d2,d1
					not.l	d1
					and.l	d1,(a4)+		;蔲
				;	addq.l	#4-4,a3
					lea.l	128-4(a4),a4		;̃X^
				next
			endif
			adda.l	#-128*16+128*1024,a4	;̃v[
		while	<cmpa.l #$00E40000,a4>,lo
	else
	;----------------
	;3[hɌׂƂ
		do				;v[̃[v
			lsr.b	#1,d4
			if	cs			;v[ɕ`悷Ƃ
				movea.l	a0,a2			;tHgf[^
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.l	(a2)+,d0		;tHg
					move.l	(a3)+,d1		;}XN
					lsr.l	d2,d0
					lsr.l	d2,d1
					not.l	d1
					and.l	(a4),d1			;蔲
					or.l	d1,d0			;킹
					move.l	d0,(a4)+		;
					move.w	-2(a2),d0		;tHg
					move.w	-2(a3),d1		;}XN
					swap.w	d0
					swap.w	d1
					clr.w	d0
					clr.w	d1
					lsr.l	d2,d0
					lsr.l	d2,d1
					not.w	d1
					and.w	(a4),d1			;蔲
					or.w	d1,d0			;킹
					move.w	d0,(a4)+		;
				;	addq.l	#4-4,a2
				;	addq.l	#4-4,a3
					lea.l	128-6(a4),a4		;̃X^
				next
			else				;v[Ƃ
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.l	(a3)+,d1		;}XN
					lsr.l	d2,d1
					not.l	d1
					and.l	d1,(a4)+		;蔲
					move.w	-2(a3),d1		;}XN
					swap.w	d1
					clr.w	d1
					lsr.l	d2,d1
					not.w	d1
					and.w	d1,(a4)+		;蔲
				;	addq.l	#4-4,a3
					lea.l	128-6(a4),a4		;̃X^
				next
			endif
			adda.l	#-128*16+128*1024,a4	;̃v[
		while	<cmpa.l #$00E40000,a4>,lo
	endif
	pop
	rts

;----------------------------------------------------------------
;sRs[
;	    
;	            
;	          d2
;	d0                  
;	                    
;	d1        
;	            
;	    
;	    
;	            
;	d0        
;	                    d2
;	d1                  
;	          
;	            
;	    
;<d0.w:Rs[̏[̍sW
;<d1.w:Rs[̉[̍sW
;<d2.w:Rs[̏[̍sW
putc_copy_rows:
	push	d0-d3/a0
	move.l	BIOS_CONSOLE_OFFSET.w,d3	;R\[̍̃AhX̃ItZbg
	lsr.l	#7,d3			;R\[̏[YhbgW
	lsr.w	#2,d3			;R\[̏[̃X^ubNԍ
	sub.w	d0,d1			;Rs[̉[̍sW-Rs[̏[̍sW=Rs[s-1
	lsl.w	#2,d1			;Rs[郉X^ubN-4
	addq.w	#3,d1			;Rs[郉X^ubN-1
;<d1.w:Rs[郉X^ubN-1
	lsl.w	#2,d0
	add.w	d3,d0			;Rs[̏[̃X^ubNԍ
;<d0.w:Rs[̏[̃X^ubNԍ
	lsl.w	#2,d2
	add.w	d3,d2			;Rs[̏[̃X^ubNԍ
;<d2.w:Rs[̏[̃X^ubNԍ
	if	<cmp.w d0,d2>,ls	;ɂ炷Ƃ
		move.w	#$0101,d3		;X^ubNԍ̑
	else				;ɂ炷Ƃ
		add.w	d1,d0			;Rs[̉[̃X^ubNԍ
		add.w	d1,d2			;Rs[̉[̃X^ubNԍ
		move.w	#$FEFF,d3		;X^ubNԍ̑
	endif
;<d0.w:Rs[̃X^ubNԍ
;<d2.w:Rs[̃X^ubNԍ
;<d3.w:X^ubNԍ̑
	lsl.w	#8,d0			;Rs[̃X^ubNԍ<<8
	move.b	d2,d0			;Rs[̃X^ubNԍ<<8|Rs[̃X^ubNԍ
;<d0.w:Rs[̃X^ubNԍ<<8|Rs[̃X^ubNԍ
aGPDR	reg	a0
	lea.l	MFP_GPDR,aGPDR		;GPIPf[^WX^BHSYNC|RINT|-|VDISP|OPMIRQ|POWER|EXPWON|ALARM
	move.w	sr,d2
	for	d1			;X^ubÑ[v
		do
		while	<tst.b (aGPDR)>,mi	;\Ԃ҂
		ori.w	#$0700,sr		;荞݂֎~
		do
		while	<tst.b (aGPDR)>,pl	;AԂ҂
		move.w	d0,CRTC_BLOCK-MFP_GPDR(aGPDR)	;X^ubNԍݒ肷
		move.w	#$0008,CRTC_ACTION-MFP_GPDR(aGPDR)	;X^Rs[ONɂB2ڈȍ~͕sv
		move.w	d2,sr			;荞݂
		add.w	d3,d0			;̃X^ubN
	next
	do
	while	<tst.b (aGPDR)>,mi	;\Ԃ҂
	ori.w	#$0700,sr		;荞݂֎~
	do
	while	<tst.b (aGPDR)>,pl	;AԂ҂
	move.w	d2,sr			;荞݂
	clr.w	CRTC_ACTION-MFP_GPDR(aGPDR)	;X^Rs[OFFɂBKv
	pop
	rts

;----------------------------------------------------------------
;s
;<d0.w:[̍sW
;<d1.w:[̍sW
putc_clear_rows:
	push	d2-d5
	moveq.l	#0,d2			;[̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[̌W
	moveq.l	#0,d4			;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;
;	͋󔒂̕`ƓBwiFœhׂ
;				F	wiF
;		0				
;		1			F	
;		2			F	
;		3				
;		4				
;		5			F	
;		6			F	
;		7				
;		8	]			
;		9	]			F
;		10	]			F
;		11	]			
;		12	]			
;		13	]			F
;		14	]			F
;		15	]			
;<d0.w:[̍sW
;<d1.w:[̍sW
;<d2.w:[̌W
;<d3.w:E[̌W
;<d4.w:[̌W̒[B0`7B܂
;<d5.w:E[̌W̒[B0`7B܂
putc_clear:
	push	d0-d7/a0-a3
;----------------
;X^߂
	sub.w	d0,d1			;[̍sW-[̍sW=s-1
	addq.w	#1,d1			;s
	lsl.w	#4,d1			;16*s=X^
	subq.w	#1,d1			;X^-1
	movea.w	d1,a3
;<a3.w:X^-1
;?d1
;----------------
;AhX߂
	swap.w	d0
	clr.w	d0			;65536*sW
	lsr.l	#5,d0			;128*16*sW
	add.l	BIOS_CONSOLE_OFFSET.w,d0	;[̍s̍̃AhX̃ItZbg
	add.l	#$00E00000,d0		;[̍s̍̃AhX
	ext.l	d2
	ext.l	d3
	add.l	d0,d2			;̃AhX
	add.l	d0,d3			;ẼAhX
;<d2.l:̃AhX
;<d3.l:ẼAhX
;?d0
;----------------
;AhXɂ
;	Wł͂ȂAhXɂ
;	_B_CONSOL̓R\[̍[̃AhXɐĂȂ
	bclr.l	#0,d2
	if	ne
		addq.w	#8,d4
	endif
;<d2.l:̃AhXB
;<d4.w:[̌W̒[B0`15
	bclr.l	#0,d3
	if	ne
		addq.w	#8,d5
	endif
;<d3.l:ẼAhXB
;<d5.w:E[̌W̒[B0`15
	movea.l	d2,a2
;<a2.l:̃AhXB
;----------------
;[h߂
	sub.w	d2,d3			;E[̃AhX-[̃AhX=2*([h-1)
	lsr.w	#1,d3			;[h-1
;<d3.w:[h-1
;?d2
;----------------
;}XN
	moveq.l	#-1,d6
	move.w	#$8000,d7
	lsr.w	d4,d6			;[̏ޕ1̃}XNB$FFFF,$7FFF,c,$0003,$0001
	asr.w	d5,d7			;E[̏ޕ1̃}XNB$8000,$C000,c,$FFFE,$FFFF
;<d6.w:[̏ޕ1̃}XNB$FFFF,$7FFF,c,$0003,$0001
;<d7.w:E[̏ޕ1̃}XNB$8000,$C000,c,$FFFE,$FFFF
;?d4-d5
;----------------
;f[^
	moveq.l	#%1111,d0
	and.b	BIOS_ATTRIBUTE_1.w,d0	;v[##
;		  111111
;		  5432109876543210
	move.w	#%1100110000000000,d2	;wiFF܂͔Bv[1hׂ
	btst.l	d0,d2
	sne.b	d2
	ext.w	d2
	swap.w	d2
;		  111111
;		  5432109876543210
	move.w	#%1010101000000000,d2	;wiFF܂͔Bv[0hׂ
	btst.l	d0,d2
	sne.b	d2
	ext.w	d2
;<d2.l:v[1̃f[^<<16|v[0̃f[^
;----------------
;1[h1[hł͂Ȃ
	if	<tst.w d3>,eq
	;----------------
	;1[ĥƂ
		and.w	d7,d6
	;<d6.w:ޕ1̃}XN
		and.w	d6,d2
		swap.w	d2
		and.w	d6,d2
		swap.w	d2
	;<d2.l:v[1̃f[^<<16|v[0̃f[^
		not.w	d6
	;<d6.w:܂Ȃ1̃}XN
		do				;v[̃[v
			movea.l	a2,a0			;̃AhX[̃AhX
			move.w	a3,d1			;X^-1
			for	d1			;X^̃[v
				move.w	(a0),d0
				and.w	d6,d0			;}XN
				or.w	d2,d0			;f[^
				move.w	d0,(a0)
				lea.l	128(a0),a0		;̍[̃AhX
			next
			swap.w	d2			;̃v[̃f[^
			adda.l	#128*1024,a2		;̃v[̍̃AhX
		while	<cmpa.l #$00E40000,a2>,lo
	else
	;----------------
	;1[hł͂ȂƂ
		subq.w	#1,d3
	;<d3.w:[ƉE[̊Ԃ̃[hB0`
		move.l	d2,d4
		move.l	d2,d5
	;<d4.l:v[1̃f[^<<16|v[0̃f[^
	;<d5.l:v[1̃f[^<<16|v[0̃f[^
		and.w	d6,d4
		and.w	d7,d5
		swap.w	d4
		swap.w	d5
		and.w	d6,d4
		and.w	d7,d5
		swap.w	d4
		swap.w	d5
	;<d4.l:v[1̍[̃f[^<<16|v[0̍[̃f[^
	;<d5.l:v[1̉E[̃f[^<<16|v[0̉E[̃f[^
		not.w	d6
		not.w	d7
	;<d6.w:[̏܂Ȃ1̃}XNB$0000,$8000,c,$FFFC,$FFFE
	;<d7.w:E[̏܂Ȃ1̃}XNB$7FFF,$3FFF,c,$0001,$0000
		do				;v[̃[v
			movea.l	a2,a1			;̃AhX[̃AhX
			move.w	a3,d1			;X^-1
			for	d1			;X^̃[v
				movea.l	a1,a0			;[̃AhX̃AhX
			;[
				move.w	(a0),d0
				and.w	d6,d0			;[̃}XN
				or.w	d4,d0			;[̃f[^
				move.w	d0,(a0)+
			;[ƉE[̊
				move.w	d3,d0			;[ƉE[̊Ԃ̃[hB0`
				forcontinue	d0
					move.w	d2,(a0)+		;f[^
				next
			;E[
				move.w	(a0),d0
				and.w	d7,d0			;E[̃}XN
				or.w	d5,d0			;E[̃f[^
				move.w	d0,(a0)+
				lea.l	128(a1),a1		;̍[̃AhX
			next
			swap.w	d2			;̃v[̃f[^
			swap.w	d4			;̃v[̍[̃f[^
			swap.w	d5			;̃v[̉E[̃f[^
			adda.l	#128*1024,a2		;̃v[̍̃AhX
		while	<cmpa.l #$00E40000,a2>,lo
	endif
	pop
	rts

;----------------------------------------------------------------
;v|[VitHg($20`$82)
proportional_font:
	.dc.w	6	;$20   
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$21 I
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0111000000000000
	.dc.w	%0111000000000000
	.dc.w	%0111000000000000
	.dc.w	%0111000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$22 h
	.dc.w	%0000000000000000
	.dc.w	%0110011000000000
	.dc.w	%0110011000000000
	.dc.w	%0010001000000000
	.dc.w	%0010001000000000
	.dc.w	%0100010000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$23 
	.dc.w	%0000000000000000
	.dc.w	%0001001000000000
	.dc.w	%0001001000000000
	.dc.w	%0001001000000000
	.dc.w	%0111111100000000
	.dc.w	%0010010000000000
	.dc.w	%0010010000000000
	.dc.w	%0010010000000000
	.dc.w	%1111111000000000
	.dc.w	%0100100000000000
	.dc.w	%0100100000000000
	.dc.w	%0100100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$24 
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0111110000000000
	.dc.w	%1001001000000000
	.dc.w	%1101000000000000
	.dc.w	%0111100000000000
	.dc.w	%0011110000000000
	.dc.w	%0001011000000000
	.dc.w	%1001001000000000
	.dc.w	%0111110000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$25 
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%1001000010000000
	.dc.w	%1001000100000000
	.dc.w	%1001001000000000
	.dc.w	%0110010000000000
	.dc.w	%0000100000000000
	.dc.w	%0001001100000000
	.dc.w	%0010010010000000
	.dc.w	%0100010010000000
	.dc.w	%1000010010000000
	.dc.w	%0000001100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$26 
	.dc.w	%0000000000000000
	.dc.w	%0111000000000000
	.dc.w	%1000100000000000
	.dc.w	%1000100000000000
	.dc.w	%1000100000000000
	.dc.w	%0101000000000000
	.dc.w	%0011000000000000
	.dc.w	%0100100100000000
	.dc.w	%1000010100000000
	.dc.w	%1000001000000000
	.dc.w	%1000010100000000
	.dc.w	%0111100010000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$27 f
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$28 i
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$29 j
	.dc.w	%0000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$2A 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%1001001000000000
	.dc.w	%0101010000000000
	.dc.w	%0011100000000000
	.dc.w	%0101010000000000
	.dc.w	%1001001000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$2B {
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%1111111000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$2C C
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$2D |
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$2E D
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$2F ^
	.dc.w	%0000000000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$30 O
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$31 P
	.dc.w	%0000000000000000
	.dc.w	%0000100000000000
	.dc.w	%0001100000000000
	.dc.w	%0011100000000000
	.dc.w	%0111100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0111111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$32 Q
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%0000001100000000
	.dc.w	%0000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0110000000000000
	.dc.w	%1100000000000000
	.dc.w	%1111111100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$33 R
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%0000001100000000
	.dc.w	%0000011000000000
	.dc.w	%0001110000000000
	.dc.w	%0000011000000000
	.dc.w	%0000001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$34 S
	.dc.w	%0000000000000000
	.dc.w	%0000001000000000
	.dc.w	%0000011000000000
	.dc.w	%0000111000000000
	.dc.w	%0001111000000000
	.dc.w	%0011011000000000
	.dc.w	%0110011000000000
	.dc.w	%1100011000000000
	.dc.w	%1111111100000000
	.dc.w	%0000011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$35 T
	.dc.w	%0000000000000000
	.dc.w	%0111111000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0111110000000000
	.dc.w	%0000011000000000
	.dc.w	%0000001100000000
	.dc.w	%0000001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$36 U
	.dc.w	%0000000000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0110000000000000
	.dc.w	%0111110000000000
	.dc.w	%1110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$37 V
	.dc.w	%0000000000000000
	.dc.w	%1111111100000000
	.dc.w	%1100001100000000
	.dc.w	%1100011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$38 W
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$39 X
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011100000000
	.dc.w	%0011111000000000
	.dc.w	%0000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$3A F
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$3B G
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$3C 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$3D 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$3E 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$3F H
	.dc.w	%0000000000000000
	.dc.w	%1111000000000000
	.dc.w	%0011100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$40 
	.dc.w	%0000000000000000
	.dc.w	%0001111100000000
	.dc.w	%0010000010000000
	.dc.w	%0100000001000000
	.dc.w	%1000111001000000
	.dc.w	%1001001001000000
	.dc.w	%1001001001000000
	.dc.w	%1001001001000000
	.dc.w	%1001110110000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0011111110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$41 `
	.dc.w	%0000000000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0001011000000000
	.dc.w	%0001011000000000
	.dc.w	%0001011000000000
	.dc.w	%0010001100000000
	.dc.w	%0010001100000000
	.dc.w	%0011111100000000
	.dc.w	%0100000110000000
	.dc.w	%0100000110000000
	.dc.w	%1110001111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$42 a
	.dc.w	%0000000000000000
	.dc.w	%1111110000000000
	.dc.w	%0110011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110011000000000
	.dc.w	%0111111000000000
	.dc.w	%0110001100000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110001100000000
	.dc.w	%1111110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$43 b
	.dc.w	%0000000000000000
	.dc.w	%0001111010000000
	.dc.w	%0110000110000000
	.dc.w	%1100000010000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000010000000
	.dc.w	%0110000100000000
	.dc.w	%0001111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$44 c
	.dc.w	%0000000000000000
	.dc.w	%1111110000000000
	.dc.w	%0110001100000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110001100000000
	.dc.w	%1111110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$45 d
	.dc.w	%0000000000000000
	.dc.w	%1111111110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000010000000
	.dc.w	%0110000000000000
	.dc.w	%0110001000000000
	.dc.w	%0111111000000000
	.dc.w	%0110001000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000010000000
	.dc.w	%0110000110000000
	.dc.w	%1111111110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$46 e
	.dc.w	%0000000000000000
	.dc.w	%1111111110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000010000000
	.dc.w	%0110000000000000
	.dc.w	%0110001000000000
	.dc.w	%0111111000000000
	.dc.w	%0110001000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$47 f
	.dc.w	%0000000000000000
	.dc.w	%0001111010000000
	.dc.w	%0110000110000000
	.dc.w	%1100000010000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100001111000000
	.dc.w	%1100000010000000
	.dc.w	%1100000010000000
	.dc.w	%0110000100000000
	.dc.w	%0001111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$48 g
	.dc.w	%0000000000000000
	.dc.w	%1111001111000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0111111110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%1111001111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	7	;$49 h
	.dc.w	%0000000000000000
	.dc.w	%1111110000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%1111110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$4A i
	.dc.w	%0000000000000000
	.dc.w	%0001111000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%1100110000000000
	.dc.w	%0011000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$4B j
	.dc.w	%0000000000000000
	.dc.w	%1111001110000000
	.dc.w	%0110000100000000
	.dc.w	%0110001000000000
	.dc.w	%0110010000000000
	.dc.w	%0110100000000000
	.dc.w	%0111110000000000
	.dc.w	%0110011000000000
	.dc.w	%0110011000000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%1111011110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$4C k
	.dc.w	%0000000000000000
	.dc.w	%1111000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000010000000
	.dc.w	%0110000110000000
	.dc.w	%1111111110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	13	;$4D l
	.dc.w	%0000000000000000
	.dc.w	%1110000001110000
	.dc.w	%0110000001100000
	.dc.w	%0111000001100000
	.dc.w	%0111000011100000
	.dc.w	%0111100011100000
	.dc.w	%0101100101100000
	.dc.w	%0101110101100000
	.dc.w	%0100111001100000
	.dc.w	%0100111001100000
	.dc.w	%0100010001100000
	.dc.w	%1110010011110000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	12	;$4E m
	.dc.w	%0000000000000000
	.dc.w	%1100000011100000
	.dc.w	%0110000001000000
	.dc.w	%0111000001000000
	.dc.w	%0111100001000000
	.dc.w	%0101110001000000
	.dc.w	%0100111001000000
	.dc.w	%0100011101000000
	.dc.w	%0100001111000000
	.dc.w	%0100000111000000
	.dc.w	%0100000011000000
	.dc.w	%1110000001000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$4F n
	.dc.w	%0000000000000000
	.dc.w	%0001111000000000
	.dc.w	%0110000110000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%0110000110000000
	.dc.w	%0001111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$50 o
	.dc.w	%0000000000000000
	.dc.w	%1111111000000000
	.dc.w	%0110000110000000
	.dc.w	%0110000011000000
	.dc.w	%0110000011000000
	.dc.w	%0110000011000000
	.dc.w	%0110000110000000
	.dc.w	%0111111000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$51 p
	.dc.w	%0000000000000000
	.dc.w	%0001111000000000
	.dc.w	%0110000110000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1101110011000000
	.dc.w	%1111011110000000
	.dc.w	%0110001100000000
	.dc.w	%0001111100000000
	.dc.w	%0000000110000000
	.dc.w	%0000000011000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$52 q
	.dc.w	%0000000000000000
	.dc.w	%1111111000000000
	.dc.w	%0110000110000000
	.dc.w	%0110000011000000
	.dc.w	%0110000011000000
	.dc.w	%0110000011000000
	.dc.w	%0110000110000000
	.dc.w	%0111111000000000
	.dc.w	%0110111000000000
	.dc.w	%0110011100000000
	.dc.w	%0110001110000000
	.dc.w	%1111000111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$53 r
	.dc.w	%0000000000000000
	.dc.w	%0001110100000000
	.dc.w	%0110001100000000
	.dc.w	%1100000100000000
	.dc.w	%1110000000000000
	.dc.w	%0111000000000000
	.dc.w	%0011110000000000
	.dc.w	%0000111000000000
	.dc.w	%0000011100000000
	.dc.w	%1000001100000000
	.dc.w	%1100011000000000
	.dc.w	%1011100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$54 s
	.dc.w	%0000000000000000
	.dc.w	%1111111111000000
	.dc.w	%1100110011000000
	.dc.w	%1000110001000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0011111100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$55 t
	.dc.w	%0000000000000000
	.dc.w	%1111000111000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0011000100000000
	.dc.w	%0000111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$56 u
	.dc.w	%0000000000000000
	.dc.w	%1111000111000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0011000100000000
	.dc.w	%0011000100000000
	.dc.w	%0011000100000000
	.dc.w	%0001101000000000
	.dc.w	%0001101000000000
	.dc.w	%0001101000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	16	;$57 v
	.dc.w	%0000000000000000
	.dc.w	%1111000110001110
	.dc.w	%0110000110000100
	.dc.w	%0011000111000100
	.dc.w	%0011000111000100
	.dc.w	%0011001011001000
	.dc.w	%0001101001101000
	.dc.w	%0001101001101000
	.dc.w	%0001101001101000
	.dc.w	%0000110000110000
	.dc.w	%0000110000110000
	.dc.w	%0000110000110000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$58 w
	.dc.w	%0000000000000000
	.dc.w	%1111000111000000
	.dc.w	%0110000010000000
	.dc.w	%0011000100000000
	.dc.w	%0011001000000000
	.dc.w	%0001110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000111000000000
	.dc.w	%0001001100000000
	.dc.w	%0010001100000000
	.dc.w	%0100000110000000
	.dc.w	%1110001111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$59 x
	.dc.w	%0000000000000000
	.dc.w	%1111000111000000
	.dc.w	%0110000010000000
	.dc.w	%0011000100000000
	.dc.w	%0011000100000000
	.dc.w	%0001101000000000
	.dc.w	%0001101000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0001111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$5A y
	.dc.w	%0000000000000000
	.dc.w	%1111111111000000
	.dc.w	%1100000011000000
	.dc.w	%1000000110000000
	.dc.w	%0000001100000000
	.dc.w	%0000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0110000001000000
	.dc.w	%1100000011000000
	.dc.w	%1111111111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$5B m
	.dc.w	%0000000000000000
	.dc.w	%0111000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$5C 
	.dc.w	%0000000000000000
	.dc.w	%1000001000000000
	.dc.w	%1000001000000000
	.dc.w	%0100010000000000
	.dc.w	%0100010000000000
	.dc.w	%0010100000000000
	.dc.w	%0010100000000000
	.dc.w	%0111110000000000
	.dc.w	%0001000000000000
	.dc.w	%0111110000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$5D n
	.dc.w	%0000000000000000
	.dc.w	%0111000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$5E O
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%0010100000000000
	.dc.w	%0100010000000000
	.dc.w	%1000001000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$5F Q
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$60 M
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$61 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0111110000000000
	.dc.w	%1100111000000000
	.dc.w	%0000011000000000
	.dc.w	%0011111000000000
	.dc.w	%0110011000000000
	.dc.w	%1100011000000000
	.dc.w	%1100111000000000
	.dc.w	%0111011100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$62 
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110111000000000
	.dc.w	%0111001100000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0111001100000000
	.dc.w	%1101111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$63 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$64 
	.dc.w	%0000000000000000
	.dc.w	%0000011100000000
	.dc.w	%0000001100000000
	.dc.w	%0000001100000000
	.dc.w	%0011101100000000
	.dc.w	%0110011100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011100000000
	.dc.w	%0011101110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$65 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001000000000
	.dc.w	%1111111000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	7	;$66 
	.dc.w	%0000000000000000
	.dc.w	%0011100000000000
	.dc.w	%0110110000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111100000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$67 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0111110100000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%0111110000000000
	.dc.w	%1100000000000000
	.dc.w	%0111111000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0111111000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$68 
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110111000000000
	.dc.w	%0111011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%1111011110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$69 
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$6A 
	.dc.w	%0000000000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0000000000000000
	.dc.w	%0011100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%1101100000000000
	.dc.w	%0111000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$6B 
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110111000000000
	.dc.w	%0110010000000000
	.dc.w	%0110100000000000
	.dc.w	%0111000000000000
	.dc.w	%0111100000000000
	.dc.w	%0110110000000000
	.dc.w	%0110011000000000
	.dc.w	%1111011100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$6C 
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	15	;$6D 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1101111011110000
	.dc.w	%0111011110111000
	.dc.w	%0110001100011000
	.dc.w	%0110001100011000
	.dc.w	%0110001100011000
	.dc.w	%0110001100011000
	.dc.w	%0110001100011000
	.dc.w	%1111011110111100
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$6E 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110111000000000
	.dc.w	%0111011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%1111011110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$6F 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$70 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110111000000000
	.dc.w	%0111011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0111011100000000
	.dc.w	%0110111000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$71 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0111011100000000
	.dc.w	%1110111000000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%1110111000000000
	.dc.w	%0111011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000111100000000
	.dc.w	%0000000000000000
	.dc.w	9	;$72 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110111000000000
	.dc.w	%0111001100000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$73 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0111101000000000
	.dc.w	%1100011000000000
	.dc.w	%1100001000000000
	.dc.w	%0111100000000000
	.dc.w	%0011110000000000
	.dc.w	%1000011000000000
	.dc.w	%1100011000000000
	.dc.w	%1011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	7	;$74 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111100000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110110000000000
	.dc.w	%0011100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$75 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110011100000000
	.dc.w	%0011110110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$76 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111011100000000
	.dc.w	%0110001000000000
	.dc.w	%0110010000000000
	.dc.w	%0011010000000000
	.dc.w	%0011100000000000
	.dc.w	%0011100000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	14	;$77 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111001000111000
	.dc.w	%0110001100010000
	.dc.w	%0110001100010000
	.dc.w	%0011010110100000
	.dc.w	%0011010110100000
	.dc.w	%0001110011100000
	.dc.w	%0001100011000000
	.dc.w	%0000100001000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$78 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111011100000000
	.dc.w	%0110001000000000
	.dc.w	%0011010000000000
	.dc.w	%0001100000000000
	.dc.w	%0001110000000000
	.dc.w	%0010011000000000
	.dc.w	%0100001100000000
	.dc.w	%1110011110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$79 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111001110000000
	.dc.w	%0110000100000000
	.dc.w	%0110000100000000
	.dc.w	%0011001000000000
	.dc.w	%0011001000000000
	.dc.w	%0001110000000000
	.dc.w	%0001110000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$7A 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111111000000000
	.dc.w	%1000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0110000000000000
	.dc.w	%1100001000000000
	.dc.w	%1111111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$7B o
	.dc.w	%0000000000000000
	.dc.w	%0001100000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$7C b
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$7D p
	.dc.w	%0000000000000000
	.dc.w	%1100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%1100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$7E P
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$7F DL
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$80 _
	.dc.w	%0000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$81 `
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%1001001000000000
	.dc.w	%0000110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$82 U
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000



;----------------------------------------------------------------
;
;	SASI IOCS
;
;----------------------------------------------------------------

SASI_OFFSET	equ	-$95B6+$CCB8

;----------------------------------------------------------------
;	΃AhX
;		P[g
;	ύXO
;		000095BE 49F9(01)00009E30 	lea.l	sasi_seek_command,a4		;SEEKR}h
;----------------------------------------------------------------
	PATCH_DATA	p95be,$00FF95BE+SASI_OFFSET,$00FF95BE+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E30+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		00009650 49F9(01)00009E3C 		lea.l	sasi_set_drive_parameter_command,a4	;SET DRIVE PARAMETERR}h
;----------------------------------------------------------------
	PATCH_DATA	p9650,$00FF9650+SASI_OFFSET,$00FF9650+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E3C+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		0000965E 49F9(01)00009E60 			lea.l	sasi_20mb_shipping_parameter,a4	;20MBhCup[^(VbsO][)
;----------------------------------------------------------------
	PATCH_DATA	p965E,$00FF965E+SASI_OFFSET,$00FF965E+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E60+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		00009684 43F9(01)00009E42 					lea.l	sasi_10mb_drive_parameter,a1	;10MBhCup[^
;----------------------------------------------------------------
	PATCH_DATA	p9684,$00FF9684+SASI_OFFSET,$00FF9684+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E42+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		00009694 43F9(01)00009E42 						lea.l	sasi_10mb_drive_parameter,a1	;10MBhCup[^
;----------------------------------------------------------------
	PATCH_DATA	p9694,$00FF9694+SASI_OFFSET,$00FF9694+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E42+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		000096C8 49F9(01)00009E3C 						lea.l	sasi_set_drive_parameter_command,a4		;SET DRIVE PARAMETERR}h
;----------------------------------------------------------------
	PATCH_DATA	p96C8,$00FF96C8+SASI_OFFSET,$00FF96C8+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E3C+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		00009728 49F9(01)00009E0C 	lea.l	sasi_test_drive_ready_command,a4	;TEST DRIVE READYR}h
;----------------------------------------------------------------
	PATCH_DATA	p9728,$00FF9728+SASI_OFFSET,$00FF9728+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E0C+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		000097B0 49F9(01)00009E2A 	lea.l	sasi_write_command,a4	;WRITER}h
;----------------------------------------------------------------
	PATCH_DATA	p97B0,$00FF97B0+SASI_OFFSET,$00FF97B0+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E2A+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		00009854 49F9(01)00009E24 	lea.l	sasi_read_command,a4		;READR}h
;----------------------------------------------------------------
	PATCH_DATA	p9854,$00FF9854+SASI_OFFSET,$00FF9854+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E24+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		000098A6 49F9(01)00009E36 	lea.l	sasi_format_alternate_track_command,a4		;FORAMT ALTERNATE TRACKR}h
;----------------------------------------------------------------
	PATCH_DATA	p98A6,$00FF98A6+SASI_OFFSET,$00FF98A6+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E36+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		000098D6 49F9(01)00009E1E 	lea.l	sasi_format_bad_track_command,a4	;FORMAT BAD TRACKR}h
;----------------------------------------------------------------
	PATCH_DATA	p98D6,$00FF98D6+SASI_OFFSET,$00FF98D6+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E1E+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		000098FE 49F9(01)00009E18 	lea.l	sasi_format_track_command,a4		;FORMAT TRACKR}h
;----------------------------------------------------------------
	PATCH_DATA	p98FE,$00FF98FE+SASI_OFFSET,$00FF98FE+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E18+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		0000993A 43F9(01)00009E56 	lea.l	sasi_20mb_drive_parameter,a1	;20MBhCup[^
;----------------------------------------------------------------
	PATCH_DATA	p993A,$00FF993A+SASI_OFFSET,$00FF993A+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E56+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		00009946 43F9(01)00009E6A 		lea.l	sasi_40mb_drive_parameter,a1	;40MBhCup[^
;----------------------------------------------------------------
	PATCH_DATA	p9946,$00FF9946+SASI_OFFSET,$00FF9946+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E6A+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		00009952 43F9(01)00009E42 			lea.l	sasi_10mb_drive_parameter,a1	;10MBhCup[^
;----------------------------------------------------------------
	PATCH_DATA	p9952,$00FF9952+SASI_OFFSET,$00FF9952+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E42+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		00009972 43F9(01)00009E42 				lea.l	sasi_10mb_drive_parameter,a1	;10MBhCup[^
;----------------------------------------------------------------
	PATCH_DATA	p9972,$00FF9972+SASI_OFFSET,$00FF9972+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E42+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		000099B2 49F9(01)00009E3C 		lea.l	sasi_set_drive_parameter_command,a4	;SET DRIVE PARAMETERR}h
;----------------------------------------------------------------
	PATCH_DATA	p99B2,$00FF99B2+SASI_OFFSET,$00FF99B2+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E3C+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		000099FE 43F9(01)00009E60 			lea.l	sasi_20mb_shipping_parameter,a1
;----------------------------------------------------------------
	PATCH_DATA	p99FE,$00FF99FE+SASI_OFFSET,$00FF99FE+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E60+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		00009A10 43F9(01)00009E74 				lea.l	sasi_40mb_shipping_parameter,a1
;----------------------------------------------------------------
	PATCH_DATA	p9A10,$00FF9A10+SASI_OFFSET,$00FF9A10+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E74+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		00009A22 43F9(01)00009E4C 					lea.l	sasi_10mb_shipping_parameter,a1
;----------------------------------------------------------------
	PATCH_DATA	p9A22,$00FF9A22+SASI_OFFSET,$00FF9A22+5+SASI_OFFSET,$43F900FF
	lea.l	$00FF9E4C+SASI_OFFSET,a1
;----------------------------------------------------------------
;	ύXO
;		00009A2E 49F9(01)00009E3C 				lea.l	sasi_set_drive_parameter_command,a4	;SET DRIVE PARAMETERR}h
;----------------------------------------------------------------
	PATCH_DATA	p9A2E,$00FF9A2E+SASI_OFFSET,$00FF9A2E+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E3C+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		00009A48 49F9(01)00009E30 							lea.l	sasi_seek_command,a4	;SEEKR}h
;----------------------------------------------------------------
	PATCH_DATA	p9A48,$00FF9A48+SASI_OFFSET,$00FF9A48+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E30+SASI_OFFSET,a4
;----------------------------------------------------------------
;	ύXO
;		00009D76 49F9(01)00009E12 		lea.l	sasi_recalibrate_command,a4	;RECALIBRATER}h
;----------------------------------------------------------------
	PATCH_DATA	p9D76,$00FF9D76+SASI_OFFSET,$00FF9D76+5+SASI_OFFSET,$49F900FF
	lea.l	$00FF9E12+SASI_OFFSET,a4

;----------------------------------------------------------------
;	SASIxt@C(1024oCgȉ)
;	
;		https://twitter.com/kamadox/status/1361214698226479109
;		IOCS _B_VERIFYSASIn[hfBXN̂ƂΏۂX[p[oCUX^bNɓǂݍŃŃf[^rĂ
;		܂OŠ󂯂ĂȂobt@DMA]Ă
;		̍\͂܂B[JƂX[p[oCUX^bNDMA͂Ƃ͌Ȃ
;	΍
;		rf[^͒OɃfBXNɏ񂾃f[^ł肻̃obt@DMA]\ȗ̈ɂ邱Ƃ҂ł
;		(1)obt@̐擪AhX$00F00000`$00FFFFFF͈̔͂ɂƂrs킸ɐԂ
;		(2)rf[^obt@X^bNփRs[
;		(3)rf[^fBXNobt@֓ǂݍ
;		(4)ǂݍݐ̂Ƃobt@ƃX^bNr
;		(5)ǂݍݎs܂͕sv̂Ƃrf[^X^bNobt@փRs[
;----------------------------------------------------------------
	PATCH_DATA	p9618,$00FF9618+SASI_OFFSET,$00FF963F+SASI_OFFSET,$4FEFFC00
	jmp	sasi_verify_1024
	PATCH_TEXT
;<d1.w:$8000|HD-ID(0`15)<<8
;<d2.l:R[hԍ
;<d3.w:oCgB1024ȉ
;<a1.l:obt@̐擪AhX
;>d0.l:0=,-2=s
sasi_verify_1024:
	push	d4/a0-a1/a6,1024
;(1)obt@̐擪AhX$00F00000`$00FFFFFF͈̔͂ɂƂrs킸ɐԂ
	moveq.l	#0,d0			;
	gotoand	<cmpa.l #$00F00000,a1>,hs,<cmpa.l #$00FFFFFF,a1>,ls,90f
;(2)rf[^obt@X^bNփRs[
	movea.l	a1,a6			;obt@
;	movea.l	a6,a1			;obt@
	movea.l	sp,a0			;X^bN
	move.w	d3,d4
	subq.w	#1,d4
	for	d4
		move.b	(a1)+,(a0)+
	next
;(3)rf[^fBXNobt@֓ǂݍ
	movea.l	a6,a1			;obt@
	jsr	$00FF9826+SASI_OFFSET	;sasi_read_modifyBd1-d3/a1/a6͔j󂳂Ȃ
	goto	<tst.b d0>,ne,10f	;ǂݍݎs
;ǂݍݐ
;(4)ǂݍݐ̂Ƃobt@ƃX^bNr
	moveq.l	#0,d0			;
;	movea.l	a6,a1			;obt@
	movea.l	sp,a0			;X^bN
	move.w	d3,d4
	subq.w	#1,d4
	for	d4
		cmpm.b	(a1)+,(a0)+
	next	eq
	goto	eq,90f			;v
;sv
	moveq.l	#-2,d0			;s
;(5)ǂݍݎs܂͕sv̂Ƃrf[^X^bNobt@փRs[
10:	movea.l	sp,a1			;X^bN
	movea.l	a6,a0			;obt@
	move.w	d3,d4
	subq.w	#1,d4
	for	d4
		move.b	(a1)+,(a0)+
	next
90:	pop
	rts

;----------------------------------------------------------------
;	sasi_write_retrỹ[v
;		̓gC񐔂Ȃ̂ł̂܂
;	ύXO
;		00009798 3F3C0064         	move.w	#100,-(sp)
;----------------------------------------------------------------

;----------------------------------------------------------------
;	sasi_read_retrỹ[v
;		̓gC񐔂Ȃ̂ł̂܂
;	ύXO
;		0000983C 3F3C0064         	move.w	#100,-(sp)
;----------------------------------------------------------------

;----------------------------------------------------------------
;	sasi_preprocess̃[v
;		oXt[tF[Y҂Bv
;	ύXO
;		00009AA4 203C000000C8     	move.l	#201-1,d0
;----------------------------------------------------------------
	PATCH_DATA	p9AA4,$00FF9AA4+SASI_OFFSET,$00FF9AA4+5+SASI_OFFSET,$203C0000
	move.w	BIOS_MPU_SPEED_ROM.w,d0
	lsr.w	#2,d0			;(10*1000/12)/4=208

;----------------------------------------------------------------
;	sasi_do_select̃[v
;		oXt[tF[Y҂Bv
;	ύXO
;		00009B24 203C000007D0     		move.l	#2001-1,d0
;----------------------------------------------------------------
	PATCH_DATA	p9B24,$00FF9B24+SASI_OFFSET,$00FF9B24+5+SASI_OFFSET,$203C0000
	jsr	p9b24
	PATCH_TEXT
p9b24:
	move.w	BIOS_MPU_SPEED_ROM.w,d0
	mulu.w	#3,d0			;(10*1000/12)*3=2500
	rts
;----------------------------------------------------------------
;	ύXO
;		00009B34*51C8FFF4_00009B2A	dbra	~~forDn,~~redo68
;----------------------------------------------------------------
	PATCH_DATA	p9B34,$00FF9B34+SASI_OFFSET,$00FF9B34+3+SASI_OFFSET,$51C8FFF4
	subq.l	#1,d0
	bcc.s	(*)-$9B36+$9B2A

;----------------------------------------------------------------
;	sasi_do_select_10̃[v
;		BSYZbĝ҂Bv
;	ύXO
;		00009B64 203C00001388     	move.l	#5000,d0
;----------------------------------------------------------------
	PATCH_DATA	p9B64,$00FF9B64+SASI_OFFSET,$00FF9B64+5+SASI_OFFSET,$203C0000
	jsr	p9b64
	PATCH_TEXT
p9b64:
	move.w	BIOS_MPU_SPEED_ROM.w,d0
	mulu.w	#6,d0			;(10*1000/12)*6=5000
	rts

;----------------------------------------------------------------
;	sasi_stsin_msginsasi_wait_status̈
;		Xe[^XtF[YƃbZ[WtF[Y҂Bv
;	ύXO
;		00009B94 2A3C004C4B40     	move.l	#5000000,d5
;----------------------------------------------------------------
	PATCH_DATA	p9B94,$00FF9B94+SASI_OFFSET,$00FF9B94+5+SASI_OFFSET,$2A3C004C
	jsr	p9b94
	PATCH_TEXT
p9b94:
	move.w	BIOS_MPU_SPEED_ROM.w,d5
	mulu.w	#6000,d5		;(10*1000/12)*6000=5000000
	rts
;----------------------------------------------------------------
;	ύXO
;		00009BA8 2A3C0001E848     		move.l	#125000,d5
;----------------------------------------------------------------
	PATCH_DATA	p9BA8,$00FF9BA8+SASI_OFFSET,$00FF9BA8+5+SASI_OFFSET,$2A3C0001
	jsr	p9ba8
	PATCH_TEXT
p9ba8:
	move.w	BIOS_MPU_SPEED_ROM.w,d5
	mulu.w	#150,d5			;(10*1000/12)*150=125000
	rts

;----------------------------------------------------------------
;	sasi_receive_sensẽ[v
;		f[^CtF[Y҂Bv
;	ύXO
;		00009C3E 283C0003D090     		move.l	#250000,d4
;----------------------------------------------------------------
	PATCH_DATA	p9C3E,$00FF9C3E+SASI_OFFSET,$00FF9C3E+5+SASI_OFFSET,$283C0003
	jsr	p9c3e
	PATCH_TEXT
p9c3e:
	move.w	BIOS_MPU_SPEED_ROM.w,d4
	mulu.w	#300,d4			;(10*1000/12)*300=250000
	rts

;----------------------------------------------------------------
;	sasi_send_command̃[v
;		R}htF[Y҂Bv
;	ύXO
;		00009CC6 243C0003D090     		move.l	#250000,d2
;----------------------------------------------------------------
	PATCH_DATA	p9CC6,$00FF9CC6+SASI_OFFSET,$00FF9CC6+5+SASI_OFFSET,$243C0003
	jsr	p9cc6
	PATCH_TEXT
p9cc6:
	move.w	BIOS_MPU_SPEED_ROM.w,d2
	mulu.w	#300,d2			;(10*1000/12)*300=250000
	rts

;----------------------------------------------------------------
;	sasi_command_start̃[v
;		R}htF[Y҂Bŏ5oCgƍŌ1oCgBv
;	ύXO
;		00009D14 243C0003D090     		move.l	#250000,d2
;----------------------------------------------------------------
	PATCH_DATA	p9D14,$00FF9D14+SASI_OFFSET,$00FF9D14+5+SASI_OFFSET,$243C0003
	jsr	p9d14
	PATCH_TEXT
p9d14:
	move.w	BIOS_MPU_SPEED_ROM.w,d2
	mulu.w	#300,d2			;(10*1000/12)*300=250000
	rts
;----------------------------------------------------------------
;	ύXO
;		00009D40 243C0003D090     	move.l	#250000,d2
;----------------------------------------------------------------
	PATCH_DATA	p9D40,$00FF9D40+SASI_OFFSET,$00FF9D40+5+SASI_OFFSET,$243C0003
	jsr	p9d40
	PATCH_TEXT
p9d40:
	move.w	BIOS_MPU_SPEED_ROM.w,d2
	mulu.w	#300,d2			;(10*1000/12)*300=250000
;DMA]ÕLbVtbV
;	R}h̍Ō1oCg𑗐M钼OɃLbVtbVĂ
;	$00FF9E02̓]Jn̒OŎԂDMACŏ̊O]v\
	bra	cache_flush

;----------------------------------------------------------------
;	sasi_mpuout_10bytẽ[v
;		f[^AEgtF[Y҂Bv
;	ύXO
;		00009DA0 283C0003D090     		move.l	#250000,d4
;----------------------------------------------------------------
	PATCH_DATA	p9DA0,$00FF9DA0+SASI_OFFSET,$00FF9DA0+5+SASI_OFFSET,$283C0003
	jsr	p9da0
	PATCH_TEXT
p9da0:
	move.w	BIOS_MPU_SPEED_ROM.w,d4
	mulu.w	#300,d4			;(10*1000/12)*300=250000
	rts

;----------------------------------------------------------------
;	sasi_do_recalibratesasi_wait_status̈
;		Xe[^XtF[Y҂Bv
;	ύXO
;		00009D82 2A3C004C4B40     			move.l	#5000000,d5
;----------------------------------------------------------------
	PATCH_DATA	p9D82,$00FF9D82+SASI_OFFSET,$00FF9D82+5+SASI_OFFSET,$2A3C004C
	jsr	p9d82
	PATCH_TEXT
p9d82:
	move.w	BIOS_MPU_SPEED_ROM.w,d5
	mulu.w	#6000,d5		;(10*1000/12)*6000=5000000
	rts



;----------------------------------------------------------------
;	IOCS$4xHD̏
;		SCSI@̂ƂG[Ԃ
;			SCSI@̂ƂIOCS$4xHD̏͂ɗOɏIĂ
;		SASI@̂ƂSASI IOCSɃWv
;	ύXO
;		00008704 670009B2_000090B8        beq     scsi_40_B_SEEK          ;IOCSR[$40 _B_SEEK(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p8704,$00FF8704,$00FF8704+3,$670009B2
;	beq.w	(*)-$8704+$95B6+SASI_OFFSET	;sasi_40_B_SEEK
	PATCH_beq.w	pD580,pD580_40
;----------------------------------------------------------------
;	ύXO
;		0000874A 67000A9C_000091E8        beq     scsi_41_B_VERIFY        ;IOCSR[$41 _B_VERIFY(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p874A,$00FF874A,$00FF874A+3,$67000A9C
;	beq.w	(*)-$874A+$95DA+SASI_OFFSET	;sasi_41_B_VERIFY
	PATCH_beq.w	pD580,pD580_41
;----------------------------------------------------------------
;	ύXO
;		0000884C 67000A02_00009250        beq     scsi_43_B_DSKINI        ;IOCSR[$43 _B_DSKINI(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p884C,$00FF884C,$00FF884C+3,$67000A02
;	beq.w	(*)-$884C+$9640+SASI_OFFSET	;sasi_43_B_DSKINI
	PATCH_beq.w	pD580,pD580_43
;----------------------------------------------------------------
;	ύXO
;		00008890 67000844_000090D6        beq     scsi_44_B_DRVSNS        ;IOCSR[$44 _B_DRVSNS(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p8890,$00FF8890,$00FF8890+3,$67000844
;	beq.w	(*)-$8890+$9720+SASI_OFFSET	;sasi_44_B_DRVSNS
	PATCH_beq.w	pD580,pD580_44
;----------------------------------------------------------------
;	ύXO
;		000088D0 670008B0_00009182        beq     scsi_45_B_WRITE         ;IOCSR[$45 _B_WRITE(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p88D0,$00FF88D0,$00FF88D0+3,$670008B0
;	beq.w	(*)-$88D0+$9744+SASI_OFFSET	;sasi_45_B_WRITE
	PATCH_beq.w	pD580,pD580_45
;----------------------------------------------------------------
;	ύXO
;		00008950 6700082A_0000917C        beq     scsi_46_B_READ          ;IOCSR[$46 _B_READ(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p8950,$00FF8950,$00FF8950+3,$6700082A
;	beq.w	(*)-$8950+$97E8+SASI_OFFSET	;sasi_46_B_READ
	PATCH_beq.w	pD580,pD580_46
;----------------------------------------------------------------
;	ύXO
;		000089C6 670006F6_000090BE        beq     scsi_47_B_RECALI        ;IOCSR[$47 _B_RECALI(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p89C6,$00FF89C6,$00FF89C6+3,$670006F6
;	beq.w	(*)-$89C6+$988C+SASI_OFFSET	;sasi_47_B_RECALI
	PATCH_beq.w	pD580,pD580_47
;----------------------------------------------------------------
;	ύXO
;		00008A96 6700062C_000090C4        beq     scsi_48_B_ASSIGN        ;IOCSR[$48 _B_ASSIGN(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p8A96,$00FF8A96,$00FF8A96+3,$6700062C
;	beq.w	(*)-$8A96+$989E+SASI_OFFSET	;sasi_48_B_ASSIGN
	PATCH_beq.w	pD580,pD580_48
;----------------------------------------------------------------
;	ύXO
;		00008B2E 6700059A_000090CA        beq     scsi_4B_B_BADFMT        ;IOCSR[$4B _B_BADFMT(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p8B2E,$00FF8B2E,$00FF8B2E+3,$6700059A
;	beq.w	(*)-$8B2E+$98CE+SASI_OFFSET	;sasi_4B_B_BADFMT
	PATCH_beq.w	pD580,pD580_4B
;----------------------------------------------------------------
;	ύXO
;		00008B80 6700054E_000090D0        beq     scsi_4D_B_FORMAT        ;IOCSR[$4D _B_FORMAT(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p8B80,$00FF8B80,$00FF8B80+3,$6700054E
;	beq.w	(*)-$8B80+$98F6+SASI_OFFSET	;sasi_4D_B_FORMAT
	PATCH_beq.w	pD580,pD580_4D
;----------------------------------------------------------------
;	ύXO
;		00008D4C 670003C6_00009114        beq     scsi_4F_B_EJECT         ;IOCSR[$4F _B_EJECT(SCSI)
;----------------------------------------------------------------
	PATCH_DATA	p8D4C,$00FF8D4C,$00FF8D4C+3,$670003C6
;	beq.w	(*)-$8D4C+$99D0+SASI_OFFSET	;sasi_4F_B_EJECT
	PATCH_beq.w	pD580,pD580_4F
;----------------------------------------------------------------
;	ύXO
;		0000D580 102E0009         		move.b	SPC_INTS(aSPC),d0
;----------------------------------------------------------------
;	PATCH_DATA	pD580,$00FFD580,$00FFDCE3,$102E0009
	PATCH_DATA	pD580,$00FFD580,$00FFD67F,$102E0009
pD580_40:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF95B6+SASI_OFFSET)PATCH_ZL	;sasi_40_B_SEEK
pD580_41:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF95DA+SASI_OFFSET)PATCH_ZL	;sasi_41_B_VERIFY
pD580_43:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF9640+SASI_OFFSET)PATCH_ZL	;sasi_43_B_DSKINI
pD580_44:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF9720+SASI_OFFSET)PATCH_ZL	;sasi_44_B_DRVSNS
pD580_45:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF9744+SASI_OFFSET)PATCH_ZL	;sasi_45_B_WRITE
pD580_46:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF97E8+SASI_OFFSET)PATCH_ZL	;sasi_46_B_READ
pD580_47:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF988C+SASI_OFFSET)PATCH_ZL	;sasi_47_B_RECALI
pD580_48:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF989E+SASI_OFFSET)PATCH_ZL	;sasi_48_B_ASSIGN
pD580_4B:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF98CE+SASI_OFFSET)PATCH_ZL	;sasi_4B_B_BADFMT
pD580_4D:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF98F6+SASI_OFFSET)PATCH_ZL	;sasi_4D_B_FORMAT
pD580_4F:
	goto	<tst.b BIOS_BUILTIN_SCSI.w>,ne,pD580_error
	goto	($00FF99D0+SASI_OFFSET)PATCH_ZL	;sasi_4F_B_EJECT
pD580_error:
	moveq.l	#-1,d0
	rts



;----------------------------------------------------------------
;
;	pb`f[^̖
;
;----------------------------------------------------------------

	PATCH_END



	.end
