#ifndef __dpmi32_h__
#define __dpmi32_h__

/* cmd values for _bios_printer() */

#define _PRINTER_WRITE  0       /* send a byte to printer */
#define _PRINTER_INIT   1       /* initialize printer */
#define _PRINTER_STATUS 2       /* read printer status */

/* cmd values for _bios_serialcom() */

#define _COM_INIT       0       /* set communication parms to a byte */
#define _COM_SEND       1       /* send a byte to port */
#define _COM_RECEIVE    2       /* read character from port */
#define _COM_STATUS     3       /* get status of port */

/* byte values for _COM_INIT cmd of _bios_serialcom() */

#define _COM_CHR5       0x00    /* 5 data bits */
#define _COM_CHR6       0x01    /* 6 data bits */
#define _COM_CHR7       0x02    /* 7 data bits */
#define _COM_CHR8       0x03    /* 8 data bits */
#define _COM_STOP1      0x00    /* 1 stop bit */
#define _COM_STOP2      0x04    /* 2 stop bits */
#define _COM_NOPARITY   0x00    /* no parity */
#define _COM_EVENPARITY 0x18    /* even parity */
#define _COM_ODDPARITY  0x08    /* odd parity */
#define _COM_110        0x00    /* 110 baud */
#define _COM_150        0x20    /* 150 baud */
#define _COM_300        0x40    /* 300 baud */
#define _COM_600        0x60    /* 600 baud */
#define _COM_1200       0x80    /* 1200 baud */
#define _COM_2400       0xa0    /* 2400 baud */
#define _COM_4800       0xc0    /* 4800 baud */
#define _COM_9600       0xe0    /* 9600 baud */

//----------------------------------------------------------------------
struct DWORDREGS {
    unsigned int eax;
    unsigned int ebx;
    unsigned int ecx;
    unsigned int edx;
    unsigned int esi;
    unsigned int edi;
    unsigned int cflag;
    unsigned int flags;
};

#define __PADDING unsigned short : 16;

struct WORDREGS {
    unsigned short ax;    __PADDING
    unsigned short bx;    __PADDING
    unsigned short cx;    __PADDING
    unsigned short dx;    __PADDING
    unsigned short si;    __PADDING
    unsigned short di;    __PADDING
    unsigned short cflag; __PADDING
    unsigned short flags;
};

struct BYTEREGS {
    unsigned char al;
    unsigned char ah; __PADDING
    unsigned char bl;
    unsigned char bh; __PADDING
    unsigned char cl;
    unsigned char ch; __PADDING
    unsigned char dl;
    unsigned char dh; __PADDING
};

union REGS {
    struct  DWORDREGS x;
    struct  WORDREGS  w;
    struct  BYTEREGS  h;
};

//----------------------------------------------------------------------
struct DOSREGS  {
    unsigned long   edi;
    unsigned long   esi;
    unsigned long   ebp;
    unsigned long   reserved;
    unsigned long   ebx;
    unsigned long   edx;
    unsigned long   ecx;
    unsigned long   eax;
    unsigned short  flags;
    unsigned short  es;
    unsigned short  ds;
    unsigned short  fs;
    unsigned short  gs;
// do not use next fields
    unsigned short  ip16;
    unsigned short  cs16;
    unsigned short  sp16;
    unsigned short  ss16;
};

//----------------------------------------------------------------------
struct  COUNTRY
{
    short   co_date;
    char    co_curr[5];
    char    co_thsep[2];
    char    co_desep[2];
    char    co_dtsep[2];
    char    co_tmsep[2];
    char    co_currstyle;
    char    co_digits;
    char    co_time;
    long    co_case;
    char    co_dasep[2];
    char    co_fill[10];
};

#if defined(__MSC) && !defined(__cplusplus)
struct  DOSERROR
{
        int     exterror;
        char    class;
        char    action;
        char    locus;
};
#else
struct  DOSERROR
{
        int     de_exterror;
        char    de_class;
        char    de_action;
        char    de_locus;
};
#endif  /* __MSC and not C++ */

//----------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif
// data maniulation
int           __cdecl peek(unsigned __segment, unsigned __offset);
char          __cdecl peekb(unsigned __segment, unsigned __offset);
void          __cdecl poke(unsigned __segment, unsigned __offset, int __value);
void          __cdecl pokeb(unsigned __segment, unsigned __offset, char __value);
void          __cdecl movedata(unsigned __srcseg, unsigned __srcoff,
                               unsigned __dstseg, unsigned __dstoff, size_t __n);
// IO
unsigned      __cdecl inport(unsigned __portid);  // read word
unsigned char __cdecl inportb(unsigned __portid); // read byte
unsigned      __cdecl inportd(unsigned __portid); // read dword
unsigned      __cdecl inpd(unsigned __portid);    // alias to inportd
unsigned      __cdecl inpw(unsigned __portid);    // alias to inport
int           __cdecl inp(unsigned __portid);     // alias to inportb
unsigned      __cdecl outpw(unsigned __portid, unsigned __value); // write word
unsigned      __cdecl outp(unsigned __portid, int __value);       // write byte
unsigned      __cdecl outpd(unsigned __portid, unsigned __value); // write dword
void          __cdecl outportw(unsigned __portid, unsigned __value); // alias to outpw
void          __cdecl outport(unsigned __portid, unsigned __value);  // alias to outp
void          __cdecl outportd(unsigned __portid, unsigned __value); // alias to outpd
//dos-access
struct COUNTRY *  __cdecl country(int __xcode, struct COUNTRY *__cp);
int           __cdecl dosexterr(struct DOSERROR *__eblkp);
// disk control's
int           __cdecl getverify(void);    // != 0 if ON, == 0 if OFF
void          __cdecl setverify(int __value);
// dos memory (for sim_int)
int           __cdecl dos_alloc(size_t __n, int *__dos_seg, int *__sel32);
int           __cdecl dos_free(int __sel32);
// interrupt
int           __cdecl int_386(int __intno, union REGS *__intregs,
int           __cdecl sim_int(int __intno, struct DOSREGS *__regs);
// dos-printer/dos-comm
unsigned      __cdecl _bios_printer(unsigned __cmd, unsigned __port, unsigned __abyte);
#define biosprint(__cmd, __abyte, __port)  _bios_printer(__cmd, __port, __abyte)
unsigned      __cdecl _bios_serialcom(unsigned __cmd, unsigned __port, unsigned __abyte);
#define bioscom(__cmd, __abyte, __port)  _bios_printer(__cmd, __port, __abyte)
// std-wrappers
void          __cdecl delay(unsigned __milliseconds);  // wrapper of Sleep
int           __cdecl getcbrk(void);            // ENABLE_PROCESSED_INPUT
int           __cdecl setcbrk(int __cbrkvalue); // -"-
void          __cdecl ctrlbrk(int __cdecl (*handler)(void));  // SetConsoleCtrlHandler + _exit

#ifdef __cplusplus
};
#endif

//----------------------------------------------------------------------
#endif // __dpmi32_h__
