/*
 * Decompiled with CFR 0.152.
 */
package com.jhe.hexed;

import com.jhe.hexed.JHexEditorASCII;
import com.jhe.hexed.JHexEditorHEX;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JHexEditor
extends JPanel
implements FocusListener,
AdjustmentListener,
MouseWheelListener {
    int[] buff;
    public int cursor;
    protected static Font font = new Font("Monospaced", 0, 12);
    protected int border = 2;
    public boolean DEBUG = false;
    private JPanel panel;
    private JScrollBar sb;
    private int inicio = 0;
    private int lineas = 24;

    public JHexEditor(int[] nArray, int n) {
        this.buff = nArray;
        this.cursor = n;
        this.addMouseWheelListener(this);
        this.sb = new JScrollBar(1);
        this.sb.addAdjustmentListener(this);
        this.sb.setMinimum(0);
        this.sb.setMaximum(nArray.length / this.getLineas());
        JPanel jPanel = new JPanel(new BorderLayout(1, 1));
        jPanel.add((Component)new JHexEditorHEX(this), "Center");
        jPanel.add((Component)new Columnas(), "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(1, 1));
        jPanel2.add((Component)new Filas(), "Center");
        jPanel2.add((Component)new Caja(), "North");
        JPanel jPanel3 = new JPanel(new BorderLayout(1, 1));
        jPanel3.add((Component)this.sb, "East");
        jPanel3.add((Component)new JHexEditorASCII(this), "Center");
        jPanel3.add((Component)new Caja(), "North");
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(1, 1));
        this.panel.add((Component)jPanel, "Center");
        this.panel.add((Component)jPanel2, "West");
        this.panel.add((Component)jPanel3, "East");
        this.setLayout(new BorderLayout(1, 1));
        this.add((Component)this.panel, "Center");
        this.actualizaCursor();
    }

    @Override
    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Rectangle rectangle = this.getBounds();
        this.lineas = rectangle.height / fontMetrics.getHeight() - 1;
        int n = this.buff.length / 16 - 1;
        if (this.lineas > n) {
            this.lineas = n;
            this.inicio = 0;
        }
        this.sb.setValues(this.getInicio(), this.getLineas(), 0, this.buff.length / 16);
        this.sb.setValueIsAdjusting(true);
        super.paint(graphics);
    }

    protected void actualizaCursor() {
        int n = this.cursor / 16;
        if (n < this.inicio) {
            this.inicio = n;
        } else if (n >= this.inicio + this.lineas) {
            this.inicio = n - (this.lineas - 1);
        }
        this.repaint();
    }

    protected int getInicio() {
        return this.inicio;
    }

    protected int getLineas() {
        return this.lineas;
    }

    protected void fondo(Graphics graphics, int n, int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.fillRect((fontMetrics.stringWidth(" ") + 1) * n + this.border, fontMetrics.getHeight() * n2 + this.border, (fontMetrics.stringWidth(" ") + 1) * n3, fontMetrics.getHeight() + 1);
    }

    protected void cuadro(Graphics graphics, int n, int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.drawRect((fontMetrics.stringWidth(" ") + 1) * n + this.border, fontMetrics.getHeight() * n2 + this.border, (fontMetrics.stringWidth(" ") + 1) * n3, fontMetrics.getHeight() + 1);
    }

    protected void printString(Graphics graphics, String string, int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.drawString(string, (fontMetrics.stringWidth(" ") + 1) * n + this.border, fontMetrics.getHeight() * (n2 + 1) - fontMetrics.getMaxDescent() + this.border);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.inicio = adjustmentEvent.getValue();
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.inicio += mouseWheelEvent.getUnitsToScroll();
        if (this.inicio + this.lineas >= this.buff.length / 16) {
            this.inicio = this.buff.length / 16 - this.lineas;
        }
        if (this.inicio < 0) {
            this.inicio = 0;
        }
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: {
                if (this.cursor >= 16 * this.lineas) {
                    this.cursor -= 16 * this.lineas;
                }
                this.actualizaCursor();
                break;
            }
            case 34: {
                if (this.cursor < this.buff.length - 16 * this.lineas) {
                    this.cursor += 16 * this.lineas;
                }
                this.actualizaCursor();
                break;
            }
            case 35: {
                this.cursor = this.buff.length - 1;
                this.actualizaCursor();
                break;
            }
            case 36: {
                this.cursor = 0;
                this.actualizaCursor();
                break;
            }
            case 37: {
                if (this.cursor != 0) {
                    --this.cursor;
                }
                this.actualizaCursor();
                break;
            }
            case 38: {
                if (this.cursor > 15) {
                    this.cursor -= 16;
                }
                this.actualizaCursor();
                break;
            }
            case 39: {
                if (this.cursor != this.buff.length - 1) {
                    ++this.cursor;
                }
                this.actualizaCursor();
                break;
            }
            case 40: {
                if (this.cursor < this.buff.length - 16) {
                    this.cursor += 16;
                }
                this.actualizaCursor();
                break;
            }
            case 32: 
            case 116: {
                this.actualizaCursor();
            }
        }
    }

    private class Caja
    extends JPanel {
        private Caja() {
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            dimension.setSize(fontMetrics.stringWidth(" ") + 1 + JHexEditor.this.border * 2 + 1, n + JHexEditor.this.border * 2 + 1);
            return dimension;
        }
    }

    private class Columnas
    extends JPanel {
        public Columnas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            int n2 = 1;
            dimension.setSize((fontMetrics.stringWidth(" ") + 1) * 47 + JHexEditor.this.border * 2 + 1, n * n2 + JHexEditor.this.border * 2 + 1);
            return dimension;
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getMinimumSize();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
            graphics.setFont(font);
            int n = 0;
            while (n < 16) {
                if (n == JHexEditor.this.cursor % 16) {
                    JHexEditor.this.cuadro(graphics, n * 3, 0, 2);
                }
                String string = "00" + Integer.toHexString(n);
                string = string.substring(string.length() - 2);
                JHexEditor.this.printString(graphics, string, n * 3, 0);
                ++n;
            }
        }
    }

    private class Filas
    extends JPanel {
        public Filas() {
            this.setLayout(new BorderLayout(1, 1));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = new Dimension();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            int n2 = JHexEditor.this.getLineas();
            dimension.setSize((fontMetrics.stringWidth(" ") + 1) * 8 + JHexEditor.this.border * 2 + 1, n * n2 + JHexEditor.this.border * 2 + 1);
            return dimension;
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getMinimumSize();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
            graphics.setFont(font);
            int n = JHexEditor.this.getInicio();
            int n2 = n + JHexEditor.this.getLineas();
            int n3 = 0;
            int n4 = n;
            while (n4 < n2) {
                if (n4 == JHexEditor.this.cursor / 16) {
                    JHexEditor.this.cuadro(graphics, 0, n3, 8);
                }
                String string = "0000000000000" + Integer.toHexString(n4 * 16);
                string = string.substring(string.length() - 8);
                JHexEditor.this.printString(graphics, string, 0, n3++);
                ++n4;
            }
        }
    }
}

