/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Breakpoints;
import com.jira.cambridgez88.ozvm.DebugGui;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.OZvm;
import com.jira.cambridgez88.ozvm.SaveRestoreVM;
import com.jira.cambridgez88.ozvm.StringEval;
import com.jira.cambridgez88.ozvm.Watchpoints;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.Z88Info;
import com.jira.cambridgez88.ozvm.datastructures.ApplicationDor;
import com.jira.cambridgez88.ozvm.datastructures.ApplicationInfo;
import com.jira.cambridgez88.ozvm.filecard.FileArea;
import com.jira.cambridgez88.ozvm.filecard.FileAreaExhaustedException;
import com.jira.cambridgez88.ozvm.filecard.FileAreaNotFoundException;
import com.jira.cambridgez88.ozvm.filecard.FileEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CommandLine {
    private static final String illegalArgumentMessage = "Illegal Argument";
    private boolean logZ80instructions;
    private Blink blink = Z88.getInstance().getBlink();
    private Z80Processor z80 = Z88.getInstance().getProcessor();
    private Dz dz;
    private Breakpoints breakPointManager;
    private Watchpoints watchpointManager;
    private Memory memory = Z88.getInstance().getMemory();

    public static CommandLine getInstance() {
        return singletonContainer.singleton;
    }

    private CommandLine() {
        this.dz = Dz.getInstance();
        this.breakPointManager = this.z80.getBreakpoints();
        this.watchpointManager = this.z80.getWatchpoints();
        this.displayCmdOutput("Type 'help' + ENTER for available debugging commands");
        this.displayCmdOutput("Type 'run' + ENTER to continue executing Z88");
    }

    private void displayCmdOutput(String string) {
        JTextArea jTextArea = DebugGui.getInstance().getCmdlineOutputArea();
        jTextArea.append(String.valueOf(string) + "\n");
    }

    private void cmdHelp() {
        this.displayCmdOutput("Launching browser to display command line reference.");
        OZvm.getInstance().getGui().launchBrowserUrl("https://cambridgez88.jira.com/wiki/x/6oB5");
    }

    /*
     * WARNING - void declaration
     */
    public void parseCommandLine(String string) {
        int n;
        Object object;
        Object object2;
        String[] stringArray;
        JTextField jTextField;
        block347: {
            String string2;
            jTextField = DebugGui.getInstance().getCmdLineInputArea();
            string = string.replaceAll("[(]", " ( ");
            string = string.replaceAll("[)]", " ) ");
            stringArray = (string = string.replaceAll("[;]", " ; ")).split(" ");
            if (stringArray[0].compareToIgnoreCase("help") == 0) {
                this.cmdHelp();
            }
            if (stringArray[0].compareToIgnoreCase("savevm") == 0) {
                object2 = new SaveRestoreVM();
                string2 = OZvm.defaultVmFile;
                if (stringArray.length > 1 && (string2 = stringArray[1]).toLowerCase().lastIndexOf(".z88") == -1) {
                    string2 = String.valueOf(string2) + ".z88";
                }
                try {
                    if (Z88.getInstance().getProcessorThread() == null) {
                        ((SaveRestoreVM)object2).storeSnapShot(string2, false);
                        this.displayCmdOutput("Snapshot successfully saved to " + string2);
                    } else {
                        this.displayCmdOutput("Snapshot can only be saved when Z88 is not running.");
                    }
                }
                catch (IOException iOException) {
                    this.displayCmdOutput("Saving snapshot failed.");
                }
            }
            if (stringArray[0].compareToIgnoreCase("loadvm") == 0) {
                object2 = new SaveRestoreVM();
                string2 = OZvm.defaultVmFile;
                if (stringArray.length > 1 && (string2 = stringArray[1]).toLowerCase().lastIndexOf(".z88") == -1) {
                    string2 = String.valueOf(string2) + ".z88";
                }
                if (Z88.getInstance().getProcessorThread() == null) {
                    try {
                        boolean n2 = ((SaveRestoreVM)object2).loadSnapShot(string2);
                        this.displayCmdOutput("Snapshot successfully installed from " + string2);
                        if (n2) {
                            Z88.getInstance().runZ80Cpu();
                            Z88.getInstance().getDisplay().grabFocus();
                            break block347;
                        }
                        this.cmdlineFirstSingleStep();
                    }
                    catch (IOException iOException) {
                        this.displayCmdOutput("Installation of snapshot failed. Z88 preset to default system.");
                        this.memory.setDefaultSystem();
                        this.z80.reset();
                        this.blink.resetBlinkRegisters();
                    }
                } else {
                    this.displayCmdOutput("Snapshot can only be installed when Z88 is not running.");
                }
            }
        }
        if (stringArray[0].compareToIgnoreCase("cls") == 0) {
            DebugGui.getInstance().clearCmdOutputArea();
        }
        if (stringArray[0].compareToIgnoreCase("apps") == 0) {
            object2 = new ApplicationInfo();
            int n3 = 0;
            while (n3 < 4) {
                ListIterator listIterator = ((ApplicationInfo)object2).getApplications(n3);
                if (listIterator != null) {
                    this.displayCmdOutput("Slot " + n3 + ":");
                    while (listIterator.hasNext()) {
                        object = (ApplicationDor)listIterator.next();
                        this.displayCmdOutput(String.valueOf(((ApplicationDor)object).getAppName()) + ": DOR = " + Dz.extAddrToHex(((ApplicationDor)object).getThisApp(), true) + ", Entry = " + Dz.extAddrToHex(((ApplicationDor)object).getEntryPoint(), true));
                    }
                }
                ++n3;
            }
        }
        if (stringArray[0].compareToIgnoreCase("app") == 0) {
            object2 = new ApplicationInfo();
            int n4 = 0;
            while (n4 < 4) {
                ListIterator listIterator = ((ApplicationInfo)object2).getApplications(n4);
                if (listIterator != null) {
                    while (listIterator.hasNext()) {
                        object = (ApplicationDor)listIterator.next();
                        if (((ApplicationDor)object).getAppName().compareTo(stringArray[1]) != 0) continue;
                        this.displayCmdOutput("DOR information, " + ((ApplicationDor)object).getAppName() + " ( []" + ((ApplicationDor)object).getKeyLetter() + " ) :");
                        this.displayCmdOutput("DOR pointer: " + Dz.extAddrToHex(((ApplicationDor)object).getThisApp(), true));
                        this.displayCmdOutput("Execution Entry: " + Dz.extAddrToHex(((ApplicationDor)object).getEntryPoint(), true) + ", bindings: " + "S0=" + Dz.byteToHex(((ApplicationDor)object).getSegment0BankBinding(), true) + ", " + "S1=" + Dz.byteToHex(((ApplicationDor)object).getSegment1BankBinding(), true) + ", " + "S2=" + Dz.byteToHex(((ApplicationDor)object).getSegment2BankBinding(), true) + ", " + "S3=" + Dz.byteToHex(((ApplicationDor)object).getSegment3BankBinding(), true));
                        this.displayCmdOutput("Mth: Topics=" + Dz.extAddrToHex(((ApplicationDor)object).getTopics(), true) + ", " + "Commands=" + Dz.extAddrToHex(((ApplicationDor)object).getCommands(), true) + ", " + "Help=" + Dz.extAddrToHex(((ApplicationDor)object).getHelp(), true) + ", " + "Tokens=" + Dz.extAddrToHex(((ApplicationDor)object).getTokens(), true));
                    }
                }
                ++n4;
            }
        }
        if (stringArray[0].compareToIgnoreCase("run") == 0 | stringArray[0].compareToIgnoreCase("x") == 0) {
            if (Z88.getInstance().getProcessorThread() == null) {
                this.z80.singleStepZ80();
            }
            if (!Z88.getInstance().runZ80Cpu()) {
                this.displayCmdOutput("Z88 is already running.");
            } else {
                DebugGui.getInstance().lockZ88MachinePanel(false);
                OZvm.getInstance().getGui().toFront();
                Z88.getInstance().getDisplay().grabFocus();
            }
        }
        if (stringArray[0].compareToIgnoreCase("stop") == 0) {
            if (Z88.getInstance().getProcessor().isZ80ThreadRunning()) {
                Z88.getInstance().getProcessor().stopZ80Execution();
                Z88.getInstance().getBlink().awakeZ80();
                DebugGui.getInstance().activateDebugCommandLine();
                CommandLine.getInstance().cmdlineFirstSingleStep();
                DebugGui.getInstance().lockZ88MachinePanel(true);
            } else {
                this.displayCmdOutput("Z88 is already stopped.");
            }
        }
        if (stringArray[0].compareToIgnoreCase("quitvm") == 0) {
            System.exit(0);
        }
        if (stringArray[0].compareToIgnoreCase("di") == 0) {
            if (Z88.getInstance().getProcessorThread() != null) {
                this.displayCmdOutput("Interrupt state cannot be edited while Z88 is running.");
                return;
            }
            this.z80.IFF1(false);
            this.z80.IFF2(false);
            this.displayCmdOutput("Maskable interrupts disabled.");
        }
        if (stringArray[0].compareToIgnoreCase("ei") == 0) {
            if (Z88.getInstance().getProcessorThread() != null) {
                this.displayCmdOutput("Interrupt state cannot be edited while Z88 is running.");
                return;
            }
            this.z80.IFF1(true);
            this.z80.IFF2(true);
            this.displayCmdOutput("Maskable interrupts enabled.");
        }
        if (stringArray[0].compareToIgnoreCase("log") == 0) {
            if (this.z80.izZ80Logged()) {
                this.logZ80instructions = false;
                this.z80.setZ80Logging(this.logZ80instructions);
                this.z80.flushZ80LogCache();
                this.displayCmdOutput("Z80 Instruction logging disabled.");
            } else {
                this.logZ80instructions = true;
                this.z80.setZ80Logging(this.logZ80instructions);
                this.displayCmdOutput("Z80 Instruction logging enabled.");
            }
        }
        if (stringArray[0].compareTo(".") == 0) {
            if (Z88.getInstance().getProcessorThread() != null) {
                this.displayCmdOutput("Z88 is running - single stepping ignored.");
                return;
            }
            this.z80.singleStepZ80();
            DebugGui.getInstance().refreshZ88HardwareInfo();
            this.displayCmdOutput(Z88Info.dzPcStatus(this.z80.PC()));
            jTextField.setText(Dz.getNextStepCommand());
            jTextField.setCaretPosition(jTextField.getDocument().getLength());
            jTextField.selectAll();
        }
        if (stringArray[0].compareToIgnoreCase("z") == 0) {
            if (Z88.getInstance().getProcessorThread() != null) {
                this.displayCmdOutput("Z88 is running - subroutine execution ignored.");
                return;
            }
            if (Dz.getNextStepCommand().compareTo("z") == 0) {
                int n5 = this.blink.decodeLocalAddress(this.dz.getNextInstrAddress(this.z80.PC()));
                this.z80.singleStepZ80();
                if (this.breakPointManager.isCreated(n5)) {
                    Z88.getInstance().runZ80Cpu();
                } else {
                    Z88.getInstance().runZ80Cpu(n5);
                }
            } else {
                this.z80.singleStepZ80();
                DebugGui.getInstance().refreshZ88HardwareInfo();
                jTextField.setText(Dz.getNextStepCommand());
                jTextField.setCaretPosition(jTextField.getDocument().getLength());
                jTextField.selectAll();
                this.displayCmdOutput(Z88Info.dzPcStatus(this.z80.PC()));
            }
        }
        if (stringArray[0].compareToIgnoreCase("fcd1") == 0 | stringArray[0].compareToIgnoreCase("fcd2") == 0 | stringArray[0].compareToIgnoreCase("fcd3") == 0) {
            this.fcdCommandline(stringArray);
        }
        if (stringArray[0].compareToIgnoreCase("dz") == 0) {
            this.dzCommandline(stringArray);
            this.displayCmdOutput("");
        }
        if (stringArray[0].compareToIgnoreCase("m") == 0) {
            this.viewMemory(stringArray);
            this.displayCmdOutput("");
        }
        if (stringArray[0].compareToIgnoreCase("bl") == 0) {
            this.displayCmdOutput(Z88Info.blinkRegisterDump());
        }
        if (stringArray[0].compareToIgnoreCase("sr") == 0) {
            this.displayCmdOutput(String.valueOf(Z88Info.bankBindingInfo()) + "\n");
            this.displayCmdOutput("");
        }
        if (stringArray[0].compareToIgnoreCase("rg") == 0) {
            this.displayCmdOutput("\n" + Z88Info.z80RegisterInfo());
            this.displayCmdOutput("");
        }
        if (stringArray[0].compareToIgnoreCase("boz") == 0) {
            this.breakPointManager.toggleBreakOzCall();
            this.displayCmdOutput("Break at OZ CALL: " + Boolean.toString(this.breakPointManager.isBreakOzCallActive()));
        }
        if (stringArray[0].compareToIgnoreCase("bozd") == 0) {
            this.breakPointManager.toggleDisplayOzCall();
            this.displayCmdOutput("Display OZ CALL: " + Boolean.toString(this.breakPointManager.isDisplayOzCallActive()));
        }
        if (stringArray[0].compareToIgnoreCase("bp") == 0) {
            try {
                this.bpCommandline(stringArray);
                this.displayCmdOutput("");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (stringArray[0].compareToIgnoreCase("bpcl") == 0) {
            this.breakPointManager.clearBreakpoints();
            this.breakPointManager.removeBreakPoints();
            this.displayCmdOutput("All breakpoints cleared.");
        }
        if (stringArray[0].compareToIgnoreCase("bpd") == 0) {
            try {
                this.bpdCommandline(stringArray);
                this.displayCmdOutput("");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (stringArray[0].compareToIgnoreCase("wp") == 0) {
            try {
                WatchpointCmdArguments watchpointCmdArguments = this.wpCommandline(stringArray);
                switch (watchpointCmdArguments.argc) {
                    case 1: {
                        this.watchpointManager.toggleWatchpoint(watchpointCmdArguments.addrStart);
                        break;
                    }
                    case 2: {
                        if (watchpointCmdArguments.wpCmds == null) {
                            int n6 = watchpointCmdArguments.addrStart;
                            while (n6 <= watchpointCmdArguments.addrEnd) {
                                this.watchpointManager.toggleWatchpoint(n6);
                                ++n6;
                            }
                            break;
                        }
                        this.watchpointManager.toggleWatchpoint(watchpointCmdArguments.addrStart, watchpointCmdArguments.wpCmds);
                        break;
                    }
                    case 3: {
                        int n7 = watchpointCmdArguments.addrStart;
                        while (n7 <= watchpointCmdArguments.addrEnd) {
                            this.watchpointManager.toggleWatchpoint(n7, watchpointCmdArguments.wpCmds);
                            ++n7;
                        }
                        break block13;
                    }
                }
            }
            catch (IOException iOException) {}
            this.displayCmdOutput(this.watchpointManager.displayWatchpoints());
        }
        if (stringArray[0].compareToIgnoreCase("wpd") == 0) {
            try {
                WatchpointCmdArguments watchpointCmdArguments = this.wpCommandline(stringArray);
                switch (watchpointCmdArguments.argc) {
                    case 1: {
                        this.watchpointManager.toggleWatchpoint(watchpointCmdArguments.addrStart, false);
                        break;
                    }
                    case 2: {
                        if (watchpointCmdArguments.wpCmds == null) {
                            int n8 = watchpointCmdArguments.addrStart;
                            while (n8 <= watchpointCmdArguments.addrEnd) {
                                this.watchpointManager.toggleWatchpoint(n8, false);
                                ++n8;
                            }
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {}
            this.displayCmdOutput(this.watchpointManager.displayWatchpoints());
        }
        if (stringArray[0].compareToIgnoreCase("wrp") == 0) {
            try {
                WatchpointCmdArguments watchpointCmdArguments = this.wpCommandline(stringArray);
                switch (watchpointCmdArguments.argc) {
                    case 1: {
                        this.watchpointManager.toggleReadWatchpoint(watchpointCmdArguments.addrStart);
                        break;
                    }
                    case 2: {
                        if (watchpointCmdArguments.wpCmds == null) {
                            int n9 = watchpointCmdArguments.addrStart;
                            while (n9 <= watchpointCmdArguments.addrEnd) {
                                this.watchpointManager.toggleReadWatchpoint(n9);
                                ++n9;
                            }
                            break;
                        }
                        this.watchpointManager.toggleReadWatchpoint(watchpointCmdArguments.addrStart, watchpointCmdArguments.wpCmds);
                        break;
                    }
                    case 3: {
                        int n10 = watchpointCmdArguments.addrStart;
                        while (n10 <= watchpointCmdArguments.addrEnd) {
                            this.watchpointManager.toggleReadWatchpoint(n10, watchpointCmdArguments.wpCmds);
                            ++n10;
                        }
                        break block22;
                    }
                }
            }
            catch (IOException iOException) {}
            this.displayCmdOutput(this.watchpointManager.displayWatchpoints());
        }
        if (stringArray[0].compareToIgnoreCase("wrpd") == 0) {
            try {
                WatchpointCmdArguments watchpointCmdArguments = this.wpCommandline(stringArray);
                switch (watchpointCmdArguments.argc) {
                    case 1: {
                        this.watchpointManager.toggleReadWatchpoint(watchpointCmdArguments.addrStart, false);
                        break;
                    }
                    case 2: {
                        if (watchpointCmdArguments.wpCmds == null) {
                            int n11 = watchpointCmdArguments.addrStart;
                            while (n11 <= watchpointCmdArguments.addrEnd) {
                                this.watchpointManager.toggleReadWatchpoint(n11, false);
                                ++n11;
                            }
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {}
            this.displayCmdOutput(this.watchpointManager.displayWatchpoints());
        }
        if (stringArray[0].compareToIgnoreCase("wwp") == 0) {
            try {
                WatchpointCmdArguments watchpointCmdArguments = this.wpCommandline(stringArray);
                switch (watchpointCmdArguments.argc) {
                    case 1: {
                        this.watchpointManager.toggleWriteWatchpoint(watchpointCmdArguments.addrStart);
                        break;
                    }
                    case 2: {
                        if (watchpointCmdArguments.wpCmds == null) {
                            int n12 = watchpointCmdArguments.addrStart;
                            while (n12 <= watchpointCmdArguments.addrEnd) {
                                this.watchpointManager.toggleWriteWatchpoint(n12);
                                ++n12;
                            }
                            break;
                        }
                        this.watchpointManager.toggleWriteWatchpoint(watchpointCmdArguments.addrStart, watchpointCmdArguments.wpCmds);
                        break;
                    }
                    case 3: {
                        int n13 = watchpointCmdArguments.addrStart;
                        while (n13 <= watchpointCmdArguments.addrEnd) {
                            this.watchpointManager.toggleWriteWatchpoint(n13, watchpointCmdArguments.wpCmds);
                            ++n13;
                        }
                        break block31;
                    }
                }
            }
            catch (IOException iOException) {}
            this.displayCmdOutput(this.watchpointManager.displayWatchpoints());
        }
        if (stringArray[0].compareToIgnoreCase("wwpd") == 0) {
            try {
                WatchpointCmdArguments watchpointCmdArguments = this.wpCommandline(stringArray);
                switch (watchpointCmdArguments.argc) {
                    case 1: {
                        this.watchpointManager.toggleWriteWatchpoint(watchpointCmdArguments.addrStart, false);
                        break;
                    }
                    case 2: {
                        if (watchpointCmdArguments.wpCmds == null) {
                            int n14 = watchpointCmdArguments.addrStart;
                            while (n14 <= watchpointCmdArguments.addrEnd) {
                                this.watchpointManager.toggleWriteWatchpoint(n14, false);
                                ++n14;
                            }
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {}
            this.displayCmdOutput(this.watchpointManager.displayWatchpoints());
        }
        if (stringArray[0].compareToIgnoreCase("wpcl") == 0) {
            this.watchpointManager.clearWatchpoints();
            this.watchpointManager.removeWatchpoints();
            this.displayCmdOutput("All watchpoints cleared.");
        }
        if (stringArray[0].compareToIgnoreCase("wb") == 0) {
            try {
                this.putByte(stringArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (stringArray[0].compareToIgnoreCase("ldc") == 0) {
            try {
                int n15 = Integer.parseInt(stringArray[2], 16);
                int n16 = n15 >>> 16 & 0xFF;
                int string3 = n15 & 0x3FFF;
                object = this.memory.getBank(n16);
                this.memory.loadBankBinary((Bank)object, string3, new File(stringArray[1]));
                this.displayCmdOutput("File image '" + stringArray[1] + "' loaded at " + stringArray[2] + ".");
            }
            catch (IOException iOException) {
                this.displayCmdOutput("Couldn't load file image at ext.address: '" + iOException.getMessage() + "'");
            }
            this.displayCmdOutput("");
        }
        if (stringArray[0].compareToIgnoreCase("dumpslot") == 0) {
            boolean bl = false;
            int n17 = Integer.parseInt(stringArray[1]);
            String string2 = "slot" + stringArray[1] + ".epr";
            object = System.getProperty("user.home");
            if (n17 > 0) {
                if (stringArray.length != 2) {
                    if (stringArray.length == 3) {
                        if (stringArray[2].compareToIgnoreCase("-b") == 0) {
                            String string3 = "slot" + stringArray[1] + "bank";
                            bl = true;
                        } else {
                            String string4 = stringArray[2];
                        }
                    } else if (stringArray.length == 4) {
                        File file;
                        if (stringArray[2].compareToIgnoreCase("-b") == 0) {
                            bl = true;
                        }
                        if ((file = new File(stringArray[3])).isDirectory()) {
                            object = file.getAbsolutePath();
                            String string5 = "slot" + stringArray[1] + "bank";
                        } else {
                            if (file.getParent() != null) {
                                object = new File(file.getParent()).getAbsolutePath();
                            }
                            String string6 = file.getName();
                        }
                    }
                }
                if (!this.memory.isSlotEmpty(n17)) {
                    try {
                        void var7_41;
                        this.memory.dumpSlot(n17, bl, (String)object, (String)var7_41);
                        this.displayCmdOutput("Slot was dumped successfully to " + (String)object);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.displayCmdOutput("Couldn't create file(s)!");
                    }
                    catch (IOException iOException) {
                        this.displayCmdOutput("I/O error while dumping slot!");
                    }
                } else {
                    this.displayCmdOutput("Slot is empty!");
                }
            }
        }
        if (stringArray[0].compareToIgnoreCase("com") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setCom(n);
            }
            this.displayCmdOutput(Z88Info.blinkComInfo());
        }
        if (stringArray[0].compareToIgnoreCase("int") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setInt(n);
            }
            this.displayCmdOutput(Z88Info.blinkIntInfo());
        }
        if (stringArray[0].compareToIgnoreCase("sta") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setSta(n);
            }
            this.displayCmdOutput(Z88Info.blinkStaInfo());
        }
        if (stringArray[0].compareToIgnoreCase("kbd") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                Z88.getInstance().getKeyboard().setKeyRow(n >>> 8, n & 0xFF);
            }
            this.displayCmdOutput(Z88.getInstance().getKeyboard().getKbdMatrixSymbolically());
        }
        if (stringArray[0].compareToIgnoreCase("ack") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setAck(n);
            }
            this.displayCmdOutput(Z88Info.blinkStaInfo());
        }
        stringArray[0].compareToIgnoreCase("epr");
        if (stringArray[0].compareToIgnoreCase("tsta") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setTsta(n);
            }
            this.displayCmdOutput(Z88Info.blinkTstaInfo());
        }
        if (stringArray[0].compareToIgnoreCase("tack") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setTack(n);
            }
            this.displayCmdOutput(Z88Info.blinkTstaInfo());
        }
        if (stringArray[0].compareToIgnoreCase("tmk") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setTmk(n);
            }
            this.displayCmdOutput(Z88Info.blinkTmkInfo());
        }
        if (stringArray[0].compareToIgnoreCase("pb0") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setPb0(n);
            }
            this.displayCmdOutput(Z88Info.blinkScreenInfo());
        }
        if (stringArray[0].compareToIgnoreCase("pb1") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setPb1(n);
            }
            this.displayCmdOutput(Z88Info.blinkScreenInfo());
        }
        if (stringArray[0].compareToIgnoreCase("pb2") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setPb2(n);
            }
            this.displayCmdOutput(Z88Info.blinkScreenInfo());
        }
        if (stringArray[0].compareToIgnoreCase("pb3") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setPb3(n);
            }
            this.displayCmdOutput(Z88Info.blinkScreenInfo());
        }
        if (stringArray[0].compareToIgnoreCase("sbr") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setSbr(n);
            }
            this.displayCmdOutput(Z88Info.blinkScreenInfo());
        }
        if (stringArray[0].compareToIgnoreCase("sr0") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setSegmentBank(0, n);
            }
            this.displayCmdOutput(Z88Info.blinkSegmentsInfo());
        }
        if (stringArray[0].compareToIgnoreCase("sr1") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setSegmentBank(1, n);
            }
            this.displayCmdOutput(Z88Info.blinkSegmentsInfo());
        }
        if (stringArray[0].compareToIgnoreCase("sr2") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setSegmentBank(2, n);
            }
            this.displayCmdOutput(Z88Info.blinkSegmentsInfo());
        }
        if (stringArray[0].compareToIgnoreCase("sr3") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setSegmentBank(3, n);
            }
            this.displayCmdOutput(Z88Info.blinkSegmentsInfo());
        }
        if (stringArray[0].compareToIgnoreCase("tim0") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setTim0(n);
            }
            this.displayCmdOutput(Z88Info.blinkTimersInfo());
        }
        if (stringArray[0].compareToIgnoreCase("tim1") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setTim1(n);
            }
            this.displayCmdOutput(Z88Info.blinkTimersInfo());
        }
        if (stringArray[0].compareToIgnoreCase("tim2") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setTim2(n);
            }
            this.displayCmdOutput(Z88Info.blinkTimersInfo());
        }
        if (stringArray[0].compareToIgnoreCase("tim3") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setTim3(n);
            }
            this.displayCmdOutput(Z88Info.blinkTimersInfo());
        }
        if (stringArray[0].compareToIgnoreCase("tim4") == 0) {
            if (stringArray.length == 2) {
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.blink.setTim4(n);
            }
            this.displayCmdOutput(Z88Info.blinkTimersInfo());
        }
        if (stringArray[0].compareToIgnoreCase("f") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change F flag while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.F(n);
            }
            this.displayCmdOutput("F=" + Z88Info.z80Flags() + " (" + Dz.byteToBin(this.z80.F(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("f'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate A register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.ex_af_af();
                this.z80.F(n);
                this.z80.ex_af_af();
            }
            this.z80.ex_af_af();
            this.displayCmdOutput("F'=" + Z88Info.z80Flags() + " (" + Dz.byteToBin(this.z80.F(), true) + ")");
            this.z80.ex_af_af();
        }
        if (stringArray[0].compareToIgnoreCase("fz") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change Zero flag while Z88 is running!");
                    return;
                }
                this.z80.fZ = StringEval.toInteger(stringArray[1]) != 0;
            } else {
                this.z80.fZ = !this.z80.fZ;
            }
            this.displayCmdOutput("F=" + Z88Info.z80Flags() + " (" + Dz.byteToBin(this.z80.F(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("fc") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change Carry flag while Z88 is running!");
                    return;
                }
                this.z80.fC = StringEval.toInteger(stringArray[1]) != 0;
            } else {
                this.z80.fC = !this.z80.fC;
            }
            this.displayCmdOutput("F=" + Z88Info.z80Flags() + " (" + Dz.byteToBin(this.z80.F(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("fs") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change Sign flag while Z88 is running!");
                    return;
                }
                this.z80.fS = StringEval.toInteger(stringArray[1]) != 0;
            } else {
                this.z80.fS = !this.z80.fS;
            }
            this.displayCmdOutput("F=" + Z88Info.z80Flags() + " (" + Dz.byteToBin(this.z80.F(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("fh") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change Half Carry flag while Z88 is running!");
                    return;
                }
                this.z80.fH = StringEval.toInteger(stringArray[1]) != 0;
            } else {
                this.z80.fH = !this.z80.fH;
            }
            this.displayCmdOutput("F=" + Z88Info.z80Flags() + " (" + Dz.byteToBin(this.z80.F(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("fn") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change Add./Sub. flag while Z88 is running!");
                    return;
                }
                this.z80.fN = StringEval.toInteger(stringArray[1]) != 0;
            } else {
                this.z80.fN = !this.z80.fN;
            }
            this.displayCmdOutput("F=" + Z88Info.z80Flags() + " (" + Dz.byteToBin(this.z80.F(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("fv") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change Parity flag while Z88 is running!");
                    return;
                }
                this.z80.fPV = StringEval.toInteger(stringArray[1]) != 0;
            } else {
                this.z80.fPV = !this.z80.fPV;
            }
            this.displayCmdOutput("F=" + Z88Info.z80Flags() + " (" + Dz.byteToBin(this.z80.F(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("a") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change A register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.A(n);
            }
            this.displayCmdOutput("A=" + Dz.byteToHex(this.z80.A(), true) + " (" + Dz.byteToBin(this.z80.A(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("a'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate A register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.ex_af_af();
                this.z80.A(n);
                this.z80.ex_af_af();
            }
            this.z80.ex_af_af();
            this.displayCmdOutput("A'=" + Dz.byteToHex(this.z80.A(), true) + " (" + Dz.byteToBin(this.z80.A(), true) + ")");
            this.z80.ex_af_af();
        }
        if (stringArray[0].compareToIgnoreCase("b") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change B register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.B(n);
            }
            this.displayCmdOutput("B=" + Dz.byteToHex(this.z80.B(), true) + " (" + Dz.byteToBin(this.z80.B(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("c") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change C register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.C(n);
            }
            this.displayCmdOutput("C=" + Dz.byteToHex(this.z80.C(), true) + " (" + Dz.byteToBin(this.z80.C(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("b'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate B register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.B(n);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("B'=" + Dz.byteToHex(this.z80.B(), true) + " (" + Dz.byteToBin(this.z80.B(), true) + ")");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("c'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate C register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.C(Integer.parseInt(stringArray[1], 16) & 0xFF);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("C'=" + Dz.byteToHex(this.z80.C(), true) + " (" + Dz.byteToBin(this.z80.C(), true) + ")");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("bc") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change BC register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.BC(n);
            }
            this.displayCmdOutput("BC=" + Dz.addrToHex(this.z80.BC(), true) + " (" + this.z80.BC() + "d)");
        }
        if (stringArray[0].compareToIgnoreCase("bc'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate BC register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.BC(n);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("BC'=" + Dz.addrToHex(this.z80.BC(), true) + " (" + this.z80.BC() + "d)");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("d") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change D register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.D(n);
            }
            this.displayCmdOutput("D=" + Dz.byteToHex(this.z80.D(), true) + " (" + Dz.byteToBin(this.z80.D(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("e") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change E register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.E(n);
            }
            this.displayCmdOutput("E=" + Dz.byteToHex(this.z80.E(), true) + " (" + Dz.byteToBin(this.z80.E(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("d'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate D register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.D(n);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("D'=" + Dz.byteToHex(this.z80.D(), true) + " (" + Dz.byteToBin(this.z80.D(), true) + ")");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("e'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate E register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.E(n);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("E'=" + Dz.byteToHex(this.z80.E(), true) + " (" + Dz.byteToBin(this.z80.E(), true) + ")");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("de") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change DE register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.DE(n);
            }
            this.displayCmdOutput("DE=" + Dz.addrToHex(this.z80.DE(), true) + " (" + this.z80.DE() + "d)");
        }
        if (stringArray[0].compareToIgnoreCase("de'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate DE register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.DE(n);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("DE'=" + Dz.addrToHex(this.z80.DE(), true) + " (" + this.z80.DE() + "d)");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("h") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change H register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.H(n);
            }
            this.displayCmdOutput("H=" + Dz.byteToHex(this.z80.H(), true) + " (" + Dz.byteToBin(this.z80.H(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("l") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change L register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.L(n);
            }
            this.displayCmdOutput("L=" + Dz.byteToHex(this.z80.L(), true) + " (" + Dz.byteToBin(this.z80.L(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("h'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate H register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.H(n);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("H'=" + Dz.byteToHex(this.z80.H(), true) + " (" + Dz.byteToBin(this.z80.H(), true) + ")");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("l'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate L register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.L(n);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("L'=" + Dz.byteToHex(this.z80.L(), true) + " (" + Dz.byteToBin(this.z80.L(), true) + ")");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("hl") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change HL register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.HL(n);
            }
            this.displayCmdOutput("HL=" + Dz.addrToHex(this.z80.HL(), true) + " (" + this.z80.HL() + "d)");
        }
        if (stringArray[0].compareToIgnoreCase("hl'") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change alternate HL register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.exx();
                this.z80.HL(n);
                this.z80.exx();
            }
            this.z80.exx();
            this.displayCmdOutput("HL'=" + Dz.addrToHex(this.z80.HL(), true) + " (" + this.z80.HL() + "d)");
            this.z80.exx();
        }
        if (stringArray[0].compareToIgnoreCase("i") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change I register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.I(n);
            }
            this.displayCmdOutput("I=" + Dz.byteToHex(this.z80.I(), true) + " (" + Dz.byteToBin(this.z80.I(), true) + ")");
        }
        if (stringArray[0].compareToIgnoreCase("ix") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change IX register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.IX(n);
            }
            this.displayCmdOutput("IX=" + Dz.addrToHex(this.z80.IX(), true) + " (" + this.z80.IX() + "d)");
        }
        if (stringArray[0].compareToIgnoreCase("iy") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change IY register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.IY(n);
            }
            this.displayCmdOutput("IY=" + Dz.addrToHex(this.z80.IY(), true) + " (" + this.z80.IY() + "d)");
        }
        if (stringArray[0].compareToIgnoreCase("sp") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change SP register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.SP(n);
            }
            this.displayCmdOutput("SP=" + Dz.addrToHex(this.z80.SP(), true) + " (" + this.z80.SP() + "d)");
        }
        if (stringArray[0].compareToIgnoreCase("pc") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change PC register while Z88 is running!");
                    return;
                }
                n = stringArray[1].startsWith("+") | stringArray[1].startsWith("-") ? this.z80.PC() + StringEval.toInteger(stringArray[1]) : StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 65535) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.PC(n);
            }
            this.displayCmdOutput(Z88Info.dzPcStatus(this.z80.PC()));
        }
        if (stringArray[0].compareToIgnoreCase("r") == 0) {
            if (stringArray.length == 2) {
                if (Z88.getInstance().getProcessorThread() != null) {
                    this.displayCmdOutput("Cannot change R register while Z88 is running!");
                    return;
                }
                n = StringEval.toInteger(stringArray[1]);
                if (n == -1 | n > 255) {
                    this.displayCmdOutput(illegalArgumentMessage);
                    return;
                }
                this.z80.R(n);
            }
            this.displayCmdOutput("R=" + Dz.byteToHex(this.z80.R(), true) + " (" + Dz.byteToBin(this.z80.R(), true) + ")");
        }
        DebugGui.getInstance().refreshZ88HardwareInfo();
    }

    public void cmdlineFirstSingleStep() {
        JTextField jTextField = DebugGui.getInstance().getCmdLineInputArea();
        this.displayCmdOutput(Z88Info.dzPcStatus(this.z80.PC()));
        DebugGui.getInstance().refreshZ88HardwareInfo();
        jTextField.setText(Dz.getNextStepCommand());
        jTextField.setCaretPosition(jTextField.getDocument().getLength());
        jTextField.selectAll();
        jTextField.grabFocus();
    }

    /*
     * Unable to fully structure code
     */
    private void fcdCommandline(String[] var1_1) {
        block25: {
            try {
                block26: {
                    if (var1_1.length == 1) {
                        var2_2 = new FileArea(var1_1[0].getBytes()[3] - 48);
                        var3_9 = var2_2.getFileEntries();
                        if (var3_9 == null) {
                            this.displayCmdOutput("File area is empty.");
                        } else {
                            this.displayCmdOutput("File area:");
                            while (var3_9.hasNext()) {
                                var4_12 = (FileEntry)var3_9.next();
                                this.displayCmdOutput(String.valueOf(var4_12.getFileName()) + (var4_12.isDeleted() != false ? " [d]" : "") + ", size=" + var4_12.getFileLength() + " bytes" + ", entry=" + Dz.extAddrToHex(var4_12.getFileEntryPtr(), true));
                            }
                        }
                        break block25;
                    }
                    if (var1_1.length == 2 & var1_1[1].compareToIgnoreCase("format") == 0) {
                        if (FileArea.create(var1_1[0].getBytes()[3] - 48, true)) {
                            this.displayCmdOutput("File area were created/formatted.");
                        } else {
                            this.displayCmdOutput("File area could not be created/formatted.");
                        }
                        break block25;
                    }
                    if (var1_1.length == 2 & var1_1[1].compareToIgnoreCase("cardhdr") == 0) {
                        if (FileArea.create(var1_1[0].getBytes()[3] - 48, false)) {
                            this.displayCmdOutput("File area header were created.");
                        } else {
                            this.displayCmdOutput("File area header could not be created.");
                        }
                        break block25;
                    }
                    if (var1_1.length == 2 & var1_1[1].compareToIgnoreCase("reclaim") == 0) {
                        var2_3 = new FileArea(var1_1[0].getBytes()[3] - 48);
                        var2_3.reclaimDeletedFileSpace();
                        this.displayCmdOutput("Deleted files have been removed from file area.");
                        break block25;
                    }
                    if (var1_1.length == 3 & var1_1[1].compareToIgnoreCase("del") == 0) {
                        var2_4 = new FileArea(var1_1[0].getBytes()[3] - 48);
                        if (var2_4.markAsDeleted(var1_1[2])) {
                            this.displayCmdOutput("File was marked as deleted.");
                        } else {
                            this.displayCmdOutput("File not found.");
                        }
                        break block25;
                    }
                    if (var1_1.length == 3 & var1_1[1].compareToIgnoreCase("ipf") == 0) {
                        var2_5 = new FileArea(var1_1[0].getBytes()[3] - 48);
                        var2_5.importHostFile(new File(var1_1[2]));
                        this.displayCmdOutput("File " + var1_1[2] + " was successfully imported.");
                        break block25;
                    }
                    if (var1_1.length == 3 & var1_1[1].compareToIgnoreCase("ipd") == 0) {
                        var2_6 = new FileArea(var1_1[0].getBytes()[3] - 48);
                        var2_6.importHostFiles(new File(var1_1[2]));
                        this.displayCmdOutput("Directory '" + var1_1[2] + "' was successfully imported.");
                        break block25;
                    }
                    if (!(var1_1.length == 3 & var1_1[1].compareToIgnoreCase("xpc") == 0)) break block26;
                    var2_7 = new FileArea(var1_1[0].getBytes()[3] - 48);
                    var3_10 = var2_7.getFileEntries();
                    if (var2_7.getActiveFileCount() != 0) ** GOTO lbl63
                    this.displayCmdOutput("No files available to export.");
                    break block25;
lbl-1000:
                    // 1 sources

                    {
                        var4_13 = (FileEntry)var3_10.next();
                        if (var4_13.isDeleted()) continue;
                        var5_15 = var4_13.getFileName();
                        var5_15 = var5_15.substring(var5_15.lastIndexOf("/") + 1);
                        var5_15 = String.valueOf(var1_1[2]) + File.separator + var5_15;
                        var6_17 = new RandomAccessFile(var5_15, "rw");
                        var6_17.write(var4_13.getFileImage());
                        var6_17.close();
                        this.displayCmdOutput("Exported " + var4_13.getFileName() + " to " + var5_15);
lbl63:
                        // 3 sources

                        ** while (var3_10.hasNext())
                    }
lbl64:
                    // 1 sources

                    break block25;
                }
                if (var1_1.length == 4 & var1_1[1].compareToIgnoreCase("xpf") == 0) {
                    var2_8 = new FileArea(var1_1[0].getBytes()[3] - 48);
                    var3_11 = var2_8.getFileEntry(var1_1[2]);
                    if (var3_11 == null) {
                        this.displayCmdOutput("File not found.");
                    } else {
                        var4_14 = var3_11.getFileName();
                        var4_14 = var4_14.substring(var4_14.lastIndexOf("/") + 1);
                        var4_14 = String.valueOf(var1_1[3]) + File.separator + var4_14;
                        var5_16 = new RandomAccessFile(var4_14, "rw");
                        var5_16.write(var3_11.getFileImage());
                        var5_16.close();
                        this.displayCmdOutput("Exported " + var3_11.getFileName() + " to " + var4_14);
                    }
                } else {
                    this.displayCmdOutput("Unknown file card command or missing arguments.");
                }
            }
            catch (FileAreaNotFoundException v0) {
                this.displayCmdOutput("No file area found in slot.");
            }
            catch (FileAreaExhaustedException v1) {
                this.displayCmdOutput("No more room in file area. One or several files could not be imported.");
            }
            catch (IOException v2) {
                this.displayCmdOutput("I/O error occurred during import/export of files.");
            }
        }
    }

    private WatchpointCmdArguments wpCommandline(String[] stringArray) throws IOException {
        WatchpointCmdArguments watchpointCmdArguments = new WatchpointCmdArguments();
        if (stringArray.length >= 2) {
            watchpointCmdArguments.argc = 1;
            watchpointCmdArguments.addrStart = Dz.stringAddr2Integer(stringArray[1]);
        }
        if (stringArray.length >= 3) {
            ++watchpointCmdArguments.argc;
            int n = 2;
            if (stringArray[n].compareTo("(") == 0) {
                watchpointCmdArguments.wpCmds = this.parseDebugCmds(stringArray, n);
                return watchpointCmdArguments;
            }
            watchpointCmdArguments.addrEnd = stringArray[n].startsWith("+") ? watchpointCmdArguments.addrStart + Integer.parseInt(stringArray[n++].substring(1)) - 1 : Dz.stringAddr2Integer(stringArray[n++]);
            if (n < stringArray.length && stringArray[n].compareTo("(") == 0) {
                ++watchpointCmdArguments.argc;
                watchpointCmdArguments.wpCmds = this.parseDebugCmds(stringArray, n);
            }
        }
        return watchpointCmdArguments;
    }

    private ArrayList<String> parseDebugCmds(String[] stringArray, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        while (n < stringArray.length & stringArray[n].compareTo("(") != 0) {
            ++n;
        }
        ++n;
        while (n < stringArray.length) {
            if (stringArray[n].length() > 0) {
                if ((stringArray[n].compareTo(";") == 0 | stringArray[n].compareTo(")") == 0) & string.length() > 0) {
                    string = string.trim();
                    arrayList.add(string);
                    string = "";
                } else {
                    string = String.valueOf(string) + stringArray[n] + " ";
                }
            }
            ++n;
        }
        return arrayList;
    }

    private void bpCommandline(String[] stringArray) throws IOException {
        if (stringArray.length >= 2) {
            int n = Dz.stringAddr2Integer(stringArray[1]);
            if (stringArray.length == 2) {
                this.breakPointManager.toggleBreakpoint(n, true);
            } else {
                this.breakPointManager.toggleBreakpoint(n, this.parseDebugCmds(stringArray, 2));
            }
            this.displayCmdOutput(this.breakPointManager.displayBreakpoints());
        }
        if (stringArray.length == 1) {
            this.displayCmdOutput(this.breakPointManager.displayBreakpoints());
        }
    }

    private void bpdCommandline(String[] stringArray) throws IOException {
        if (stringArray.length == 2) {
            int n = Dz.stringAddr2Integer(stringArray[1]);
            this.breakPointManager.toggleBreakpoint(n, false);
            this.displayCmdOutput(this.breakPointManager.displayBreakpoints());
        }
        if (stringArray.length == 1) {
            this.displayCmdOutput(this.breakPointManager.displayBreakpoints());
        }
    }

    private void dzCommandline(String[] stringArray) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(64);
        JTextField jTextField = DebugGui.getInstance().getCmdLineInputArea();
        if (stringArray.length == 2) {
            n = Integer.parseInt(stringArray[1], 16);
            if (n > 65535) {
                n2 = n >>> 16 & 0xFF;
                n &= 0xFFFF;
                bl = false;
            } else if (stringArray[1].length() == 6) {
                n2 = 0;
                bl = false;
            } else {
                bl = true;
            }
        } else if (stringArray.length == 1) {
            n = this.z80.PC();
            bl = true;
        } else {
            this.displayCmdOutput("Illegal argument.");
            return;
        }
        if (bl) {
            int n3 = 0;
            while (n3 < 16) {
                int n4 = n;
                n = this.dz.getInstrAscii(stringBuffer, n, false, true);
                this.displayCmdOutput(String.valueOf(Dz.addrToHex(n4, false)) + " (" + Dz.extAddrToHex(this.blink.decodeLocalAddress(n4), false).toString() + ") " + stringBuffer.toString());
                ++n3;
            }
            DebugGui.getInstance().getCmdLineInputArea().setText("dz " + Dz.addrToHex(n, false));
        } else {
            int n5 = 0;
            while (n5 < 16) {
                int n6 = n;
                n = this.dz.getInstrAscii(stringBuffer, n, n & 0x3FFF, n2, false, true);
                this.displayCmdOutput(String.valueOf(Dz.extAddrToHex(n2 << 16 | n6, false)) + " " + stringBuffer);
                ++n5;
            }
            jTextField.setText("dz " + Dz.extAddrToHex(n2 << 16 | n, false));
        }
        jTextField.setCaretPosition(jTextField.getDocument().getLength());
        jTextField.selectAll();
    }

    private int getMemoryAscii(StringBuffer stringBuffer, int n) {
        stringBuffer.delete(0, 255);
        int n2 = n;
        while (n2 < n + 16) {
            stringBuffer.append(Dz.byteToHex(this.blink.readByte(n2), false)).append(" ");
            ++n2;
        }
        int n3 = n;
        while (n3 < n + 16) {
            int n4 = this.blink.readByte(n3);
            stringBuffer.append(n4 >= 32 && n4 <= 127 ? Character.toString((char)n4) : ".");
            ++n3;
        }
        return n3;
    }

    private int getMemoryAscii(StringBuffer stringBuffer, int n, int n2) {
        stringBuffer.delete(0, 255);
        int n3 = n;
        while (n3 < n + 16) {
            stringBuffer.append(Dz.byteToHex(this.memory.getByte(n3, n2), false)).append(" ");
            ++n3;
        }
        int n4 = n;
        while (n4 < n + 16) {
            int n5 = this.memory.getByte(n4, n2);
            stringBuffer.append(n5 >= 32 && n5 <= 127 ? Character.toString((char)n5) : ".");
            ++n4;
        }
        return n4;
    }

    private void putByte(String[] stringArray) throws IOException {
        int n;
        int[] nArray;
        int n2;
        int n3;
        if (stringArray.length >= 3 & stringArray.length <= 18) {
            n3 = Integer.parseInt(stringArray[1], 16);
            n2 = n3 >>> 16 & 0xFF;
            n3 &= 0xFFFF;
            nArray = new int[stringArray.length - 2];
            n = 0;
            while (n < stringArray.length - 2) {
                nArray[n] = Integer.parseInt(stringArray[2 + n], 16);
                ++n;
            }
        } else {
            this.displayCmdOutput("Illegal argument(s).");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        this.getMemoryAscii(stringBuffer, n3, n2);
        this.displayCmdOutput("Before:\n" + stringBuffer);
        n = 0;
        while (n < stringArray.length - 2) {
            this.memory.setByte(n3 + n, n2, nArray[n]);
            ++n;
        }
        this.getMemoryAscii(stringBuffer, n3, n2);
        this.displayCmdOutput("After:\n" + stringBuffer);
    }

    private void viewMemory(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (stringArray.length == 2) {
            n = Dz.stringAddr2Integer(stringArray[1]);
        } else if (stringArray.length == 1) {
            n = this.blink.decodeLocalAddress(this.z80.PC());
        } else {
            this.displayCmdOutput("Illegal argument.");
            return;
        }
        n2 = n >>> 16 & 0xFF;
        n3 = n & 0x3FFF;
        Z88.getInstance().getMemory().getBank(n2).editMemory(n3, n2);
    }

    /* synthetic */ CommandLine(CommandLine commandLine) {
        this();
    }

    private class WatchpointCmdArguments {
        public int argc = 0;
        public int addrStart = -1;
        public int addrEnd = -1;
        public ArrayList<String> wpCmds = null;
    }

    private static final class singletonContainer {
        static final CommandLine singleton = new CommandLine(null);

        private singletonContainer() {
        }
    }
}

