/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.CommandHistory;
import com.jira.cambridgez88.ozvm.CommandLine;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.Z88Info;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.DefaultCaret;

public class DebugGui
extends JFrame
implements KeyListener {
    private Z80Processor z80;
    private Blink bl;
    private CommandHistory cmdList;
    private JTextArea jCmdOutput;
    private JTextField jCmdlineInput;
    private JScrollPane jCmdLineScrollPane;
    private JPanel jZ88HardwareView;
    private JTextField z80A;
    private JTextField z80F;
    private JTextField z80Flags;
    private JTextField z80Ax;
    private JTextField z80Fx;
    private JTextField z80BC;
    private JTextField z80DE;
    private JTextField z80HL;
    private JTextField z80BCx;
    private JTextField z80DEx;
    private JTextField z80HLx;
    private JTextField z80IX;
    private JTextField z80IY;
    private JTextField z80SP;
    private JTextField z80PC;
    private JTextField blSR0;
    private JTextField blSR1;
    private JTextField blSR2;
    private JTextField blSR3;
    private JTextField blTIM0;
    private JTextField blTIM1;
    private JTextField blTIM2;
    private JTextField blTIM3;
    private JTextField blTIM4;
    private JTextField blINT;
    private JTextField blSTA;
    private JTextField blTSTA;
    private JTable stackView;
    private Object[][] stackData;
    private final int stackViewRows = 256;
    private final int stackViewCols = 2;

    public static DebugGui getInstance() {
        if (singletonContainer.singleton == null) {
            singletonContainer.singleton = new DebugGui();
        }
        return singletonContainer.singleton;
    }

    private DebugGui() {
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.z80 = Z88.getInstance().getProcessor();
        this.bl = Z88.getInstance().getBlink();
        this.setIconImage(new ImageIcon(this.getClass().getResource("/pixel/debug.gif")).getImage());
        this.stackData = new String[256][2];
        this.getContentPane().add((Component)this.getCmdLineScrollPane(), "Center");
        this.getContentPane().add((Component)this.getZ88MachinePanel(), "After");
        this.getContentPane().add((Component)this.getCmdLineInputArea(), "South");
        this.setTitle("OZvm Debugger");
        this.setResizable(true);
        this.setForeground(Color.green);
        this.pack();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                singletonContainer.singleton = null;
            }
        });
        this.z80A.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("a " + DebugGui.this.z80A.getText());
            }
        });
        this.z80Ax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("a' " + DebugGui.this.z80Ax.getText());
            }
        });
        this.z80F.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("f " + DebugGui.this.z80F.getText());
            }
        });
        this.z80Fx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("f' " + DebugGui.this.z80Fx.getText());
            }
        });
        this.z80BC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("bc " + DebugGui.this.z80BC.getText());
            }
        });
        this.z80BCx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("bc' " + DebugGui.this.z80BCx.getText());
            }
        });
        this.z80DE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("de " + DebugGui.this.z80DE.getText());
            }
        });
        this.z80DEx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("de' " + DebugGui.this.z80DEx.getText());
            }
        });
        this.z80HL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("hl " + DebugGui.this.z80HL.getText());
            }
        });
        this.z80HLx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("hl' " + DebugGui.this.z80HLx.getText());
            }
        });
        this.z80IX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("ix " + DebugGui.this.z80IX.getText());
            }
        });
        this.z80IY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("iy " + DebugGui.this.z80IY.getText());
            }
        });
        this.z80PC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("pc " + DebugGui.this.z80PC.getText());
            }
        });
        this.z80SP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("sp " + DebugGui.this.z80SP.getText());
            }
        });
        this.z80PC.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DebugGui.this.z80PC.setText(Dz.addrToHex(DebugGui.this.z80.PC(), false));
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DebugGui.this.z80PC.setText(String.valueOf(Dz.byteToHex(DebugGui.this.bl.decodeLocalAddress(DebugGui.this.z80.PC()) >>> 16, false)) + Dz.addrToHex(DebugGui.this.z80.PC(), false));
            }
        });
        this.blSR0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("sr0 " + DebugGui.this.blSR0.getText());
            }
        });
        this.blSR1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("sr1 " + DebugGui.this.blSR1.getText());
            }
        });
        this.blSR2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("sr2 " + DebugGui.this.blSR2.getText());
            }
        });
        this.blSR3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("sr3 " + DebugGui.this.blSR3.getText());
            }
        });
        this.blTIM0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("tim0 " + DebugGui.this.blTIM0.getText());
            }
        });
        this.blTIM1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("tim1 " + DebugGui.this.blTIM1.getText());
            }
        });
        this.blTIM2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("tim2 " + DebugGui.this.blTIM2.getText());
            }
        });
        this.blTIM3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("tim3 " + DebugGui.this.blTIM3.getText());
            }
        });
        this.blTIM4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommandLine.getInstance().parseCommandLine("tim4 " + DebugGui.this.blTIM4.getText());
            }
        });
        this.getCmdLineInputArea().grabFocus();
    }

    public void refreshZ88HardwareInfo() {
        this.z80A.setText(Dz.byteToHex(this.z80.A(), false));
        this.z80F.setText(Dz.byteToHex(this.z80.F(), false));
        this.z80Flags.setText(Z88Info.z80Flags(this.z80.F()).toString());
        this.z80Ax.setText(Dz.byteToHex(this.z80.AFx() >> 8, false));
        this.z80Fx.setText(Dz.byteToHex(this.z80.AFx() & 0xFF, false));
        this.z80BC.setText(Dz.addrToHex(this.z80.BC(), false));
        this.z80DE.setText(Dz.addrToHex(this.z80.DE(), false));
        this.z80HL.setText(Dz.addrToHex(this.z80.HL(), false));
        this.z80BCx.setText(Dz.addrToHex(this.z80.BCx(), false));
        this.z80DEx.setText(Dz.addrToHex(this.z80.DEx(), false));
        this.z80HLx.setText(Dz.addrToHex(this.z80.HLx(), false));
        this.z80IX.setText(Dz.addrToHex(this.z80.IX(), false));
        this.z80IY.setText(Dz.addrToHex(this.z80.IY(), false));
        this.z80SP.setText(Dz.addrToHex(this.z80.SP(), false));
        this.z80PC.setText(String.valueOf(Dz.byteToHex(this.bl.decodeLocalAddress(this.z80.PC()) >>> 16, false)) + Dz.addrToHex(this.z80.PC(), false));
        this.updateStackView();
        this.blSR0.setText(Dz.byteToHex(this.bl.getSegmentBank(0), false));
        this.blSR1.setText(Dz.byteToHex(this.bl.getSegmentBank(1), false));
        this.blSR2.setText(Dz.byteToHex(this.bl.getSegmentBank(2), false));
        this.blSR3.setText(Dz.byteToHex(this.bl.getSegmentBank(3), false));
        this.blTIM0.setText(Dz.byteToHex(this.bl.getTim0(), false));
        this.blTIM1.setText(Dz.byteToHex(this.bl.getTim1(), false));
        this.blTIM2.setText(Dz.byteToHex(this.bl.getTim2(), false));
        this.blTIM3.setText(Dz.byteToHex(this.bl.getTim3(), false));
        this.blTIM4.setText(Dz.byteToHex(this.bl.getTim4(), false));
        this.blINT.setText(Dz.byteToBin(this.bl.getInt(), false));
        this.blSTA.setText(Dz.byteToBin(this.bl.getSta(), false));
        this.blTSTA.setText(Dz.byteToBin(this.bl.getTsta(), false));
    }

    public void lockZ88MachinePanel(boolean bl) {
        this.z80A.setEnabled(bl);
        this.z80F.setEnabled(bl);
        this.z80Flags.setEnabled(false);
        this.z80Ax.setEnabled(bl);
        this.z80Fx.setEnabled(bl);
        this.z80BC.setEnabled(bl);
        this.z80DE.setEnabled(bl);
        this.z80HL.setEnabled(bl);
        this.z80BCx.setEnabled(bl);
        this.z80DEx.setEnabled(bl);
        this.z80HLx.setEnabled(bl);
        this.z80IX.setEnabled(bl);
        this.z80IY.setEnabled(bl);
        this.z80SP.setEnabled(bl);
        this.z80PC.setEnabled(bl);
        this.stackView.setEnabled(bl);
        this.blSR0.setEnabled(bl);
        this.blSR1.setEnabled(bl);
        this.blSR2.setEnabled(bl);
        this.blSR3.setEnabled(bl);
        this.blTIM0.setEnabled(bl);
        this.blTIM1.setEnabled(bl);
        this.blTIM2.setEnabled(bl);
        this.blTIM3.setEnabled(bl);
        this.blTIM4.setEnabled(bl);
        this.blINT.setEnabled(false);
        this.blSTA.setEnabled(false);
        this.blTSTA.setEnabled(false);
    }

    private void updateStackView() {
        int n = this.z80.SP() + 64;
        int n2 = 0;
        while (n2 < 256) {
            this.stackView.setValueAt(Dz.addrToHex(n, false), n2, 0);
            this.stackView.setValueAt(Dz.addrToHex(this.z80.readWord(n), false), n2, 1);
            if (n == this.z80.SP()) {
                this.stackView.setRowSelectionInterval(n2, n2);
            }
            n -= 2;
            ++n2;
        }
    }

    public JTable getZ80StackView() {
        if (this.stackView == null) {
            Object[] objectArray = new String[]{"SP", "(SP)"};
            this.stackView = new JTable(this.stackData, objectArray);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(0);
            this.stackView.getColumnModel().getColumn(0).setHeaderRenderer(defaultTableCellRenderer);
            this.stackView.getColumnModel().getColumn(1).setHeaderRenderer(defaultTableCellRenderer);
            this.stackView.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
            this.stackView.getColumnModel().getColumn(1).setCellRenderer(defaultTableCellRenderer);
        }
        return this.stackView;
    }

    public JPanel getZ88MachinePanel() {
        if (this.jZ88HardwareView == null) {
            this.jZ88HardwareView = new JPanel(new GridBagLayout());
            JLabel jLabel = new JLabel("Z80 CPU Registers", 0);
            Font font = jLabel.getFont();
            jLabel.setFont(new Font(font.getName(), 1, 14));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.gridwidth = 6;
            gridBagConstraints.fill = 2;
            this.jZ88HardwareView.add((Component)jLabel, gridBagConstraints);
            this.getZ80StackView().getTableHeader().setFont(new Font(font.getName(), 1, 14));
            this.getZ80StackView().setFont(new Font(font.getName(), 0, 13));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.insets = new Insets(3, 3, 0, 0);
            gridBagConstraints2.weightx = 1.1;
            gridBagConstraints2.gridheight = 14;
            gridBagConstraints2.fill = 1;
            this.jZ88HardwareView.add((Component)new JScrollPane(this.getZ80StackView()), gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("AF", 11), gridBagConstraints3);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 0.7;
            gridBagConstraints4.fill = 2;
            this.z80A = new JTextField(2);
            this.z80A.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80A, gridBagConstraints4);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 0.7;
            gridBagConstraints5.fill = 2;
            this.z80F = new JTextField(2);
            this.z80F.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80F, gridBagConstraints5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("AF'", 11), gridBagConstraints6);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.weightx = 0.7;
            gridBagConstraints7.fill = 2;
            this.z80Ax = new JTextField(2);
            this.z80Ax.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80Ax, gridBagConstraints7);
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.gridy = 2;
            gridBagConstraints8.weightx = 0.7;
            gridBagConstraints8.fill = 2;
            this.z80Fx = new JTextField(2);
            this.z80Fx.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80Fx, gridBagConstraints8);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 3;
            gridBagConstraints9.weightx = 0.0;
            gridBagConstraints9.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("Flags", 11), gridBagConstraints9);
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.gridy = 3;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.gridwidth = 2;
            gridBagConstraints10.fill = 2;
            this.z80Flags = new JTextField(4);
            this.z80Flags.setHorizontalAlignment(0);
            this.z80Flags.setFont(new Font("Monospaced", 0, 13));
            this.jZ88HardwareView.add((Component)this.z80Flags, gridBagConstraints10);
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 4;
            gridBagConstraints11.weightx = 0.0;
            gridBagConstraints11.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("PC", 11), gridBagConstraints11);
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.gridy = 4;
            gridBagConstraints12.weightx = 0.0;
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.fill = 2;
            this.z80PC = new JTextField(4);
            this.z80PC.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80PC, gridBagConstraints12);
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 5;
            gridBagConstraints13.weightx = 0.0;
            gridBagConstraints13.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("SP", 11), gridBagConstraints13);
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 1;
            gridBagConstraints14.gridy = 5;
            gridBagConstraints14.weightx = 0.0;
            gridBagConstraints14.gridwidth = 2;
            gridBagConstraints14.fill = 2;
            this.z80SP = new JTextField(4);
            this.z80SP.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80SP, gridBagConstraints14);
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 6;
            gridBagConstraints15.weightx = 0.0;
            gridBagConstraints15.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("BC", 11), gridBagConstraints15);
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.gridy = 6;
            gridBagConstraints16.weightx = 0.0;
            gridBagConstraints16.gridwidth = 2;
            gridBagConstraints16.fill = 2;
            this.z80BC = new JTextField(4);
            this.z80BC.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80BC, gridBagConstraints16);
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.gridy = 7;
            gridBagConstraints17.weightx = 0.0;
            gridBagConstraints17.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("DE", 11), gridBagConstraints17);
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 1;
            gridBagConstraints18.gridy = 7;
            gridBagConstraints18.weightx = 0.0;
            gridBagConstraints18.gridwidth = 2;
            gridBagConstraints18.fill = 2;
            this.z80DE = new JTextField(4);
            this.z80DE.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80DE, gridBagConstraints18);
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.gridy = 8;
            gridBagConstraints19.weightx = 0.0;
            gridBagConstraints19.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("HL", 11), gridBagConstraints19);
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 1;
            gridBagConstraints20.gridy = 8;
            gridBagConstraints20.weightx = 0.0;
            gridBagConstraints20.gridwidth = 2;
            gridBagConstraints20.fill = 2;
            this.z80HL = new JTextField(4);
            this.z80HL.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80HL, gridBagConstraints20);
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridy = 9;
            gridBagConstraints21.weightx = 0.0;
            gridBagConstraints21.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("IX", 11), gridBagConstraints21);
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.gridy = 9;
            gridBagConstraints22.weightx = 0.0;
            gridBagConstraints22.gridwidth = 2;
            gridBagConstraints22.fill = 2;
            this.z80IX = new JTextField(4);
            this.z80IX.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80IX, gridBagConstraints22);
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.gridy = 10;
            gridBagConstraints23.weightx = 0.0;
            gridBagConstraints23.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("IY", 11), gridBagConstraints23);
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 1;
            gridBagConstraints24.gridy = 10;
            gridBagConstraints24.weightx = 0.0;
            gridBagConstraints24.gridwidth = 2;
            gridBagConstraints24.fill = 2;
            this.z80IY = new JTextField(4);
            this.z80IY.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80IY, gridBagConstraints24);
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 0;
            gridBagConstraints25.gridy = 11;
            gridBagConstraints25.weightx = 0.0;
            gridBagConstraints25.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("BC'", 11), gridBagConstraints25);
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 1;
            gridBagConstraints26.gridy = 11;
            gridBagConstraints26.weightx = 0.0;
            gridBagConstraints26.gridwidth = 2;
            gridBagConstraints26.fill = 2;
            this.z80BCx = new JTextField(4);
            this.z80BCx.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80BCx, gridBagConstraints26);
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 0;
            gridBagConstraints27.gridy = 12;
            gridBagConstraints27.weightx = 0.0;
            gridBagConstraints27.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("DE'", 11), gridBagConstraints27);
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 1;
            gridBagConstraints28.gridy = 12;
            gridBagConstraints28.weightx = 0.0;
            gridBagConstraints28.gridwidth = 2;
            gridBagConstraints28.fill = 2;
            this.z80DEx = new JTextField(4);
            this.z80DEx.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80DEx, gridBagConstraints28);
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.gridx = 0;
            gridBagConstraints29.gridy = 13;
            gridBagConstraints29.weightx = 0.0;
            gridBagConstraints29.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("HL'", 11), gridBagConstraints29);
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridx = 1;
            gridBagConstraints30.gridy = 13;
            gridBagConstraints30.weightx = 0.0;
            gridBagConstraints30.gridwidth = 2;
            gridBagConstraints30.fill = 2;
            this.z80HLx = new JTextField(4);
            this.z80HLx.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.z80HLx, gridBagConstraints30);
            JLabel jLabel2 = new JLabel("Z88 Blink Registers", 0);
            jLabel2.setFont(new Font(font.getName(), 1, 14));
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.gridy = 15;
            gridBagConstraints31.anchor = 19;
            gridBagConstraints31.gridwidth = 6;
            gridBagConstraints31.fill = 2;
            this.jZ88HardwareView.add((Component)jLabel2, gridBagConstraints31);
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.gridy = 16;
            gridBagConstraints32.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel(" SR0-3", 11), gridBagConstraints32);
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.gridx = 1;
            gridBagConstraints33.gridy = 16;
            gridBagConstraints33.weightx = 0.5;
            gridBagConstraints33.gridwidth = 1;
            gridBagConstraints33.fill = 2;
            this.blSR0 = new JTextField(2);
            this.blSR0.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blSR0, gridBagConstraints33);
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.gridx = 2;
            gridBagConstraints34.gridy = 16;
            gridBagConstraints34.weightx = 0.5;
            gridBagConstraints34.gridwidth = 1;
            gridBagConstraints34.fill = 2;
            this.blSR1 = new JTextField(2);
            this.blSR1.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blSR1, gridBagConstraints34);
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.gridx = 3;
            gridBagConstraints35.gridy = 16;
            gridBagConstraints35.weightx = 0.6;
            gridBagConstraints35.gridwidth = 1;
            gridBagConstraints35.fill = 2;
            this.blSR2 = new JTextField(2);
            this.blSR2.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blSR2, gridBagConstraints35);
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.gridx = 4;
            gridBagConstraints36.gridy = 16;
            gridBagConstraints36.weightx = 0.6;
            gridBagConstraints36.gridwidth = 1;
            gridBagConstraints36.fill = 2;
            this.blSR3 = new JTextField(2);
            this.blSR3.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blSR3, gridBagConstraints36);
            GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
            gridBagConstraints37.gridx = 0;
            gridBagConstraints37.gridy = 17;
            gridBagConstraints37.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("TIM0-4", 11), gridBagConstraints37);
            GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
            gridBagConstraints38.gridx = 1;
            gridBagConstraints38.gridy = 17;
            gridBagConstraints38.weightx = 0.5;
            gridBagConstraints38.gridwidth = 1;
            gridBagConstraints38.fill = 2;
            this.blTIM0 = new JTextField(2);
            this.blTIM0.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blTIM0, gridBagConstraints38);
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            gridBagConstraints39.gridx = 2;
            gridBagConstraints39.gridy = 17;
            gridBagConstraints39.weightx = 0.5;
            gridBagConstraints39.gridwidth = 1;
            gridBagConstraints39.fill = 2;
            this.blTIM1 = new JTextField(2);
            this.blTIM1.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blTIM1, gridBagConstraints39);
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            gridBagConstraints40.gridx = 3;
            gridBagConstraints40.gridy = 17;
            gridBagConstraints40.weightx = 0.6;
            gridBagConstraints40.gridwidth = 1;
            gridBagConstraints40.fill = 2;
            this.blTIM2 = new JTextField(2);
            this.blTIM2.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blTIM2, gridBagConstraints40);
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 4;
            gridBagConstraints41.gridy = 17;
            gridBagConstraints41.weightx = 0.6;
            gridBagConstraints41.gridwidth = 1;
            gridBagConstraints41.fill = 2;
            this.blTIM3 = new JTextField(2);
            this.blTIM3.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blTIM3, gridBagConstraints41);
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.gridx = 5;
            gridBagConstraints42.gridy = 17;
            gridBagConstraints42.weightx = 0.6;
            gridBagConstraints42.gridwidth = 1;
            gridBagConstraints42.fill = 2;
            this.blTIM4 = new JTextField(2);
            this.blTIM4.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blTIM4, gridBagConstraints42);
            GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
            gridBagConstraints43.gridx = 0;
            gridBagConstraints43.gridy = 18;
            gridBagConstraints43.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("INT", 11), gridBagConstraints43);
            GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
            gridBagConstraints44.gridx = 1;
            gridBagConstraints44.gridy = 18;
            gridBagConstraints44.weightx = 0.6;
            gridBagConstraints44.gridwidth = 5;
            gridBagConstraints44.fill = 2;
            this.blINT = new JTextField(2);
            this.blINT.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blINT, gridBagConstraints44);
            GridBagConstraints gridBagConstraints45 = new GridBagConstraints();
            gridBagConstraints45.gridx = 0;
            gridBagConstraints45.gridy = 19;
            gridBagConstraints45.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("STA", 11), gridBagConstraints45);
            GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
            gridBagConstraints46.gridx = 1;
            gridBagConstraints46.gridy = 19;
            gridBagConstraints46.weightx = 0.6;
            gridBagConstraints46.gridwidth = 5;
            gridBagConstraints46.fill = 2;
            this.blSTA = new JTextField(2);
            this.blSTA.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blSTA, gridBagConstraints46);
            GridBagConstraints gridBagConstraints47 = new GridBagConstraints();
            gridBagConstraints47.gridx = 0;
            gridBagConstraints47.gridy = 20;
            gridBagConstraints47.fill = 2;
            this.jZ88HardwareView.add((Component)new JLabel("TSTA", 11), gridBagConstraints47);
            GridBagConstraints gridBagConstraints48 = new GridBagConstraints();
            gridBagConstraints48.gridx = 1;
            gridBagConstraints48.gridy = 20;
            gridBagConstraints48.weightx = 0.6;
            gridBagConstraints48.gridwidth = 5;
            gridBagConstraints48.fill = 2;
            this.blTSTA = new JTextField(2);
            this.blTSTA.setHorizontalAlignment(0);
            this.jZ88HardwareView.add((Component)this.blTSTA, gridBagConstraints48);
            this.jZ88HardwareView.setPreferredSize(new Dimension(220, 400));
            this.jZ88HardwareView.setFont(new Font("Monospaced", 0, 11));
        }
        return this.jZ88HardwareView;
    }

    public JTextArea getCmdlineOutputArea() {
        if (this.jCmdOutput == null) {
            this.jCmdOutput = new JTextArea(20, 100);
            this.jCmdOutput.setFont(new Font("Monospaced", 0, 11));
            this.jCmdOutput.setBackground(Color.BLACK);
            this.jCmdOutput.setForeground(Color.GREEN);
            this.jCmdOutput.setTabSize(1);
            this.jCmdOutput.setEditable(false);
            this.jCmdOutput.setToolTipText("This area displays debug command output.");
            this.jCmdOutput.setVisible(true);
            DefaultCaret defaultCaret = (DefaultCaret)this.jCmdOutput.getCaret();
            defaultCaret.setUpdatePolicy(2);
        }
        return this.jCmdOutput;
    }

    public void clearCmdOutputArea() {
        this.getCmdlineOutputArea().setText("");
    }

    public void displayCmdOutput(String string) {
        this.getCmdlineOutputArea().append(String.valueOf(string) + "\n");
    }

    public void activateDebugCommandLine() {
        this.toFront();
        this.getCmdLineInputArea().grabFocus();
        this.lockZ88MachinePanel(Z88.getInstance().getProcessorThread() == null);
    }

    public JTextField getCmdLineInputArea() {
        if (this.jCmdlineInput == null) {
            this.jCmdlineInput = new JTextField();
            this.jCmdlineInput.setFont(new Font("Monospaced", 0, 11));
            this.jCmdlineInput.setToolTipText("Type your debugging commands here");
            this.jCmdlineInput.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = DebugGui.this.jCmdlineInput.getText();
                    DebugGui.this.cmdList.addCommand(string);
                    DebugGui.this.jCmdlineInput.setText("");
                    CommandLine.getInstance().parseCommandLine(string);
                }
            });
            this.jCmdlineInput.addKeyListener(this);
            this.cmdList = new CommandHistory();
            this.jCmdlineInput.setVisible(true);
        }
        return this.jCmdlineInput;
    }

    public void disableCmdLineInput() {
        this.getCmdLineInputArea().setEnabled(false);
    }

    public void enableCmdLineInput() {
        this.getCmdLineInputArea().setEnabled(true);
    }

    private JScrollPane getCmdLineScrollPane() {
        if (this.jCmdLineScrollPane == null) {
            this.jCmdLineScrollPane = new JScrollPane(20, 31);
            this.jCmdLineScrollPane.setViewportView(this.getCmdlineOutputArea());
            this.jCmdLineScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    adjustmentEvent.getAdjustable().setValue(adjustmentEvent.getAdjustable().getMaximum());
                }
            });
        }
        return this.jCmdLineScrollPane;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.getCmdLineInputArea();
        switch (keyEvent.getKeyCode()) {
            case 123: {
                Z88.getInstance().getDisplay().grabFocus();
                break;
            }
            case 38: {
                String string = this.cmdList.browsePrevCommand();
                if (string == null) break;
                this.getCmdLineInputArea().setText(string);
                this.getCmdLineInputArea().setCaretPosition(this.getCmdLineInputArea().getDocument().getLength());
                this.getCmdLineInputArea().selectAll();
                break;
            }
            case 40: {
                String string = this.cmdList.browseNextCommand();
                if (string == null) break;
                this.getCmdLineInputArea().setText(string);
                this.getCmdLineInputArea().setCaretPosition(this.getCmdLineInputArea().getDocument().getLength());
                this.getCmdLineInputArea().selectAll();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    /* synthetic */ DebugGui(DebugGui debugGui) {
        this();
    }

    private static final class singletonContainer {
        static DebugGui singleton = new DebugGui(null);

        private singletonContainer() {
        }
    }
}

