/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Z88;

public final class EpromBank
extends Bank {
    public static final int VPP32KB = 126;
    public static final int VPP128KB = 124;
    private Blink blink = Z88.getInstance().getBlink();
    private int eprType;

    public EpromBank(int n) {
        super(-1);
        this.eprType = n;
        int n2 = 0;
        while (n2 < 16384) {
            this.setByte(n2, 255);
            ++n2;
        }
    }

    @Override
    public final int readByte(int n) {
        return this.getByte(n);
    }

    @Override
    public final void writeByte(int n, int n2) {
        int n3 = this.blink.getCom();
        int n4 = this.blink.getEpr();
        if ((n3 & 1) == 0 && (n3 & 2) != 0 && (n3 & 8) != 0 || (n3 & 0x20) != 0) {
            switch (this.eprType) {
                case 126: {
                    if (n4 == 72) break;
                    return;
                }
                case 124: {
                    if (n4 == 105) break;
                    return;
                }
            }
            this.setByte(n, n2 & this.getByte(n));
        }
    }

    public int getEprType() {
        return this.eprType;
    }

    @Override
    public boolean isEmpty() {
        int n = 0;
        while (n < 16384) {
            if (this.getByte(n) != 255) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

