/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.CommandLine;
import com.jira.cambridgez88.ozvm.DebugGui;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.OZvm;
import com.jira.cambridgez88.ozvm.RubberKeyboard;
import com.jira.cambridgez88.ozvm.SaveRestoreVM;
import com.jira.cambridgez88.ozvm.Slots;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.Z88BodyGui;
import com.jira.cambridgez88.ozvm.screen.Z88display;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;

public class Gui
extends JFrame {
    private static final String aboutDialogText = "<html><center><h2>OZvm 1.2</h2><h3>The Z88 emulator & debugging environment</h3>GPL v2 licensed software by Gunther Strube<br><tt>gstrube@gmail.com</tt><br><br><tt>https://cambridgez88.jira.com/wiki/display/OZVM</tt></center><br><hr><br><table align='center' cellspacing='0' border='0'><tr><td>Java:</td><td>" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "; " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "</td></tr>" + "<tr><td>Runtime:</td><td>" + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version") + "</td></tr>" + "<tr><td>System:</td><td>" + System.getProperty("os.name") + " V" + System.getProperty("os.version") + " on " + System.getProperty("os.arch") + "</td></tr>" + "</table>" + "</html>";
    private Z88BodyGui zb;
    private Blink blink;
    private ButtonGroup kbLayoutButtonGroup;
    private ButtonGroup scrRefreshRateButtonGroup;
    private JToolBar toolBar;
    private JButton toolBarButton1;
    private JButton toolBarButton2;
    private Z88display z88Display;
    private Z80Processor z80proc;
    private JPanel z88ScreenPanel;
    private RubberKeyboard keyboardPanel;
    private Slots slotsPanel;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu viewMenu;
    private JMenu z88Menu;
    private JMenu screenMenu;
    private JMenu keyboardMenu;
    private JMenu screenRefrashRateMenu;
    private JMenu installRomMenuItem;
    private JMenuItem fileExitMenuItem;
    private JMenuItem debugCmdlineMenuItem;
    private JMenuItem aboutOZvmMenuItem;
    private JMenuItem createSnapshotMenuItem;
    private JMenuItem loadSnapshotMenuItem;
    private JMenuItem softResetMenuItem;
    private JMenuItem hardResetMenuItem;
    private JMenuItem installOz43RomMenuItem;
    private JMenuItem installOz44RomMenuItem;
    private JMenuItem installOz45RomMenuItem;
    private JMenuItem installOz46RomMenuItem;
    private JMenuItem installOz47RomMenuItem;
    private JMenuItem installUk400RomMenuItem;
    private JMenuItem installUk300RomMenuItem;
    private JMenuItem installUk220RomMenuItem;
    private JMenuItem installFr326RomMenuItem;
    private JMenuItem installEs319RomMenuItem;
    private JMenuItem installDe318RomMenuItem;
    private JMenuItem installIt323RomMenuItem;
    private JMenuItem installDk321RomMenuItem;
    private JMenuItem installSe250RomMenuItem;
    private JMenuItem installNo260RomMenuItem;
    private JMenuItem installFi401RomMenuItem;
    private JMenuItem installHe313RomMenuItem;
    private JMenuItem installTk317RomMenuItem;
    private JMenuItem userManualMenuItem;
    private JMenuItem z88UserGuideMenuItem;
    private JMenuItem z88DevNotesMenuItem;
    private JMenuItem gifMovieMenuItem;
    private JMenuItem screenSnapshotMenuItem;
    private JMenuItem viewMemoryMenuItem;
    private JMenuItem battLowIntMenuItem;
    private JMenuItem shiftKeysMenuItem;
    private JMenuItem clearKbMatrixMenuItem;
    private JCheckBoxMenuItem screenDoubleSizeMenuItem;
    private JCheckBoxMenuItem rtmMessagesMenuItem;
    private JCheckBoxMenuItem seLayoutMenuItem;
    private JCheckBoxMenuItem frLayoutMenuItem;
    private JCheckBoxMenuItem dkLayoutMenuItem;
    private JCheckBoxMenuItem ukLayoutMenuItem;
    private JCheckBoxMenuItem showRubberKbMenuItem;
    private JCheckBoxMenuItem scr10FpsMenuItem;
    private JCheckBoxMenuItem scr25FpsMenuItem;
    private JCheckBoxMenuItem scr50FpsMenuItem;
    private JCheckBoxMenuItem scr100FpsMenuItem;
    private JCheckBoxMenuItem z80CpuRealSpeedMenuItem;

    public Gui() {
        this.initialize();
        this.setDefaultCloseOperation(3);
    }

    private JPanel getZ88ScreenPanel() {
        if (this.z88ScreenPanel == null) {
            this.z88ScreenPanel = new JPanel();
            if (this.getZ88Display().isDoubleScreenSize()) {
                this.z88ScreenPanel.setPreferredSize(new Dimension(1288, 136));
            } else {
                this.z88ScreenPanel.setPreferredSize(new Dimension(644, 72));
            }
            this.z88ScreenPanel.setBackground(Color.GRAY);
            this.z88ScreenPanel.add(this.getZ88Display());
        }
        return this.z88ScreenPanel;
    }

    private Z88display getZ88Display() {
        if (this.z88Display == null) {
            this.z88Display = Z88.getInstance().getDisplay();
            this.z88Display.setLayout(null);
            this.z88Display.setForeground(Color.WHITE);
            this.z88Display.setText("This is the Z88 Screen");
        }
        return this.z88Display;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getToolBarButton1());
            this.toolBar.add(this.getToolBarButton2());
            this.toolBar.setVisible(false);
        }
        return this.toolBar;
    }

    private JButton getToolBarButton1() {
        if (this.toolBarButton1 == null) {
            this.toolBarButton1 = new JButton();
            this.toolBarButton1.setText("New JButton");
        }
        return this.toolBarButton1;
    }

    private JButton getToolBarButton2() {
        if (this.toolBarButton2 == null) {
            this.toolBarButton2 = new JButton();
            this.toolBarButton2.setText("New JButton");
        }
        return this.toolBarButton2;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getUserManualMenuItem());
            this.helpMenu.add(this.getZ88UserGuideMenuItem());
            this.helpMenu.add(this.getZ88DevNotesMenuItem());
            this.helpMenu.add(this.getAboutOZvmMenuItem());
        }
        return this.helpMenu;
    }

    public void launchBrowserUrl(String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        Runtime runtime = Runtime.getRuntime();
        try {
            if (string2.indexOf("win") >= 0) {
                runtime.exec("rundll32 url.dll,FileProtocolHandler " + string);
            } else if (string2.indexOf("mac") >= 0) {
                runtime.exec("open " + string);
            } else if (string2.indexOf("nix") >= 0 || string2.indexOf("nux") >= 0) {
                String[] stringArray = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(String.valueOf(n == 0 ? "" : " || ") + stringArray[n] + " \"" + string + "\" ");
                    ++n;
                }
                runtime.exec(new String[]{"sh", "-c", stringBuffer.toString()});
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Could not launch URL in Desktop Browser.", "Online Help", 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, "Could not launch URL in Desktop Browser.", "Online Help", 0);
        }
    }

    private JMenuItem getUserManualMenuItem() {
        if (this.userManualMenuItem == null) {
            this.userManualMenuItem = new JMenuItem();
            this.userManualMenuItem.setText("OZvm User Guide");
            this.userManualMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.launchBrowserUrl("https://cambridgez88.jira.com/wiki/x/zIB5");
                }
            });
        }
        return this.userManualMenuItem;
    }

    private JMenuItem getZ88UserGuideMenuItem() {
        if (this.z88UserGuideMenuItem == null) {
            this.z88UserGuideMenuItem = new JMenuItem();
            this.z88UserGuideMenuItem.setText("Z88 User Guide");
            this.z88UserGuideMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.launchBrowserUrl("https://cambridgez88.jira.com/wiki/x/LgAkAg");
                }
            });
        }
        return this.z88UserGuideMenuItem;
    }

    private JMenuItem getZ88DevNotesMenuItem() {
        if (this.z88DevNotesMenuItem == null) {
            this.z88DevNotesMenuItem = new JMenuItem();
            this.z88DevNotesMenuItem.setText("Z88 Developers' Notes");
            this.z88DevNotesMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.launchBrowserUrl("https://cambridgez88.jira.com/wiki/x/NQAE");
                }
            });
        }
        return this.z88DevNotesMenuItem;
    }

    private JMenuItem getAboutOZvmMenuItem() {
        if (this.aboutOZvmMenuItem == null) {
            this.aboutOZvmMenuItem = new JMenuItem();
            this.aboutOZvmMenuItem.setMnemonic(65);
            this.aboutOZvmMenuItem.setText("About");
            this.aboutOZvmMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane.showMessageDialog(Gui.this, aboutDialogText, "About OZvm", -1);
                }
            });
        }
        return this.aboutOZvmMenuItem;
    }

    private JMenuBar getMainMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.menuBar.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.menuBar.add(this.getFileMenu());
            this.menuBar.add(this.getZ88Menu());
            this.menuBar.add(this.getKeyboardMenu());
            this.menuBar.add(this.getViewMenu());
            this.menuBar.add(this.getHelpMenu());
        }
        return this.menuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getLoadSnapshotMenuItem());
            this.fileMenu.add(this.getCreateSnapshotMenuItem());
            this.fileMenu.add(this.getCreateScreenMenu());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getFileExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getDebugCmdlineMenuItem() {
        if (this.debugCmdlineMenuItem == null) {
            this.debugCmdlineMenuItem = new JMenuItem();
            this.debugCmdlineMenuItem.setMnemonic(68);
            this.debugCmdlineMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
            this.debugCmdlineMenuItem.setText("Debug Command Line");
            this.debugCmdlineMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DebugGui.getInstance().refreshZ88HardwareInfo();
                    DebugGui.getInstance().activateDebugCommandLine();
                    if (Z88.getInstance().getProcessor().isZ80ThreadRunning()) {
                        DebugGui.getInstance().displayCmdOutput("Z88 is currently running.");
                    } else {
                        CommandLine.getInstance().cmdlineFirstSingleStep();
                        DebugGui.getInstance().lockZ88MachinePanel(true);
                    }
                }
            });
        }
        return this.debugCmdlineMenuItem;
    }

    private JMenuItem getFileExitMenuItem() {
        if (this.fileExitMenuItem == null) {
            this.fileExitMenuItem = new JMenuItem();
            this.fileExitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            this.fileExitMenuItem.setMnemonic(69);
            this.fileExitMenuItem.setText("Exit");
        }
        return this.fileExitMenuItem;
    }

    private JMenuItem getBattLowIntMenuItem() {
        if (this.battLowIntMenuItem == null) {
            this.battLowIntMenuItem = new JMenuItem();
            this.battLowIntMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.blink.signalBattLow();
                }
            });
            this.battLowIntMenuItem.setText("Indicate Battery Low");
        }
        return this.battLowIntMenuItem;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.setText("View");
            this.viewMenu.add(this.getRtmMessagesMenuItem());
            this.viewMenu.add(this.getViewMemoryMenuItem());
        }
        return this.viewMenu;
    }

    public void displayZ88ScreenPane(boolean bl) {
        if (bl) {
            this.getContentPane().remove(this.getZ88ScreenPanel());
            this.addZ88ScreenPanel();
            this.getZ88Display().grabFocus();
        } else {
            this.getContentPane().remove(this.getZ88ScreenPanel());
            this.z88ScreenPanel = null;
        }
    }

    public void displayRunTimeMessagesPane(boolean bl) {
        OZvm.getInstance().getRtmMsgGui().setVisible(bl);
        this.getZ88Display().grabFocus();
    }

    public void displayZ88Keyboard(boolean bl) {
        if (bl) {
            this.getContentPane().remove(this.getKeyboardPanel());
            this.addKeyboardPanel();
        } else {
            this.getContentPane().remove(this.getKeyboardPanel());
        }
        this.getZ88Display().grabFocus();
    }

    public void displayZ88CardSlots(boolean bl) {
        if (bl) {
            this.getContentPane().remove(this.getSlotsPanel());
            this.addSlotsPanel();
            this.getSlotsPanel().refreshSlotInfo();
        } else {
            this.getContentPane().remove(this.getSlotsPanel());
        }
        this.getZ88Display().grabFocus();
    }

    public JCheckBoxMenuItem getRtmMessagesMenuItem() {
        if (this.rtmMessagesMenuItem == null) {
            this.rtmMessagesMenuItem = new JCheckBoxMenuItem();
            this.rtmMessagesMenuItem.setSelected(false);
            this.rtmMessagesMenuItem.setText("Runtime Messages");
            this.rtmMessagesMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.displayRunTimeMessagesPane(Gui.this.rtmMessagesMenuItem.isSelected());
                    Gui.this.pack();
                }
            });
        }
        return this.rtmMessagesMenuItem;
    }

    public JCheckBoxMenuItem getZ80CpuRealSpeedMenuItem() {
        if (this.z80CpuRealSpeedMenuItem == null) {
            this.z80CpuRealSpeedMenuItem = new JCheckBoxMenuItem();
            this.z80CpuRealSpeedMenuItem.setSelected(this.z80proc.isCpuRealSpeed());
            this.z80CpuRealSpeedMenuItem.setText("Z80 CPU 3.2768Mhz");
            this.z80CpuRealSpeedMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.z80proc.setCpuRealSpeed(Gui.this.z80CpuRealSpeedMenuItem.isSelected());
                }
            });
        }
        return this.z80CpuRealSpeedMenuItem;
    }

    public JMenuItem getViewMemoryMenuItem() {
        if (this.viewMemoryMenuItem == null) {
            this.viewMemoryMenuItem = new JMenuItem();
            this.viewMemoryMenuItem.setSelected(false);
            this.viewMemoryMenuItem.setText("View/edit memory");
            this.viewMemoryMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = JOptionPane.showInputDialog(null, "Enter extended address (eg. 073fc0): ", "View/Edit Z88 Memory", 3);
                    int n = Dz.stringAddr2Integer(string);
                    int n2 = n >>> 16 & 0xFF;
                    int n3 = n & 0x3FFF;
                    Z88.getInstance().getMemory().getBank(n2).editMemory(n3, n2);
                }
            });
        }
        return this.viewMemoryMenuItem;
    }

    private void addZ88ScreenPanel() {
        this.getContentPane().add(this.getZ88ScreenPanel());
    }

    private void addKeyboardPanel() {
        if (this.getKeyboardPanel().isVisible()) {
            this.getContentPane().add(this.getKeyboardPanel());
        }
    }

    private void addSlotsPanel() {
        this.getContentPane().add(this.getSlotsPanel());
    }

    private RubberKeyboard getKeyboardPanel() {
        if (this.keyboardPanel == null) {
            this.keyboardPanel = RubberKeyboard.getInstance();
            this.keyboardPanel.setKeyboardCountrySpecificIcons(Z88.getInstance().getKeyboard().getKeyboardLayout());
        }
        return this.keyboardPanel;
    }

    private JMenu getKeyboardMenu() {
        if (this.keyboardMenu == null) {
            this.keyboardMenu = new JMenu();
            this.keyboardMenu.setText("Keyboard");
            this.keyboardMenu.add(this.getShiftKeysMenuItem());
            this.keyboardMenu.add(this.getClearKbMatrixMenuItem());
            this.keyboardMenu.add(this.getUkLayoutMenuItem());
            this.keyboardMenu.add(this.getDkLayoutMenuItem());
            this.keyboardMenu.add(this.getFrLayoutMenuItem());
            this.keyboardMenu.add(this.getSeLayoutMenuItem());
            this.keyboardMenu.add(this.getShowRubberKbMenuItem());
        }
        return this.keyboardMenu;
    }

    public Slots getSlotsPanel() {
        if (this.slotsPanel == null) {
            this.slotsPanel = new Slots();
        }
        return this.slotsPanel;
    }

    private JMenuItem getShiftKeysMenuItem() {
        if (this.shiftKeysMenuItem == null) {
            this.shiftKeysMenuItem = new JMenuItem();
            this.shiftKeysMenuItem.setText("Press both SHIFT keys");
            this.shiftKeysMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
            this.shiftKeysMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Z88.getInstance().getKeyboard().typeShiftKeys();
                }
            });
        }
        return this.shiftKeysMenuItem;
    }

    private JMenuItem getClearKbMatrixMenuItem() {
        if (this.clearKbMatrixMenuItem == null) {
            this.clearKbMatrixMenuItem = new JMenuItem();
            this.clearKbMatrixMenuItem.setText("Reset Z88 Keyboard Matrix");
            this.clearKbMatrixMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Z88.getInstance().getKeyboard().resetKeyboardMatrix();
                }
            });
        }
        return this.clearKbMatrixMenuItem;
    }

    public JCheckBoxMenuItem getShowRubberKbMenuItem() {
        if (this.showRubberKbMenuItem == null) {
            this.showRubberKbMenuItem = new JCheckBoxMenuItem();
            this.showRubberKbMenuItem.setText("Show Rubber Keyboard");
            this.showRubberKbMenuItem.setState(true);
            this.showRubberKbMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.getKeyboardPanel().setVisible(Gui.this.showRubberKbMenuItem.isSelected());
                    Gui.this.redrawGuiWindows(Gui.this.getScreenDoubleSizeMenuItem().getState());
                }
            });
        }
        return this.showRubberKbMenuItem;
    }

    public JCheckBoxMenuItem getUkLayoutMenuItem() {
        if (this.ukLayoutMenuItem == null) {
            this.ukLayoutMenuItem = new JCheckBoxMenuItem();
            this.ukLayoutMenuItem.setText("English Layout");
            this.ukLayoutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(3);
                    Gui.this.getZ88Display().grabFocus();
                }
            });
            this.kbLayoutButtonGroup.add(this.ukLayoutMenuItem);
        }
        return this.ukLayoutMenuItem;
    }

    public JCheckBoxMenuItem getDkLayoutMenuItem() {
        if (this.dkLayoutMenuItem == null) {
            this.dkLayoutMenuItem = new JCheckBoxMenuItem();
            this.dkLayoutMenuItem.setText("Danish/Norwegian Layout");
            this.dkLayoutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(4);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(4);
                    Gui.this.getZ88Display().grabFocus();
                }
            });
            this.kbLayoutButtonGroup.add(this.dkLayoutMenuItem);
        }
        return this.dkLayoutMenuItem;
    }

    public JCheckBoxMenuItem getFrLayoutMenuItem() {
        if (this.frLayoutMenuItem == null) {
            this.frLayoutMenuItem = new JCheckBoxMenuItem();
            this.frLayoutMenuItem.setText("French Layout");
            this.frLayoutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(1);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(1);
                    Gui.this.getZ88Display().grabFocus();
                }
            });
            this.kbLayoutButtonGroup.add(this.frLayoutMenuItem);
        }
        return this.frLayoutMenuItem;
    }

    public JCheckBoxMenuItem getScreen10FpsMenuItem() {
        if (this.scr10FpsMenuItem == null) {
            this.scr10FpsMenuItem = new JCheckBoxMenuItem();
            this.scr10FpsMenuItem.setText("10 Frames Per Second");
            this.scr10FpsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.getZ88Display().setFrameRate(0);
                    Gui.this.getZ88Display().grabFocus();
                }
            });
            this.scrRefreshRateButtonGroup.add(this.scr10FpsMenuItem);
        }
        return this.scr10FpsMenuItem;
    }

    public JCheckBoxMenuItem getScreen25FpsMenuItem() {
        if (this.scr25FpsMenuItem == null) {
            this.scr25FpsMenuItem = new JCheckBoxMenuItem();
            this.scr25FpsMenuItem.setText("25 Frames Per Second");
            this.scr25FpsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.getZ88Display().setFrameRate(1);
                    Gui.this.getZ88Display().grabFocus();
                }
            });
            this.scrRefreshRateButtonGroup.add(this.scr25FpsMenuItem);
        }
        return this.scr25FpsMenuItem;
    }

    public JCheckBoxMenuItem getScreen50FpsMenuItem() {
        if (this.scr50FpsMenuItem == null) {
            this.scr50FpsMenuItem = new JCheckBoxMenuItem();
            this.scr50FpsMenuItem.setText("50 Frames Per Second");
            this.scr50FpsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.getZ88Display().setFrameRate(2);
                    Gui.this.getZ88Display().grabFocus();
                }
            });
            this.scrRefreshRateButtonGroup.add(this.scr50FpsMenuItem);
        }
        return this.scr50FpsMenuItem;
    }

    public JCheckBoxMenuItem getScreen100FpsMenuItem() {
        if (this.scr100FpsMenuItem == null) {
            this.scr100FpsMenuItem = new JCheckBoxMenuItem();
            this.scr100FpsMenuItem.setText("100 Frames Per Second");
            this.scr100FpsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.getZ88Display().setFrameRate(3);
                    Gui.this.getZ88Display().grabFocus();
                }
            });
            this.scrRefreshRateButtonGroup.add(this.scr100FpsMenuItem);
        }
        return this.scr100FpsMenuItem;
    }

    public JCheckBoxMenuItem getSeLayoutMenuItem() {
        if (this.seLayoutMenuItem == null) {
            this.seLayoutMenuItem = new JCheckBoxMenuItem();
            this.seLayoutMenuItem.setText("Swedish/Finish Layout");
            this.seLayoutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(5);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(5);
                    Gui.this.getZ88Display().grabFocus();
                }
            });
            this.kbLayoutButtonGroup.add(this.seLayoutMenuItem);
        }
        return this.seLayoutMenuItem;
    }

    private JMenuItem getLoadSnapshotMenuItem() {
        if (this.loadSnapshotMenuItem == null) {
            this.loadSnapshotMenuItem = new JMenuItem();
            this.loadSnapshotMenuItem.setText("Load Z88 snapshot");
            this.loadSnapshotMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    block8: {
                        boolean bl;
                        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
                        SaveRestoreVM saveRestoreVM = new SaveRestoreVM();
                        JFileChooser jFileChooser = new JFileChooser(fileSystemView.getHomeDirectory());
                        jFileChooser.setDialogTitle("Load/resume Z88 snapshot");
                        jFileChooser.setMultiSelectionEnabled(false);
                        jFileChooser.setFileSelectionMode(0);
                        jFileChooser.setFileFilter(saveRestoreVM.getSnapshotFilter());
                        if (Z88.getInstance().getProcessorThread() != null) {
                            bl = true;
                            Z88.getInstance().getProcessor().stopZ80Execution();
                            Gui.this.blink.awakeZ80();
                        } else {
                            bl = false;
                        }
                        int n = jFileChooser.showOpenDialog(Gui.this.getContentPane().getParent());
                        if (n == 0) {
                            String string = jFileChooser.getSelectedFile().getAbsolutePath();
                            try {
                                boolean bl2 = saveRestoreVM.loadSnapShot(string);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                                OZvm.displayRtmMessage("Snapshot successfully installed from " + string);
                                Gui.this.setWindowTitle("[" + jFileChooser.getSelectedFile().getName() + "]");
                                if (bl2) {
                                    Z88.getInstance().runZ80Cpu();
                                    break block8;
                                }
                                DebugGui.getInstance().activateDebugCommandLine();
                                CommandLine.getInstance().cmdlineFirstSingleStep();
                            }
                            catch (IOException iOException) {
                                Z88.getInstance().getMemory().setDefaultSystem();
                                Z88.getInstance().getProcessor().reset();
                                Gui.this.blink.resetBlinkRegisters();
                                OZvm.displayRtmMessage("Loading of snapshot '" + string + "' failed. Z88 preset to default system.");
                            }
                        } else if (bl) {
                            Z88.getInstance().runZ80Cpu();
                        }
                    }
                    Gui.this.getSlotsPanel().repaint();
                    Gui.this.pack();
                    Gui.this.redrawGuiWindows(Gui.this.getScreenDoubleSizeMenuItem().getState());
                    Gui.this.centerGui();
                    Z88.getInstance().getDisplay().grabFocus();
                }
            });
        }
        return this.loadSnapshotMenuItem;
    }

    private void centerGui() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray[0].getDefaultConfiguration().getBounds().x;
        int n2 = graphicsDeviceArray[0].getDefaultConfiguration().getBounds().y;
        int n3 = graphicsDeviceArray[0].getDefaultConfiguration().getBounds().width;
        int n4 = graphicsDeviceArray[0].getDefaultConfiguration().getBounds().height;
        int n5 = (n3 - this.getWidth()) / 2 + n;
        int n6 = (n4 - this.getHeight()) / 2 + n2;
        this.setLocation(n5, n6);
    }

    private JMenuItem getCreateSnapshotMenuItem() {
        if (this.createSnapshotMenuItem == null) {
            this.createSnapshotMenuItem = new JMenuItem();
            this.createSnapshotMenuItem.setText("Save Z88 snapshot");
            this.createSnapshotMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    FileSystemView fileSystemView = FileSystemView.getFileSystemView();
                    SaveRestoreVM saveRestoreVM = new SaveRestoreVM();
                    JFileChooser jFileChooser = new JFileChooser(fileSystemView.getHomeDirectory());
                    jFileChooser.setDialogTitle("Save Z88 snapshot");
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setFileFilter(saveRestoreVM.getSnapshotFilter());
                    jFileChooser.setSelectedFile(new File(OZvm.defaultVmFile));
                    if (Z88.getInstance().getProcessorThread() != null) {
                        bl = true;
                        Z88.getInstance().getProcessor().stopZ80Execution();
                        Gui.this.blink.awakeZ80();
                    } else {
                        bl = false;
                    }
                    int n = jFileChooser.showSaveDialog(Gui.this.getContentPane().getParent());
                    if (n == 0) {
                        String string = jFileChooser.getSelectedFile().getAbsolutePath();
                        try {
                            saveRestoreVM.storeSnapShot(string, bl);
                            OZvm.displayRtmMessage("Snapshot successfully created in " + string);
                            Gui.this.setWindowTitle("[" + jFileChooser.getSelectedFile().getName() + "]");
                        }
                        catch (IOException iOException) {
                            OZvm.displayRtmMessage("Creating snapshot '" + string + "' failed.");
                        }
                    }
                    Gui.this.getSlotsPanel().repaint();
                    if (bl) {
                        Z88.getInstance().runZ80Cpu();
                        Z88.getInstance().getDisplay().grabFocus();
                    }
                }
            });
        }
        return this.createSnapshotMenuItem;
    }

    private JMenu getZ88Menu() {
        if (this.z88Menu == null) {
            this.z88Menu = new JMenu();
            this.z88Menu.setText("Z88");
            this.z88Menu.add(this.getSoftResetMenuItem());
            this.z88Menu.add(this.getHardResetMenuItem());
            this.z88Menu.add(this.getInstallRomMenuItem());
            this.z88Menu.addSeparator();
            this.z88Menu.add(this.getDebugCmdlineMenuItem());
            this.z88Menu.add(this.getZ80CpuRealSpeedMenuItem());
            this.z88Menu.add(this.getBattLowIntMenuItem());
            this.z88Menu.add(this.getScreenRefreshRateMenu());
            this.z88Menu.add(this.getScreenDoubleSizeMenuItem());
        }
        return this.z88Menu;
    }

    public void redrawGuiWindows(boolean bl) {
        this.displayZ88ScreenPane(false);
        this.getZ88Display().setDoubleScreenSize(bl);
        this.displayZ88ScreenPane(true);
        if (bl) {
            this.displayZ88Keyboard(false);
            this.displayZ88CardSlots(false);
        } else {
            this.displayZ88Keyboard(true);
            this.displayZ88CardSlots(true);
        }
        this.pack();
        this.centerGui();
        if (bl) {
            if (this.zb == null) {
                this.zb = new Z88BodyGui(this.keyboardPanel, this.slotsPanel);
            } else {
                this.zb.dispose();
                this.zb = new Z88BodyGui(this.keyboardPanel, this.slotsPanel);
            }
        } else if (this.zb != null) {
            this.zb.dispose();
            this.zb = null;
        }
        this.toFront();
        this.getZ88Display().grabFocus();
    }

    public JCheckBoxMenuItem getScreenDoubleSizeMenuItem() {
        if (this.screenDoubleSizeMenuItem == null) {
            this.screenDoubleSizeMenuItem = new JCheckBoxMenuItem();
            this.screenDoubleSizeMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 0));
            this.screenDoubleSizeMenuItem.setText("Screen Double Size");
            this.screenDoubleSizeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.redrawGuiWindows(Gui.this.screenDoubleSizeMenuItem.getState());
                }
            });
        }
        return this.screenDoubleSizeMenuItem;
    }

    private JMenuItem getSoftResetMenuItem() {
        if (this.softResetMenuItem == null) {
            this.softResetMenuItem = new JMenuItem();
            this.softResetMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
            this.softResetMenuItem.setText("Soft Reset");
            this.softResetMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() == null) {
                        Z88.getInstance().runZ80Cpu();
                    }
                    if (JOptionPane.showConfirmDialog(Gui.this, "Soft Reset Z88?") == 0) {
                        Z88.getInstance().pressResetButton();
                    }
                }
            });
        }
        return this.softResetMenuItem;
    }

    private JMenuItem getHardResetMenuItem() {
        if (this.hardResetMenuItem == null) {
            this.hardResetMenuItem = new JMenuItem();
            this.hardResetMenuItem.setAccelerator(KeyStroke.getKeyStroke(120, 0));
            this.hardResetMenuItem.setText("Hard Reset");
            this.hardResetMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() == null) {
                        Z88.getInstance().runZ80Cpu();
                    }
                    Gui.this.blink.signalFlapOpened();
                    if (JOptionPane.showConfirmDialog(Gui.this, "Hard Reset Z88?") == 0) {
                        Z88.getInstance().hardReset();
                    }
                    Gui.this.blink.signalFlapClosed();
                }
            });
        }
        return this.hardResetMenuItem;
    }

    private JMenuItem getInstallRomMenuItem() {
        if (this.installRomMenuItem == null) {
            this.installRomMenuItem = new JMenu();
            this.installRomMenuItem.setText("Install ROM in Slot 0");
            this.installRomMenuItem.add(this.getInstallOz47Rom());
            this.installRomMenuItem.add(this.getInstallOz46Rom());
            this.installRomMenuItem.add(this.getInstallOz45Rom());
            this.installRomMenuItem.add(this.getInstallOz44Rom());
            this.installRomMenuItem.add(this.getInstallOz43Rom());
            this.installRomMenuItem.add(this.getInstallUk400Rom());
            this.installRomMenuItem.add(this.getInstallUk300Rom());
            this.installRomMenuItem.add(this.getInstallUk220Rom());
            this.installRomMenuItem.add(this.getInstallFr326Rom());
            this.installRomMenuItem.add(this.getInstallEs319Rom());
            this.installRomMenuItem.add(this.getInstallDe318Rom());
            this.installRomMenuItem.add(this.getInstallIt323Rom());
            this.installRomMenuItem.add(this.getInstallDk321Rom());
            this.installRomMenuItem.add(this.getInstallSe250Rom());
            this.installRomMenuItem.add(this.getInstallNo260Rom());
            this.installRomMenuItem.add(this.getInstallFi401Rom());
            this.installRomMenuItem.add(this.getInstallHe313Rom());
            this.installRomMenuItem.add(this.getInstallTk317Rom());
        }
        return this.installRomMenuItem;
    }

    private JMenuItem getInstallOz43Rom() {
        if (this.installOz43RomMenuItem == null) {
            this.installOz43RomMenuItem = new JMenuItem();
            this.installOz43RomMenuItem.setText("OZ V4.3.1 ROM");
            this.installOz43RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install OZ V4.3.1 ROM in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88OZ431.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installOz43RomMenuItem;
    }

    private JMenuItem getInstallOz44Rom() {
        if (this.installOz44RomMenuItem == null) {
            this.installOz44RomMenuItem = new JMenuItem();
            this.installOz44RomMenuItem.setText("OZ V4.4 ROM");
            this.installOz44RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install OZ V4.4 ROM in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88OZ441.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installOz44RomMenuItem;
    }

    private JMenuItem getInstallOz45Rom() {
        if (this.installOz45RomMenuItem == null) {
            this.installOz45RomMenuItem = new JMenuItem();
            this.installOz45RomMenuItem.setText("OZ V4.5 ROM");
            this.installOz45RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install OZ V4.5 ROM in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88OZ45.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installOz45RomMenuItem;
    }

    private JMenuItem getInstallOz46Rom() {
        if (this.installOz46RomMenuItem == null) {
            this.installOz46RomMenuItem = new JMenuItem();
            this.installOz46RomMenuItem.setText("OZ V4.6 ROM");
            this.installOz46RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install OZ V4.6 ROM in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88OZ46.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installOz46RomMenuItem;
    }

    private JMenuItem getInstallOz47Rom() {
        if (this.installOz47RomMenuItem == null) {
            this.installOz47RomMenuItem = new JMenuItem();
            this.installOz47RomMenuItem.setText("OZ V4.7 ROM");
            this.installOz47RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install OZ V4.7 ROM in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88OZ47.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installOz47RomMenuItem;
    }

    private JMenuItem getInstallUk400Rom() {
        if (this.installUk400RomMenuItem == null) {
            this.installUk400RomMenuItem = new JMenuItem();
            this.installUk400RomMenuItem.setText("British OZ V4.0 ROM");
            this.installUk400RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install British OZ V4.0 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88UK400.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installUk400RomMenuItem;
    }

    private JMenuItem getInstallUk300Rom() {
        if (this.installUk300RomMenuItem == null) {
            this.installUk300RomMenuItem = new JMenuItem();
            this.installUk300RomMenuItem.setText("British OZ V3.0 ROM");
            this.installUk300RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install British OZ V3.0 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88UK300.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installUk300RomMenuItem;
    }

    private JMenuItem getInstallUk220Rom() {
        if (this.installUk220RomMenuItem == null) {
            this.installUk220RomMenuItem = new JMenuItem();
            this.installUk220RomMenuItem.setText("British OZ V2.2 ROM");
            this.installUk220RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install British OZ V2.2 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88UK220.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installUk220RomMenuItem;
    }

    private JMenuItem getInstallFr326Rom() {
        if (this.installFr326RomMenuItem == null) {
            this.installFr326RomMenuItem = new JMenuItem();
            this.installFr326RomMenuItem.setText("French OZ V3.26 ROM");
            this.installFr326RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install French OZ V3.26 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88FR326.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(1);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installFr326RomMenuItem;
    }

    private JMenuItem getInstallEs319Rom() {
        if (this.installEs319RomMenuItem == null) {
            this.installEs319RomMenuItem = new JMenuItem();
            this.installEs319RomMenuItem.setText("Spanish OZ V3.19 ROM");
            this.installEs319RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install Spanish OZ V3.19 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88ES319.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installEs319RomMenuItem;
    }

    private JMenuItem getInstallDe318Rom() {
        if (this.installDe318RomMenuItem == null) {
            this.installDe318RomMenuItem = new JMenuItem();
            this.installDe318RomMenuItem.setText("German OZ V3.18 ROM");
            this.installDe318RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install German OZ V3.18 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88DE318.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installDe318RomMenuItem;
    }

    private JMenuItem getInstallIt323Rom() {
        if (this.installIt323RomMenuItem == null) {
            this.installIt323RomMenuItem = new JMenuItem();
            this.installIt323RomMenuItem.setText("Italian OZ V3.23 ROM");
            this.installIt323RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install Italian OZ V3.23 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88IT323.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installIt323RomMenuItem;
    }

    private JMenuItem getInstallDk321Rom() {
        if (this.installDk321RomMenuItem == null) {
            this.installDk321RomMenuItem = new JMenuItem();
            this.installDk321RomMenuItem.setText("Danish OZ V3.21 ROM");
            this.installDk321RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install Danish OZ V3.21 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88DK321.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(4);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installDk321RomMenuItem;
    }

    private JMenuItem getInstallSe250Rom() {
        if (this.installSe250RomMenuItem == null) {
            this.installSe250RomMenuItem = new JMenuItem();
            this.installSe250RomMenuItem.setText("Swedish OZ V2.50 ROM");
            this.installSe250RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install Swedish OZ V2.50 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88SE250.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(5);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installSe250RomMenuItem;
    }

    private JMenuItem getInstallNo260Rom() {
        if (this.installNo260RomMenuItem == null) {
            this.installNo260RomMenuItem = new JMenuItem();
            this.installNo260RomMenuItem.setText("Norwegian OZ V2.60 ROM");
            this.installNo260RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install Norwegian OZ V2.60 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88NO260.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(4);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installNo260RomMenuItem;
    }

    private JMenuItem getInstallFi401Rom() {
        if (this.installFi401RomMenuItem == null) {
            this.installFi401RomMenuItem = new JMenuItem();
            this.installFi401RomMenuItem.setText("Finnish OZ V4.01 ROM");
            this.installFi401RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install Finnish OZ V4.01 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88FI401.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(5);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installFi401RomMenuItem;
    }

    private JMenuItem getInstallHe313Rom() {
        if (this.installHe313RomMenuItem == null) {
            this.installHe313RomMenuItem = new JMenuItem();
            this.installHe313RomMenuItem.setText("Swiss OZ V3.13 ROM");
            this.installHe313RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install Swiss OZ V3.13 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88HE313.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installHe313RomMenuItem;
    }

    private JMenuItem getInstallTk317Rom() {
        if (this.installTk317RomMenuItem == null) {
            this.installTk317RomMenuItem = new JMenuItem();
            this.installTk317RomMenuItem.setText("Turkish OZ V3.17 ROM");
            this.installTk317RomMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Z88.getInstance().getProcessorThread() != null) {
                        Gui.this.blink.signalFlapOpened();
                        if (JOptionPane.showConfirmDialog(Gui.this, "Install Turkish OZ V3.17 in slot 0?") == 0) {
                            try {
                                File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88TK317.rom"));
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Gui.this.getUkLayoutMenuItem().setSelected(true);
                                Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                                Z88.getInstance().hardResetWithSlot0Rom(file);
                                Gui.this.getSlotsPanel().refreshSlotInfo();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Gui.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                        Gui.this.blink.signalFlapClosed();
                    } else {
                        JOptionPane.showMessageDialog(Gui.this, "Z88 is not running");
                    }
                }
            });
        }
        return this.installTk317RomMenuItem;
    }

    private JMenu getScreenRefreshRateMenu() {
        if (this.screenRefrashRateMenu == null) {
            this.screenRefrashRateMenu = new JMenu();
            this.screenRefrashRateMenu.setText("Screen Fresh Rate");
            this.screenRefrashRateMenu.add(this.getScreen10FpsMenuItem());
            this.screenRefrashRateMenu.add(this.getScreen25FpsMenuItem());
            this.screenRefrashRateMenu.add(this.getScreen50FpsMenuItem());
            this.screenRefrashRateMenu.add(this.getScreen100FpsMenuItem());
        }
        return this.screenRefrashRateMenu;
    }

    private JMenu getCreateScreenMenu() {
        if (this.screenMenu == null) {
            this.screenMenu = new JMenu();
            this.screenMenu.setText("Create Screen");
            this.screenMenu.add(this.getCreateScreenSnapshotMenuItem());
            this.screenMenu.add(this.getCreateGifMovieMenuItem());
        }
        return this.screenMenu;
    }

    private JMenuItem getCreateScreenSnapshotMenuItem() {
        if (this.screenSnapshotMenuItem == null) {
            this.screenSnapshotMenuItem = new JMenuItem();
            this.screenSnapshotMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.getZ88Display().grabScreenFrameToFile();
                }
            });
            this.screenSnapshotMenuItem.setText("Snapshot");
        }
        return this.screenSnapshotMenuItem;
    }

    private JMenuItem getCreateGifMovieMenuItem() {
        if (this.gifMovieMenuItem == null) {
            this.gifMovieMenuItem = new JMenuItem();
            this.gifMovieMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Gui.this.getZ88Display().toggleMovieRecording();
                }
            });
            this.gifMovieMenuItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
            this.gifMovieMenuItem.setText("Gif movie (start/stop)");
        }
        return this.gifMovieMenuItem;
    }

    public void setWindowTitle(String string) {
        this.setTitle("OZvm V1.2  " + string);
    }

    private void initialize() {
        this.zb = null;
        this.blink = Z88.getInstance().getBlink();
        this.z80proc = Z88.getInstance().getProcessor();
        this.kbLayoutButtonGroup = new ButtonGroup();
        this.scrRefreshRateButtonGroup = new ButtonGroup();
        this.setResizable(false);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/pixel/title.gif")).getImage());
        this.setJMenuBar(this.getMainMenuBar());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setBackground(Color.BLACK);
        this.getContentPane().add(this.getToolBar());
        this.displayZ88ScreenPane(true);
        this.setWindowTitle("");
        switch (this.getZ88Display().getCurrentFrameRate()) {
            case 0: {
                this.getScreen10FpsMenuItem().setSelected(true);
                break;
            }
            case 1: {
                this.getScreen25FpsMenuItem().setSelected(true);
                break;
            }
            case 2: {
                this.getScreen50FpsMenuItem().setSelected(true);
                break;
            }
            case 3: {
                this.getScreen100FpsMenuItem().setSelected(true);
            }
        }
        switch (Z88.getInstance().getKeyboard().getKeyboardLayout()) {
            case 0: 
            case 3: {
                this.getUkLayoutMenuItem().setSelected(true);
                break;
            }
            case 5: {
                this.getSeLayoutMenuItem().setSelected(true);
                break;
            }
            case 4: {
                this.getDkLayoutMenuItem().setSelected(true);
                break;
            }
            case 1: {
                this.getFrLayoutMenuItem().setSelected(true);
                break;
            }
            default: {
                this.getUkLayoutMenuItem().setSelected(true);
            }
        }
    }
}

