/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.Z88Info;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class LogZ80Instruction {
    private static final int BUFSIZE = 100000;
    private int[] pcAddressCache = new int[100000];
    private int[][] registerCache = new int[100000][8];
    private int index;
    private int logFileCounter;

    public boolean isCacheAvailable() {
        return this.index != 0;
    }

    public void logInstruction(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.index == 100000) {
            this.flushCache();
        }
        this.pcAddressCache[this.index] = n;
        this.registerCache[this.index][0] = n2;
        this.registerCache[this.index][1] = n3;
        this.registerCache[this.index][2] = n4;
        this.registerCache[this.index][3] = n5;
        this.registerCache[this.index][4] = n6;
        this.registerCache[this.index][5] = n7;
        this.registerCache[this.index][6] = n8;
        this.registerCache[this.index][7] = n9;
        ++this.index;
    }

    public void flushCache() {
        Dz dz = Dz.getInstance();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("z80_" + this.logFileCounter++ + ".log"));
            StringBuffer stringBuffer = new StringBuffer(64);
            StringBuffer stringBuffer2 = new StringBuffer(128);
            int n = 0;
            while (n < this.index) {
                int n2 = this.pcAddressCache[n] >>> 16 & 0xFF;
                int n3 = this.pcAddressCache[n] & 0xFFFF;
                dz.getInstrAscii(stringBuffer, this.registerCache[n][7], n3, n2, false, true);
                stringBuffer2.append(Dz.extAddrToHex(this.pcAddressCache[n] & 0xFF0000 | this.pcAddressCache[n] & 0xFFFF | this.registerCache[n][7], false));
                stringBuffer2.append(" ");
                stringBuffer2.append(stringBuffer);
                int n4 = 31 - stringBuffer.length();
                while (n4 > 0) {
                    stringBuffer2.append(" ");
                    --n4;
                }
                stringBuffer2.append(Z88Info.quickZ80Dump(this.registerCache[n][0], this.registerCache[n][1], this.registerCache[n][2], this.registerCache[n][3], this.registerCache[n][4], this.registerCache[n][5], this.registerCache[n][6]));
                stringBuffer2.append(System.getProperty("line.separator"));
                bufferedWriter.write(stringBuffer2.toString());
                stringBuffer2.delete(0, 127);
                ++n;
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
        this.index = 0;
    }
}

