/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.AmdFlashBank;
import com.jira.cambridgez88.ozvm.AmicFlashBank;
import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.EpromBank;
import com.jira.cambridgez88.ozvm.IntelFlashBank;
import com.jira.cambridgez88.ozvm.OZvm;
import com.jira.cambridgez88.ozvm.RamBank;
import com.jira.cambridgez88.ozvm.RomBank;
import com.jira.cambridgez88.ozvm.VoidBank;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.datastructures.SlotInfo;
import com.jira.cambridgez88.ozvm.filecard.FileArea;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;

public final class Memory {
    private Bank[] memory = new Bank[256];
    private VoidBank nullBank = new VoidBank();
    private File loadedRomFile;

    public Memory() {
        this.setVoidMemory();
    }

    public final Bank getBank(int n) {
        return this.memory[n & 0xFF];
    }

    public final void setBank(Bank bank, int n) {
        bank.setBankNumber(n);
        this.memory[n & 0xFF] = bank;
    }

    public void setByte(int n, int n2, int n3) {
        this.getBank(n2).setByte(n, n3);
    }

    public void setByte(int n, int n2) {
        this.setByte(n & 0x3FFF, n >>> 16, n2);
    }

    public void setBreakpoint(int n) {
        this.getBank(n >>> 16).setBreakpoint(n);
    }

    public void clearBreakpoint(int n) {
        this.getBank(n >>> 16).clearBreakpoint(n);
    }

    public void clearWatchpoint(int n) {
        this.getBank(n >>> 16).clearReadWatchpoint(n);
        this.getBank(n >>> 16).clearWriteWatchpoint(n);
    }

    public void clearReadWatchpoint(int n) {
        this.getBank(n >>> 16).clearReadWatchpoint(n);
    }

    public void clearWriteWatchpoint(int n) {
        this.getBank(n >>> 16).clearWriteWatchpoint(n);
    }

    public void setWatchpoint(int n) {
        this.getBank(n >>> 16).setReadWatchpoint(n);
        this.getBank(n >>> 16).setWriteWatchpoint(n);
    }

    public void setReadWatchpoint(int n) {
        this.getBank(n >>> 16).setReadWatchpoint(n);
    }

    public void setWriteWatchpoint(int n) {
        this.getBank(n >>> 16).setWriteWatchpoint(n);
    }

    public int getByte(int n) {
        return this.getByte(n & 0x3FFF, n >>> 16);
    }

    public int getByte(int n, int n2) {
        return this.getBank(n2).getByte(n);
    }

    public int getNextExtAddress(int n) {
        int n2 = n & 0xC000;
        int n3 = n & 0x3FFF;
        int n4 = n >>> 16;
        if (n3 == 16383) {
            n3 = 0;
            ++n4;
        } else {
            ++n3;
        }
        n3 = n2 | n3;
        return n4 << 16 | n3;
    }

    public void insertCard(Bank[] bankArray, int n) {
        int n2;
        int n3;
        if (n == 0) {
            n3 = bankArray[0] instanceof RamBank ? 32 : 0;
            n2 = 32;
        } else {
            n3 = n << 6;
            n2 = 64;
        }
        int n4 = 0;
        while (n4 < bankArray.length) {
            this.setBank(bankArray[n4], n3++);
            --n2;
            ++n4;
        }
        while (n2 > 0) {
            n4 = 0;
            while (n4 < bankArray.length) {
                this.memory[n3++] = bankArray[n4];
                --n2;
                ++n4;
            }
        }
        if (n > 0) {
            this.slotConnectorSenseLine();
        }
        if (bankArray[bankArray.length - 1].getByte(16382) == 79 & bankArray[bankArray.length - 1].getByte(16383) == 90) {
            OZvm.displayRtmMessage("Application Card was inserted into slot " + n);
        } else if (bankArray[bankArray.length - 1].getByte(16382) == 111 & bankArray[bankArray.length - 1].getByte(16383) == 122) {
            OZvm.displayRtmMessage("File Card was inserted into slot " + n);
        }
        Z88.getInstance().getProcessor().getBreakpoints().installBreakpoints();
    }

    public Bank[] removeCard(int n) {
        Bank[] bankArray = new Bank[this.getExternalCardSize(n)];
        int n2 = (n & 3) << 6;
        int n3 = n2 | 0x3F;
        int n4 = 0;
        while (n4 < bankArray.length) {
            bankArray[n4] = this.memory[n2 + n4];
            ++n4;
        }
        while (n2 <= n3) {
            this.memory[n2++] = this.nullBank;
        }
        this.slotConnectorSenseLine();
        return bankArray;
    }

    public void dumpSlot(int n, boolean bl, String string, String string2) throws IOException, FileNotFoundException {
        if ((n &= 3) == 0) {
            this.dumpBanksToFile(0, this.getInternalRomSize() - 1, string, "rom.bin");
            this.dumpBanksToFile(32, 32 + this.getInternalRamSize() - 1, string, "ram.bin");
        } else if (!this.isSlotEmpty(n)) {
            if (!bl) {
                int n2;
                int n3 = n << 6;
                switch (SlotInfo.getInstance().getCardType(n)) {
                    case 8: 
                    case 9: {
                        n2 = n << 6 | 0x3F;
                        n3 = n2 - 31;
                        break;
                    }
                    default: {
                        n2 = n3 + (this.getExternalCardSize(n) - 1);
                    }
                }
                this.dumpBanksToFile(n3, n2, string, string2);
            } else {
                int n4 = (n & 3) << 6 | 0x3F;
                int n5 = n4 - (this.getExternalCardSize(n) - 1);
                int n6 = n4;
                while (n6 >= n5) {
                    if (SlotInfo.getInstance().getCardType(n) == 2) {
                        this.dumpBanksToFile(n6, n6, string, String.valueOf(string2) + "." + (n6 & 0x3F));
                    } else if (!this.getBank(n6).isEmpty()) {
                        this.dumpBanksToFile(n6, n6, string, String.valueOf(string2) + "." + (n6 & 0x3F));
                    }
                    --n6;
                }
                this.createRomUpdCfgFile(n, string, string2);
            }
        }
    }

    public boolean createRomUpdCfgFile(int n, String string, String string2) {
        int n2 = 0;
        int n3 = this.getExternalCardSize(n);
        if (SlotInfo.getInstance().isOzRom(n)) {
            int n4 = (n & 3) << 6 | 0x3F;
            int n5 = n4 - (n3 - 1);
            int n6 = n4;
            while (n6 >= n5) {
                if (!this.getBank(n6).isEmpty()) {
                    ++n2;
                }
                --n6;
            }
            try {
                File file = new File(String.valueOf(string) + File.separator + "romupdate.cfg");
                file.delete();
                RandomAccessFile randomAccessFile = new RandomAccessFile(String.valueOf(string) + File.separator + "romupdate.cfg", "rw");
                randomAccessFile.writeBytes("CFG.V4\n");
                randomAccessFile.writeBytes("; total amount of banks to update in card.\n");
                randomAccessFile.writeBytes("CD," + n2 + "\n");
                randomAccessFile.writeBytes("; Bank file, CRC, destination bank to update (in slot " + n + ").\n");
                int n7 = n5;
                while (n7 <= n4) {
                    if (!this.getBank(n7).isEmpty()) {
                        randomAccessFile.writeBytes("\"" + string2 + "." + (n7 & 0x3F) + "\",");
                        randomAccessFile.writeBytes("$" + Long.toHexString(this.getBank(n7).getCRC32()) + ",");
                        randomAccessFile.writeBytes("$" + Dz.byteToHex(n7 & 0x3F, false) + "\n");
                    }
                    ++n7;
                }
                randomAccessFile.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void dumpBanksToFile(int n, int n2, String string, String string2) throws IOException, FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(String.valueOf(string) + File.separator + string2, "rw");
        int n3 = n;
        while (n3 <= n2) {
            if (this.getBank(n3) != null) {
                randomAccessFile.write(this.getBank(n3).dumpBytes(0, 16384));
            }
            ++n3;
        }
        randomAccessFile.close();
    }

    public boolean isSlotEmpty(int n) {
        if (n == 0) {
            return false;
        }
        int n2 = (n & 3) << 6;
        return this.getBank(n2) instanceof VoidBank;
    }

    public void setDefaultSystem() {
        this.setVoidMemory();
        try {
            File file = new File(URI.create("file:" + OZvm.getInstance().getAppPath() + "roms/Z88UK400.rom"));
            this.loadRomBinary(file);
            Z88.getInstance().getBlink().setRAMS(this.getBank(0));
            this.insertRamCard(128, 0);
        }
        catch (IOException iOException) {}
    }

    public void setVoidMemory() {
        int n = 0;
        while (n < this.memory.length) {
            this.memory[n] = this.nullBank;
            ++n;
        }
    }

    public void resetRam() {
        int n = 0;
        while (n < this.memory.length) {
            if (this.memory[n] instanceof RamBank) {
                int n2 = 0;
                while (n2 < 16384) {
                    this.memory[n].setByte(n2, 0);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private Bank[] createCard(int n, int n2) {
        n -= n % 16;
        int n3 = n / 16;
        Bank[] bankArray = new Bank[n3];
        switch (n2) {
            case 8: {
                Bank[] bankArray2 = this.createCard(512, 2);
                Bank[] bankArray3 = this.createCard(512, 5);
                System.arraycopy(bankArray2, 0, bankArray, 0, bankArray2.length);
                System.arraycopy(bankArray3, 0, bankArray, bankArray2.length, bankArray3.length);
                break;
            }
            case 9: {
                Bank[] bankArray4 = this.createCard(512, 2);
                Bank[] bankArray5 = this.createCard(512, 6);
                System.arraycopy(bankArray4, 0, bankArray, 0, bankArray4.length);
                System.arraycopy(bankArray5, 0, bankArray, bankArray4.length, bankArray5.length);
                break;
            }
            default: {
                int n4 = 0;
                while (n4 < n3) {
                    block4 : switch (n2) {
                        case 2: {
                            bankArray[n4] = new RamBank();
                            break;
                        }
                        case 3: {
                            if (n3 <= 2) {
                                bankArray[n4] = new EpromBank(126);
                                break;
                            }
                            bankArray[n4] = new EpromBank(124);
                            break;
                        }
                        case 4: {
                            switch (n3) {
                                case 32: {
                                    bankArray[n4] = new IntelFlashBank(167);
                                    break block4;
                                }
                                case 64: {
                                    bankArray[n4] = new IntelFlashBank(166);
                                    break block4;
                                }
                            }
                            return null;
                        }
                        case 5: {
                            switch (n3) {
                                case 8: {
                                    bankArray[n4] = new AmdFlashBank(32);
                                    break block4;
                                }
                                case 32: {
                                    bankArray[n4] = new AmdFlashBank(164);
                                    break block4;
                                }
                                case 64: {
                                    bankArray[n4] = new AmdFlashBank(213);
                                    break block4;
                                }
                            }
                            return null;
                        }
                        case 6: {
                            switch (n3) {
                                case 32: {
                                    bankArray[n4] = new AmicFlashBank();
                                    break block4;
                                }
                            }
                            return null;
                        }
                        default: {
                            bankArray[n4] = new RomBank();
                        }
                    }
                    ++n4;
                }
                break block0;
            }
        }
        return bankArray;
    }

    public boolean insertEprCard(int n, int n2, int n3) {
        n %= 4;
        Bank[] bankArray = this.createCard(n2, n3);
        if (bankArray != null) {
            this.insertCard(bankArray, n);
            return true;
        }
        return false;
    }

    public boolean insertRamAmdCard(int n) {
        if ((n %= 4) == 0) {
            return false;
        }
        Bank[] bankArray = this.createCard(1024, 8);
        if (bankArray != null) {
            this.insertCard(bankArray, n);
            return true;
        }
        return false;
    }

    public boolean insertRamAmicCard(int n) {
        if ((n %= 4) == 0) {
            return false;
        }
        Bank[] bankArray = this.createCard(1024, 9);
        if (bankArray != null) {
            this.insertCard(bankArray, n);
            return true;
        }
        return false;
    }

    public boolean insertFileCard(int n, int n2, int n3) {
        if (this.insertEprCard(n, n2, n3)) {
            return FileArea.create(n, true);
        }
        return false;
    }

    public void insertRamCard(int n, int n2) {
        Bank[] bankArray;
        if ((bankArray = this.createCard(n -= n % 16, 2)) != null) {
            this.insertCard(bankArray, n2 & 3);
        }
    }

    public void loadFileImageOnCard(int n, int n2, int n3, File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n4 = (int)randomAccessFile.length();
        randomAccessFile.close();
        if (n4 > 1024 * n2) {
            throw new IOException("Binary image larger than specified Card size!");
        }
        if (n4 % 16384 > 0) {
            throw new IOException("Binary image must be in 16K sizes!");
        }
        Bank[] bankArray = this.createCard(n2, n3);
        if (bankArray == null) {
            throw new IOException("Illegal card type or size!");
        }
        this.loadBinaryImageIntoContainer(bankArray, n4, new FileInputStream(file));
        this.insertCard(bankArray, n & 3);
    }

    public void loadFileImagesOnCard(int n, int n2, int n3, File[] fileArray) throws IOException {
        Bank[] bankArray;
        if ((bankArray = this.createCard(n2 -= n2 % 16, n3)) == null) {
            throw new IOException("Illegal card type or size!");
        }
        int n4 = 0;
        while (n4 < fileArray.length) {
            if (fileArray[n4].isFile()) {
                RandomAccessFile randomAccessFile = new RandomAccessFile(fileArray[n4], "r");
                int n5 = (int)randomAccessFile.length();
                randomAccessFile.close();
                if (n5 > 16384) {
                    this.loadBinaryImageIntoContainer(bankArray, n5, new FileInputStream(fileArray[n4]));
                } else {
                    int n6;
                    try {
                        String string = fileArray[n4].getName();
                        n6 = Integer.parseInt(string.substring(string.lastIndexOf(".") + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n6 = 63;
                    }
                    if (n6 < 0 | n6 > 63) {
                        throw new IOException("Illegal bank file number (must be 0-63)!");
                    }
                    int n7 = bankArray.length - 1 - (63 - n6);
                    if (n7 >= 0) {
                        this.loadBankBinary(bankArray[n7], 0, fileArray[n4]);
                    }
                }
            }
            ++n4;
        }
        this.insertCard(bankArray, n & 3);
    }

    public void loadBankFilesOnCard(int n, int n2, int n3, String string) throws IOException {
        BankFilesFilter bankFilesFilter;
        Bank[] bankArray;
        if ((bankArray = this.createCard(n2 -= n2 % 16, n3)) == null) {
            throw new IOException("Illegal card type or size!");
        }
        File file = new File(new File(string).getParent());
        String[] stringArray = file.list(bankFilesFilter = new BankFilesFilter(new File(string).getName()));
        if (stringArray != null) {
            int n4 = 0;
            while (n4 < stringArray.length) {
                block7: {
                    int n5;
                    try {
                        n5 = Integer.parseInt(stringArray[n4].substring(stringArray[n4].lastIndexOf(".") + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block7;
                    }
                    if (n5 < 0 | n5 > 63) {
                        throw new IOException("Illegal bank file number (must be 0-63)!");
                    }
                    int n6 = bankArray.length - 1 - (63 - n5);
                    if (n6 >= 0) {
                        this.loadBankBinary(bankArray[n6], 0, new File(file.getAbsoluteFile() + File.separator + stringArray[n4]));
                    }
                }
                ++n4;
            }
        }
        this.insertCard(bankArray, n & 3);
    }

    public void loadBankBinary(Bank bank, int n, File file) throws IOException {
        if (bank instanceof VoidBank) {
            throw new IOException("Bank is part of empty slot!");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        if ((long)n + randomAccessFile.length() > 16384L) {
            randomAccessFile.close();
            throw new IOException("File image exceeds Bank boundary!");
        }
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(byArray);
        randomAccessFile.close();
        bank.loadBytes(byArray, n);
    }

    public void loadCardBinary(int n, int n2, File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n3 = (int)randomAccessFile.length();
        randomAccessFile.close();
        this.loadCardBinary(n, n3, n2, new FileInputStream(file));
    }

    public void loadCardBinary(int n, int n2, int n3, InputStream inputStream) throws IOException {
        if ((n &= 3) == 0 & n2 > 524288) {
            throw new IllegalArgumentException("Max 512K size for RAM or ROM in slot 0!");
        }
        if (n > 0 & n2 > 0x100000) {
            throw new IllegalArgumentException("Max 1024K size for card binary in slots 1-3!");
        }
        if (n2 % 16384 > 0) {
            throw new IllegalArgumentException("Card binary must be in 16K sizes!");
        }
        Bank[] bankArray = this.createCard(n2 / 1024, n3);
        if (bankArray == null) {
            throw new IOException("Illegal card type or size!");
        }
        this.loadBinaryImageIntoContainer(bankArray, n2, inputStream);
        this.insertCard(bankArray, n);
    }

    private void loadBinaryImageIntoContainer(Bank[] bankArray, int n, InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 16384);
        byte[] byArray = new byte[16384];
        int n2 = bankArray.length - n / 16384;
        while (n2 < bankArray.length) {
            bufferedInputStream.read(byArray, 0, 16384);
            bankArray[n2].loadBytes(byArray, 0);
            ++n2;
        }
        bufferedInputStream.close();
    }

    public File getLoadedRomFile() {
        return this.loadedRomFile;
    }

    public void loadRomBinary(File file) throws IOException, IllegalArgumentException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        int n = (int)randomAccessFile.length();
        randomAccessFile.close();
        this.loadRomBinary(n, new FileInputStream(file));
        this.loadedRomFile = file;
    }

    public void loadRomBinary(int n, InputStream inputStream) throws IOException, IllegalArgumentException {
        if (n > 524288) {
            throw new IllegalArgumentException("Max 512K ROM!");
        }
        if (n % 16384 > 0) {
            throw new IllegalArgumentException("ROM must be in 16K sizes!");
        }
        if (n % 32768 > 0) {
            throw new IllegalArgumentException("ROM must be in even banks!");
        }
        Bank[] bankArray = n / 16384 == 32 ? this.createCard(n / 1024, 5) : this.createCard(n / 1024, 1);
        this.loadBinaryImageIntoContainer(bankArray, n, inputStream);
        boolean bl = false;
        int n2 = bankArray.length - 1;
        while (n2 >= 0) {
            if (bankArray[n2].getByte(16379) == 129 & bankArray[n2].getByte(16382) == 79 & bankArray[n2].getByte(16383) == 90) {
                bl = true;
                break;
            }
            --n2;
        }
        if (!bl) {
            throw new IllegalArgumentException("This is not a Z88 ROM");
        }
        this.insertCard(bankArray, 0);
    }

    public int getInternalRomSize() {
        int n = 1;
        int n2 = 0;
        Bank bank = this.getBank(n2);
        while (++n2 <= 31) {
            if (this.getBank(n2) == bank) break;
            ++n;
        }
        return n;
    }

    public int getInternalRamSize() {
        int n = 1;
        int n2 = 32;
        Bank bank = this.getBank(n2);
        while (++n2 <= 63) {
            if (this.getBank(n2) == bank) break;
            ++n;
        }
        return n;
    }

    public int getExternalCardSize(int n) {
        int n2 = -1;
        int n3 = (n & 3) << 6 | 0x3F;
        if (this.isSlotEmpty(n)) {
            return -1;
        }
        Bank bank = this.getBank(n3);
        if (bank instanceof AmdFlashBank) {
            AmdFlashBank amdFlashBank = (AmdFlashBank)bank;
            switch (amdFlashBank.getDeviceCode()) {
                case 32: {
                    return 8;
                }
                case 164: {
                    return 32;
                }
                case 213: {
                    return 64;
                }
            }
        }
        if (bank instanceof AmicFlashBank) {
            return 32;
        }
        if (bank instanceof IntelFlashBank) {
            return 64;
        }
        if (n > 0) {
            int n4 = 64;
            n2 = 1;
            while (--n4 > 0) {
                if (this.getBank(--n3) == bank) break;
                ++n2;
            }
        }
        return n2;
    }

    private void slotConnectorSenseLine() {
    }

    private class BankFilesFilter
    implements FilenameFilter {
        String baseName = null;

        public BankFilesFilter(String string) {
            this.baseName = string.toLowerCase();
        }

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().startsWith(this.baseName);
        }
    }
}

