/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.LogZ80Instruction;
import com.jira.cambridgez88.ozvm.OZvm;
import java.util.concurrent.TimeUnit;

public abstract class Z80 {
    private int tstatesCounter = 0;
    private LogZ80Instruction lgZ80;
    private boolean logZ80instructions;
    private boolean nmi = false;
    private boolean cpuRealSpeed = true;
    protected boolean z80Stopped = false;
    private static final int tstatesPerInterrupt = 131072;
    private static final int tstatesPer10Ms = 32768;
    private static final int IM0 = 0;
    private static final int IM1 = 1;
    private static final int IM2 = 2;
    public static final int F_C = 1;
    public static final int F_N = 2;
    public static final int F_PV = 4;
    public static final int F_3 = 8;
    public static final int F_H = 16;
    public static final int F_5 = 32;
    public static final int F_Z = 64;
    public static final int F_S = 128;
    private final boolean[] parity = new boolean[256];
    private int _A = 0;
    private int _HL = 0;
    private int _B = 0;
    private int _C = 0;
    private int _DE = 0;
    public boolean fS = false;
    public boolean fZ = false;
    public boolean f5 = false;
    public boolean fH = false;
    public boolean f3 = false;
    public boolean fPV = false;
    public boolean fN = false;
    public boolean fC = false;
    private int _AF_ = 0;
    private int _HL_ = 0;
    private int _BC_ = 0;
    private int _DE_ = 0;
    private int _IX = 0;
    private int _IY = 0;
    private int _ID = 0;
    private int _SP = 0;
    private int _PC = 0;
    private int instrPC = 0;
    private int _I = 0;
    private int _R = 0;
    private int _R7 = 0;
    private boolean _IFF1 = true;
    private boolean _IFF2 = true;
    private int _IM = 2;

    public abstract void haltZ80();

    public abstract boolean intRequest();

    public abstract boolean isZ80Stopped();

    public abstract int readByte(int var1);

    public abstract int pcReadByte(int var1);

    public abstract void writeByte(int var1, int var2);

    public abstract int readWord(int var1);

    public abstract void writeWord(int var1, int var2);

    public abstract int getPcAddress();

    public abstract void outByte(int var1, int var2, int var3);

    public abstract int inByte(int var1, int var2);

    public Z80() {
        int n = 0;
        while (n < 256) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < 8) {
                if ((n & 1 << n2) != 0) {
                    bl = !bl;
                }
                ++n2;
            }
            this.parity[n] = bl;
            ++n;
        }
        this.lgZ80 = new LogZ80Instruction();
        this.reset();
    }

    public boolean isCpuRealSpeed() {
        return this.cpuRealSpeed;
    }

    public void setCpuRealSpeed(boolean bl) {
        this.cpuRealSpeed = bl;
    }

    public void flushZ80LogCache() {
        if (this.lgZ80.isCacheAvailable()) {
            this.lgZ80.flushCache();
        }
    }

    public void setZ80Logging(boolean bl) {
        this.logZ80instructions = bl;
    }

    public boolean izZ80Logged() {
        return this.logZ80instructions;
    }

    public int getTstatesCounter() {
        int n = this.tstatesCounter;
        this.tstatesCounter = 0;
        return n;
    }

    public final int AF() {
        return this.A() << 8 | this.F();
    }

    public final int AFx() {
        return this._AF_;
    }

    public final void AF(int n) {
        this.A(n >>> 8);
        this.F(n);
    }

    public final int BC() {
        return this.B() << 8 | this.C();
    }

    public final int BCx() {
        return this._BC_;
    }

    public final void BC(int n) {
        this.B(n >> 8);
        this.C(n & 0xFF);
    }

    public final int DE() {
        return this._DE;
    }

    public final int DEx() {
        return this._DE_;
    }

    public final void DE(int n) {
        this._DE = n;
    }

    public final int HL() {
        return this._HL;
    }

    public final int HLx() {
        return this._HL_;
    }

    public final void HL(int n) {
        this._HL = n;
    }

    public final int PC() {
        return this._PC;
    }

    public int getInstrPC() {
        return this.instrPC;
    }

    public final void PC(int n) {
        this._PC = n;
    }

    public final int SP() {
        return this._SP;
    }

    public final void SP(int n) {
        this._SP = n;
    }

    private final int ID() {
        return this._ID;
    }

    private final void ID(int n) {
        this._ID = n;
    }

    public final int IX() {
        return this._IX;
    }

    public final void IX(int n) {
        this._IX = n;
    }

    public final int IY() {
        return this._IY;
    }

    public final void IY(int n) {
        this._IY = n;
    }

    public final int A() {
        return this._A;
    }

    public final void A(int n) {
        this._A = n;
    }

    public final int F() {
        return (this.Sset() ? 128 : 0) | (this.Zset() ? 64 : 0) | (this.f5 ? 32 : 0) | (this.Hset() ? 16 : 0) | (this.f3 ? 8 : 0) | (this.PVset() ? 4 : 0) | (this.Nset() ? 2 : 0) | (this.Cset() ? 1 : 0);
    }

    public final void F(int n) {
        this.fS = (n & 0x80) != 0;
        this.fZ = (n & 0x40) != 0;
        this.f5 = (n & 0x20) != 0;
        this.fH = (n & 0x10) != 0;
        this.f3 = (n & 8) != 0;
        this.fPV = (n & 4) != 0;
        this.fN = (n & 2) != 0;
        this.fC = (n & 1) != 0;
    }

    public final int B() {
        return this._B;
    }

    public final void B(int n) {
        this._B = n;
    }

    public final int C() {
        return this._C;
    }

    public final void C(int n) {
        this._C = n;
    }

    public final int D() {
        return this._DE >> 8;
    }

    public final void D(int n) {
        this._DE = n << 8 | this._DE & 0xFF;
    }

    public final int E() {
        return this._DE & 0xFF;
    }

    public final void E(int n) {
        this._DE = this._DE & 0xFF00 | n;
    }

    public final int H() {
        return this._HL >> 8;
    }

    public final void H(int n) {
        this._HL = n << 8 | this._HL & 0xFF;
    }

    public final int L() {
        return this._HL & 0xFF;
    }

    public final void L(int n) {
        this._HL = this._HL & 0xFF00 | n;
    }

    private final int IDH() {
        return this._ID >> 8;
    }

    private final void IDH(int n) {
        this._ID = n << 8 | this._ID & 0xFF;
    }

    private final int IDL() {
        return this._ID & 0xFF;
    }

    private final void IDL(int n) {
        this._ID = this._ID & 0xFF00 | n;
    }

    private final int R7() {
        return this._R7;
    }

    public final int R() {
        return this._R & 0x7F | this._R7;
    }

    public final void R(int n) {
        this._R = n;
        this._R7 = n & 0x80;
    }

    private final void REFRESH(int n) {
        this._R += n;
    }

    public final int I() {
        return this._I;
    }

    public final void I(int n) {
        this._I = n;
    }

    public final boolean IFF1() {
        return this._IFF1;
    }

    public final void IFF1(boolean bl) {
        this._IFF1 = bl;
    }

    public final boolean IFF2() {
        return this._IFF2;
    }

    public final void IFF2(boolean bl) {
        this._IFF2 = bl;
    }

    public final int IM() {
        return this._IM;
    }

    public final void IM(int n) {
        this._IM = n;
    }

    private final void setZ(boolean bl) {
        this.fZ = bl;
    }

    private final void setC(boolean bl) {
        this.fC = bl;
    }

    private final void setS(boolean bl) {
        this.fS = bl;
    }

    private final void setH(boolean bl) {
        this.fH = bl;
    }

    private final void setN(boolean bl) {
        this.fN = bl;
    }

    private final void setPV(boolean bl) {
        this.fPV = bl;
    }

    private final void set3(boolean bl) {
        this.f3 = bl;
    }

    private final void set5(boolean bl) {
        this.f5 = bl;
    }

    public final boolean f3set() {
        return this.f3;
    }

    public final boolean f5set() {
        return this.f5;
    }

    public final boolean Zset() {
        return this.fZ;
    }

    public final boolean Cset() {
        return this.fC;
    }

    public final boolean Sset() {
        return this.fS;
    }

    public final boolean Hset() {
        return this.fH;
    }

    public final boolean Nset() {
        return this.fN;
    }

    public final boolean PVset() {
        return this.fPV;
    }

    private final int ID_d() {
        return this.ID() + (byte)this.readByte(this._PC++) & 0xFFFF;
    }

    private final void pushw(int n) {
        int n2 = this.SP() - 2 & 0xFFFF;
        this.SP(n2);
        this.writeWord(n2, n);
    }

    private final int popw() {
        int n = this.SP();
        int n2 = this.readWord(n);
        this.SP(n + 2 & 0xFFFF);
        return n2;
    }

    private final int nxtpcw() {
        this._PC += 2;
        return this.readWord(this._PC - 2);
    }

    public void reset() {
        this.PC(0);
        this.SP(65535);
        this.A(0);
        this.F(0);
        this.BC(0);
        this.DE(0);
        this.HL(0);
        this.exx();
        this.ex_af_af();
        this.A(255);
        this.F(255);
        this.BC(0);
        this.DE(0);
        this.HL(0);
        this.IX(0);
        this.IY(0);
        this.R(0);
        this.I(0);
        this.IFF1(false);
        this.IFF2(false);
        this.IM(0);
    }

    public final void setNmiSignal() {
        if (this.IFF1()) {
            this.nmi = true;
        }
    }

    private void execNmiInterrupt() {
        this.nmi = false;
        this.pushw(this._PC);
        this.IFF2(this.IFF1());
        this.IFF1(false);
        this.PC(102);
        this.instrPC = 102;
        this.tstatesCounter += 13;
    }

    private void execMaskableInterrupt() {
        if (!this.IFF1()) {
            OZvm.displayRtmMessage("INT request blocked");
            return;
        }
        this.IFF1(false);
        this.IFF2(false);
        switch (this.IM()) {
            case 0: {
                this.pushw(this._PC);
                this.PC(102);
                this.instrPC = 102;
                this.tstatesCounter += 13;
                break;
            }
            case 1: {
                this.pushw(this._PC);
                this.PC(56);
                this.instrPC = 56;
                this.tstatesCounter += 13;
                break;
            }
            case 2: {
                this.pushw(this._PC);
                int n = this.I() << 8 | 0xFF;
                this.PC(this.readWord(n));
                this.instrPC = this.readWord(n);
                this.tstatesCounter += 19;
            }
        }
    }

    public boolean isZ80running() {
        return !this.z80Stopped;
    }

    public void decode(boolean bl) {
        this.z80Stopped = false;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        this.tstatesCounter = 0;
        block582: do {
            if (!bl & this.cpuRealSpeed & this.tstatesCounter > 32768) {
                long l3 = System.currentTimeMillis();
                long l4 = 10000L - (l3 - l) * 1000L;
                if (l4 < 0L) {
                    l4 = l2;
                } else {
                    l2 = l4;
                }
                try {
                    TimeUnit.MICROSECONDS.sleep(l4);
                }
                catch (InterruptedException interruptedException) {}
                l = System.currentTimeMillis();
                this.tstatesCounter = 0;
            }
            this.instrPC = this._PC;
            if (!bl & this.nmi & this.intRequest()) {
                this.execNmiInterrupt();
            }
            if (!bl & this.IFF1() & this.intRequest()) {
                this.execMaskableInterrupt();
            }
            if (this.logZ80instructions) {
                this.lgZ80.logInstruction(this.getPcAddress(), this.AF(), this.BC(), this.DE(), this.HL(), this.IX(), this.IY(), this.SP(), this.PC());
            }
            this.REFRESH(1);
            int n = this.pcReadByte(this._PC);
            if (!bl & this.isZ80Stopped()) {
                this.z80Stopped = true;
                return;
            }
            ++this._PC;
            switch (n) {
                case 0: {
                    this.tstatesCounter += 4;
                    break;
                }
                case 8: {
                    this.ex_af_af();
                    this.tstatesCounter += 4;
                    break;
                }
                case 16: {
                    int n2;
                    int n3 = this.qdec8(this.B());
                    this.B(n3);
                    if (n3 != 0) {
                        n2 = (byte)this.readByte(this._PC++);
                        this.PC(this.PC() + n2 & 0xFFFF);
                        this.tstatesCounter += 13;
                        break;
                    }
                    this.PC(this.inc16(this.PC()));
                    this.tstatesCounter += 8;
                    break;
                }
                case 24: {
                    byte by = (byte)this.readByte(this._PC++);
                    this.PC(this.PC() + by & 0xFFFF);
                    this.tstatesCounter += 12;
                    break;
                }
                case 32: {
                    if (!this.Zset()) {
                        byte by = (byte)this.readByte(this._PC++);
                        this.PC(this.PC() + by & 0xFFFF);
                        this.tstatesCounter += 12;
                        break;
                    }
                    this.PC(this.inc16(this.PC()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 40: {
                    if (this.Zset()) {
                        byte by = (byte)this.readByte(this._PC++);
                        this.PC(this.PC() + by & 0xFFFF);
                        this.tstatesCounter += 12;
                        break;
                    }
                    this.PC(this.inc16(this.PC()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 48: {
                    if (!this.Cset()) {
                        byte by = (byte)this.readByte(this._PC++);
                        this.PC(this.PC() + by & 0xFFFF);
                        this.tstatesCounter += 12;
                        break;
                    }
                    this.PC(this.inc16(this.PC()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 56: {
                    if (this.Cset()) {
                        byte by = (byte)this.readByte(this._PC++);
                        this.PC(this.PC() + by & 0xFFFF);
                        this.tstatesCounter += 12;
                        break;
                    }
                    this.PC(this.inc16(this.PC()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 1: {
                    this.BC(this.nxtpcw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 9: {
                    this.HL(this.add16(this.HL(), this.BC()));
                    this.tstatesCounter += 11;
                    break;
                }
                case 17: {
                    this.DE(this.nxtpcw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 25: {
                    this.HL(this.add16(this.HL(), this.DE()));
                    this.tstatesCounter += 11;
                    break;
                }
                case 33: {
                    this.HL(this.nxtpcw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 41: {
                    int n4 = this.HL();
                    this.HL(this.add16(n4, n4));
                    this.tstatesCounter += 11;
                    break;
                }
                case 49: {
                    this.SP(this.nxtpcw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 57: {
                    this.HL(this.add16(this.HL(), this.SP()));
                    this.tstatesCounter += 11;
                    break;
                }
                case 2: {
                    this.writeByte(this.BC(), this.A());
                    this.tstatesCounter += 7;
                    break;
                }
                case 10: {
                    this.A(this.readByte(this.BC()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 18: {
                    this.writeByte(this.DE(), this.A());
                    this.tstatesCounter += 7;
                    break;
                }
                case 26: {
                    this.A(this.readByte(this.DE()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 34: {
                    this.writeWord(this.nxtpcw(), this.HL());
                    this.tstatesCounter += 16;
                    break;
                }
                case 42: {
                    this.HL(this.readWord(this.nxtpcw()));
                    this.tstatesCounter += 16;
                    break;
                }
                case 50: {
                    this.writeByte(this.nxtpcw(), this.A());
                    this.tstatesCounter += 13;
                    break;
                }
                case 58: {
                    this.A(this.readByte(this.nxtpcw()));
                    this.tstatesCounter += 13;
                    break;
                }
                case 3: {
                    this.BC(this.inc16(this.BC()));
                    this.tstatesCounter += 6;
                    break;
                }
                case 11: {
                    this.BC(this.dec16(this.BC()));
                    this.tstatesCounter += 6;
                    break;
                }
                case 19: {
                    this.DE(this.inc16(this.DE()));
                    this.tstatesCounter += 6;
                    break;
                }
                case 27: {
                    this.DE(this.dec16(this.DE()));
                    this.tstatesCounter += 6;
                    break;
                }
                case 35: {
                    this.HL(this.inc16(this.HL()));
                    this.tstatesCounter += 6;
                    break;
                }
                case 43: {
                    this.HL(this.dec16(this.HL()));
                    this.tstatesCounter += 6;
                    break;
                }
                case 51: {
                    this.SP(this.inc16(this.SP()));
                    this.tstatesCounter += 6;
                    break;
                }
                case 59: {
                    this.SP(this.dec16(this.SP()));
                    this.tstatesCounter += 6;
                    break;
                }
                case 4: {
                    this.B(this.inc8(this.B()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 12: {
                    this.C(this.inc8(this.C()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 20: {
                    this.D(this.inc8(this.D()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 28: {
                    this.E(this.inc8(this.E()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 36: {
                    this.H(this.inc8(this.H()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 44: {
                    this.L(this.inc8(this.L()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 52: {
                    int n5 = this.HL();
                    this.writeByte(n5, this.inc8(this.readByte(n5)));
                    this.tstatesCounter += 11;
                    break;
                }
                case 60: {
                    this.A(this.inc8(this.A()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 5: {
                    this.B(this.dec8(this.B()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 13: {
                    this.C(this.dec8(this.C()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 21: {
                    this.D(this.dec8(this.D()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 29: {
                    this.E(this.dec8(this.E()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 37: {
                    this.H(this.dec8(this.H()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 45: {
                    this.L(this.dec8(this.L()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 53: {
                    int n6 = this.HL();
                    this.writeByte(n6, this.dec8(this.readByte(n6)));
                    this.tstatesCounter += 11;
                    break;
                }
                case 61: {
                    this.A(this.dec8(this.A()));
                    this.tstatesCounter += 4;
                    break;
                }
                case 6: {
                    this.B(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 14: {
                    this.C(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 22: {
                    this.D(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 30: {
                    this.E(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 38: {
                    this.H(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 46: {
                    this.L(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 54: {
                    this.writeByte(this.HL(), this.readByte(this._PC++));
                    this.tstatesCounter += 10;
                    break;
                }
                case 62: {
                    this.A(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 7: {
                    this.rlc_a();
                    this.tstatesCounter += 4;
                    break;
                }
                case 15: {
                    this.rrc_a();
                    this.tstatesCounter += 4;
                    break;
                }
                case 23: {
                    this.rl_a();
                    this.tstatesCounter += 4;
                    break;
                }
                case 31: {
                    this.rr_a();
                    this.tstatesCounter += 4;
                    break;
                }
                case 39: {
                    this.daa_a();
                    this.tstatesCounter += 4;
                    break;
                }
                case 47: {
                    this.cpl_a();
                    this.tstatesCounter += 4;
                    break;
                }
                case 55: {
                    this.scf();
                    this.tstatesCounter += 4;
                    break;
                }
                case 63: {
                    this.ccf();
                    this.tstatesCounter += 4;
                    break;
                }
                case 64: {
                    this.tstatesCounter += 4;
                    break;
                }
                case 65: {
                    this.B(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 66: {
                    this.B(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 67: {
                    this.B(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 68: {
                    this.B(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 69: {
                    this.B(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 70: {
                    this.B(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 71: {
                    this.B(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 72: {
                    this.C(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 73: {
                    this.tstatesCounter += 4;
                    break;
                }
                case 74: {
                    this.C(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 75: {
                    this.C(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 76: {
                    this.C(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 77: {
                    this.C(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 78: {
                    this.C(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 79: {
                    this.C(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 80: {
                    this.D(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 81: {
                    this.D(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 82: {
                    this.tstatesCounter += 4;
                    break;
                }
                case 83: {
                    this.D(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 84: {
                    this.D(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 85: {
                    this.D(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 86: {
                    this.D(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 87: {
                    this.D(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 88: {
                    this.E(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 89: {
                    this.E(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 90: {
                    this.E(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 91: {
                    this.tstatesCounter += 4;
                    break;
                }
                case 92: {
                    this.E(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 93: {
                    this.E(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 94: {
                    this.E(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 95: {
                    this.E(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 96: {
                    this.H(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 97: {
                    this.H(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 98: {
                    this.H(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 99: {
                    this.H(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 100: {
                    this.tstatesCounter += 4;
                    break;
                }
                case 101: {
                    this.H(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 102: {
                    this.H(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 103: {
                    this.H(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 104: {
                    this.L(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 105: {
                    this.L(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 106: {
                    this.L(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 107: {
                    this.L(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 108: {
                    this.L(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 109: {
                    this.tstatesCounter += 4;
                    break;
                }
                case 110: {
                    this.L(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 111: {
                    this.L(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 112: {
                    this.writeByte(this.HL(), this.B());
                    this.tstatesCounter += 7;
                    break;
                }
                case 113: {
                    this.writeByte(this.HL(), this.C());
                    this.tstatesCounter += 7;
                    break;
                }
                case 114: {
                    this.writeByte(this.HL(), this.D());
                    this.tstatesCounter += 7;
                    break;
                }
                case 115: {
                    this.writeByte(this.HL(), this.E());
                    this.tstatesCounter += 7;
                    break;
                }
                case 116: {
                    this.writeByte(this.HL(), this.H());
                    this.tstatesCounter += 7;
                    break;
                }
                case 117: {
                    this.writeByte(this.HL(), this.L());
                    this.tstatesCounter += 7;
                    break;
                }
                case 118: {
                    this.haltZ80();
                    this.tstatesCounter += 4;
                    break;
                }
                case 119: {
                    this.writeByte(this.HL(), this.A());
                    this.tstatesCounter += 7;
                    break;
                }
                case 120: {
                    this.A(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 121: {
                    this.A(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 122: {
                    this.A(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 123: {
                    this.A(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 124: {
                    this.A(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 125: {
                    this.A(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 126: {
                    this.A(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 127: {
                    this.tstatesCounter += 4;
                    break;
                }
                case 128: {
                    this.add_a(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 129: {
                    this.add_a(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 130: {
                    this.add_a(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 131: {
                    this.add_a(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 132: {
                    this.add_a(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 133: {
                    this.add_a(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 134: {
                    this.add_a(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 135: {
                    this.add_a(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 136: {
                    this.adc_a(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 137: {
                    this.adc_a(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 138: {
                    this.adc_a(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 139: {
                    this.adc_a(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 140: {
                    this.adc_a(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 141: {
                    this.adc_a(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 142: {
                    this.adc_a(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 143: {
                    this.adc_a(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 144: {
                    this.sub_a(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 145: {
                    this.sub_a(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 146: {
                    this.sub_a(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 147: {
                    this.sub_a(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 148: {
                    this.sub_a(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 149: {
                    this.sub_a(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 150: {
                    this.sub_a(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 151: {
                    this.sub_a(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 152: {
                    this.sbc_a(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 153: {
                    this.sbc_a(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 154: {
                    this.sbc_a(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 155: {
                    this.sbc_a(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 156: {
                    this.sbc_a(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 157: {
                    this.sbc_a(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 158: {
                    this.sbc_a(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 159: {
                    this.sbc_a(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 160: {
                    this.and_a(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 161: {
                    this.and_a(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 162: {
                    this.and_a(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 163: {
                    this.and_a(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 164: {
                    this.and_a(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 165: {
                    this.and_a(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 166: {
                    this.and_a(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 167: {
                    this.and_a(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 168: {
                    this.xor_a(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 169: {
                    this.xor_a(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 170: {
                    this.xor_a(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 171: {
                    this.xor_a(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 172: {
                    this.xor_a(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 173: {
                    this.xor_a(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 174: {
                    this.xor_a(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 175: {
                    this.xor_a(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 176: {
                    this.or_a(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 177: {
                    this.or_a(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 178: {
                    this.or_a(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 179: {
                    this.or_a(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 180: {
                    this.or_a(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 181: {
                    this.or_a(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 182: {
                    this.or_a(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 183: {
                    this.or_a(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 184: {
                    this.cp_a(this.B());
                    this.tstatesCounter += 4;
                    break;
                }
                case 185: {
                    this.cp_a(this.C());
                    this.tstatesCounter += 4;
                    break;
                }
                case 186: {
                    this.cp_a(this.D());
                    this.tstatesCounter += 4;
                    break;
                }
                case 187: {
                    this.cp_a(this.E());
                    this.tstatesCounter += 4;
                    break;
                }
                case 188: {
                    this.cp_a(this.H());
                    this.tstatesCounter += 4;
                    break;
                }
                case 189: {
                    this.cp_a(this.L());
                    this.tstatesCounter += 4;
                    break;
                }
                case 190: {
                    this.cp_a(this.readByte(this.HL()));
                    this.tstatesCounter += 7;
                    break;
                }
                case 191: {
                    this.cp_a(this.A());
                    this.tstatesCounter += 4;
                    break;
                }
                case 192: {
                    if (!this.Zset()) {
                        this.PC(this.popw());
                        this.tstatesCounter += 11;
                        break;
                    }
                    this.tstatesCounter += 5;
                    break;
                }
                case 200: {
                    if (this.Zset()) {
                        this.PC(this.popw());
                        this.tstatesCounter += 11;
                        break;
                    }
                    this.tstatesCounter += 5;
                    break;
                }
                case 208: {
                    if (!this.Cset()) {
                        this.PC(this.popw());
                        this.tstatesCounter += 11;
                        break;
                    }
                    this.tstatesCounter += 5;
                    break;
                }
                case 216: {
                    if (this.Cset()) {
                        this.PC(this.popw());
                        this.tstatesCounter += 11;
                        break;
                    }
                    this.tstatesCounter += 5;
                    break;
                }
                case 224: {
                    if (!this.PVset()) {
                        this.PC(this.popw());
                        this.tstatesCounter += 11;
                        break;
                    }
                    this.tstatesCounter += 5;
                    break;
                }
                case 232: {
                    if (this.PVset()) {
                        this.PC(this.popw());
                        this.tstatesCounter += 11;
                        break;
                    }
                    this.tstatesCounter += 5;
                    break;
                }
                case 240: {
                    if (!this.Sset()) {
                        this.PC(this.popw());
                        this.tstatesCounter += 11;
                        break;
                    }
                    this.tstatesCounter += 5;
                    break;
                }
                case 248: {
                    if (this.Sset()) {
                        this.PC(this.popw());
                        this.tstatesCounter += 11;
                        break;
                    }
                    this.tstatesCounter += 5;
                    break;
                }
                case 193: {
                    this.BC(this.popw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 201: {
                    this.PC(this.popw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 209: {
                    this.DE(this.popw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 217: {
                    this.exx();
                    this.tstatesCounter += 4;
                    break;
                }
                case 225: {
                    this.HL(this.popw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 233: {
                    this.PC(this.HL());
                    this.tstatesCounter += 4;
                    break;
                }
                case 241: {
                    this.AF(this.popw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 249: {
                    this.SP(this.HL());
                    this.tstatesCounter += 6;
                    break;
                }
                case 194: {
                    if (!this.Zset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    this.tstatesCounter += 10;
                    break;
                }
                case 202: {
                    if (this.Zset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    this.tstatesCounter += 10;
                    break;
                }
                case 210: {
                    if (!this.Cset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    this.tstatesCounter += 10;
                    break;
                }
                case 218: {
                    if (this.Cset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    this.tstatesCounter += 10;
                    break;
                }
                case 226: {
                    if (!this.PVset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    this.tstatesCounter += 10;
                    break;
                }
                case 234: {
                    if (this.PVset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    this.tstatesCounter += 10;
                    break;
                }
                case 242: {
                    if (!this.Sset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    this.tstatesCounter += 10;
                    break;
                }
                case 250: {
                    if (this.Sset()) {
                        this.PC(this.nxtpcw());
                    } else {
                        this.PC(this.PC() + 2 & 0xFFFF);
                    }
                    this.tstatesCounter += 10;
                    break;
                }
                case 195: {
                    this.PC(this.nxtpcw());
                    this.tstatesCounter += 10;
                    break;
                }
                case 203: {
                    this.REFRESH(1);
                    switch (this.readByte(this._PC++)) {
                        case 0: {
                            this.B(this.rlc(this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 1: {
                            this.C(this.rlc(this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 2: {
                            this.D(this.rlc(this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 3: {
                            this.E(this.rlc(this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 4: {
                            this.H(this.rlc(this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 5: {
                            this.L(this.rlc(this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 6: {
                            int n7 = this.HL();
                            this.writeByte(n7, this.rlc(this.readByte(n7)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 7: {
                            this.A(this.rlc(this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 8: {
                            this.B(this.rrc(this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 9: {
                            this.C(this.rrc(this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 10: {
                            this.D(this.rrc(this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 11: {
                            this.E(this.rrc(this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 12: {
                            this.H(this.rrc(this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 13: {
                            this.L(this.rrc(this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 14: {
                            int n8 = this.HL();
                            this.writeByte(n8, this.rrc(this.readByte(n8)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 15: {
                            this.A(this.rrc(this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 16: {
                            this.B(this.rl(this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 17: {
                            this.C(this.rl(this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 18: {
                            this.D(this.rl(this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 19: {
                            this.E(this.rl(this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 20: {
                            this.H(this.rl(this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 21: {
                            this.L(this.rl(this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 22: {
                            int n9 = this.HL();
                            this.writeByte(n9, this.rl(this.readByte(n9)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 23: {
                            this.A(this.rl(this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 24: {
                            this.B(this.rr(this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 25: {
                            this.C(this.rr(this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 26: {
                            this.D(this.rr(this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 27: {
                            this.E(this.rr(this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 28: {
                            this.H(this.rr(this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 29: {
                            this.L(this.rr(this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 30: {
                            int n10 = this.HL();
                            this.writeByte(n10, this.rr(this.readByte(n10)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 31: {
                            this.A(this.rr(this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 32: {
                            this.B(this.sla(this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 33: {
                            this.C(this.sla(this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 34: {
                            this.D(this.sla(this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 35: {
                            this.E(this.sla(this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 36: {
                            this.H(this.sla(this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 37: {
                            this.L(this.sla(this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 38: {
                            int n11 = this.HL();
                            this.writeByte(n11, this.sla(this.readByte(n11)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 39: {
                            this.A(this.sla(this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 40: {
                            this.B(this.sra(this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 41: {
                            this.C(this.sra(this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 42: {
                            this.D(this.sra(this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 43: {
                            this.E(this.sra(this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 44: {
                            this.H(this.sra(this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 45: {
                            this.L(this.sra(this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 46: {
                            int n12 = this.HL();
                            this.writeByte(n12, this.sra(this.readByte(n12)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 47: {
                            this.A(this.sra(this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 48: {
                            this.B(this.sls(this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 49: {
                            this.C(this.sls(this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 50: {
                            this.D(this.sls(this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 51: {
                            this.E(this.sls(this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 52: {
                            this.H(this.sls(this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 53: {
                            this.L(this.sls(this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 54: {
                            int n13 = this.HL();
                            this.writeByte(n13, this.sls(this.readByte(n13)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 55: {
                            this.A(this.sls(this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 56: {
                            this.B(this.srl(this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 57: {
                            this.C(this.srl(this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 58: {
                            this.D(this.srl(this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 59: {
                            this.E(this.srl(this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 60: {
                            this.H(this.srl(this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 61: {
                            this.L(this.srl(this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 62: {
                            int n14 = this.HL();
                            this.writeByte(n14, this.srl(this.readByte(n14)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 63: {
                            this.A(this.srl(this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 64: {
                            this.bit(1, this.B());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 65: {
                            this.bit(1, this.C());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 66: {
                            this.bit(1, this.D());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 67: {
                            this.bit(1, this.E());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 68: {
                            this.bit(1, this.H());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 69: {
                            this.bit(1, this.L());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 70: {
                            this.bit(1, this.readByte(this.HL()));
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 71: {
                            this.bit(1, this.A());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 72: {
                            this.bit(2, this.B());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 73: {
                            this.bit(2, this.C());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 74: {
                            this.bit(2, this.D());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 75: {
                            this.bit(2, this.E());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 76: {
                            this.bit(2, this.H());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 77: {
                            this.bit(2, this.L());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 78: {
                            this.bit(2, this.readByte(this.HL()));
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 79: {
                            this.bit(2, this.A());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 80: {
                            this.bit(4, this.B());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 81: {
                            this.bit(4, this.C());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 82: {
                            this.bit(4, this.D());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 83: {
                            this.bit(4, this.E());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 84: {
                            this.bit(4, this.H());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 85: {
                            this.bit(4, this.L());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 86: {
                            this.bit(4, this.readByte(this.HL()));
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 87: {
                            this.bit(4, this.A());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 88: {
                            this.bit(8, this.B());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 89: {
                            this.bit(8, this.C());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 90: {
                            this.bit(8, this.D());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 91: {
                            this.bit(8, this.E());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 92: {
                            this.bit(8, this.H());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 93: {
                            this.bit(8, this.L());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 94: {
                            this.bit(8, this.readByte(this.HL()));
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 95: {
                            this.bit(8, this.A());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 96: {
                            this.bit(16, this.B());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 97: {
                            this.bit(16, this.C());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 98: {
                            this.bit(16, this.D());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 99: {
                            this.bit(16, this.E());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 100: {
                            this.bit(16, this.H());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 101: {
                            this.bit(16, this.L());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 102: {
                            this.bit(16, this.readByte(this.HL()));
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 103: {
                            this.bit(16, this.A());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 104: {
                            this.bit(32, this.B());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 105: {
                            this.bit(32, this.C());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 106: {
                            this.bit(32, this.D());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 107: {
                            this.bit(32, this.E());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 108: {
                            this.bit(32, this.H());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 109: {
                            this.bit(32, this.L());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 110: {
                            this.bit(32, this.readByte(this.HL()));
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 111: {
                            this.bit(32, this.A());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 112: {
                            this.bit(64, this.B());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 113: {
                            this.bit(64, this.C());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 114: {
                            this.bit(64, this.D());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 115: {
                            this.bit(64, this.E());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 116: {
                            this.bit(64, this.H());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 117: {
                            this.bit(64, this.L());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 118: {
                            this.bit(64, this.readByte(this.HL()));
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 119: {
                            this.bit(64, this.A());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 120: {
                            this.bit(128, this.B());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 121: {
                            this.bit(128, this.C());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 122: {
                            this.bit(128, this.D());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 123: {
                            this.bit(128, this.E());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 124: {
                            this.bit(128, this.H());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 125: {
                            this.bit(128, this.L());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 126: {
                            this.bit(128, this.readByte(this.HL()));
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 127: {
                            this.bit(128, this.A());
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 128: {
                            this.B(this.res(1, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 129: {
                            this.C(this.res(1, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 130: {
                            this.D(this.res(1, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 131: {
                            this.E(this.res(1, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 132: {
                            this.H(this.res(1, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 133: {
                            this.L(this.res(1, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 134: {
                            int n15 = this.HL();
                            this.writeByte(n15, this.res(1, this.readByte(n15)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 135: {
                            this.A(this.res(1, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 136: {
                            this.B(this.res(2, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 137: {
                            this.C(this.res(2, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 138: {
                            this.D(this.res(2, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 139: {
                            this.E(this.res(2, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 140: {
                            this.H(this.res(2, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 141: {
                            this.L(this.res(2, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 142: {
                            int n16 = this.HL();
                            this.writeByte(n16, this.res(2, this.readByte(n16)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 143: {
                            this.A(this.res(2, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 144: {
                            this.B(this.res(4, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 145: {
                            this.C(this.res(4, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 146: {
                            this.D(this.res(4, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 147: {
                            this.E(this.res(4, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 148: {
                            this.H(this.res(4, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 149: {
                            this.L(this.res(4, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 150: {
                            int n17 = this.HL();
                            this.writeByte(n17, this.res(4, this.readByte(n17)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 151: {
                            this.A(this.res(4, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 152: {
                            this.B(this.res(8, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 153: {
                            this.C(this.res(8, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 154: {
                            this.D(this.res(8, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 155: {
                            this.E(this.res(8, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 156: {
                            this.H(this.res(8, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 157: {
                            this.L(this.res(8, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 158: {
                            int n18 = this.HL();
                            this.writeByte(n18, this.res(8, this.readByte(n18)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 159: {
                            this.A(this.res(8, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 160: {
                            this.B(this.res(16, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 161: {
                            this.C(this.res(16, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 162: {
                            this.D(this.res(16, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 163: {
                            this.E(this.res(16, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 164: {
                            this.H(this.res(16, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 165: {
                            this.L(this.res(16, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 166: {
                            int n19 = this.HL();
                            this.writeByte(n19, this.res(16, this.readByte(n19)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 167: {
                            this.A(this.res(16, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 168: {
                            this.B(this.res(32, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 169: {
                            this.C(this.res(32, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 170: {
                            this.D(this.res(32, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 171: {
                            this.E(this.res(32, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 172: {
                            this.H(this.res(32, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 173: {
                            this.L(this.res(32, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 174: {
                            int n20 = this.HL();
                            this.writeByte(n20, this.res(32, this.readByte(n20)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 175: {
                            this.A(this.res(32, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 176: {
                            this.B(this.res(64, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 177: {
                            this.C(this.res(64, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 178: {
                            this.D(this.res(64, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 179: {
                            this.E(this.res(64, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 180: {
                            this.H(this.res(64, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 181: {
                            this.L(this.res(64, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 182: {
                            int n21 = this.HL();
                            this.writeByte(n21, this.res(64, this.readByte(n21)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 183: {
                            this.A(this.res(64, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 184: {
                            this.B(this.res(128, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 185: {
                            this.C(this.res(128, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 186: {
                            this.D(this.res(128, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 187: {
                            this.E(this.res(128, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 188: {
                            this.H(this.res(128, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 189: {
                            this.L(this.res(128, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 190: {
                            int n22 = this.HL();
                            this.writeByte(n22, this.res(128, this.readByte(n22)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 191: {
                            this.A(this.res(128, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 192: {
                            this.B(this.set(1, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 193: {
                            this.C(this.set(1, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 194: {
                            this.D(this.set(1, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 195: {
                            this.E(this.set(1, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 196: {
                            this.H(this.set(1, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 197: {
                            this.L(this.set(1, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 198: {
                            int n23 = this.HL();
                            this.writeByte(n23, this.set(1, this.readByte(n23)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 199: {
                            this.A(this.set(1, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 200: {
                            this.B(this.set(2, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 201: {
                            this.C(this.set(2, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 202: {
                            this.D(this.set(2, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 203: {
                            this.E(this.set(2, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 204: {
                            this.H(this.set(2, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 205: {
                            this.L(this.set(2, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 206: {
                            int n24 = this.HL();
                            this.writeByte(n24, this.set(2, this.readByte(n24)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 207: {
                            this.A(this.set(2, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 208: {
                            this.B(this.set(4, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 209: {
                            this.C(this.set(4, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 210: {
                            this.D(this.set(4, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 211: {
                            this.E(this.set(4, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 212: {
                            this.H(this.set(4, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 213: {
                            this.L(this.set(4, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 214: {
                            int n25 = this.HL();
                            this.writeByte(n25, this.set(4, this.readByte(n25)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 215: {
                            this.A(this.set(4, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 216: {
                            this.B(this.set(8, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 217: {
                            this.C(this.set(8, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 218: {
                            this.D(this.set(8, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 219: {
                            this.E(this.set(8, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 220: {
                            this.H(this.set(8, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 221: {
                            this.L(this.set(8, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 222: {
                            int n26 = this.HL();
                            this.writeByte(n26, this.set(8, this.readByte(n26)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 223: {
                            this.A(this.set(8, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 224: {
                            this.B(this.set(16, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 225: {
                            this.C(this.set(16, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 226: {
                            this.D(this.set(16, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 227: {
                            this.E(this.set(16, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 228: {
                            this.H(this.set(16, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 229: {
                            this.L(this.set(16, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 230: {
                            int n27 = this.HL();
                            this.writeByte(n27, this.set(16, this.readByte(n27)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 231: {
                            this.A(this.set(16, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 232: {
                            this.B(this.set(32, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 233: {
                            this.C(this.set(32, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 234: {
                            this.D(this.set(32, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 235: {
                            this.E(this.set(32, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 236: {
                            this.H(this.set(32, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 237: {
                            this.L(this.set(32, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 238: {
                            int n28 = this.HL();
                            this.writeByte(n28, this.set(32, this.readByte(n28)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 239: {
                            this.A(this.set(32, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 240: {
                            this.B(this.set(64, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 241: {
                            this.C(this.set(64, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 242: {
                            this.D(this.set(64, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 243: {
                            this.E(this.set(64, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 244: {
                            this.H(this.set(64, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 245: {
                            this.L(this.set(64, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 246: {
                            int n29 = this.HL();
                            this.writeByte(n29, this.set(64, this.readByte(n29)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 247: {
                            this.A(this.set(64, this.A()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 248: {
                            this.B(this.set(128, this.B()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 249: {
                            this.C(this.set(128, this.C()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 250: {
                            this.D(this.set(128, this.D()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 251: {
                            this.E(this.set(128, this.E()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 252: {
                            this.H(this.set(128, this.H()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 253: {
                            this.L(this.set(128, this.L()));
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 254: {
                            int n30 = this.HL();
                            this.writeByte(n30, this.set(128, this.readByte(n30)));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 255: {
                            this.A(this.set(128, this.A()));
                            this.tstatesCounter += 8;
                        }
                    }
                    continue block582;
                }
                case 211: {
                    this.outByte(this.readByte(this._PC++), this.A(), this.A());
                    this.tstatesCounter += 11;
                    break;
                }
                case 219: {
                    this.A(this.inByte(this.readByte(this._PC++), this.A()));
                    this.tstatesCounter += 11;
                    break;
                }
                case 227: {
                    int n31 = this.HL();
                    int n2 = this.SP();
                    this.HL(this.readWord(n2));
                    this.writeWord(n2, n31);
                    this.tstatesCounter += 19;
                    break;
                }
                case 235: {
                    int n32 = this.HL();
                    this.HL(this.DE());
                    this.DE(n32);
                    this.tstatesCounter += 4;
                    break;
                }
                case 243: {
                    this.IFF1(false);
                    this.IFF2(false);
                    this.tstatesCounter += 4;
                    break;
                }
                case 251: {
                    this.tstatesCounter += 4;
                    if (!bl) {
                        this.decode(true);
                    }
                    this.IFF1(true);
                    this.IFF2(true);
                    break;
                }
                case 196: {
                    if (!this.Zset()) {
                        int n33 = this.nxtpcw();
                        this.pushw(this._PC);
                        this.PC(n33);
                        this.tstatesCounter += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    this.tstatesCounter += 10;
                    break;
                }
                case 204: {
                    if (this.Zset()) {
                        int n34 = this.nxtpcw();
                        this.pushw(this._PC);
                        this.PC(n34);
                        this.tstatesCounter += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    this.tstatesCounter += 10;
                    break;
                }
                case 212: {
                    if (!this.Cset()) {
                        int n35 = this.nxtpcw();
                        this.pushw(this._PC);
                        this.PC(n35);
                        this.tstatesCounter += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    this.tstatesCounter += 10;
                    break;
                }
                case 220: {
                    if (this.Cset()) {
                        int n36 = this.nxtpcw();
                        this.pushw(this._PC);
                        this.PC(n36);
                        this.tstatesCounter += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    this.tstatesCounter += 10;
                    break;
                }
                case 228: {
                    if (!this.PVset()) {
                        int n37 = this.nxtpcw();
                        this.pushw(this._PC);
                        this.PC(n37);
                        this.tstatesCounter += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    this.tstatesCounter += 10;
                    break;
                }
                case 236: {
                    if (this.PVset()) {
                        int n38 = this.nxtpcw();
                        this.pushw(this._PC);
                        this.PC(n38);
                        this.tstatesCounter += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    this.tstatesCounter += 10;
                    break;
                }
                case 244: {
                    if (!this.Sset()) {
                        int n39 = this.nxtpcw();
                        this.pushw(this._PC);
                        this.PC(n39);
                        this.tstatesCounter += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    this.tstatesCounter += 10;
                    break;
                }
                case 252: {
                    if (this.Sset()) {
                        int n40 = this.nxtpcw();
                        this.pushw(this._PC);
                        this.PC(n40);
                        this.tstatesCounter += 17;
                        break;
                    }
                    this.PC(this.PC() + 2 & 0xFFFF);
                    this.tstatesCounter += 10;
                    break;
                }
                case 197: {
                    this.pushw(this.BC());
                    this.tstatesCounter += 11;
                    break;
                }
                case 205: {
                    int n41 = this.nxtpcw();
                    this.pushw(this._PC);
                    this.PC(n41);
                    this.tstatesCounter += 17;
                    break;
                }
                case 213: {
                    this.pushw(this.DE());
                    this.tstatesCounter += 11;
                    break;
                }
                case 221: {
                    this.ID(this.IX());
                    this.execute_id();
                    this.IX(this.ID());
                    break;
                }
                case 229: {
                    this.pushw(this.HL());
                    this.tstatesCounter += 11;
                    break;
                }
                case 237: {
                    int n2;
                    this.REFRESH(1);
                    switch (this.readByte(this._PC++)) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 127: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 180: 
                        case 181: 
                        case 182: 
                        case 183: {
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 128: {
                            this.tstatesCounter += 4;
                            break;
                        }
                        case 64: {
                            this.B(this.in_bc());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 72: {
                            this.C(this.in_bc());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 80: {
                            this.D(this.in_bc());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 88: {
                            this.E(this.in_bc());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 96: {
                            this.H(this.in_bc());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 104: {
                            this.L(this.in_bc());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 112: {
                            this.in_bc();
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 120: {
                            this.A(this.in_bc());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 65: {
                            this.outByte(this.C(), this.B(), this.B());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 73: {
                            this.outByte(this.C(), this.B(), this.C());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 81: {
                            this.outByte(this.C(), this.B(), this.D());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 89: {
                            this.outByte(this.C(), this.B(), this.E());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 97: {
                            this.outByte(this.C(), this.B(), this.H());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 105: {
                            this.outByte(this.C(), this.B(), this.L());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 113: {
                            this.outByte(this.C(), this.B(), 0);
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 121: {
                            this.outByte(this.C(), this.B(), this.A());
                            this.tstatesCounter += 12;
                            break;
                        }
                        case 66: {
                            this.HL(this.sbc16(this.HL(), this.BC()));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 74: {
                            this.HL(this.adc16(this.HL(), this.BC()));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 82: {
                            this.HL(this.sbc16(this.HL(), this.DE()));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 90: {
                            this.HL(this.adc16(this.HL(), this.DE()));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 98: {
                            int n42 = this.HL();
                            this.HL(this.sbc16(n42, n42));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 106: {
                            int n43 = this.HL();
                            this.HL(this.adc16(n43, n43));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 114: {
                            this.HL(this.sbc16(this.HL(), this.SP()));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 122: {
                            this.HL(this.adc16(this.HL(), this.SP()));
                            this.tstatesCounter += 15;
                            break;
                        }
                        case 67: {
                            this.writeWord(this.nxtpcw(), this.BC());
                            this.tstatesCounter += 20;
                            break;
                        }
                        case 75: {
                            this.BC(this.readWord(this.nxtpcw()));
                            this.tstatesCounter += 20;
                            break;
                        }
                        case 83: {
                            this.writeWord(this.nxtpcw(), this.DE());
                            this.tstatesCounter += 20;
                            break;
                        }
                        case 91: {
                            this.DE(this.readWord(this.nxtpcw()));
                            this.tstatesCounter += 20;
                            break;
                        }
                        case 99: {
                            this.writeWord(this.nxtpcw(), this.HL());
                            this.tstatesCounter += 20;
                            break;
                        }
                        case 107: {
                            this.HL(this.readWord(this.nxtpcw()));
                            this.tstatesCounter += 20;
                            break;
                        }
                        case 115: {
                            this.writeWord(this.nxtpcw(), this.SP());
                            this.tstatesCounter += 20;
                            break;
                        }
                        case 123: {
                            this.SP(this.readWord(this.nxtpcw()));
                            this.tstatesCounter += 20;
                            break;
                        }
                        case 68: 
                        case 76: 
                        case 84: 
                        case 92: 
                        case 100: 
                        case 108: 
                        case 116: 
                        case 124: {
                            this.neg_a();
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 69: 
                        case 85: 
                        case 101: 
                        case 117: {
                            this.IFF1(this.IFF2());
                            this.PC(this.popw());
                            this.tstatesCounter += 14;
                            break;
                        }
                        case 77: 
                        case 93: 
                        case 109: 
                        case 125: {
                            this.PC(this.popw());
                            this.tstatesCounter += 14;
                            break;
                        }
                        case 70: 
                        case 78: 
                        case 102: 
                        case 110: {
                            this.IM(0);
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 86: 
                        case 118: {
                            this.IM(1);
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 94: 
                        case 126: {
                            this.IM(2);
                            this.tstatesCounter += 8;
                            break;
                        }
                        case 71: {
                            this.I(this.A());
                            this.tstatesCounter += 9;
                            break;
                        }
                        case 79: {
                            this.R(this.A());
                            this.tstatesCounter += 9;
                            break;
                        }
                        case 87: {
                            this.ld_a_i();
                            this.tstatesCounter += 9;
                            break;
                        }
                        case 95: {
                            this.ld_a_r();
                            this.tstatesCounter += 9;
                            break;
                        }
                        case 103: {
                            this.rrd_a();
                            this.tstatesCounter += 18;
                            break;
                        }
                        case 111: {
                            this.rld_a();
                            this.tstatesCounter += 18;
                            break;
                        }
                        case 160: {
                            this.writeByte(this.DE(), this.readByte(this.HL()));
                            this.DE(this.inc16(this.DE()));
                            this.HL(this.inc16(this.HL()));
                            this.BC(this.dec16(this.BC()));
                            this.setPV(this.BC() != 0);
                            this.setH(false);
                            this.setN(false);
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 161: {
                            boolean bl2 = this.Cset();
                            this.cp_a(this.readByte(this.HL()));
                            this.HL(this.inc16(this.HL()));
                            this.BC(this.dec16(this.BC()));
                            this.setPV(this.BC() != 0);
                            this.setC(bl2);
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 162: {
                            this.writeByte(this.HL(), this.inByte(this.C(), this.B()));
                            int n44 = this.qdec8(this.B());
                            this.B(n44);
                            this.HL(this.inc16(this.HL()));
                            this.setZ(n44 == 0);
                            this.setN(true);
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 163: {
                            int n45 = this.qdec8(this.B());
                            this.B(n45);
                            this.outByte(this.C(), this.B(), this.readByte(this.HL()));
                            this.HL(this.inc16(this.HL()));
                            this.setZ(n45 == 0);
                            this.setN(true);
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 168: {
                            this.writeByte(this.DE(), this.readByte(this.HL()));
                            this.DE(this.dec16(this.DE()));
                            this.HL(this.dec16(this.HL()));
                            this.BC(this.dec16(this.BC()));
                            this.setPV(this.BC() != 0);
                            this.setH(false);
                            this.setN(false);
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 169: {
                            boolean bl3 = this.Cset();
                            this.cp_a(this.readByte(this.HL()));
                            this.HL(this.dec16(this.HL()));
                            this.BC(this.dec16(this.BC()));
                            this.setPV(this.BC() != 0);
                            this.setC(bl3);
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 170: {
                            this.writeByte(this.HL(), this.inByte(this.C(), this.B()));
                            int n46 = this.qdec8(this.B());
                            this.B(n46);
                            this.HL(this.dec16(this.HL()));
                            this.setZ(n46 == 0);
                            this.setN(true);
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 171: {
                            int n47 = this.qdec8(this.B());
                            this.B(n47);
                            this.outByte(this.C(), this.B(), this.readByte(this.HL()));
                            this.HL(this.dec16(this.HL()));
                            this.setZ(n47 == 0);
                            this.setN(true);
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 176: {
                            int n48 = this.BC();
                            n2 = this.DE();
                            int n49 = this.HL();
                            this.REFRESH(-2);
                            do {
                                this.writeByte(n2, this.readByte(n49));
                                n49 = this.inc16(n49);
                                n2 = this.inc16(n2);
                                n48 = this.dec16(n48);
                                this.tstatesCounter += 21;
                                this.REFRESH(2);
                            } while (n48 != 0);
                            if (n48 != 0) {
                                this.PC(this.PC() - 2 & 0xFFFF);
                                this.setH(false);
                                this.setN(false);
                                this.setPV(true);
                            } else {
                                this.tstatesCounter -= 5;
                                this.setH(false);
                                this.setN(false);
                                this.setPV(false);
                            }
                            this.DE(n2);
                            this.HL(n49);
                            this.BC(n48);
                            break;
                        }
                        case 177: {
                            boolean bl4 = this.Cset();
                            this.cp_a(this.readByte(this.HL()));
                            this.HL(this.inc16(this.HL()));
                            this.BC(this.dec16(this.BC()));
                            n2 = this.BC() != 0 ? 1 : 0;
                            this.setPV(n2 != 0);
                            this.setC(bl4);
                            if (n2 != 0 && !this.Zset()) {
                                this.PC(this.PC() - 2 & 0xFFFF);
                                this.tstatesCounter += 21;
                            }
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 178: {
                            this.writeByte(this.HL(), this.inByte(this.C(), this.B()));
                            int n50 = this.qdec8(this.B());
                            this.B(n50);
                            this.HL(this.inc16(this.HL()));
                            this.setZ(true);
                            this.setN(true);
                            if (n50 != 0) {
                                this.PC(this.PC() - 2 & 0xFFFF);
                                this.tstatesCounter += 21;
                            }
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 179: {
                            int n51 = this.qdec8(this.B());
                            this.B(n51);
                            this.outByte(this.C(), this.B(), this.readByte(this.HL()));
                            this.HL(this.inc16(this.HL()));
                            this.setZ(true);
                            this.setN(true);
                            if (n51 != 0) {
                                this.PC(this.PC() - 2 & 0xFFFF);
                                this.tstatesCounter += 21;
                            }
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 184: {
                            int n52 = this.BC();
                            n2 = this.DE();
                            int n53 = this.HL();
                            this.REFRESH(-2);
                            do {
                                this.writeByte(n2, this.readByte(n53));
                                n53 = this.dec16(n53);
                                n2 = this.dec16(n2);
                                n52 = this.dec16(n52);
                                this.tstatesCounter += 21;
                                this.REFRESH(2);
                            } while (n52 != 0);
                            if (n52 != 0) {
                                this.PC(this.PC() - 2 & 0xFFFF);
                                this.setH(false);
                                this.setN(false);
                                this.setPV(true);
                            } else {
                                this.tstatesCounter -= 5;
                                this.setH(false);
                                this.setN(false);
                                this.setPV(false);
                            }
                            this.DE(n2);
                            this.HL(n53);
                            this.BC(n52);
                            break;
                        }
                        case 185: {
                            boolean bl5 = this.Cset();
                            this.cp_a(this.readByte(this.HL()));
                            this.HL(this.dec16(this.HL()));
                            this.BC(this.dec16(this.BC()));
                            n2 = this.BC() != 0 ? 1 : 0;
                            this.setPV(n2 != 0);
                            this.setC(bl5);
                            if (n2 != 0 && !this.Zset()) {
                                this.PC(this.PC() - 2 & 0xFFFF);
                                this.tstatesCounter += 21;
                            }
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 186: {
                            this.writeByte(this.HL(), this.inByte(this.C(), this.B()));
                            int n54 = this.qdec8(this.B());
                            this.B(n54);
                            this.HL(this.dec16(this.HL()));
                            this.setZ(true);
                            this.setN(true);
                            if (n54 != 0) {
                                this.PC(this.PC() - 2 & 0xFFFF);
                                this.tstatesCounter += 21;
                            }
                            this.tstatesCounter += 16;
                            break;
                        }
                        case 187: {
                            int n55 = this.qdec8(this.B());
                            this.B(n55);
                            this.outByte(this.C(), this.B(), this.readByte(this.HL()));
                            this.HL(this.dec16(this.HL()));
                            this.setZ(true);
                            this.setN(true);
                            if (n55 != 0) {
                                this.PC(this.PC() - 2 & 0xFFFF);
                                this.tstatesCounter += 21;
                            }
                            this.tstatesCounter += 16;
                        }
                    }
                    continue block582;
                }
                case 245: {
                    this.pushw(this.AF());
                    this.tstatesCounter += 11;
                    break;
                }
                case 253: {
                    this.ID(this.IY());
                    this.execute_id();
                    this.IY(this.ID());
                    break;
                }
                case 198: {
                    this.add_a(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 206: {
                    this.adc_a(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 214: {
                    this.sub_a(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 222: {
                    this.sbc_a(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 230: {
                    this.and_a(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 238: {
                    this.xor_a(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 246: {
                    this.or_a(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 254: {
                    this.cp_a(this.readByte(this._PC++));
                    this.tstatesCounter += 7;
                    break;
                }
                case 199: {
                    this.pushw(this._PC);
                    this.PC(0);
                    this.tstatesCounter += 11;
                    break;
                }
                case 207: {
                    this.pushw(this._PC);
                    this.PC(8);
                    this.tstatesCounter += 11;
                    break;
                }
                case 215: {
                    this.pushw(this._PC);
                    this.PC(16);
                    this.tstatesCounter += 11;
                    break;
                }
                case 223: {
                    this.pushw(this._PC);
                    this.PC(24);
                    this.tstatesCounter += 11;
                    break;
                }
                case 231: {
                    this.pushw(this._PC);
                    this.PC(32);
                    this.tstatesCounter += 11;
                    break;
                }
                case 239: {
                    this.pushw(this._PC);
                    this.PC(40);
                    this.tstatesCounter += 11;
                    break;
                }
                case 247: {
                    this.pushw(this._PC);
                    this.PC(48);
                    this.tstatesCounter += 11;
                    break;
                }
                case 255: {
                    this.pushw(this._PC);
                    this.PC(56);
                    this.tstatesCounter += 11;
                }
            }
        } while (!bl & !this.z80Stopped);
    }

    private final void execute_id() {
        this.REFRESH(1);
        switch (this.readByte(this._PC++)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 95: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 228: 
            case 230: 
            case 231: 
            case 232: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: {
                this.PC(this.dec16(this.PC()));
                this.REFRESH(-1);
                this.tstatesCounter += 4;
                break;
            }
            case 9: {
                this.ID(this.add16(this.ID(), this.BC()));
                this.tstatesCounter += 15;
                break;
            }
            case 25: {
                this.ID(this.add16(this.ID(), this.DE()));
                this.tstatesCounter += 15;
                break;
            }
            case 41: {
                int n = this.ID();
                this.ID(this.add16(n, n));
                this.tstatesCounter += 15;
                break;
            }
            case 57: {
                this.ID(this.add16(this.ID(), this.SP()));
                this.tstatesCounter += 15;
                break;
            }
            case 33: {
                this.ID(this.nxtpcw());
                this.tstatesCounter += 14;
                break;
            }
            case 34: {
                this.writeWord(this.nxtpcw(), this.ID());
                this.tstatesCounter += 20;
                break;
            }
            case 42: {
                this.ID(this.readWord(this.nxtpcw()));
                this.tstatesCounter += 20;
                break;
            }
            case 35: {
                this.ID(this.inc16(this.ID()));
                this.tstatesCounter += 10;
                break;
            }
            case 43: {
                this.ID(this.dec16(this.ID()));
                this.tstatesCounter += 10;
                break;
            }
            case 36: {
                this.IDH(this.inc8(this.IDH()));
                this.tstatesCounter += 8;
                break;
            }
            case 44: {
                this.IDL(this.inc8(this.IDL()));
                this.tstatesCounter += 8;
                break;
            }
            case 52: {
                int n = this.ID_d();
                this.writeByte(n, this.inc8(this.readByte(n)));
                this.tstatesCounter += 23;
                break;
            }
            case 37: {
                this.IDH(this.dec8(this.IDH()));
                this.tstatesCounter += 8;
                break;
            }
            case 45: {
                this.IDL(this.dec8(this.IDL()));
                this.tstatesCounter += 8;
                break;
            }
            case 53: {
                int n = this.ID_d();
                this.writeByte(n, this.dec8(this.readByte(n)));
                this.tstatesCounter += 23;
                break;
            }
            case 38: {
                this.IDH(this.readByte(this._PC++));
                this.tstatesCounter += 11;
                break;
            }
            case 46: {
                this.IDL(this.readByte(this._PC++));
                this.tstatesCounter += 11;
                break;
            }
            case 54: {
                int n = this.ID_d();
                this.writeByte(n, this.readByte(this._PC++));
                this.tstatesCounter += 19;
                break;
            }
            case 68: {
                this.B(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 69: {
                this.B(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 70: {
                this.B(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 76: {
                this.C(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 77: {
                this.C(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 78: {
                this.C(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 84: {
                this.D(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 85: {
                this.D(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 86: {
                this.D(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 92: {
                this.E(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 93: {
                this.E(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 94: {
                this.E(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 96: {
                this.IDH(this.B());
                this.tstatesCounter += 8;
                break;
            }
            case 97: {
                this.IDH(this.C());
                this.tstatesCounter += 8;
                break;
            }
            case 98: {
                this.IDH(this.D());
                this.tstatesCounter += 8;
                break;
            }
            case 99: {
                this.IDH(this.E());
                this.tstatesCounter += 8;
                break;
            }
            case 100: {
                this.tstatesCounter += 8;
                break;
            }
            case 101: {
                this.IDH(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 102: {
                this.H(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 103: {
                this.IDH(this.A());
                this.tstatesCounter += 8;
                break;
            }
            case 104: {
                this.IDL(this.B());
                this.tstatesCounter += 8;
                break;
            }
            case 105: {
                this.IDL(this.C());
                this.tstatesCounter += 8;
                break;
            }
            case 106: {
                this.IDL(this.D());
                this.tstatesCounter += 8;
                break;
            }
            case 107: {
                this.IDL(this.E());
                this.tstatesCounter += 8;
                break;
            }
            case 108: {
                this.IDL(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 109: {
                this.tstatesCounter += 8;
                break;
            }
            case 110: {
                this.L(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 111: {
                this.IDL(this.A());
                this.tstatesCounter += 8;
                break;
            }
            case 112: {
                this.writeByte(this.ID_d(), this.B());
                this.tstatesCounter += 19;
                break;
            }
            case 113: {
                this.writeByte(this.ID_d(), this.C());
                this.tstatesCounter += 19;
                break;
            }
            case 114: {
                this.writeByte(this.ID_d(), this.D());
                this.tstatesCounter += 19;
                break;
            }
            case 115: {
                this.writeByte(this.ID_d(), this.E());
                this.tstatesCounter += 19;
                break;
            }
            case 116: {
                this.writeByte(this.ID_d(), this.H());
                this.tstatesCounter += 19;
                break;
            }
            case 117: {
                this.writeByte(this.ID_d(), this.L());
                this.tstatesCounter += 19;
                break;
            }
            case 119: {
                this.writeByte(this.ID_d(), this.A());
                this.tstatesCounter += 19;
                break;
            }
            case 124: {
                this.A(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 125: {
                this.A(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 126: {
                this.A(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 132: {
                this.add_a(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 133: {
                this.add_a(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 134: {
                this.add_a(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 140: {
                this.adc_a(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 141: {
                this.adc_a(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 142: {
                this.adc_a(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 148: {
                this.sub_a(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 149: {
                this.sub_a(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 150: {
                this.sub_a(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 156: {
                this.sbc_a(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 157: {
                this.sbc_a(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 158: {
                this.sbc_a(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 164: {
                this.and_a(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 165: {
                this.and_a(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 166: {
                this.and_a(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 172: {
                this.xor_a(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 173: {
                this.xor_a(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 174: {
                this.xor_a(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 180: {
                this.or_a(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 181: {
                this.or_a(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 182: {
                this.or_a(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 188: {
                this.cp_a(this.IDH());
                this.tstatesCounter += 8;
                break;
            }
            case 189: {
                this.cp_a(this.IDL());
                this.tstatesCounter += 8;
                break;
            }
            case 190: {
                this.cp_a(this.readByte(this.ID_d()));
                this.tstatesCounter += 19;
                break;
            }
            case 225: {
                this.ID(this.popw());
                this.tstatesCounter += 14;
                break;
            }
            case 233: {
                this.PC(this.ID());
                this.tstatesCounter += 8;
                break;
            }
            case 249: {
                this.SP(this.ID());
                this.tstatesCounter += 10;
                break;
            }
            case 203: {
                int n = this.ID_d();
                int n2 = this.readByte(this._PC++);
                switch (n2) {
                    case 0: {
                        n2 = this.rlc(this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 1: {
                        n2 = this.rlc(this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 2: {
                        n2 = this.rlc(this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 3: {
                        n2 = this.rlc(this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 4: {
                        n2 = this.rlc(this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 5: {
                        n2 = this.rlc(this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 6: {
                        this.writeByte(n, this.rlc(this.readByte(n)));
                        break;
                    }
                    case 7: {
                        n2 = this.rlc(this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 8: {
                        n2 = this.rrc(this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 9: {
                        n2 = this.rrc(this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 10: {
                        n2 = this.rrc(this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 11: {
                        n2 = this.rrc(this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 12: {
                        n2 = this.rrc(this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 13: {
                        n2 = this.rrc(this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 14: {
                        this.writeByte(n, this.rrc(this.readByte(n)));
                        break;
                    }
                    case 15: {
                        n2 = this.rrc(this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 16: {
                        n2 = this.rl(this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 17: {
                        n2 = this.rl(this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 18: {
                        n2 = this.rl(this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 19: {
                        n2 = this.rl(this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 20: {
                        n2 = this.rl(this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 21: {
                        n2 = this.rl(this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 22: {
                        this.writeByte(n, this.rl(this.readByte(n)));
                        break;
                    }
                    case 23: {
                        n2 = this.rl(this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 24: {
                        n2 = this.rr(this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 25: {
                        n2 = this.rr(this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 26: {
                        n2 = this.rr(this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 27: {
                        n2 = this.rr(this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 28: {
                        n2 = this.rr(this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 29: {
                        n2 = this.rr(this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 30: {
                        this.writeByte(n, this.rr(this.readByte(n)));
                        break;
                    }
                    case 31: {
                        n2 = this.rr(this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 32: {
                        n2 = this.sla(this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 33: {
                        n2 = this.sla(this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 34: {
                        n2 = this.sla(this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 35: {
                        n2 = this.sla(this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 36: {
                        n2 = this.sla(this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 37: {
                        n2 = this.sla(this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 38: {
                        this.writeByte(n, this.sla(this.readByte(n)));
                        break;
                    }
                    case 39: {
                        n2 = this.sla(this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 40: {
                        n2 = this.sra(this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 41: {
                        n2 = this.sra(this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 42: {
                        n2 = this.sra(this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 43: {
                        n2 = this.sra(this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 44: {
                        n2 = this.sra(this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 45: {
                        n2 = this.sra(this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 46: {
                        this.writeByte(n, this.sra(this.readByte(n)));
                        break;
                    }
                    case 47: {
                        n2 = this.sra(this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 48: {
                        n2 = this.sls(this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 49: {
                        n2 = this.sls(this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 50: {
                        n2 = this.sls(this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 51: {
                        n2 = this.sls(this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 52: {
                        n2 = this.sls(this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 53: {
                        n2 = this.sls(this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 54: {
                        this.writeByte(n, this.sls(this.readByte(n)));
                        break;
                    }
                    case 55: {
                        n2 = this.sls(this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 56: {
                        n2 = this.srl(this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 57: {
                        n2 = this.srl(this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 58: {
                        n2 = this.srl(this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 59: {
                        n2 = this.srl(this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 60: {
                        n2 = this.srl(this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 61: {
                        n2 = this.srl(this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 62: {
                        this.writeByte(n, this.srl(this.readByte(n)));
                        break;
                    }
                    case 63: {
                        n2 = this.srl(this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: {
                        this.bit(1, this.readByte(n));
                        break;
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: {
                        this.bit(2, this.readByte(n));
                        break;
                    }
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: {
                        this.bit(4, this.readByte(n));
                        break;
                    }
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        this.bit(8, this.readByte(n));
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: {
                        this.bit(16, this.readByte(n));
                        break;
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: {
                        this.bit(32, this.readByte(n));
                        break;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: {
                        this.bit(64, this.readByte(n));
                        break;
                    }
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: {
                        this.bit(128, this.readByte(n));
                        break;
                    }
                    case 128: {
                        n2 = this.res(1, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 129: {
                        n2 = this.res(1, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 130: {
                        n2 = this.res(1, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 131: {
                        n2 = this.res(1, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 132: {
                        n2 = this.res(1, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 133: {
                        n2 = this.res(1, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 134: {
                        this.writeByte(n, this.res(1, this.readByte(n)));
                        break;
                    }
                    case 135: {
                        n2 = this.res(1, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 136: {
                        n2 = this.res(2, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 137: {
                        n2 = this.res(2, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 138: {
                        n2 = this.res(2, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 139: {
                        n2 = this.res(2, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 140: {
                        n2 = this.res(2, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 141: {
                        n2 = this.res(2, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 142: {
                        this.writeByte(n, this.res(2, this.readByte(n)));
                        break;
                    }
                    case 143: {
                        n2 = this.res(2, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 144: {
                        n2 = this.res(4, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 145: {
                        n2 = this.res(4, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 146: {
                        n2 = this.res(4, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 147: {
                        n2 = this.res(4, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 148: {
                        n2 = this.res(4, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 149: {
                        n2 = this.res(4, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 150: {
                        this.writeByte(n, this.res(4, this.readByte(n)));
                        break;
                    }
                    case 151: {
                        n2 = this.res(4, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 152: {
                        n2 = this.res(8, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 153: {
                        n2 = this.res(8, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 154: {
                        n2 = this.res(8, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 155: {
                        n2 = this.res(8, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 156: {
                        n2 = this.res(8, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 157: {
                        n2 = this.res(8, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 158: {
                        this.writeByte(n, this.res(8, this.readByte(n)));
                        break;
                    }
                    case 159: {
                        n2 = this.res(8, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 160: {
                        n2 = this.res(16, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 161: {
                        n2 = this.res(16, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 162: {
                        n2 = this.res(16, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 163: {
                        n2 = this.res(16, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 164: {
                        n2 = this.res(16, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 165: {
                        n2 = this.res(16, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 166: {
                        this.writeByte(n, this.res(16, this.readByte(n)));
                        break;
                    }
                    case 167: {
                        n2 = this.res(16, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 168: {
                        n2 = this.res(32, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 169: {
                        n2 = this.res(32, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 170: {
                        n2 = this.res(32, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 171: {
                        n2 = this.res(32, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 172: {
                        n2 = this.res(32, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 173: {
                        n2 = this.res(32, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 174: {
                        this.writeByte(n, this.res(32, this.readByte(n)));
                        break;
                    }
                    case 175: {
                        n2 = this.res(32, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 176: {
                        n2 = this.res(64, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 177: {
                        n2 = this.res(64, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 178: {
                        n2 = this.res(64, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 179: {
                        n2 = this.res(64, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 180: {
                        n2 = this.res(64, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 181: {
                        n2 = this.res(64, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 182: {
                        this.writeByte(n, this.res(64, this.readByte(n)));
                        break;
                    }
                    case 183: {
                        n2 = this.res(64, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 184: {
                        n2 = this.res(128, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 185: {
                        n2 = this.res(128, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 186: {
                        n2 = this.res(128, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 187: {
                        n2 = this.res(128, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 188: {
                        n2 = this.res(128, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 189: {
                        n2 = this.res(128, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 190: {
                        this.writeByte(n, this.res(128, this.readByte(n)));
                        break;
                    }
                    case 191: {
                        n2 = this.res(128, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 192: {
                        n2 = this.set(1, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 193: {
                        n2 = this.set(1, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 194: {
                        n2 = this.set(1, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 195: {
                        n2 = this.set(1, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 196: {
                        n2 = this.set(1, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 197: {
                        n2 = this.set(1, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 198: {
                        this.writeByte(n, this.set(1, this.readByte(n)));
                        break;
                    }
                    case 199: {
                        n2 = this.set(1, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 200: {
                        n2 = this.set(2, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 201: {
                        n2 = this.set(2, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 202: {
                        n2 = this.set(2, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 203: {
                        n2 = this.set(2, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 204: {
                        n2 = this.set(2, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 205: {
                        n2 = this.set(2, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 206: {
                        this.writeByte(n, this.set(2, this.readByte(n)));
                        break;
                    }
                    case 207: {
                        n2 = this.set(2, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 208: {
                        n2 = this.set(4, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 209: {
                        n2 = this.set(4, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 210: {
                        n2 = this.set(4, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 211: {
                        n2 = this.set(4, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 212: {
                        n2 = this.set(4, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 213: {
                        n2 = this.set(4, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 214: {
                        this.writeByte(n, this.set(4, this.readByte(n)));
                        break;
                    }
                    case 215: {
                        n2 = this.set(4, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 216: {
                        n2 = this.set(8, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 217: {
                        n2 = this.set(8, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 218: {
                        n2 = this.set(8, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 219: {
                        n2 = this.set(8, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 220: {
                        n2 = this.set(8, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 221: {
                        n2 = this.set(8, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 222: {
                        this.writeByte(n, this.set(8, this.readByte(n)));
                        break;
                    }
                    case 223: {
                        n2 = this.set(8, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 224: {
                        n2 = this.set(16, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 225: {
                        n2 = this.set(16, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 226: {
                        n2 = this.set(16, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 227: {
                        n2 = this.set(16, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 228: {
                        n2 = this.set(16, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 229: {
                        n2 = this.set(16, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 230: {
                        this.writeByte(n, this.set(16, this.readByte(n)));
                        break;
                    }
                    case 231: {
                        n2 = this.set(16, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 232: {
                        n2 = this.set(32, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 233: {
                        n2 = this.set(32, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 234: {
                        n2 = this.set(32, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 235: {
                        n2 = this.set(32, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 236: {
                        n2 = this.set(32, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 237: {
                        n2 = this.set(32, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 238: {
                        this.writeByte(n, this.set(32, this.readByte(n)));
                        break;
                    }
                    case 239: {
                        n2 = this.set(32, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 240: {
                        n2 = this.set(64, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 241: {
                        n2 = this.set(64, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 242: {
                        n2 = this.set(64, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 243: {
                        n2 = this.set(64, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 244: {
                        n2 = this.set(64, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 245: {
                        n2 = this.set(64, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 246: {
                        this.writeByte(n, this.set(64, this.readByte(n)));
                        break;
                    }
                    case 247: {
                        n2 = this.set(64, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 248: {
                        n2 = this.set(128, this.readByte(n));
                        this.B(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 249: {
                        n2 = this.set(128, this.readByte(n));
                        this.C(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 250: {
                        n2 = this.set(128, this.readByte(n));
                        this.D(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 251: {
                        n2 = this.set(128, this.readByte(n));
                        this.E(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 252: {
                        n2 = this.set(128, this.readByte(n));
                        this.H(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 253: {
                        n2 = this.set(128, this.readByte(n));
                        this.L(n2);
                        this.writeByte(n, n2);
                        break;
                    }
                    case 254: {
                        this.writeByte(n, this.set(128, this.readByte(n)));
                        break;
                    }
                    case 255: {
                        n2 = this.set(128, this.readByte(n));
                        this.A(n2);
                        this.writeByte(n, n2);
                    }
                }
                this.tstatesCounter += (n2 & 0xC0) == 64 ? 20 : 23;
                break;
            }
            case 227: {
                int n = this.ID();
                int n3 = this.SP();
                this.ID(this.readWord(n3));
                this.writeWord(n3, n);
                this.tstatesCounter += 23;
                break;
            }
            case 229: {
                this.pushw(this.ID());
                this.tstatesCounter += 15;
            }
        }
    }

    private final int in_bc() {
        int n = this.inByte(this.C(), this.B());
        this.setZ(n == 0);
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setPV(this.parity[n]);
        this.setN(false);
        this.setH(false);
        return n;
    }

    private final void adc_a(int n) {
        int n2 = this.A();
        int n3 = this.Cset() ? 1 : 0;
        int n4 = n2 + n + n3;
        int n5 = n4 & 0xFF;
        this.setS((n5 & 0x80) != 0);
        this.set3((n5 & 8) != 0);
        this.set5((n5 & 0x20) != 0);
        this.setZ(n5 == 0);
        this.setC((n4 & 0x100) != 0);
        this.setPV(((n2 ^ ~n) & (n2 ^ n5) & 0x80) != 0);
        this.setH(((n2 & 0xF) + (n & 0xF) + n3 & 0x10) != 0);
        this.setN(false);
        this.A(n5);
    }

    private final void add_a(int n) {
        int n2 = this.A();
        int n3 = n2 + n;
        int n4 = n3 & 0xFF;
        this.setS((n4 & 0x80) != 0);
        this.set3((n4 & 8) != 0);
        this.set5((n4 & 0x20) != 0);
        this.setZ(n4 == 0);
        this.setC((n3 & 0x100) != 0);
        this.setPV(((n2 ^ ~n) & (n2 ^ n4) & 0x80) != 0);
        this.setH(((n2 & 0xF) + (n & 0xF) & 0x10) != 0);
        this.setN(false);
        this.A(n4);
    }

    private final void sbc_a(int n) {
        int n2 = this.A();
        int n3 = this.Cset() ? 1 : 0;
        int n4 = n2 - n - n3;
        int n5 = n4 & 0xFF;
        this.setS((n5 & 0x80) != 0);
        this.set3((n5 & 8) != 0);
        this.set5((n5 & 0x20) != 0);
        this.setZ(n5 == 0);
        this.setC((n4 & 0x100) != 0);
        this.setPV(((n2 ^ n) & (n2 ^ n5) & 0x80) != 0);
        this.setH(((n2 & 0xF) - (n & 0xF) - n3 & 0x10) != 0);
        this.setN(true);
        this.A(n5);
    }

    private final void sub_a(int n) {
        int n2 = this.A();
        int n3 = n2 - n;
        int n4 = n3 & 0xFF;
        this.setS((n4 & 0x80) != 0);
        this.set3((n4 & 8) != 0);
        this.set5((n4 & 0x20) != 0);
        this.setZ(n4 == 0);
        this.setC((n3 & 0x100) != 0);
        this.setPV(((n2 ^ n) & (n2 ^ n4) & 0x80) != 0);
        this.setH(((n2 & 0xF) - (n & 0xF) & 0x10) != 0);
        this.setN(true);
        this.A(n4);
    }

    private final void rlc_a() {
        boolean bl;
        int n = this.A();
        boolean bl2 = bl = (n & 0x80) != 0;
        n = bl ? n << 1 | 1 : (n <<= 1);
        this.set3(((n &= 0xFF) & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(bl);
        this.A(n);
    }

    private final void rrc_a() {
        boolean bl;
        int n = this.A();
        boolean bl2 = bl = (n & 1) != 0;
        n = bl ? n >> 1 | 0x80 : (n >>= 1);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(bl);
        this.A(n);
    }

    private final void rl_a() {
        boolean bl;
        int n = this.A();
        boolean bl2 = bl = (n & 0x80) != 0;
        n = this.Cset() ? n << 1 | 1 : (n <<= 1);
        this.set3(((n &= 0xFF) & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(bl);
        this.A(n);
    }

    private final void rr_a() {
        boolean bl;
        int n = this.A();
        boolean bl2 = bl = (n & 1) != 0;
        n = this.Cset() ? n >> 1 | 0x80 : (n >>= 1);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(bl);
        this.A(n);
    }

    private final void cp_a(int n) {
        int n2 = this.A();
        int n3 = n2 - n;
        int n4 = n3 & 0xFF;
        this.setS((n4 & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(true);
        this.setZ(n4 == 0);
        this.setC((n3 & 0x100) != 0);
        this.setH(((n2 & 0xF) - (n & 0xF) & 0x10) != 0);
        this.setPV(((n2 ^ n) & (n2 ^ n4) & 0x80) != 0);
    }

    private final void and_a(int n) {
        int n2 = this.A() & n;
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setH(true);
        this.setPV(this.parity[n2]);
        this.setZ(n2 == 0);
        this.setN(false);
        this.setC(false);
        this.A(n2);
    }

    private final void or_a(int n) {
        int n2 = this.A() | n;
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setH(false);
        this.setPV(this.parity[n2]);
        this.setZ(n2 == 0);
        this.setN(false);
        this.setC(false);
        this.A(n2);
    }

    private final void xor_a(int n) {
        int n2 = (this.A() ^ n) & 0xFF;
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setH(false);
        this.setPV(this.parity[n2]);
        this.setZ(n2 == 0);
        this.setN(false);
        this.setC(false);
        this.A(n2);
    }

    private final void neg_a() {
        int n = this.A();
        this.A(0);
        this.sub_a(n);
    }

    private final void cpl_a() {
        int n = this.A() ^ 0xFF;
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setH(true);
        this.setN(true);
        this.A(n);
    }

    private final void daa_a() {
        int n = this.A();
        int n2 = 0;
        boolean bl = this.Cset();
        if (this.Hset() || (n & 0xF) > 9) {
            n2 |= 6;
        }
        if (bl || n > 159 || n > 143 && (n & 0xF) > 9) {
            n2 |= 0x60;
        }
        if (n > 153) {
            bl = true;
        }
        if (this.Nset()) {
            this.sub_a(n2);
        } else {
            this.add_a(n2);
        }
        n = this.A();
        this.setC(bl);
        this.setPV(this.parity[n]);
    }

    private final void ld_a_i() {
        int n = this.I();
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(n);
    }

    private final void ld_a_r() {
        int n = this.R();
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.IFF2());
        this.setH(false);
        this.setN(false);
        this.A(n);
    }

    private final void rrd_a() {
        int n;
        int n2 = this.A();
        int n3 = n = this.readByte(this.HL());
        n = n >> 4 | n2 << 4;
        n2 = n2 & 0xF0 | n3 & 0xF;
        this.writeByte(this.HL(), n);
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setZ(n2 == 0);
        this.setPV(this.parity[n2]);
        this.setH(false);
        this.setN(false);
        this.A(n2);
    }

    private final void rld_a() {
        int n;
        int n2 = this.A();
        int n3 = n = this.readByte(this.HL());
        n = n << 4 | n2 & 0xF;
        n2 = n2 & 0xF0 | n3 >> 4;
        this.writeByte(this.HL(), n & 0xFF);
        this.setS((n2 & 0x80) != 0);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setZ(n2 == 0);
        this.setPV(this.parity[n2]);
        this.setH(false);
        this.setN(false);
        this.A(n2);
    }

    private final void bit(int n, int n2) {
        boolean bl = (n2 & n) != 0;
        this.setN(false);
        this.setH(true);
        this.set3((n2 & 8) != 0);
        this.set5((n2 & 0x20) != 0);
        this.setS(n == 128 ? bl : false);
        this.setZ(!bl);
        this.setPV(!bl);
    }

    private final void scf() {
        int n = this.A();
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setH(false);
        this.setC(true);
    }

    private final void ccf() {
        int n = this.A();
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setN(false);
        this.setC(!this.Cset());
    }

    private final int rlc(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 0x80) != 0;
        n = bl ? n << 1 | 1 : (n <<= 1);
        this.setS(((n &= 0xFF) & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int rrc(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 1) != 0;
        n = bl ? n >> 1 | 0x80 : (n >>= 1);
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int rl(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 0x80) != 0;
        n = this.Cset() ? n << 1 | 1 : (n <<= 1);
        this.setS(((n &= 0xFF) & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int rr(int n) {
        boolean bl;
        boolean bl2 = bl = (n & 1) != 0;
        n = this.Cset() ? n >> 1 | 0x80 : (n >>= 1);
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int sla(int n) {
        boolean bl = (n & 0x80) != 0;
        n = n << 1 & 0xFF;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int sls(int n) {
        boolean bl = (n & 0x80) != 0;
        n = (n << 1 | 1) & 0xFF;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int sra(int n) {
        boolean bl = (n & 1) != 0;
        n = n >> 1 | n & 0x80;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int srl(int n) {
        boolean bl = (n & 1) != 0;
        this.setS(((n >>= 1) & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(this.parity[n]);
        this.setH(false);
        this.setN(false);
        this.setC(bl);
        return n;
    }

    private final int dec8(int n) {
        boolean bl = n == 128;
        boolean bl2 = ((n & 0xF) - 1 & 0x10) != 0;
        n = n - 1 & 0xFF;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(bl);
        this.setH(bl2);
        this.setN(true);
        return n;
    }

    private final int inc8(int n) {
        boolean bl = n == 127;
        boolean bl2 = ((n & 0xF) + 1 & 0x10) != 0;
        n = n + 1 & 0xFF;
        this.setS((n & 0x80) != 0);
        this.set3((n & 8) != 0);
        this.set5((n & 0x20) != 0);
        this.setZ(n == 0);
        this.setPV(bl);
        this.setH(bl2);
        this.setN(false);
        return n;
    }

    private final int adc16(int n, int n2) {
        int n3 = this.Cset() ? 1 : 0;
        int n4 = n + n2 + n3;
        int n5 = n4 & 0xFFFF;
        this.setS((n5 & 0x8000) != 0);
        this.set3((n5 & 0x800) != 0);
        this.set5((n5 & 0x2000) != 0);
        this.setZ(n5 == 0);
        this.setC((n4 & 0x10000) != 0);
        this.setPV(((n ^ ~n2) & (n ^ n5) & 0x8000) != 0);
        this.setH(((n & 0xFFF) + (n2 & 0xFFF) + n3 & 0x1000) != 0);
        this.setN(false);
        return n5;
    }

    private final int add16(int n, int n2) {
        int n3 = n + n2;
        int n4 = n3 & 0xFFFF;
        this.set3((n4 & 0x800) != 0);
        this.set5((n4 & 0x2000) != 0);
        this.setC((n3 & 0x10000) != 0);
        this.setH(((n & 0xFFF) + (n2 & 0xFFF) & 0x1000) != 0);
        this.setN(false);
        return n4;
    }

    private final int sbc16(int n, int n2) {
        int n3 = this.Cset() ? 1 : 0;
        int n4 = n - n2 - n3;
        int n5 = n4 & 0xFFFF;
        this.setS((n5 & 0x8000) != 0);
        this.set3((n5 & 0x800) != 0);
        this.set5((n5 & 0x2000) != 0);
        this.setZ(n5 == 0);
        this.setC((n4 & 0x10000) != 0);
        this.setPV(((n ^ n2) & (n ^ n5) & 0x8000) != 0);
        this.setH(((n & 0xFFF) - (n2 & 0xFFF) - n3 & 0x1000) != 0);
        this.setN(true);
        return n5;
    }

    public final void exx() {
        int n = this.HL();
        this.HL(this._HL_);
        this._HL_ = n;
        n = this.DE();
        this.DE(this._DE_);
        this._DE_ = n;
        n = this.BC();
        this.BC(this._BC_);
        this._BC_ = n;
    }

    public final void ex_af_af() {
        int n = this.AF();
        this.AF(this._AF_);
        this._AF_ = n;
    }

    private final int inc16(int n) {
        return n + 1 & 0xFFFF;
    }

    private final int qinc8(int n) {
        return n + 1 & 0xFF;
    }

    private final int dec16(int n) {
        return n - 1 & 0xFFFF;
    }

    private final int qdec8(int n) {
        return n - 1 & 0xFF;
    }

    private final int res(int n, int n2) {
        return n2 & ~n;
    }

    private final int set(int n, int n2) {
        return n2 | n;
    }
}

