/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.OZvm;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88Keyboard;
import com.jira.cambridgez88.ozvm.screen.Z88display;
import java.io.File;
import java.io.IOException;

public class Z88 {
    private final Blink blink;
    private final Memory memory;
    private final Z88Keyboard keyboard;
    private final Z88display display;
    private final Z80Processor z80 = new Z80Processor();
    private Thread z80Thread;

    private Z88() {
        this.blink = new Blink();
        this.memory = new Memory();
        this.display = new Z88display();
        this.keyboard = new Z88Keyboard();
        this.z80.connectBlink(this.blink);
        this.blink.connectProcessor(this.z80);
        this.blink.connectMemory(this.memory);
        this.blink.connectKeyboard(this.keyboard);
        this.display.connectProcessor(this.z80);
        this.display.connectBlink(this.blink);
        this.display.connectMemory(this.memory);
        this.display.addKeyListener(this.keyboard.processKeyInput());
    }

    private void stopZ80Cpu() {
        if (this.getProcessorThread() != null) {
            this.getProcessor().stopZ80Execution();
            this.blink.awakeZ80();
            while (this.z80.isZ80ThreadRunning()) {
                Thread.yield();
            }
        }
        this.z80Thread = null;
    }

    public static Z88 getInstance() {
        return singletonContainer.singleton;
    }

    public Blink getBlink() {
        return this.blink;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public Z88display getDisplay() {
        return this.display;
    }

    public Z88Keyboard getKeyboard() {
        return this.keyboard;
    }

    public void pressResetButton() {
        this.stopZ80Cpu();
        this.z80.reset();
        this.runZ80Cpu();
    }

    public void hardResetWithSlot0Rom(File file) throws IOException {
        this.stopZ80Cpu();
        this.getMemory().loadRomBinary(file);
        this.getMemory().resetRam();
        this.blink.resetBlinkRegisters();
        this.getProcessor().reset();
        this.runZ80Cpu();
    }

    public void hardReset() {
        this.stopZ80Cpu();
        this.memory.resetRam();
        this.blink.resetBlinkRegisters();
        this.pressResetButton();
    }

    public Z80Processor getProcessor() {
        return this.z80;
    }

    public Thread getProcessorThread() {
        if (this.z80Thread != null && this.z80Thread.isAlive()) {
            return this.z80Thread;
        }
        this.z80Thread = null;
        return null;
    }

    public boolean runZ80Cpu() {
        if (this.z80Thread != null && this.z80Thread.isAlive()) {
            return false;
        }
        OZvm.displayRtmMessage("Z88 virtual machine was started.");
        this.z80Thread = new Thread(this.z80);
        this.z80Thread.start();
        return true;
    }

    public boolean runZ80Cpu(int n) {
        if (this.z80Thread != null && this.z80Thread.isAlive()) {
            return false;
        }
        this.z80.setOneStopBreakpoint(n);
        return this.runZ80Cpu();
    }

    /* synthetic */ Z88(Z88 z88) {
        this();
    }

    private static final class singletonContainer {
        static final Z88 singleton = new Z88(null);

        private singletonContainer() {
        }
    }
}

