/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.filecard;

import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.EpromBank;
import com.jira.cambridgez88.ozvm.GenericAmdFlashBank;
import com.jira.cambridgez88.ozvm.IntelFlashBank;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.datastructures.ApplicationCardHeader;
import com.jira.cambridgez88.ozvm.datastructures.FileAreaHeader;
import com.jira.cambridgez88.ozvm.datastructures.SlotInfo;
import com.jira.cambridgez88.ozvm.filecard.FileAreaExhaustedException;
import com.jira.cambridgez88.ozvm.filecard.FileAreaNotFoundException;
import com.jira.cambridgez88.ozvm.filecard.FileEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;

public class FileArea {
    private static byte[] nullFile;
    private Memory memory = Z88.getInstance().getMemory();
    private SlotInfo slotinfo = SlotInfo.getInstance();
    private int slotNumber;
    private int fileAreaTopBank;
    private int fileAreaBottomBank;
    private FileAreaHeader fileAreaHdr;
    private LinkedList filesList;

    static {
        byte[] byArray = new byte[6];
        byArray[0] = 1;
        nullFile = byArray;
    }

    public FileArea(int n) throws FileAreaNotFoundException {
        this.slotNumber = n;
        this.fileAreaTopBank = this.slotinfo.getFileHeaderBank(this.slotNumber);
        if (this.fileAreaTopBank == -1) {
            throw new FileAreaNotFoundException();
        }
        this.fileAreaHdr = new FileAreaHeader(this.fileAreaTopBank);
        this.fileAreaBottomBank = this.fileAreaTopBank - this.fileAreaHdr.getSize() + 1;
        this.refreshFileList();
    }

    public void scanFileArea() throws FileAreaNotFoundException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        this.refreshFileList();
    }

    private void refreshFileList() {
        this.filesList = new LinkedList();
        int n = this.fileAreaBottomBank << 16;
        while (this.memory.getByte(n) != 255 & this.memory.getByte(n) != 0) {
            FileEntry fileEntry = new FileEntry(n);
            this.filesList.add(fileEntry);
            n = this.intToPtr(this.ptrToInt(n) + fileEntry.getHdrLength() + fileEntry.getFileLength());
        }
    }

    public ListIterator getFileEntries() throws FileAreaNotFoundException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList != null & this.filesList.size() > 0) {
            return this.filesList.listIterator(0);
        }
        return null;
    }

    public String[] getFileEntryNames() throws FileAreaNotFoundException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList != null & this.filesList.size() > 0) {
            String[] stringArray = new String[this.getActiveFileCount()];
            int n = 0;
            int n2 = 0;
            while (n2 < this.filesList.size()) {
                FileEntry fileEntry = (FileEntry)this.filesList.get(n2);
                if (!fileEntry.isDeleted()) {
                    stringArray[n++] = fileEntry.getFileName();
                }
                ++n2;
            }
            return stringArray;
        }
        return null;
    }

    public FileEntry getFileEntry(String string) throws FileAreaNotFoundException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList == null || this.filesList.size() == 0) {
            return null;
        }
        int n = 0;
        while (n < this.filesList.size()) {
            FileEntry fileEntry = (FileEntry)this.filesList.get(n);
            if (fileEntry.getFileName().compareToIgnoreCase(string) == 0) {
                return fileEntry;
            }
            ++n;
        }
        return null;
    }

    public int getFreeSpace() throws FileAreaNotFoundException {
        int n = 0;
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList != null & this.filesList.size() > 0) {
            FileEntry fileEntry = (FileEntry)this.filesList.getLast();
            int n2 = this.intToPtr(this.ptrToInt(fileEntry.getFileEntryPtr()) + fileEntry.getHdrLength() + fileEntry.getFileLength());
            int n3 = this.fileAreaHdr.getBankNo() << 16 | 0x3FC0;
            n = this.ptrToInt(n3) - this.ptrToInt(n2);
        } else {
            n = this.getFileAreaSize();
        }
        return n;
    }

    public int getDeletedSpace() throws FileAreaNotFoundException {
        int n = 0;
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList == null || this.filesList.size() == 0) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.filesList.size()) {
            FileEntry fileEntry = (FileEntry)this.filesList.get(n2);
            if (fileEntry.isDeleted()) {
                n += fileEntry.getHdrLength() + fileEntry.getFileLength();
            }
            ++n2;
        }
        return n;
    }

    public int getFileAreaSize() throws FileAreaNotFoundException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        return this.fileAreaHdr.getSize() * 16384 - 64;
    }

    public int getActiveFileCount() throws FileAreaNotFoundException {
        int n = 0;
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList != null & this.filesList.size() > 0) {
            int n2 = 0;
            while (n2 < this.filesList.size()) {
                FileEntry fileEntry = (FileEntry)this.filesList.get(n2);
                if (!fileEntry.isDeleted()) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public int getDeletedFileCount() throws FileAreaNotFoundException {
        int n = 0;
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList != null & this.filesList.size() > 0) {
            int n2 = 0;
            while (n2 < this.filesList.size()) {
                FileEntry fileEntry = (FileEntry)this.filesList.get(n2);
                if (fileEntry.isDeleted()) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private int getFreeSpacePtr() throws FileAreaNotFoundException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList != null & this.filesList.size() > 0) {
            FileEntry fileEntry = (FileEntry)this.filesList.getLast();
            return this.intToPtr(this.ptrToInt(fileEntry.getFileEntryPtr()) + fileEntry.getHdrLength() + fileEntry.getFileLength());
        }
        return this.fileAreaBottomBank << 16;
    }

    public void storeFile(String string, byte[] byArray) throws FileAreaNotFoundException, FileAreaExhaustedException {
        int n;
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (1 + string.length() + 4 + byArray.length > this.getFreeSpace()) {
            throw new FileAreaExhaustedException();
        }
        this.markAsDeleted(string);
        int n2 = n = this.getFreeSpacePtr();
        this.memory.setByte(n2, string.length());
        n2 = this.memory.getNextExtAddress(n2);
        byte[] byArray2 = string.getBytes();
        int n3 = 0;
        int n4 = string.length();
        while (n3 < n4) {
            this.memory.setByte(n2, byArray2[n3]);
            n2 = this.memory.getNextExtAddress(n2);
            ++n3;
        }
        n3 = byArray.length;
        n4 = 0;
        while (n4 < 4) {
            this.memory.setByte(n2, n3 & 0xFF);
            n2 = this.memory.getNextExtAddress(n2);
            n3 >>>= 8;
            ++n4;
        }
        n4 = 0;
        int n5 = byArray.length;
        while (n4 < n5) {
            this.memory.setByte(n2, byArray[n4]);
            n2 = this.memory.getNextExtAddress(n2);
            ++n4;
        }
        FileEntry fileEntry = new FileEntry(n);
        if (this.filesList == null) {
            this.filesList = new LinkedList();
        }
        this.filesList.add(fileEntry);
    }

    public boolean isImportable(File[] fileArray) throws FileAreaNotFoundException, IOException {
        int n = 0;
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (!fileArray[n2].isFile()) {
                throw new IOException("Not a file.");
            }
            String string = this.convertHostFileName(fileArray[n2]);
            n = (int)((long)n + ((long)(1 + string.length() + 4) + fileArray[n2].length()));
            ++n2;
        }
        if (n <= this.getFreeSpace()) {
            return true;
        }
        return true;
    }

    public void importHostFile(File file) throws FileAreaNotFoundException, FileAreaExhaustedException, IOException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (!file.isFile()) {
            throw new IOException("Not a file.");
        }
        String string = this.convertHostFileName(file);
        if ((long)(1 + string.length() + 4) + file.length() > (long)this.getFreeSpace()) {
            throw new FileAreaExhaustedException();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(byArray);
        randomAccessFile.close();
        this.storeFile(string, byArray);
    }

    public void exportFileEntry(FileEntry fileEntry, String string) throws IOException {
        String string2 = fileEntry.getFileName();
        string2 = string2.substring(string2.lastIndexOf("/") + 1);
        string2 = String.valueOf(string) + File.separator + string2;
        new File(string2).delete();
        RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
        randomAccessFile.write(fileEntry.getFileImage());
        randomAccessFile.close();
    }

    public void importHostFiles(File file) throws FileAreaNotFoundException, FileAreaExhaustedException, IOException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (!file.isDirectory()) {
            throw new IOException("Not a directory.");
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                this.importHostFile(fileArray[n]);
            }
            ++n;
        }
    }

    private String convertHostFileName(File file) {
        String string = "/" + file.getName();
        return string;
    }

    public boolean isFileAreaAvailable() {
        if (this.fileAreaHdr == null) {
            this.fileAreaTopBank = this.slotinfo.getFileHeaderBank(this.slotNumber);
            if (this.fileAreaTopBank == -1) {
                return false;
            }
            this.fileAreaHdr = new FileAreaHeader(this.fileAreaTopBank);
            this.fileAreaBottomBank = this.fileAreaTopBank - this.fileAreaHdr.getSize() + 1;
            this.refreshFileList();
        }
        if (!this.slotinfo.isFileHeader(this.fileAreaTopBank)) {
            this.fileAreaTopBank = this.slotinfo.getFileHeaderBank(this.slotNumber);
            if (this.fileAreaTopBank == -1) {
                this.fileAreaHdr = null;
                this.filesList = null;
                return false;
            }
            this.fileAreaHdr = new FileAreaHeader(this.fileAreaTopBank);
            this.fileAreaBottomBank = this.fileAreaTopBank - this.fileAreaHdr.getSize() + 1;
            this.refreshFileList();
            return true;
        }
        int n = this.memory.getByte(16376, this.fileAreaTopBank) << 24 | this.memory.getByte(16377, this.fileAreaTopBank) << 16 | this.memory.getByte(16378, this.fileAreaTopBank) << 8 | this.memory.getByte(16379, this.fileAreaTopBank);
        if (n != this.fileAreaHdr.getRandomId()) {
            this.refreshFileList();
        }
        return true;
    }

    public static boolean isCreateable(int n) {
        Memory memory = Z88.getInstance().getMemory();
        SlotInfo slotInfo = SlotInfo.getInstance();
        if ((n &= 3) == 0) {
            return false;
        }
        int n2 = n << 6 | 0x3F;
        Bank bank = memory.getBank(n2);
        if (!(bank instanceof EpromBank) & !(bank instanceof GenericAmdFlashBank) & !(bank instanceof IntelFlashBank)) {
            return false;
        }
        int n3 = slotInfo.getFileHeaderBank(n);
        if (n3 != -1) {
            return true;
        }
        if (slotInfo.isApplicationCard(n)) {
            GenericAmdFlashBank genericAmdFlashBank;
            ApplicationCardHeader applicationCardHeader = new ApplicationCardHeader(n);
            if (bank instanceof EpromBank) {
                return memory.getExternalCardSize(n) != applicationCardHeader.getAppAreaSize();
            }
            int n4 = memory.getExternalCardSize(n) - applicationCardHeader.getAppAreaSize();
            if (bank instanceof GenericAmdFlashBank && (genericAmdFlashBank = (GenericAmdFlashBank)bank).getDeviceCode() == 32) {
                return n4 >= 1;
            }
            return n4 >= 4;
        }
        return true;
    }

    public static boolean create(int n, boolean bl) {
        int n2;
        Memory memory = Z88.getInstance().getMemory();
        SlotInfo slotInfo = SlotInfo.getInstance();
        if ((n &= 3) == 0) {
            return false;
        }
        int n3 = n << 6 | 0x3F;
        Bank bank = memory.getBank(n3);
        if (!(bank instanceof EpromBank) & !(bank instanceof GenericAmdFlashBank) & !(bank instanceof IntelFlashBank)) {
            return false;
        }
        int n4 = slotInfo.getFileHeaderBank(n);
        if (n4 != -1) {
            if (bl) {
                FileArea.formatFileArea(n4);
            }
        } else if (slotInfo.isOzRom(n) | slotInfo.isApplicationCard(n)) {
            ApplicationCardHeader applicationCardHeader = new ApplicationCardHeader(n);
            if (bank instanceof EpromBank) {
                if (memory.getExternalCardSize(n) == applicationCardHeader.getAppAreaSize()) {
                    return false;
                }
                n2 = memory.getExternalCardSize(n) - applicationCardHeader.getAppAreaSize() - 1;
                if (bl) {
                    FileArea.formatFileArea(n2);
                }
            } else {
                GenericAmdFlashBank genericAmdFlashBank;
                n2 = memory.getExternalCardSize(n) - applicationCardHeader.getAppAreaSize();
                n2 -= n2 % 4;
                if (bank instanceof GenericAmdFlashBank ? ((genericAmdFlashBank = (GenericAmdFlashBank)bank).getDeviceCode() == 32 ? n2 < 1 : n2 < 4) : n2 < 4) {
                    return false;
                }
                int n5 = applicationCardHeader.getAppAreaSize();
                if (n5 % 4 > 0) {
                    n5 += 4 - n5 % 4;
                }
                int n6 = n3 - n5;
                if (bl) {
                    FileArea.formatFileArea(n6);
                }
            }
        } else if (bl) {
            FileArea.formatFileArea(n3);
        }
        if (bank instanceof IntelFlashBank & bl) {
            int n7 = n << 22;
            n2 = 0;
            while (n2 < nullFile.length) {
                memory.setByte(n7++, nullFile[n2]);
                ++n2;
            }
        }
        return true;
    }

    public static boolean checkFileAreaImage(File file) {
        boolean bl = true;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            switch ((int)randomAccessFile.length()) {
                case 32768: 
                case 131072: 
                case 262144: 
                case 524288: 
                case 0x100000: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
            randomAccessFile.seek(randomAccessFile.length() - 4L);
            if ((long)(randomAccessFile.readByte() * 16384) != randomAccessFile.length()) {
                bl = false;
            }
            randomAccessFile.readByte();
            byte by = randomAccessFile.readByte();
            byte by2 = randomAccessFile.readByte();
            if (by != 111 & by2 != 122) {
                bl = false;
            }
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return bl;
    }

    public static boolean createFileHeader(int n) {
        Memory memory = Z88.getInstance().getMemory();
        Random random = new Random();
        int n2 = (n & 0xC0) >> 6;
        if (n2 == 0) {
            return false;
        }
        Bank bank = memory.getBank(n);
        if (bank instanceof EpromBank | bank instanceof GenericAmdFlashBank | bank instanceof IntelFlashBank) {
            int n3 = 16320;
            while (n3 < 16375) {
                memory.setByte(n3, n, 0);
                ++n3;
            }
            memory.setByte(16375, n, 1);
            memory.setByte(16376, n, random.nextInt(255));
            memory.setByte(16377, n, random.nextInt(255));
            memory.setByte(16378, n, random.nextInt(255));
            memory.setByte(16379, n, random.nextInt(255));
            n3 = (n & memory.getExternalCardSize(n2) - 1) + 1;
            memory.setByte(16380, n, n3);
            if (bank instanceof EpromBank) {
                if (memory.getExternalCardSize(n2) == 2) {
                    memory.setByte(16381, n, 126);
                } else {
                    memory.setByte(16381, n, 124);
                }
            }
            if (bank instanceof GenericAmdFlashBank) {
                memory.setByte(16381, n, 111);
            }
            if (bank instanceof IntelFlashBank) {
                memory.setByte(16381, n, 119);
            }
            memory.setByte(16382, n, 111);
            memory.setByte(16383, n, 122);
            return true;
        }
        return false;
    }

    public boolean markAsDeleted(String string) throws FileAreaNotFoundException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        FileEntry fileEntry = this.getFileEntry(string);
        if (fileEntry == null) {
            return false;
        }
        int n = fileEntry.getFileEntryPtr();
        n = this.memory.getNextExtAddress(n);
        this.memory.setByte(n, 0);
        n = fileEntry.getFileEntryPtr();
        FileEntry fileEntry2 = new FileEntry(n);
        this.filesList.set(this.filesList.indexOf(fileEntry), fileEntry2);
        return true;
    }

    private static void formatFileArea(int n) {
        Bank bank;
        int n2 = n;
        Memory memory = Z88.getInstance().getMemory();
        int n3 = (n2 & 0x3F) % memory.getExternalCardSize(n >> 6);
        while ((bank = memory.getBank(n2)) instanceof EpromBank | bank instanceof GenericAmdFlashBank | bank instanceof IntelFlashBank) {
            int n4 = 0;
            while (n4 < 16384) {
                memory.setByte(n4, n2, 255);
                ++n4;
            }
            --n2;
            if (n3-- > 0) continue;
        }
        FileArea.createFileHeader(n);
    }

    private int ptrToInt(int n) {
        int n2 = n >> 16 & 0x3F;
        int n3 = n & 0x3FFF;
        return n2 * 16384 + n3;
    }

    private int intToPtr(int n) {
        int n2 = n / 16384 | this.slotNumber << 6;
        int n3 = n % 16384;
        return n2 << 16 | n3;
    }

    public void reclaimDeletedFileSpace() throws FileAreaNotFoundException {
        if (!this.isFileAreaAvailable()) {
            throw new FileAreaNotFoundException();
        }
        if (this.filesList != null & this.filesList.size() > 0) {
            FileEntry fileEntry;
            LinkedList<FileEntryCache> linkedList = new LinkedList<FileEntryCache>();
            int n = 0;
            while (n < this.filesList.size()) {
                fileEntry = (FileEntry)this.filesList.get(n);
                if (!fileEntry.isDeleted()) {
                    FileEntryCache fileEntryCache = new FileEntryCache(fileEntry.getFileEntryPtr());
                    linkedList.add(fileEntryCache);
                }
                ++n;
            }
            FileArea.create(this.slotNumber, true);
            this.filesList = new LinkedList();
            n = 0;
            while (n < linkedList.size()) {
                fileEntry = (FileEntryCache)linkedList.get(n);
                try {
                    this.storeFile(fileEntry.getFileName(), ((FileEntryCache)fileEntry).getFileImage());
                }
                catch (FileAreaExhaustedException fileAreaExhaustedException) {}
                ++n;
            }
        }
    }

    private class FileEntryCache
    extends FileEntry {
        private byte[] fileImageCopy;

        public FileEntryCache(int n) {
            super(n);
            this.fileImageCopy = super.getFileImage();
        }

        @Override
        public byte[] getFileImage() {
            return this.fileImageCopy;
        }
    }
}

