/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.screen;

import com.jira.cambridgez88.ozvm.screen.DirectGif89Frame;
import com.jira.cambridgez88.ozvm.screen.Gif89Frame;
import com.jira.cambridgez88.ozvm.screen.IndexGif89Frame;
import com.jira.cambridgez88.ozvm.screen.ReverseColorMap;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

class GifColorTable {
    private int[] theColors = new int[256];
    private int colorDepth;
    private int transparentIndex = -1;
    private int ciCount;
    private ReverseColorMap ciLookup;

    GifColorTable() {
        this.ciLookup = new ReverseColorMap();
    }

    GifColorTable(Color[] colorArray) {
        int n = Math.min(this.theColors.length, colorArray.length);
        int n2 = 0;
        while (n2 < n) {
            this.theColors[n2] = colorArray[n2].getRGB();
            ++n2;
        }
    }

    int getDepth() {
        return this.colorDepth;
    }

    int getTransparent() {
        return this.transparentIndex;
    }

    void setTransparent(int n) {
        this.transparentIndex = n;
    }

    void processPixels(Gif89Frame gif89Frame) throws IOException {
        if (gif89Frame instanceof DirectGif89Frame) {
            this.filterPixels((DirectGif89Frame)gif89Frame);
        } else {
            this.trackPixelUsage((IndexGif89Frame)gif89Frame);
        }
    }

    void closePixelProcessing() {
        this.colorDepth = this.computeColorDepth(this.ciCount);
    }

    void encode(OutputStream outputStream) throws IOException {
        int n = 1 << this.colorDepth;
        int n2 = 0;
        while (n2 < n) {
            outputStream.write(this.theColors[n2] >> 16 & 0xFF);
            outputStream.write(this.theColors[n2] >> 8 & 0xFF);
            outputStream.write(this.theColors[n2] & 0xFF);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void filterPixels(DirectGif89Frame var1_1) throws IOException {
        if (this.ciLookup == null) {
            throw new IOException("RGB frames require palette autodetection");
        }
        var2_2 = (int[])var1_1.getPixelSource();
        var3_3 = var1_1.getPixelSink();
        var4_4 = var2_2.length;
        var5_5 = 0;
        while (var5_5 < var4_4) {
            block7: {
                var6_6 = var2_2[var5_5];
                if (var6_6 >>> 24 >= 128) ** GOTO lbl-1000
                if (this.transparentIndex != -1) break block7;
                this.transparentIndex = this.ciCount;
                ** GOTO lbl-1000
            }
            if (var6_6 != this.theColors[this.transparentIndex]) {
                var3_3[var5_5] = (byte)this.transparentIndex;
            } else if ((var7_7 = this.ciLookup.getPaletteIndex(var6_6 & 0xFFFFFF)) == -1) {
                if (this.ciCount == 256) {
                    throw new IOException("can't encode as GIF (> 256 colors)");
                }
                this.theColors[this.ciCount] = var6_6;
                this.ciLookup.put(var6_6 & 0xFFFFFF, this.ciCount);
                var3_3[var5_5] = (byte)this.ciCount;
                ++this.ciCount;
            } else {
                var3_3[var5_5] = (byte)var7_7;
            }
            ++var5_5;
        }
    }

    private void trackPixelUsage(IndexGif89Frame indexGif89Frame) throws IOException {
        byte[] byArray = (byte[])indexGif89Frame.getPixelSource();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] >= this.ciCount) {
                this.ciCount = byArray[n2] + 1;
            }
            ++n2;
        }
    }

    private int computeColorDepth(int n) {
        if (n <= 2) {
            return 1;
        }
        if (n <= 4) {
            return 2;
        }
        if (n <= 16) {
            return 4;
        }
        return 8;
    }
}

