/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.screen;

import com.imagero.util.ThreadManager;
import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.OZvm;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.screen.DirectGif89Frame;
import com.jira.cambridgez88.ozvm.screen.Gif89Encoder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.filechooser.FileSystemView;

public class Z88display
extends JLabel
implements MouseListener,
FocusListener {
    public static final int FPS10 = 0;
    public static final int FPS25 = 1;
    public static final int FPS50 = 2;
    public static final int FPS100 = 3;
    public static final int Z88SCREENWIDTH = 640;
    public static final int Z88SCREENHEIGHT = 64;
    private static final int SBRSIZE = 2048;
    private static final int[] fps = new int[]{10, 25, 50, 100};
    private static final int[] fcd = new int[]{7, 18, 35, 70};
    private static final int PXCOLON = -12182659;
    private static final int PXCOLGREY = -7294809;
    private static final int PXCOLOFF = -2957127;
    private static final int PXCOLSCROFF = -2039584;
    private static final int attrHrs = 32;
    private static final int attrRev = 16;
    private static final int attrFls = 8;
    private static final int attrGry = 4;
    private static final int attrUnd = 2;
    private static final int attrNull = 52;
    private static final int attrCursor = 56;
    private static int screenPixelFactor = 1;
    private Timer scrTimer;
    private boolean renderDoubleScreenSize = false;
    private GraphicsConfiguration configuration;
    private RenderPerMs renderPerMs;
    private boolean renderRunning = false;
    private int curRenderSpeedIndex = 2;
    private ThreadManager movieHelper = new ThreadManager(1);
    private OutputStream movieOutputStream;
    private String movieFilename;
    private BufferedImage image;
    private int scrdumpCounter;
    private int movieCounter;
    private Gif89Encoder gifEncoder;
    private int frameDelay;
    private LinkedList screenFrameQueue = new LinkedList();
    private int frameCounter;
    private Blink blink = null;
    private Memory memory = null;
    private boolean recordingMovie;
    private boolean cursorInverse = true;
    private boolean flashTextEmpty;
    private int[] displayMatrix = new int[40960];
    private int[] cpyDisplayMatrix = new int[40960];
    private boolean screenChanged;
    private int lores0;
    private int lores1;
    private int hires0;
    private int hires1;
    private int sbr;
    private int bankLores0;
    private int bankLores1;
    private int bankHires0;
    private int bankHires1;
    private int bankSbr;
    private Z80Processor z80Proc = null;

    public Z88display() {
        this.scrTimer = new Timer(true);
        this.configuration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        this.setPreferredSize(new Dimension(640, 64));
        this.setToolTipText("Click on this window with the mouse to get Z88 keyboard focus.");
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.setFocusTraversalKeysEnabled(false);
    }

    public boolean isDoubleScreenSize() {
        return this.renderDoubleScreenSize;
    }

    public void setDoubleScreenSize(boolean bl) {
        this.renderDoubleScreenSize = bl;
        screenPixelFactor = bl ? 2 : 1;
        this.setPreferredSize(new Dimension(640 * screenPixelFactor, 64 * screenPixelFactor));
        this.renderImageToComponent();
    }

    public void connectBlink(Blink blink) {
        this.blink = blink;
    }

    public void connectProcessor(Z80Processor z80Processor) {
        this.z80Proc = z80Processor;
    }

    public void connectMemory(Memory memory) {
        this.memory = memory;
    }

    public void setFrameRate(int n) {
        this.stop();
        this.curRenderSpeedIndex = n % fps.length;
        this.start();
    }

    public int getCurrentFrameRate() {
        return this.curRenderSpeedIndex;
    }

    public void renderDisplay() {
        this.lores0 = this.blink.getPb0Address();
        this.lores1 = this.blink.getPb1Address();
        this.hires0 = this.blink.getPb2Address();
        this.hires1 = this.blink.getPb3Address();
        this.sbr = this.blink.getSbrAddress();
        if ((this.blink.getCom() & 1) == 0) {
            this.renderNoScreenFrame();
            return;
        }
        if (this.sbr == 0 | this.lores1 == 0 | this.lores0 == 0 | this.hires0 == 0 | this.hires1 == 0) {
            this.renderNoScreenFrame();
            return;
        }
        this.renderScreenFrame();
    }

    public void grabScreenFrameToFile() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        BufferedImage bufferedImage = new BufferedImage(640, 64, 6);
        bufferedImage.setRGB(0, 0, 640, 64, this.displayMatrix, 0, 640);
        File file = new File(fileSystemView.getHomeDirectory() + File.separator + "z88screen" + this.scrdumpCounter++ + ".png");
        OZvm.displayRtmMessage("Screen captured to '" + file.getAbsolutePath() + "'.");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IOException iOException) {}
    }

    public void toggleMovieRecording() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (!this.recordingMovie) {
            try {
                this.movieFilename = fileSystemView.getHomeDirectory() + File.separator + "z88movie" + this.movieCounter++ + ".gif";
                this.movieOutputStream = new BufferedOutputStream(new FileOutputStream(this.movieFilename), 16384);
                this.gifEncoder = new Gif89Encoder();
                this.recordingMovie = true;
                OZvm.displayRtmMessage("Screen recording to '" + this.movieFilename + "' activated.");
            }
            catch (IOException iOException) {
                this.recordingMovie = false;
                OZvm.displayRtmMessage("Could not create animated Gif file.");
            }
        } else {
            this.recordingMovie = false;
            ScreenFrameAction screenFrameAction = new ScreenFrameAction(this.movieOutputStream);
            this.screenFrameQueue.add(screenFrameAction);
            OZvm.displayRtmMessage("Screen recording stopped. Saved in '" + this.movieFilename + "'.");
        }
    }

    private void scheduleFrameAction(ScreenFrameAction screenFrameAction) {
        this.movieHelper.addTask(screenFrameAction);
    }

    public BufferedImage getScreenFrame() {
        BufferedImage bufferedImage = new BufferedImage(640, 64, 6);
        bufferedImage.setRGB(0, 0, 640, 64, this.displayMatrix, 0, 640);
        return bufferedImage;
    }

    private void renderNoScreenFrame() {
        this.screenChanged = false;
        int n = 0;
        int n2 = 40960;
        while (n < n2) {
            this.setPixel(n, -2039584);
            ++n;
        }
        if (this.screenChanged) {
            this.renderImageToComponent();
        }
    }

    private void renderScreenFrame() {
        this.screenChanged = false;
        this.bankLores0 = this.lores0 >>> 16;
        this.lores0 &= 0x3FFF;
        this.bankLores1 = this.lores1 >>> 16;
        this.lores1 &= 0x3FFF;
        this.bankHires0 = this.hires0 >>> 16;
        this.hires0 &= 0x3FFF;
        this.bankHires1 = this.hires1 >>> 16;
        this.hires1 &= 0x3FFF;
        this.bankSbr = this.sbr >>> 16;
        this.sbr &= 0x3FFF;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 2048) {
            int n4;
            int n5;
            int n6;
            int n7 = 0;
            while (n7 < 213) {
                n6 = this.sbr + n3 + n7;
                n5 = this.memory.getByte(n6, this.bankSbr);
                n4 = this.memory.getByte(n6 + 1, this.bankSbr);
                if ((n4 & 0x20) == 0) {
                    this.drawLoresChar(n, n2, n4, n5);
                    n += 6;
                } else if ((n4 & 0x38) == 56) {
                    this.drawLoresCursor(n, n2, n4, n5);
                    n += 6;
                } else if ((n4 & 0x34) != 52) {
                    this.drawHiresChar(n, n2, n4, n5);
                    n += 8;
                }
                n7 += 2;
            }
            if (n < 639) {
                n7 = n2 * 640;
                n6 = n2 * 640 + 5120;
                while (n7 < n6) {
                    n5 = 0;
                    n4 = 640 - n;
                    while (n5 < n4) {
                        this.setPixel(n7 + n + n5, -2957127);
                        ++n5;
                    }
                    n7 += 640;
                }
            }
            n2 += 8;
            n = 0;
            n3 += 256;
        }
        if (this.screenChanged) {
            this.renderImageToComponent();
            if (this.recordingMovie) {
                if (this.screenFrameQueue.size() > 0) {
                    ((ScreenFrameAction)this.screenFrameQueue.getLast()).setFrameDelay(this.frameDelay / 10);
                }
                ScreenFrameAction screenFrameAction = new ScreenFrameAction(this.movieOutputStream, this.gifEncoder, 640, 64, this.displayMatrix);
                this.screenFrameQueue.add(screenFrameAction);
            }
            this.frameDelay = 0;
        }
        if (this.screenFrameQueue.size() > 0) {
            if (this.recordingMovie & this.screenFrameQueue.size() == 1) {
                return;
            }
            this.scheduleFrameAction((ScreenFrameAction)this.screenFrameQueue.removeFirst());
        }
    }

    private void renderImageToComponent() {
        this.image = new BufferedImage(640, 64, 6);
        this.image.setRGB(0, 0, 640, 64, this.displayMatrix, 0, 640);
        if (!this.renderDoubleScreenSize) {
            this.setIcon(new ImageIcon(this.image));
        } else {
            BufferedImage bufferedImage = this.configuration.createCompatibleImage(640 * screenPixelFactor, 64 * screenPixelFactor, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.image, 0, 0, 640 * screenPixelFactor, 64 * screenPixelFactor, null);
            graphics2D.dispose();
            this.setIcon(new ImageIcon(bufferedImage));
        }
    }

    private void drawLoresCursor(int n, int n2, int n3, int n4) {
        int n5;
        if (640 - n < 6) {
            return;
        }
        int n6 = (n3 & 1) << 8 | n4;
        if (n6 >= 448) {
            n6 = this.lores0 + ((n4 & 0x3F) << 3);
            n5 = this.bankLores0;
        } else {
            n6 = this.lores1 + (n6 << 3);
            n5 = this.bankLores1;
        }
        int n7 = n2 * 640;
        int n8 = n2 * 640 + 5120;
        while (n7 < n8) {
            int n9 = this.memory.getByte(n6++, n5);
            if (this.cursorInverse) {
                n9 ^= 0xFFFFFFFF;
            }
            int n10 = 0;
            int n11 = 32;
            while (n11 > 0) {
                this.setPixel(n7 + n + n10++, (n9 & n11) != 0 ? -12182659 : -2957127);
                n11 >>>= 1;
            }
            n7 += 640;
        }
    }

    private void drawLoresChar(int n, int n2, int n3, int n4) {
        int n5;
        if (640 - n < 6) {
            return;
        }
        if ((n3 & 8) == 8 && this.flashTextEmpty) {
            int n6 = n2 * 640;
            int n7 = n2 * 640 + 5120;
            while (n6 < n7) {
                int n8 = 0;
                while (n8 < 6) {
                    this.setPixel(n6 + n + n8, -2957127);
                    ++n8;
                }
                n6 += 640;
            }
            return;
        }
        int n9 = (n3 & 4) == 0 ? -12182659 : -7294809;
        int n10 = (n3 & 1) << 8 | n4;
        if (n10 >= 448) {
            n10 = this.lores0 + ((n4 & 0x3F) << 3);
            n5 = this.bankLores0;
        } else {
            n10 = this.lores1 + (n10 << 3);
            n5 = this.bankLores1;
        }
        int n11 = 0;
        int n12 = n2 * 640;
        int n13 = n2 * 640 + 5120;
        while (n12 < n13) {
            int n14;
            int n15 = this.memory.getByte(n10++, n5);
            if ((n3 & 0x10) == 16) {
                n15 ^= 0xFFFFFFFF;
            }
            if (n11++ == 7 && (n3 & 2) == 2) {
                int n16 = n9;
                if ((n3 & 0x10) == 16) {
                    n16 = -2957127;
                }
                n14 = 0;
                while (n14 < 6) {
                    this.setPixel(n12 + n + n14, n16);
                    ++n14;
                }
                break;
            }
            int n17 = 0;
            n14 = 32;
            while (n14 > 0) {
                this.setPixel(n12 + n + n17++, (n15 & n14) != 0 ? n9 : -2957127);
                n14 >>>= 1;
            }
            n12 += 640;
        }
    }

    private void drawHiresChar(int n, int n2, int n3, int n4) {
        int n5;
        if (640 - n < 8) {
            return;
        }
        if ((n3 & 8) == 8 && this.flashTextEmpty) {
            int n6 = n2 * 640;
            int n7 = n2 * 640 + 5120;
            while (n6 < n7) {
                int n8 = 0;
                while (n8 < 8) {
                    this.setPixel(n6 + n + n8, -2957127);
                    ++n8;
                }
                n6 += 640;
            }
            return;
        }
        int n9 = (n3 & 3) << 8 | n4;
        if (n9 >= 768) {
            n9 = this.hires1 + (n4 << 3);
            n5 = this.bankHires1;
        } else {
            n9 = this.hires0 + (n9 << 3);
            n5 = this.bankHires0;
        }
        int n10 = (n3 & 4) == 0 ? -12182659 : -7294809;
        int n11 = n2 * 640;
        int n12 = n2 * 640 + 5120;
        while (n11 < n12) {
            int n13 = this.memory.getByte(n9++, n5);
            if ((n3 & 0x10) == 16) {
                n13 ^= 0xFFFFFFFF;
            }
            int n14 = 0;
            int n15 = 128;
            while (n15 > 0) {
                this.setPixel(n11 + n + n14++, (n13 & n15) != 0 ? n10 : -2957127);
                n15 >>>= 1;
            }
            n11 += 640;
        }
    }

    private void setPixel(int n, int n2) {
        this.displayMatrix[n] = n2;
        if (this.cpyDisplayMatrix[n] != this.displayMatrix[n]) {
            this.cpyDisplayMatrix[n] = this.displayMatrix[n];
            this.screenChanged = true;
        }
    }

    private void flashCounter() {
        if (this.frameCounter++ > fps[this.curRenderSpeedIndex]) {
            this.frameCounter = 0;
            this.flashTextEmpty = !this.flashTextEmpty;
        }
        this.cursorInverse = this.frameCounter < fcd[this.curRenderSpeedIndex];
    }

    public void stop() {
        if (this.renderPerMs != null) {
            this.renderPerMs.cancel();
            this.renderRunning = false;
        }
    }

    public void start() {
        if (!this.renderRunning) {
            this.renderPerMs = new RenderPerMs();
            this.scrTimer.scheduleAtFixedRate((TimerTask)this.renderPerMs, 0L, (long)(1000 / fps[this.curRenderSpeedIndex]));
            this.renderRunning = true;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.grabFocus();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Z88.getInstance().getKeyboard().resetKeyboardMatrix();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private class RenderPerMs
    extends TimerTask {
        boolean priorityDefined;

        private RenderPerMs() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("ScreenFrameDisplay");
            if (!this.priorityDefined) {
                Thread.currentThread().setPriority(1);
                this.priorityDefined = true;
            }
            Z88display z88display = Z88display.this;
            z88display.frameDelay = z88display.frameDelay + 1000 / fps[Z88display.this.curRenderSpeedIndex];
            if (Z88display.this.z80Proc.isZ80running()) {
                Z88display.this.flashCounter();
            }
            Z88display.this.renderDisplay();
        }
    }

    private class ScreenFrameAction
    implements Runnable {
        private static final int actionEncodeFrame = 1;
        private static final int actionCloseGifFile = 2;
        private OutputStream outStream;
        private int fileAction;
        private DirectGif89Frame gifFrame;
        private Gif89Encoder gifEnc;

        public ScreenFrameAction(OutputStream outputStream) {
            this.outStream = outputStream;
            this.fileAction = 2;
        }

        public ScreenFrameAction(OutputStream outputStream, Gif89Encoder gif89Encoder, int n, int n2, int[] nArray) {
            this.outStream = outputStream;
            this.gifEnc = gif89Encoder;
            this.fileAction = 1;
            this.gifFrame = new DirectGif89Frame(n, n2, nArray);
            this.gifFrame.setDelay(50);
        }

        public void setFrameDelay(int n) {
            if (this.gifFrame != null) {
                this.gifFrame.setDelay(n);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName("DisplayFrameDecoder");
            try {
                if (this.fileAction == 1) {
                    this.gifEnc.encodeFrame(this.outStream, this.gifFrame);
                }
                if (this.fileAction == 2) {
                    this.outStream.write(59);
                    this.outStream.close();
                    this.outStream = null;
                }
            }
            catch (IOException iOException) {}
        }
    }
}

