/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.util;

import java.util.Vector;

public class ThreadManager {
    int count;
    Runner[] runners;
    Runnable[] current;
    Vector keys = new Vector();
    protected Vector tasks = new Vector();

    public ThreadManager() {
        this(1);
    }

    public ThreadManager(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("" + n);
        }
        this.runners = new Runner[n];
        this.current = new Runnable[n];
        int n2 = 0;
        while (n2 < this.runners.length) {
            this.runners[n2] = new Runner();
            this.runners[n2].start();
            ++n2;
        }
    }

    public void clearTasks() {
        this.tasks.clear();
    }

    public void addTask(Runnable runnable) {
        int n = this.tasks.indexOf(runnable);
        if (n < 0 && !this.isCurrentImpl(runnable)) {
            this.tasks.add(runnable);
            this.wakeUp();
        }
    }

    protected boolean isCurrentImpl(Runnable runnable) {
        int n = 0;
        while (n < this.current.length) {
            if (this.current[n] == runnable) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isCurrent(Runnable runnable) {
        return this.isCurrentImpl(runnable);
    }

    public boolean hasTask(Runnable runnable) {
        return this.isCurrentImpl(runnable) || this.tasks.contains(runnable);
    }

    protected synchronized void wakeUp() {
        this.notifyAll();
    }

    protected void finalize() throws Throwable {
        int n = 0;
        while (n < this.runners.length) {
            this.runners[n].stopMe();
            this.runners[n] = null;
            ++n;
        }
        this.wakeUp();
    }

    protected synchronized Runnable nextTask() {
        if (this.tasks.size() > 0) {
            return (Runnable)this.tasks.remove(0);
        }
        return null;
    }

    synchronized void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    private class Runner
    extends Thread {
        protected int num;
        boolean stopped;

        public Runner() {
            this.num = ThreadManager.this.count++;
            this.setPriority(1);
        }

        public void stopMe() {
            this.stopped = true;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("com.imagero.util.ThreadManager");
            while (!this.stopped) {
                ThreadManager.this.current[this.num] = ThreadManager.this.nextTask();
                if (ThreadManager.this.current[this.num] != null) {
                    try {
                        ThreadManager.this.current[this.num].run();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    continue;
                }
                ThreadManager.this.doWait();
            }
        }
    }
}

