/*
 * Decompiled with CFR 0.152.
 */
package com.jhe.hexed;

import com.jhe.hexed.JHexEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class JHexEditorASCII
extends JComponent
implements MouseListener,
KeyListener {
    private JHexEditor he;

    public JHexEditorASCII(JHexEditor jHexEditor) {
        this.he = jHexEditor;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(jHexEditor);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this.getFontMetrics(JHexEditor.font);
        int n = fontMetrics.getHeight();
        int n2 = this.he.getLineas();
        dimension.setSize((fontMetrics.stringWidth(" ") + 1) * 16 + this.he.border * 2 + 1, n * n2 + this.he.border * 2 + 1);
        return dimension;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getMinimumSize();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        graphics.setFont(JHexEditor.font);
        int n = this.he.getInicio() * 16;
        int n2 = n + this.he.getLineas() * 16;
        if (n2 > this.he.buff.length) {
            n2 = this.he.buff.length;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            if (n5 == this.he.cursor) {
                graphics.setColor(Color.blue);
                if (this.hasFocus()) {
                    this.he.fondo(graphics, n3, n4, 1);
                } else {
                    this.he.cuadro(graphics, n3, n4, 1);
                }
                if (this.hasFocus()) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(Color.black);
                }
            } else {
                graphics.setColor(Color.black);
            }
            String string = "" + new Character((char)this.he.buff[n5]);
            if (this.he.buff[n5] < 20 || this.he.buff[n5] > 126) {
                string = "\u0010";
            }
            this.he.printString(graphics, string, n3++, n4);
            if (n3 == 16) {
                n3 = 0;
                ++n4;
            }
            ++n5;
        }
    }

    public int calcularPosicionRaton(int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(JHexEditor.font);
        return (n /= fontMetrics.stringWidth(" ") + 1) + ((n2 /= fontMetrics.getHeight()) + this.he.getInicio()) * 16;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.he.cursor = this.calcularPosicionRaton(mouseEvent.getX(), mouseEvent.getY());
        this.requestFocus();
        this.he.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.he.buff[this.he.cursor] = (byte)keyEvent.getKeyChar();
        if (this.he.cursor != this.he.buff.length - 1) {
            ++this.he.cursor;
        }
        this.he.repaint();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.he.keyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }
}

