/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jhe.hexed.JHexEditor;
import com.jira.cambridgez88.ozvm.Dz;
import java.awt.event.WindowAdapter;
import java.util.zip.CRC32;
import javax.swing.JFrame;

public abstract class Bank
extends WindowAdapter {
    public static final int SIZE = 16384;
    private int bankNo = -1;
    private int[] bankMem = new int[16384];
    private boolean[] breakPoints = new boolean[16384];
    private boolean[] watchReadPoints = new boolean[16384];
    private boolean[] watchWritePoints = new boolean[16384];
    private JFrame win;

    public Bank() {
    }

    public Bank(int n) {
        this();
        this.bankNo = n;
    }

    public abstract int readByte(int var1);

    public abstract void writeByte(int var1, int var2);

    public abstract boolean isEmpty();

    public int getByte(int n) {
        try {
            return this.bankMem[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.bankMem[n & 0x3FFF];
        }
    }

    public boolean isBreakpoint(int n) {
        try {
            return this.breakPoints[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.breakPoints[n & 0x3FFF];
        }
    }

    public void setBreakpoint(int n) {
        this.breakPoints[n & 0x3FFF] = true;
    }

    public void clearBreakpoint(int n) {
        this.breakPoints[n & 0x3FFF] = false;
    }

    public boolean isReadWatchpoint(int n) {
        try {
            return this.watchReadPoints[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.watchReadPoints[n & 0x3FFF];
        }
    }

    public boolean isWriteWatchpoint(int n) {
        try {
            return this.watchWritePoints[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.watchWritePoints[n & 0x3FFF];
        }
    }

    public void setReadWatchpoint(int n) {
        this.watchReadPoints[n & 0x3FFF] = true;
    }

    public void setWriteWatchpoint(int n) {
        this.watchWritePoints[n & 0x3FFF] = true;
    }

    public void clearReadWatchpoint(int n) {
        this.watchReadPoints[n & 0x3FFF] = false;
    }

    public void clearWriteWatchpoint(int n) {
        this.watchWritePoints[n & 0x3FFF] = false;
    }

    public void setByte(int n, int n2) {
        try {
            this.bankMem[n] = n2 & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.bankMem[n & 0x3FFF] = n2 & 0xFF;
        }
    }

    public final void loadBytes(byte[] byArray, int n) {
        int n2 = (n %= 16384) + byArray.length > 16384 ? 16384 - n : byArray.length;
        int n3 = 0;
        while (n2-- > 0) {
            this.bankMem[n++] = byArray[n3++] & 0xFF;
        }
    }

    public final byte[] dumpBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n2-- > 0) {
            byArray[n3++] = (byte)(this.bankMem[n++] & 0xFF);
        }
        return byArray;
    }

    public final int getBankNumber() {
        return this.bankNo;
    }

    public final void setBankNumber(int n) {
        this.bankNo = n & 0xFF;
    }

    public long getCRC32() {
        byte[] byArray = this.dumpBytes(0, 16384);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public void editMemory(int n, int n2) {
        this.win = new JFrame();
        this.win.getContentPane().add(new JHexEditor(this.bankMem, n));
        this.win.addWindowListener(this);
        this.win.setTitle("Viewing Bank " + Dz.byteToHex(n2, true) + "    (press F5/SPACE to refresh contents)");
        this.win.pack();
        this.win.show();
    }
}

