/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.CommandLine;
import com.jira.cambridgez88.ozvm.DebugGui;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.Z88;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Breakpoints {
    private Map breakPoints = new HashMap();
    private Breakpoint bpSearchKey = new Breakpoint(0);
    private boolean breakAtOZCall = false;
    private boolean displayOZCall = false;

    public void toggleBreakOzCall() {
        this.breakAtOZCall = !this.breakAtOZCall;
    }

    public void toggleDisplayOzCall() {
        this.displayOZCall = !this.displayOZCall;
    }

    public boolean isBreakOzCallActive() {
        return this.breakAtOZCall;
    }

    public boolean isDisplayOzCallActive() {
        return this.displayOZCall;
    }

    public void clearBreakpoint(int n) {
        Breakpoint breakpoint = new Breakpoint(n);
        if (this.breakPoints.containsKey(breakpoint)) {
            this.breakPoints.remove(breakpoint);
            Z88.getInstance().getMemory().clearBreakpoint(n);
        }
    }

    public void setBreakpoint(int n) {
        Breakpoint breakpoint = new Breakpoint(n);
        if (!this.breakPoints.containsKey(breakpoint)) {
            this.breakPoints.put(breakpoint, breakpoint);
            Z88.getInstance().getMemory().setBreakpoint(n);
        }
    }

    public void setSingleStopBreakpoint(int n) {
        Breakpoint breakpoint = new Breakpoint(n, true, true);
        if (!this.breakPoints.containsKey(breakpoint)) {
            this.breakPoints.put(breakpoint, breakpoint);
            Z88.getInstance().getMemory().setBreakpoint(n);
        }
    }

    public void toggleBreakpoint(int n) {
        Breakpoint breakpoint = new Breakpoint(n);
        if (!this.breakPoints.containsKey(breakpoint)) {
            this.breakPoints.put(breakpoint, breakpoint);
            Z88.getInstance().getMemory().setBreakpoint(n);
        } else {
            this.breakPoints.remove(breakpoint);
            Z88.getInstance().getMemory().clearBreakpoint(n);
        }
    }

    public void toggleBreakpoint(int n, boolean bl) {
        Breakpoint breakpoint = new Breakpoint(n, bl);
        if (!this.breakPoints.containsKey(breakpoint)) {
            this.breakPoints.put(breakpoint, breakpoint);
            Z88.getInstance().getMemory().setBreakpoint(n);
        } else {
            this.breakPoints.remove(breakpoint);
            Z88.getInstance().getMemory().clearBreakpoint(n);
        }
    }

    public void toggleBreakpoint(int n, ArrayList<String> arrayList) {
        Breakpoint breakpoint = new Breakpoint(n, arrayList);
        if (!this.breakPoints.containsKey(breakpoint)) {
            this.breakPoints.put(breakpoint, breakpoint);
            Z88.getInstance().getMemory().setBreakpoint(n);
        } else {
            this.breakPoints.remove(breakpoint);
            Z88.getInstance().getMemory().clearBreakpoint(n);
        }
    }

    public boolean hasCommands(int n) {
        this.bpSearchKey.setBpAddress(n);
        Breakpoint breakpoint = (Breakpoint)this.breakPoints.get(this.bpSearchKey);
        if (breakpoint != null) {
            return breakpoint.hasCommands();
        }
        return false;
    }

    public void runCommands(int n) {
        this.bpSearchKey.setBpAddress(n);
        Breakpoint breakpoint = (Breakpoint)this.breakPoints.get(this.bpSearchKey);
        if (breakpoint != null & breakpoint.hasCommands()) {
            breakpoint.runCommands();
        }
    }

    public boolean isCreated(int n) {
        this.bpSearchKey.setBpAddress(n);
        Breakpoint breakpoint = (Breakpoint)this.breakPoints.get(this.bpSearchKey);
        return breakpoint != null;
    }

    public boolean isStoppable(int n) {
        this.bpSearchKey.setBpAddress(n);
        Breakpoint breakpoint = (Breakpoint)this.breakPoints.get(this.bpSearchKey);
        return breakpoint != null && breakpoint.stop;
    }

    public boolean isSingleStopBreakpoint(int n) {
        this.bpSearchKey.setBpAddress(n);
        Breakpoint breakpoint = (Breakpoint)this.breakPoints.get(this.bpSearchKey);
        return breakpoint != null && breakpoint.onestop;
    }

    public void activate(int n) {
        this.bpSearchKey.setBpAddress(n);
        Breakpoint breakpoint = (Breakpoint)this.breakPoints.get(this.bpSearchKey);
        if (breakpoint != null) {
            breakpoint.active = true;
        }
    }

    public void suspend(int n) {
        this.bpSearchKey.setBpAddress(n);
        Breakpoint breakpoint = (Breakpoint)this.breakPoints.get(this.bpSearchKey);
        if (breakpoint != null) {
            breakpoint.active = false;
        }
    }

    public boolean isActive(int n) {
        this.bpSearchKey.setBpAddress(n);
        Breakpoint breakpoint = (Breakpoint)this.breakPoints.get(this.bpSearchKey);
        return breakpoint != null && breakpoint.active;
    }

    public String displayBreakpoints() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("Breakpoints:\n");
        if (this.breakPoints.isEmpty()) {
            return new String("No Breakpoints defined.");
        }
        for (Map.Entry entry : this.breakPoints.entrySet()) {
            Breakpoint breakpoint = (Breakpoint)entry.getKey();
            stringBuffer.append(Dz.extAddrToHex(breakpoint.getBpAddress(), false));
            stringBuffer.append(!breakpoint.stop ? "[d]" : "");
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String breakpointList() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.breakPoints.isEmpty()) {
            return "";
        }
        Iterator iterator = this.breakPoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Breakpoint breakpoint = (Breakpoint)entry.getKey();
            stringBuffer.append(!breakpoint.stop ? "[d]" : "");
            stringBuffer.append(Dz.extAddrToHex(breakpoint.getBpAddress(), false));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public void installBreakpoints() {
        if (!this.breakPoints.isEmpty()) {
            for (Map.Entry entry : this.breakPoints.entrySet()) {
                Breakpoint breakpoint = (Breakpoint)entry.getKey();
                Z88.getInstance().getMemory().setBreakpoint(breakpoint.getBpAddress());
            }
        }
    }

    public void clearBreakpoints() {
        if (!this.breakPoints.isEmpty()) {
            for (Map.Entry entry : this.breakPoints.entrySet()) {
                Breakpoint breakpoint = (Breakpoint)entry.getKey();
                Z88.getInstance().getMemory().clearBreakpoint(breakpoint.getBpAddress());
            }
        }
    }

    public void removeBreakPoints() {
        this.clearBreakpoints();
        this.breakPoints.clear();
    }

    private class Breakpoint {
        private int addressKey;
        private boolean onestop;
        private boolean stop;
        private boolean active;
        private ArrayList<String> commands;

        Breakpoint(int n) {
            this.stop = true;
            this.onestop = false;
            this.active = true;
            this.addressKey = n;
            this.commands = null;
        }

        Breakpoint(int n, ArrayList<String> arrayList) {
            this.stop = true;
            this.onestop = false;
            this.active = true;
            this.addressKey = n;
            this.commands = arrayList;
        }

        Breakpoint(int n, boolean bl) {
            this.stop = bl;
            this.onestop = false;
            this.active = true;
            this.addressKey = n;
            this.commands = null;
        }

        Breakpoint(int n, boolean bl, boolean bl2) {
            this.stop = bl;
            this.onestop = bl2;
            this.active = true;
            this.addressKey = n;
            this.commands = null;
        }

        private void setBpAddress(int n) {
            this.addressKey = n;
        }

        private int getBpAddress() {
            return this.addressKey;
        }

        public int hashCode() {
            return this.addressKey;
        }

        private boolean hasCommands() {
            return this.commands != null;
        }

        private void runCommands() {
            if (this.commands != null) {
                CommandLine commandLine = CommandLine.getInstance();
                DebugGui.getInstance().disableCmdLineInput();
                int n = 0;
                while (n < this.commands.size()) {
                    commandLine.parseCommandLine(this.commands.get(n));
                    ++n;
                }
                DebugGui.getInstance().enableCmdLineInput();
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof Breakpoint)) {
                return false;
            }
            Breakpoint breakpoint = (Breakpoint)object;
            return this.addressKey == breakpoint.addressKey;
        }
    }
}

