/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.AmdFlashBank;
import com.jira.cambridgez88.ozvm.AmicFlashBank;
import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.Z88;

public abstract class GenericAmdFlashBank
extends Bank {
    private Memory memory = Z88.getInstance().getMemory();
    private boolean readArrayMode;
    private boolean signalCommandFailure;
    private static final int[] commandUnlockCycles = new int[]{1365, 170, 682, 85, 1365, 63};
    private static final int[] readStatusCommandSuccess = new int[]{64, 64};
    private static final int[] readStatusCommandFailure = new int[]{96, 32, 96, 32};
    private SequenceStack commandUnlockCycleStack;
    private SequenceStack readStatusStack;
    private boolean isCommandAccumulating;
    private boolean isCommandExecuting;
    private int executingCommandCode;

    public GenericAmdFlashBank() {
        super(-1);
        this.eraseBank();
        this.readArrayMode = true;
        this.isCommandAccumulating = false;
        this.isCommandExecuting = false;
    }

    @Override
    public final int readByte(int n) {
        if (this.readArrayMode) {
            return this.getByte(n);
        }
        return this.getCommandStatus(n);
    }

    @Override
    public final void writeByte(int n, int n2) {
        this.processCommandCycle(n, n2);
    }

    public abstract int getDeviceCode();

    public abstract int getManufacturerCode();

    public void eraseBank() {
        int n = 0;
        while (n < 16384) {
            this.setByte(n, 255);
            ++n;
        }
    }

    private final int getCommandStatus(int n) {
        if (this.isCommandAccumulating) {
            this.readArrayMode = true;
            this.isCommandAccumulating = false;
            this.isCommandExecuting = false;
            return this.getByte(n);
        }
        if (!this.isCommandExecuting) {
            this.readArrayMode = true;
            this.isCommandAccumulating = false;
            return this.getByte(n);
        }
        switch (this.executingCommandCode) {
            case 16: 
            case 48: 
            case 160: {
                int n2;
                if (this.signalCommandFailure) {
                    if (this.readStatusStack.isEmpty()) {
                        this.readStatusStack = this.presetSequence(readStatusCommandFailure);
                    }
                    n2 = this.readStatusStack.pop();
                } else {
                    n2 = this.readStatusStack.pop();
                    if (this.readStatusStack.isEmpty()) {
                        this.readArrayMode = true;
                        this.isCommandAccumulating = false;
                        this.isCommandExecuting = false;
                    }
                }
                return n2;
            }
            case 144: {
                switch (n &= 0xFF) {
                    case 0: {
                        return this.getManufacturerCode();
                    }
                    case 1: {
                        return this.getDeviceCode();
                    }
                }
                return 255;
            }
        }
        this.readArrayMode = true;
        this.isCommandAccumulating = false;
        this.isCommandExecuting = false;
        return this.getByte(n);
    }

    private final void processCommandCycle(int n, int n2) {
        if (this.readArrayMode) {
            this.readArrayMode = false;
            this.isCommandAccumulating = true;
            this.executingCommandCode = 0;
            this.commandUnlockCycleStack = this.presetSequence(commandUnlockCycles);
        }
        if (!this.isCommandAccumulating) {
            if (n2 == 240) {
                this.readArrayMode = true;
                this.isCommandAccumulating = false;
                this.isCommandExecuting = false;
            }
        } else {
            int n3 = this.commandUnlockCycleStack.pop();
            int n4 = this.commandUnlockCycleStack.pop();
            if (n4 != 63) {
                if ((n &= 0xFFF) != n3 & n2 != n4) {
                    this.readArrayMode = true;
                    this.isCommandAccumulating = false;
                    this.isCommandExecuting = false;
                }
            } else if (this.executingCommandCode == 160) {
                this.isCommandAccumulating = false;
                this.isCommandExecuting = true;
                this.programByteAtAddress(n, n2);
            } else {
                switch (n2) {
                    case 16: {
                        this.isCommandAccumulating = false;
                        this.isCommandExecuting = true;
                        this.executingCommandCode = 16;
                        this.eraseChipCommand();
                        break;
                    }
                    case 48: {
                        this.isCommandAccumulating = false;
                        this.isCommandExecuting = true;
                        this.executingCommandCode = 48;
                        this.eraseSectorCommand();
                        break;
                    }
                    case 128: {
                        this.commandUnlockCycleStack = this.presetSequence(commandUnlockCycles);
                        break;
                    }
                    case 144: {
                        this.isCommandAccumulating = false;
                        this.isCommandExecuting = true;
                        this.executingCommandCode = 144;
                        break;
                    }
                    case 160: {
                        this.executingCommandCode = 160;
                        this.commandUnlockCycleStack.push(63);
                        this.commandUnlockCycleStack.push(63);
                        break;
                    }
                    default: {
                        this.readArrayMode = true;
                        this.isCommandAccumulating = false;
                        this.isCommandExecuting = false;
                    }
                }
            }
        }
    }

    private void programByteAtAddress(int n, int n2) {
        if ((n2 & this.getByte(n)) == n2) {
            this.setByte(n, n2);
            this.readStatusStack = this.presetSequence(readStatusCommandSuccess);
            this.signalCommandFailure = false;
        } else {
            this.readStatusStack = this.presetSequence(readStatusCommandFailure);
            this.signalCommandFailure = true;
        }
    }

    private void eraseChipCommand() {
        GenericAmdFlashBank genericAmdFlashBank;
        int n = 0;
        int n2 = this.getBankNumber() & 0xC0;
        int n3 = n2 == 0 ? this.memory.getBank(31).getBankNumber() : this.memory.getBank(n2 | 0x3F).getBankNumber();
        Bank bank = this.memory.getBank(n3);
        if (bank instanceof AmdFlashBank) {
            genericAmdFlashBank = (AmdFlashBank)bank;
            switch (((AmdFlashBank)genericAmdFlashBank).getDeviceCode()) {
                case 32: {
                    n = 8;
                    break;
                }
                case 164: {
                    n = 32;
                    break;
                }
                case 213: {
                    n = 64;
                }
            }
        }
        if (bank instanceof AmicFlashBank) {
            n = 32;
        }
        while (n-- > 0) {
            genericAmdFlashBank = (GenericAmdFlashBank)this.memory.getBank(n3--);
            genericAmdFlashBank.eraseBank();
        }
        this.readStatusStack = this.presetSequence(readStatusCommandSuccess);
        this.signalCommandFailure = false;
    }

    private void eraseSectorCommand() {
        if (this.getDeviceCode() == 32) {
            this.eraseBank();
        } else {
            int n;
            int n2 = n = this.getBankNumber() & 0xFC;
            while (n2 <= n + 3) {
                GenericAmdFlashBank genericAmdFlashBank = (GenericAmdFlashBank)this.memory.getBank(n2);
                genericAmdFlashBank.eraseBank();
                ++n2;
            }
        }
        this.readStatusStack = this.presetSequence(readStatusCommandSuccess);
        this.signalCommandFailure = false;
    }

    private SequenceStack presetSequence(int[] nArray) {
        SequenceStack sequenceStack = new SequenceStack();
        int n = nArray.length - 1;
        while (n >= 0) {
            sequenceStack.push(nArray[n]);
            --n;
        }
        return sequenceStack;
    }

    @Override
    public boolean isEmpty() {
        int n = 0;
        while (n < 16384) {
            if (this.getByte(n) != 255) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private class SequenceStack {
        private int[] sequence = new int[8];
        private int stackPtr = -1;

        public int push(int n) {
            this.sequence[++this.stackPtr] = n;
            return n;
        }

        public boolean isEmpty() {
            return this.stackPtr < 0;
        }

        public int pop() {
            if (this.stackPtr < 0) {
                return -1;
            }
            return this.sequence[this.stackPtr--];
        }
    }
}

