/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.Z88;

public class IntelFlashBank
extends Bank {
    private Memory memory;
    public static final int I28F004S5 = 167;
    public static final int I28F008S5 = 166;
    public static final int MANUFACTURERCODE = 137;
    private boolean readArrayMode;
    private int executingCommandCode;
    private int statusRegister;
    private Blink blink = Z88.getInstance().getBlink();
    private int deviceCode;

    public IntelFlashBank(int n) {
        super(-1);
        this.deviceCode = n;
        this.memory = Z88.getInstance().getMemory();
        this.eraseBank();
        this.readArrayMode = true;
    }

    @Override
    public final int readByte(int n) {
        if (this.readArrayMode) {
            return this.getByte(n);
        }
        return this.getCommandStatus(n);
    }

    @Override
    public final void writeByte(int n, int n2) {
        this.processCommand(n, n2);
    }

    public final int getDeviceCode() {
        return this.deviceCode;
    }

    public void eraseBank() {
        int n = 0;
        while (n < 16384) {
            this.setByte(n, 255);
            ++n;
        }
    }

    private final int getCommandStatus(int n) {
        n &= 0x3FFF;
        switch (this.executingCommandCode) {
            case 16: 
            case 64: 
            case 112: 
            case 208: {
                return this.statusRegister;
            }
            case 144: {
                if ((this.getBankNumber() & 0x3F) == 0) {
                    switch (n) {
                        case 0: {
                            return 137;
                        }
                        case 1: {
                            return this.getDeviceCode();
                        }
                    }
                    return 255;
                }
                return 255;
            }
        }
        return 255;
    }

    private final void processCommand(int n, int n2) {
        if (this.readArrayMode) {
            this.readArrayMode = false;
            this.executingCommandCode = 0;
        }
        if (!this.readArrayMode) {
            if (this.executingCommandCode == 16 | this.executingCommandCode == 64) {
                this.programByteAtAddress(n, n2);
                this.executingCommandCode = 112;
            } else {
                switch (n2) {
                    case 32: {
                        this.executingCommandCode = 32;
                        break;
                    }
                    case 80: {
                        this.executingCommandCode = 0;
                        this.statusRegister = 128;
                        break;
                    }
                    case 112: {
                        this.executingCommandCode = 112;
                        break;
                    }
                    case 144: {
                        this.executingCommandCode = 144;
                        break;
                    }
                    case 16: 
                    case 64: {
                        this.executingCommandCode = 64;
                        break;
                    }
                    case 208: {
                        if (this.executingCommandCode != 32) break;
                        this.executingCommandCode = 208;
                        this.eraseBlockCommand();
                        break;
                    }
                    case 255: {
                        this.readArrayMode = true;
                        this.executingCommandCode = 0;
                        break;
                    }
                    default: {
                        this.readArrayMode = true;
                        this.executingCommandCode = 0;
                    }
                }
            }
        }
    }

    private void programByteAtAddress(int n, int n2) {
        if ((this.getBankNumber() & 0xC0) != 192) {
            this.statusRegister = 152;
            return;
        }
        if ((this.blink.getCom() & 2) == 0) {
            this.statusRegister = 152;
            return;
        }
        if ((n2 & this.getByte(n)) == n2) {
            this.setByte(n, n2);
            this.statusRegister = 128;
        } else {
            this.statusRegister = 144;
        }
    }

    private void eraseBlockCommand() {
        int n = this.getBankNumber() & 0xFC;
        if ((n & 0xC0) != 192) {
            this.statusRegister = 168;
            return;
        }
        if ((this.blink.getCom() & 2) == 0) {
            this.statusRegister = 168;
            return;
        }
        int n2 = n;
        while (n2 <= n + 3) {
            IntelFlashBank intelFlashBank = (IntelFlashBank)this.memory.getBank(n2);
            intelFlashBank.eraseBank();
            ++n2;
        }
        this.statusRegister = 128;
    }

    @Override
    public boolean isEmpty() {
        int n = 0;
        while (n < 16384) {
            if (this.getByte(n) != 255) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

