/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.CommandLine;
import com.jira.cambridgez88.ozvm.DebugGui;
import com.jira.cambridgez88.ozvm.Gui;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.RtmMessageGui;
import com.jira.cambridgez88.ozvm.RubberKeyboard;
import com.jira.cambridgez88.ozvm.SaveRestoreVM;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.filecard.FileArea;
import com.jira.cambridgez88.ozvm.filecard.FileAreaExhaustedException;
import com.jira.cambridgez88.ozvm.filecard.FileAreaNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class OZvm {
    public static final String defaultVmFile = String.valueOf(System.getProperty("user.home")) + File.separator + "boot.z88";
    public static final String defaultPreferencesFile = String.valueOf(System.getProperty("user.home")) + File.separator + "ozvm.ini";
    private static Properties loadedPreferences = null;
    public static final String VERSION = "1.2";
    public static final String systemBootRom = "roms/Z88OZ47.rom";
    public static String defaultBootRom = "";
    private boolean autoRun = true;
    private RtmMessageGui rtmMsgGui;
    private String guiKbLayout = "";
    private Blink blink = Z88.getInstance().getBlink();
    private Memory memory = Z88.getInstance().getMemory();
    private Gui gui;

    public static OZvm getInstance() {
        return singletonContainer.singleton;
    }

    private OZvm() {
        Z88.getInstance().getDisplay().start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                OZvm.savePreferences();
            }
        });
    }

    public boolean getAutorunStatus() {
        return this.autoRun;
    }

    public Gui getGui() {
        return this.gui;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean boot(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 128;
        this.gui = new Gui();
        try {
            int n4 = 0;
            block12: while (n4 < stringArray.length) {
                int n5;
                String string;
                Object object;
                if (stringArray[n4].compareTo("rom") != 0 & stringArray[n4].compareTo("ram0") != 0 & stringArray[n4].compareTo("ram1") != 0 & stringArray[n4].compareTo("ram2") != 0 & stringArray[n4].compareTo("ram3") != 0 & stringArray[n4].compareTo("epr1") != 0 & stringArray[n4].compareTo("epr2") != 0 & stringArray[n4].compareTo("epr3") != 0 & stringArray[n4].compareTo("fcd1") != 0 & stringArray[n4].compareTo("fcd2") != 0 & stringArray[n4].compareTo("fcd3") != 0 & stringArray[n4].compareTo("crd1") != 0 & stringArray[n4].compareTo("crd2") != 0 & stringArray[n4].compareTo("crd3") != 0 & stringArray[n4].compareTo("kbl") != 0 & stringArray[n4].compareTo("debug") != 0 & stringArray[n4].compareTo("initdebug") != 0) {
                    object = new SaveRestoreVM();
                    string = stringArray[n4];
                    if (string.toLowerCase().lastIndexOf(".z88") == -1) {
                        string = String.valueOf(string) + ".z88";
                    }
                    try {
                        this.autoRun = ((SaveRestoreVM)object).loadSnapShot(string);
                        OZvm.displayRtmMessage("Snapshot successfully installed from " + string);
                        this.gui.setWindowTitle("[" + new File(string).getName() + "]");
                        bl3 = true;
                    }
                    catch (IOException iOException) {
                        this.memory.setDefaultSystem();
                        Z88.getInstance().getProcessor().reset();
                        this.blink.resetBlinkRegisters();
                    }
                    ++n4;
                }
                if (n4 < stringArray.length && stringArray[n4].compareTo("rom") == 0) {
                    OZvm.displayRtmMessage("Loading '" + stringArray[n4 + 1] + "' into ROM space   in slot 0.");
                    object = new File(stringArray[n4 + 1]);
                    this.memory.loadRomBinary((File)object);
                    this.gui.setWindowTitle("[" + ((File)object).getName() + "]");
                    this.blink.resetBlinkRegisters();
                    this.blink.setRAMS(this.memory.getBank(0));
                    bl = true;
                    n4 += 2;
                }
                if (n4 < stringArray.length && stringArray[n4].startsWith("ram")) {
                    int n6 = stringArray[n4].charAt(3) - 48;
                    n = Integer.parseInt(stringArray[n4 + 1], 10);
                    if (n6 == 0) {
                        if (n < 32 | n > 512) {
                            OZvm.displayRtmMessage("Only 32K-512K RAM Card size allowed in slot " + n6);
                            return false;
                        }
                    } else if (n < 32 | n > 1024) {
                        OZvm.displayRtmMessage("Only 32K-1024K RAM Card size allowed in slot " + n6);
                        return false;
                    }
                    this.memory.insertRamCard(n, n6);
                    if (n6 == 0) {
                        bl4 = true;
                    }
                    OZvm.displayRtmMessage("Inserted " + n + "K RAM Card in slot " + n6);
                    bl2 = true;
                    n4 += 2;
                    continue;
                }
                if (n4 < stringArray.length && stringArray[n4].startsWith("epr")) {
                    int n7 = stringArray[n4].charAt(3) - 48;
                    n2 = Integer.parseInt(stringArray[n4 + 1], 10);
                    string = "";
                    n5 = 0;
                    if (stringArray[n4 + 2].compareToIgnoreCase("27C") == 0) {
                        string = "Inserted " + n2 + "K UV Eprom Card in slot " + n7;
                        n5 = 3;
                    }
                    if (stringArray[n4 + 2].compareToIgnoreCase("28F") == 0) {
                        string = "Inserted " + n2 + "K Intel Flash Card in slot " + n7;
                        n5 = 4;
                    }
                    if (stringArray[n4 + 2].compareToIgnoreCase("29F") == 0) {
                        string = "Inserted " + n2 + "K Amd Flash  Card in slot " + n7;
                        n5 = 5;
                    }
                    if (this.memory.insertEprCard(n7, n2, n5)) {
                        OZvm.displayRtmMessage(string);
                        bl2 = true;
                    } else {
                        OZvm.displayRtmMessage("Eprom Card size/type configuration is illegal.");
                    }
                    n4 += 3;
                    continue;
                }
                if (n4 < stringArray.length && stringArray[n4].startsWith("fcd")) {
                    int n8 = stringArray[n4].charAt(3) - 48;
                    n2 = Integer.parseInt(stringArray[n4 + 1], 10);
                    string = "";
                    n5 = 0;
                    if (stringArray[n4 + 2].compareToIgnoreCase("27C") == 0) {
                        string = "Inserted " + n2 + "K UV Eprom Card in slot " + n8;
                        n5 = 3;
                    }
                    if (stringArray[n4 + 2].compareToIgnoreCase("28F") == 0) {
                        string = "Inserted " + n2 + "K Intel Flash Card in slot " + n8;
                        n5 = 4;
                    }
                    if (stringArray[n4 + 2].compareToIgnoreCase("29F") == 0) {
                        string = "Inserted " + n2 + "K Amd Flash  Card in slot " + n8;
                        n5 = 5;
                    }
                    if (this.memory.insertFileCard(n8, n2, n5)) {
                        OZvm.displayRtmMessage(string);
                        bl2 = true;
                    } else {
                        OZvm.displayRtmMessage("Eprom File Card size/type configuration is illegal.");
                    }
                    if ((n4 += 3) >= stringArray.length) continue;
                    FileArea fileArea = new FileArea(n8);
                    while (stringArray[n4].compareToIgnoreCase("-d") == 0 | stringArray[n4].compareToIgnoreCase("-f") == 0) {
                        if (stringArray[n4].compareToIgnoreCase("-f") == 0) {
                            fileArea.importHostFile(new File(stringArray[n4 + 1]));
                        }
                        if (stringArray[n4].compareToIgnoreCase("-d") == 0) {
                            fileArea.importHostFiles(new File(stringArray[n4 + 1]));
                        }
                        if ((n4 += 2) >= stringArray.length) continue block12;
                    }
                    continue;
                }
                if (n4 < stringArray.length && stringArray[n4].startsWith("crd")) {
                    int n9 = stringArray[n4].charAt(3) - 48;
                    n2 = Integer.parseInt(stringArray[n4 + 1], 10);
                    string = "";
                    n5 = 0;
                    if (stringArray[n4 + 2].compareToIgnoreCase("27C") == 0) {
                        string = "Loaded  file image '" + stringArray[n4 + 3] + "' on " + n2 + "K   UV Eprom Card in slot " + n9;
                        n5 = 3;
                    }
                    if (stringArray[n4 + 2].compareToIgnoreCase("28F") == 0) {
                        string = "Loaded  file image '" + stringArray[n4 + 3] + "' on " + n2 + "K   Intel Flash Card in slot " + n9;
                        n5 = 4;
                    }
                    if (stringArray[n4 + 2].compareToIgnoreCase("29F") == 0) {
                        string = "Loaded  file image '" + stringArray[n4 + 3] + "' on " + n2 + "K   Amd Flash Card in slot " + n9;
                        n5 = 5;
                    }
                    if (stringArray[n4 + 3].compareToIgnoreCase("-b") == 0) {
                        this.memory.loadBankFilesOnCard(n9, n2, n5, stringArray[n4 + 4]);
                        bl2 = true;
                        n4 += 5;
                        continue;
                    }
                    this.memory.loadFileImageOnCard(n9, n2, n5, new File(stringArray[n4 + 3]));
                    OZvm.displayRtmMessage(string);
                    bl2 = true;
                    n4 += 4;
                    continue;
                }
                if (n4 < stringArray.length && stringArray[n4].compareTo("debug") == 0) {
                    this.autoRun = false;
                    DebugGui.getInstance().activateDebugCommandLine();
                    ++n4;
                    continue;
                }
                if (n4 < stringArray.length && stringArray[n4].compareTo("initdebug") == 0) {
                    this.autoRun = false;
                    DebugGui.getInstance().activateDebugCommandLine();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[n4 + 1], "r");
                    DebugGui.getInstance().disableCmdLineInput();
                    while ((object = randomAccessFile.readLine()) != null) {
                        CommandLine.getInstance().parseCommandLine((String)object);
                    }
                    DebugGui.getInstance().enableCmdLineInput();
                    randomAccessFile.close();
                    OZvm.displayRtmMessage("Parsed '" + stringArray[n4 + 1] + "' command file.");
                    n4 += 2;
                    continue;
                }
                if (n4 >= stringArray.length || stringArray[n4].compareTo("kbl") != 0) continue;
                if (stringArray[n4 + 1].compareToIgnoreCase("uk") == 0 || stringArray[n4 + 1].compareToIgnoreCase("en") == 0) {
                    this.guiKbLayout = "uk";
                }
                if (stringArray[n4 + 1].compareTo("fr") == 0) {
                    this.guiKbLayout = "fr";
                }
                if (stringArray[n4 + 1].compareTo("dk") == 0) {
                    this.guiKbLayout = "dk";
                }
                if (stringArray[n4 + 1].compareTo("se") == 0 | stringArray[n4 + 1].compareTo("fi") == 0) {
                    this.guiKbLayout = "se";
                }
                n4 += 2;
            }
            if (!bl3 & !bl2 & !bl) {
                SaveRestoreVM saveRestoreVM = new SaveRestoreVM();
                try {
                    this.autoRun = saveRestoreVM.loadSnapShot(defaultVmFile);
                    bl3 = true;
                    OZvm.displayRtmMessage("Snapshot successfully installed from " + defaultVmFile);
                    this.gui.setWindowTitle("[boot.z88]");
                }
                catch (IOException iOException) {
                    bl3 = false;
                }
            }
            if (!bl3) {
                OZvm.loadPreferences();
            }
            if (!bl3 && !bl4) {
                if (loadedPreferences != null && loadedPreferences.getProperty("Slot0Ram") != null) {
                    n3 = Integer.parseInt(loadedPreferences.getProperty("Slot0Ram"));
                }
                OZvm.displayRtmMessage("RAM0 set to default " + n3 + "K.");
                this.memory.insertRamCard(n3, 0);
            }
            if (!bl3 & !bl & defaultBootRom != "") {
                OZvm.displayRtmMessage("Loading ROM image as specified in preferences: " + defaultBootRom);
                File file = new File(defaultBootRom);
                this.memory.loadRomBinary(file);
                this.blink.setRAMS(this.memory.getBank(0));
                bl = true;
            }
            if (!bl3 & !bl) {
                OZvm.displayRtmMessage("No external ROM image specified, using roms/Z88OZ47.rom");
                File file = new File(URI.create("file:///" + this.getAppPath() + systemBootRom.replace("\\", "/")));
                this.memory.loadRomBinary(file);
                this.blink.setRAMS(this.memory.getBank(0));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Couldn't load ROM/EPROM image:\n" + fileNotFoundException.getMessage() + "\n", "OZvm startup", 0);
            String string = fileNotFoundException.getMessage();
            if (!string.toLowerCase().contains(systemBootRom.toLowerCase())) {
                JOptionPane.showMessageDialog(null, "Loading System default ROM image:\n" + this.getAppPath() + systemBootRom + "\n", "OZvm startup", 1);
                File file = new File(URI.create("file:///" + this.getAppPath() + systemBootRom.replace("\\", "/")));
                try {
                    this.memory.loadRomBinary(file);
                }
                catch (IOException iOException) {
                    return false;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
                this.blink.setRAMS(this.memory.getBank(0));
            }
            return false;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Problem with ROM/EPROM image or I/O:\n" + iOException.getMessage(), "OZvm startup", 0);
            return false;
        }
        catch (FileAreaNotFoundException fileAreaNotFoundException) {
            JOptionPane.showMessageDialog(null, "Problem with importing file into File Card:\n" + fileAreaNotFoundException.getMessage(), "OZvm startup", 0);
            return false;
        }
        catch (FileAreaExhaustedException fileAreaExhaustedException) {
            JOptionPane.showMessageDialog(null, "Problem with importing file into File Card:\n" + fileAreaExhaustedException.getMessage(), "OZvm startup", 0);
            return false;
        }
        this.displayDefaultGui();
        this.gui.pack();
        this.gui.setVisible(true);
        this.gui.redrawGuiWindows(this.gui.getScreenDoubleSizeMenuItem().getState());
        return true;
    }

    public String getAppPath() {
        return this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replaceFirst("z88.jar", "");
    }

    private void displayDefaultGui() {
        this.gui.displayRunTimeMessagesPane(false);
        this.gui.displayZ88Keyboard(true);
        this.gui.displayZ88CardSlots(true);
        if (this.guiKbLayout.compareToIgnoreCase("uk") == 0) {
            Z88.getInstance().getKeyboard().setKeyboardLayout(3);
            this.gui.getUkLayoutMenuItem().setState(true);
            RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(3);
            OZvm.displayRtmMessage("Using English (UK) keyboard layout.");
        }
        if (this.guiKbLayout.compareTo("fr") == 0) {
            Z88.getInstance().getKeyboard().setKeyboardLayout(1);
            this.gui.getUkLayoutMenuItem().setState(true);
            RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(1);
            OZvm.displayRtmMessage("Using French keyboard layout.");
        }
        if (this.guiKbLayout.compareTo("dk") == 0) {
            Z88.getInstance().getKeyboard().setKeyboardLayout(4);
            this.gui.getUkLayoutMenuItem().setState(true);
            RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(4);
            OZvm.displayRtmMessage("Using Danish keyboard layout.");
        }
        if (this.guiKbLayout.compareTo("se") == 0) {
            Z88.getInstance().getKeyboard().setKeyboardLayout(5);
            this.gui.getUkLayoutMenuItem().setState(true);
            RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(5);
            OZvm.displayRtmMessage("Using Swedish/Finish keyboard layout.");
        }
        this.gui.setLocationRelativeTo(null);
    }

    public static void savePreferences() {
        int n = Z88.getInstance().getMemory().getInternalRamSize();
        Properties properties = new Properties();
        properties.setProperty("Z88KbLayout", "" + Z88.getInstance().getKeyboard().getKeyboardLayout());
        properties.setProperty("ScreenDoubleSize", Boolean.toString(OZvm.getInstance().getGui().getScreenDoubleSizeMenuItem().getState()));
        properties.setProperty("CpuRealSpeed", Boolean.toString(OZvm.getInstance().getGui().getZ80CpuRealSpeedMenuItem().isSelected()));
        properties.setProperty("DisplayRubberKeyboard", Boolean.toString(OZvm.getInstance().getGui().getShowRubberKbMenuItem().isSelected()));
        properties.setProperty("ScreenFps", "" + Z88.getInstance().getDisplay().getCurrentFrameRate());
        if (n == 1) {
            n = 8;
        }
        properties.setProperty("Slot0Ram", "" + n * 16);
        String string = defaultBootRom;
        if (Z88.getInstance().getMemory().getLoadedRomFile() != null) {
            string = Z88.getInstance().getMemory().getLoadedRomFile().getAbsolutePath();
        }
        properties.setProperty("Slot0Rom", string);
        File file = new File(defaultPreferencesFile);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static void loadPreferences() {
        String string;
        block34: {
            loadedPreferences = new Properties();
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(defaultPreferencesFile);
                    loadedPreferences.load(fileInputStream);
                }
                catch (IOException iOException) {
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (loadedPreferences.getProperty("Z88KbLayout") != null) {
            int n = Integer.parseInt(loadedPreferences.getProperty("Z88KbLayout"));
            switch (n) {
                case 3: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                    OZvm.getInstance().getGui().getUkLayoutMenuItem().setState(true);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(3);
                    break;
                }
                case 4: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(4);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(4);
                    OZvm.getInstance().getGui().getDkLayoutMenuItem().setState(true);
                    break;
                }
                case 1: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(1);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(1);
                    OZvm.getInstance().getGui().getFrLayoutMenuItem().setState(true);
                    break;
                }
                case 5: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(5);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(5);
                    OZvm.getInstance().getGui().getSeLayoutMenuItem().setState(true);
                    break;
                }
                default: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                    OZvm.getInstance().getGui().getUkLayoutMenuItem().setState(true);
                }
            }
        }
        if (loadedPreferences.getProperty("Slot0Rom") != null && (string = loadedPreferences.getProperty("Slot0Rom")) != "") {
            defaultBootRom = string;
        }
        if (loadedPreferences.getProperty("Z88Keyboard") != null) {
            boolean bl = Boolean.valueOf(loadedPreferences.getProperty("Z88Keyboard"));
            OZvm.getInstance().getGui().displayZ88Keyboard(bl);
        }
        if (loadedPreferences.getProperty("Z88CardSlots") != null) {
            boolean bl = Boolean.valueOf(loadedPreferences.getProperty("Z88CardSlots"));
            OZvm.getInstance().getGui().displayZ88CardSlots(bl);
        }
        if (loadedPreferences.getProperty("DisplayRubberKeyboard") != null) {
            boolean bl = Boolean.valueOf(loadedPreferences.getProperty("DisplayRubberKeyboard"));
            RubberKeyboard.getInstance().setVisible(bl);
            OZvm.getInstance().getGui().getShowRubberKbMenuItem().setSelected(bl);
        }
        if (loadedPreferences.getProperty("ScreenDoubleSize") != null) {
            boolean bl = Boolean.valueOf(loadedPreferences.getProperty("ScreenDoubleSize"));
            OZvm.getInstance().getGui().getScreenDoubleSizeMenuItem().setState(bl);
        }
        if (loadedPreferences.getProperty("CpuRealSpeed") != null) {
            boolean bl = Boolean.valueOf(loadedPreferences.getProperty("CpuRealSpeed"));
            OZvm.getInstance().getGui().getZ80CpuRealSpeedMenuItem().setSelected(bl);
            Z88.getInstance().getProcessor().setCpuRealSpeed(bl);
        }
        if (loadedPreferences.getProperty("ScreenFps") != null) {
            int n = Integer.parseInt(loadedPreferences.getProperty("ScreenFps"));
            Z88.getInstance().getDisplay().setFrameRate(n);
            switch (n) {
                case 0: {
                    OZvm.getInstance().getGui().getScreen10FpsMenuItem().setSelected(true);
                    break;
                }
                case 1: {
                    OZvm.getInstance().getGui().getScreen25FpsMenuItem().setSelected(true);
                    break;
                }
                case 2: {
                    OZvm.getInstance().getGui().getScreen50FpsMenuItem().setSelected(true);
                    break;
                }
                case 3: {
                    OZvm.getInstance().getGui().getScreen100FpsMenuItem().setSelected(true);
                }
            }
        }
    }

    public static void displayRtmMessage(String string) {
        OZvm.getInstance().getRtmMsgGui().displayRtmMessage(string);
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(System.getProperty("java.version").substring(0, 1)) * 10 + Integer.parseInt(System.getProperty("java.version").substring(2, 3));
        if (n < 16) {
            System.err.println("Java Runtime must be 1.6 or higher. OZvm terminated.");
            System.exit(0);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println("Error setting cross platform LAF: " + exception);
        }
        OZvm oZvm = OZvm.getInstance();
        if (!oZvm.boot(stringArray)) {
            System.out.println("Ozvm terminated.");
            System.exit(0);
        }
        if (oZvm.getAutorunStatus()) {
            Z88.getInstance().runZ80Cpu();
            Z88.getInstance().getDisplay().grabFocus();
        } else {
            DebugGui.getInstance().activateDebugCommandLine();
            CommandLine.getInstance().cmdlineFirstSingleStep();
        }
    }

    public RtmMessageGui getRtmMsgGui() {
        if (this.rtmMsgGui == null) {
            this.rtmMsgGui = new RtmMessageGui();
        }
        return this.rtmMsgGui;
    }

    /* synthetic */ OZvm(OZvm oZvm) {
        this();
    }

    private static final class singletonContainer {
        static final OZvm singleton = new OZvm(null);

        private singletonContainer() {
        }
    }
}

