/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Breakpoints;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.OZvm;
import com.jira.cambridgez88.ozvm.RubberKeyboard;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.datastructures.SlotInfo;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;

public class SaveRestoreVM {
    private Blink blink;
    private Z80Processor z80 = Z88.getInstance().getProcessor();
    private Memory memory = Z88.getInstance().getMemory();

    public SaveRestoreVM() {
        this.blink = Z88.getInstance().getBlink();
    }

    private void storeZ80Regs(Properties properties) {
        properties.setProperty("AF", Dz.addrToHex(this.z80.AF(), false));
        properties.setProperty("BC", Dz.addrToHex(this.z80.BC(), false));
        properties.setProperty("DE", Dz.addrToHex(this.z80.DE(), false));
        properties.setProperty("HL", Dz.addrToHex(this.z80.HL(), false));
        properties.setProperty("IX", Dz.addrToHex(this.z80.IX(), false));
        properties.setProperty("IY", Dz.addrToHex(this.z80.IY(), false));
        properties.setProperty("PC", Dz.addrToHex(this.z80.PC(), false));
        properties.setProperty("SP", Dz.addrToHex(this.z80.SP(), false));
        this.z80.ex_af_af();
        properties.setProperty("_AF", Dz.addrToHex(this.z80.AF(), false));
        this.z80.ex_af_af();
        this.z80.exx();
        properties.setProperty("_BC", Dz.addrToHex(this.z80.BC(), false));
        properties.setProperty("_DE", Dz.addrToHex(this.z80.DE(), false));
        properties.setProperty("_HL", Dz.addrToHex(this.z80.HL(), false));
        this.z80.exx();
        properties.setProperty("I", Dz.byteToHex(this.z80.I(), false));
        properties.setProperty("R", Dz.byteToHex(this.z80.R(), false));
        properties.setProperty("IM", Dz.byteToHex(this.z80.IM(), false));
        properties.setProperty("IFF1", Boolean.toString(this.z80.IFF1()));
        properties.setProperty("IFF2", Boolean.toString(this.z80.IFF2()));
    }

    private void loadZ80Regs(Properties properties) {
        this.z80.AF(Integer.parseInt(properties.getProperty("AF"), 16));
        this.z80.BC(Integer.parseInt(properties.getProperty("BC"), 16));
        this.z80.DE(Integer.parseInt(properties.getProperty("DE"), 16));
        this.z80.HL(Integer.parseInt(properties.getProperty("HL"), 16));
        this.z80.IX(Integer.parseInt(properties.getProperty("IX"), 16));
        this.z80.IY(Integer.parseInt(properties.getProperty("IY"), 16));
        this.z80.PC(Integer.parseInt(properties.getProperty("PC"), 16));
        this.z80.SP(Integer.parseInt(properties.getProperty("SP"), 16));
        this.z80.ex_af_af();
        this.z80.AF(Integer.parseInt(properties.getProperty("_AF"), 16));
        this.z80.ex_af_af();
        this.z80.exx();
        this.z80.BC(Integer.parseInt(properties.getProperty("_BC"), 16));
        this.z80.DE(Integer.parseInt(properties.getProperty("_DE"), 16));
        this.z80.HL(Integer.parseInt(properties.getProperty("_HL"), 16));
        this.z80.exx();
        this.z80.I(Integer.parseInt(properties.getProperty("I"), 16));
        this.z80.R(Integer.parseInt(properties.getProperty("R"), 16));
        this.z80.IM(Integer.parseInt(properties.getProperty("IM"), 16));
        this.z80.IFF1(Boolean.valueOf(properties.getProperty("IFF1")));
        this.z80.IFF2(Boolean.valueOf(properties.getProperty("IFF2")));
    }

    private void storeBlinkRegs(Properties properties) {
        properties.setProperty("PB0", Dz.addrToHex(this.blink.getPb0(), false));
        properties.setProperty("PB1", Dz.addrToHex(this.blink.getPb1(), false));
        properties.setProperty("PB2", Dz.addrToHex(this.blink.getPb2(), false));
        properties.setProperty("PB3", Dz.addrToHex(this.blink.getPb3(), false));
        properties.setProperty("SBR", Dz.addrToHex(this.blink.getSbr(), false));
        properties.setProperty("COM", Dz.byteToHex(this.blink.getCom(), false));
        properties.setProperty("INT", Dz.byteToHex(this.blink.getInt(), false));
        properties.setProperty("STA", Dz.byteToHex(this.blink.getSta(), false));
        properties.setProperty("TMK", Dz.byteToHex(this.blink.getTmk(), false));
        properties.setProperty("TSTA", Dz.byteToHex(this.blink.getTsta(), false));
        properties.setProperty("SR0", Dz.byteToHex(this.blink.getSegmentBank(0), false));
        properties.setProperty("SR1", Dz.byteToHex(this.blink.getSegmentBank(1), false));
        properties.setProperty("SR2", Dz.byteToHex(this.blink.getSegmentBank(2), false));
        properties.setProperty("SR3", Dz.byteToHex(this.blink.getSegmentBank(3), false));
        properties.setProperty("TIM0", Dz.byteToHex(this.blink.getTim0(), false));
        properties.setProperty("TIM1", Dz.byteToHex(this.blink.getTim1(), false));
        properties.setProperty("TIM2", Dz.byteToHex(this.blink.getTim2(), false));
        properties.setProperty("TIM3", Dz.byteToHex(this.blink.getTim3(), false));
        properties.setProperty("TIM4", Dz.byteToHex(this.blink.getTim4(), false));
    }

    private void loadBlinkRegs(Properties properties) {
        this.blink.setPb0(Integer.parseInt(properties.getProperty("PB0"), 16));
        this.blink.setPb1(Integer.parseInt(properties.getProperty("PB1"), 16));
        this.blink.setPb2(Integer.parseInt(properties.getProperty("PB2"), 16));
        this.blink.setPb3(Integer.parseInt(properties.getProperty("PB3"), 16));
        this.blink.setSbr(Integer.parseInt(properties.getProperty("SBR"), 16));
        this.blink.setCom(Integer.parseInt(properties.getProperty("COM"), 16));
        this.blink.setInt(Integer.parseInt(properties.getProperty("INT"), 16));
        this.blink.setSta(Integer.parseInt(properties.getProperty("STA"), 16));
        this.blink.setTmk(Integer.parseInt(properties.getProperty("TMK"), 16));
        this.blink.setTsta(Integer.parseInt(properties.getProperty("TSTA"), 16));
        this.blink.setSegmentBank(0, Integer.parseInt(properties.getProperty("SR0"), 16));
        this.blink.setSegmentBank(1, Integer.parseInt(properties.getProperty("SR1"), 16));
        this.blink.setSegmentBank(2, Integer.parseInt(properties.getProperty("SR2"), 16));
        this.blink.setSegmentBank(3, Integer.parseInt(properties.getProperty("SR3"), 16));
        this.blink.setTim0(Integer.parseInt(properties.getProperty("TIM0"), 16));
        this.blink.setTim1(Integer.parseInt(properties.getProperty("TIM1"), 16));
        this.blink.setTim2(Integer.parseInt(properties.getProperty("TIM2"), 16));
        this.blink.setTim3(Integer.parseInt(properties.getProperty("TIM3"), 16));
        this.blink.setTim4(Integer.parseInt(properties.getProperty("TIM4"), 16));
    }

    private void loadBreakpoints(Properties properties) {
        Breakpoints breakpoints = this.z80.getBreakpoints();
        breakpoints.removeBreakPoints();
        String string = properties.getProperty("Breakpoints");
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2 != null && string2.length() > 0) {
                if (string2.startsWith("[d]")) {
                    string2 = string2.substring(3);
                    breakpoints.toggleBreakpoint(Integer.parseInt(string2, 16), false);
                } else {
                    breakpoints.toggleBreakpoint(Integer.parseInt(string2, 16));
                }
            }
            ++n;
        }
    }

    public void storeSnapShot(String string, boolean bl) throws IOException {
        Object object;
        String string2 = String.valueOf(System.getProperty("user.home")) + File.separator + "snapshot.settings";
        String string3 = String.valueOf(System.getProperty("user.home")) + File.separator + "snapshot.png";
        Properties properties = new Properties();
        if (string.toLowerCase().lastIndexOf(".z88") == -1) {
            string = String.valueOf(string) + ".z88";
        }
        this.storeZ80Regs(properties);
        this.storeBlinkRegs(properties);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
        zipOutputStream.setLevel(9);
        BufferedImage bufferedImage = Z88.getInstance().getDisplay().getScreenFrame();
        File file = new File(string3);
        ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        this.copyToZip(string3, "snapshot.png", zipOutputStream);
        file.delete();
        int n = 0;
        while (n <= 3) {
            if (!this.memory.isSlotEmpty(n)) {
                if (n == 0) {
                    this.memory.dumpSlot(n, false, System.getProperty("user.home"), "");
                    this.copyToZip(String.valueOf(System.getProperty("user.home")) + File.separator + "rom.bin", "rom.bin", zipOutputStream);
                    this.copyToZip(String.valueOf(System.getProperty("user.home")) + File.separator + "ram.bin", "ram.bin", zipOutputStream);
                    new File(String.valueOf(System.getProperty("user.home")) + File.separator + "rom.bin").delete();
                    new File(String.valueOf(System.getProperty("user.home")) + File.separator + "ram.bin").delete();
                } else {
                    properties.setProperty("SLOT" + n + "TYPE", "" + SlotInfo.getInstance().getCardType(n));
                    object = "slot" + n + ".bin";
                    String string4 = String.valueOf(System.getProperty("user.home")) + File.separator + (String)object;
                    this.memory.dumpSlot(n, false, System.getProperty("user.home"), (String)object);
                    this.copyToZip(string4, (String)object, zipOutputStream);
                    new File(string4).delete();
                }
            } else {
                properties.setProperty("SLOT" + n + "TYPE", "0");
            }
            ++n;
        }
        properties.setProperty("Z88StoppedAtTime", "" + this.z80.getZ88StoppedAtTime());
        properties.setProperty("Z88KbLayout", "" + Z88.getInstance().getKeyboard().getKeyboardLayout());
        properties.setProperty("RtmMessages", Boolean.toString(OZvm.getInstance().getGui().getRtmMessagesMenuItem().isSelected()));
        properties.setProperty("Breakpoints", this.z80.getBreakpoints().breakpointList());
        properties.setProperty("Autorun", Boolean.toString(bl));
        properties.setProperty("ScreenDoubleSize", Boolean.toString(OZvm.getInstance().getGui().getScreenDoubleSizeMenuItem().getState()));
        properties.setProperty("CpuRealSpeed", Boolean.toString(OZvm.getInstance().getGui().getZ80CpuRealSpeedMenuItem().isSelected()));
        properties.setProperty("DisplayRubberKeyboard", Boolean.toString(OZvm.getInstance().getGui().getShowRubberKbMenuItem().isSelected()));
        properties.setProperty("ScreenFps", "" + Z88.getInstance().getDisplay().getCurrentFrameRate());
        File file2 = new File(string2);
        object = new FileOutputStream(file2);
        properties.store((OutputStream)object, null);
        ((FileOutputStream)object).close();
        this.copyToZip(string2, "snapshot.settings", zipOutputStream);
        file2.delete();
        zipOutputStream.close();
    }

    private void copyToZip(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[16384];
        FileInputStream fileInputStream = new FileInputStream(string);
        zipOutputStream.putNextEntry(new ZipEntry(string2));
        while ((n = fileInputStream.read(byArray)) > 0) {
            zipOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
    }

    /*
     * WARNING - void declaration
     */
    public boolean loadSnapShot(String string) throws IOException {
        void var6_6;
        Properties properties = new Properties();
        if (string.toLowerCase().lastIndexOf(".z88") == -1) {
            string = String.valueOf(string) + ".z88";
        }
        this.memory.setVoidMemory();
        this.blink.resetBlinkRegisters();
        ZipFile zipFile = new ZipFile(string);
        ZipEntry zipEntry = zipFile.getEntry("snapshot.settings");
        if (zipEntry == null) {
            throw new IOException("'snapshot.settings' is missing!");
        }
        properties.load(zipFile.getInputStream(zipEntry));
        zipEntry = zipFile.getEntry("rom.bin");
        if (zipEntry == null) {
            throw new IOException("ROM image is missing!");
        }
        this.memory.loadRomBinary((int)zipEntry.getSize(), zipFile.getInputStream(zipEntry));
        zipEntry = zipFile.getEntry("ram.bin");
        if (zipEntry == null) {
            throw new IOException("RAM.0 image is missing!");
        }
        this.memory.loadCardBinary(0, (int)zipEntry.getSize(), 2, zipFile.getInputStream(zipEntry));
        boolean bl = true;
        while (var6_6 <= 3) {
            zipEntry = zipFile.getEntry("slot" + (int)var6_6 + ".bin");
            if (zipEntry != null) {
                this.memory.loadCardBinary((int)var6_6, (int)zipEntry.getSize(), Integer.parseInt(properties.getProperty("SLOT" + (int)var6_6 + "TYPE"), 16), zipFile.getInputStream(zipEntry));
            }
            ++var6_6;
        }
        this.loadZ80Regs(properties);
        this.loadBlinkRegs(properties);
        this.loadBreakpoints(properties);
        if (properties.getProperty("Z88StoppedAtTime") != null) {
            this.z80.setZ88StoppedAtTime(Long.parseLong(properties.getProperty("Z88StoppedAtTime")));
        } else {
            this.z80.setZ88StoppedAtTime(System.currentTimeMillis());
        }
        if (properties.getProperty("Z88KbLayout") != null) {
            int n = Integer.parseInt(properties.getProperty("Z88KbLayout"));
            switch (n) {
                case 3: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                    OZvm.getInstance().getGui().getUkLayoutMenuItem().setState(true);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(3);
                    break;
                }
                case 4: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(4);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(4);
                    OZvm.getInstance().getGui().getDkLayoutMenuItem().setState(true);
                    break;
                }
                case 1: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(1);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(1);
                    OZvm.getInstance().getGui().getFrLayoutMenuItem().setState(true);
                    break;
                }
                case 5: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(5);
                    RubberKeyboard.getInstance().setKeyboardCountrySpecificIcons(5);
                    OZvm.getInstance().getGui().getSeLayoutMenuItem().setState(true);
                    break;
                }
                default: {
                    Z88.getInstance().getKeyboard().setKeyboardLayout(3);
                    OZvm.getInstance().getGui().getUkLayoutMenuItem().setState(true);
                }
            }
        }
        if (properties.getProperty("RtmMessages") != null) {
            boolean bl2 = Boolean.valueOf(properties.getProperty("RtmMessages"));
            OZvm.getInstance().getGui().displayRunTimeMessagesPane(bl2);
        }
        if (properties.getProperty("Z88Keyboard") != null) {
            boolean bl3 = Boolean.valueOf(properties.getProperty("Z88Keyboard"));
            OZvm.getInstance().getGui().displayZ88Keyboard(bl3);
        }
        if (properties.getProperty("Z88CardSlots") != null) {
            boolean bl4 = Boolean.valueOf(properties.getProperty("Z88CardSlots"));
            OZvm.getInstance().getGui().displayZ88CardSlots(bl4);
        }
        boolean bl5 = properties.getProperty("Autorun") != null ? Boolean.valueOf(properties.getProperty("Autorun")) : true;
        if (properties.getProperty("DisplayRubberKeyboard") != null) {
            boolean bl6 = Boolean.valueOf(properties.getProperty("DisplayRubberKeyboard"));
            RubberKeyboard.getInstance().setVisible(bl6);
            OZvm.getInstance().getGui().getShowRubberKbMenuItem().setSelected(bl6);
        }
        if (properties.getProperty("ScreenDoubleSize") != null) {
            boolean bl7 = Boolean.valueOf(properties.getProperty("ScreenDoubleSize"));
            OZvm.getInstance().getGui().getScreenDoubleSizeMenuItem().setState(bl7);
        }
        if (properties.getProperty("CpuRealSpeed") != null) {
            boolean bl8 = Boolean.valueOf(properties.getProperty("CpuRealSpeed"));
            OZvm.getInstance().getGui().getZ80CpuRealSpeedMenuItem().setSelected(bl8);
            Z88.getInstance().getProcessor().setCpuRealSpeed(bl8);
        }
        if (properties.getProperty("ScreenFps") != null) {
            int n = Integer.parseInt(properties.getProperty("ScreenFps"));
            Z88.getInstance().getDisplay().setFrameRate(n);
            switch (n) {
                case 0: {
                    OZvm.getInstance().getGui().getScreen10FpsMenuItem().setSelected(true);
                    break;
                }
                case 1: {
                    OZvm.getInstance().getGui().getScreen25FpsMenuItem().setSelected(true);
                    break;
                }
                case 2: {
                    OZvm.getInstance().getGui().getScreen50FpsMenuItem().setSelected(true);
                    break;
                }
                case 3: {
                    OZvm.getInstance().getGui().getScreen100FpsMenuItem().setSelected(true);
                }
            }
        }
        zipFile.close();
        return bl5;
    }

    public SnapshotFilter getSnapshotFilter() {
        return new SnapshotFilter();
    }

    private class SnapshotFilter
    extends FileFilter {
        private SnapshotFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null) {
                if (string.equalsIgnoreCase("z88")) {
                    ZipFile zipFile;
                    block8: {
                        ZipEntry zipEntry;
                        Properties properties = new Properties();
                        try {
                            zipFile = new ZipFile(file);
                            zipEntry = zipFile.getEntry("snapshot.settings");
                            if (zipEntry == null) {
                                return false;
                            }
                            properties.load(zipFile.getInputStream(zipEntry));
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                        zipEntry = zipFile.getEntry("rom.bin");
                        if (zipEntry != null) break block8;
                        return false;
                    }
                    zipFile.close();
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Z88 snapshot files";
        }

        private String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }
}

