/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.CommandLine;
import com.jira.cambridgez88.ozvm.DebugGui;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.Z88;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Watchpoints {
    private Map watchPoints = new HashMap();
    private Watchpoint bpSearchKey = new Watchpoint(0);

    public void clearWatchpoint(int n) {
        Watchpoint watchpoint = new Watchpoint(n);
        if (this.watchPoints.containsKey(watchpoint)) {
            this.watchPoints.remove(watchpoint);
            Z88.getInstance().getMemory().clearWatchpoint(n);
        }
    }

    public void setWatchpoint(int n) {
        Watchpoint watchpoint = new Watchpoint(n);
        if (!this.watchPoints.containsKey(watchpoint)) {
            this.watchPoints.put(watchpoint, watchpoint);
            Z88.getInstance().getMemory().setReadWatchpoint(n);
            Z88.getInstance().getMemory().setReadWatchpoint(n);
        }
    }

    public void toggleWatchpoint(int n) {
        Watchpoint watchpoint = new Watchpoint(n);
        if (!this.watchPoints.containsKey(watchpoint)) {
            this.watchPoints.put(watchpoint, watchpoint);
            Z88.getInstance().getMemory().setWatchpoint(n);
        } else {
            this.watchPoints.remove(watchpoint);
            Z88.getInstance().getMemory().clearWatchpoint(n);
        }
    }

    public void toggleReadWatchpoint(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            Z88.getInstance().getMemory().clearReadWatchpoint(n);
            if (watchpoint.databusWrite) {
                watchpoint.databusRead = false;
            } else {
                this.watchPoints.remove(watchpoint);
                Z88.getInstance().getMemory().clearWatchpoint(n);
            }
        } else {
            Watchpoint watchpoint2 = new Watchpoint(n);
            watchpoint2.databusWrite = false;
            this.watchPoints.put(watchpoint2, watchpoint2);
            Z88.getInstance().getMemory().setReadWatchpoint(n);
        }
    }

    public void toggleReadWatchpoint(int n, boolean bl) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            Z88.getInstance().getMemory().clearReadWatchpoint(n);
            if (watchpoint.databusWrite) {
                watchpoint.databusRead = false;
            } else {
                this.watchPoints.remove(watchpoint);
                Z88.getInstance().getMemory().clearWatchpoint(n);
            }
        } else {
            Watchpoint watchpoint2 = new Watchpoint(n, bl);
            watchpoint2.databusWrite = false;
            this.watchPoints.put(watchpoint2, watchpoint2);
            Z88.getInstance().getMemory().setReadWatchpoint(n);
        }
    }

    public void toggleReadWatchpoint(int n, ArrayList<String> arrayList) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            Z88.getInstance().getMemory().clearReadWatchpoint(n);
            if (watchpoint.databusWrite) {
                watchpoint.databusRead = false;
            } else {
                this.watchPoints.remove(watchpoint);
                Z88.getInstance().getMemory().clearWatchpoint(n);
            }
        } else {
            Watchpoint watchpoint2 = new Watchpoint(n, arrayList);
            watchpoint2.databusWrite = false;
            this.watchPoints.put(watchpoint2, watchpoint2);
            Z88.getInstance().getMemory().setReadWatchpoint(n);
        }
    }

    public void toggleWriteWatchpoint(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            Z88.getInstance().getMemory().clearWriteWatchpoint(n);
            if (watchpoint.databusRead) {
                watchpoint.databusWrite = false;
            } else {
                this.watchPoints.remove(watchpoint);
                Z88.getInstance().getMemory().clearWatchpoint(n);
            }
        } else {
            Watchpoint watchpoint2 = new Watchpoint(n);
            watchpoint2.databusRead = false;
            this.watchPoints.put(watchpoint2, watchpoint2);
            Z88.getInstance().getMemory().setWriteWatchpoint(n);
        }
    }

    public void toggleWriteWatchpoint(int n, boolean bl) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            Z88.getInstance().getMemory().clearWriteWatchpoint(n);
            if (watchpoint.databusRead) {
                watchpoint.databusWrite = false;
            } else {
                this.watchPoints.remove(watchpoint);
                Z88.getInstance().getMemory().clearWatchpoint(n);
            }
        } else {
            Watchpoint watchpoint2 = new Watchpoint(n, bl);
            watchpoint2.databusRead = false;
            this.watchPoints.put(watchpoint2, watchpoint2);
            Z88.getInstance().getMemory().setWriteWatchpoint(n);
        }
    }

    public void toggleWriteWatchpoint(int n, ArrayList<String> arrayList) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            Z88.getInstance().getMemory().clearWriteWatchpoint(n);
            if (watchpoint.databusRead) {
                watchpoint.databusWrite = false;
            } else {
                this.watchPoints.remove(watchpoint);
                Z88.getInstance().getMemory().clearWatchpoint(n);
            }
        } else {
            Watchpoint watchpoint2 = new Watchpoint(n, arrayList);
            watchpoint2.databusRead = false;
            this.watchPoints.put(watchpoint2, watchpoint2);
            Z88.getInstance().getMemory().setWriteWatchpoint(n);
        }
    }

    public void toggleWatchpoint(int n, boolean bl) {
        Watchpoint watchpoint = new Watchpoint(n, bl);
        if (!this.watchPoints.containsKey(watchpoint)) {
            this.watchPoints.put(watchpoint, watchpoint);
            Z88.getInstance().getMemory().setWatchpoint(n);
        } else {
            this.watchPoints.remove(watchpoint);
            Z88.getInstance().getMemory().clearWatchpoint(n);
        }
    }

    public void toggleWatchpoint(int n, ArrayList<String> arrayList) {
        Watchpoint watchpoint = new Watchpoint(n, arrayList);
        if (!this.watchPoints.containsKey(watchpoint)) {
            this.watchPoints.put(watchpoint, watchpoint);
            Z88.getInstance().getMemory().setWatchpoint(n);
        } else {
            this.watchPoints.remove(watchpoint);
            Z88.getInstance().getMemory().clearWatchpoint(n);
        }
    }

    public boolean hasCommands(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            return watchpoint.hasCommands();
        }
        return false;
    }

    public void runCommands(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null & watchpoint.hasCommands()) {
            watchpoint.runCommands();
        }
    }

    public boolean isCreated(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        return watchpoint != null;
    }

    public boolean isStoppable(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        return watchpoint != null && watchpoint.stop;
    }

    public void activate(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            watchpoint.active = true;
        }
    }

    public void suspend(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        if (watchpoint != null) {
            watchpoint.active = false;
        }
    }

    public boolean isActive(int n) {
        this.bpSearchKey.setWpAddress(n);
        Watchpoint watchpoint = (Watchpoint)this.watchPoints.get(this.bpSearchKey);
        return watchpoint != null && watchpoint.active;
    }

    public String displayWatchpoints() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n = 0;
        stringBuffer.append("Watchpoints:\n");
        if (this.watchPoints.isEmpty()) {
            return new String("No Watchpoints defined.");
        }
        for (Map.Entry entry : this.watchPoints.entrySet()) {
            Watchpoint watchpoint = (Watchpoint)entry.getKey();
            stringBuffer.append(Dz.extAddrToHex(watchpoint.getWpAddress(), false));
            stringBuffer.append(watchpoint.databusRead ? "r" : "");
            stringBuffer.append(watchpoint.databusWrite ? "w" : "");
            stringBuffer.append(!watchpoint.stop ? "[d]" : "");
            if (n++ == 7) {
                stringBuffer.append("\n");
                n = 0;
                continue;
            }
            stringBuffer.append("\t");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String watchpointList() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (this.watchPoints.isEmpty()) {
            return "";
        }
        Iterator iterator = this.watchPoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Watchpoint watchpoint = (Watchpoint)entry.getKey();
            stringBuffer.append(watchpoint.databusRead ? "r" : "");
            stringBuffer.append(watchpoint.databusWrite ? "w" : "");
            stringBuffer.append(!watchpoint.stop ? "[d]" : "");
            stringBuffer.append(Dz.extAddrToHex(watchpoint.getWpAddress(), false));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public void installWatchpoints() {
        if (!this.watchPoints.isEmpty()) {
            for (Map.Entry entry : this.watchPoints.entrySet()) {
                Watchpoint watchpoint = (Watchpoint)entry.getKey();
                Z88.getInstance().getMemory().setWatchpoint(watchpoint.getWpAddress());
            }
        }
    }

    public void clearWatchpoints() {
        if (!this.watchPoints.isEmpty()) {
            for (Map.Entry entry : this.watchPoints.entrySet()) {
                Watchpoint watchpoint = (Watchpoint)entry.getKey();
                Z88.getInstance().getMemory().clearWatchpoint(watchpoint.getWpAddress());
            }
        }
    }

    public void removeWatchpoints() {
        this.clearWatchpoints();
        this.watchPoints.clear();
    }

    private class Watchpoint {
        private int addressKey;
        private boolean stop = true;
        private boolean databusRead = true;
        private boolean databusWrite = true;
        private boolean active = true;
        private ArrayList<String> commands;

        Watchpoint(int n) {
            this.addressKey = n;
            this.commands = null;
        }

        Watchpoint(int n, ArrayList<String> arrayList) {
            this(n);
            this.commands = arrayList;
        }

        Watchpoint(int n, boolean bl) {
            this(n);
            this.stop = bl;
        }

        private void setWpAddress(int n) {
            this.addressKey = n;
        }

        private int getWpAddress() {
            return this.addressKey;
        }

        public int hashCode() {
            return this.addressKey;
        }

        private boolean hasCommands() {
            return this.commands != null;
        }

        private void runCommands() {
            if (this.commands != null) {
                CommandLine commandLine = CommandLine.getInstance();
                DebugGui.getInstance().disableCmdLineInput();
                int n = 0;
                while (n < this.commands.size()) {
                    commandLine.parseCommandLine(this.commands.get(n));
                    ++n;
                }
                DebugGui.getInstance().enableCmdLineInput();
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof Watchpoint)) {
                return false;
            }
            Watchpoint watchpoint = (Watchpoint)object;
            return this.addressKey == watchpoint.addressKey;
        }
    }
}

