/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88;

public class Z88Info {
    public static String z80RegisterInfo() {
        Z80Processor z80Processor = Z88.getInstance().getProcessor();
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(" ").append("BC=").append(Dz.addrToHex(z80Processor.BC(), false)).append(" ");
        stringBuffer.append(" ").append("DE=").append(Dz.addrToHex(z80Processor.DE(), false)).append(" ");
        stringBuffer.append(" ").append("HL=").append(Dz.addrToHex(z80Processor.HL(), false)).append(" ");
        stringBuffer.append(" ").append("IX=").append(Dz.addrToHex(z80Processor.IX(), false)).append(" ");
        stringBuffer.append(" ").append("IY=").append(Dz.addrToHex(z80Processor.IY(), false)).append(" ");
        stringBuffer.append(" ").append("\n");
        z80Processor.exx();
        stringBuffer.append("'BC=").append(Dz.addrToHex(z80Processor.BC(), false)).append(" ");
        stringBuffer.append("'DE=").append(Dz.addrToHex(z80Processor.DE(), false)).append(" ");
        stringBuffer.append("'HL=").append(Dz.addrToHex(z80Processor.HL(), false)).append(" ");
        z80Processor.exx();
        stringBuffer.append(" ").append("SP=").append(Dz.addrToHex(z80Processor.SP(), false)).append(" ");
        stringBuffer.append(" ").append("PC=").append(Dz.addrToHex(z80Processor.PC(), false)).append("\n");
        stringBuffer.append(" ").append("AF=").append(Dz.addrToHex(z80Processor.AF(), false)).append(" ");
        stringBuffer.append(" ").append("A=").append(Dz.byteToHex(z80Processor.A(), false)).append(" ");
        stringBuffer.append(" ").append("F=").append(Z88Info.z80Flags()).append(" ");
        stringBuffer.append(" ").append("I=").append(z80Processor.I()).append("\n");
        z80Processor.ex_af_af();
        stringBuffer.append("'AF=").append(Dz.addrToHex(z80Processor.AF(), false)).append(" ");
        stringBuffer.append("'A=").append(Dz.byteToHex(z80Processor.A(), false)).append(" ");
        stringBuffer.append("'F=").append(Z88Info.z80Flags()).append(" ");
        stringBuffer.append(" ").append("R=").append(z80Processor.R()).append("\n");
        z80Processor.ex_af_af();
        return stringBuffer.toString();
    }

    public static String dzPcStatus(int n) {
        Dz dz = Dz.getInstance();
        StringBuffer stringBuffer = new StringBuffer(128);
        dz.getInstrAscii(stringBuffer, n, false, true);
        StringBuffer stringBuffer2 = new StringBuffer(128);
        stringBuffer2.append(Dz.addrToHex(n, false)).append(" (").append(Dz.extAddrToHex(Z88.getInstance().getBlink().decodeLocalAddress(n), false).toString()).append(") ").append(stringBuffer);
        int n2 = 45 - stringBuffer2.length();
        while (n2 > 0) {
            stringBuffer2.append(" ");
            --n2;
        }
        stringBuffer2.append(Z88Info.quickZ80Dump());
        return stringBuffer2.toString();
    }

    public static StringBuffer quickZ80Dump(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n >>> 8;
        int n9 = n & 0xFF;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(Dz.byteToHex(n8, false)).append(" ");
        stringBuffer.append(Dz.addrToHex(n2, false)).append(" ");
        stringBuffer.append(Dz.addrToHex(n3, false)).append(" ");
        stringBuffer.append(Dz.addrToHex(n4, false)).append(" ");
        stringBuffer.append(Dz.addrToHex(n7, false)).append(" ");
        stringBuffer.append(Dz.addrToHex(n5, false)).append(" ");
        stringBuffer.append(Dz.addrToHex(n6, false)).append(" ");
        stringBuffer.append((n9 & 0x80) != 0 ? "S" : ".");
        stringBuffer.append((n9 & 0x40) != 0 ? "Z" : ".");
        stringBuffer.append((n9 & 0x20) != 0 ? "5" : ".");
        stringBuffer.append((n9 & 0x10) != 0 ? "H" : ".");
        stringBuffer.append((n9 & 8) != 0 ? "3" : ".");
        stringBuffer.append((n9 & 4) != 0 ? "V" : ".");
        stringBuffer.append((n9 & 2) != 0 ? "N" : ".");
        stringBuffer.append((n9 & 1) != 0 ? "C" : ".");
        return stringBuffer;
    }

    private static StringBuffer quickZ80Dump() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Z80Processor z80Processor = Z88.getInstance().getProcessor();
        stringBuffer.append(Dz.byteToHex(z80Processor.A(), false)).append(" ");
        stringBuffer.append(Dz.addrToHex(z80Processor.BC(), false)).append(" ");
        stringBuffer.append(Dz.addrToHex(z80Processor.DE(), false)).append(" ");
        stringBuffer.append(Dz.addrToHex(z80Processor.HL(), false)).append(" ");
        stringBuffer.append("(").append(Dz.addrToHex(z80Processor.SP(), false)).append(")=");
        stringBuffer.append(Dz.addrToHex(z80Processor.readWord(z80Processor.SP()), false)).append(" ");
        stringBuffer.append(Dz.addrToHex(z80Processor.IX(), false)).append(" ");
        stringBuffer.append(Dz.addrToHex(z80Processor.IY(), false)).append(" ");
        stringBuffer.append(Z88Info.z80Flags());
        return stringBuffer;
    }

    public static String blinkRegisterDump() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(Z88Info.blinkComInfo()).append("\n");
        stringBuffer.append(Z88Info.blinkIntInfo()).append("\n");
        stringBuffer.append(Z88Info.blinkStaInfo()).append("\n");
        stringBuffer.append(Z88Info.blinkTimersInfo()).append("\n");
        stringBuffer.append(Z88Info.blinkTstaInfo()).append("\n");
        stringBuffer.append(Z88Info.blinkTmkInfo()).append("\n");
        stringBuffer.append(Z88Info.blinkScreenInfo()).append("\n");
        stringBuffer.append(Z88Info.blinkSegmentsInfo()).append("\n");
        return stringBuffer.toString();
    }

    public static String blinkTimersInfo() {
        Blink blink = Z88.getInstance().getBlink();
        int n = blink.getTim0();
        int n2 = blink.getTim1();
        int n3 = blink.getTim2();
        int n4 = blink.getTim3();
        int n5 = blink.getTim4();
        int n6 = 65536 * n5 + 256 * n4 + n3;
        int n7 = n6 / 1440;
        int n8 = (n6 - n7 * 1440) / 60;
        n6 = n6 - n7 * 1440 - n8 * 60;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("TIM4=" + n5);
        stringBuffer.append(",TIM3=" + n4);
        stringBuffer.append(",TIM2=" + n3);
        stringBuffer.append(",TIM1=" + n2);
        stringBuffer.append(",TIM0=" + n);
        stringBuffer.append(", Time elapsed: " + n7 + "d:" + n8 + "h:");
        stringBuffer.append(String.valueOf(n6) + "m:" + n2 + "s:" + n * 5 + "ms");
        return stringBuffer.toString();
    }

    public static StringBuffer z80Flags(int n) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append((n & 0x80) != 0 ? "S" : ".");
        stringBuffer.append((n & 0x40) != 0 ? "Z" : ".");
        stringBuffer.append((n & 0x20) != 0 ? "5" : ".");
        stringBuffer.append((n & 0x10) != 0 ? "H" : ".");
        stringBuffer.append((n & 8) != 0 ? "3" : ".");
        stringBuffer.append((n & 4) != 0 ? "V" : ".");
        stringBuffer.append((n & 2) != 0 ? "N" : ".");
        stringBuffer.append((n & 1) != 0 ? "C" : ".");
        return stringBuffer;
    }

    public static StringBuffer z80Flags() {
        return Z88Info.z80Flags(Z88.getInstance().getProcessor().F());
    }

    public static String bankBindingInfo() {
        StringBuffer stringBuffer = new StringBuffer(256);
        Blink blink = Z88.getInstance().getBlink();
        stringBuffer.append("RAMS      (0000h-1FFFh): ");
        if ((blink.getCom() & 4) == 4) {
            stringBuffer.append("20h");
        } else {
            stringBuffer.append("00h");
        }
        stringBuffer.append("\n");
        stringBuffer.append("Segment 0 (2000h-3FFFh): ");
        stringBuffer.append(Dz.byteToHex(blink.getSegmentBank(0) & 0xFE, true)).append(" ");
        stringBuffer.append((blink.getSegmentBank(0) & 1) == 0 ? "(Lower 8K)" : "(Upper 8K)");
        stringBuffer.append("\n");
        stringBuffer.append("Segment 1 (4000h-7FFFh): ");
        stringBuffer.append(Dz.byteToHex(blink.getSegmentBank(1), true)).append("\n");
        stringBuffer.append("Segment 2 (8000h-BFFFh): ");
        stringBuffer.append(Dz.byteToHex(blink.getSegmentBank(2), true)).append("\n");
        stringBuffer.append("Segment 3 (C000h-FFFFh): ");
        stringBuffer.append(Dz.byteToHex(blink.getSegmentBank(3), true));
        return stringBuffer.toString();
    }

    public static String blinkComInfo() {
        StringBuffer stringBuffer = new StringBuffer(128);
        Blink blink = Z88.getInstance().getBlink();
        int n = blink.getCom() & 0xFF;
        stringBuffer.append("COM (B0h) = " + Dz.byteToBin(n, true) + " : ");
        if ((n & 0x80) == 0 & (n & 0x40) == 0) {
            stringBuffer.append("Speaker=Low");
        }
        if ((n & 0x80) == 0 & (n & 0x40) == 64) {
            stringBuffer.append("Speaker=High");
        }
        if ((n & 0x80) == 128 & (n & 0x40) == 0) {
            stringBuffer.append("Speaker=3200Khz");
        }
        if ((n & 0x80) == 128 & (n & 0x40) == 64) {
            stringBuffer.append("Speaker=TxD");
        }
        if ((n & 0x20) == 32) {
            stringBuffer.append(",OVERP");
        }
        if ((n & 0x10) == 16) {
            stringBuffer.append(",RESTIM");
        }
        if ((n & 8) == 8) {
            stringBuffer.append(",PROGRAM");
        }
        if ((n & 4) == 4) {
            stringBuffer.append(",RAMS");
        } else {
            stringBuffer.append(",BANK0");
        }
        if ((n & 2) == 2) {
            stringBuffer.append(",VPPON");
        }
        if ((n & 1) == 1) {
            stringBuffer.append(",LCDON");
        }
        return stringBuffer.toString();
    }

    public static String blinkIntInfo() {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = Z88.getInstance().getBlink().getInt() & 0xFF;
        stringBuffer.append("INT (B1h) = " + Dz.byteToBin(n, true) + " : ");
        if ((n & 0x80) == 128) {
            stringBuffer.append("KWAIT");
        }
        if ((n & 0x40) == 64) {
            stringBuffer.append(",A19");
        }
        if ((n & 0x20) == 32) {
            stringBuffer.append(",FLAP");
        }
        if ((n & 0x10) == 16) {
            stringBuffer.append(",UART");
        }
        if ((n & 8) == 8) {
            stringBuffer.append(",BTL");
        }
        if ((n & 4) == 4) {
            stringBuffer.append(",KEY");
        }
        if ((n & 2) == 2) {
            stringBuffer.append(",TIME");
        }
        if ((n & 1) == 1) {
            stringBuffer.append(",GINT");
        }
        return stringBuffer.toString();
    }

    public static String blinkStaInfo() {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = Z88.getInstance().getBlink().getSta() & 0xFF;
        stringBuffer.append("STA (B1h) = " + Dz.byteToBin(n, true) + " : ");
        if ((n & 0x80) == 128) {
            stringBuffer.append("FLAPOPEN");
        }
        if ((n & 0x40) == 64) {
            stringBuffer.append(",A19");
        }
        if ((n & 0x20) == 32) {
            stringBuffer.append(",FLAP");
        }
        if ((n & 0x10) == 16) {
            stringBuffer.append(",UART");
        }
        if ((n & 8) == 8) {
            stringBuffer.append(",BTL");
        }
        if ((n & 4) == 4) {
            stringBuffer.append(",KEY");
        }
        if ((n & 1) == 1) {
            stringBuffer.append(",TIME");
        }
        return stringBuffer.toString();
    }

    public static String blinkTstaInfo() {
        int n = Z88.getInstance().getBlink().getTsta() & 0xFF;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("TSTA (B5h) = " + Dz.byteToBin(n, true) + " : ");
        if ((n & 4) == 4) {
            stringBuffer.append("MIN");
        }
        if ((n & 2) == 2) {
            stringBuffer.append(",SEC");
        }
        if ((n & 1) == 1) {
            stringBuffer.append(",TICK");
        }
        return stringBuffer.toString();
    }

    public static String blinkTmkInfo() {
        int n = Z88.getInstance().getBlink().getTmk() & 0xFF;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("TMK (B5h) = " + Dz.byteToBin(n, true) + " : ");
        if ((n & 4) == 4) {
            stringBuffer.append("MIN");
        }
        if ((n & 2) == 2) {
            stringBuffer.append(",SEC");
        }
        if ((n & 1) == 1) {
            stringBuffer.append(",TICK");
        }
        return stringBuffer.toString();
    }

    public static String blinkScreenInfo() {
        Blink blink = Z88.getInstance().getBlink();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SBR (Screen file): ");
        stringBuffer.append(Dz.addrToHex(blink.getSbr(), true));
        stringBuffer.append(" (" + Dz.extAddrToHex(blink.getSbrAddress(), true) + ")\n");
        stringBuffer.append("PB0 (LORES0): ");
        stringBuffer.append(Dz.addrToHex(blink.getPb0(), true));
        stringBuffer.append(" (" + Dz.extAddrToHex(blink.getPb0Address(), true) + "), ");
        stringBuffer.append("PB1 (LORES1): ");
        stringBuffer.append(Dz.addrToHex(blink.getPb1(), true));
        stringBuffer.append(" (" + Dz.extAddrToHex(blink.getPb1Address(), true) + ")\n");
        stringBuffer.append("PB2 (HIRES0): ");
        stringBuffer.append(Dz.addrToHex(blink.getPb2(), true));
        stringBuffer.append(" (" + Dz.extAddrToHex(blink.getPb2Address(), true) + "), ");
        stringBuffer.append("PB3 (HIRES1): ");
        stringBuffer.append(Dz.addrToHex(blink.getPb3(), true));
        stringBuffer.append(" (" + Dz.extAddrToHex(blink.getPb3Address(), true) + ")");
        return stringBuffer.toString();
    }

    public static String blinkSegmentsInfo() {
        StringBuffer stringBuffer = new StringBuffer(128);
        Blink blink = Z88.getInstance().getBlink();
        stringBuffer.append("SR0: " + Dz.byteToHex(blink.getSegmentBank(0), true) + ", ");
        stringBuffer.append("SR1: " + Dz.byteToHex(blink.getSegmentBank(1), true) + ", ");
        stringBuffer.append("SR2: " + Dz.byteToHex(blink.getSegmentBank(2), true) + ", ");
        stringBuffer.append("SR3: " + Dz.byteToHex(blink.getSegmentBank(3), true));
        return stringBuffer.toString();
    }
}

