/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.datastructures;

import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.Z88;

public class ApplicationDor {
    private Memory memory;
    private int thisApp;
    private int nextApp;
    private char keyLetter;
    private int ramSize;
    private int unsafeWorkspace;
    private int safeWorkspace;
    private int entryPoint;
    private int segment0Bank;
    private int segment1Bank;
    private int segment2Bank;
    private int segment3Bank;
    private int appType1;
    private int appType2;
    private int topics;
    private int commands;
    private int help;
    private int tokens;
    private String appName;

    public ApplicationDor(int n) {
        this.thisApp = n;
        int n2 = n >> 16;
        int n3 = n2 & 0xC0;
        int n4 = n & 0xFFFF;
        this.memory = Z88.getInstance().getMemory();
        this.nextApp = this.memory.getByte((n4 += 3) + 2, n2) << 16 | this.memory.getByte(n4 + 1, n2) << 8 | this.memory.getByte(n4, n2);
        if (this.nextApp != 0) {
            this.nextApp |= n3 << 16;
        }
        n4 += 12;
        this.keyLetter = (char)this.memory.getByte(n4++, n2);
        this.ramSize = this.memory.getByte(n4++, n2);
        this.unsafeWorkspace = this.memory.getByte((n4 += 2) + 1, n2) << 8 | this.memory.getByte(n4, n2);
        this.safeWorkspace = this.memory.getByte((n4 += 2) + 1, n2) << 8 | this.memory.getByte(n4, n2);
        this.entryPoint = this.memory.getByte((n4 += 2) + 1, n2) << 8 | this.memory.getByte(n4, n2);
        this.segment0Bank = this.memory.getByte(n4 += 2, n2) != 0 ? n3 | this.memory.getByte(n4, n2) : 0;
        this.segment1Bank = this.memory.getByte(++n4, n2) != 0 ? n3 | this.memory.getByte(n4, n2) : 0;
        this.segment2Bank = this.memory.getByte(++n4, n2) != 0 ? n3 | this.memory.getByte(n4, n2) : 0;
        this.segment3Bank = this.memory.getByte(++n4, n2) != 0 ? n3 | this.memory.getByte(n4, n2) : 0;
        switch ((this.entryPoint & 0xC000) >> 14) {
            case 0: {
                this.entryPoint |= (this.segment0Bank & 0xFF) << 16;
                break;
            }
            case 1: {
                this.entryPoint |= (this.segment1Bank & 0xFF) << 16;
                break;
            }
            case 2: {
                this.entryPoint |= (this.segment2Bank & 0xFF) << 16;
                break;
            }
            case 3: {
                this.entryPoint |= (this.segment3Bank & 0xFF) << 16;
                break;
            }
        }
        int n5 = ++n4;
        this.appType1 = this.memory.getByte(n5, n2);
        int n6 = ++n4;
        ++n4;
        this.appType2 = this.memory.getByte(n6, n2);
        this.topics = (this.memory.getByte((n4 += 2) + 2, n2) | n3) << 16 | this.memory.getByte(n4 + 1, n2) << 8 | this.memory.getByte(n4, n2);
        this.commands = (this.memory.getByte((n4 += 3) + 2, n2) | n3) << 16 | this.memory.getByte(n4 + 1, n2) << 8 | this.memory.getByte(n4, n2);
        this.help = (this.memory.getByte((n4 += 3) + 2, n2) | n3) << 16 | this.memory.getByte(n4 + 1, n2) << 8 | this.memory.getByte(n4, n2);
        this.tokens = (this.memory.getByte((n4 += 3) + 2, n2) | n3) << 16 | this.memory.getByte(n4 + 1, n2) << 8 | this.memory.getByte(n4, n2);
        n4 += 4;
        int n7 = this.memory.getByte(n4++, n2) - 1;
        StringBuffer stringBuffer = new StringBuffer(32);
        int n8 = 0;
        while (n8 < n7) {
            stringBuffer.append((char)this.memory.getByte(n4++, n2));
            ++n8;
        }
        this.appName = stringBuffer.toString();
    }

    public String getAppName() {
        return this.appName;
    }

    public int getAppType1() {
        return this.appType1;
    }

    public int getAppType2() {
        return this.appType2;
    }

    public int getCommands() {
        return this.commands;
    }

    public int getEntryPoint() {
        return this.entryPoint;
    }

    public int getHelp() {
        return this.help;
    }

    public char getKeyLetter() {
        return this.keyLetter;
    }

    public int getNextApp() {
        return this.nextApp;
    }

    public int getRamSize() {
        return this.ramSize;
    }

    public int getSafeWorkspace() {
        return this.safeWorkspace;
    }

    public int getSegment0BankBinding() {
        return this.segment0Bank;
    }

    public int getSegment1BankBinding() {
        return this.segment1Bank;
    }

    public int getSegment2BankBinding() {
        return this.segment2Bank;
    }

    public int getSegment3BankBinding() {
        return this.segment3Bank;
    }

    public int getTokens() {
        return this.tokens;
    }

    public int getTopics() {
        return this.topics;
    }

    public int getUnsafeWorkspace() {
        return this.unsafeWorkspace;
    }

    public int getThisApp() {
        return this.thisApp;
    }
}

