/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.filecard;

import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.Z88;

public class FileEntry {
    private Memory memory = Z88.getInstance().getMemory();
    private String fileName;
    private int fileLength;
    private int hdrLength;
    private boolean deleted;
    private int fileEntryPtr;
    private int fileImagePtr;

    public FileEntry(int n) {
        this.fileEntryPtr = n;
        int n2 = this.memory.getByte(n);
        n = this.memory.getNextExtAddress(n);
        ++this.hdrLength;
        if (this.memory.getByte(n) == 0) {
            --n2;
            n = this.memory.getNextExtAddress(n);
            ++this.hdrLength;
            this.deleted = true;
        } else {
            this.deleted = false;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append((char)this.memory.getByte(n));
            n = this.memory.getNextExtAddress(n);
            ++this.hdrLength;
            ++n3;
        }
        this.fileName = stringBuffer.toString();
        this.fileLength = this.memory.getByte(n);
        n = this.memory.getNextExtAddress(n);
        this.fileLength |= this.memory.getByte(n) << 8;
        n = this.memory.getNextExtAddress(n);
        this.fileLength |= this.memory.getByte(n) << 16;
        n = this.memory.getNextExtAddress(n);
        this.fileLength |= this.memory.getByte(n) << 24;
        n = this.memory.getNextExtAddress(n);
        this.hdrLength += 4;
        this.fileImagePtr = n;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int getFileLength() {
        return this.fileLength;
    }

    public byte[] getFileImage() {
        int n = this.getFileLength();
        int n2 = this.fileImagePtr;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)this.memory.getByte(n2);
            n2 = this.memory.getNextExtAddress(n2);
            ++n3;
        }
        return byArray;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getHdrLength() {
        return this.hdrLength;
    }

    public int getFileImagePtr() {
        return this.fileImagePtr;
    }

    public int getFileEntryPtr() {
        return this.fileEntryPtr;
    }
}

