/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.screen;

import com.jira.cambridgez88.ozvm.screen.DirectGif89Frame;
import com.jira.cambridgez88.ozvm.screen.Gif89Frame;
import com.jira.cambridgez88.ozvm.screen.GifColorTable;
import com.jira.cambridgez88.ozvm.screen.IndexGif89Frame;
import com.jira.cambridgez88.ozvm.screen.Put;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class Gif89Encoder {
    private Dimension dispDim = new Dimension(0, 0);
    private GifColorTable colorTable;
    private int bgIndex;
    private int loopCount = 1;
    private String theComments;
    private Vector vFrames = new Vector();
    private boolean gifHdrWritten;

    public Gif89Encoder() {
        this.colorTable = new GifColorTable();
    }

    public Gif89Encoder(Image image) throws IOException {
        this();
        this.addFrame(image);
    }

    public Gif89Encoder(Color[] colorArray) {
        this.colorTable = new GifColorTable(colorArray);
    }

    public Gif89Encoder(Color[] colorArray, int n, int n2, byte[] byArray) throws IOException {
        this(colorArray);
        this.addFrame(n, n2, byArray);
    }

    public int getFrameCount() {
        return this.vFrames.size();
    }

    public Gif89Frame getFrameAt(int n) {
        return this.isOk(n) ? (Gif89Frame)this.vFrames.elementAt(n) : null;
    }

    public void addFrame(Gif89Frame gif89Frame) throws IOException {
        this.accommodateFrame(gif89Frame);
        this.vFrames.addElement(gif89Frame);
    }

    public void addFrame(Image image) throws IOException {
        this.addFrame(new DirectGif89Frame(image));
    }

    public void addFrame(int n, int n2, byte[] byArray) throws IOException {
        this.addFrame(new IndexGif89Frame(n, n2, byArray));
    }

    public void insertFrame(int n, Gif89Frame gif89Frame) throws IOException {
        this.accommodateFrame(gif89Frame);
        this.vFrames.insertElementAt(gif89Frame, n);
    }

    public void setTransparentIndex(int n) {
        this.colorTable.setTransparent(n);
    }

    public void setLogicalDisplay(Dimension dimension, int n) {
        this.dispDim = new Dimension(dimension);
        this.bgIndex = n;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    public void setComments(String string) {
        this.theComments = string;
    }

    public void setUniformDelay(int n) {
        int n2 = 0;
        while (n2 < this.vFrames.size()) {
            ((Gif89Frame)this.vFrames.elementAt(n2)).setDelay(n);
            ++n2;
        }
    }

    public void encodeFrame(OutputStream outputStream, Gif89Frame gif89Frame) throws IOException {
        if (this.getFrameCount() < 1) {
            this.addFrame(gif89Frame);
        } else {
            if (!this.gifHdrWritten) {
                int n = this.getFrameCount();
                boolean bl = n > 1;
                this.colorTable.closePixelProcessing();
                Put.ascii("GIF89a", outputStream);
                this.writeLogicalScreenDescriptor(outputStream);
                this.colorTable.encode(outputStream);
                if (bl && this.loopCount != 1) {
                    this.writeNetscapeExtension(outputStream);
                }
                if (this.theComments != null && this.theComments.length() > 0) {
                    this.writeCommentExtension(outputStream);
                }
                int n2 = 0;
                while (n2 < n) {
                    ((Gif89Frame)this.vFrames.elementAt(n2)).encode(outputStream, bl, this.colorTable.getDepth(), this.colorTable.getTransparent());
                    ++n2;
                }
                this.gifHdrWritten = true;
            }
            this.accommodateFrame(gif89Frame);
            gif89Frame.encode(outputStream, true, this.colorTable.getDepth(), this.colorTable.getTransparent());
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n = this.getFrameCount();
        boolean bl = n > 1;
        this.colorTable.closePixelProcessing();
        Put.ascii("GIF89a", outputStream);
        this.writeLogicalScreenDescriptor(outputStream);
        this.colorTable.encode(outputStream);
        if (bl && this.loopCount != 1) {
            this.writeNetscapeExtension(outputStream);
        }
        if (this.theComments != null && this.theComments.length() > 0) {
            this.writeCommentExtension(outputStream);
        }
        int n2 = 0;
        while (n2 < n) {
            ((Gif89Frame)this.vFrames.elementAt(n2)).encode(outputStream, bl, this.colorTable.getDepth(), this.colorTable.getTransparent());
            ++n2;
        }
        outputStream.write(59);
        outputStream.flush();
    }

    private void accommodateFrame(Gif89Frame gif89Frame) throws IOException {
        this.dispDim.width = Math.max(this.dispDim.width, gif89Frame.getWidth());
        this.dispDim.height = Math.max(this.dispDim.height, gif89Frame.getHeight());
        this.colorTable.processPixels(gif89Frame);
    }

    private void writeLogicalScreenDescriptor(OutputStream outputStream) throws IOException {
        Put.leShort(this.dispDim.width, outputStream);
        Put.leShort(this.dispDim.height, outputStream);
        outputStream.write(0xF0 | this.colorTable.getDepth() - 1);
        outputStream.write(this.bgIndex);
        outputStream.write(0);
    }

    private void writeNetscapeExtension(OutputStream outputStream) throws IOException {
        outputStream.write(33);
        outputStream.write(255);
        outputStream.write(11);
        Put.ascii("NETSCAPE2.0", outputStream);
        outputStream.write(3);
        outputStream.write(1);
        Put.leShort(this.loopCount > 1 ? this.loopCount - 1 : 0, outputStream);
        outputStream.write(0);
    }

    private void writeCommentExtension(OutputStream outputStream) throws IOException {
        outputStream.write(33);
        outputStream.write(254);
        int n = this.theComments.length() % 255;
        int n2 = this.theComments.length() / 255;
        int n3 = n2 + (n > 0 ? 1 : 0);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n5 < n2 ? 255 : n;
            outputStream.write(n6);
            Put.ascii(this.theComments.substring(n4, n4 + n6), outputStream);
            n4 += n6;
            ++n5;
        }
        outputStream.write(0);
    }

    private boolean isOk(int n) {
        return n >= 0 && n < this.vFrames.size();
    }
}

