/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88Keyboard;
import java.util.Timer;
import java.util.TimerTask;

public final class Blink {
    private volatile boolean snooze = false;
    private boolean coma;
    private Memory memory = null;
    private Z80Processor z80 = null;
    private Z88Keyboard keyboard = null;
    private final Timer rtcTimer;
    private final Rtc rtc;
    private int INT;
    public static final int BM_INTKWAIT = 128;
    public static final int BM_INTA19 = 64;
    public static final int BM_INTFLAP = 32;
    public static final int BM_INTUART = 16;
    public static final int BM_INTBTL = 8;
    public static final int BM_INTKEY = 4;
    public static final int BM_INTTIME = 2;
    public static final int BM_INTGINT = 1;
    private int STA;
    public static final int BM_STAFLAPOPEN = 128;
    public static final int BM_STAA19 = 64;
    public static final int BM_STAFLAP = 32;
    public static final int BM_STAUART = 16;
    public static final int BM_STABTL = 8;
    public static final int BM_STAKEY = 4;
    public static final int BM_STATIME = 1;
    public static final int BM_TSTAMIN = 4;
    public static final int BM_TSTASEC = 2;
    public static final int BM_TSTATICK = 1;
    public static final int BM_TMKMIN = 4;
    public static final int BM_TMKSEC = 2;
    public static final int BM_TMKTICK = 1;
    public static final int BM_TACKMIN = 4;
    public static final int BM_TACKSEC = 2;
    public static final int BM_TACKTICK = 1;
    private int PB0;
    private int PB1;
    private int PB2;
    private int PB3;
    private int SBR;
    private Bank RAMS;
    private int[] sR = new int[4];
    private int COM;
    public static final int BM_COMSRUN = 128;
    public static final int BM_COMSBIT = 64;
    public static final int BM_COMOVERP = 32;
    public static final int BM_COMRESTIM = 16;
    public static final int BM_COMPROGRAM = 8;
    public static final int BM_COMRAMS = 4;
    public static final int BM_COMVPPON = 2;
    public static final int BM_COMLCDON = 1;
    private int EPR;
    public static final int BM_EPRPD1 = 128;
    public static final int BM_EPRPD0 = 64;
    public static final int BM_EPRPGMD = 32;
    public static final int BM_EPREOED = 16;
    public static final int BM_EPRSE3D = 8;
    public static final int BM_EPRPGMP = 4;
    public static final int BM_EPREOEP = 2;
    public static final int BM_EPRSE3P = 1;

    public Blink() {
        this.rtcTimer = new Timer(true);
        this.rtc = new Rtc();
        this.resetBlinkRegisters();
    }

    public void connectProcessor(Z80Processor z80Processor) {
        this.z80 = z80Processor;
    }

    public void connectMemory(Memory memory) {
        this.memory = memory;
        this.RAMS = this.memory.getBank(0);
    }

    public void connectKeyboard(Z88Keyboard z88Keyboard) {
        this.keyboard = z88Keyboard;
    }

    public void resetBlinkRegisters() {
        this.SBR = 0;
        this.PB3 = 0;
        this.PB2 = 0;
        this.PB1 = 0;
        this.PB0 = 0;
        this.STA = 0;
        this.INT = 0;
        this.COM = 0;
        this.rtc.TSTA = 0;
        this.rtc.TMK = 0;
        this.rtc.reset();
        int n = 0;
        while (n < this.sR.length) {
            this.sR[n] = 0;
            ++n;
        }
    }

    public void setInt(int n) {
        this.INT = n;
    }

    public int getInt() {
        return this.INT;
    }

    public void setAck(int n) {
        this.STA &= ~(n & 0xFF);
    }

    public int getSta() {
        return this.STA;
    }

    public void setSta(int n) {
        this.STA = n;
    }

    public int getTsta() {
        return this.rtc.TSTA;
    }

    public void setTsta(int n) {
        this.rtc.TSTA = n;
    }

    public void setTack(int n) {
        Rtc rtc = this.rtc;
        rtc.TSTA = rtc.TSTA & ~(n & 0xFF);
        if (this.rtc.TSTA == 0) {
            this.STA &= 0xFFFFFFFE;
        }
    }

    public void setTmk(int n) {
        this.rtc.TMK = n;
    }

    public int getTmk() {
        return this.rtc.TMK;
    }

    public int getTim0() {
        return this.rtc.TIM0;
    }

    public void setTim0(int n) {
        this.rtc.TIM0 = n;
    }

    public int getTim1() {
        return this.rtc.TIM1;
    }

    public void setTim1(int n) {
        this.rtc.TIM1 = n;
    }

    public int getTim2() {
        return this.rtc.TIM2;
    }

    public void setTim2(int n) {
        this.rtc.TIM2 = n;
    }

    public int getTim3() {
        return this.rtc.TIM3;
    }

    public void setTim3(int n) {
        this.rtc.TIM3 = n;
    }

    public int getTim4() {
        return this.rtc.TIM4;
    }

    public void setTim4(int n) {
        this.rtc.TIM4 = n;
    }

    public void setPb0(int n) {
        this.PB0 = n;
    }

    public int getPb0() {
        return this.PB0;
    }

    public int getPb0Address() {
        int n = this.PB0 << 3 & 0xF700;
        int n2 = this.PB0 << 1 & 0x3F;
        return (n | n2) << 8;
    }

    public void setPb1(int n) {
        this.PB1 = n;
    }

    public int getPb1() {
        return this.PB1;
    }

    public int getPb1Address() {
        int n = this.PB1 << 6 & 0xFF00;
        int n2 = this.PB1 << 4 & 0x30;
        return (n | n2) << 8;
    }

    public void setPb2(int n) {
        this.PB2 = n;
    }

    public int getPb2() {
        return this.PB2;
    }

    public int getPb2Address() {
        int n = this.PB2 << 7 & 0xFF00;
        int n2 = this.PB2 << 5 & 0x20;
        return (n | n2) << 8;
    }

    public void setPb3(int n) {
        this.PB3 = n;
    }

    public int getPb3() {
        return this.PB3;
    }

    public int getPb3Address() {
        int n = this.PB3 << 5 & 0xFF00;
        int n2 = this.PB3 << 3 & 0x38;
        return (n | n2) << 8;
    }

    public void setSbr(int n) {
        this.SBR = n;
    }

    public int getSbr() {
        return this.SBR;
    }

    public int getSbrAddress() {
        int n = this.SBR << 5 & 0xFF00;
        int n2 = this.SBR << 3 & 0x38;
        return (n | n2) << 8;
    }

    public synchronized void signalKeyPressed() {
        if ((this.INT & 4) == 4 & (this.STA & 4) == 0) {
            this.STA |= 4;
        }
        this.awakeZ80();
    }

    public synchronized int getKbd(int n) {
        if ((this.INT & 0x80) == 128) {
            try {
                this.enableSnooze();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.keyboard.scanKeyRow(n);
    }

    public int getSegmentBank(int n) {
        return this.sR[n & 3];
    }

    public void setSegmentBank(int n, int n2) {
        this.sR[n & 3] = n2;
    }

    public int decodeLocalAddress(int n) {
        int n2;
        if (n > 16383) {
            n2 = this.sR[(n & 0xFFFF) >>> 14];
        } else if (n < 8192) {
            n2 = (this.COM & 4) == 4 ? 32 : 0;
        } else {
            n2 = this.sR[0] & 0xFE;
            if ((this.sR[0] & 1) == 0) {
                n &= 0x1FFF;
            }
        }
        return n2 << 16 | n & 0x3FFF;
    }

    public int decodeExtendedAddress(int n, int n2) {
        if ((n2 &= 3) > 0) {
            return n & 0x3FFF | n2 << 14;
        }
        return n & 0x1FFF | 0x2000;
    }

    public final int readByte(int n) {
        try {
            if (n > 16383) {
                return this.memory.getBank(this.sR[n >>> 14]).readByte(n & 0x3FFF);
            }
            if (n < 8192) {
                return this.RAMS.readByte(n);
            }
            if ((this.sR[0] & 1) == 0) {
                return this.memory.getBank(this.sR[0] & 0xFE).readByte(n & 0x1FFF);
            }
            return this.memory.getBank(this.sR[0] & 0xFE).readByte(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public final boolean isBreakpoint(int n) {
        try {
            if (n > 16383) {
                return this.memory.getBank(this.sR[n >>> 14]).isBreakpoint(n & 0x3FFF);
            }
            if (n < 8192) {
                return this.RAMS.isBreakpoint(n);
            }
            if ((this.sR[0] & 1) == 0) {
                return this.memory.getBank(this.sR[0] & 0xFE).isBreakpoint(n & 0x1FFF);
            }
            return this.memory.getBank(this.sR[0] & 0xFE).isBreakpoint(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public final boolean isReadWatchpoint(int n) {
        try {
            if (n > 16383) {
                return this.memory.getBank(this.sR[n >>> 14]).isReadWatchpoint(n & 0x3FFF);
            }
            if (n < 8192) {
                return this.RAMS.isReadWatchpoint(n);
            }
            if ((this.sR[0] & 1) == 0) {
                return this.memory.getBank(this.sR[0] & 0xFE).isReadWatchpoint(n & 0x1FFF);
            }
            return this.memory.getBank(this.sR[0] & 0xFE).isReadWatchpoint(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public final boolean isWriteWatchpoint(int n) {
        try {
            if (n > 16383) {
                return this.memory.getBank(this.sR[n >>> 14]).isWriteWatchpoint(n & 0x3FFF);
            }
            if (n < 8192) {
                return this.RAMS.isWriteWatchpoint(n);
            }
            if ((this.sR[0] & 1) == 0) {
                return this.memory.getBank(this.sR[0] & 0xFE).isWriteWatchpoint(n & 0x1FFF);
            }
            return this.memory.getBank(this.sR[0] & 0xFE).isWriteWatchpoint(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public final void writeByte(int n, int n2) {
        try {
            if (n > 16383) {
                this.memory.getBank(this.sR[n >>> 14]).writeByte(n & 0x3FFF, n2);
            } else if (n < 8192) {
                this.RAMS.writeByte(n, n2);
            } else {
                Bank bank = this.memory.getBank(this.sR[0] & 0xFE);
                if ((this.sR[0] & 1) == 0) {
                    bank.writeByte(n & 0x1FFF, n2);
                } else {
                    bank.writeByte(n, n2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    private void adjustLostTime() {
        long l = 0L;
        l += (long)(this.getTim0() * 5);
        l += (long)(this.getTim1() * 1000);
        l += (long)(this.getTim2() * 60 * 1000);
        l += (long)(this.getTim3() * 256 * 60 * 1000);
        l += (long)(this.getTim4() * 65536 * 60 * 1000);
        this.setTim4((int)((l += System.currentTimeMillis() - this.z80.getZ88StoppedAtTime()) / 65536L / 60L / 1000L) & 0xFF);
        this.setTim3((int)((l / 1000L / 60L - (long)(this.getTim4() * 65536)) / 256L) & 0xFF);
        this.setTim2((int)(l / 1000L / 60L - (long)(this.getTim4() * 65536) - (long)(this.getTim3() * 256)) & 0xFF);
        this.setTim1((int)(l / 1000L - (long)(this.getTim4() * 65536 * 60) - (long)(this.getTim3() * 256 * 60) - (long)(this.getTim2() * 60)) & 0xFF);
        this.setTim0((int)((l - (long)(this.getTim4() * 65536 * 60 * 1000) - (long)(this.getTim3() * 256 * 60 * 1000) - (long)(this.getTim2() * 60 * 1000) - (long)(this.getTim1() * 1000)) / 5L) & 0xFF);
    }

    public void setCom(int n) {
        this.COM = n;
        if ((this.COM & 0x10) == 16) {
            this.rtc.reset();
        }
        this.RAMS = (this.COM & 4) == 4 ? this.memory.getBank(32) : this.memory.getBank(0);
    }

    public final int getCom() {
        return this.COM;
    }

    public int getEpr() {
        return this.EPR;
    }

    public void setEpr(int n) {
        this.EPR = n;
    }

    public void startRtcInterrupts() {
        if ((this.getCom() & 0x10) == 0) {
            this.adjustLostTime();
            this.rtc.start();
        }
    }

    public void stopRtcInterrupts() {
        this.rtc.stop();
    }

    public synchronized void enableSnooze() throws InterruptedException {
        this.snooze = true;
        while (this.snooze & this.z80.isZ80running()) {
            this.wait();
        }
    }

    public synchronized void awakeZ80() {
        if (this.snooze) {
            this.snooze = false;
            this.notifyAll();
        }
    }

    public Bank getRAMS() {
        return this.RAMS;
    }

    public void setRAMS(Bank bank) {
        this.RAMS = bank;
    }

    public void signalBattLow() {
        this.STA |= 8;
        this.awakeZ80();
    }

    public void signalFlapOpened() {
        if ((this.INT & 0x20) == 32 & (this.INT & 1) == 1) {
            this.STA |= 0xA0;
            this.awakeZ80();
        }
    }

    public void signalNmi() {
    }

    public void signalFlapClosed() {
        this.STA &= 0xFFFFFF7F;
        this.awakeZ80();
    }

    public boolean isFlapOpen() {
        return (this.STA & 0x80) == 128;
    }

    public final class Rtc {
        private TimerTask countRtc;
        private int TIM0;
        private int TIM1;
        private int TIM2;
        private int TIM3;
        private int TIM4;
        private int TSTA = 0;
        private int TMK = 7;
        private boolean rtcRunning = false;

        private Rtc() {
        }

        public void stop() {
            if (this.countRtc != null) {
                this.countRtc.cancel();
            }
            this.rtcRunning = false;
        }

        public void start() {
            if (!this.rtcRunning) {
                this.rtcRunning = true;
                this.countRtc = new Counter();
                Blink.this.rtcTimer.scheduleAtFixedRate(this.countRtc, 0L, 5L);
            }
        }

        public void reset() {
            this.TIM0 = 152;
            this.TIM4 = 0;
            this.TIM3 = 0;
            this.TIM2 = 0;
            this.TIM1 = 0;
        }

        public boolean isRunning() {
            return this.rtcRunning;
        }

        private final class Counter
        extends TimerTask {
            private Counter() {
            }

            @Override
            public void run() {
                if ((Blink.this.getCom() & 0x10) == 16) {
                    Blink.this.rtc.reset();
                    return;
                }
                if (!Blink.this.z80.isZ80ThreadRunning()) {
                    return;
                }
                if ((Blink.this.STA & 0x80) == 0 & (Rtc.this.TMK & 1) == 1 & (Rtc.this.TSTA & 1) == 0 & (Blink.this.INT & 2) == 2) {
                    Rtc rtc = Rtc.this;
                    rtc.TSTA = rtc.TSTA | 1;
                }
                if (Rtc.this.TIM0 > 199) {
                    Rtc.this.TIM0 = 0;
                } else {
                    Rtc rtc = Rtc.this;
                    int n = rtc.TIM0;
                    rtc.TIM0 = n + 1;
                    if (n == 128) {
                        Rtc rtc2 = Rtc.this;
                        rtc2.TIM1 = rtc2.TIM1 + 1;
                        if ((Blink.this.STA & 0x80) == 0 & (Rtc.this.TMK & 2) == 2 & (Rtc.this.TSTA & 2) == 0 & (Blink.this.INT & 2) == 2) {
                            Rtc rtc3 = Rtc.this;
                            rtc3.TSTA = rtc3.TSTA | 2;
                        }
                    }
                }
                if (Rtc.this.TIM1 > 59) {
                    Rtc.this.TIM1 = 0;
                    if ((Blink.this.STA & 0x80) == 0 & (Rtc.this.TMK & 4) == 4 & (Rtc.this.TSTA & 4) == 0 & (Blink.this.INT & 2) == 2) {
                        Rtc rtc = Rtc.this;
                        rtc.TSTA = rtc.TSTA | 4;
                    }
                    Rtc rtc = Rtc.this;
                    int n = rtc.TIM2 + 1;
                    rtc.TIM2 = n;
                    if (n > 255) {
                        Rtc.this.TIM2 = 0;
                        Rtc rtc4 = Rtc.this;
                        int n2 = rtc4.TIM3 + 1;
                        rtc4.TIM3 = n2;
                        if (n2 > 255) {
                            Rtc.this.TIM3 = 0;
                            Rtc rtc5 = Rtc.this;
                            int n3 = rtc5.TIM4 + 1;
                            rtc5.TIM4 = n3;
                            if (n3 > 31) {
                                Rtc.this.TIM4 = 0;
                            }
                        }
                    }
                }
                if (Rtc.this.TSTA != 0) {
                    Blink blink = Blink.this;
                    blink.STA = blink.STA | 1;
                    if ((Blink.this.INT & 1) == 1) {
                        Blink.this.awakeZ80();
                    }
                }
            }
        }
    }
}

