/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.Z80Processor;
import com.jira.cambridgez88.ozvm.Z88;

public class Dz {
    private static final char[] hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] mainStrMnem = new String[]{"NOP", "LD   BC,{0}", "LD   (BC),A", "INC  BC", "INC  B", "DEC  B", "LD   B,{0}", "RLCA", "EX   AF,AF'", "ADD  HL,BC", "LD   A,(BC)", "DEC  BC", "INC  C", "DEC  C", "LD   C,{0}", "RRCA", "DJNZ {0}", "LD   DE,{0}", "LD   (DE),A", "INC  DE", "INC  D", "DEC  D", "LD   D,{0}", "RLA", "JR   {0}", "ADD  HL,DE", "LD   A,(DE)", "DEC  DE", "INC  E", "DEC  E", "LD   E,{0}", "RRA", "JR   NZ,{0}", "LD   HL,{0}", "LD   ({0}),HL", "INC  HL", "INC  H", "DEC  H", "LD   H,{0}", "DAA", "JR   Z,{0}", "ADD  HL,HL", "LD   HL,({0})", "DEC  HL", "INC  L", "DEC  L", "LD   L,{0}", "CPL", "JR   NC,{0}", "LD   SP,{0}", "LD   ({0}),A", "INC  SP", "INC  (HL)", "DEC  (HL)", "LD   (HL),{0}", "SCF", "JR   C,{0}", "ADD  HL,SP", "LD   A,({0})", "DEC  SP", "INC  A", "DEC  A", "LD   A,{0}", "CCF", "LD   B,B", "LD   B,C", "LD   B,D", "LD   B,E", "LD   B,H", "LD   B,L", "LD   B,(HL)", "LD   B,A", "LD   C,B", "LD   C,C", "LD   C,D", "LD   C,E", "LD   C,H", "LD   C,L", "LD   C,(HL)", "LD   C,A", "LD   D,B", "LD   D,C", "LD   D,D", "LD   D,E", "LD   D,H", "LD   D,L", "LD   D,(HL)", "LD   D,A", "LD   E,B", "LD   E,C", "LD   E,D", "LD   E,E", "LD   E,H", "LD   E,L", "LD   E,(HL)", "LD   E,A", "LD   H,B", "LD   H,C", "LD   H,D", "LD   H,E", "LD   H,H", "LD   H,L", "LD   H,(HL)", "LD   H,A", "LD   L,B", "LD   L,C", "LD   L,D", "LD   L,E", "LD   L,H", "LD   L,L", "LD   L,(HL)", "LD   L,A", "LD   (HL),B", "LD   (HL),C", "LD   (HL),D", "LD   (HL),E", "LD   (HL),H", "LD   (HL),L", "HALT", "LD   (HL),A", "LD   A,B", "LD   A,C", "LD   A,D", "LD   A,E", "LD   A,H", "LD   A,L", "LD   A,(HL)", "LD   A,A", "ADD  A,B", "ADD  A,C", "ADD  A,D", "ADD  A,E", "ADD  A,H", "ADD  A,L", "ADD  A,(HL)", "ADD  A,A", "ADC  A,B", "ADC  A,C", "ADC  A,D", "ADC  A,E", "ADC  A,H", "ADC  A,L", "ADC  A,(HL)", "ADC  A,A", "SUB  B", "SUB  C", "SUB  D", "SUB  E", "SUB  H", "SUB  L", "SUB  (HL)", "SUB  A", "SBC  A,B", "SBC  A,C", "SBC  A,D", "SBC  A,E", "SBC  A,H", "SBC  A,L", "SBC  A,(HL)", "SBC  A,A", "AND  B", "AND  C", "AND  D", "AND  E", "AND  H", "AND  L", "AND  (HL)", "AND  A", "XOR  B", "XOR  C", "XOR  D", "XOR  E", "XOR  H", "XOR  L", "XOR  (HL)", "XOR  A", "OR   B", "OR   C", "OR   D", "OR   E", "OR   H", "OR   L", "OR   (HL)", "OR   A", "CP   B", "CP   C", "CP   D", "CP   E", "CP   H", "CP   L", "CP   (HL)", "CP   A", "RET  NZ", "POP  BC", "JP   NZ,{0}", "JP   {0}", "CALL NZ,{0}", "PUSH BC", "ADD  A,{0}", "RST  00h", "RET  Z", "RET", "JP   Z,{0}", "", "CALL Z,{0}", "CALL {0}", "ADC  A,{0}", "RST  08h", "RET  NC", "POP  DE", "JP   NC,{0}", "OUT  ({0}),A", "CALL NC,{0}", "PUSH DE", "SUB  {0}", "RST  10h", "RET  C", "EXX", "JP   C,{0}", "IN   A,({0})", "CALL C,{0}", "", "SBC  A,{0}", "RST  18h", "RET  PO", "POP  HL", "JP   PO,{0}", "EX   (SP),HL", "CALL PO,{0}", "PUSH HL", "AND  {0}", "RST  20h", "RET  PE", "JP   (HL)", "JP   PE,{0}", "EX   DE,HL", "CALL PE,{0}", "", "XOR  {0}", "EXTCALL {0},{1}", "RET  P", "POP  AF", "JP   P,{0}", "DI", "CALL P,{0}", "PUSH AF", "OR   {0}", "OZ   MPB", "RET  M", "LD   SP,HL", "JP   M,{0}", "EI", "CALL M,{0}", "", "CP   {0}", "RST  38h"};
    private static final int[] mainArgsMnem;
    private static final String[] cbStrMnem;
    private static final String[] ddcbStrMnem;
    private static final int[] ddcbArgsMnem;
    private static final String[] fdcbStrMnem;
    private static final int[] fdcbArgsMnem;
    private static final String[] ddStrMnem;
    private static final int[] ddArgsMnem;
    private static final String[] fdStrMnem;
    private static final int[] fdArgsMnem;
    private static final String[] edStrMnem;
    private static final int[] edArgsMnem;
    private static final String[] ozdcStrMnem;
    private static final String[] ozos1StrMnem;
    private static final String[] ozos2StrMnem;
    private static final String[] ozgnStrMnem;
    private static final String[] ozfppStrMnem;

    static {
        int[] nArray = new int[256];
        nArray[1] = 2;
        nArray[6] = 1;
        nArray[14] = 1;
        nArray[16] = -1;
        nArray[17] = 2;
        nArray[22] = 1;
        nArray[24] = -1;
        nArray[30] = 1;
        nArray[32] = -1;
        nArray[33] = 2;
        nArray[34] = 2;
        nArray[38] = 1;
        nArray[40] = -1;
        nArray[42] = 2;
        nArray[46] = 1;
        nArray[48] = -1;
        nArray[49] = 2;
        nArray[50] = 2;
        nArray[54] = 1;
        nArray[56] = -1;
        nArray[58] = 2;
        nArray[62] = 1;
        nArray[194] = 2;
        nArray[195] = 2;
        nArray[196] = 2;
        nArray[198] = 1;
        nArray[202] = 2;
        nArray[204] = 2;
        nArray[205] = 2;
        nArray[206] = 1;
        nArray[210] = 2;
        nArray[211] = 1;
        nArray[212] = 2;
        nArray[214] = 1;
        nArray[218] = 2;
        nArray[219] = 1;
        nArray[220] = 2;
        nArray[222] = 1;
        nArray[226] = 2;
        nArray[228] = 2;
        nArray[230] = 1;
        nArray[234] = 2;
        nArray[236] = 2;
        nArray[238] = 1;
        nArray[239] = 4;
        nArray[242] = 2;
        nArray[244] = 2;
        nArray[246] = 1;
        nArray[250] = 2;
        nArray[252] = 2;
        nArray[254] = 1;
        mainArgsMnem = nArray;
        cbStrMnem = new String[]{"RLC  B", "RLC  C", "RLC  D", "RLC  E", "RLC  H", "RLC  L", "RLC  (HL)", "RLC  A", "RRC  B", "RRC  C", "RRC  D", "RRC  E", "RRC  H", "RRC  L", "RRC  (HL)", "RRC  A", "RL   B", "RL   C", "RL   D", "RL   E", "RL   H", "RL   L", "RL   (HL)", "RL   A", "RR   B", "RR   C", "RR   D", "RR   E", "RR   H", "RR   L", "RR   (HL)", "RR   A", "SLA  B", "SLA  C", "SLA  D", "SLA  E", "SLA  H", "SLA  L", "SLA  (HL)", "SLA  A", "SRA  B", "SRA  C", "SRA  D", "SRA  E", "SRA  H", "SRA  L", "SRA  (HL)", "SRA  A", "SLL  B", "SLL  C", "SLL  D", "SLL  E", "SLL  H", "SLL  L", "SLL  (HL)", "SLL  A", "SRL  B", "SRL  C", "SRL  D", "SRL  E", "SRL  H", "SRL  L", "SRL  (HL)", "SRL  A", "BIT  0,B", "BIT  0,C", "BIT  0,D", "BIT  0,E", "BIT  0,H", "BIT  0,L", "BIT  0,(HL)", "BIT  0,A", "BIT  1,B", "BIT  1,C", "BIT  1,D", "BIT  1,E", "BIT  1,H", "BIT  1,L", "BIT  1,(HL)", "BIT  1,A", "BIT  2,B", "BIT  2,C", "BIT  2,D", "BIT  2,E", "BIT  2,H", "BIT  2,L", "BIT  2,(HL)", "BIT  2,A", "BIT  3,B", "BIT  3,C", "BIT  3,D", "BIT  3,E", "BIT  3,H", "BIT  3,L", "BIT  3,(HL)", "BIT  3,A", "BIT  4,B", "BIT  4,C", "BIT  4,D", "BIT  4,E", "BIT  4,H", "BIT  4,L", "BIT  4,(HL)", "BIT  4,A", "BIT  5,B", "BIT  5,C", "BIT  5,D", "BIT  5,E", "BIT  5,H", "BIT  5,L", "BIT  5,(HL)", "BIT  5,A", "BIT  6,B", "BIT  6,C", "BIT  6,D", "BIT  6,E", "BIT  6,H", "BIT  6,L", "BIT  6,(HL)", "BIT  6,A", "BIT  7,B", "BIT  7,C", "BIT  7,D", "BIT  7,E", "BIT  7,H", "BIT  7,L", "BIT  7,(HL)", "BIT  7,A", "RES  0,B", "RES  0,C", "RES  0,D", "RES  0,E", "RES  0,H", "RES  0,L", "RES  0,(HL)", "RES  0,A", "RES  1,B", "RES  1,C", "RES  1,D", "RES  1,E", "RES  1,H", "RES  1,L", "RES  1,(HL)", "RES  1,A", "RES  2,B", "RES  2,C", "RES  2,D", "RES  2,E", "RES  2,H", "RES  2,L", "RES  2,(HL)", "RES  2,A", "RES  3,B", "RES  3,C", "RES  3,D", "RES  3,E", "RES  3,H", "RES  3,L", "RES  3,(HL)", "RES  3,A", "RES  4,B", "RES  4,C", "RES  4,D", "RES  4,E", "RES  4,H", "RES  4,L", "RES  4,(HL)", "RES  4,A", "RES  5,B", "RES  5,C", "RES  5,D", "RES  5,E", "RES  5,H", "RES  5,L", "RES  5,(HL)", "RES  5,A", "RES  6,B", "RES  6,C", "RES  6,D", "RES  6,E", "RES  6,H", "RES  6,L", "RES  6,(HL)", "RES  6,A", "RES  7,B", "RES  7,C", "RES  7,D", "RES  7,E", "RES  7,H", "RES  7,L", "RES  7,(HL)", "RES  7,A", "SET  0,B", "SET  0,C", "SET  0,D", "SET  0,E", "SET  0,H", "SET  0,L", "SET  0,(HL)", "SET  0,A", "SET  1,B", "SET  1,C", "SET  1,D", "SET  1,E", "SET  1,H", "SET  1,L", "SET  1,(HL)", "SET  1,A", "SET  2,B", "SET  2,C", "SET  2,D", "SET  2,E", "SET  2,H", "SET  2,L", "SET  2,(HL)", "SET  2,A", "SET  3,B", "SET  3,C", "SET  3,D", "SET  3,E", "SET  3,H", "SET  3,L", "SET  3,(HL)", "SET  3,A", "SET  4,B", "SET  4,C", "SET  4,D", "SET  4,E", "SET  4,H", "SET  4,L", "SET  4,(HL)", "SET  4,A", "SET  5,B", "SET  5,C", "SET  5,D", "SET  5,E", "SET  5,H", "SET  5,L", "SET  5,(HL)", "SET  5,A", "SET  6,B", "SET  6,C", "SET  6,D", "SET  6,E", "SET  6,H", "SET  6,L", "SET  6,(HL)", "SET  6,A", "SET  7,B", "SET  7,C", "SET  7,D", "SET  7,E", "SET  7,H", "SET  7,L", "SET  7,(HL)", "SET  7,A"};
        ddcbStrMnem = new String[]{"?", "?", "?", "?", "?", "?", "RLC  (IX{0})", "?", "?", "?", "?", "?", "?", "?", "RRC  (IX{0})", "?", "?", "?", "?", "?", "?", "?", "RL   (IX{0})", "?", "?", "?", "?", "?", "?", "?", "RR   (IX{0})", "?", "?", "?", "?", "?", "?", "?", "SLA  (IX{0})", "?", "?", "?", "?", "?", "?", "?", "SRA  (IX{0})", "?", "?", "?", "?", "?", "?", "?", "SLL  (IX{0})", "?", "?", "?", "?", "?", "?", "?", "SRL  (IX{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  0,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  1,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  2,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  3,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  4,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  5,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  6,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  7,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "RES  0,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "RES  1,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "RES  2,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "RES  3,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "RES  4,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "RES  5,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "RES  6,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "RES  7,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "SET  0,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "SET  1,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "SET  2,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "SET  3,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "SET  4,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "SET  5,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "SET  6,(IX{0})", "?", "?", "?", "?", "?", "?", "?", "SET  7,(IX{0})", "?"};
        int[] nArray2 = new int[256];
        nArray2[6] = -2;
        nArray2[14] = -2;
        nArray2[22] = -2;
        nArray2[30] = -2;
        nArray2[38] = -2;
        nArray2[46] = -2;
        nArray2[54] = -2;
        nArray2[62] = -2;
        nArray2[70] = -2;
        nArray2[78] = -2;
        nArray2[86] = -2;
        nArray2[94] = -2;
        nArray2[102] = -2;
        nArray2[110] = -2;
        nArray2[118] = -2;
        nArray2[126] = -2;
        nArray2[134] = -2;
        nArray2[142] = -2;
        nArray2[150] = -2;
        nArray2[158] = -2;
        nArray2[166] = -2;
        nArray2[174] = -2;
        nArray2[182] = -2;
        nArray2[190] = -2;
        nArray2[198] = -2;
        nArray2[206] = -2;
        nArray2[214] = -2;
        nArray2[222] = -2;
        nArray2[230] = -2;
        nArray2[238] = -2;
        nArray2[246] = -2;
        nArray2[254] = -2;
        ddcbArgsMnem = nArray2;
        fdcbStrMnem = new String[]{"?", "?", "?", "?", "?", "?", "RLC  (IY{0})", "?", "?", "?", "?", "?", "?", "?", "RRC  (IY{0})", "?", "?", "?", "?", "?", "?", "?", "RL   (IY{0})", "?", "?", "?", "?", "?", "?", "?", "RR   (IY{0})", "?", "?", "?", "?", "?", "?", "?", "SLA  (IY{0})", "?", "?", "?", "?", "?", "?", "?", "SRA  (IY{0})", "?", "?", "?", "?", "?", "?", "?", "SLL  (IY{0})", "?", "?", "?", "?", "?", "?", "?", "SRL  (IY{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  0,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  1,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  2,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  3,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  4,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  5,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  6,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "BIT  7,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "RES  0,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "RES  1,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "RES  2,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "RES  3,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "RES  4,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "RES  5,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "RES  6,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "RES  7,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "SET  0,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "SET  1,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "SET  2,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "SET  3,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "SET  4,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "SET  5,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "SET  6,(IY{0})", "?", "?", "?", "?", "?", "?", "?", "SET  7,(IY{0})", "?"};
        int[] nArray3 = new int[256];
        nArray3[6] = -2;
        nArray3[14] = -2;
        nArray3[22] = -2;
        nArray3[30] = -2;
        nArray3[38] = -2;
        nArray3[46] = -2;
        nArray3[54] = -2;
        nArray3[62] = -2;
        nArray3[70] = -2;
        nArray3[78] = -2;
        nArray3[86] = -2;
        nArray3[94] = -2;
        nArray3[102] = -2;
        nArray3[110] = -2;
        nArray3[118] = -2;
        nArray3[126] = -2;
        nArray3[134] = -2;
        nArray3[142] = -2;
        nArray3[150] = -2;
        nArray3[158] = -2;
        nArray3[166] = -2;
        nArray3[174] = -2;
        nArray3[182] = -2;
        nArray3[190] = -2;
        nArray3[198] = -2;
        nArray3[206] = -2;
        nArray3[214] = -2;
        nArray3[222] = -2;
        nArray3[230] = -2;
        nArray3[238] = -2;
        nArray3[246] = -2;
        nArray3[254] = -2;
        fdcbArgsMnem = nArray3;
        ddStrMnem = new String[]{"?", "?", "?", "?", "?", "?", "?", "?", "?", "ADD  IX,BC", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "ADD  IX,DE", "?", "?", "?", "?", "?", "?", "?", "LD   IX,{0}", "LD   ({0}),IX", "INC  IX", "INC  IXH", "DEC  IXH", "LD   IXH,{0}", "?", "?", "ADD  IX,IX", "LD   IX,({0})", "DEC  IX", "INC  IXL", "DEC  IXL", "LD   IXL,{0}", "?", "?", "?", "?", "?", "INC  (IX{0})", "DEC  (IX{0})", "LD   (IX{0}),{1}", "?", "?", "ADD  IX,SP", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "LD   B,IXH", "LD   B,IXL", "LD   B,(IX{0})", "?", "?", "?", "?", "?", "LD   C,IXH", "LD   C,IXL", "LD   C,(IX{0})", "?", "?", "?", "?", "?", "LD   D,IXH", "LD   D,IXL", "LD   D,(IX{0})", "?", "?", "?", "?", "?", "LD   E,IXH", "LD   E,IXL", "LD   E,(IX{0})", "?", "LD   IXH,B", "LD   IXH,C", "LD   IXH,D", "LD   IXH,E", "LD   IXH,IXH", "LD   IXH,IXL", "LD   H,(IX{0})", "LD   IXH,A", "LD   IXL,B", "LD   IXL,C", "LD   IXL,D", "LD   IXL,E", "LD   IXL,IXH", "LD   IXL,IXL", "LD   L,(IX{0})", "LD   IXL,A", "LD   (IX{0}),B", "LD   (IX{0}),C", "LD   (IX{0}),D", "LD   (IX{0}),E", "LD   (IX{0}),H", "LD   (IX{0}),L", "?", "LD   (IX{0}),A", "?", "?", "?", "?", "LD   A,IXH", "LD   A,IXL", "LD   A,(IX{0})", "?", "?", "?", "?", "?", "ADD  A,IXH", "ADD  A,IXL", "ADD  A,(IX{0})", "?", "?", "?", "?", "?", "ADC  A,IXH", "ADC  A,IXL", "ADC  A,(IX{0})", "?", "?", "?", "?", "?", "SUB  IXH", "SUB  IXL", "SUB  (IX{0})", "?", "?", "?", "?", "?", "SBC  A,IXH", "SBC  A,IXL", "SBC  A,(IX{0})", "?", "?", "?", "?", "?", "AND  IXH", "AND  IXL", "AND  (IX{0})", "?", "?", "?", "?", "?", "XOR  IXH", "XOR  IXL", "XOR  (IX{0})", "?", "?", "?", "?", "?", "OR   IXH", "OR   IXL", "OR   (IX{0})", "?", "?", "?", "?", "?", "CP   IXH", "CP   IXL", "CP   (IX{0})", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "POP  IX", "?", "EX   (SP),IX", "?", "PUSH IX", "?", "?", "?", "JP   (IX)", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "LD   SP,IX", "?", "?", "?", "?", "?", "?"};
        int[] nArray4 = new int[256];
        nArray4[33] = 2;
        nArray4[34] = 2;
        nArray4[38] = 1;
        nArray4[42] = 2;
        nArray4[46] = 1;
        nArray4[52] = -4;
        nArray4[53] = -4;
        nArray4[54] = -3;
        nArray4[70] = -4;
        nArray4[78] = -4;
        nArray4[86] = -4;
        nArray4[94] = -4;
        nArray4[102] = -4;
        nArray4[110] = -4;
        nArray4[112] = -4;
        nArray4[113] = -4;
        nArray4[114] = -4;
        nArray4[115] = -4;
        nArray4[116] = -4;
        nArray4[117] = -4;
        nArray4[119] = -4;
        nArray4[126] = -4;
        nArray4[134] = -4;
        nArray4[142] = -4;
        nArray4[150] = -4;
        nArray4[158] = -4;
        nArray4[166] = -4;
        nArray4[174] = -4;
        nArray4[182] = -4;
        nArray4[190] = -4;
        ddArgsMnem = nArray4;
        fdStrMnem = new String[]{"?", "?", "?", "?", "?", "?", "?", "?", "?", "ADD  IY,BC", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "ADD  IY,DE", "?", "?", "?", "?", "?", "?", "?", "LD   IY,{0}", "LD   ({0}),IY", "INC  IY", "INC  IYH", "DEC  IYH", "LD   IYH,{0}", "?", "?", "ADD  IY,IY", "LD   IY,({0})", "DEC  IY", "INC  IYL", "DEC  IYL", "LD   IYL,{0}", "?", "?", "?", "?", "?", "INC  (IY{0})", "DEC  (IY{0})", "LD   (IY{0}),{1}", "?", "?", "ADD  IY,SP", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "LD   B,IYH", "LD   B,IYL", "LD   B,(IY{0})", "?", "?", "?", "?", "?", "LD   C,IYH", "LD   C,IYL", "LD   C,(IY{0})", "?", "?", "?", "?", "?", "LD   D,IYH", "LD   D,IYL", "LD   D,(IY{0})", "?", "?", "?", "?", "?", "LD   E,IYH", "LD   E,IYL", "LD   E,(IY{0})", "?", "LD   IYH,B", "LD   IYH,C", "LD   IYH,D", "LD   IYH,E", "LD   IYH,IYH", "LD   IYH,IYL", "LD   H,(IY{0})", "LD   IYH,A", "LD   IYL,B", "LD   IYL,C", "LD   IYL,D", "LD   IYL,E", "LD   IYL,IYH", "LD   IYL,IYL", "LD   L,(IY{0})", "LD   IYL,A", "LD   (IY{0}),B", "LD   (IY{0}),C", "LD   (IY{0}),D", "LD   (IY{0}),E", "LD   (IY{0}),H", "LD   (IY{0}),L", "?", "LD   (IY{0}),A", "?", "?", "?", "?", "LD   A,IYH", "LD   A,IYL", "LD   A,(IY{0})", "?", "?", "?", "?", "?", "ADD  A,IYH", "ADD  A,IYL", "ADD  A,(IY{0})", "?", "?", "?", "?", "?", "ADC  A,IYH", "ADC  A,IYL", "ADC  A,(IY{0})", "?", "?", "?", "?", "?", "SUB  IYH", "SUB  IYL", "SUB  (IY{0})", "?", "?", "?", "?", "?", "SBC  A,IYH", "SBC  A,IYL", "SBC  A,(IY{0})", "?", "?", "?", "?", "?", "AND  IYH", "AND  IYL", "AND  (IY{0})", "?", "?", "?", "?", "?", "XOR  IYH", "XOR  IYL", "XOR  (IY{0})", "?", "?", "?", "?", "?", "OR   IYH", "OR   IYL", "OR   (IY{0})", "?", "?", "?", "?", "?", "CP   IYH", "CP   IYL", "CP   (IY{0})", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "POP  IY", "?", "EX   (SP),IY", "?", "PUSH IY", "?", "?", "?", "JP   (IY)", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "LD   SP,IY", "?", "?", "?", "?", "?", "?"};
        int[] nArray5 = new int[256];
        nArray5[33] = 2;
        nArray5[34] = 2;
        nArray5[38] = 1;
        nArray5[42] = 2;
        nArray5[46] = 1;
        nArray5[52] = -4;
        nArray5[53] = -4;
        nArray5[54] = -3;
        nArray5[70] = -4;
        nArray5[78] = -4;
        nArray5[86] = -4;
        nArray5[94] = -4;
        nArray5[102] = -4;
        nArray5[110] = -4;
        nArray5[112] = -4;
        nArray5[113] = -4;
        nArray5[114] = -4;
        nArray5[115] = -4;
        nArray5[116] = -4;
        nArray5[117] = -4;
        nArray5[119] = -4;
        nArray5[126] = -4;
        nArray5[134] = -4;
        nArray5[142] = -4;
        nArray5[150] = -4;
        nArray5[158] = -4;
        nArray5[166] = -4;
        nArray5[174] = -4;
        nArray5[182] = -4;
        nArray5[190] = -4;
        fdArgsMnem = nArray5;
        edStrMnem = new String[]{"?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "IN   B,(C)", "OUT  (C),B", "SBC  HL,BC", "LD   ({0}),BC", "NEG", "RETN", "IM   0", "LD   I,A", "IN   C,(C)", "OUT  (C),C", "ADC  HL,BC", "LD   BC,({0})", "?", "RETI", "?", "LD   R,A", "IN   D,(C)", "OUT  (C),D", "SBC  HL,DE", "LD   ({0}),DE", "?", "?", "IM   1", "LD   A,I", "IN   E,(C)", "OUT  (C),E", "ADC  HL,DE", "LD   DE,({0})", "?", "?", "IM   2", "LD   A,R", "IN   H,(C)", "OUT  (C),H", "SBC  HL,HL", "?", "?", "?", "?", "RRD", "IN   L,(C)", "OUT  (C),L", "ADC  HL,HL", "?", "?", "?", "?", "RLD", "IN   F,(C)", "?", "SBC  HL,SP", "LD   ({0}),SP", "?", "?", "?", "?", "IN   A,(C)", "OUT  (C),A", "ADC  HL,SP", "LD   SP,({0})", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "LDI", "CPI", "INI", "OUTI", "?", "?", "?", "?", "LDD", "CPD", "IND", "OUTD", "?", "?", "?", "?", "LDIR", "CPIR", "INIR", "OTIR", "?", "?", "?", "?", "LDDR", "CPDR", "INDR", "OTDR", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?", "?"};
        int[] nArray6 = new int[256];
        nArray6[67] = 2;
        nArray6[75] = 2;
        nArray6[83] = 2;
        nArray6[91] = 2;
        nArray6[115] = 2;
        nArray6[123] = 2;
        edArgsMnem = nArray6;
        ozdcStrMnem = new String[]{"OZ   DC_INI", "OZ   DC_BYE", "OZ   DC_ENT", "OZ   DC_NAM", "OZ   DC_IN", "OZ   DC_OUT", "OZ   DC_PRT", "OZ   DC_ICL", "OZ   DC_NQ", "OZ   DC_SP", "OZ   DC_ALT", "OZ   DC_RBD", "OZ   DC_XIN", "OZ   DC_GEN", "OZ   DC_POL", "OZ   DC_UPD", "OZ   DC_ELF", "OZ   DC_RTE", "OZ   UNKNOWN"};
        ozos1StrMnem = new String[]{"OZ   OS_BYE", "OZ   OS_PRT", "OZ   OS_OUT", "OZ   OS_IN", "OZ   OS_TIN", "OZ   OS_XIN", "OZ   OS_PUR", "OZ   OS_UGB", "OZ   OS_GB", "OZ   OS_PB", "OZ   OS_GBT", "OZ   OS_PBT", "OZ   OS_MV", "OZ   OS_FRM", "OZ   OS_FWM", "OZ   OS_MOP", "OZ   OS_MCL", "OZ   OS_MAL", "OZ   OS_MFR", "OZ   OS_MGB", "OZ   OS_MPB", "OZ   OS_BIX", "OZ   OS_BOX", "OZ   OS_NQ", "OZ   OS_SP", "OZ   OS_SR", "OZ   OS_ESC", "OZ   OS_ERC", "OZ   OS_ERH", "OZ   OS_UST", "OZ   OS_FN", "OZ   OS_WAIT", "OZ   OS_ALM", "OZ   OS_CLI", "OZ   OS_DOR", "OZ   OS_FC", "OZ   OS_SI", "OZ   OS_BOUT", "OZ   OS_POUT", "OZ   OS_HOUT", "OZ   OS_SOUT", "OZ   OS_KIN", "OZ   OS_NLN", "OZ   UNKNOWN"};
        ozos2StrMnem = new String[]{"OZ   OS_WTS", "OZ   OS_UASH", "OZ   OS_FXM", "OZ   OS_AXM", "OZ   OS_FMA", "OZ   OS_PLOZ", "OZ   OS_FEP", "OZ   OS_WTB", "OZ   OS_WRT", "OZ   OS_WSQ", "OZ   OS_ISQ", "OZ   OS_AXP", "OZ   OS_SCI", "OZ   OS_DLY", "OZ   OS_BLP", "OZ   OS_BDE", "OZ   OS_BHL", "OZ   OS_FTH", "OZ   OS_VTH", "OZ   OS_GTH", "OZ   OS_REN", "OZ   OS_DEL", "OZ   OS_CL", "OZ   OS_OP", "OZ   OS_OFF", "OZ   OS_USE", "OZ   OS_EPR", "OZ   OS_HT", "OZ   OS_MAP", "OZ   OS_EXIT", "OZ   OS_STK", "OZ   OS_ENT", "OZ   OS_POLL", "OZ   OS_DOM", "OZ   UNKNOWN"};
        ozgnStrMnem = new String[]{"OZ   GN_GDT", "OZ   GN_PDT", "OZ   GN_GTM", "OZ   GN_PTM", "OZ   GN_SDO", "OZ   GN_GDN", "OZ   GN_PDN", "OZ   GN_DIE", "OZ   GN_DEI", "OZ   GN_GMD", "OZ   GN_GMT", "OZ   GN_PMD", "OZ   GN_PMT", "OZ   GN_MSC", "OZ   GN_FLO", "OZ   GN_FLC", "OZ   GN_FLW", "OZ   GN_FLR", "OZ   GN_FLF", "OZ   GN_FPB", "OZ   GN_NLN", "OZ   GN_CLS", "OZ   GN_SKC", "OZ   GN_SKD", "OZ   GN_SKT", "OZ   GN_SIP", "OZ   GN_SOP", "OZ   GN_SOE", "OZ   GN_RBE", "OZ   GN_WBE", "OZ   GN_CME", "OZ   GN_XNX", "OZ   GN_XIN", "OZ   GN_XDL", "OZ   GN_ERR", "OZ   GN_ESP", "OZ   GN_FCM", "OZ   GN_FEX", "OZ   GN_OPW", "OZ   GN_WCL", "OZ   GN_WFN", "OZ   GN_PRS", "OZ   GN_PFS", "OZ   GN_WSM", "OZ   GN_ESA", "OZ   GN_OPF", "OZ   GN_CL", "OZ   GN_DEL", "OZ   GN_REN", "OZ   GN_AAB", "OZ   GN_FAB", "OZ   GN_LAB", "OZ   GN_UAB", "OZ   GN_ALP", "OZ   GN_M16", "OZ   GN_D16", "OZ   GN_M24", "OZ   GN_D24", "OZ   GN_WIN", "OZ   GN_CRC", "OZ   GN_GAB", "OZ   GN_LDM", "OZ   GN_ELF", "OZ   UNKNOWN"};
        ozfppStrMnem = new String[]{"FPP  FP_AND", "FPP  FP_IDV", "FPP  FP_EOR", "FPP  FP_MOD", "FPP  FP_OR", "FPP  FP_LEQ", "FPP  FP_NEQ", "FPP  FP_GEQ", "FPP  FP_LT", "FPP  FP_EQ", "FPP  FP_MUL", "FPP  FP_ADD", "FPP  FP_GT", "FPP  FP_SUB", "FPP  FP_PWR", "FPP  FP_DIV", "FPP  FP_ABS", "FPP  FP_ACS", "FPP  FP_ASN", "FPP  FP_ATN", "FPP  FP_COS", "FPP  FP_DEG", "FPP  FP_EXP", "FPP  FP_INT", "FPP  FP_LN", "FPP  FP_LOG", "FPP  FP_NOT", "FPP  FP_RAD", "FPP  FP_SGN", "FPP  FP_SIN", "FPP  FP_SQR", "FPP  FP_TAN", "FPP  FP_ZER", "FPP  FP_ONE", "FPP  FP_TRU", "FPP  FP_PI", "FPP  FP_VAL", "FPP  FP_STR", "FPP  FP_FIX", "FPP  FP_FLT", "FPP  FP_TST", "FPP  FP_CMP", "FPP  FP_NEG", "FPP  FP_BAS", "FPP  UNKNOWN"};
    }

    public static Dz getInstance() {
        return singletonContainer.singleton;
    }

    private Dz() {
    }

    public static final String byteToHex(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(3);
        stringBuffer.append(hexcodes[(n & 0xFF) / 16]).append(hexcodes[(n & 0xFF) % 16]);
        if (bl) {
            stringBuffer.append('h');
        }
        return stringBuffer.toString();
    }

    public static final String byteToBin(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(9);
        int n2 = 7;
        while (n2 >= 0) {
            if ((n & 1 << n2) == 0) {
                stringBuffer.append("0");
            } else {
                stringBuffer.append("1");
            }
            --n2;
        }
        if (bl) {
            stringBuffer.append('b');
        }
        return stringBuffer.toString();
    }

    public static final String addrToHex(int n, boolean bl) {
        int n2 = n >>> 8 & 0xFF;
        int n3 = n & 0xFF;
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(hexcodes[n2 / 16]).append(hexcodes[n2 % 16]);
        stringBuffer.append(hexcodes[n3 / 16]).append(hexcodes[n3 % 16]);
        if (bl) {
            stringBuffer.append('h');
        }
        return stringBuffer.toString();
    }

    public static final String extAddrToHex(int n, boolean bl) {
        int n2 = n >>> 16 & 0xFF;
        int n3 = n >>> 8 & 0xFF;
        int n4 = n & 0xFF;
        StringBuffer stringBuffer = new StringBuffer(7);
        stringBuffer.append(hexcodes[n2 / 16]).append(hexcodes[n2 % 16]);
        stringBuffer.append(hexcodes[n3 / 16]).append(hexcodes[n3 % 16]);
        stringBuffer.append(hexcodes[n4 / 16]).append(hexcodes[n4 % 16]);
        if (bl) {
            stringBuffer.append('h');
        }
        return stringBuffer.toString();
    }

    public final int getInstrAscii(StringBuffer stringBuffer, int n, int n2, int n3, boolean bl, boolean bl2) {
        Dz.dzInstrAscii(stringBuffer, n, this.getInstrOpcode(n2, n3), bl, bl2);
        return this.getNextInstrAddress(n2, n3);
    }

    public final int getInstrAscii(StringBuffer stringBuffer, int n, boolean bl, boolean bl2) {
        n += Dz.dzInstrAscii(stringBuffer, n, this.getInstrOpcode(n), bl, bl2);
        return n;
    }

    public static final int dzInstrAscii(StringBuffer stringBuffer, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = 0;
        String[] stringArray = null;
        int[] nArray = null;
        stringBuffer.setLength(64);
        stringBuffer.delete(0, 63);
        stringBuffer.setCharAt(0, ' ');
        int[] nArray2 = new int[5];
        int n5 = 0;
        while (n5 < 5) {
            nArray2[n5] = n2 & 0xFF;
            n2 >>>= 8;
            ++n5;
        }
        int n6 = nArray2[n4++];
        block0 : switch (n6) {
            case 203: {
                stringArray = cbStrMnem;
                nArray = null;
                n6 = nArray2[n4++];
                break;
            }
            case 237: {
                stringArray = edStrMnem;
                nArray = edArgsMnem;
                n6 = nArray2[n4++];
                break;
            }
            case 221: {
                n6 = nArray2[n4];
                if (n6 == 203) {
                    stringArray = ddcbStrMnem;
                    nArray = ddcbArgsMnem;
                    n6 = nArray2[n4 + 2];
                } else {
                    stringArray = ddStrMnem;
                    nArray = ddArgsMnem;
                }
                ++n4;
                break;
            }
            case 253: {
                n6 = nArray2[n4];
                if (n6 == 203) {
                    stringArray = fdcbStrMnem;
                    nArray = fdcbArgsMnem;
                    n6 = nArray2[n4 + 2];
                } else {
                    stringArray = fdStrMnem;
                    nArray = fdArgsMnem;
                }
                ++n4;
                break;
            }
            case 223: {
                n6 = nArray2[n4++];
                stringArray = ozfppStrMnem;
                if (n6 % 3 == 0 && n6 >= 33 && n6 <= 162) {
                    n6 = n6 / 3 - 11;
                    break;
                }
                n6 = stringArray.length - 1;
                break;
            }
            case 231: {
                n6 = nArray2[n4++];
                switch (n6) {
                    case 6: {
                        stringArray = ozos2StrMnem;
                        n6 = nArray2[n4++];
                        if (n6 % 2 == 0 && n6 >= 188 && n6 <= 254) {
                            n6 = n6 / 2 - 95;
                            break block0;
                        }
                        n6 = stringArray.length - 1;
                        break block0;
                    }
                    case 9: {
                        stringArray = ozgnStrMnem;
                        n6 = nArray2[n4++];
                        if (n6 % 2 == 0 && n6 >= 6 && n6 <= 130) {
                            n6 = n6 / 2 - 3;
                            break block0;
                        }
                        n6 = stringArray.length - 1;
                        break block0;
                    }
                    case 12: {
                        stringArray = ozdcStrMnem;
                        n6 = nArray2[n4++];
                        if (n6 % 2 == 0 && n6 >= 6 && n6 <= 40) {
                            n6 = n6 / 2 - 3;
                            break block0;
                        }
                        n6 = stringArray.length - 1;
                        break block0;
                    }
                }
                stringArray = ozos1StrMnem;
                if (n6 % 3 == 0 && n6 >= 33 && n6 <= 159) {
                    n6 = n6 / 3 - 11;
                    break;
                }
                n6 = stringArray.length - 1;
                break;
            }
            default: {
                stringArray = mainStrMnem;
                nArray = mainArgsMnem;
            }
        }
        stringBuffer.append(stringArray[n6]);
        if (nArray != null) {
            n5 = stringBuffer.indexOf("{0}");
            switch (nArray[n6]) {
                case 4: {
                    n3 = nArray2[n4];
                    int n7 = nArray2[n4 + 2];
                    stringBuffer.replace(n5, n5 + 3, Dz.addrToHex(n3 += 256 * nArray2[n4 + 1], true));
                    int n8 = stringBuffer.indexOf("{1}");
                    stringBuffer.replace(n8, n8 + 3, Dz.byteToHex(n7, true));
                    n4 += 4;
                    break;
                }
                case 3: {
                    n3 = nArray2[n4];
                    int n7 = nArray2[n4 + 2];
                    stringBuffer.replace(n5, n5 + 3, Dz.addrToHex(n3 += 256 * nArray2[n4 + 1], true));
                    int n8 = stringBuffer.indexOf("{1}");
                    stringBuffer.replace(n8, n8 + 3, Dz.byteToHex(n7, true));
                    n4 += 3;
                    break;
                }
                case 2: {
                    n3 = nArray2[n4];
                    stringBuffer.replace(n5, n5 + 3, Dz.addrToHex(n3 += 256 * nArray2[n4 + 1], true));
                    n4 += 2;
                    break;
                }
                case 1: {
                    stringBuffer.replace(n5, n5 + 3, Dz.byteToHex(nArray2[n4], true));
                    ++n4;
                    break;
                }
                case 0: {
                    break;
                }
                case -1: {
                    byte by = (byte)nArray2[n4];
                    int n9 = n + 2 + by & 0xFFFF;
                    stringBuffer.replace(n5, n5 + 3, Dz.addrToHex(n9, true));
                    ++n4;
                    break;
                }
                case -2: {
                    byte by = (byte)nArray2[n4];
                    if (by >= 0) {
                        stringBuffer.replace(n5, n5 + 3, "+" + Integer.toString(by));
                    } else {
                        stringBuffer.replace(n5, n5 + 3, Integer.toString(by));
                    }
                    n4 += 2;
                    break;
                }
                case -3: {
                    byte by = (byte)nArray2[n4++];
                    if (by >= 0) {
                        stringBuffer.replace(n5, n5 + 3, "+" + Integer.toString(by));
                    } else {
                        stringBuffer.replace(n5, n5 + 3, Integer.toString(by));
                    }
                    int n10 = stringBuffer.indexOf("{1}");
                    stringBuffer.replace(n10, n10 + 3, Dz.byteToHex(nArray2[n4++], true));
                    break;
                }
                case -4: {
                    byte by = (byte)nArray2[n4++];
                    if (by >= 0) {
                        stringBuffer.replace(n5, n5 + 3, "+" + Integer.toString(by));
                        break;
                    }
                    stringBuffer.replace(n5, n5 + 3, Integer.toString(by));
                }
            }
        }
        if (bl) {
            stringBuffer.insert(0, String.valueOf(Dz.addrToHex(n, false)) + " ");
        }
        if (bl2) {
            StringBuffer stringBuffer2 = new StringBuffer(24);
            n3 = 0;
            while (n3 < n4) {
                stringBuffer2.append(Dz.byteToHex(nArray2[n3], false)).append(' ');
                ++n3;
            }
            n3 = 5 - n4;
            while (n3 > 0) {
                stringBuffer2.append("   ");
                --n3;
            }
            stringBuffer.insert(0, stringBuffer2.toString());
        }
        return n4;
    }

    public final int getNextInstrAddress(int n, int n2) {
        Memory memory = Z88.getInstance().getMemory();
        if (memory.getByte(n, n2) == 231 & memory.getByte(n + 1, n2) == 147) {
            n += 2;
            while (memory.getByte(n++, n2) != 0) {
            }
        } else {
            n += Dz.calcInstrOpcodeSize(this.getInstrOpcode(n, n2));
        }
        return n;
    }

    public int getInstrOpcode(int n, int n2) {
        Memory memory = Z88.getInstance().getMemory();
        int n3 = memory.getByte((n &= 0x3FFF) + 3, n2) << 24 | memory.getByte(n + 2, n2) << 16 | memory.getByte(n + 1, n2) << 8;
        int n4 = memory.getByte(n, n2);
        return n3 | n4;
    }

    public int getInstrOpcode(int n) {
        int n2 = Z88.getInstance().getBlink().decodeLocalAddress(n);
        return this.getInstrOpcode(n2 & 0x3FFF, n2 >>> 16);
    }

    public final int getNextInstrAddress(int n) {
        int n2;
        int n3;
        int n4;
        Memory memory = Z88.getInstance().getMemory();
        if (memory.getByte(n4 = (n3 = Z88.getInstance().getBlink().decodeLocalAddress(n)) & 0x3FFF, n2 = n3 >>> 16) == 231 & memory.getByte(n4 + 1, n2) == 147) {
            n4 += 2;
            n += 3;
            while (memory.getByte(n4++, n2) != 0) {
                ++n;
            }
        } else {
            n += Dz.calcInstrOpcodeSize(this.getInstrOpcode(n4, n2));
        }
        return n;
    }

    public static String getNextStepCommand() {
        Z80Processor z80Processor = Z88.getInstance().getProcessor();
        int n = z80Processor.readByte(z80Processor.PC());
        switch (n) {
            case 220: {
                if (z80Processor.fC) {
                    return "z";
                }
                return ".";
            }
            case 212: {
                if (!z80Processor.fC) {
                    return "z";
                }
                return ".";
            }
            case 204: {
                if (z80Processor.fZ) {
                    return "z";
                }
                return ".";
            }
            case 196: {
                if (!z80Processor.fZ) {
                    return "z";
                }
                return ".";
            }
            case 244: {
                if (!z80Processor.fS) {
                    return "z";
                }
                return ".";
            }
            case 252: {
                if (z80Processor.fS) {
                    return "z";
                }
                return ".";
            }
            case 236: {
                if (z80Processor.fPV) {
                    return "z";
                }
                return ".";
            }
            case 228: {
                if (!z80Processor.fPV) {
                    return "z";
                }
                return ".";
            }
            case 199: 
            case 205: 
            case 207: 
            case 215: 
            case 223: 
            case 231: 
            case 239: 
            case 247: 
            case 255: {
                return "z";
            }
        }
        return ".";
    }

    public static int stringAddr2Integer(String string) {
        int n = Integer.parseInt(string, 16);
        n = n > 65535 ? (n &= 0xFF3FFF) : (string.length() == 6 ? (n &= 0x3FFF) : Z88.getInstance().getBlink().decodeLocalAddress(n));
        return n;
    }

    public static final int calcInstrOpcodeSize(int n) {
        int n2 = 0;
        int[] nArray = null;
        int[] nArray2 = new int[4];
        int n3 = 0;
        while (n3 < 4) {
            nArray2[n3] = n & 0xFF;
            n >>>= 8;
            ++n3;
        }
        int n4 = nArray2[n2++];
        switch (n4) {
            case 203: {
                nArray = null;
                n4 = nArray2[n2++];
                break;
            }
            case 237: {
                nArray = edArgsMnem;
                n4 = nArray2[n2++];
                break;
            }
            case 221: {
                n4 = nArray2[n2++];
                if (n4 == 203) {
                    nArray = ddcbArgsMnem;
                    n4 = nArray2[n2 + 1];
                    break;
                }
                nArray = ddArgsMnem;
                n4 = nArray2[n2 - 1];
                break;
            }
            case 253: {
                n4 = nArray2[n2++];
                if (n4 == 203) {
                    nArray = fdcbArgsMnem;
                    n4 = nArray2[n2 + 1];
                    break;
                }
                nArray = fdArgsMnem;
                n4 = nArray2[n2 - 1];
                break;
            }
            case 223: {
                return ++n2;
            }
            case 231: {
                n4 = nArray2[n2++];
                switch (n4) {
                    case 6: {
                        return ++n2;
                    }
                    case 9: {
                        return ++n2;
                    }
                    case 12: {
                        return ++n2;
                    }
                }
                return n2;
            }
            default: {
                nArray = mainArgsMnem;
            }
        }
        if (nArray != null) {
            switch (nArray[n4]) {
                case 4: {
                    n2 += 4;
                    break;
                }
                case 2: {
                    n2 += 2;
                    break;
                }
                case 1: {
                    ++n2;
                    break;
                }
                case 0: {
                    break;
                }
                case -1: {
                    ++n2;
                    break;
                }
                case -2: {
                    n2 += 2;
                    break;
                }
                case -3: {
                    n2 += 2;
                    break;
                }
                case -4: {
                    ++n2;
                }
            }
        }
        return n2;
    }

    /* synthetic */ Dz(Dz dz) {
        this();
    }

    private static final class singletonContainer {
        static final Dz singleton = new Dz(null);

        private singletonContainer() {
        }
    }
}

