/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.imagero.util.ThreadManager;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class RtmMessageGui
extends JFrame {
    private ThreadManager rtmMsgHelper;
    private Timestamp rtmMsgTime;
    private JMenuBar jJMenuBar;
    private JMenu jFileMenu;
    private JMenuItem clearRtmWindowMenuItem;
    private JTextArea jRtmOutputArea;
    private JScrollPane jRtmOutputScrollPane;
    private int totalMessages = 0;

    public RtmMessageGui() {
        this.initialize();
    }

    private void initialize() {
        this.setJMenuBar(this.getRtmMenuBar());
        this.getContentPane().add(this.getRtmOutputScrollPane());
        this.setIconImage(new ImageIcon(this.getClass().getResource("/pixel/title.gif")).getImage());
        this.setTitle("Runtime messages");
        this.setResizable(true);
        this.pack();
        this.setVisible(false);
        this.rtmMsgHelper = new ThreadManager(1);
        this.rtmMsgTime = new Timestamp(0L);
    }

    public JMenuBar getRtmMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.jFileMenu == null) {
            this.jFileMenu = new JMenu();
            this.jFileMenu.setSize(46, 24);
            this.jFileMenu.setText("File");
            this.jFileMenu.setMnemonic(70);
            this.jFileMenu.add(this.getClearRtmWindowMenuItem());
        }
        return this.jFileMenu;
    }

    public JMenuItem getClearRtmWindowMenuItem() {
        if (this.clearRtmWindowMenuItem == null) {
            this.clearRtmWindowMenuItem = new JMenuItem();
            this.clearRtmWindowMenuItem.setSelected(false);
            this.clearRtmWindowMenuItem.setText("Clear Runtime Messages");
            this.clearRtmWindowMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RtmMessageGui.this.getRtmOutputArea().setText("");
                }
            });
        }
        return this.clearRtmWindowMenuItem;
    }

    public void displayRtmMessage(final String string) {
        this.rtmMsgHelper.addTask(new Runnable(){

            @Override
            public void run() {
                RtmMessageGui.this.rtmMsgTime.setTime(System.currentTimeMillis());
                String string2 = RtmMessageGui.this.rtmMsgTime.toString();
                if (string2.length() < 23) {
                    string2 = String.valueOf(string2) + "0";
                }
                RtmMessageGui rtmMessageGui = RtmMessageGui.this;
                int n = rtmMessageGui.totalMessages;
                rtmMessageGui.totalMessages = n + 1;
                if (n > 10000) {
                    RtmMessageGui.this.totalMessages = 0;
                    RtmMessageGui.this.getRtmOutputArea().setText("");
                }
                RtmMessageGui.this.getRtmOutputArea().append("\n" + string2 + ": " + string);
                RtmMessageGui.this.getRtmOutputArea().setCaretPosition(RtmMessageGui.this.getRtmOutputArea().getDocument().getLength());
            }
        });
    }

    private JScrollPane getRtmOutputScrollPane() {
        if (this.jRtmOutputScrollPane == null) {
            this.jRtmOutputScrollPane = new JScrollPane();
            this.jRtmOutputScrollPane.setViewportView(this.getRtmOutputArea());
        }
        return this.jRtmOutputScrollPane;
    }

    private JTextArea getRtmOutputArea() {
        if (this.jRtmOutputArea == null) {
            this.jRtmOutputArea = new JTextArea(20, 110);
            this.jRtmOutputArea.setTabSize(1);
            this.jRtmOutputArea.setFont(new Font("Monospaced", 0, 11));
            this.jRtmOutputArea.setEditable(false);
        }
        return this.jRtmOutputArea;
    }
}

