/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.OZvm;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.datastructures.SlotInfo;
import com.jira.cambridgez88.ozvm.filecard.FileArea;
import com.jira.cambridgez88.ozvm.filecard.FileAreaExhaustedException;
import com.jira.cambridgez88.ozvm.filecard.FileAreaNotFoundException;
import com.jira.cambridgez88.ozvm.filecard.FileEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class Slots
extends JPanel {
    private static final String defaultAppLoadText = "Select Application or File Card Image:";
    private static final String installRomMsg = "Install new ROM in slot 0?\nWARNING: Installing a ROM will automatically perform a hard reset!";
    private static final String installRamMsg = "Install new RAM into slot 0?\nWARNING: Installing RAM will automatically perform a hard reset!";
    private static final DefaultComboBoxModel newCardTypes = new DefaultComboBoxModel<String>(new String[]{"RAM", "EPROM", "INTEL FLASH", "AMD FLASH", "AMD/RAM 512/512K", "AMIC/RAM 512/512K"});
    private static final DefaultComboBoxModel ram0Sizes = new DefaultComboBoxModel<String>(new String[]{"32K", "128K", "256K", "512K"});
    private static final DefaultComboBoxModel ramCardSizes = new DefaultComboBoxModel<String>(new String[]{"32K", "128K", "512K", "1024K"});
    private static final DefaultComboBoxModel eprSizes = new DefaultComboBoxModel<String>(new String[]{"32K", "128K", "256K"});
    private static final DefaultComboBoxModel amdFlashSizes = new DefaultComboBoxModel<String>(new String[]{"128K", "512K", "1024K"});
    private static final DefaultComboBoxModel intelFlashSizes = new DefaultComboBoxModel<String>(new String[]{"1024K"});
    private static final DefaultComboBoxModel amdHybridSizes = new DefaultComboBoxModel<String>(new String[]{"1024K"});
    private static final DefaultComboBoxModel amicHybridSizes = new DefaultComboBoxModel<String>(new String[]{"1024K"});
    private static final Font buttonFont = new Font("Sans Serif", 1, 11);
    private JLabel spaceLabel;
    private JPanel slot1Panel;
    private JPanel slot2Panel;
    private JPanel slot3Panel;
    private JPanel slot0Panel;
    private JButton ram0Button;
    private JButton rom0Button;
    private JButton slot1Button;
    private JButton slot2Button;
    private JButton slot3Button;
    private JComboBox cardSizeComboBox;
    private JLabel cardSizeLabel;
    private JComboBox cardTypeComboBox;
    private JLabel cardTypeLabel;
    private JPanel newCardPanel;
    private JButton browseAppsButton;
    private JLabel appAreaLabel;
    private JButton browseFilesButton;
    private JCheckBox fileAreaCheckBox;
    private JCheckBox saveAsBanksCheckBox;
    private JCheckBox insertCardCopyCheckBox;
    private Memory memory;
    private Blink blink;
    private EpromFileFilter eprfileFilter;
    private JFileChooser cardImageFileChooser;
    private JFileChooser fileAreaChooser;
    private Bank[][] lastRemovedCard;
    private File currentEpromDir;
    private File currentFilesDir;
    private JPanel saveAsBanksPanel;
    private JLabel saveAsBanksLabel;
    private ImageIcon emptySlotIcon;

    public Slots() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        this.blink = Z88.getInstance().getBlink();
        this.memory = Z88.getInstance().getMemory();
        this.eprfileFilter = new EpromFileFilter();
        this.currentEpromDir = fileSystemView.getHomeDirectory();
        this.currentFilesDir = fileSystemView.getHomeDirectory();
        this.lastRemovedCard = new Bank[4][];
        this.emptySlotIcon = this.getEmptySlotIcon();
        this.setLayout(new BoxLayout(this, 0));
        this.setPreferredSize(new Dimension(644, 44));
        this.add(this.getSlot0Panel());
        this.add(this.getSlot1Panel());
        this.add(this.getSlot2Panel());
        this.add(this.getSlot3Panel());
        this.setBackground(Color.BLACK);
        this.setVisible(true);
    }

    private ImageIcon getEmptySlotIcon() {
        int[] nArray = new int[2160];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -16777216;
            ++n;
        }
        BufferedImage bufferedImage = new BufferedImage(135, 16, 6);
        bufferedImage.setRGB(0, 0, 135, 16, nArray, 0, 135);
        return new ImageIcon(bufferedImage);
    }

    public void refreshSlotInfo() {
        int n = 0;
        while (n < 4) {
            this.refreshSlotInfo(n);
            ++n;
        }
    }

    public void refreshSlotInfo(int n) {
        String string = null;
        int n2 = SlotInfo.getInstance().getCardType(n &= 3);
        switch (n2) {
            case 5: {
                string = "AMD FLASH";
                break;
            }
            case 8: {
                string = "AMD/RAM";
                break;
            }
            case 9: {
                string = "AMIC/RAM";
                break;
            }
            case 3: {
                string = "EPROM";
                break;
            }
            case 4: {
                string = "INTEL FLASH";
                break;
            }
            case 2: {
                string = "RAM";
                break;
            }
            case 1: {
                string = "ROM";
            }
        }
        if (n > 0 && n2 != 0) {
            switch (n2) {
                case 8: {
                    string = "512/512K AMD/RAM";
                    break;
                }
                case 9: {
                    string = "512/512K AMIC/RAM";
                    break;
                }
                default: {
                    string = String.valueOf(this.memory.getExternalCardSize(n) * 16) + "K " + string;
                }
            }
        }
        switch (n) {
            case 0: {
                if (SlotInfo.getInstance().getCardType(n) != 1) {
                    this.getRom0Button().setText(" " + this.memory.getInternalRomSize() * 16 + "K FLASH ");
                } else {
                    this.getRom0Button().setText(" " + this.memory.getInternalRomSize() * 16 + "K ROM ");
                }
                this.getRam0Button().setText(" " + this.memory.getInternalRamSize() * 16 + "K RAM");
                break;
            }
            case 1: {
                if (n2 == 0) {
                    this.getSlot1Button().setBorder(BorderFactory.createBevelBorder(1, Color.LIGHT_GRAY, Color.DARK_GRAY));
                    this.getSlot1Button().setIcon(this.emptySlotIcon);
                    this.getSlot1Button().setText(null);
                    break;
                }
                this.getSlot1Button().setBorder(BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY));
                this.getSlot1Button().setIcon(null);
                this.getSlot1Button().setText(" " + string);
                break;
            }
            case 2: {
                if (n2 == 0) {
                    this.getSlot2Button().setBorder(BorderFactory.createBevelBorder(1, Color.LIGHT_GRAY, Color.DARK_GRAY));
                    this.getSlot2Button().setIcon(this.emptySlotIcon);
                    this.getSlot2Button().setText(null);
                    break;
                }
                this.getSlot2Button().setBorder(BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY));
                this.getSlot2Button().setIcon(null);
                this.getSlot2Button().setText(" " + string);
                break;
            }
            case 3: {
                if (n2 == 0) {
                    this.getSlot3Button().setBorder(BorderFactory.createBevelBorder(1, Color.LIGHT_GRAY, Color.DARK_GRAY));
                    this.getSlot3Button().setIcon(this.emptySlotIcon);
                    this.getSlot3Button().setText(null);
                    break;
                }
                this.getSlot3Button().setBorder(BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY));
                this.getSlot3Button().setIcon(null);
                this.getSlot3Button().setText(" " + string);
            }
        }
    }

    private JPanel getSlot0Panel() {
        if (this.slot0Panel == null) {
            this.slot0Panel = new JPanel();
            this.slot0Panel.setLayout(new BoxLayout(this.slot0Panel, 0));
            this.slot0Panel.setBackground(Color.BLACK);
            this.slot0Panel.add(this.getRom0Button());
            this.slot0Panel.add(this.getSpaceLabel());
            this.slot0Panel.add(this.getRam0Button());
            this.slot0Panel.setBorder(new TitledBorder(new EtchedBorder(Color.GRAY, Color.DARK_GRAY), "Slot 0", 3, 0, null, Color.WHITE));
        }
        return this.slot0Panel;
    }

    private JPanel getSlot1Panel() {
        if (this.slot1Panel == null) {
            this.slot1Panel = new JPanel();
            this.slot1Panel.setLayout(new BoxLayout(this.slot1Panel, 0));
            this.slot1Panel.setBackground(Color.BLACK);
            this.slot1Panel.setBorder(new TitledBorder(new EtchedBorder(Color.GRAY, Color.DARK_GRAY), "Slot 1", 3, 0, null, Color.WHITE));
            this.slot1Panel.add(this.getSlot1Button());
        }
        return this.slot1Panel;
    }

    private JPanel getSlot2Panel() {
        if (this.slot2Panel == null) {
            this.slot2Panel = new JPanel();
            this.slot2Panel.setLayout(new BoxLayout(this.slot2Panel, 0));
            this.slot2Panel.setBackground(Color.BLACK);
            this.slot2Panel.setBorder(new TitledBorder(new EtchedBorder(Color.GRAY, Color.DARK_GRAY), "Slot 2", 3, 0, null, Color.WHITE));
            this.slot2Panel.add(this.getSlot2Button());
        }
        return this.slot2Panel;
    }

    private JPanel getSlot3Panel() {
        if (this.slot3Panel == null) {
            this.slot3Panel = new JPanel();
            this.slot3Panel.setLayout(new BoxLayout(this.slot3Panel, 0));
            this.slot3Panel.setBackground(Color.BLACK);
            this.slot3Panel.setForeground(Color.WHITE);
            this.slot3Panel.setBorder(new TitledBorder(new EtchedBorder(Color.GRAY, Color.DARK_GRAY), "Slot 3", 3, 0, null, Color.WHITE));
            this.slot3Panel.add(this.getSlot3Button());
        }
        return this.slot3Panel;
    }

    private JButton getRom0Button() {
        if (this.rom0Button == null) {
            this.rom0Button = new JButton();
            this.rom0Button.setBorder(BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY));
            this.rom0Button.setMaximumSize(new Dimension(89, 20));
            this.rom0Button.setHorizontalAlignment(2);
            this.rom0Button.setFont(buttonFont);
            if (Slots.getOsName() == "windows") {
                this.rom0Button.setForeground(Color.BLACK);
                this.rom0Button.setBackground(Color.LIGHT_GRAY);
            } else {
                this.rom0Button.setForeground(Color.LIGHT_GRAY);
                this.rom0Button.setBackground(Color.BLACK);
            }
            this.rom0Button.setMargin(new Insets(2, 2, 2, 2));
            this.rom0Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Slots.this.blink.signalFlapOpened();
                    if (JOptionPane.showConfirmDialog(Slots.this, Slots.installRomMsg, "Replace OZ operating system ROM", 0) == 0) {
                        JFileChooser jFileChooser = new JFileChooser(Slots.this.currentEpromDir);
                        jFileChooser.setDialogTitle("Load/install Z88 ROM into slot 0");
                        jFileChooser.setMultiSelectionEnabled(false);
                        jFileChooser.setFileSelectionMode(0);
                        int n = jFileChooser.showOpenDialog(Slots.this);
                        if (n == 0) {
                            Slots.this.currentEpromDir = jFileChooser.getCurrentDirectory();
                            File file = new File(jFileChooser.getSelectedFile().getAbsolutePath());
                            try {
                                Slots.this.memory.loadRomBinary(file);
                                OZvm.getInstance().getGui().setWindowTitle("[" + file.getName() + "]");
                                Z88.getInstance().hardReset();
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Slots.this, "Selected file couldn't be opened!");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                JOptionPane.showMessageDialog(Slots.this, "Selected file was not a Z88 ROM!");
                            }
                        }
                    }
                    Slots.this.blink.signalFlapClosed();
                    Slots.this.refreshSlotInfo(0);
                    Z88.getInstance().getDisplay().grabFocus();
                }
            });
        }
        return this.rom0Button;
    }

    private JButton getRam0Button() {
        if (this.ram0Button == null) {
            this.ram0Button = new JButton();
            this.ram0Button.setBorder(BorderFactory.createBevelBorder(0, Color.LIGHT_GRAY, Color.DARK_GRAY));
            this.ram0Button.setMaximumSize(new Dimension(89, 20));
            this.ram0Button.setHorizontalAlignment(2);
            this.ram0Button.setFont(buttonFont);
            if (Slots.getOsName() == "windows") {
                this.ram0Button.setForeground(Color.BLACK);
                this.ram0Button.setBackground(Color.LIGHT_GRAY);
            } else {
                this.ram0Button.setForeground(Color.LIGHT_GRAY);
                this.ram0Button.setBackground(Color.BLACK);
            }
            this.ram0Button.setMargin(new Insets(2, 2, 2, 2));
            this.ram0Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Slots.this.blink.signalFlapOpened();
                    if (JOptionPane.showConfirmDialog(Slots.this, Slots.installRamMsg, "Replace internal RAM memory", 0) == 0) {
                        Slots.this.getCardSizeComboBox().setModel(ram0Sizes);
                        JOptionPane.showMessageDialog(Slots.this, Slots.this.getCardSizeComboBox(), "Select RAM size for slot 0", 1);
                        String string = (String)ram0Sizes.getElementAt(Slots.this.getCardSizeComboBox().getSelectedIndex());
                        Slots.this.memory.insertRamCard(Integer.parseInt(string.substring(0, string.indexOf("K"))), 0);
                        Z88.getInstance().hardReset();
                    }
                    Slots.this.blink.signalFlapClosed();
                    Slots.this.refreshSlotInfo(0);
                    Z88.getInstance().getDisplay().grabFocus();
                }
            });
        }
        return this.ram0Button;
    }

    private JButton getSlot1Button() {
        if (this.slot1Button == null) {
            this.slot1Button = new JButton();
            this.slot1Button.setHorizontalAlignment(2);
            this.slot1Button.setBorder(BorderFactory.createBevelBorder(1, Color.LIGHT_GRAY, Color.DARK_GRAY));
            this.slot1Button.setMaximumSize(new Dimension(139, 20));
            this.slot1Button.setFont(buttonFont);
            this.slot1Button.setMargin(new Insets(2, 2, 2, 2));
            if (Slots.getOsName() == "windows") {
                this.slot1Button.setForeground(Color.BLACK);
                this.slot1Button.setBackground(Color.LIGHT_GRAY);
            } else {
                this.slot1Button.setForeground(Color.LIGHT_GRAY);
                this.slot1Button.setBackground(Color.BLACK);
            }
            this.slot1Button.setComponentPopupMenu(new CardPopupMenu(1));
            this.slot1Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SlotInfo.getInstance().getCardType(1) == 0) {
                        Slots.this.insertCard((JButton)actionEvent.getSource(), 1);
                    } else {
                        JButton jButton = (JButton)actionEvent.getSource();
                        jButton.getComponentPopupMenu().show(jButton, 4, 4);
                    }
                }
            });
        }
        return this.slot1Button;
    }

    private JButton getSlot2Button() {
        if (this.slot2Button == null) {
            this.slot2Button = new JButton();
            this.slot2Button.setHorizontalAlignment(2);
            this.slot2Button.setBorder(BorderFactory.createBevelBorder(1, Color.LIGHT_GRAY, Color.DARK_GRAY));
            this.slot2Button.setMaximumSize(new Dimension(139, 20));
            this.slot2Button.setFont(buttonFont);
            this.slot2Button.setMargin(new Insets(2, 2, 2, 2));
            if (Slots.getOsName() == "windows") {
                this.slot2Button.setForeground(Color.BLACK);
                this.slot2Button.setBackground(Color.LIGHT_GRAY);
            } else {
                this.slot2Button.setForeground(Color.LIGHT_GRAY);
                this.slot2Button.setBackground(Color.BLACK);
            }
            this.slot2Button.setComponentPopupMenu(new CardPopupMenu(2));
            this.slot2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SlotInfo.getInstance().getCardType(2) == 0) {
                        Slots.this.insertCard((JButton)actionEvent.getSource(), 2);
                    } else {
                        JButton jButton = (JButton)actionEvent.getSource();
                        jButton.getComponentPopupMenu().show(jButton, 4, 4);
                    }
                }
            });
        }
        return this.slot2Button;
    }

    private JButton getSlot3Button() {
        if (this.slot3Button == null) {
            this.slot3Button = new JButton();
            this.slot3Button.setHorizontalAlignment(2);
            this.slot3Button.setBorder(BorderFactory.createBevelBorder(1, Color.LIGHT_GRAY, Color.DARK_GRAY));
            this.slot3Button.setMaximumSize(new Dimension(139, 20));
            this.slot3Button.setFont(buttonFont);
            this.slot3Button.setMargin(new Insets(2, 2, 2, 2));
            if (Slots.getOsName() == "windows") {
                this.slot3Button.setForeground(Color.BLACK);
                this.slot3Button.setBackground(Color.LIGHT_GRAY);
            } else {
                this.slot3Button.setForeground(Color.LIGHT_GRAY);
                this.slot3Button.setBackground(Color.BLACK);
            }
            this.slot3Button.setComponentPopupMenu(new CardPopupMenu(3));
            this.slot3Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SlotInfo.getInstance().getCardType(3) == 0) {
                        Slots.this.insertCard((JButton)actionEvent.getSource(), 3);
                    } else {
                        JButton jButton = (JButton)actionEvent.getSource();
                        jButton.getComponentPopupMenu().show(jButton, 4, 4);
                    }
                }
            });
        }
        return this.slot3Button;
    }

    private JLabel getSpaceLabel() {
        if (this.spaceLabel == null) {
            this.spaceLabel = new JLabel();
            this.spaceLabel.setText(" ");
        }
        return this.spaceLabel;
    }

    private void insertCard(JButton jButton, int n) {
        FileArea fileArea = null;
        File[] fileArray = null;
        int n2 = 0;
        this.getFileAreaCheckBox().setText("Create File Area:");
        if (n == 1) {
            this.getCardSizeComboBox().setModel(ramCardSizes);
            this.getCardTypeComboBox().setSelectedIndex(0);
            this.getCardSizeComboBox().setSelectedIndex(3);
            this.getFileAreaCheckBox().setEnabled(false);
            this.getAppAreaLabel().setEnabled(false);
            this.getBrowseFilesButton().setEnabled(false);
            this.getBrowseAppsButton().setEnabled(false);
        }
        if (n == 2) {
            this.getCardSizeComboBox().setModel(amdFlashSizes);
            this.getCardTypeComboBox().setSelectedIndex(3);
            this.getCardSizeComboBox().setSelectedIndex(2);
            this.insertCardDialogAccessibility(true);
        }
        if (n == 3) {
            this.getCardSizeComboBox().setModel(intelFlashSizes);
            this.getCardTypeComboBox().setSelectedIndex(2);
            this.getCardSizeComboBox().setSelectedIndex(0);
            this.insertCardDialogAccessibility(true);
        }
        this.getReInsertCardCopyCheckBox().setSelected(false);
        this.getFileAreaCheckBox().setSelected(false);
        this.getAppAreaLabel().setText(defaultAppLoadText);
        this.fileAreaChooser = null;
        this.cardImageFileChooser = null;
        if (this.lastRemovedCard[n] != null) {
            this.getReInsertCardCopyCheckBox().setEnabled(true);
        } else {
            this.getReInsertCardCopyCheckBox().setEnabled(false);
        }
        this.blink.signalFlapOpened();
        if (JOptionPane.showConfirmDialog(this, this.getNewCardPanel(), "Create Card to insert into slot " + n, 0) == 0) {
            String string = (String)this.getCardSizeComboBox().getModel().getElementAt(this.getCardSizeComboBox().getSelectedIndex());
            int n3 = Integer.parseInt(string.substring(0, string.indexOf("K")));
            if (this.getReInsertCardCopyCheckBox().isSelected()) {
                this.memory.insertCard(this.lastRemovedCard[n], n);
                this.lastRemovedCard[n] = null;
                OZvm.displayRtmMessage("Re-inserted previously removed Card back to slot " + n);
            } else {
                if (this.cardImageFileChooser != null) {
                    fileArray = this.cardImageFileChooser.getSelectedFiles();
                }
                switch (this.getCardTypeComboBox().getSelectedIndex()) {
                    case 0: {
                        this.memory.insertRamCard(n3, n);
                        OZvm.displayRtmMessage(String.valueOf(n3) + "K RAM Card was inserted in slot " + n);
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 4;
                        break;
                    }
                    case 3: {
                        n2 = 5;
                        break;
                    }
                    case 4: {
                        n2 = 8;
                        break;
                    }
                    case 5: {
                        n2 = 9;
                    }
                }
                if (fileArray != null) {
                    try {
                        this.memory.loadFileImagesOnCard(n, n3, n2, fileArray);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, iOException.getMessage(), "Insert Card Error", 0);
                        this.blink.signalFlapClosed();
                        Z88.getInstance().getDisplay().grabFocus();
                        return;
                    }
                } else if (n2 != 0) {
                    this.memory.insertEprCard(n, n3, n2);
                }
                if (this.getFileAreaCheckBox().isSelected()) {
                    if (SlotInfo.getInstance().getFileHeaderBank(n) != -1) {
                        if (JOptionPane.showConfirmDialog(this, "Re-format file area on card?\nWarning: All current files is lost", "File Area available on card", 1) == 0 && !FileArea.create(n, true)) {
                            JOptionPane.showMessageDialog(this, "File Area could not be re-formatted", "Card Error in slot " + n, 0);
                        }
                    } else if (!FileArea.create(n, true)) {
                        JOptionPane.showMessageDialog(this, "File Area could not be created", "Card Error in slot " + n, 0);
                    }
                    if (SlotInfo.getInstance().getFileHeaderBank(n) != -1) {
                        try {
                            fileArea = new FileArea(n);
                            if (this.fileAreaChooser != null) {
                                File[] fileArray2 = this.fileAreaChooser.getSelectedFiles();
                                int n4 = 0;
                                while (n4 < fileArray2.length) {
                                    fileArea.importHostFile(fileArray2[n4]);
                                    ++n4;
                                }
                            }
                        }
                        catch (FileAreaNotFoundException fileAreaNotFoundException) {
                            JOptionPane.showMessageDialog(this, "File Area not available in slot" + n, "Insert Card Error in slot " + n, 0);
                        }
                        catch (FileAreaExhaustedException fileAreaExhaustedException) {
                            JOptionPane.showMessageDialog(this, "File Area exhausted during import", "Insert Card Error in slot " + n, 0);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(this, "I/O error during File Area import", "Insert Card Error in slot " + n, 0);
                        }
                    }
                }
            }
            this.refreshSlotInfo(n);
        }
        this.blink.signalFlapClosed();
        Z88.getInstance().getDisplay().grabFocus();
    }

    private void removeCard(JButton jButton, int n) {
        this.blink.signalFlapOpened();
        if (SlotInfo.getInstance().getCardType(n) == 2) {
            if (JOptionPane.showConfirmDialog(this, "Remove RAM card?\nWarning: Z88 enters \"fail\" mode after removal.\nPerform a (suggested) hard reset in the 'Z88' menu.", "Remove card from slot " + n, 0) == 0) {
                this.memory.removeCard(n);
                this.lastRemovedCard[n] = null;
                this.blink.signalFlapClosed();
            }
        } else if (JOptionPane.showConfirmDialog(this, "Remove " + jButton.getText() + " card?", "Remove card from slot " + n, 0) == 0) {
            if (JOptionPane.showConfirmDialog(this, this.getSaveAsBanksPanel(), "Remove card from slot " + n, 0) == 0) {
                if (!this.getSaveAsBanksCheckBox().isSelected()) {
                    JFileChooser jFileChooser = new JFileChooser(this.currentEpromDir);
                    jFileChooser.setDialogTitle("Save Z88 Card as a single image file (*.EPR)");
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setFileFilter(this.eprfileFilter);
                    int n2 = jFileChooser.showSaveDialog(this.getParent());
                    if (n2 == 0) {
                        String string = jFileChooser.getSelectedFile().getAbsolutePath();
                        if (string.toLowerCase().lastIndexOf(".epr") == -1) {
                            string = String.valueOf(string) + ".epr";
                        }
                        try {
                            this.memory.dumpSlot(n, false, "", string);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            JOptionPane.showMessageDialog(this, "Couldn't save the card to an EPR file", "Remove Card from slot " + n, 0);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(this, "Couldn't save the card to an EPR file", "Remove Card from slot " + n, 0);
                        }
                    }
                } else {
                    JFileChooser jFileChooser = new JFileChooser(this.currentEpromDir);
                    jFileChooser.setDialogTitle("Save Z88 Card as 16 Bank files (.0 - .63)");
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileSelectionMode(0);
                    int n3 = jFileChooser.showSaveDialog(this.getParent());
                    if (n3 == 0) {
                        String string = jFileChooser.getSelectedFile().getParent();
                        try {
                            this.memory.dumpSlot(n, true, string, jFileChooser.getSelectedFile().getName());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            JOptionPane.showMessageDialog(this, "Couldn't save the card as 16k bank files", "Remove Card from slot " + n, 0);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(this, "Couldn't save the card as 16k bank files", "Remove Card from slot " + n, 0);
                        }
                    }
                }
            }
            this.lastRemovedCard[n] = this.memory.removeCard(n);
        }
        this.blink.signalFlapClosed();
        if (this.memory.isSlotEmpty(n)) {
            OZvm.displayRtmMessage(String.valueOf(jButton.getText()) + " Card was removed from slot " + n);
        }
        this.refreshSlotInfo(n);
        Z88.getInstance().getDisplay().grabFocus();
    }

    private JLabel getSaveAsBanksLabel() {
        if (this.saveAsBanksLabel == null) {
            this.saveAsBanksLabel = new JLabel();
            this.saveAsBanksLabel.setText("Dump card to filing system, before removing it?");
        }
        return this.saveAsBanksLabel;
    }

    private JPanel getSaveAsBanksPanel() {
        if (this.saveAsBanksPanel == null) {
            this.saveAsBanksPanel = new JPanel();
            this.saveAsBanksPanel.setLayout(new BoxLayout(this.saveAsBanksPanel, 1));
            this.saveAsBanksPanel.add(this.getSaveAsBanksLabel());
            this.saveAsBanksPanel.add(this.getSaveAsBanksCheckBox());
        }
        return this.saveAsBanksPanel;
    }

    private JPanel getNewCardPanel() {
        this.newCardPanel = new JPanel();
        this.newCardPanel.setLayout(new GridBagLayout());
        this.newCardPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Create Card", 0, 0, null, null));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.newCardPanel.add((Component)this.getCardTypeLabel(), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        this.newCardPanel.add((Component)this.getCardTypeComboBox(), gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 10, 0, 20);
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 2;
        this.newCardPanel.add((Component)this.getCardSizeLabel(), gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.gridx = 3;
        this.newCardPanel.add((Component)this.getCardSizeComboBox(), gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 20);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.gridx = 0;
        this.newCardPanel.add((Component)this.getAppAreaLabel(), gridBagConstraints5);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.gridx = 3;
        this.newCardPanel.add((Component)this.getBrowseAppsButton(), gridBagConstraints6);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.gridy = 2;
        gridBagConstraints7.gridx = 0;
        this.newCardPanel.add((Component)this.getFileAreaCheckBox(), gridBagConstraints7);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.gridy = 2;
        gridBagConstraints8.gridx = 3;
        this.newCardPanel.add((Component)this.getBrowseFilesButton(), gridBagConstraints8);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridwidth = 4;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.gridy = 4;
        gridBagConstraints9.gridx = 0;
        this.newCardPanel.add((Component)this.getReInsertCardCopyCheckBox(), gridBagConstraints9);
        return this.newCardPanel;
    }

    private JLabel getCardTypeLabel() {
        if (this.cardTypeLabel == null) {
            this.cardTypeLabel = new JLabel();
            this.cardTypeLabel.setText("Type:");
        }
        return this.cardTypeLabel;
    }

    private JComboBox getCardTypeComboBox() {
        if (this.cardTypeComboBox == null) {
            this.cardTypeComboBox = new JComboBox();
            this.cardTypeComboBox.setModel(newCardTypes);
            this.cardTypeComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    switch (jComboBox.getSelectedIndex()) {
                        case 0: {
                            Slots.this.getCardSizeComboBox().setModel(ramCardSizes);
                            break;
                        }
                        case 1: {
                            Slots.this.getCardSizeComboBox().setModel(eprSizes);
                            break;
                        }
                        case 2: {
                            Slots.this.getCardSizeComboBox().setModel(intelFlashSizes);
                            break;
                        }
                        case 3: {
                            Slots.this.getCardSizeComboBox().setModel(amdFlashSizes);
                            Slots.this.getCardSizeComboBox().setSelectedIndex(2);
                            break;
                        }
                        case 4: {
                            Slots.this.getCardSizeComboBox().setModel(amdHybridSizes);
                            break;
                        }
                        case 5: {
                            Slots.this.getCardSizeComboBox().setModel(amicHybridSizes);
                        }
                    }
                    if (Slots.this.getCardTypeComboBox().getSelectedIndex() == 0) {
                        Slots.this.getFileAreaCheckBox().setEnabled(false);
                        Slots.this.getAppAreaLabel().setEnabled(false);
                        Slots.this.getBrowseFilesButton().setEnabled(false);
                        Slots.this.getBrowseAppsButton().setEnabled(false);
                    } else {
                        Slots.this.getFileAreaCheckBox().setEnabled(true);
                        Slots.this.getAppAreaLabel().setEnabled(true);
                        Slots.this.getBrowseFilesButton().setEnabled(true);
                        Slots.this.getBrowseAppsButton().setEnabled(true);
                    }
                }
            });
        }
        return this.cardTypeComboBox;
    }

    private JLabel getCardSizeLabel() {
        if (this.cardSizeLabel == null) {
            this.cardSizeLabel = new JLabel();
            this.cardSizeLabel.setText("Size:");
        }
        return this.cardSizeLabel;
    }

    private JComboBox getCardSizeComboBox() {
        if (this.cardSizeComboBox == null) {
            this.cardSizeComboBox = new JComboBox();
        }
        return this.cardSizeComboBox;
    }

    private void insertCardDialogAccessibility(boolean bl) {
        this.getCardTypeLabel().setEnabled(bl);
        this.getCardTypeComboBox().setEnabled(bl);
        this.getCardSizeLabel().setEnabled(bl);
        this.getCardSizeComboBox().setEnabled(bl);
        this.getFileAreaCheckBox().setEnabled(bl);
        this.getBrowseFilesButton().setEnabled(bl);
        this.getAppAreaLabel().setEnabled(bl);
        this.getBrowseAppsButton().setEnabled(bl);
    }

    private JCheckBox getReInsertCardCopyCheckBox() {
        if (this.insertCardCopyCheckBox == null) {
            this.insertCardCopyCheckBox = new JCheckBox();
            this.insertCardCopyCheckBox.setText("Re-insert previously removed card");
            this.insertCardCopyCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (Slots.this.insertCardCopyCheckBox.isSelected()) {
                        Slots.this.insertCardDialogAccessibility(false);
                    } else {
                        Slots.this.insertCardDialogAccessibility(true);
                    }
                }
            });
        }
        return this.insertCardCopyCheckBox;
    }

    private JCheckBox getFileAreaCheckBox() {
        if (this.fileAreaCheckBox == null) {
            this.fileAreaCheckBox = new JCheckBox();
            this.fileAreaCheckBox.setText("Create File Area:");
        }
        return this.fileAreaCheckBox;
    }

    private JCheckBox getSaveAsBanksCheckBox() {
        if (this.saveAsBanksCheckBox == null) {
            this.saveAsBanksCheckBox = new JCheckBox();
            this.saveAsBanksCheckBox.setText("Save Card as 16K bank files (0-63)");
        }
        return this.saveAsBanksCheckBox;
    }

    private JButton getBrowseFilesButton() {
        if (this.browseFilesButton == null) {
            this.browseFilesButton = new JButton();
            this.browseFilesButton.setFont(buttonFont);
            this.browseFilesButton.setText("Load Files..");
            this.browseFilesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Slots.this.fileAreaChooser = new JFileChooser(Slots.this.currentFilesDir);
                    Slots.this.fileAreaChooser.setDialogTitle("Import files into Card File Area");
                    Slots.this.fileAreaChooser.setMultiSelectionEnabled(true);
                    Slots.this.fileAreaChooser.setFileSelectionMode(0);
                    int n = Slots.this.fileAreaChooser.showOpenDialog(Slots.this.getParent());
                    if (n == 0) {
                        Slots.this.getFileAreaCheckBox().setSelected(true);
                        Slots.this.currentFilesDir = Slots.this.fileAreaChooser.getCurrentDirectory();
                        File[] fileArray = Slots.this.fileAreaChooser.getSelectedFiles();
                        int n2 = 0;
                        int n3 = 0;
                        while (n3 < fileArray.length) {
                            if (fileArray[n3].isFile()) {
                                n2 = (int)((long)n2 + ((long)(1 + fileArray[n3].getName().length() + 4) + fileArray[n3].length()));
                            }
                            ++n3;
                        }
                        Slots.this.getFileAreaCheckBox().setText("Create File Area: (" + Slots.this.fileAreaChooser.getSelectedFiles().length + " files = " + n2 / 1024 + "K)");
                    } else {
                        Slots.this.getFileAreaCheckBox().setSelected(false);
                    }
                }
            });
        }
        return this.browseFilesButton;
    }

    private JLabel getAppAreaLabel() {
        if (this.appAreaLabel == null) {
            this.appAreaLabel = new JLabel();
            this.appAreaLabel.setText(defaultAppLoadText);
        }
        return this.appAreaLabel;
    }

    private JButton getBrowseAppsButton() {
        if (this.browseAppsButton == null) {
            this.browseAppsButton = new JButton();
            this.browseAppsButton.setFont(buttonFont);
            this.browseAppsButton.setText("Load Images..");
            this.browseAppsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Slots.this.cardImageFileChooser = new JFileChooser(Slots.this.currentEpromDir);
                    Slots.this.cardImageFileChooser.setDialogTitle("Load eprom and/or 16K bank file images into card");
                    Slots.this.cardImageFileChooser.setMultiSelectionEnabled(true);
                    Slots.this.cardImageFileChooser.setFileSelectionMode(0);
                    Slots.this.cardImageFileChooser.setFileFilter(Slots.this.eprfileFilter);
                    int n = Slots.this.cardImageFileChooser.showOpenDialog(Slots.this.getParent());
                    if (n == 0) {
                        Slots.this.currentEpromDir = Slots.this.cardImageFileChooser.getCurrentDirectory();
                        if (Slots.this.cardImageFileChooser.getSelectedFiles().length == 1) {
                            String string = Slots.this.cardImageFileChooser.getSelectedFile().getAbsolutePath();
                            if (string.toLowerCase().lastIndexOf(".epr") == -1) {
                                string = String.valueOf(string) + ".epr";
                            }
                            File file = new File(string);
                            Slots.this.getAppAreaLabel().setText(file.getName());
                        } else {
                            Slots.this.getAppAreaLabel().setText("Multiple file images");
                        }
                    } else {
                        Slots.this.getAppAreaLabel().setText(Slots.defaultAppLoadText);
                    }
                }
            });
        }
        return this.browseAppsButton;
    }

    private static String getOsName() {
        String string = "";
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
            string = "windows";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("linux") > -1) {
            string = "linux";
        } else if (System.getProperty("os.name").toLowerCase().indexOf("mac") > -1) {
            string = "mac";
        }
        return string;
    }

    private class CardPopupMenu
    extends JPopupMenu {
        private static final String removeCardMsg = "Remove Card";
        private static final String expFilesMsg = "Export files from File Area";
        private static final String impFilesMsg = "Import files into File Area";
        private static final String formatFileAreaMsg = "Format File Area";
        private static final String reclaimDelSpaceMsg = "Reclaim deleted space in File Area";
        private static final String markFileDeletedMsg = "Mark file(s) as deleted in File Area";
        private FileArea cardFileArea;
        private int cardSlotNo;
        private JMenuItem removeCardMenuItem;
        private JMenuItem importFilesMenuItem;
        private JMenuItem exportFilesMenuItem;
        private JMenuItem formatFileAreaMenuItem;
        private JMenuItem reclaimDelSpaceMenuItem;
        private JMenuItem markFileDeletedMenuItem;

        public CardPopupMenu(int n) {
            this.cardSlotNo = n;
            this.add(this.getRemoveCardMenuItem());
            this.add(this.getImportFilesMenuItem());
            this.add(this.getExportFilesMenuItem());
            this.add(this.getMarkFileDeletedMenuItem());
            this.add(this.getReclaimDelSpaceMenuItem());
            this.add(this.getFormatFileAreaMenuItem());
        }

        private boolean isFileAreaAvailable() {
            boolean bl = false;
            if (SlotInfo.getInstance().getFileHeaderBank(this.cardSlotNo) != -1) {
                try {
                    if (this.cardFileArea == null) {
                        this.cardFileArea = new FileArea(this.cardSlotNo);
                    } else {
                        this.cardFileArea.scanFileArea();
                    }
                }
                catch (FileAreaNotFoundException fileAreaNotFoundException) {}
                bl = true;
            }
            return bl;
        }

        private JMenuItem getRemoveCardMenuItem() {
            if (this.removeCardMenuItem == null) {
                this.removeCardMenuItem = new JMenuItem();
                this.removeCardMenuItem.setText(removeCardMsg);
                this.removeCardMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        switch (CardPopupMenu.this.cardSlotNo) {
                            case 1: {
                                Slots.this.removeCard(Slots.this.slot1Button, 1);
                                break;
                            }
                            case 2: {
                                Slots.this.removeCard(Slots.this.slot2Button, 2);
                                break;
                            }
                            case 3: {
                                Slots.this.removeCard(Slots.this.slot3Button, 3);
                            }
                        }
                    }
                });
            }
            return this.removeCardMenuItem;
        }

        private JMenuItem getExportFilesMenuItem() {
            if (this.exportFilesMenuItem == null) {
                this.exportFilesMenuItem = new JMenuItem();
                this.exportFilesMenuItem.setText(expFilesMsg);
                this.exportFilesMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        block7: {
                            try {
                                JList<String> jList = new JList<String>(CardPopupMenu.this.cardFileArea.getFileEntryNames());
                                jList.setSelectionMode(2);
                                JScrollPane jScrollPane = new JScrollPane();
                                jScrollPane.setViewportView(jList);
                                if (JOptionPane.showConfirmDialog(Slots.this, jScrollPane, "Export files from File Area in slot " + CardPopupMenu.this.cardSlotNo, 0) != 0) break block7;
                                JFileChooser jFileChooser = new JFileChooser(Slots.this.currentFilesDir);
                                jFileChooser.setDialogTitle("Export files from File Area in slot " + CardPopupMenu.this.cardSlotNo + " to filing system");
                                jFileChooser.setMultiSelectionEnabled(false);
                                jFileChooser.setFileSelectionMode(1);
                                int n = jFileChooser.showSaveDialog(Slots.this);
                                if (n != 0) break block7;
                                int n2 = 0;
                                Slots.this.currentFilesDir = jFileChooser.getSelectedFile();
                                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                                if (jList.getSelectedIndex() == -1) {
                                    n2 = jList.getModel().getSize();
                                    int n3 = 0;
                                    while (n3 < jList.getModel().getSize()) {
                                        String string2 = jList.getModel().getElementAt(n3);
                                        FileEntry fileEntry = CardPopupMenu.this.cardFileArea.getFileEntry(string2);
                                        CardPopupMenu.this.cardFileArea.exportFileEntry(fileEntry, string);
                                        ++n3;
                                    }
                                } else {
                                    int[] nArray = jList.getSelectedIndices();
                                    n2 = nArray.length;
                                    int n4 = 0;
                                    while (n4 < nArray.length) {
                                        jList.setSelectedIndex(nArray[n4]);
                                        String string3 = jList.getSelectedValue();
                                        FileEntry fileEntry = CardPopupMenu.this.cardFileArea.getFileEntry(string3);
                                        CardPopupMenu.this.cardFileArea.exportFileEntry(fileEntry, string);
                                        ++n4;
                                    }
                                }
                                JOptionPane.showMessageDialog(Slots.this, String.valueOf(n2) + " file(s) were exported to " + string, "Export files from File Area in slot " + CardPopupMenu.this.cardSlotNo, 1);
                            }
                            catch (FileAreaNotFoundException fileAreaNotFoundException) {
                            }
                            catch (IOException iOException) {
                                JOptionPane.showMessageDialog(Slots.this, iOException.getMessage(), "Export files from File Area in slot " + CardPopupMenu.this.cardSlotNo + " to filing system", 0);
                            }
                        }
                        Z88.getInstance().getDisplay().grabFocus();
                    }
                });
            }
            return this.exportFilesMenuItem;
        }

        private JMenuItem getImportFilesMenuItem() {
            if (this.importFilesMenuItem == null) {
                this.importFilesMenuItem = new JMenuItem();
                this.importFilesMenuItem.setText(impFilesMsg);
                this.importFilesMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        File[] fileArray = null;
                        try {
                            JFileChooser jFileChooser = new JFileChooser(Slots.this.currentFilesDir);
                            jFileChooser.setDialogTitle(CardPopupMenu.impFilesMsg);
                            jFileChooser.setMultiSelectionEnabled(true);
                            jFileChooser.setFileSelectionMode(0);
                            if (jFileChooser.showOpenDialog(Slots.this.getParent()) == 0) {
                                Slots.this.currentFilesDir = jFileChooser.getCurrentDirectory();
                                fileArray = jFileChooser.getSelectedFiles();
                                if (fileArray != null) {
                                    int n = 0;
                                    while (n < fileArray.length) {
                                        CardPopupMenu.this.cardFileArea.importHostFile(fileArray[n]);
                                        ++n;
                                    }
                                }
                            }
                            if (fileArray != null) {
                                JOptionPane.showMessageDialog(Slots.this, String.valueOf(fileArray.length) + " file(s) were imported", "Import files into File Area in slot " + CardPopupMenu.this.cardSlotNo, 1);
                            }
                        }
                        catch (FileAreaNotFoundException fileAreaNotFoundException) {
                        }
                        catch (FileAreaExhaustedException fileAreaExhaustedException) {
                            JOptionPane.showMessageDialog(Slots.this, "File Area exhausted during import", "Import files into File Area in slot " + CardPopupMenu.this.cardSlotNo, 0);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(Slots.this, iOException.getMessage(), "Import files into File Area in slot " + CardPopupMenu.this.cardSlotNo, 0);
                        }
                        Z88.getInstance().getDisplay().grabFocus();
                    }
                });
            }
            return this.importFilesMenuItem;
        }

        private JMenuItem getFormatFileAreaMenuItem() {
            if (this.formatFileAreaMenuItem == null) {
                this.formatFileAreaMenuItem = new JMenuItem();
                this.formatFileAreaMenuItem.setText(formatFileAreaMsg);
                this.formatFileAreaMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (JOptionPane.showConfirmDialog(Slots.this, "Format file area?\nWarning: All files will be lost.", "Format File Area in slot " + CardPopupMenu.this.cardSlotNo, 0) == 0) {
                            if (FileArea.create(CardPopupMenu.this.cardSlotNo, true)) {
                                JOptionPane.showMessageDialog(Slots.this, "File area was successfully formatted", "Format File Area in slot " + CardPopupMenu.this.cardSlotNo, 1);
                            } else {
                                JOptionPane.showMessageDialog(Slots.this, "An error occurred. File area was not formatted", "Format File Area in slot " + CardPopupMenu.this.cardSlotNo, 0);
                            }
                        }
                        Z88.getInstance().getDisplay().grabFocus();
                    }
                });
            }
            return this.formatFileAreaMenuItem;
        }

        private JMenuItem getReclaimDelSpaceMenuItem() {
            if (this.reclaimDelSpaceMenuItem == null) {
                this.reclaimDelSpaceMenuItem = new JMenuItem();
                this.reclaimDelSpaceMenuItem.setText(reclaimDelSpaceMsg);
                this.reclaimDelSpaceMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (JOptionPane.showConfirmDialog(Slots.this, "Reclaim deleted file space?", "Reclaim deleted space in File Area in slot " + CardPopupMenu.this.cardSlotNo, 0) == 0) {
                            try {
                                CardPopupMenu.this.cardFileArea.reclaimDeletedFileSpace();
                                JOptionPane.showMessageDialog(Slots.this, "Files marked as deleted were removed from File Area.", "Reclaim deleted space in File Area in slot " + CardPopupMenu.this.cardSlotNo, 1);
                            }
                            catch (FileAreaNotFoundException fileAreaNotFoundException) {}
                        }
                        Z88.getInstance().getDisplay().grabFocus();
                    }
                });
            }
            return this.reclaimDelSpaceMenuItem;
        }

        private JMenuItem getMarkFileDeletedMenuItem() {
            if (this.markFileDeletedMenuItem == null) {
                this.markFileDeletedMenuItem = new JMenuItem();
                this.markFileDeletedMenuItem.setText(markFileDeletedMsg);
                this.markFileDeletedMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            JList<String> jList = new JList<String>(CardPopupMenu.this.cardFileArea.getFileEntryNames());
                            jList.setSelectionMode(2);
                            JScrollPane jScrollPane = new JScrollPane();
                            jScrollPane.setViewportView(jList);
                            if (JOptionPane.showConfirmDialog(Slots.this, jScrollPane, "Mark file(s) as deleted in File Area in slot " + CardPopupMenu.this.cardSlotNo, 0) == 0) {
                                if (jList.getSelectedIndex() == -1) {
                                    JOptionPane.showMessageDialog(Slots.this, "No files were marked to be 'deleted'.", "Mark file(s) as deleted in File Area in slot " + CardPopupMenu.this.cardSlotNo, 1);
                                } else {
                                    int[] nArray = jList.getSelectedIndices();
                                    int n = 0;
                                    while (n < nArray.length) {
                                        jList.setSelectedIndex(nArray[n]);
                                        String string = jList.getSelectedValue();
                                        CardPopupMenu.this.cardFileArea.markAsDeleted(string);
                                        ++n;
                                    }
                                    JOptionPane.showMessageDialog(Slots.this, String.valueOf(nArray.length) + " files were marked as deleted.", "Mark file(s) as deleted in File Area in slot " + CardPopupMenu.this.cardSlotNo, 1);
                                }
                            }
                        }
                        catch (FileAreaNotFoundException fileAreaNotFoundException) {}
                        Z88.getInstance().getDisplay().grabFocus();
                    }
                });
            }
            return this.markFileDeletedMenuItem;
        }

        @Override
        public void show(Component component, int n, int n2) {
            if (SlotInfo.getInstance().getCardType(this.cardSlotNo) == 0) {
                return;
            }
            this.getImportFilesMenuItem().setEnabled(false);
            this.getExportFilesMenuItem().setEnabled(false);
            this.getMarkFileDeletedMenuItem().setEnabled(false);
            this.getReclaimDelSpaceMenuItem().setEnabled(false);
            this.getFormatFileAreaMenuItem().setEnabled(false);
            if (this.isFileAreaAvailable()) {
                this.getImportFilesMenuItem().setEnabled(true);
                this.getFormatFileAreaMenuItem().setEnabled(true);
                try {
                    if (this.cardFileArea.getActiveFileCount() > 0) {
                        this.getExportFilesMenuItem().setEnabled(true);
                        this.getMarkFileDeletedMenuItem().setEnabled(true);
                    }
                    if (this.cardFileArea.getDeletedFileCount() > 0) {
                        this.getReclaimDelSpaceMenuItem().setEnabled(true);
                    }
                }
                catch (FileAreaNotFoundException fileAreaNotFoundException) {}
            } else if (FileArea.isCreateable(this.cardSlotNo)) {
                this.getFormatFileAreaMenuItem().setEnabled(true);
            }
            super.show(component, n, n2);
        }
    }

    private class EpromFileFilter
    extends FileFilter {
        private EpromFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null) {
                if (string.equalsIgnoreCase("epr") | string.equalsIgnoreCase("bin")) {
                    return true;
                }
                try {
                    int n = Integer.parseInt(string);
                    return n >= 0 & n <= 63;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Z88 Card image files";
        }

        private String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }
}

