/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.jira.cambridgez88.ozvm.Blink;
import com.jira.cambridgez88.ozvm.Breakpoints;
import com.jira.cambridgez88.ozvm.CommandLine;
import com.jira.cambridgez88.ozvm.DebugGui;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.OZvm;
import com.jira.cambridgez88.ozvm.Watchpoints;
import com.jira.cambridgez88.ozvm.Z80;
import com.jira.cambridgez88.ozvm.Z88Info;

public class Z80Processor
extends Z80
implements Runnable {
    private Blink blink = null;
    private Breakpoints breakpoints = new Breakpoints();
    private final Watchpoints watchpoints = new Watchpoints();
    private long z88StoppedAtTime;
    private boolean z80ThreadRunning = false;
    private boolean simulateInterrupts = true;
    private boolean stopZ88 = false;

    public void connectBlink(Blink blink) {
        this.blink = blink;
    }

    public void singleStepZ80() {
        this.decode(true);
    }

    public void execZ80() {
        this.z80ThreadRunning = true;
        this.decode(false);
        this.z80ThreadRunning = false;
    }

    @Override
    public synchronized void haltZ80() {
        if (this.z80ThreadRunning) {
            try {
                this.blink.enableSnooze();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopZ80Execution() {
        this.stopZ88 = true;
    }

    public long getZ88StoppedAtTime() {
        return this.z88StoppedAtTime;
    }

    public void setZ88StoppedAtTime(long l) {
        this.z88StoppedAtTime = l;
    }

    @Override
    public boolean isZ80Stopped() {
        if (this.stopZ88) {
            this.stopZ88 = false;
            this.z88StoppedAtTime = System.currentTimeMillis();
            OZvm.displayRtmMessage("Z88 virtual machine was stopped at " + Dz.extAddrToHex(this.blink.decodeLocalAddress(this.getInstrPC()), true));
            return true;
        }
        return false;
    }

    @Override
    public int readByte(int n) {
        int n2 = this.blink.readByte(n);
        if (this.blink.isReadWatchpoint(n)) {
            this.watchPointAction(n);
        }
        return n2;
    }

    @Override
    public int pcReadByte(int n) {
        int n2 = this.blink.readByte(n);
        if (this.blink.isBreakpoint(n)) {
            this.breakPointAction();
        } else if (n2 == 231) {
            if (this.breakpoints.isBreakOzCallActive()) {
                this.ozCallBreakAction();
            }
            if (this.breakpoints.isDisplayOzCallActive()) {
                this.ozCallDisplayAction();
            }
        }
        return n2;
    }

    @Override
    public void writeByte(int n, int n2) {
        if (this.blink.isWriteWatchpoint(n)) {
            this.watchPointAction(n);
        }
        this.blink.writeByte(n, n2);
    }

    @Override
    public int readWord(int n) {
        return this.readByte(n + 1) << 8 | this.readByte(n);
    }

    @Override
    public void writeWord(int n, int n2) {
        this.writeByte(n, n2);
        this.writeByte(n + 1, n2 >>> 8);
    }

    private void breakPointAction() {
        int n = this.blink.decodeLocalAddress(this.getInstrPC());
        if (this.breakpoints.isActive(n)) {
            if (this.breakpoints.isStoppable(n)) {
                this.stopZ80Execution();
                DebugGui.getInstance().activateDebugCommandLine();
                CommandLine.getInstance().cmdlineFirstSingleStep();
                DebugGui.getInstance().lockZ88MachinePanel(true);
                if (this.breakpoints.hasCommands(n)) {
                    this.breakpoints.runCommands(n);
                }
                if (this.breakpoints.isSingleStopBreakpoint(n)) {
                    this.breakpoints.clearBreakpoint(n);
                }
            } else {
                OZvm.displayRtmMessage(Z88Info.dzPcStatus(this.getInstrPC()));
            }
        }
    }

    private void watchPointAction(int n) {
        if (this.z80ThreadRunning && this.watchpoints.isActive(n = this.blink.decodeLocalAddress(n))) {
            if (this.watchpoints.isStoppable(n)) {
                this.z80Stopped = true;
                DebugGui.getInstance().activateDebugCommandLine();
                DebugGui.getInstance().displayCmdOutput(Z88Info.dzPcStatus(this.getInstrPC()));
                DebugGui.getInstance().displayCmdOutput("Watchpoint " + Dz.extAddrToHex(n, true) + " signaled CPU stop");
                if (this.watchpoints.hasCommands(n)) {
                    this.watchpoints.runCommands(n);
                }
            } else {
                OZvm.displayRtmMessage("Watchpoint " + Dz.extAddrToHex(n, true) + ": " + Z88Info.dzPcStatus(this.getInstrPC()));
            }
        }
    }

    private void ozCallBreakAction() {
        OZvm.displayRtmMessage(Z88Info.dzPcStatus(this.getInstrPC()));
        this.stopZ80Execution();
        DebugGui.getInstance().activateDebugCommandLine();
    }

    private void ozCallDisplayAction() {
        OZvm.displayRtmMessage(Z88Info.dzPcStatus(this.getInstrPC()));
    }

    public Breakpoints getBreakpoints() {
        return this.breakpoints;
    }

    public Watchpoints getWatchpoints() {
        return this.watchpoints;
    }

    public void setBreakpoints(Breakpoints breakpoints) {
        this.breakpoints = breakpoints;
    }

    @Override
    public final void outByte(int n, int n2, int n3) {
        switch (n) {
            case 208: 
            case 209: 
            case 210: 
            case 211: {
                this.blink.setSegmentBank(n, n3);
                break;
            }
            case 176: {
                this.blink.setCom(n3);
                break;
            }
            case 177: {
                this.blink.setInt(n3);
                break;
            }
            case 179: {
                this.blink.setEpr(n3);
                break;
            }
            case 180: {
                this.blink.setTack(n3);
                break;
            }
            case 181: {
                this.blink.setTmk(n3);
                break;
            }
            case 182: {
                this.blink.setAck(n3);
                break;
            }
            case 112: {
                this.blink.setPb0(n2 << 8 | n3);
                break;
            }
            case 113: {
                this.blink.setPb1(n2 << 8 | n3);
                break;
            }
            case 114: {
                this.blink.setPb2(n2 << 8 | n3);
                break;
            }
            case 115: {
                this.blink.setPb3(n2 << 8 | n3);
                break;
            }
            case 116: {
                this.blink.setSbr(n2 << 8 | n3);
                break;
            }
            case 226: {
                break;
            }
            case 227: {
                break;
            }
            case 228: {
                break;
            }
            case 229: {
                break;
            }
            case 230: {
                break;
            }
            default: {
                OZvm.displayRtmMessage("WARNING:\n" + Z88Info.dzPcStatus(this.getInstrPC()) + "\n" + "Blink Write Register " + Dz.byteToHex(n, true) + " does not exist.");
            }
        }
    }

    @Override
    public final int inByte(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 177: {
                n3 = this.blink.getSta();
                break;
            }
            case 178: {
                n3 = this.blink.getKbd(n2);
                break;
            }
            case 181: {
                n3 = this.blink.getTsta();
                break;
            }
            case 208: {
                n3 = this.blink.getTim0();
                break;
            }
            case 209: {
                n3 = this.blink.getTim1();
                break;
            }
            case 210: {
                n3 = this.blink.getTim2();
                break;
            }
            case 211: {
                n3 = this.blink.getTim3();
                break;
            }
            case 212: {
                n3 = this.blink.getTim4();
                break;
            }
            case 224: {
                n3 = 0;
                break;
            }
            case 225: {
                n3 = 0;
                break;
            }
            case 229: {
                n3 = 0;
                break;
            }
            default: {
                OZvm.displayRtmMessage("WARNING:\n" + Z88Info.dzPcStatus(this.getInstrPC()) + "\n" + "Blink Read Register " + Dz.byteToHex(n, true) + " does not exist.");
                n3 = 0;
            }
        }
        return n3;
    }

    @Override
    public void run() {
        Breakpoints breakpoints = this.getBreakpoints();
        Thread.currentThread().setName("Z80Processor");
        if (breakpoints.isStoppable(this.blink.decodeLocalAddress(this.PC()))) {
            this.singleStepZ80();
        }
        if (this.simulateInterrupts) {
            this.blink.startRtcInterrupts();
        }
        this.execZ80();
        if (this.simulateInterrupts) {
            this.blink.stopRtcInterrupts();
        }
    }

    public boolean isZ80ThreadRunning() {
        return this.z80ThreadRunning;
    }

    public void setInterrupts(boolean bl) {
        this.simulateInterrupts = bl;
    }

    public void setOneStopBreakpoint(int n) {
        this.breakpoints.setSingleStopBreakpoint(n);
    }

    @Override
    public int getPcAddress() {
        return this.blink.decodeLocalAddress(this.PC());
    }

    @Override
    public boolean intRequest() {
        return (this.blink.getInt() & 1) == 1 & (this.blink.getInt() & this.blink.getSta()) != 0;
    }
}

