/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm;

import com.imagero.util.ThreadManager;
import com.jira.cambridgez88.ozvm.CommandLine;
import com.jira.cambridgez88.ozvm.DebugGui;
import com.jira.cambridgez88.ozvm.Dz;
import com.jira.cambridgez88.ozvm.RubberKeyboard;
import com.jira.cambridgez88.ozvm.Z88;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.im.InputContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Z88Keyboard {
    public static final int COUNTRY_US = 0;
    public static final int COUNTRY_FR = 1;
    public static final int COUNTRY_DE = 2;
    public static final int COUNTRY_UK = 3;
    public static final int COUNTRY_DK = 4;
    public static final int COUNTRY_SE = 5;
    public static final int COUNTRY_FI = 5;
    public static final int COUNTRY_IT = 6;
    public static final int COUNTRY_ES = 7;
    public static final int COUNTRY_JP = 8;
    public static final int COUNTRY_IS = 9;
    public static final int COUNTRY_NO = 10;
    public static final int COUNTRY_CH = 11;
    public static final int COUNTRY_TR = 12;
    private RubberKeyboard rubberKb;
    private ThreadManager kpHelper = new ThreadManager(1);
    Z88KeyboardListener z88Kbl;
    private int currentKbLayoutCountryCode = 3;
    private Locale hostKeyboardLocale = InputContext.getInstance().getLocale();
    private Map currentKbLayout;
    private Map[] z88Keyboards;
    private int[] keyRows = new int[8];
    private KeyPress z88RshKey;
    private KeyPress z88LshKey;
    private KeyPress z88DiamondKey;
    private KeyPress z88SquareKey;
    private KeyPress z88TabKey;
    private KeyPress z88DelKey;
    private KeyPress z88EnterKey;
    private KeyPress z88ArrowLeftKey;
    private KeyPress z88ArrowRightKey;
    private KeyPress z88ArrowUpKey;
    private KeyPress z88ArrowDownKey;
    private KeyPress z88CapslockKey;
    private KeyPress z88EscKey;
    private KeyPress z88IndexKey;
    private KeyPress z88HelpKey;
    private KeyPress z88MenuKey;
    private KeyPress z88SpaceKey;
    private KeyPress searchKey = new KeyPress(0, 0);

    public Z88Keyboard() {
        this.resetKeyboardMatrix();
        this.z88Keyboards = new HashMap[13];
        this.createSystemKeys();
        this.createKbLayouts();
        this.setKeyboardLayout(3);
    }

    public Z88KeyboardListener processKeyInput() {
        if (this.z88Kbl == null) {
            this.z88Kbl = new Z88KeyboardListener();
        }
        return this.z88Kbl;
    }

    private void createKbLayouts() {
        Map map = this.createUkLayout();
        int n = 0;
        while (n < this.z88Keyboards.length) {
            this.z88Keyboards[n] = map;
            ++n;
        }
        this.z88Keyboards[1] = this.createFrLayout();
        this.z88Keyboards[4] = this.createDkLayout();
        this.z88Keyboards[5] = this.createSeFiLayout();
        this.z88Keyboards[5] = this.z88Keyboards[5];
    }

    private void createSystemKeys() {
        this.z88RshKey = new KeyPress(16, 1919);
        this.z88LshKey = new KeyPress(16, 1727);
        this.z88SquareKey = new KeyPress(18, 1983);
        this.z88DiamondKey = new KeyPress(17, 1775);
        this.z88TabKey = new KeyPress(9, 1759);
        this.z88DelKey = new KeyPress(8, 127);
        this.z88EnterKey = new KeyPress(10, 191);
        this.z88ArrowLeftKey = new KeyPress(37, 1215);
        this.z88ArrowRightKey = new KeyPress(39, 959);
        this.z88ArrowDownKey = new KeyPress(40, 703);
        this.z88ArrowUpKey = new KeyPress(38, 447);
        this.z88CapslockKey = new KeyPress(20, 2039);
        this.z88EscKey = new KeyPress(27, 2015);
        this.z88IndexKey = new KeyPress(113, 2031);
        this.z88HelpKey = new KeyPress(112, 1663);
        this.z88MenuKey = new KeyPress(114, 1783);
        this.z88SpaceKey = new KeyPress(32, 1471);
    }

    private void mapSystemKeys(Map map) {
        map.put(this.z88TabKey, this.z88TabKey);
        map.put(this.z88DelKey, this.z88DelKey);
        map.put(this.z88EnterKey, this.z88EnterKey);
        map.put(this.z88ArrowLeftKey, this.z88ArrowLeftKey);
        map.put(new KeyPress(226, 0), this.z88ArrowLeftKey);
        map.put(this.z88ArrowRightKey, this.z88ArrowRightKey);
        map.put(new KeyPress(227, 0), this.z88ArrowRightKey);
        map.put(this.z88ArrowDownKey, this.z88ArrowDownKey);
        map.put(new KeyPress(225, 0), this.z88ArrowDownKey);
        map.put(this.z88ArrowUpKey, this.z88ArrowUpKey);
        map.put(new KeyPress(224, 0), this.z88ArrowUpKey);
        map.put(this.z88CapslockKey, this.z88CapslockKey);
        map.put(this.z88EscKey, this.z88EscKey);
        map.put(this.z88HelpKey, this.z88HelpKey);
        map.put(this.z88IndexKey, this.z88IndexKey);
        map.put(this.z88MenuKey, this.z88MenuKey);
        map.put(this.z88SpaceKey, this.z88SpaceKey);
    }

    private void addKey(Map map, int n, int n2) {
        KeyPress keyPress = new KeyPress(n, n2);
        map.put(keyPress, keyPress);
    }

    private Map createUkLayout() {
        HashMap hashMap = new HashMap();
        this.mapSystemKeys(hashMap);
        this.addKey(hashMap, 46, 2043);
        this.addKey(hashMap, 47, 2045);
        this.addKey(hashMap, 163, 2046);
        this.addKey(hashMap, 44, 1787);
        this.addKey(hashMap, 59, 1789);
        this.addKey(hashMap, 222, 1790);
        this.addKey(hashMap, 91, 1407);
        this.addKey(hashMap, 49, 1503);
        this.addKey(hashMap, 97, 1503);
        this.addKey(hashMap, 81, 1519);
        this.addKey(hashMap, 65, 1527);
        this.addKey(hashMap, 90, 1531);
        this.addKey(hashMap, 76, 1533);
        this.addKey(hashMap, 48, 1534);
        this.addKey(hashMap, 96, 1534);
        this.addKey(hashMap, 93, 1151);
        this.addKey(hashMap, 50, 1247);
        this.addKey(hashMap, 98, 1247);
        this.addKey(hashMap, 87, 1263);
        this.addKey(hashMap, 83, 1271);
        this.addKey(hashMap, 88, 1275);
        this.addKey(hashMap, 77, 1277);
        this.addKey(hashMap, 80, 1278);
        this.addKey(hashMap, 45, 895);
        this.addKey(hashMap, 51, 991);
        this.addKey(hashMap, 99, 991);
        this.addKey(hashMap, 69, 1007);
        this.addKey(hashMap, 68, 1015);
        this.addKey(hashMap, 67, 1019);
        this.addKey(hashMap, 75, 1021);
        this.addKey(hashMap, 57, 1022);
        this.addKey(hashMap, 105, 1022);
        this.addKey(hashMap, 61, 639);
        this.addKey(hashMap, 52, 735);
        this.addKey(hashMap, 100, 735);
        this.addKey(hashMap, 82, 751);
        this.addKey(hashMap, 70, 759);
        this.addKey(hashMap, 86, 763);
        this.addKey(hashMap, 74, 765);
        this.addKey(hashMap, 79, 766);
        this.addKey(hashMap, 92, 383);
        this.addKey(hashMap, 53, 479);
        this.addKey(hashMap, 101, 479);
        this.addKey(hashMap, 84, 495);
        this.addKey(hashMap, 71, 503);
        this.addKey(hashMap, 66, 507);
        this.addKey(hashMap, 85, 509);
        this.addKey(hashMap, 73, 510);
        this.addKey(hashMap, 54, 223);
        this.addKey(hashMap, 102, 223);
        this.addKey(hashMap, 89, 239);
        this.addKey(hashMap, 72, 247);
        this.addKey(hashMap, 78, 251);
        this.addKey(hashMap, 55, 253);
        this.addKey(hashMap, 103, 253);
        this.addKey(hashMap, 56, 254);
        this.addKey(hashMap, 104, 254);
        return hashMap;
    }

    private Map createUsLayout() {
        HashMap hashMap = new HashMap();
        this.mapSystemKeys(hashMap);
        this.addKey(hashMap, 46, 2043);
        this.addKey(hashMap, 47, 2045);
        this.addKey(hashMap, 44, 1787);
        this.addKey(hashMap, 59, 1789);
        this.addKey(hashMap, 222, 1790);
        this.addKey(hashMap, 91, 1407);
        this.addKey(hashMap, 49, 1503);
        this.addKey(hashMap, 97, 1503);
        this.addKey(hashMap, 81, 1519);
        this.addKey(hashMap, 65, 1527);
        this.addKey(hashMap, 90, 1531);
        this.addKey(hashMap, 76, 1533);
        this.addKey(hashMap, 48, 1534);
        this.addKey(hashMap, 96, 1534);
        this.addKey(hashMap, 93, 1151);
        this.addKey(hashMap, 50, 1247);
        this.addKey(hashMap, 98, 1247);
        this.addKey(hashMap, 87, 1263);
        this.addKey(hashMap, 83, 1271);
        this.addKey(hashMap, 88, 1275);
        this.addKey(hashMap, 77, 1277);
        this.addKey(hashMap, 80, 1278);
        this.addKey(hashMap, 45, 895);
        this.addKey(hashMap, 51, 991);
        this.addKey(hashMap, 99, 991);
        this.addKey(hashMap, 69, 1007);
        this.addKey(hashMap, 68, 1015);
        this.addKey(hashMap, 67, 1019);
        this.addKey(hashMap, 75, 1021);
        this.addKey(hashMap, 57, 1022);
        this.addKey(hashMap, 105, 1022);
        this.addKey(hashMap, 61, 639);
        this.addKey(hashMap, 52, 735);
        this.addKey(hashMap, 100, 735);
        this.addKey(hashMap, 82, 751);
        this.addKey(hashMap, 70, 759);
        this.addKey(hashMap, 86, 763);
        this.addKey(hashMap, 74, 765);
        this.addKey(hashMap, 79, 766);
        this.addKey(hashMap, 92, 383);
        this.addKey(hashMap, 53, 479);
        this.addKey(hashMap, 101, 479);
        this.addKey(hashMap, 84, 495);
        this.addKey(hashMap, 71, 503);
        this.addKey(hashMap, 66, 507);
        this.addKey(hashMap, 85, 509);
        this.addKey(hashMap, 73, 510);
        this.addKey(hashMap, 54, 223);
        this.addKey(hashMap, 102, 223);
        this.addKey(hashMap, 89, 239);
        this.addKey(hashMap, 72, 247);
        this.addKey(hashMap, 78, 251);
        this.addKey(hashMap, 55, 253);
        this.addKey(hashMap, 103, 253);
        this.addKey(hashMap, 56, 254);
        this.addKey(hashMap, 104, 254);
        return hashMap;
    }

    private Map createFrLayout() {
        HashMap hashMap = new HashMap();
        this.mapSystemKeys(hashMap);
        this.addKey(hashMap, 513, 2043);
        this.addKey(hashMap, 515, 2045);
        this.addKey(hashMap, 130, 2046);
        this.addKey(hashMap, 59, 1787);
        this.addKey(hashMap, 77, 1789);
        this.addKey(hashMap, 222, 1790);
        this.addKey(hashMap, 151, 1407);
        this.addKey(hashMap, 49, 1503);
        this.addKey(hashMap, 97, 1503);
        this.addKey(hashMap, 65, 1519);
        this.addKey(hashMap, 81, 1527);
        this.addKey(hashMap, 87, 1531);
        this.addKey(hashMap, 76, 1533);
        this.addKey(hashMap, 48, 1534);
        this.addKey(hashMap, 96, 1534);
        this.addKey(hashMap, 61, 1151);
        this.addKey(hashMap, 50, 1247);
        this.addKey(hashMap, 98, 1247);
        this.addKey(hashMap, 90, 1263);
        this.addKey(hashMap, 83, 1271);
        this.addKey(hashMap, 88, 1275);
        this.addKey(hashMap, 44, 1277);
        this.addKey(hashMap, 80, 1278);
        this.addKey(hashMap, 522, 895);
        this.addKey(hashMap, 51, 991);
        this.addKey(hashMap, 99, 991);
        this.addKey(hashMap, 69, 1007);
        this.addKey(hashMap, 68, 1015);
        this.addKey(hashMap, 67, 1019);
        this.addKey(hashMap, 75, 1021);
        this.addKey(hashMap, 57, 1022);
        this.addKey(hashMap, 105, 1022);
        this.addKey(hashMap, 45, 639);
        this.addKey(hashMap, 52, 735);
        this.addKey(hashMap, 100, 735);
        this.addKey(hashMap, 82, 751);
        this.addKey(hashMap, 70, 759);
        this.addKey(hashMap, 86, 763);
        this.addKey(hashMap, 74, 765);
        this.addKey(hashMap, 79, 766);
        this.addKey(hashMap, 153, 383);
        this.addKey(hashMap, 53, 479);
        this.addKey(hashMap, 101, 479);
        this.addKey(hashMap, 84, 495);
        this.addKey(hashMap, 71, 503);
        this.addKey(hashMap, 66, 507);
        this.addKey(hashMap, 85, 509);
        this.addKey(hashMap, 73, 510);
        this.addKey(hashMap, 54, 223);
        this.addKey(hashMap, 102, 223);
        this.addKey(hashMap, 89, 239);
        this.addKey(hashMap, 72, 247);
        this.addKey(hashMap, 78, 251);
        this.addKey(hashMap, 55, 253);
        this.addKey(hashMap, 103, 253);
        this.addKey(hashMap, 56, 254);
        this.addKey(hashMap, 104, 254);
        return hashMap;
    }

    private Map createDkLayout() {
        HashMap hashMap = new HashMap();
        this.mapSystemKeys(hashMap);
        this.addKey(hashMap, 46, 2043);
        this.addKey(hashMap, 45, 2045);
        this.addKey(hashMap, 153, 2046);
        this.addKey(hashMap, 44, 1787);
        this.addKey(hashMap, 65766, 1789);
        this.addKey(hashMap, 65734, 1789);
        this.addKey(hashMap, 65670, 1789);
        this.addKey(hashMap, 65784, 1790);
        this.addKey(hashMap, 65752, 1790);
        this.addKey(hashMap, 65688, 1790);
        this.addKey(hashMap, 65765, 1407);
        this.addKey(hashMap, 65733, 1407);
        this.addKey(hashMap, 65669, 1407);
        this.addKey(hashMap, 49, 1503);
        this.addKey(hashMap, 97, 1503);
        this.addKey(hashMap, 81, 1519);
        this.addKey(hashMap, 65, 1527);
        this.addKey(hashMap, 90, 1531);
        this.addKey(hashMap, 76, 1533);
        this.addKey(hashMap, 48, 1534);
        this.addKey(hashMap, 96, 1534);
        this.addKey(hashMap, 222, 1151);
        this.addKey(hashMap, 50, 1247);
        this.addKey(hashMap, 98, 1247);
        this.addKey(hashMap, 87, 1263);
        this.addKey(hashMap, 83, 1271);
        this.addKey(hashMap, 88, 1275);
        this.addKey(hashMap, 77, 1277);
        this.addKey(hashMap, 80, 1278);
        this.addKey(hashMap, 129, 895);
        this.addKey(hashMap, 51, 991);
        this.addKey(hashMap, 99, 991);
        this.addKey(hashMap, 69, 1007);
        this.addKey(hashMap, 68, 1015);
        this.addKey(hashMap, 67, 1019);
        this.addKey(hashMap, 75, 1021);
        this.addKey(hashMap, 57, 1022);
        this.addKey(hashMap, 105, 1022);
        this.addKey(hashMap, 521, 639);
        this.addKey(hashMap, 52, 735);
        this.addKey(hashMap, 100, 735);
        this.addKey(hashMap, 82, 751);
        this.addKey(hashMap, 70, 759);
        this.addKey(hashMap, 86, 763);
        this.addKey(hashMap, 74, 765);
        this.addKey(hashMap, 79, 766);
        this.addKey(hashMap, 135, 383);
        this.addKey(hashMap, 53, 479);
        this.addKey(hashMap, 101, 479);
        this.addKey(hashMap, 84, 495);
        this.addKey(hashMap, 71, 503);
        this.addKey(hashMap, 66, 507);
        this.addKey(hashMap, 85, 509);
        this.addKey(hashMap, 73, 510);
        this.addKey(hashMap, 54, 223);
        this.addKey(hashMap, 102, 223);
        this.addKey(hashMap, 89, 239);
        this.addKey(hashMap, 72, 247);
        this.addKey(hashMap, 78, 251);
        this.addKey(hashMap, 55, 253);
        this.addKey(hashMap, 103, 253);
        this.addKey(hashMap, 56, 254);
        this.addKey(hashMap, 104, 254);
        return hashMap;
    }

    private Map createSeFiLayout() {
        HashMap hashMap = new HashMap();
        this.mapSystemKeys(hashMap);
        this.addKey(hashMap, 46, 2043);
        this.addKey(hashMap, 45, 2045);
        this.addKey(hashMap, 153, 2046);
        this.addKey(hashMap, 44, 1787);
        this.addKey(hashMap, 65782, 1789);
        this.addKey(hashMap, 65750, 1789);
        this.addKey(hashMap, 65686, 1789);
        this.addKey(hashMap, 65764, 1790);
        this.addKey(hashMap, 65732, 1790);
        this.addKey(hashMap, 65668, 1790);
        this.addKey(hashMap, 65765, 1407);
        this.addKey(hashMap, 65733, 1407);
        this.addKey(hashMap, 65669, 1407);
        this.addKey(hashMap, 49, 1503);
        this.addKey(hashMap, 97, 1503);
        this.addKey(hashMap, 81, 1519);
        this.addKey(hashMap, 65, 1527);
        this.addKey(hashMap, 90, 1531);
        this.addKey(hashMap, 76, 1533);
        this.addKey(hashMap, 48, 1534);
        this.addKey(hashMap, 96, 1534);
        this.addKey(hashMap, 222, 1151);
        this.addKey(hashMap, 50, 1247);
        this.addKey(hashMap, 98, 1247);
        this.addKey(hashMap, 87, 1263);
        this.addKey(hashMap, 83, 1271);
        this.addKey(hashMap, 88, 1275);
        this.addKey(hashMap, 77, 1277);
        this.addKey(hashMap, 80, 1278);
        this.addKey(hashMap, 129, 895);
        this.addKey(hashMap, 51, 991);
        this.addKey(hashMap, 99, 991);
        this.addKey(hashMap, 69, 1007);
        this.addKey(hashMap, 68, 1015);
        this.addKey(hashMap, 67, 1019);
        this.addKey(hashMap, 75, 1021);
        this.addKey(hashMap, 57, 1022);
        this.addKey(hashMap, 105, 1022);
        this.addKey(hashMap, 521, 639);
        this.addKey(hashMap, 52, 735);
        this.addKey(hashMap, 100, 735);
        this.addKey(hashMap, 82, 751);
        this.addKey(hashMap, 70, 759);
        this.addKey(hashMap, 86, 763);
        this.addKey(hashMap, 74, 765);
        this.addKey(hashMap, 79, 766);
        this.addKey(hashMap, 135, 383);
        this.addKey(hashMap, 53, 479);
        this.addKey(hashMap, 101, 479);
        this.addKey(hashMap, 84, 495);
        this.addKey(hashMap, 71, 503);
        this.addKey(hashMap, 66, 507);
        this.addKey(hashMap, 85, 509);
        this.addKey(hashMap, 73, 510);
        this.addKey(hashMap, 54, 223);
        this.addKey(hashMap, 102, 223);
        this.addKey(hashMap, 89, 239);
        this.addKey(hashMap, 72, 247);
        this.addKey(hashMap, 78, 251);
        this.addKey(hashMap, 55, 253);
        this.addKey(hashMap, 103, 253);
        this.addKey(hashMap, 56, 254);
        this.addKey(hashMap, 104, 254);
        return hashMap;
    }

    public int scanKeyRow(int n) {
        int n2 = 255;
        int n3 = 1;
        int n4 = 0;
        while (n4 < 8) {
            if ((n & n3) == 0) {
                n2 &= this.keyRows[n4];
            }
            n3 <<= 1;
            ++n4;
        }
        return n2;
    }

    public void setKeyRow(int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        while (n4 < 8) {
            if ((n & n3) == 0) {
                this.keyRows[n4] = n2;
            }
            n3 <<= 1;
            ++n4;
        }
    }

    public String getKbdMatrixSymbolically() {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        while (n < 8) {
            stringBuffer.append("A" + (15 - n < 10 ? "0" : "") + (15 - n) + ": " + Dz.byteToBin(this.keyRows[7 - n], false) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void pressZ88key(KeyPress keyPress) {
        this.pressZ88key((keyPress.keyZ88Typed & 0xFF00) >>> 8, keyPress.keyZ88Typed & 0xFF);
    }

    public void pressZ88key(final int n, final int n2) {
        this.kpHelper.addTask(new Runnable(){

            @Override
            public void run() {
                if (Z88.getInstance().getProcessorThread() != null) {
                    int[] nArray = Z88Keyboard.this.keyRows;
                    int n3 = n;
                    nArray[n3] = nArray[n3] & n2;
                    Z88.getInstance().getBlink().signalKeyPressed();
                }
            }
        });
    }

    public void releaseZ88key(final int n, final int n2) {
        this.kpHelper.addTask(new Runnable(){

            @Override
            public void run() {
                if (Z88.getInstance().getProcessorThread() != null) {
                    int[] nArray = Z88Keyboard.this.keyRows;
                    int n3 = n;
                    nArray[n3] = nArray[n3] | ~n2 & 0xFF;
                }
            }
        });
    }

    private void releaseZ88key(KeyPress keyPress) {
        this.releaseZ88key((keyPress.keyZ88Typed & 0xFF00) >>> 8, keyPress.keyZ88Typed & 0xFF);
    }

    public void typeShiftKeys() {
        this.pressZ88key(this.z88RshKey);
        this.pressZ88key(this.z88LshKey);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.releaseZ88key(this.z88LshKey);
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        this.releaseZ88key(this.z88RshKey);
    }

    public void resetKeyboardMatrix() {
        int n = 0;
        while (n < 8) {
            this.keyRows[n] = 255;
            ++n;
        }
    }

    public void setKeyboardLayout(int n) {
        this.currentKbLayoutCountryCode = n %= this.z88Keyboards.length;
        this.currentKbLayout = this.z88Keyboards[n];
    }

    public int getKeyboardLayout() {
        return this.currentKbLayoutCountryCode;
    }

    public KeyPress getZ88Key(int n) {
        this.searchKey.keyCode = n;
        KeyPress keyPress = (KeyPress)this.currentKbLayout.get(this.searchKey);
        return keyPress;
    }

    private class KeyPress {
        private int keyCode;
        private int keyZ88Typed;

        public KeyPress(int n, int n2) {
            this.keyCode = n;
            this.keyZ88Typed = n2;
        }

        public int hashCode() {
            return this.keyCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyPress)) {
                return false;
            }
            KeyPress keyPress = (KeyPress)object;
            return this.keyCode == keyPress.keyCode;
        }
    }

    private class Z88KeyboardListener
    implements KeyListener {
        private Z88KeyboardListener() {
        }

        private KeyPress hostLayoutConversion(KeyEvent keyEvent) {
            KeyPress keyPress = null;
            block0 : switch (keyEvent.getKeyCode()) {
                case 77: {
                    switch (keyEvent.getKeyChar()) {
                        case ',': 
                        case '?': {
                            keyPress = Z88Keyboard.this.getZ88Key(44);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(77);
                    break;
                }
                case 44: {
                    switch (keyEvent.getKeyChar()) {
                        case '.': 
                        case ';': {
                            keyPress = Z88Keyboard.this.getZ88Key(59);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(44);
                    break;
                }
                case 46: {
                    switch (keyEvent.getKeyChar()) {
                        case '/': 
                        case ':': {
                            keyPress = Z88Keyboard.this.getZ88Key(513);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(46);
                    break;
                }
                case 47: {
                    switch (keyEvent.getKeyChar()) {
                        case '+': 
                        case '=': {
                            keyPress = Z88Keyboard.this.getZ88Key(61);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(47);
                    break;
                }
                case 91: {
                    switch (keyEvent.getKeyChar()) {
                        case '^': 
                        case '\u00a8': {
                            keyPress = Z88Keyboard.this.getZ88Key(130);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(91);
                    break;
                }
                case 135: {
                    if (keyEvent.getKeyChar() == '\u00a8') {
                        keyPress = Z88Keyboard.this.getZ88Key(130);
                        break;
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(135);
                    break;
                }
                case 128: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1] & keyEvent.getKeyChar() == '`') {
                        keyPress = Z88Keyboard.this.getZ88Key(151);
                        break;
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(128);
                    break;
                }
                case 92: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1] & (keyEvent.getKeyChar() == '`' | keyEvent.getKeyChar() == '\u00a3')) {
                        keyPress = Z88Keyboard.this.getZ88Key(151);
                        break;
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(92);
                    break;
                }
                case 93: {
                    switch (keyEvent.getKeyChar()) {
                        case '$': 
                        case '*': {
                            keyPress = Z88Keyboard.this.getZ88Key(515);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(93);
                    break;
                }
                case 192: {
                    switch (keyEvent.getKeyChar()) {
                        case '<': 
                        case '>': {
                            keyPress = Z88Keyboard.this.getZ88Key(153);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(192);
                    break;
                }
                case 61: {
                    switch (keyEvent.getKeyChar()) {
                        case '-': 
                        case '_': {
                            keyPress = Z88Keyboard.this.getZ88Key(45);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(61);
                    break;
                }
                case 45: {
                    switch (keyEvent.getKeyChar()) {
                        case ')': 
                        case '\u00b0': {
                            keyPress = Z88Keyboard.this.getZ88Key(522);
                            break block0;
                        }
                    }
                    keyPress = Z88Keyboard.this.getZ88Key(45);
                    break;
                }
                default: {
                    keyPress = Z88Keyboard.this.getZ88Key(keyEvent.getKeyCode());
                }
            }
            return keyPress;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            KeyPress keyPress = null;
            switch (keyEvent.getKeyCode()) {
                case 16: {
                    if (keyEvent.getKeyLocation() == 2) {
                        Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88LshKey);
                    }
                    if (keyEvent.getKeyLocation() != 3) break;
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                    break;
                }
                case 116: {
                    if (!Z88.getInstance().getProcessor().isZ80ThreadRunning()) break;
                    Z88.getInstance().getProcessor().stopZ80Execution();
                    Z88.getInstance().getBlink().awakeZ80();
                    DebugGui.getInstance().activateDebugCommandLine();
                    CommandLine.getInstance().cmdlineFirstSingleStep();
                    DebugGui.getInstance().lockZ88MachinePanel(true);
                    break;
                }
                case 123: {
                    DebugGui.getInstance().activateDebugCommandLine();
                    break;
                }
                case 17: {
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88DiamondKey);
                    break;
                }
                case 18: {
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88SquareKey);
                    break;
                }
                case 155: {
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88DiamondKey);
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.getZ88Key(86));
                    break;
                }
                case 127: {
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88DelKey);
                    break;
                }
                case 36: {
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88DiamondKey);
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88ArrowLeftKey);
                    break;
                }
                case 35: {
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88DiamondKey);
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88ArrowRightKey);
                    break;
                }
                case 33: {
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88ArrowUpKey);
                    break;
                }
                case 34: {
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88ArrowDownKey);
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                    }
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.getZ88Key(keyEvent.getKeyCode()));
                    break;
                }
                case 107: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                        keyPress = Z88Keyboard.this.getZ88Key(61);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.pressZ88key(keyPress);
                    break;
                }
                case 109: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        keyPress = Z88Keyboard.this.getZ88Key(45);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.pressZ88key(keyPress);
                    break;
                }
                case 106: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        keyPress = Z88Keyboard.this.getZ88Key(151);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.pressZ88key(keyPress);
                    break;
                }
                case 111: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                        keyPress = Z88Keyboard.this.getZ88Key(513);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.pressZ88key(keyPress);
                    break;
                }
                case 110: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                        keyPress = Z88Keyboard.this.getZ88Key(59);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.pressZ88key(keyPress);
                    break;
                }
                case 520: {
                    if (keyEvent.getKeyChar() == '#') {
                        Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                        Z88Keyboard.this.pressZ88key(Z88Keyboard.this.getZ88Key(51));
                    }
                    if (keyEvent.getKeyChar() != '~') break;
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.z88RshKey);
                    Z88Keyboard.this.pressZ88key(Z88Keyboard.this.getZ88Key(163));
                    break;
                }
                default: {
                    keyPress = this.hostLayoutConversion(keyEvent);
                    if (keyPress == null) break;
                    Z88Keyboard.this.pressZ88key(keyPress);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            KeyPress keyPress = null;
            switch (keyEvent.getKeyCode()) {
                case 16: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88LshKey);
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                    break;
                }
                case 17: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88DiamondKey);
                    break;
                }
                case 18: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88SquareKey);
                    break;
                }
                case 127: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88DelKey);
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                    break;
                }
                case 155: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.getZ88Key(86));
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88DiamondKey);
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    keyPress = Z88Keyboard.this.getZ88Key(keyEvent.getKeyCode());
                    Z88Keyboard.this.releaseZ88key(keyPress);
                    if (Z88Keyboard.this.currentKbLayout != Z88Keyboard.this.z88Keyboards[1]) break;
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                    break;
                }
                case 36: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88ArrowLeftKey);
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88DiamondKey);
                    break;
                }
                case 35: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88ArrowRightKey);
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88DiamondKey);
                    break;
                }
                case 33: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88ArrowUpKey);
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                    break;
                }
                case 34: {
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88ArrowDownKey);
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                    break;
                }
                case 107: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                        keyPress = Z88Keyboard.this.getZ88Key(61);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.releaseZ88key(keyPress);
                    break;
                }
                case 109: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        keyPress = Z88Keyboard.this.getZ88Key(45);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.releaseZ88key(keyPress);
                    break;
                }
                case 106: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        keyPress = Z88Keyboard.this.getZ88Key(151);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.releaseZ88key(keyPress);
                    break;
                }
                case 111: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                        keyPress = Z88Keyboard.this.getZ88Key(513);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.releaseZ88key(keyPress);
                    break;
                }
                case 110: {
                    if (Z88Keyboard.this.currentKbLayout == Z88Keyboard.this.z88Keyboards[1]) {
                        Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                        keyPress = Z88Keyboard.this.getZ88Key(59);
                    }
                    if (keyPress == null) break;
                    Z88Keyboard.this.releaseZ88key(keyPress);
                    break;
                }
                case 520: {
                    if (keyEvent.getKeyChar() == '#') {
                        Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                        Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.getZ88Key(51));
                    }
                    if (keyEvent.getKeyChar() != '~') break;
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.z88RshKey);
                    Z88Keyboard.this.releaseZ88key(Z88Keyboard.this.getZ88Key(163));
                    break;
                }
                default: {
                    keyPress = this.hostLayoutConversion(keyEvent);
                    if (keyPress == null) break;
                    Z88Keyboard.this.releaseZ88key(keyPress);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            Z88Keyboard.this.hostKeyboardLocale = InputContext.getInstance().getLocale();
        }
    }
}

