/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.datastructures;

import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.Z88;
import com.jira.cambridgez88.ozvm.datastructures.SlotInfo;

public class ApplicationCardHeader {
    private Memory memory = Z88.getInstance().getMemory();
    private SlotInfo slotinfo = SlotInfo.getInstance();
    private int cardId;
    private int countryCode;
    private int appAreaSize;

    public ApplicationCardHeader(int n) {
        if (this.slotinfo.isOzRom(n) | this.slotinfo.isApplicationCard(n)) {
            int n2 = (n & 3) << 6 | 0x3F;
            this.cardId = this.memory.getByte(16377, n2) << 8 | this.memory.getByte(16376, n2);
            this.countryCode = this.memory.getByte(16378, n2);
            this.appAreaSize = this.memory.getByte(16380, n2);
        }
    }

    public int getAppAreaSize() {
        return this.appAreaSize;
    }

    public int getCardId() {
        return this.cardId;
    }

    public int getCountryCode() {
        return this.countryCode;
    }
}

