/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.datastructures;

import com.jira.cambridgez88.ozvm.datastructures.ApplicationDor;
import com.jira.cambridgez88.ozvm.datastructures.ApplicationFrontDor;
import com.jira.cambridgez88.ozvm.datastructures.SlotInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ApplicationInfo {
    private List[] appSlotList = new List[4];

    public ApplicationInfo() {
        this.scanSlots();
    }

    public void scanSlots() {
        int n = 0;
        while (n < 4) {
            this.scanSlot(n);
            ++n;
        }
    }

    private void scanSlot(int n) {
        if (!SlotInfo.getInstance().isApplicationCard(n &= 3) & !SlotInfo.getInstance().isOzRom(n)) {
            this.appSlotList[n] = null;
        } else {
            this.appSlotList[n] = new LinkedList();
            ApplicationFrontDor applicationFrontDor = new ApplicationFrontDor(n);
            ApplicationDor applicationDor = new ApplicationDor(applicationFrontDor.getFirstApplicationDor());
            this.appSlotList[n].add(applicationDor);
            while (applicationDor.getNextApp() != 0) {
                applicationDor = new ApplicationDor(applicationDor.getNextApp());
                this.appSlotList[n].add(applicationDor);
            }
        }
    }

    public ListIterator getApplications(int n) {
        if (this.appSlotList[n &= 3] != null) {
            return this.appSlotList[n].listIterator();
        }
        return null;
    }

    public static boolean checkAppImage(File file) {
        boolean bl = true;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            if (randomAccessFile.length() > 0x100000L | randomAccessFile.length() % 16384L != 0L) {
                bl = false;
            }
            randomAccessFile.seek(randomAccessFile.length() - 4L);
            if ((long)(randomAccessFile.readByte() * 16384) > randomAccessFile.length()) {
                bl = false;
            }
            randomAccessFile.readByte();
            byte by = randomAccessFile.readByte();
            byte by2 = randomAccessFile.readByte();
            if (by != 79 & by2 != 90) {
                bl = false;
            }
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return bl;
    }
}

