/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.datastructures;

import com.jira.cambridgez88.ozvm.AmdFlashBank;
import com.jira.cambridgez88.ozvm.AmicFlashBank;
import com.jira.cambridgez88.ozvm.Bank;
import com.jira.cambridgez88.ozvm.EpromBank;
import com.jira.cambridgez88.ozvm.GenericAmdFlashBank;
import com.jira.cambridgez88.ozvm.IntelFlashBank;
import com.jira.cambridgez88.ozvm.Memory;
import com.jira.cambridgez88.ozvm.RamBank;
import com.jira.cambridgez88.ozvm.RomBank;
import com.jira.cambridgez88.ozvm.VoidBank;
import com.jira.cambridgez88.ozvm.Z88;

public class SlotInfo {
    public static final int EmptySlot = 0;
    public static final int RomCard = 1;
    public static final int RamCard = 2;
    public static final int EpromCard = 3;
    public static final int IntelFlashCard = 4;
    public static final int AmdFlashCard = 5;
    public static final int AmicFlashCard = 6;
    public static final int AmdHybridRamCard = 8;
    public static final int AmicHybridRamCard = 9;
    private Memory memory = Z88.getInstance().getMemory();

    public static SlotInfo getInstance() {
        return singletonContainer.singleton;
    }

    private SlotInfo() {
    }

    public boolean isApplicationCard(int n) {
        int n2 = n == 0 ? 31 : (n & 3) << 6 | 0x3F;
        return this.memory.getByte(16379, n2) == 128 & this.memory.getByte(16382, n2) == 79 & this.memory.getByte(16383, n2) == 90;
    }

    public boolean isOzRom(int n) {
        int n2 = n == 0 ? 31 : (n & 3) << 6 | 0x3F;
        return this.memory.getByte(16379, n2) == 129 & this.memory.getByte(16382, n2) == 79 & this.memory.getByte(16383, n2) == 90;
    }

    public boolean isFileHeader(int n) {
        return this.memory.getByte(16375, n & 0xFF) == 1 & this.memory.getByte(16382, n & 0xFF) == 111 & this.memory.getByte(16383, n & 0xFF) == 122;
    }

    public int getFileHeaderBank(int n) {
        int n2 = (n & 3) << 6;
        int n3 = n2 | 0x3F;
        while (n3 >= n2) {
            Bank bank = this.memory.getBank(n3);
            if (!(bank instanceof EpromBank | bank instanceof GenericAmdFlashBank | bank instanceof IntelFlashBank)) break;
            if (this.isFileHeader(n3)) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public boolean isFileCard(int n) {
        int n2 = (n & 3) << 6 | 0x3F;
        return this.isFileHeader(n2);
    }

    public int getCardType(int n) {
        int n2 = (n & 3) << 6;
        int n3 = (n & 3) << 6 | 0x3F;
        if (this.memory.getBank(n3) instanceof VoidBank) {
            return 0;
        }
        if (this.memory.getBank(n3) instanceof RomBank) {
            return 1;
        }
        if (this.memory.getBank(n3) instanceof RamBank) {
            return 2;
        }
        if (this.memory.getBank(n3) instanceof EpromBank) {
            return 3;
        }
        if (this.memory.getBank(n3) instanceof IntelFlashBank) {
            return 4;
        }
        if (this.memory.getBank(n3) instanceof AmdFlashBank && this.memory.getBank(n2) instanceof AmdFlashBank) {
            return 5;
        }
        if (this.memory.getBank(n3) instanceof AmicFlashBank && this.memory.getBank(n2) instanceof AmicFlashBank) {
            return 6;
        }
        if (this.memory.getBank(n3) instanceof AmdFlashBank && this.memory.getBank(n2) instanceof RamBank) {
            return 8;
        }
        if (this.memory.getBank(n3) instanceof AmicFlashBank && this.memory.getBank(n2) instanceof RamBank) {
            return 9;
        }
        return 0;
    }

    /* synthetic */ SlotInfo(SlotInfo slotInfo) {
        this();
    }

    private static final class singletonContainer {
        static final SlotInfo singleton = new SlotInfo(null);

        private singletonContainer() {
        }
    }
}

