/*
 * Decompiled with CFR 0.152.
 */
package com.jira.cambridgez88.ozvm.screen;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class Gif89Decoder {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected BufferedInputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int lastBgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected Rectangle lastRect;
    protected BufferedImage image;
    protected BufferedImage lastImage;
    protected byte[] block = new byte[256];
    protected int blockSize;
    protected int dispose;
    protected int lastDispose;
    protected boolean transparency;
    protected int delay;
    protected int transIndex;
    protected static final int MaxStackSize = 4096;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected ArrayList frames;
    protected int frameCount;

    public int getDelay(int n) {
        this.delay = -1;
        if (n >= 0 && n < this.frameCount) {
            this.delay = ((GifFrame)this.frames.get((int)n)).delay;
        }
        return this.delay;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public BufferedImage getImage() {
        return this.getFrame(0);
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    protected void setPixels() {
        int n;
        int[] nArray = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                n = this.frameCount - 2;
                this.lastImage = n > 0 ? this.getFrame(n - 1) : null;
            }
            if (this.lastImage != null) {
                int[] nArray2 = ((DataBufferInt)this.lastImage.getRaster().getDataBuffer()).getData();
                System.arraycopy(nArray2, 0, nArray, 0, this.width * this.height);
                if (this.lastDispose == 2) {
                    Graphics2D graphics2D = this.image.createGraphics();
                    Color color = null;
                    color = this.transparency ? new Color(0, 0, 0, 0) : new Color(this.lastBgColor);
                    graphics2D.setColor(color);
                    graphics2D.setComposite(AlphaComposite.Src);
                    graphics2D.fill(this.lastRect);
                    graphics2D.dispose();
                }
            }
        }
        n = 1;
        int n2 = 8;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.ih) {
            int n5 = n4;
            if (this.interlace) {
                if (n3 >= this.ih) {
                    switch (++n) {
                        case 2: {
                            n3 = 4;
                            break;
                        }
                        case 3: {
                            n3 = 2;
                            n2 = 4;
                            break;
                        }
                        case 4: {
                            n3 = 1;
                            n2 = 2;
                            break;
                        }
                    }
                }
                n5 = n3;
                n3 += n2;
            }
            if ((n5 += this.iy) < this.height) {
                int n6 = n5 * this.width;
                int n7 = n6 + this.ix;
                int n8 = n7 + this.iw;
                if (n6 + this.width < n8) {
                    n8 = n6 + this.width;
                }
                int n9 = n4 * this.iw;
                while (n7 < n8) {
                    int n10;
                    int n11;
                    if ((n11 = this.act[n10 = this.pixels[n9++] & 0xFF]) != 0) {
                        nArray[n7] = n11;
                    }
                    ++n7;
                }
            }
            ++n4;
        }
    }

    public BufferedImage getFrame(int n) {
        BufferedImage bufferedImage = null;
        if (n >= 0 && n < this.frameCount) {
            bufferedImage = ((GifFrame)this.frames.get((int)n)).image;
        }
        return bufferedImage;
    }

    public Dimension getFrameSize() {
        return new Dimension(this.width, this.height);
    }

    public int read(BufferedInputStream bufferedInputStream) {
        this.init();
        if (bufferedInputStream != null) {
            this.in = bufferedInputStream;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {}
        return this.status;
    }

    public int read(String string) {
        this.status = 0;
        try {
            string = string.trim().toLowerCase();
            if (string.indexOf("file:") >= 0 || string.indexOf(":/") > 0) {
                URL uRL = new URL(string);
                this.in = new BufferedInputStream(uRL.openStream());
            } else {
                this.in = new BufferedInputStream(new FileInputStream(string));
            }
            this.status = this.read(this.in);
        }
        catch (IOException iOException) {
            this.status = 2;
        }
        return this.status;
    }

    protected void decodeImageData() {
        int n = -1;
        int n2 = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < n2) {
            this.pixels = new byte[n2];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n3 = this.read();
        int n4 = 1 << n3;
        int n5 = n4 + 1;
        int n6 = n4 + 2;
        int n7 = n;
        int n8 = n3 + 1;
        int n9 = (1 << n8) - 1;
        int n10 = 0;
        while (n10 < n4) {
            this.prefix[n10] = 0;
            this.suffix[n10] = (byte)n10;
            ++n10;
        }
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        while (n18 < n2) {
            if (n13 == 0) {
                if (n16 < n8) {
                    if (n15 == 0) {
                        n15 = this.readBlock();
                        if (n15 <= 0) break;
                        n11 = 0;
                    }
                    n17 += (this.block[n11] & 0xFF) << n16;
                    n16 += 8;
                    ++n11;
                    --n15;
                    continue;
                }
                n10 = n17 & n9;
                n17 >>= n8;
                n16 -= n8;
                if (n10 > n6 || n10 == n5) break;
                if (n10 == n4) {
                    n8 = n3 + 1;
                    n9 = (1 << n8) - 1;
                    n6 = n4 + 2;
                    n7 = n;
                    continue;
                }
                if (n7 == n) {
                    this.pixelStack[n13++] = this.suffix[n10];
                    n7 = n10;
                    n14 = n10;
                    continue;
                }
                int n19 = n10;
                if (n10 == n6) {
                    this.pixelStack[n13++] = (byte)n14;
                    n10 = n7;
                }
                while (n10 > n4) {
                    this.pixelStack[n13++] = this.suffix[n10];
                    n10 = this.prefix[n10];
                }
                n14 = this.suffix[n10] & 0xFF;
                if (n6 >= 4096) break;
                this.pixelStack[n13++] = (byte)n14;
                this.prefix[n6] = (short)n7;
                this.suffix[n6] = (byte)n14;
                if ((++n6 & n9) == 0 && n6 < 4096) {
                    ++n8;
                    n9 += n6;
                }
                n7 = n19;
            }
            this.pixels[n12++] = this.pixelStack[--n13];
            ++n18;
        }
        n18 = n12;
        while (n18 < n2) {
            this.pixels[n18] = 0;
            ++n18;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new ArrayList();
        this.gct = null;
        this.lct = null;
    }

    protected int read() {
        int n = 0;
        try {
            n = this.in.read();
        }
        catch (IOException iOException) {
            this.status = 1;
        }
        return n;
    }

    protected int readBlock() {
        this.blockSize = this.read();
        int n = 0;
        if (this.blockSize > 0) {
            try {
                int n2 = 0;
                while (n < this.blockSize) {
                    n2 = this.in.read(this.block, n, this.blockSize - n);
                    if (n2 != -1) {
                        n += n2;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    protected int[] readColorTable(int n) {
        int n2 = 3 * n;
        int[] nArray = null;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = this.in.read(byArray);
        }
        catch (IOException iOException) {}
        if (n3 < n2) {
            this.status = 1;
        } else {
            nArray = new int[256];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                nArray[n4++] = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
            }
        }
        return nArray;
    }

    protected void readContents() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(12);
        while (!bl && !this.err()) {
            int n = this.read();
            block0 : switch (n) {
                case 44: {
                    this.readImage();
                    break;
                }
                case 33: {
                    n = this.read();
                    switch (n) {
                        case 249: {
                            this.readGraphicControlExt();
                            break block0;
                        }
                        case 255: {
                            this.readBlock();
                            stringBuffer.delete(0, 12);
                            int n2 = 0;
                            while (n2 < 11) {
                                stringBuffer.append((char)this.block[n2]);
                                ++n2;
                            }
                            if (stringBuffer.toString().equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                break block0;
                            }
                            this.skip();
                            break block0;
                        }
                    }
                    this.skip();
                    break;
                }
                case 59: {
                    bl = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.status = 1;
                }
            }
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int n = this.read();
        this.dispose = (n & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (n & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        StringBuffer stringBuffer = new StringBuffer(6);
        int n = 0;
        while (n < 6) {
            stringBuffer.append((char)this.read());
            ++n;
        }
        if (!stringBuffer.toString().startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int n = this.read();
        this.lctFlag = (n & 0x80) != 0;
        this.interlace = (n & 0x40) != 0;
        this.lctSize = 2 << (n & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int n2 = 0;
        if (this.transparency) {
            n2 = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount;
        this.image = new BufferedImage(this.width, this.height, 3);
        this.setPixels();
        this.frames.add(new GifFrame(this.image, this.delay));
        if (this.transparency) {
            this.act[this.transIndex] = n2;
        }
        this.resetFrame();
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int n = this.read();
        this.gctFlag = (n & 0x80) != 0;
        this.gctSize = 2 << (n & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int n = this.block[1] & 0xFF;
            int n2 = this.block[2] & 0xFF;
            this.loopCount = n2 << 8 | n;
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void resetFrame() {
        this.lastDispose = this.dispose;
        this.lastRect = new Rectangle(this.ix, this.iy, this.iw, this.ih);
        this.lastImage = this.image;
        this.lastBgColor = this.bgColor;
        this.lct = null;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    static class GifFrame {
        public BufferedImage image;
        public int delay;

        public GifFrame(BufferedImage bufferedImage, int n) {
            this.image = bufferedImage;
            this.delay = n;
        }
    }
}

