#ifdef _DEBUG
#include <stdio.h>
#endif

#include <windows.h>
#include "Gfx #1.3.h"
#include "rdp.h"
#include "vi.h"

unsigned char cfg[32] = {
    0x02, 0x7F, /* custom digital screen width, minus one */
    0x01, 0xDF, /* custom digital screen height, minus one */

/*
 * screen resolution formula methods
 * 0x00:  VI DAC to NTSC/PAL
 * 0x01:  DP frame buffer active video
 * 0x02:  user-defined (cares what the above two words are)
 */
    0x00,

/*
 * reserved for future use as a graphics microcode simulation setting
 * 0xFF:  no microcode simulation (force LLE graphics)
 * 0x00:  automatic (if asked to do HLE, try to auto-detect microcode)
 * 0x01:  RSP SW
 * 0x02:  F3DEX
 * ...
 */
    0x00,

/*
 * reserved for doing extra OpenGL stuff...brightness, extra filtering?
 * not yet implemented
 */
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,
    0x00, 0x00,

    0x00, /* Skip UpdateScreen this many times. */
    0x00, /* Skip ProcessDList (and ProcessRDPList) this many times. */

/*
 * 64-bit Boolean flags, bits 63..48 (little-endian):
 * currently reserved
 */
    0x00, 0x00,

/*
 * 64-bit Boolean flags, bits 47..32:
 * currently reserved
 */
    0x00, 0x00,

/*
 * 64-bit Boolean flags, bits 31..16:
 * currently reserved
 */
    0x00, 0x00,

/*
 * 64-bit Boolean flags, bits 15..0:
 *  0.  Ignore and bypass all VI_STATUS_REG filter modes?
 *  1.  Emulate alternative TV size (calculated with bi-linear scaling)?
 *  2.  Pause emulation after every screen update?
 */
    0x00, 0x00,

/*
 * spare bytes for other types of configuration?
 * currently unused
 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

EXPORT void CALL DllAbout(HWND hParent)
{
    MessageBox(
        hParent,
        "angrylion's RDP, unpublished beta. MESS source code used.",
        "DllAbout",
        MB_ICONINFORMATION);
    return;
}

EXPORT void CALL DllConfig(HWND hParent)
{
    int response;
#ifdef _DEBUG
    char text_buf[192];

    sprintf(
        text_buf,

        "CYCLE_TYPE_1   :  %d\n"\
        "CYCLE_TYPE_2   :  %d\n"\
        "CYCLE_TYPE_COPY:  %d\n"\
        "CYCLE_TYPE_FILL:  %d",

        render_cycle_mode_counts[CYCLE_TYPE_1],
        render_cycle_mode_counts[CYCLE_TYPE_2],
        render_cycle_mode_counts[CYCLE_TYPE_COPY],
        render_cycle_mode_counts[CYCLE_TYPE_FILL]);
    MessageBox(hParent, text_buf, "Render Spans Cycle Mode Counts", MB_OK);
#endif
    response = MessageBox(
        hParent, "Disable VI DAC filters?", "Frame Buffer Overlay", MB_YESNO);
    if (response == IDYES || response == IDNO)
    {
        cfg[23] &= ~(0x01 << 0);
        cfg[23] |= (response == IDYES) << 0;
    }

    response = MessageBox(
        hParent, "GPU-accelerated scaling?", "Alternate TV Size", MB_YESNO);
    if (response == IDYES || response == IDNO)
    {
        cfg[23] &= ~(0x01 << 1);
        cfg[23] |= (response == IDYES) << 1;
    }

    response = MessageBox(
        hParent, "Pause after each screen update?", "Frame Stepping", MB_YESNO);
    if (response == IDYES || response == IDNO)
    {
        cfg[23] &= ~(0x01 << 2);
        cfg[23] |= (response == IDYES) << 2;
    }

#ifdef TRACE_DP_COMMANDS
    count_DP_commands();
#endif
    return;
}

EXPORT void CALL DllTest(HWND hParent)
{
    return;
}
