/******************************************************************************\
* Project:  File Formatting for Capturing Screen Pixel Maps                    *
* Authors:  Iconoclast                                                         *
* Release:  2014.04.12                                                         *
* License:  none                                                               *
\******************************************************************************/

#include <stdio.h>
#include <memory.h>
#include <malloc.h>
#include "z64.h"
#include "bitmap.h"
#include "vi.h"

static unsigned char bitmap_header[HEADERSIZE] = {
    'B', 'M',

/* file size (little-endian) */
    ((4*PRESCALE_WIDTH*PRESCALE_HEIGHT + HEADERSIZE) >>  0) & 0xFF,
    ((4*PRESCALE_WIDTH*PRESCALE_HEIGHT + HEADERSIZE) >>  8) & 0xFF,
    ((4*PRESCALE_WIDTH*PRESCALE_HEIGHT + HEADERSIZE) >> 16) & 0xFF,
    ((4*PRESCALE_WIDTH*PRESCALE_HEIGHT + HEADERSIZE) >> 24) & 0xFF,

/* reserved */
    0x00, 0x00,
/* reserved */
    0x00, 0x00,
/* file offset to pixel array (little-endian) */
    (HEADERSIZE >>  0) & 0xFF,
    (HEADERSIZE >>  8) & 0xFF,
    (HEADERSIZE >> 16) & 0xFF,
    (HEADERSIZE >> 24) & 0xFF,

/* BITMAPINFOHEADER:  size in bytes (little-endian) */
    40, 0x00, 0x00, 0x00,
/* BITMAPINFOHEADER:  image width, in pixels */
    (PRESCALE_WIDTH  >>  0) & 0xFF,
    (PRESCALE_WIDTH  >>  8) & 0xFF,
    (PRESCALE_WIDTH  >> 16) & 0xFF,
    (PRESCALE_WIDTH  >> 24) & 0xFF,
/* BITMAPINFOHEADER:  image height, in pixels */
    (PRESCALE_HEIGHT >>  0) & 0xFF,
    (PRESCALE_HEIGHT >>  8) & 0xFF,
    (PRESCALE_HEIGHT >> 16) & 0xFF,
    (PRESCALE_HEIGHT >> 24) & 0xFF,
/* BITMAPINFOHEADER:  number of color planes */
    1, 0x00,
/* BITMAPINFOHEADER:  color depth, in bits per pixel */
    32, 0x00,
/* BITMAPINFOHEADER:  compression method */
    0, 0x00, 0x00, 0x00,
/* BITMAPINFOHEADER:  bitmap size (optional for BI_RGB) */
    (4*PRESCALE_WIDTH*PRESCALE_HEIGHT >>  0) & 0xFF,
    (4*PRESCALE_WIDTH*PRESCALE_HEIGHT >>  8) & 0xFF,
    (4*PRESCALE_WIDTH*PRESCALE_HEIGHT >> 16) & 0xFF,
    (4*PRESCALE_WIDTH*PRESCALE_HEIGHT >> 24) & 0xFF,
/* BITMAPINFOHEADER:  bullshit */
    (RESOLUTION_H >>  0) & 0xFF,
    (RESOLUTION_H >>  8) & 0xFF,
    (RESOLUTION_H >> 16) & 0xFF,
    (RESOLUTION_H >> 24) & 0xFF,
/* BITMAPINFOHEADER:  more bullshit */
    (RESOLUTION_V >>  0) & 0xFF,
    (RESOLUTION_V >>  8) & 0xFF,
    (RESOLUTION_V >> 16) & 0xFF,
    (RESOLUTION_V >> 24) & 0xFF,
/* BITMAPINFOHEADER:  palette shit */
    0, 0x00, 0x00, 0x00,
/* BITMAPINFOHEADER:  unimportant shit */
    0, 0x00, 0x00, 0x00,

/* optional padding */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/*
 * end of 64-byte header structure
 * big-endian RGB bitmap concatenated from this point
 */
};

void capture_screen_to_file(char * path)
{
    FILE* file_stream;
    int h_start, v_start;
    unsigned char* file_data;
    unsigned char* bitmap;
    register int x, y;
    int pixels;
    int prevy, y_start;
    int hres, vres;
    int cur_x, line_x;
    const int frame_buffer = *GET_GFX_INFO(VI_ORIGIN_REG) & 0x00FFFFFF;
    const int VI_width = *GET_GFX_INFO(VI_WIDTH_REG) & 0x00000FFF;
    const int x_add = *GET_GFX_INFO(VI_X_SCALE_REG) & 0x00000FFF;
    const int y_add = *GET_GFX_INFO(VI_Y_SCALE_REG) & 0x00000FFF;
    const int v_sync = *GET_GFX_INFO(VI_V_SYNC_REG) & 0x000003FF;
    const int ispal  = (v_sync > 550);
    const int x1 = (*GET_GFX_INFO(VI_H_START_REG) >> 16) & 0x03FF;
    const int y1 = (*GET_GFX_INFO(VI_V_START_REG) >> 16) & 0x03FF;
    const int x2 = (*GET_GFX_INFO(VI_H_START_REG) >>  0) & 0x03FF;
    const int y2 = (*GET_GFX_INFO(VI_V_START_REG) >>  0) & 0x03FF;
    const unsigned char bits_per_pixel = 16;
    const unsigned int bytes_per_pixel = bits_per_pixel >> 3;

    hres = x2 - x1;
    vres = y2 - y1;

    h_start = x1 - (ispal ? 128 : 108);
    v_start = y1 - (ispal ?  47 :  37);
    h_start = (h_start < 0) ? 0 : h_start;
    v_start = (v_start < 0) ? 0 : v_start;
    v_start >>= 1;
    vres >>= 1;
    if (hres > PRESCALE_WIDTH - h_start)
        hres = PRESCALE_WIDTH - h_start;
    if (vres > PRESCALE_HEIGHT - v_start)
        vres = PRESCALE_HEIGHT - v_start;

    hres -= hres & 1; /* screwed up width with Gauntlet Legends */

    bitmap_header[18] = (hres >>  0) & 0xFF;
    bitmap_header[19] = (hres >>  8) & 0xFF;
    bitmap_header[20] = (hres >> 16) & 0xFF;
    bitmap_header[21] = (hres >> 24) & 0xFF;
    bitmap_header[22] = (vres >>  0) & 0xFF;
    bitmap_header[23] = (vres >>  8) & 0xFF;
    bitmap_header[24] = (vres >> 16) & 0xFF;
    bitmap_header[25] = (vres >> 24) & 0xFF;
    bitmap_header[28] = bits_per_pixel;
    bitmap_header[34] = (bytes_per_pixel*hres*vres >>  0) & 0xFF;
    bitmap_header[35] = (bytes_per_pixel*hres*vres >>  8) & 0xFF;
    bitmap_header[36] = (bytes_per_pixel*hres*vres >> 16) & 0xFF;
    bitmap_header[37] = (bytes_per_pixel*hres*vres >> 24) & 0xFF;
    bitmap_header[ 2] = (bytes_per_pixel*hres*vres + HEADERSIZE)>> 0 & 0xFF;
    bitmap_header[ 3] = (bytes_per_pixel*hres*vres + HEADERSIZE)>> 8 & 0xFF;
    bitmap_header[ 4] = (bytes_per_pixel*hres*vres + HEADERSIZE)>>16 & 0xFF;
    bitmap_header[ 5] = (bytes_per_pixel*hres*vres + HEADERSIZE)>>24 & 0xFF;
    file_data = malloc(bytes_per_pixel*hres*vres + HEADERSIZE);
    memcpy(file_data, bitmap_header, HEADERSIZE);

    y_start = *GET_GFX_INFO(VI_Y_SCALE_REG)>>16 & 0x0FFF;
    for (y = vres - 1; y >= 0; y--)
    {
        int x_start;

        x_start = *GET_GFX_INFO(VI_X_SCALE_REG)>>16 & 0x0FFF;
        prevy = y_start >> 10;
        pixels = VI_width * prevy;

        bitmap = file_data + HEADERSIZE + bytes_per_pixel*y*hres;
        for (x = 0; x < hres; x++)
        {
            UINT16 pixel;
            unsigned long addr;

            line_x = x_start >> 10;
            cur_x = pixels + line_x;
            x_start += x_add;

            addr = frame_buffer + 2*cur_x;
            if (plim - addr < 0)
                continue;
            addr = addr ^ (WORD_ADDR_XOR << 1);
            pixel = *(INT16 *)(DRAM + addr);
/*
            r = (pixel & 0xF800) >> 11;
            g = (pixel & 0x07C0) >>  6;
            b = (pixel & 0x003E) >>  1;
            a = (pixel & 0x0001) >>  0;
            pixel = (a << 15) | (r << 10) | (g << 5) | (b << 0);
*/
            pixel = (pixel<<15 & 0x8000) | (pixel>>1 & 0x7FFF);
            *(bitmap++) = (pixel >> 0) & 0xFF;
            *(bitmap++) = (pixel >> 8) & 0xFF;
        }
        y_start += y_add;
    }
    file_stream = fopen(path, "wb");
    fwrite(file_data, bytes_per_pixel*hres*vres + HEADERSIZE, 1, file_stream);
    fclose(file_stream);
    free(file_data);
    return;
}
