#ifndef _VI_H_
#define _VI_H_

#include <Windows.h>
#include <ddraw.h>
#include "Gfx #1.3.h"
#include "z64.h"

typedef struct {
    unsigned char r, g, b, cvg;
} CCVG;

typedef struct {
    int ntscnolerp;
    int copymstrangecrashes;
    int fillmcrashes;
    int fillmbitcrashes;
    int syncfullcrash;
} onetime;

typedef struct {
    UINT8 cvg;
    UINT8 cvbit;
    UINT8 xoff;
    UINT8 yoff;
} CVtcmaskDERIVATIVE;

extern LPDIRECTDRAW7 lpdd;
extern LPDIRECTDRAWSURFACE7 lpddsprimary;
extern LPDIRECTDRAWSURFACE7 lpddsback;
extern DDSURFACEDESC2 ddsd;
extern RECT src, dst;
extern HRESULT res;
extern INT32 pitchindwords;

extern GFX_INFO gfx;
extern UINT8* rdram_8;
extern UINT16* rdram_16;
extern UINT32 plim;
extern UINT32 idxlim16;
extern UINT32 idxlim32;
extern UINT8 hidden_bits[0x400000];

extern int overlay;
extern onetime onetimewarnings;
extern UINT32 gamma_table[0x100];
extern UINT32 gamma_dither_table[0x4000];
extern INT32 vi_restore_table[0x400];
extern INT32 oldvstart;
extern INT32* PreScale;

extern INLINE void popmessage(const char* err, ...);
extern INLINE void fatalerror(const char* err, ...);
extern STRICTINLINE INT32 irand(void);
extern void rdp_init(void);
extern void rdp_close(void);
extern void rdp_update(void);

#endif
