#ifndef _VI_H_
#define _VI_H_

#include <GL/gl.h>
#include <Windows.h>

#include "Gfx #1.3.h"
#include "z64.h"

extern unsigned char cfg[32];

extern GLuint screen[PRESCALE_HEIGHT][PRESCALE_WIDTH];

typedef struct {
    unsigned char r, g, b, cvg;
} CCVG;

typedef struct {
    int ntscnolerp;
    int copymstrangecrashes;
    int fillmcrashes;
    int fillmbitcrashes;
    int syncfullcrash;
} onetime;

typedef struct {
    UINT8 cvg;
    UINT8 cvbit;
    UINT8 xoff;
    UINT8 yoff;
} CVtcmaskDERIVATIVE;

extern HGLRC render_context;
extern HDC device_context;
extern const PIXELFORMATDESCRIPTOR pixel_format;

extern RECT src, dst;
extern HRESULT res;
extern INT32 pitchindwords;

extern BOOL sync;
extern int is_full_screen;

extern GFX_INFO gfx;
extern UINT8* rdram_8;
extern UINT16* rdram_16;
extern UINT32 plim;
extern UINT32 idxlim16;
extern UINT32 idxlim32;
extern UINT8 hidden_bits[0x400000];

extern onetime onetimewarnings;

extern GLuint* PreScale;
extern UINT32 gamma_table[0x100];
extern UINT32 gamma_dither_table[0x4000];
extern INT32 vi_restore_table[0x400];
extern INT32 oldvstart;
extern int hres_old, vres_old; /* for optional FB size change detection */

extern NOINLINE void DisplayError(char * error);
extern NOINLINE void DisplayGLError(char * text, GLenum error);

extern NOINLINE void zerobuf(void * memory, size_t length);
extern NOINLINE int file_in(char* path, void* data, unsigned long length);
extern NOINLINE void file_out(char* path, void* data, unsigned long length);
extern NOINLINE void screen_resize(GLsizei width, GLsizei height);
extern NOINLINE void get_screen_size(int* dimensions);

extern STRICTINLINE INT32 irand(void);
extern void rdp_init(void);
extern void rdp_close(void);
extern void rdp_update(void);

#endif
