RASTERSTART	EQU 97
RASTEREND	EQU RASTERSTART+22
SCROLLSTART	EQU RASTERSTART+8
SCROLLEND	EQU SCROLLSTART+9
BKGCOLOR	EQU	0x0080			; Raster color index
SCRPOS		EQU	0x0081			; Hardware scroll pos
VBLANK		EQU	0x0082			; VBlank indicator
SINECOUNTER	EQU	0x0083			; VBlank indicator
RASCOUNTER	EQU	0x0084			; Raster line counter
SCRCOUNTER	EQU	0x0086			; Scroll text counter

Segment0:
times 65536-$+Segment0 db 0
Segment1:
times 65536-$+Segment1 db 0
Segment2:
times 65536-$+Segment2 db 0
Segment3:
times 65536-$+Segment3 db 0
Segment4:
times 65536-$+Segment4 db 0
Segment5:
times 65536-$+Segment5 db 0
Segment6:
times 65536-$+Segment6 db 0
Segment7:
times 65536-$+Segment7 db 0
Segment8:
times 65536-$+Segment8 db 0
Segment9:
times 65536-$+Segment9 db 0
SegmentA:
times 65536-$+SegmentA db 0
SegmentB:
times 65536-$+SegmentB db 0
SegmentC:
times 65536-$+SegmentC db 0
SegmentD:
times 65536-$+SegmentD db 0
SegmentE:
times 65536-$+SegmentE db 0

SegmentF:
Start:
	cli

	xor		ax, ax
	mov		bx, ax
	mov		cx, ax
	mov		dx, ax
	mov		es, ax
	mov		ds, ax
	mov		bp, ax
	mov		ss, ax
	mov		sp, 0x8000

	xor		ax,ax			; Turn off FG/BG/sprites?
	out		0x00, ax

	in		al, 0xA0		; Machine type?
	test	al, 02
	jne		CorrectMachine

	nop						; Handle bad machine

CorrectMachine:
	in		al, 0x60		; Set color mode (4 bits per tile)
	or		al, 0x40
	out		0x60, al

	xor		ax, ax
	mov		es, ax
	mov		di, 0x0080		; Clear from 000080 to 00FE00
	mov		cx, 0x7EC0
	xor		ax, ax
	cld
	rep		stosw

	call	InterruptSetup
	call	TransferScreen
	call	ScreenSetup
	call	SpriteSetup

	mov		al, 0x00
	mov		[BKGCOLOR], al		; Set background color index
	mov		[SCRPOS], al        ; Set hardware scroll position
	mov		[VBLANK], al		; Set Vblank
	mov		[SINECOUNTER], al	; Set Vblank
	mov		[RASCOUNTER], ax    ; Set raster counter
	mov		[SCRCOUNTER], ax	; Set scroll position

	sti

GameLoop:
	mov		al, [VBLANK]
	cmp		al, 0
	je		GameLoop

	mov		al, 0
	mov		[VBLANK], al

	mov		di, 0x1C02

	xor		bx, bx
	mov		bl, [SINECOUNTER]
	inc		bl

	cmp		bl, 30
	jb		StoreSine

	xor		bx, bx

StoreSine:
	mov		[SINECOUNTER], bl
    mov		si, SineTable
	add		si, bx

	mov		ax, 0x0000
	mov		es, ax

	mov		ax, 0xF000
	mov		ds, ax

	mov		cx, 5

LetterLoop:
	mov		al, [si]

	mov		[es:di], al
	add		di, 4
	add		al, 8
	mov		[es:di], al
	add		di, 4

	sub		al, 8
	mov		[es:di], al
	add		di, 4
	add		al, 8
	mov		[es:di], al
	add		di, 4

	add		si, 6

	cmp		si, SineTable+30
	jb		NoAdjust

	sub		si, 30

NoAdjust:
	dec		cx
	jne		LetterLoop

	mov		ax, 0x0000
	mov		ds, ax

	jmp		GameLoop

InterruptSetup:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es
	push	bx

	mov		bx, 0x0000			; Set divide by zero interrupt
	mov		ax, Interrupt0
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0004			; Set single step interrupt
	mov		ax, Interrupt1
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0008			; Set non-maskable interrupt
	mov		ax, Interrupt2
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x000C			; Set breakpoint interrupt
	mov		ax, Interrupt3
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0010			; Set overflow interrupt
	mov		ax, Interrupt4
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0014			; Set print screen interrupt(?)
	mov		ax, Interrupt5
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	mov		al, 0x08			; Set interrupt base to 8h
	out		0xb0, al
	push	bx
	mov		bx, 0x0020			; Set serial transmit interrupt
	mov		ax, TransmitInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0024			; Set key press interrupt
	mov		ax, KeyInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0028			; Set RTC alarm interrupt
	mov		ax, RtcInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x002C			; Set serial receive interrupt
	mov		ax, ReceiveInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0030			; Set drawing line detection interrupt
	mov		ax, DrawLineInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0034			; Set vblank end interrupt
	mov		ax, VBlankEndInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0038			; Set vblank begin interrupt
	mov		ax, VBlankBeginInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x003C			; Set hblank interrupt
	mov		ax, HBlankInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx

	mov		ax, 0x0000			; ?
	out		0xA4, ax

	mov		ax, 0x0000			; ?
	out		0xA6, ax

	mov		al, 0x0F			; Possibly interrupt ignore?
	out		0xA2, al

	mov		al, 0xC0			; Turn on HBLANK | VBLANK begin
	out		0xB6, al

	mov		al, 0xC0			; Acknowledge (clear) HBLANK | VBLANK end interrupts
	out		0xB2, al

	pop		es
	pop		ds
	pop		bp
	pop		di
	pop		si
	pop		dx
	pop		cx
	pop		bx
	pop		ax

	ret

ScreenSetup:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov		al, 0x20			; Set foreground screen location
    out		0x07, al			; Set locations

	mov		al, 0x00			; Set background palette
	out		0x01, al

	xor		ax, ax
	mov		es, ax
	mov		di, 0xFE00

	mov		ax, 0xF000			; Set color palette
	mov		ds, ax
	mov		si, Palette
    mov		cx, 48

	rep		movsw

	mov		di, 0xFF00
	mov		si, Palette
    mov		cx, 4

	rep		movsw

	mov		ax, 0x0000			; Set scroll positions
	out		0x10, ax
	out		0x12, ax
    mov		al, 0x06			; Turn on Foreground and sprites
	out		0x00, al

    xor		al, al 				; Turn transparency off
    out		0x15, al

    in		al, 0x14			; Turn on LDC(?)
    or		al, 0x01
    out		0x14, al

	pop		es
	pop		ds
	pop		bp
	pop		di
	pop		si
	pop		dx
	pop		cx
	pop		bx
	pop		ax

	ret

SpriteSetup:
	push	ds
	push	es
	push	ax

	mov		ax, 0x1c00			; Set sprite table location
	shr		ax, 9
	out		0x04, al

	xor		ax, ax				; Set first and last sprites
	out		0x05, al
	mov		ax, 21
	out		0x06, al

	mov		ax, 0x0000
	mov		es, ax
	mov		di, 0x1c00

	mov		ax, 0xF000
	mov		ds, ax
	mov		si, SpriteTable

	mov		cx, 20*2

	rep		movsw

	pop		ax
	pop		es
	pop		ds

	ret

TransferScreen:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov		ax, 0x0000
	mov		es, ax
	mov		di, 0x2000
	mov		ax, 0xF000
	mov		ds, ax
	mov		si, Font			; Transfer tiles
	mov		cx, 2368/2

	cld
	rep		movsw

	mov		di, 0x1000          ; Transfer map
	mov		si, Map
	mov		cx, 1152/2

	cld
	rep		movsw

	pop		es
	pop		ds
	pop		bp
	pop		di
	pop		si
	pop		dx
	pop		cx
	pop		bx
	pop		ax

	ret

Interrupt0:
	mov		al, 0x38			; ?
	out		0x15, al
	iret

Interrupt1:
	iret

Interrupt2:
	iret

Interrupt3:
	iret

Interrupt4:
	iret

Interrupt5:
	iret

TransmitInterrupt:
	push	ax
	mov		al, 1
	out		0xB6, al
	pop		ax

	iret

KeyInterrupt:
	push	ax
	mov		al, 2
	out		0xB6, al
	pop		ax

	iret

RtcInterrupt:
	push	ax
	mov		al, 4
	out		0xB6, al
	pop		ax

	iret

ReceiveInterrupt:
	push	ax
	mov		al, 8
	out		0xB6, al
	pop		ax

	iret

DrawLineInterrupt:
	push	ax
	mov		al, 10h
	out		0xB6, al
	pop		ax

	iret

VBlankEndInterrupt:
	push	ax

	mov		al, 20h
	out		0xB6, al

	pop		ax

	iret

VBlankBeginInterrupt:
	push	ax

	mov		ax, 0
	mov		[RASCOUNTER], ax

	mov		al, 1
    mov		[VBLANK], al

	mov		al, 40h
	out		0xB6, al

	pop		ax

	iret

HBlankInterrupt:
	push	ax
	push	ds
	push	es

	mov		ax, [RASCOUNTER]
	inc		ax					; Increment color register
	mov		[RASCOUNTER], ax

	cmp		ax, RASTERSTART
	jbe		EndHBlank

	cmp		ax, RASTEREND
	je		EndRaster
	ja		EndHBlank

	xor		ax, ax
	mov		al, [BKGCOLOR]
	add		al, 2				; Increment color register
	mov		[BKGCOLOR], al

    mov		bx, RasterTable
    add		bx, ax

	mov		ax, 0xF000
	mov		es, ax

	mov		ax, [es:bx]

	mov		[0xFE00], ax

	mov		ax, [RASCOUNTER]

	cmp		ax, SCROLLEND
	jb		CheckScroll
	ja		EndHBlank

	mov		al, 0
	out		0x12, al

	jmp		EndHBlank

CheckScroll:
	cmp		ax, SCROLLSTART
	jne		EndHBlank

	mov		al, [SCRPOS]
	out		0x12, al

	inc		al
	mov		[SCRPOS], al

	cmp		al, 8
	jb		EndHBlank

	mov		al, 0
	mov		[SCRPOS], al

EndHBlank:
	mov		al, 80h
	out		0xB6, al

	pop		es
	pop		ds
	pop		ax

	iret

EndRaster:
	mov		ax, 0x0000
	mov		ds, ax
	mov		es, ax

	mov		ax, 0x0000
	mov		[BKGCOLOR], al
	mov		[0xFE00], ax

	mov		al, [SCRPOS]
	cmp		al, 0
	jne		EndHBlank

	mov		si, 0x1342
	mov		di, 0x1340

	mov		cx, 28*2

	cld
	rep		movsw

	mov		ax, 0xF000
	mov		es, ax

	mov		ax, [SCRCOUNTER]
	inc		ax
	mov		[SCRCOUNTER], ax

CalcLetter:
	mov		bx, ScrollText
	add		bx, ax

	xor		ax, ax

	mov		al, [es:bx]

	cmp		al, 0
	jne		WriteScroll

	mov		ax, 0
	mov		[SCRCOUNTER], ax

	jmp		CalcLetter

WriteScroll:
	mov		[0x1378], ax

	jmp		EndHBlank

Font:
	incbin	"Font.bin"

Map:
	incbin	"Map.bin"

Palette:
	dw	0x0000, 0x0FFF, 0x0F00, 0x000F
	dw	0x0000, 0x0FFF, 0x0F00, 0x000F
	dw	0x0000, 0x0FFF, 0x0F00, 0x000F
	dw	0x0000, 0x0FFF, 0x0F00, 0x000F
	dw	0x000F, 0x000F, 0x0000, 0x0000
	dw	0x000F, 0x000F, 0x0000, 0x0000
	dw	0x000F, 0x000F, 0x0000, 0x0000
	dw	0x000F, 0x000F, 0x0000, 0x0000
	dw	0x000F, 0x0F00, 0x0000, 0x0000
	dw	0x000F, 0x0F00, 0x0000, 0x0000
	dw	0x000F, 0x0F00, 0x0000, 0x0000
	dw	0x000F, 0x0F00, 0x0000, 0x0000

RasterTable:
	dw	0x0002, 0x0004, 0x0006, 0x0008, 0x000A, 0x000C, 0x000E, 0x000F
	dw	0x000F, 0x000F, 0x000F, 0x000F, 0x000F, 0x000F, 0x000F, 0x000E
	dw	0x000C, 0x000A, 0x0008, 0x0006, 0x0004, 0x0002

ScrollText:
	db	" This is 'our' spiffy color demo for the Wonderswan Colors. It's still cheesy, but "
	db	"hey it has color, and this demo includes source. Thanks to Judge_ and Dox for the "
	db	"documents and the wscdev mailing list for all the information on the list. Yes this "
	db	"demo is in Red, White, and Blue and yes I'm an American. As 'bad' as the government "
	db	"can be, it's still an excellent place to live. Just look at New York, the people "
	db	"have a reputation of being pretty rude, but during the WTC event they pulled together "
	db	"and did whatever needed to be done to help each other. Visit the Chaos website at "
	db	"http://www.Chaos89.com. This demo was written by Raster (cdoty@netzero.net). "
	db	" ..WRAP HERE.. ...*ERRRR* I MEANT HERE :)...  ", 0

SpriteTable:
	dw	0x2080	; Sprite 1
	dw	0x4818	; Location
	dw	0x2081	; Sprite 2
	dw	0x4820	; Location
	dw	0x2082	; Sprite 3
	dw	0x5018	; Location
	dw	0x2083	; Sprite 4
	dw	0x5020	; Location

	dw	0x2084	; Sprite 5
	dw	0x5818	; Location
	dw	0x2085	; Sprite 6
	dw	0x5820	; Location
	dw	0x2086	; Sprite 7
	dw	0x6018	; Location
	dw	0x2087	; Sprite 8
	dw	0x6020	; Location

	dw	0x2088	; Sprite 9
	dw	0x6818	; Location
	dw	0x2089	; Sprite 10
	dw	0x6820	; Location
	dw	0x208A	; Sprite 11
	dw	0x7018	; Location
	dw	0x208B	; Sprite 12
	dw	0x7020	; Location

	dw	0x208C	; Sprite 13
	dw	0x7818	; Location
	dw	0x208D	; Sprite 14
	dw	0x7820	; Location
	dw	0x208E	; Sprite 15
	dw	0x8018	; Location
	dw	0x208F	; Sprite 16
	dw	0x8020	; Location

	dw	0x2090	; Sprite 17
	dw	0x8818	; Location
	dw	0x2091	; Sprite 18
	dw	0x8820	; Location
	dw	0x2092	; Sprite 19
	dw	0x9018	; Location
	dw	0x2093	; Sprite 20
	dw	0x9020	; Location

SineTable:
	db	24, 25, 26, 28, 28, 29, 30, 30
	db	30, 30, 29, 28, 28, 26, 25, 24
	db	23, 22, 21, 20, 19, 18, 18, 18
	db	18, 19, 19, 20, 21, 23

times 65520-$+SegmentF db	0
	db	0xEA	; jmpf
	dw	Start	; Start
	dw	0xF000	; In bank 0xF000
	db	0x00

Header:
	db	0xCD	; Developer ID
	db	0x01	; Wonderswan color(?)
	db	0x01	; Cart number
	db	0x00	; ?
	db	0x03	; Cart Size (8 Mb)
	db	0x00	; SRAM size (0 k)
	db	0x04	; Horizontal game
	db	0x00	; ?
	dw	0x0000	; Checksum (?)
