#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#define romsize 512*1024 //minimal ROM size for wondermagic is 4 mbits

#define BYTE unsigned char


BYTE  rom[romsize];
FILE *p1;
long rozmiar;
char ident[]="Com2ws 1.0  (c)dox@space.pl"; //why not ;)
int i,checksum;

int main(int argc, char* argv[])
{
	printf("Com2ws 1.0  (c)dox@space.pl\n");
	memset(rom,0,sizeof(rom));
	if(argc<3)
	{
		printf(" usage: com2ws.exe file.com file.ws\n");
		return -1;
	}
    p1=fopen(argv[1],"rb");
    fseek(p1,0,SEEK_END);
	rozmiar=ftell(p1);
	fseek(p1,0,SEEK_SET);
	fread(&rom[0x100],1,rozmiar,p1);
	fclose(p1);
    memcpy(rom,ident,sizeof(ident));
    for(checksum=i=0; i<romsize-2; checksum+=rom[i], i++);
    checksum&= 0xFFFF;
    rom[romsize-1]=checksum>>8;
    rom[romsize-2]=checksum&0xff; //checksum
    rom[romsize-4]=4; //horizontal
    rom[romsize-6]=1; //rom size
    rom[romsize-16]=0xea;//jump to start of code 
    rom[romsize-15]=0x00; 
    rom[romsize-14]=0x01; 
    rom[romsize-12]=0x80; 
    rom[romsize-9]=0x1; //IMPORTANT !!! wonderswan color
    p1=fopen(argv[argc-1],"wb");
    fwrite(rom,1,romsize,p1);
    fclose(p1);
    return 0;
}

