RASTERSTART	EQU 97
RASTEREND	EQU RASTERSTART+22
SCROLLSTART	EQU RASTERSTART+8
SCROLLEND	EQU SCROLLSTART+9
BKGCOLOR	EQU	0x0080			; Raster color index
SCRPOS		EQU	0x0081			; Hardware scroll pos
RASCOUNTER	EQU	0x0082			; Raster line counter
SCRCOUNTER	EQU	0x0084			; Scroll text counter

Segment0:
times 65536-$+Segment0 db 0
Segment1:
times 65536-$+Segment1 db 0
Segment2:
times 65536-$+Segment2 db 0
Segment3:
times 65536-$+Segment3 db 0
Segment4:
times 65536-$+Segment4 db 0
Segment5:
times 65536-$+Segment5 db 0
Segment6:
times 65536-$+Segment6 db 0
Segment7:
times 65536-$+Segment7 db 0
Segment8:
times 65536-$+Segment8 db 0
Segment9:
times 65536-$+Segment9 db 0
SegmentA:
times 65536-$+SegmentA db 0
SegmentB:
times 65536-$+SegmentB db 0
SegmentC:
times 65536-$+SegmentC db 0
SegmentD:
times 65536-$+SegmentD db 0
SegmentE:
times 65536-$+SegmentE db 0

SegmentF:
Start:
	cli

	xor		ax, ax
	mov		bx, ax
	mov		cx, ax
	mov		dx, ax
	mov		es, ax
	mov		ds, ax
	mov		bp, ax
	mov		ss, ax
	mov		sp, 0xFF00

	xor		ax,ax		; Turn off FG/BG/sprites?
	out		0, ax

;	in		al, 0xA0	; Machine type?
;	test	al, 02
;	jne		CorrectMachine

;	nop					; Handle bad machine

CorrectMachine:
;	in		al, 0x60		; ?
;	or		al, 0xC0
;	out		0x60, al

	xor		ax, ax
	mov		es, ax
	mov		di, 0x0080		; Clear from 000080 to 00FE00
	mov		cx, 0x7EC0
	xor		ax, ax
	cld
	rep		stosw

	call	InterruptSetup
	call	TransferScreen
	call	ScreenSetup
	call	SpriteSetup

	mov		al, 0x00
	mov		[BKGCOLOR], al		; Set background color index
	mov		[SCRPOS], al        ; Set hardware scroll position
	mov		[RASCOUNTER], ax    ; Set raster counter
	mov		[SCRCOUNTER], ax	; Set scroll position

	sti

GameLoop:
	jmp		GameLoop

InterruptSetup:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es
	push	bx

	mov		bx, 0x0000			; Set divide by zero interrupt
	mov		ax, Interrupt0
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0004			; Set single step interrupt
	mov		ax, Interrupt1
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0008			; Set non-maskable interrupt
	mov		ax, Interrupt2
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x000C			; Set breakpoint interrupt
	mov		ax, Interrupt3
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0010			; Set overflow interrupt
	mov		ax, Interrupt4
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0014			; Set print screen interrupt(?)
	mov		ax, Interrupt5
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	mov		al, 0x08			; Set interrupt base to 8h
	out		0xb0, al
	push	bx
	mov		bx, 0x0020			; Set serial transmit interrupt
	mov		ax, TransmitInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0024			; Set key press interrupt
	mov		ax, KeyInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0028			; Set RTC alarm interrupt
	mov		ax, RtcInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x002C			; Set serial receive interrupt
	mov		ax, ReceiveInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0030			; Set drawing line detection interrupt
	mov		ax, DrawLineInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0034			; Set vblank end interrupt
	mov		ax, VBlankEndInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x0038			; Set vblank begin interrupt
	mov		ax, VBlankBeginInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx
	push	bx
	mov		bx, 0x003C			; Set hblank interrupt
	mov		ax, HBlankInterrupt
	mov		[ss:bx], ax
	mov		ax, 0xF000
	mov		[ss:bx+2], ax
	pop		bx

	mov		ax, 0x0000			; ?
	out		0xA4, ax

	mov		ax, 0x0000			; ?
	out		0xA6, ax

	mov		al, 0x0F			; Possibly interrupt ignore?
	out		0xA2, al

	mov		al, 0xC0			; Turn on HBLANK | VBLANK begin
	out		0xB6, al

	mov		al, 0xC0			; Acknowledge (clear) HBLANK | VBLANK end interrupts
	out		0xB2, al

	pop		es
	pop		ds
	pop		bp
	pop		di
	pop		si
	pop		dx
	pop		cx
	pop		bx
	pop		ax

	ret

ScreenSetup:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es
	push	ss
	pop		ds

	mov		al, 0x20			; Set foreground screen location
    out		0x07, al			; Set locations

	mov		ax, 0x0000			; Set scroll positions
	out		0x10, ax
	out		0x12, ax

	mov		ax, 0x8ACF			; Set colors to use
	out		0x1C, ax
	mov		ax, 0x0246
	out		0x1E, ax

	mov		ax, 0x7560			; Set palette colors
	out		0x20, ax
	mov		ax, 0x7650			; Set palette colors
	out		0x22, ax
	out		0x24, ax
	out		0x26, ax
	out		0x28, ax
	out		0x2a, ax
	out		0x2c, ax
	out		0x2e, ax

    mov		al, 2				; Turn on Foreground
	out		0x00, al

    xor		al, al 				; Turn transparency off
    out		0x15, al

    in		al, 0x14			; Turn on LDC(?)
    or		al, 0x01
    out		0x14, al

	pop		es
	pop		ds
	pop		bp
	pop		di
	pop		si
	pop		dx
	pop		cx
	pop		bx
	pop		ax

	ret

SpriteSetup:
	push	ds
	push	ax
	push	ss
	pop		ds

	mov		ax, 0x1c00			; Set sprite table location
	shr		ax, 9
	out		04h, al

	xor		ax, ax				; Set first and last sprites
	out		05h, al
	out		06h, al

	pop		ax
	pop		ds

	ret

TransferScreen:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es

	mov		ax, 0x0000
	mov		es, ax
	mov		di, 0x2000
	mov		ax, 0xF000
	mov		ds, ax
	mov		si, Font			; Transfer tiles
	mov		cx, 2368/2

	cld
	rep		movsw

	mov		di, 0x1000          ; Transfer map
	mov		si, Map
	mov		cx, 1152/2

	cld
	rep		movsw

	pop		es
	pop		ds
	pop		bp
	pop		di
	pop		si
	pop		dx
	pop		cx
	pop		bx
	pop		ax

	ret

Interrupt0:
	mov		al, 0x38			; ?
	out		0x15, al
	iret

Interrupt1:
	iret

Interrupt2:
	iret

Interrupt3:
	iret

Interrupt4:
	iret

Interrupt5:
	iret

TransmitInterrupt:
	push	ax
	mov		al, 1
	out		0xB6, al
	pop		ax

	iret

KeyInterrupt:
	push	ax
	mov		al, 2
	out		0xB6, al
	pop		ax

	iret

RtcInterrupt:
	push	ax
	mov		al, 4
	out		0xB6, al
	pop		ax

	iret

ReceiveInterrupt:
	push	ax
	mov		al, 8
	out		0xB6, al
	pop		ax

	iret

DrawLineInterrupt:
	push	ax
	mov		al, 10h
	out		0xB6, al
	pop		ax

	iret

VBlankEndInterrupt:
	push	ax
	mov		al, 20h
	out		0xB6, al
	pop		ax

	iret

VBlankBeginInterrupt:
	push	ax

	mov		ax, 0
	mov		[RASCOUNTER], ax

	mov		al, 40h
	out		0xB6, al
	pop		ax

	iret

HBlankInterrupt:
	push	ax
	push	ds
	push	es

	mov		ax, [RASCOUNTER]
	inc		ax					; Increment color register
	mov		[RASCOUNTER], ax

	cmp		ax, RASTERSTART
	jbe		EndHBlank

	cmp		ax, RASTEREND
	je		EndRaster
	ja		EndHBlank

	xor		ax, ax
	mov		al, [BKGCOLOR]
	inc		al					; Increment color register
	mov		[BKGCOLOR], al

    mov		bx, RasterTable
    add		bx, ax

	mov		ax, 0xF000
	mov		es, ax

	mov		al, [es:bx]

	out		0x1c, al

	mov		ax, [RASCOUNTER]

	cmp		ax, SCROLLEND
	jb		CheckScroll
	ja		EndHBlank

	mov		al, 0
	out		0x12, al

	jmp		EndHBlank

CheckScroll:
	cmp		ax, SCROLLSTART
	jne		EndHBlank

	mov		al, [SCRPOS]
	out		0x12, al

	inc		al
	mov		[SCRPOS], al

	cmp		al, 8
	jb		EndHBlank

	mov		al, 0
	mov		[SCRPOS], al

EndHBlank:
	mov		al, 80h
	out		0xB6, al

	pop		es
	pop		ds
	pop		ax

	iret

EndRaster:
	xor		al, al
	mov		[BKGCOLOR], al
	mov		al, 0x0F
	out		0x1c, al

	mov		al, [SCRPOS]
	cmp		al, 0
	jne		EndHBlank

	mov		si, 0x1342
	mov		di, 0x1340

	mov		ax, 0x0000
	mov		ds, ax
	mov		es, ax

	mov		cx, 28*2

	cld
	rep		movsw

	mov		ax, 0xF000
	mov		es, ax

	mov		ax, [SCRCOUNTER]
	inc		ax
	mov		[SCRCOUNTER], ax

CalcLetter:
	mov		bx, ScrollText
	add		bx, ax

	xor		ax, ax

	mov		al, [es:bx]

	cmp		al, 0
	jne		WriteScroll

	mov		ax, 0
	mov		[SCRCOUNTER], ax

	jmp		CalcLetter

WriteScroll:
	mov		[0x1378], ax

	jmp		EndHBlank

Font:
	incbin	"Font.bin"

Map:
	incbin	"Map.bin"

RasterTable:
	db	0x07, 0x06, 0x05, 0x04, 0x03, 0x02, 0x01, 0x00
	db	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
	db	0x02, 0x03, 0x04, 0x05, 0x06, 0x07

ScrollText:
	db	" This is 'our' demo for the Wonderswan. It's a cheesy little demo, but we have to start"
	db	" somewhere. And this 'first' demo includes source. This is a NEO *err* new beginning for "
	db	"*ELITE* type demos. Hopefully we'll see a few more demos, and maybe color. WRAP HERE..", 0

times 65520-$+SegmentF db	0
	db	0xEA	; jmpf
	dw	Start	; Start
	dw	0xF000	; In bank 0xF000
	db	0x00

Header:
	db	0xCD	; Developer ID
	db	0x01	; Wonderswan color(?)
	db	0x01	; Cart number
	db	0x00	; ?
	db	0x03	; Cart Size (8 Mb)
	db	0x00	; SRAM size (0 k)
	db	0x04	; Horizontal game
	db	0x00	; ?
	dw	0x0000	; Checksum (?)
