VERSION 5.00
Begin VB.Form frmMainWnd 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "vb81"
   ClientHeight    =   3735
   ClientLeft      =   150
   ClientTop       =   720
   ClientWidth     =   4140
   Icon            =   "frmMainWnd.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   249
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   276
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox picToolbar 
      BorderStyle     =   0  'None
      Height          =   510
      Left            =   0
      ScaleHeight     =   34
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   815
      TabIndex        =   1
      Top             =   60
      Visible         =   0   'False
      Width           =   12225
      Begin VB.CommandButton cmdMemoCalc 
         Height          =   375
         Left            =   600
         Picture         =   "frmMainWnd.frx":0442
         Style           =   1  'Graphical
         TabIndex        =   3
         TabStop         =   0   'False
         ToolTipText     =   "Memocalc"
         Top             =   60
         UseMaskColor    =   -1  'True
         Width           =   375
      End
      Begin VB.CommandButton cmdReset 
         Height          =   375
         Left            =   120
         Picture         =   "frmMainWnd.frx":0544
         Style           =   1  'Graphical
         TabIndex        =   2
         TabStop         =   0   'False
         ToolTipText     =   "Reset ZX81"
         Top             =   60
         Width           =   375
      End
      Begin VB.Line Line1 
         BorderColor     =   &H80000014&
         Index           =   2
         X1              =   815
         X2              =   0
         Y1              =   33
         Y2              =   33
      End
      Begin VB.Line Line1 
         BorderColor     =   &H80000010&
         Index           =   3
         X1              =   815
         X2              =   0
         Y1              =   32
         Y2              =   32
      End
   End
   Begin VB.PictureBox picDisplay 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00E0E0E0&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   2880
      Left            =   120
      ScaleHeight     =   192
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   259
      TabIndex        =   0
      Top             =   180
      Width           =   3885
   End
   Begin VB.Line Line1 
      BorderColor     =   &H80000014&
      Index           =   1
      X1              =   815
      X2              =   -1
      Y1              =   1
      Y2              =   1
   End
   Begin VB.Line Line1 
      BorderColor     =   &H80000010&
      Index           =   0
      X1              =   815
      X2              =   -1
      Y1              =   0
      Y2              =   0
   End
   Begin VB.Menu mnuFileMain 
      Caption         =   "&File"
      Begin VB.Menu mnuFile 
         Caption         =   "Specify tape &directory..."
         Index           =   1
      End
      Begin VB.Menu mnuFile 
         Caption         =   "-"
         Index           =   2
      End
      Begin VB.Menu mnuFile 
         Caption         =   "&Reset ZX81"
         Index           =   3
      End
      Begin VB.Menu mnuFile 
         Caption         =   "-"
         Index           =   4
      End
      Begin VB.Menu mnuFile 
         Caption         =   "E&xit"
         Index           =   5
      End
   End
   Begin VB.Menu mnuOptionsMain 
      Caption         =   "&Options"
      Begin VB.Menu mnuOptions 
         Caption         =   "&Display size"
         Index           =   1
         Begin VB.Menu mnuOptionsDisplay 
            Caption         =   "&Standard (256 x 192)"
            Checked         =   -1  'True
            Index           =   1
            Shortcut        =   +{F5}
         End
         Begin VB.Menu mnuOptionsDisplay 
            Caption         =   "-"
            Index           =   2
         End
         Begin VB.Menu mnuOptionsDisplay 
            Caption         =   "Double &Width (512 x 192)"
            Index           =   3
            Shortcut        =   +{F6}
         End
         Begin VB.Menu mnuOptionsDisplay 
            Caption         =   "Double &Height (256 x 384)"
            Index           =   4
            Shortcut        =   +{F7}
         End
         Begin VB.Menu mnuOptionsDisplay 
            Caption         =   "&Double Size (512 x 384)"
            Index           =   5
            Shortcut        =   +{F8}
         End
         Begin VB.Menu mnuOptionsDisplay 
            Caption         =   "-"
            Index           =   6
         End
         Begin VB.Menu mnuOptionsDisplay 
            Caption         =   "&Triple Size (768 x 576)"
            Index           =   7
            Shortcut        =   +{F9}
         End
      End
      Begin VB.Menu mnuOptions 
         Caption         =   "-"
         Index           =   2
      End
      Begin VB.Menu mnuOptions 
         Caption         =   "Show &toolbar"
         Index           =   3
         Shortcut        =   +{F3}
      End
      Begin VB.Menu mnuOptions 
         Caption         =   "&Colors..."
         Index           =   4
      End
      Begin VB.Menu mnuOptions 
         Caption         =   "Allow &Writes to Shadow ROM (8-16K area)"
         Index           =   5
      End
   End
   Begin VB.Menu mnuHelpMain 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelp 
         Caption         =   "ZX81 &Keyboard"
         Index           =   1
         Shortcut        =   {F1}
      End
      Begin VB.Menu mnuHelp 
         Caption         =   "-"
         Index           =   2
      End
      Begin VB.Menu mnuHelp 
         Caption         =   "&About vb81..."
         Index           =   3
      End
   End
End
Attribute VB_Name = "frmMainWnd"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' /*******************************************************************************
'   frmMainWnd.frm within vb81.vbp
'
'   Main application window for vb81
'
'   Author: Chris Cowley <ccowley@grok.co.uk>
'
'   Copyright (C)2000  Grok Developments Ltd.
'   http://www.grok.co.uk/
'
'   This program is free software; you can redistribute it and/or
'   modify it under the terms of the GNU General Public License
'   as published by the Free Software Foundation; either version 2
'   of the License, or (at your option) any later version.
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'
' *******************************************************************************/

Option Explicit

Private Sub cmdMemoCalc_Click()
    If bDisplayShown Then
        picDisplay.SetFocus
    End If
    frmMemoCalc.Show 1
End Sub

Private Sub cmdReset_Click()
    If bDisplayShown Then
        picDisplay.SetFocus
    End If
    Z80Reset
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    If (Shift And 4) = 0 Then
        ' // Only do a ZX81 keypress if ALT is not being pressed
        doKey True, KeyCode, Shift
    End If
End Sub

Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)
    doKey False, KeyCode, Shift
End Sub


Private Sub Form_Resize()
    If Width > 10000 Then
        picDisplay.Width = 768
    ElseIf Width > 5000 Then
        picDisplay.Width = 512
    Else
        picDisplay.Width = 256
    End If
    
    If Height > 9000 Then
        picDisplay.Height = 576
    ElseIf Height > 5000 Then
        picDisplay.Height = 384
    Else
        picDisplay.Height = 192
    End If
    
End Sub

Private Sub Form_Unload(Cancel As Integer)
    timeEndPeriod 1
    End
End Sub




Private Sub mnuFile_Click(Index As Integer)
    Select Case Index
    Case 1 ' // Specify tape dir
        frmSelectDir.Show vbModal
    Case 3 ' // Reset Z80
        Z80Reset
    Case 5 ' // Exit
        Unload Me
    End Select

    resetKeyboard
End Sub


Private Sub mnuHelp_Click(Index As Integer)
    Select Case Index
    Case 1 ' // ZX81 Keyboard
        frmKeyboard.Show vbModeless
    Case 3 ' About
        frmAbout.Show vbModal
    End Select
    
    resetKeyboard
End Sub

Public Sub mnuOptions_Click(Index As Integer)
    If Index = 3 Then mnuOptions(3).Checked = Not mnuOptions(3).Checked
    If Index = 5 Then mnuOptions(5).Checked = Not mnuOptions(5).Checked

    Select Case Index
    Case 3 ' // Toggle toolbar
        If (mnuOptions(3).Checked) Then
            SaveSetting "Grok", "vb81", "ShowToolbar", "1"
            frmMainWnd.Height = frmMainWnd.Height + picToolbar.Height * Screen.TwipsPerPixelY
            picToolbar.Visible = True
            picDisplay.Top = picToolbar.Height + 12
        Else
            SaveSetting "Grok", "vb81e", "ShowToolbar", "0"
            frmMainWnd.Height = frmMainWnd.Height - picToolbar.Height * Screen.TwipsPerPixelY
            picToolbar.Visible = False
            picDisplay.Top = 12
        End If
    Case 4
        frmOptions.Show 1
    Case 5
        ' // Toggle "Allow writes to ROM area"
        If (mnuOptions(5).Checked) Then
            SaveSetting "Grok", "vb81", "AllowWritesToROM", "1"
            bAllowWritesToROM = True
        Else
            SaveSetting "Grok", "vb81", "AllowWritesToROM", "0"
            bAllowWritesToROM = False
        End If
    End Select
    
    resetKeyboard
End Sub

Public Sub mnuOptionsDisplay_Click(Index As Integer)
    Dim i As Integer, y As Long, x As Long
    
    y = (GetSystemMetrics(SM_CYCAPTION) + GetSystemMetrics(SM_CYMENU) + GetSystemMetrics(SM_CYFRAME) * 2) * Screen.TwipsPerPixelY
    x = (GetSystemMetrics(SM_CXFRAME) * 2) * Screen.TwipsPerPixelX
    
    
    Select Case Index
    Case 1 ' // Standard
        frmMainWnd.Width = 4065 + x
        frmMainWnd.Height = 3180 + y + IIf(picToolbar.Visible, picToolbar.Height * Screen.TwipsPerPixelY, 0)
        glDisplayXMultiplier = 1
        glDisplayYMultiplier = 1
        mnuOptionsDisplay(1).Checked = True
        mnuOptionsDisplay(3).Checked = False
        mnuOptionsDisplay(4).Checked = False
        mnuOptionsDisplay(5).Checked = False
        mnuOptionsDisplay(7).Checked = False
        SaveSetting "Grok", "vb81", "ScreenSize", "1"
    Case 3 ' // Double Width
        frmMainWnd.Width = 7905 + x
        frmMainWnd.Height = 3180 + y + IIf(picToolbar.Visible, picToolbar.Height * Screen.TwipsPerPixelY, 0)
        glDisplayXMultiplier = 2
        glDisplayYMultiplier = 1
        mnuOptionsDisplay(1).Checked = False
        mnuOptionsDisplay(3).Checked = True
        mnuOptionsDisplay(4).Checked = False
        mnuOptionsDisplay(5).Checked = False
        mnuOptionsDisplay(7).Checked = False
        SaveSetting "Grok", "vb81", "ScreenSize", "4"
    Case 4 ' // Double Height
        frmMainWnd.Width = 4065 + x
        frmMainWnd.Height = 6090 + y + IIf(picToolbar.Visible, picToolbar.Height * Screen.TwipsPerPixelY, 0)
        glDisplayXMultiplier = 1
        glDisplayYMultiplier = 2
        mnuOptionsDisplay(1).Checked = False
        mnuOptionsDisplay(3).Checked = False
        mnuOptionsDisplay(4).Checked = True
        mnuOptionsDisplay(5).Checked = False
        mnuOptionsDisplay(7).Checked = False
        SaveSetting "Grok", "vb81", "ScreenSize", "5"
    Case 5 ' // Double Size
        frmMainWnd.Width = 7905 + x
        frmMainWnd.Height = 6090 + y + IIf(picToolbar.Visible, picToolbar.Height * Screen.TwipsPerPixelY, 0)
        glDisplayXMultiplier = 2
        glDisplayYMultiplier = 2
        mnuOptionsDisplay(1).Checked = False
        mnuOptionsDisplay(3).Checked = False
        mnuOptionsDisplay(4).Checked = False
        mnuOptionsDisplay(5).Checked = True
        mnuOptionsDisplay(7).Checked = False
        SaveSetting "Grok", "vb81", "ScreenSize", "2"
    Case 7 ' // Triple Size
        frmMainWnd.Width = 11745 + x
        frmMainWnd.Height = 8905 + y + IIf(picToolbar.Visible, picToolbar.Height * Screen.TwipsPerPixelY, 0)
        glDisplayXMultiplier = 3
        glDisplayYMultiplier = 3
        mnuOptionsDisplay(1).Checked = False
        mnuOptionsDisplay(3).Checked = False
        mnuOptionsDisplay(4).Checked = False
        mnuOptionsDisplay(5).Checked = False
        mnuOptionsDisplay(7).Checked = True
        SaveSetting "Grok", "vb81", "ScreenSize", "3"
    End Select
    
    resetKeyboard

    ' // Display size has altered, clear the display buffer
    If lHiresLoc = 0 Then
        For i = 0 To 767
            sLastScreen(i) = 0
        Next i
        For i = 0 To 6143
            gcBufferBits(i) = 0
        Next i
    Else
        For y = 0 To 191
            For x = 0 To 31
                cLastHiResScreen(y, x) = 0
                gcBufferBits(y * 32 + x) = 0
            Next x
        Next y
    End If
    gpicDisplay.Cls
End Sub


