Attribute VB_Name = "modMain"
' /*******************************************************************************
'   modMain.bas within vb81.vbp
'
'   Public variable declarations, startup and initialization code,
'   and routines for loading the ROM and applying the required patches
'
'   Author: Chris Cowley <ccowley@grok.co.uk>
'
'   Copyright (C)2000-2002  Grok Developments Ltd.
'   http://www.grok.co.uk/
'
'   This program is free software; you can redistribute it and/or
'   modify it under the terms of the GNU General Public License
'   as published by the Free Software Foundation; either version 2
'   of the License, or (at your option) any later version.
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'
' *******************************************************************************/

Option Explicit

Public Declare Function timeGetTime Lib "winmm.dll" () As Long
Public Declare Function timeBeginPeriod Lib "winmm.dll" (ByVal uPeriod As Long) As Long
Public Declare Function timeEndPeriod Lib "winmm.dll" (ByVal uPeriod As Long) As Long
Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
Public Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Public Declare Function StretchBlt Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long

Public Declare Function GetSystemMetrics Lib "user32" (ByVal nIndex As Long) As Long
Public Const SM_CYCAPTION = 4
Public Const SM_CYMENU = 15
Public Const SM_CXFRAME = 32
Public Const SM_CYFRAME = 33

' // ShellExecute is used for the clickable web URL in the "About..." dialog, not
' //the actual emulator itself
Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public glDisplayXMultiplier As Long
Public glDisplayYMultiplier As Long

Public glTstatesPerInterrupt As Long
Public Parity(256) As Long
Public bInputWait As Long
Public bBooting As Long
Public glInterruptTimer As Long

' // Main registers //
Public regA As Long
Public regHL As Long
Public regB As Long
Public regC As Long
Public regDE As Long

Public fS As Long
Public fZ As Long
Public f5 As Long
Public fH As Long
Public f3 As Long
Public fPV As Long
Public fN As Long
Public fC As Long

' // Flag positions
Public Const F_C = 1
Public Const F_N = 2
Public Const F_PV = 4
Public Const F_3 = 8
Public Const F_H = 16
Public Const F_5 = 32
Public Const F_Z = 64
Public Const F_S = 128

' // Alternate registers //
Public regAF_ As Long
Public regHL_ As Long
Public regBC_ As Long
Public regDE_ As Long

' // Index registers  - ID used as temp for ix/iy //
Public regIX As Long
Public regIY As Long
Public regID As Long

' // Stack pointer and program counter
Public regSP As Long
Public regPC As Long

' // Interrupt registers and flip-flops and refresh registers //
Public intI As Long
Public intR As Long
Public intRTemp As Long
Public intIFF1 As Long
Public intIFF2 As Long
Public intIM As Long

' // Memory //
Public mem(65536) As Long

' // Lookup tables for speed division
Public glMemAddrDiv256(81919) As Long
Public glMemAddrDiv2(81919) As Long
 
' // Screen things
Public sLastScreen(767) As Long
' // Hires Support
Public lHiresLoc As Long ' // location in ZX81's memory of the hi-res displayfile
Public cLastHiResScreen(0 To 191, 0 To 31) As Long

' // Interrupts/Screen refreshing
Public interruptCounter As Long
Public Const refreshRate = 1

' // Keypresses
Public keyB_SPC As Long
Public keyH_ENT As Long
Public keyY_P As Long
Public key6_0 As Long
Public key1_5 As Long
Public keyQ_T As Long
Public keyA_G As Long
Public keyCAPS_V As Long

' // Display colors
Public colors(3) As Long
Public bHideInFastMode As Long
Public bDisplayShown As Long

' // Other settings
Public bAllowWritesToROM As Long

' // Global picDisplay variable to speed things up
Public gpicDisplay As PictureBox

' // WINAPI stuff for fast screen updates
Public Const SRCCOPY = &HCC0020 ' (DWORD) dest = source
Public Declare Function StretchDIBits Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal dx As Long, ByVal dy As Long, ByVal SrcX As Long, ByVal SrcY As Long, ByVal wSrcWidth As Long, ByVal wSrcHeight As Long, lpBits As Any, lpBitsInfo As BITMAPINFO, ByVal wUsage As Long, ByVal dwRop As Long) As Long

Public Type BITMAPINFOHEADER '40 bytes
        biSize As Long
        biWidth As Long
        biHeight As Long
        biPlanes As Integer
        biBitCount As Integer
        biCompression As Long
        biSizeImage As Long
        biXPelsPerMeter As Long
        biYPelsPerMeter As Long
        biClrUsed As Long
        biClrImportant As Long
End Type
Public Type RGBQUAD
        rgbBlue As Byte
        rgbGreen As Byte
        rgbRed As Byte
        rgbReserved As Byte
End Type
Public Type BITMAPINFO
        bmiHeader As BITMAPINFOHEADER
        bmiColors(1) As RGBQUAD
End Type
Public Const BI_RGB = 0&
Public Const DIB_RGB_COLORS = 0 '  color table in RGBs

Public bmiBuffer As BITMAPINFO
Public gcBufferBits(6144) As Byte

Public Sub CreateScreenBuffer()
    bmiBuffer.bmiHeader.biSize = Len(bmiBuffer.bmiHeader)
    bmiBuffer.bmiHeader.biWidth = 256
    bmiBuffer.bmiHeader.biHeight = 192
    bmiBuffer.bmiHeader.biPlanes = 1
    bmiBuffer.bmiHeader.biBitCount = 1
    bmiBuffer.bmiHeader.biCompression = BI_RGB
    bmiBuffer.bmiHeader.biSizeImage = 0
    bmiBuffer.bmiHeader.biXPelsPerMeter = 200
    bmiBuffer.bmiHeader.biYPelsPerMeter = 200
    bmiBuffer.bmiHeader.biClrUsed = 0
    bmiBuffer.bmiHeader.biClrImportant = 0
    
    InitBitmapColors
End Sub
Public Sub InitBitmapColors()
    SetBitmapColor 0, colors(0)
    SetBitmapColor 1, colors(1)
End Sub

Private Sub InitDivisionTables()
    Dim n As Long
     
    For n = 0 To 81919
        glMemAddrDiv256(n) = (n And 65535) \ 256&
        glMemAddrDiv2(n) = (n And 65535) \ 2&
    Next n
End Sub
Sub initParity()
    Dim iCounter As Integer, j As Byte, p As Long
    
    For iCounter = 0 To 255
        p = True
        For j = 0 To 7
            If (iCounter And (2 ^ j)) <> 0 Then p = Not p
        Next j
        Parity(iCounter) = p
    Next iCounter
End Sub


Public Sub InstallROMHacks()
    ' // Patch the 'SAVE' ROM routine with an illegal operation, which we
    ' // trap in the Z80 emulation so the file can be saved to disk instead of
    ' // the ROM trying to output it to TAPE via the ULA
    mem(&H2FC) = &HED ' // ED FD    ; the illegal Z80 op we use for SAVE
    mem(&H2FD) = &HFD ' //
    mem(&H2FE) = &HC3 ' // JP 0207h ; this is where the ZX81 ROM jumps to after
    mem(&H2FF) = &H7  ' //          ; saving a program to tape
    mem(&H300) = &H2  ' //

    ' // Patch the 'LOAD' ROM routine with an illegal op, which is trapped
    ' // just like the SAVE patch above.
    mem(&H347) = &HEB ' // EX DE,HL ; points HL to the name of the program to
                      ' //          ; load (in the ZX character set)
    mem(&H348) = &HED ' // ED FC    ; the illegal Z80 op we use for LOAD
    mem(&H349) = &HFC ' //
    mem(&H34A) = &HC3 ' // JP 0207h ; this is where the ZX81 ROM jumps to after
    mem(&H34B) = &H7  ' //          ; loading a program from tape
    mem(&H34C) = &H2  ' //

    ' // Execute 'out (0),a' when waiting for input, and
    ' // 'out (1),a when finished waiting (used to paint
    ' // the screen during idle periods when in fast mode)
    mem(&H4CA) = &HD3 ' //       OUT (0),A  ; Tell the emulator we are waiting
    mem(&H4CB) = 0    ' //                  ; for keyboard input
    mem(&H4CC) = &HCB ' // loop: BIT 0,(HL) ; Loop until our NMI emulation sets
    mem(&H4CD) = &H46 ' //                  ; bit 0 of (CDFLAGS), which indicates
    mem(&H4CE) = &H28 ' //       JR Z,loop  ; that a key has been pressed
    mem(&H4CF) = &HFC ' //
    mem(&H4D0) = &HD3 ' //       OUT (1),A  ; Tell the emulator that we are no
    mem(&H4D1) = 1    ' //                  ; longer waiting for keyboard input
    mem(&H4D2) = 0    ' //       NOP        ; NOP an old byte (filler)
    
    ' // This is required for correct implementation of the PAUSE command, as the
    ' // PAUSE code in a real ZX81 is tied in with the FRAMES counter in the FAST
    ' // mode display loop which we emulate outside of the routines in the ROM.
    mem(&H2A9) = &HD3 ' //   OUT (0),A  ; see above
    mem(&H2AA) = 0
    mem(&H2AB) = 118  ' //   HALT       ; ensures the bit of display code that
                      ' //              ; we loop through only gets executed
                      ' //              ; once per interrupt (as it would in a
                      ' //              ; real ZX81)
    mem(&H2AC) = 205  ' //   CALL 0229h ; jump out of the display routine
    mem(&H2AD) = &H29 ' //              ; early to avoid the nasty code that
    mem(&H2AE) = 2    ' //              ; jumps right into the DFILE!
    mem(&H2AF) = &HD3 ' //  OUT (1),A   ; see above
    mem(&H2B0) = 1
    mem(&H2B1) = 201  ' //  RET         ; Return to PAUSE command routine
End Sub

Public Sub LoadMemoCalcROM()
    Dim hFile As Long, sROM As String, iCounter As Integer
    
    If Dir$("memocalc.rom") = "" Then
        MsgBox "Error: Could not find required MemoCalc ROM image '" & CurDir$ & "\" & "memocalc.rom'.", vbOKOnly Or vbCritical, "vb81"
        Exit Sub
    End If
    hFile = FreeFile
    Open "memocalc.rom" For Binary As hFile
    sROM = Input(4096, #hFile)
    Close hFile
    
    For iCounter = 12288 To 16383
        mem(iCounter) = Asc(Mid$(sROM, iCounter - 12287, 1))
    Next iCounter
End Sub

Sub LoadROM()
    Dim hFile As Long, sROM As String, iCounter As Integer
    
    If Dir$("zx81.rom") = "" Then
        MsgBox "Error: Could not find required ROM image '" & CurDir$ & "\" & "zx81.rom'.", vbOKOnly Or vbCritical, "vb81"
        Unload frmMainWnd
        Exit Sub
    End If
    hFile = FreeFile
    Open "zx81.rom" For Binary As hFile
    sROM = Input(IIf(LOF(hFile) < 8192, LOF(hFile), 8192), #hFile)
    Close hFile
    
    For iCounter = 1 To Len(sROM)
        mem(iCounter - 1) = Asc(Mid$(sROM, iCounter, 1))
    Next iCounter
End Sub

Sub Main()
    Dim iCounter As Integer, s As String
    
    Load frmMainWnd
    
    InitDivisionTables
    
    ' // Get colors and initialize display
    colors(0) = &HC0C0C0
    colors(1) = 0
    colors(2) = &HC0C0C0
    colors(3) = &H808080
    For iCounter = 0 To 3
        s = GetSetting("Grok", "vb81", "Color" & (iCounter + 1), "")
        If s <> "" Then
            colors(iCounter) = val("&h" & s)
        End If
    Next iCounter
    
    ' // Set up the screen bitmap in memory
    CreateScreenBuffer
    
    Set gpicDisplay = frmMainWnd.picDisplay
    
        
    ' // Set the correct size (standard/double)
    Select Case val(GetSetting("Grok", "vb81", "ScreenSize", "1"))
    Case 1
        frmMainWnd.mnuOptionsDisplay_Click 1
    Case 2
        frmMainWnd.mnuOptionsDisplay_Click 5
    Case 3
        frmMainWnd.mnuOptionsDisplay_Click 7
    Case 4
        frmMainWnd.mnuOptionsDisplay_Click 3
    Case 5
        frmMainWnd.mnuOptionsDisplay_Click 4
    End Select
    
    If GetSetting("Grok", "vb81", "ShowToolbar", "1") = "1" Then
        frmMainWnd.mnuOptions_Click 3
    End If
    
    If GetSetting("Grok", "vb81", "AllowWritesToROM", "1") = "1" Then
        frmMainWnd.mnuOptions_Click 5
    End If

    bHideInFastMode = val(GetSetting("Grok", "vb81", "HideInFastMode", "1"))
    
    With frmMainWnd
        If bHideInFastMode Then
            gpicDisplay.Visible = False
            .BackColor = colors(3)
        Else
            .BackColor = colors(2)
        End If
        bDisplayShown = bHideInFastMode
        gpicDisplay.BackColor = colors(0)
        gpicDisplay.Cls
        .Cls
    
        .Show
        .Refresh
    End With

    ' // Initialize everything
    intIFF1 = True
    intIFF2 = True
    intIM = 2
    initParity
    
    ' // In slow mode, the ZX81 runs at approx. 0.8MHz
    glTstatesPerInterrupt = 16000
    bInputWait = False
    bBooting = False
    
    ' // load the ROM image into memory
    LoadROM
    InstallROMHacks
    CopyROM ' // Copy the 8K ZX81 rom into 0x2000 - 0x3FFF (this is how the
            ' // memory map on a real ZX81 looks
    resetKeyboard
    
    timeBeginPeriod 1

    glInterruptTimer = timeGetTime() + 20
    
    ' // Begin executing the ROM code at 0x0000
    execute
End Sub

Sub CopyROM()
    Dim iCounter As Integer
    
    For iCounter = 0 To 8191
        mem(iCounter + 8192) = mem(iCounter)
    Next iCounter
End Sub

Public Function Max(lVal1 As Long, lVal2 As Long) As Long
    Max = IIf(lVal1 > lVal2, lVal2, lVal1)
End Function

Sub resetKeyboard()
    keyB_SPC = &HFF&
    keyH_ENT = &HFF&
    keyY_P = &HFF&
    key6_0 = &HFF&
    key1_5 = &HFF&
    keyQ_T = &HFF&
    keyA_G = &HFF&
    keyCAPS_V = &HFF&
End Sub


Public Sub SetBitmapColor(lIndex As Long, lColor As Long)
    If lIndex > 1 Then Exit Sub
    
    bmiBuffer.bmiColors(lIndex).rgbRed = (lColor And &HFF&)
    bmiBuffer.bmiColors(lIndex).rgbGreen = (lColor And &HFF00&) \ 256
    bmiBuffer.bmiColors(lIndex).rgbBlue = (lColor And &HFF0000) \ 65536
End Sub

Public Sub ShowDisplay(ByVal flag As Long, bPaintFlag As Long)
    ' flag=TRUE (ShowDisplay)
    ' flag=FALSE (HideDisplay)
    
    If bHideInFastMode And bDisplayShown <> flag Then
        If flag Then
            frmMainWnd.BackColor = colors(2)
            If bPaintFlag Then screenPaint
        Else
            frmMainWnd.BackColor = colors(3)
        End If
        frmMainWnd.picDisplay.Visible = flag
        frmMainWnd.Refresh
        bDisplayShown = flag
    End If
End Sub
