﻿
'Copyright © 2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.



Option Explicit On
Option Strict On
' Yo_fr (jj.stac @ aliceadsl.fr)
' Le 25/01/2015 !
' Ce jour j'ai envoyé le microcode, créé les fonctions Ecrit caractere, Ecrit phrase, Lecture clavier !
' 07 mars 2015 : fin de l'étude les différentes commandes fonctionnent bien :
'                peek / poke / Save / Load / Reset / DIR / CLS et même Help
'                Le Batch de commande est encore en projet, mais d'un intéret moyen...
' Novembe / Decembre 2015 : ajout des fonctions pour lire les vidéo et les sons digitalisés de l'HectorDuino !

' Ce code est libre d'utilisation et de diffusion (Sous licence GPLV3), néanmoins si vous utilisez mon code,
' merci de m'envoyer un petit mail !
' Si vous améliorez / corrigez des bug, merci de me le renvoyer la correction !

' This code is free to use and distribute (under GPLV3 licence), however if you use my code thank you send me a mail!
' If you improve / correct the bug, thank you for returning it to me!

Imports System
Imports System.Runtime.InteropServices
Imports System.IO.Directory


Public Module Arduino
    ' Création d'une class pour simulation de ce doit faire l'arduino pour causer avec Hector
    ' Il reprends évidement le principe de fonctionnement du Disc2, notament le microcode envoyé
    ' en début de communication

    'Mémoire intermédiaire Hector, Disc2 :
    Public Disc2_data_r_ready As Boolean
    Public Disc2_data_read As Byte ' Octet Hector => Disc

    Public Disc2_data_w_ready As Boolean ' Octet Disc => Hector dispo
    Public Disc2_data_write As Byte ' data send by Disc2, to Hector

    'Pour le debuggage
    Public Strg_ARD As String
    Public MemROM(4096) As Byte
    Dim Index_Envoi As Integer = 0

    Dim PAS As Integer  ' Pas courant
    Dim Carac As Byte   ' caractere saisi
    Dim Commande As String
    Dim Pointeur As Integer
    Dim PVideo As Boolean = False

    'Gestion des fonctions demandées par l'appel de fonction
    Public Fonction As Integer = 0 ' N° de la fonction demandée
    Dim Pas_Fonction As Integer = 0 ' pas à pas des fonctions !
    Dim Param_Fonction(5) As String ' les options de la commandes !
    Dim PAS_SP As Integer = 0
    Dim PAS_SP_N1 As Integer = 0
    Public Index As Integer = 0

    Public Directory As String = "SD/"  ' peut être modifié, répertoire de deposit pour les fichiers à utiliser !
    Public Flag As Byte = 0

    Public Sub OneCycle()
        'Réalisation d'un appel de cycle à l'Arduino
        ' ici il faut créer un automate de marche Arduino
        ' à l'aide de micro instructions à suivre (comme le 
        ' ferait l'Arduino)
        ' on est appelé à 5MHz et non 16 comme l'arduino

        Select Case PAS
            Case 100 ' on commence par exécuter le pas 100 pour gagner du temps !
                ' ici pour l'exécution d'une commande
                If Execute_Commande() Then
                    PAS = 7 ' on relance la machine à la fin d'exécution d'une commande
                End If

            Case 0
                'Attente octet d'Hector
                If Disc2_data_r_ready = True Then
                    PAS += 1
                End If
            Case 1
                'Verification si c'est bien un octet de synchro
                If Disc2_data_read = &HAA Then
                    Disc2_data_r_ready = False
                    PAS += 1
                    Strg_ARD = Strg_ARD & "Synchro reçue" & vbCrLf
                    Index_Envoi = 0
                Else
                    PAS = 0
                End If
            Case 2
                ' Envoi des data à Hector!
                Disc2_data_write = MemROM(Index_Envoi)
                Disc2_data_w_ready = True
                PAS += 1
            Case 3
                If Disc2_data_w_ready = False Then
                    Index_Envoi += 1
                    If Index_Envoi < MainForm.Taille_Microcode Then ' &H178 + 4 Then ' + 2 + 2 Then '161h octets + @ rangement + long intégré au fichier
                        PAS = PAS - 1
                    Else
                        PAS += 1
                        Strg_ARD += "Microcode send!" & vbCrLf
                        Index_Envoi = 0
                    End If
                End If
            Case 4
                If Ecrit_Ligne("  ") Then
                    PAS += 1
                End If
            Case 5
                If Ecrit_Ligne("JJ Stacino - yo_fr    31/12/2015") Then
                    PAS += 1
                End If
            Case 6
                If Ecrit_Ligne("Type 'HELP' for futher assistance") Then ' saut de ligne
                    PAS += 1
                End If
            Case 7
                If Ecrit_Phrase(" " + vbCrLf + ">") Then ' saut de ligne
                    PAS += 1
                    Commande = ""
                End If
            Case 8
                If Recup_Caractere(Carac) Then
                    PAS += 1
                    If Carac <> 13 Then
                        Commande = Commande + Microsoft.VisualBasic.Chr(Carac)
                    End If
                    If Carac = 8 Then ' Gestion du backspace
                        If Commande.Length <= 2 Then
                            If Commande.Length < 2 Then
                                PAS = 8
                            End If
                            Commande = ""
                        Else
                            Commande = Left(Commande, Commande.Length - 2)
                        End If
                    End If
                End If
            Case 9
                If Ecrit_Caractere(Carac) Then
                    If Carac = 8 Then
                        Carac = Carac
                    End If
                    If Carac = 10 Then
                        'Execution de la ligne saisie !
                        PAS = 100
                        Analyse_Commande(Commande)
                        Commande = ""
                    ElseIf Carac = 13 Then

                        'Ajout LF à CR pour un saut à la ligne complete !
                        Carac = 10
                        PAS = 9
                    Else
                        PAS = 8
                    End If

                End If

        End Select

    End Sub

    ' Execution des differentes commande possible
    Private Function LOAD() As Boolean
        Static Adr As Integer
        Static Adr_Low, Adr_High As Byte
        Static Lon_Low, Lon_High As Byte
        Dim CF As Byte
        Static Fichier As Byte()

        LOAD = False
        Select Case Pas_Fonction
            Case 0
                Pas_Fonction += 1
                Pointeur = 0
                Adr = MainForm.Conv_Strg_To_Int(Param_Fonction(2))
                Adr_High = CByte(Adr >> 8)
                Adr_Low = CByte(Adr And &HFF)

            Case 1
                If Ecrit_Ligne("File name : " & Param_Fonction(1)) Then
                    Pas_Fonction += 1
                    Try
                        Fichier = Microsoft.VisualBasic.FileIO.FileSystem.ReadAllBytes(Directory & "\" & Param_Fonction(1))

                        If Fichier.Length > (65536 - Adr) Then
                            'fichier trop long !
                            Pas_Fonction = 99
                        Else
                            Lon_High = CByte((Fichier.Length) >> 8)
                            Lon_Low = CByte((Fichier.Length) And &HFF)
                        End If
                    Catch
                        'Error sur fichier ! 
                        Pas_Fonction = 98
                    End Try
                End If

            Case 2
                If Ecrit_Ligne("Adress to load (video): " & Hex(Adr)) Then
                    Pas_Fonction += 1
                End If
            Case 3
                If PVideo Then
                    CF = &H82
                Else
                    CF = &H2
                End If
                If Envoi_Octet(CF) Then 'Code 10 = ecriture d'un bloc d'octet à l'adresse donnée !
                    Pas_Fonction += 1
                End If
            Case 4
                If Envoi_Octet(Lon_High) Then  ' Poids fort : Longueur
                    Pas_Fonction += 1
                End If
            Case 5
                If Envoi_Octet(Lon_Low) Then  ' Poids faible : Longueur
                    Pas_Fonction += 1
                End If
            Case 6
                If Envoi_Octet(Adr_High) Then  ' Poids fort : Adresse
                    Pas_Fonction += 1
                End If
            Case 7
                If Envoi_Octet(Adr_Low) Then  ' Poids faible : Adresse
                    Pas_Fonction += 1
                End If
                Adr = 0
            Case 8
                If Envoi_Octet(Fichier(Pointeur)) Then  ' Valeur à écrire !
                    Pointeur += 1
                    If Pointeur >= Fichier.Length Then ' si le pointeur est arrivé au bout du fichier,
                        'C'est que c'est fini !
                        Pas_Fonction += 1
                    End If
                End If
            Case 9
                Pas_Fonction += 1
                LOAD = True


                ' Traitement des erreurs !
            Case 98
                If Ecrit_Ligne("File exist?") Then
                    Pas_Fonction = 0
                    LOAD = True
                End If
            Case 99
                If Ecrit_Ligne("Error file too big!") Then
                    Pas_Fonction = 0
                    LOAD = True
                End If

        End Select
    End Function      ' Chargement d'un fichier en mémoire
    Private Function SAVE() As Boolean
        Static Adr, Lon As Integer
        Static Adr_Low, Adr_High As Byte
        Static Lon_Low, Lon_High As Byte
        Dim CF As Byte

        SAVE = False

        Static Fichier As Byte()

        Select Case Pas_Fonction
            Case 0
                ' Ininilisation divers !
                Pas_Fonction += 1
                Pointeur = 0
                Adr = MainForm.Conv_Strg_To_Int(Param_Fonction(2))
                Adr_High = CByte(Adr >> 8)
                Adr_Low = CByte(Adr And &HFF)
                 ' Longueur
                Lon = MainForm.Conv_Strg_To_Int(Param_Fonction(3))
                Lon_High = CByte(Lon >> 8)
                Lon_Low = CByte(Lon And &HFF)

                If (CDbl(Lon) + CDbl(Adr) > 65535) Then
                    Pas_Fonction = 99 ' Error !
                End If
                ' et on redimmentionne le  tableau !
                ReDim Fichier(Lon - 1)  '  on reserve assez de place pour la sauvegarde

            Case 1
                If PVideo Then
                    CF = &H83
                Else
                    CF = &H3
                End If
                If Envoi_Octet(CF) Then 'Code 10 = ecriture d'un bloc d'octet à l'adresse donnée !
                    Pas_Fonction += 1
                End If
            Case 2
                If Envoi_Octet(Lon_High) Then  ' Poids fort : Longueur
                    Pas_Fonction += 1
                End If
            Case 3
                If Envoi_Octet(Lon_Low) Then  ' Poids faible : Longueur
                    Pas_Fonction += 1
                End If
            Case 4
                If Envoi_Octet(Adr_High) Then  ' Poids fort : Adresse
                    Pas_Fonction += 1
                End If
            Case 5
                If Envoi_Octet(Adr_Low) Then  ' Poids faible : Adresse
                    Pas_Fonction += 1
                End If
                Adr = 0
            Case 6
                If Lit_Octet(Fichier(Pointeur)) Then  ' Valeur à écrire !
                    Pointeur += 1
                    If Pointeur >= Lon Then ' si le pointeur est arrivé au bout du fichier,
                        'C'est que c'est fini !
                        Pas_Fonction += 1
                    End If
                End If
            Case 7

                Pas_Fonction += 1
                'Sauvegarde du fichier !
                Try
                    Microsoft.VisualBasic.FileIO.FileSystem.WriteAllBytes(Directory & "\" & Param_Fonction(1), Fichier, False)
                Catch
                    'Error sur fichier ! 
                    Pas_Fonction = 98
                End Try

            Case 8
                Pas_Fonction = 0
                SAVE = True


                ' Traitement des erreurs !
            Case 98
                If Ecrit_Ligne("File exist?") Then
                    Pas_Fonction = 0
                    SAVE = True
                End If
            Case 99
                If Ecrit_Ligne("Memory area too big!") Then
                    Pas_Fonction = 0
                    SAVE = True
                End If

        End Select
    End Function      ' Chargement d'un fichier en mémoire
    ' Execution des differentes commande possible
    Private Function VIDEO() As Boolean
        VIDEO = False
        Dim Adr As Integer
        Static Adr_Low, Adr_High As Byte
        Static Lon_Low, Lon_High As Byte
        Static Fichier As Byte()

        Select Case Pas_Fonction
            ' On charge le PLAYER en mémoire Haute !
            ' (Hors écran BR...)
            Case 0
                '  Pas_Fonction = 8
                Pas_Fonction += 1
                Pointeur = 0
                Adr = &H8000  'Adresse fixe 0X08000
                Adr_High = CByte(Adr >> 8)
                Adr_Low = CByte(Adr And &HFF)

            Case 1
                Pas_Fonction += 1
                Try
                    Fichier = Microsoft.VisualBasic.FileIO.FileSystem.ReadAllBytes("Player.bin")

                    Lon_High = CByte((Fichier.Length) >> 8)
                    Lon_Low = CByte((Fichier.Length) And &HFF)
                    Catch
                    'Error sur fichier ! 
                    Pas_Fonction = 97
                End Try
                
            Case 2
                If Envoi_Octet(&H2) Then 'Code 2 = ecriture d'un bloc d'octet à l'adresse donnée !
                    Pas_Fonction += 1
                End If
            Case 3
                If Envoi_Octet(Lon_High) Then  ' Poids fort : Longueur
                    Pas_Fonction += 1
                End If
            Case 4
                If Envoi_Octet(Lon_Low) Then  ' Poids faible : Longueur
                    Pas_Fonction += 1
                End If
            Case 5
                If Envoi_Octet(Adr_High) Then  ' Poids fort : Adresse
                    Pas_Fonction += 1
                End If
            Case 6
                If Envoi_Octet(Adr_Low) Then  ' Poids faible : Adresse
                    Pas_Fonction += 1
                End If
                Adr = 0
            Case 7
                If Envoi_Octet(Fichier(Pointeur)) Then  ' Valeur à écrire !
                    Pointeur += 1
                    If Pointeur >= Fichier.Length Then ' si le pointeur est arrivé au bout du fichier,
                        'C'est que c'est fini !
                        Pas_Fonction += 1
                    End If
                End If
            Case 8
                Pas_Fonction += 1
                Pointeur = 0
                Exit Select
            Case 9
                If Ecrit_Ligne("Film name : " & Param_Fonction(1)) Then
                    Pas_Fonction += 1
                    Try
                        Fichier = Microsoft.VisualBasic.FileIO.FileSystem.ReadAllBytes(Directory & "\" & Param_Fonction(1))

                    Catch
                        'Erreur sur fichier ! 
                        Pas_Fonction = 98
                    End Try
                End If
                If Fichier.Length < 1 Then
                    'Trop court, même punition : sortie !
                    Pas_Fonction = 98
                End If
                Exit Select
            Case 10
                If Envoi_Octet(&HD) Then 'Code C = VIDEO EN RELATIF, D VIDEO EN ABSOLU (VIDEOA)
                    Pas_Fonction += 1
                    Flag = 0
                End If
                Exit Select
            Case 11
                Pas_Fonction += 1
                Exit Select
            Case 12
                Select Case Flag ' Adresse Hector video : 6166
                    Case 0
                        If Pointeur = 0 Then
                            '    MainForm.Debuggage = True
                            'C'est le 1er octet => en synchro normale
                            If Envoi_Octet(Fichier(Pointeur)) Then  ' Valeur à écrire !
                                Pointeur += 1
                                Flag = 1
                            End If
                        Else
                            'C'est plus le 1er octet => en synchro par portA
                            Disc2_data_write = &HEE
                            If (Disc2_data_w_ready = False) And (Disc2_data_read = 4) Then
                                Disc2_data_write = Fichier(Pointeur)
                                Pointeur += 1
                                Flag = 1 '  CByte(Flag + 1)
                            End If

                        End If
                        Exit Select
                    Case 1
                        If (Disc2_data_w_ready = False) And (Disc2_data_read = 3) Then
                            Disc2_data_write = Fichier(Pointeur)
                            Pointeur += 1
                            Flag = CByte(Flag + 1)
                        End If
                        Exit Select
                    Case 2
                        If Disc2_data_read = 2 Then
                            Disc2_data_write = Fichier(Pointeur)
                            Pointeur += 1
                            Flag = CByte(Flag + 1)
                        End If
                        Exit Select
                    Case 3
                        If Disc2_data_read = 1 Then
                            Disc2_data_write = Fichier(Pointeur)
                            Pointeur += 1
                            If Pointeur >= Fichier.Length Then ' si le pointeur est arrivé au bout du fichier,
                                'C'est que c'est fini !
                                Pas_Fonction += 1
                            End If
                            Flag = 0
                        End If
                        Exit Select
                End Select

            Case 13
                If Ecrit_Ligne("Fin de la video!" & vbLf) Then
                    Pas_Fonction += 1
                End If
                Exit Select
            Case 14
                If Ecrit_Ligne("Ceci est une demonstration, 'presque' a l'identique de la realite MAIS les  timing ne sont pas respectes !" & vbCrLf & "Ils dependent de votre PC !" & vbCrLf & "PS : En basse resolution cela ce       termine par un reset..." & vbCrLf) Then

                    Pas_Fonction = 0
                    VIDEO = True
                End If
                Exit Select
                ' Traitement des erreurs !
            Case 97
                If Ecrit_Ligne("File player.bin exist?") Then
                    Pas_Fonction = 0
                    VIDEO = True
                End If
            Case 98
                If Ecrit_Ligne("File exist?") Then
                    Pas_Fonction = 0
                    VIDEO = True
                End If
            Case 99
                If Ecrit_Ligne("Error file too big!") Then
                    Pas_Fonction = 0
                    VIDEO = True
                End If

        End Select
    End Function      ' Chargement d'un fichier en mémoire

    Private Function DIR() As Boolean
        Static dirs As String()

        DIR = False
        Static Repertoire As Boolean

        Select Case Pas_Fonction
            Case 0
                If Ecrit_Ligne("Execution de la commande DIR") Then
                    Pas_Fonction += 1
                End If
            Case 1
                Try
                    dirs = System.IO.Directory.GetFileSystemEntries(Directory, "*.*", IO.SearchOption.TopDirectoryOnly)
                Catch
                    ReDim dirs(0)
                    dirs(0) = "error"
                End Try

                Pas_Fonction += 1
                Pointeur = -1

            Case 2
                Pointeur += 1
                If Pointeur >= dirs.Length Then
                    Pas_Fonction = 4 'un de moins que la sortie !
                Else
                    'On remplace le \ windows par le / d'Hector...sinon "\" = "ç" !
                    dirs(Pointeur) = Replace(dirs(Pointeur), "\", Chr(47))
                    Repertoire = System.IO.Directory.Exists(dirs(Pointeur))
                End If
                Pas_Fonction += 1

            Case 3
                If Repertoire Then
                    If Pen(2) Then
                        Pas_Fonction += 1
                    End If
                Else
                    If Pen(3) Then
                        Pas_Fonction += 1
                    End If
                End If
            Case 4
                If Ecrit_Ligne(dirs(Pointeur)) Then
                    Pas_Fonction = 2
                    If dirs(0) = "error" Then
                        Pas_Fonction = 5
                    End If
                End If
            Case 5
                If Pen(2) Then
                    Pas_Fonction = 0
                    DIR = True
                End If
        End Select

    End Function        ' affiche directory
    Private Function CD() As Boolean          ' Change Directory
        'Court mais conci !
        Directory = Directory & Param_Fonction(1) & "/"
        CD = True
    End Function
    Private Function CD__() As Boolean          ' remonte d'un directory Directory
        Dim PositionSlash As Integer

        PositionSlash = Directory.LastIndexOf("/", Directory.Length - 2)
        If PositionSlash > 0 Then
            Directory = Microsoft.VisualBasic.Left(Directory, PositionSlash + 1)
        End If
        CD__ = True
    End Function
    Private Function Type_File() As Boolean
        Static Fichier As Byte()

        Type_File = False
        Select Case Pas_Fonction
            Case 0
                Pas_Fonction += 1
                Pointeur = 0

            Case 1
                If Ecrit_Ligne("Type File name : " & Param_Fonction(1)) Then
                    Pas_Fonction += 1
                    Try
                        Fichier = Microsoft.VisualBasic.FileIO.FileSystem.ReadAllBytes(Directory & "\" & Param_Fonction(1))

                    Catch
                        'Error sur fichier ! 
                        Pas_Fonction = 98
                    End Try
                End If

            Case 2
                If Ecrit_Caractere(Fichier(Pointeur)) Then  ' caractere à écrire !
                    Pointeur += 1
                    If Pointeur >= Fichier.Length Then ' si le pointeur est arrivé au bout du fichier,
                        'C'est que c'est fini !
                        Pas_Fonction += 1
                    End If
                End If
            Case 3
                Pas_Fonction += 1
                Type_File = True

                ' Traitement des erreurs !
            Case 98
                If Ecrit_Ligne("File exist?") Then
                    Pas_Fonction = 0
                    Type_File = True
                End If
            Case 99
                If Ecrit_Ligne("Error file too big!") Then
                    Pas_Fonction = 0
                    Type_File = True
                End If

        End Select
    End Function      ' listing d'un fichier sur écran


    Private Function REDO() As Boolean

        REDO = False
        Select Case Pas_Fonction
            Case 0
                If Ecrit_Phrase("Commande inconnue" & vbCrLf) Then
                    Pas_Fonction += 1
                End If
            Case 1
                'Sortie car fin de traitement !
                REDO = True
        End Select
    End Function      ' erreur de commande
    Private Function SYNTAXE() As Boolean

        SYNTAXE = False
        Select Case Pas_Fonction
            Case 0
                If Ecrit_Phrase("Syntax Error" & vbCrLf) Then
                    Pas_Fonction += 1
                End If
            Case 1
                'Sortie car fin de traitement !
                SYNTAXE = True
                Pas_Fonction = 0
        End Select
    End Function   ' erreur de syntaxe
    Private Function GO() As Boolean
        Static Adr_Low, Adr_High As Byte
        Dim Adr As Integer

        GO = False

        Select Case Pas_Fonction
            Case 0
                ' Lecture du paramétre 1 : Adresse d'écriture
                Adr = MainForm.Conv_Strg_To_Int(Param_Fonction(1))
                Adr_High = CByte(Adr >> 8)
                Adr_Low = CByte(Adr And &HFF)
                Pas_Fonction += 1
            Case 1
                If Envoi_Octet(0) Then 'Code 0 = Lancement à l'adresse suivante !
                    Pas_Fonction += 1
                End If
            Case 2
                If Envoi_Octet(Adr_High) Then  ' Poids faible : 00
                    Pas_Fonction += 1
                End If
            Case 3
                If Envoi_Octet(Adr_Low) Then ' Poids fort : 144
                    Pas_Fonction = 0
                    GO = True
                End If
        End Select

    End Function        ' execution d'un programme à adresse
    Private Function CODE() As Boolean
        Static Adr_Low, Adr_High As Byte
        Static Value As Byte
        Dim Adr As Integer
        Static number As Integer = 0

        CODE = False

        Select Case Pas_Fonction
            Case 0
                If Ecrit_Ligne("Execution de la commande CODE") Then
                    Pas_Fonction += 1
                End If
            Case 1
                ' Lecture du paramétre 1 : Adresse d'écriture
                Adr = MainForm.Conv_Strg_To_Int(Param_Fonction(1))
                Adr_High = CByte(Adr >> 8)
                Adr_Low = CByte(Adr And &HFF)

                ' Lecture du paramétre 2 : Valeur à écrire !
                Value = CByte(MainForm.Conv_Strg_To_Int(Param_Fonction(2)))
                Pas_Fonction += 1

                'code = 11 alors caractére 5eme sera affiché !
                'code 12 attente 1 touche
            Case 2
                If Envoi_Octet(11) Then 'Code 11 = ??
                    Pas_Fonction += 1
                End If
            Case 3
                If Envoi_Octet(&H21) Then  ' Poids fort : Longueur  REGISTRE DE
                    Pas_Fonction += 1
                End If
            Case 4
                If Envoi_Octet(&H10) Then  ' Poids faible : Longueur  REGISTRE DE
                    Pas_Fonction += 1
                End If
            Case 5
                If Envoi_Octet(&H81) Then  ' Poids fort : Adresse  REG HL
                    Pas_Fonction += 1
                End If
            Case 6
                If Envoi_Octet(1) Then  ' Poids faible : Adresse  REG HL
                    Pas_Fonction += 1
                End If
            Case 7
                '          If Envoi_Octet(CByte((number + 1) And 255)) Then  ' Poids faible : 00
                ' number += 1
                '  If number > (&H1000 - 1) Then
                ' Pas_Fonction += 1
                ' End If
                ' End If
                If Envoi_Octet(&H44) Then  ' Poids faible : Adresse  REG A
                    Pas_Fonction += 1
                End If

            Case 8
                Pas_Fonction = 0
                CODE = True
        End Select

    End Function      ' permet de tester les codes fonction du microcode !
    Private Function RESETCMD() As Boolean

        RESETCMD = False

        Select Case Pas_Fonction
            Case 0
                If Envoi_Octet(1) Then 'Code 0 = RESET
                    Pas_Fonction += 1
                End If
            Case 1
                Pas_Fonction = 0
                RESETCMD = True
        End Select

    End Function  ' permet de rester Hector !
    Private Function Poke() As Boolean  'Remplissage mémoire
        Static Adr_Low, Adr_High As Byte
        Static Value As Byte
        Dim Adr As Integer
        Dim CF As Byte


        Poke = False

        Select Case Pas_Fonction
            Case 0
                If PVideo Then
                    If Ecrit_Ligne("Execution de la commande VPOKE") Then
                        Pas_Fonction += 1
                    End If
                Else
                    If Ecrit_Ligne("Execution de la commande POKE") Then
                        Pas_Fonction += 1
                    End If
                End If
            Case 1
                ' Lecture du paramétre 1 : Adresse d'écriture
                Adr = MainForm.Conv_Strg_To_Int(Param_Fonction(1))
                Adr_High = CByte(Adr >> 8)
                Adr_Low = CByte(Adr And &HFF)

                ' Lecture du paramétre 2 : Valeur à écrire !
                Value = CByte(MainForm.Conv_Strg_To_Int(Param_Fonction(2)))
                Pas_Fonction += 1
            Case 2  ' Code 0 => reset !
                If PVideo Then
                    CF = &H89
                Else
                    CF = &H9
                End If
                If Envoi_Octet(CF) Then 'Code 9 = ecriture d'un octet à l'adresse donnée, 89 : Page Video !
                    Pas_Fonction += 1
                End If
            Case 3
                If Envoi_Octet(Adr_High) Then  ' Poids faible : 00 adresse écriture
                    Pas_Fonction += 1
                End If
            Case 4
                If Envoi_Octet(Adr_Low) Then  ' Poids fort : 80 adresse écriture
                    Pas_Fonction += 1
                End If
            Case 5
                If Envoi_Octet(Value) Then  ' Poids faible : 00 longeur
                    Pas_Fonction += 1
                End If
            Case 6
                Pas_Fonction = 0
                Poke = True
        End Select

    End Function      ' permet d'envoyer un octet à Hector Syntax  Poke ADR VAL !
    Private Function Peek() As Boolean
        Static Adr_Low, Adr_High As Byte
        Static Value As Byte
        Static Adr As Integer
        Dim CF As Byte

        Peek = False

        Select Case Pas_Fonction
            Case 0
                If PVideo Then
                    If Ecrit_Ligne("Execution de la commande VPEEK") Then
                        Pas_Fonction += 1
                    End If
                Else
                    If Ecrit_Ligne("Execution de la commande PEEK") Then
                        Pas_Fonction += 1
                    End If
                End If
            Case 1
                ' Lecture du paramétre 1 : Adresse d'écriture
                Adr = MainForm.Conv_Strg_To_Int(Param_Fonction(1))
                Adr_High = CByte(Adr >> 8)
                Adr_Low = CByte(Adr And &HFF)
                Pas_Fonction += 1
            Case 2  ' Code 10 => Peek !
                If PVideo Then
                    CF = &H8A
                Else
                    CF = &HA
                End If
                If Envoi_Octet(CF) Then 'Code 10 = Lecture d'un octet à l'adresse donnée !
                    Pas_Fonction += 1
                End If
            Case 3
                If Envoi_Octet(Adr_High) Then  ' Poids faible : 00 adresse écriture
                    Pas_Fonction += 1
                End If
            Case 4
                If Envoi_Octet(Adr_Low) Then  ' Poids fort : 80 adresse écriture
                    Pas_Fonction += 1
                End If
            Case 5
                If Lit_Octet(Value) Then  ' Lecture de l'octet !
                    Pas_Fonction += 1
                End If
            Case 6
                If PVideo Then
                    If Ecrit_Ligne(" VPEEK(" & Hex(Adr) & ") =" & Hex(Value)) Then
                        Pas_Fonction += 1
                    End If
                Else
                    If Ecrit_Ligne(" PEEK(" & Hex(Adr) & ") =" & Hex(Value)) Then
                        Pas_Fonction += 1
                    End If
                End If


            Case 7
                Pas_Fonction = 0
                Peek = True
        End Select

    End Function      ' Lecture d'une mémoire
    Private Function HELP() As Boolean  'Liste des commandes
        Dim Octet As Byte
        HELP = False

        Select Case Pas_Fonction
            Case 0
                If Ecrit_Ligne("Available commands are:") Then
                    Pas_Fonction += 1
                End If
            Case 1
                '   If Ecrit_Ligne(" ") Then
                If Pen(3) Then
                    Pas_Fonction += 1
                End If
            Case 2
                If Ecrit_Ligne("POKE ADR VAL  : write VAL at ADR") Then
                    Pas_Fonction += 1
                End If
            Case 3
                If Ecrit_Ligne("VPOKE ADR VAL : write video page") Then
                    Pas_Fonction += 1
                End If
            Case 4
                If Ecrit_Ligne("PEEK ADR      : Read memory") Then
                    Pas_Fonction += 1
                End If
            Case 5
                If Ecrit_Ligne("VPEEK ADR     : Read video memory") Then
                    Pas_Fonction += 1
                End If
            Case 6
                If Ecrit_Ligne("LOAD file AD  : load file>memory") Then
                    Pas_Fonction += 1
                End If
            Case 7
                If Ecrit_Ligne("VLOAD file ADR: file>video memory") Then
                    Pas_Fonction += 1
                End If
            Case 8
                If Ecrit_Ligne("SAVE file Adr Len : save memory>file") Then
                    Pas_Fonction += 1
                End If
            Case 9
                If Ecrit_Ligne("VSAVE file ADR Len: >video memory") Then
                    Pas_Fonction += 1
                End If
            Case 10
                If Ecrit_Ligne("TYPE file     : Display file") Then
                    Pas_Fonction += 1
                End If
            Case 11
                If Ecrit_Ligne("DIR           : List current directory") Then
                    Pas_Fonction += 1
                End If
            Case 12
                If Ecrit_Ligne("CD nnnn       : enter in directory") Then
                    Pas_Fonction += 1
                End If
            Case 13
                If Ecrit_Ligne("CD..          : up directory") Then
                    Pas_Fonction += 1
                End If
            Case 14
                If Ecrit_Ligne("DEL           : delete file") Then
                    Pas_Fonction += 1
                End If
            Case 15
                If Ecrit_Ligne("GO  ADR       : Launch at ADR") Then
                    Pas_Fonction += 1
                End If
            Case 16
                If Ecrit_Ligne("CLS           : Clear The Screen") Then
                    Pas_Fonction += 1
                End If
            Case 17
                If Ecrit_Ligne("RESET         : RESET Hector") Then
                    Pas_Fonction += 1
                End If
            Case 18
                If Ecrit_Ligne("HELP          : Here we are!") Then
                    Pas_Fonction += 1
                End If
            Case 19
                If Ecrit_Ligne(" All data in hexa!") Then
                    Pas_Fonction += 1
                End If
            Case 20
                If Pen(1) Then
                    Pas_Fonction += 1
                End If
            Case 21
                If Ecrit_Ligne("Example" & vbCrLf & "LOAD B3X 4200 adress are always 4200") Then
                    Pas_Fonction += 1
                End If
            Case 22
                If Ecrit_Phrase("Press any key...") Then
                    Pas_Fonction += 1
                End If
            Case 23
                If Recup_Caractere(Octet) Then
                    Pas_Fonction += 1
                End If
            Case 24
                If Pen(3) Then
                    Pas_Fonction += 1
                End If
            Case 25
                If Ecrit_Ligne(vbCrLf & "VIDEO xxx.vid : play video file") Then
                    Pas_Fonction += 1
                End If
            Case 26
                If Pen(1) Then
                    Pas_Fonction += 1
                End If
            Case 27
                If Ecrit_Ligne(" ->Example") Then
                    Pas_Fonction += 1
                End If
            Case 28
                If Ecrit_Ligne("VIDEO BICHE.VID ") Then
                    Pas_Fonction += 1
                End If
            Case 29
                If Pen(3) Then
                    Pas_Fonction += 1
                End If
            Case 30
                If Ecrit_Ligne("play xxx.snd : play sound file") Then
                    Pas_Fonction += 1
                End If
            Case 31
                If Pen(1) Then
                    Pas_Fonction += 1
                End If
            Case 32
                If Ecrit_Ligne(" ->Example") Then
                    Pas_Fonction += 1
                End If
            Case 33
                If Ecrit_Ligne("PLAY LEJ.SND ") Then
                    Pas_Fonction += 1
                End If
            Case 34
                If Pen(2) Then
                    Pas_Fonction += 1
                End If
            Case 35
                If Ecrit_Ligne(vbCrLf + "Have FUN !!! " & vbCrLf & "Yo_Fr") Then
                    HELP = True
                    Pas_Fonction = 0
                End If
            Case Else
                HELP = True
        End Select

    End Function      ' permet de lister les commandes valide !
    Private Function CLS() As Boolean

        CLS = False
        Select Case Pas_Fonction
            Case 0 ' Code 4 => cls !
                If Envoi_Octet(4) Then 'Code 4 = cls !
                    Pas_Fonction = 0
                    CLS = True
                End If
            Case Else
                Pas_Fonction = 0
                CLS = True
        End Select
    End Function       ' Efface l'ecran !
    Private Function Play() As Boolean
        Static number As UInt64 = 0
        Static Longueur As UInt64 = 0
        Static Fichier As Byte()
        Static date1, date2 As System.DateTime
        Static Tmp As String
        Static Octet_C As Byte = &HFF

        Play = False

        Select Case Pas_Fonction

            Case 0
                If Ecrit_Ligne("Execution de la commande PLAY : " & vbCrLf & "File name : " & Param_Fonction(1)) Then
                    Pointeur = 0
                    Pas_Fonction += 1
                    Try
                        Fichier = Microsoft.VisualBasic.FileIO.FileSystem.ReadAllBytes(Directory & "\" & Param_Fonction(1))
                        Longueur = CULng(Fichier.Length)
                        If Longueur < (6) Then
                            'fichier trop court !
                            Pas_Fonction = 99
                        End If
                    Catch
                        'Error sur fichier ! 
                        Pas_Fonction = 98
                    End Try
                End If
            Case 1
                If Envoi_Octet(&HF) Then 'Code 15 = Play 1bit !
                    Pas_Fonction += 1
                    '         MainForm.Debuggage = True
                    date1 = Now
                End If
            Case 2
                If Envoi_Octet(&HF) Then 'Code 15 = Play 1bit !
                    Pointeur = 0 ' on raz le pointeur
                    Pas_Fonction += 1
                    '              MainForm.Debuggage = True
                    date1 = Now
                    Octet_C = &H54

                End If
            Case 3
                'C'est plus le 1er octet => en synchro par portA
                Disc2_data_write = Octet_C

                Dim TT As Byte
                If Octet_C = &H54 Then
                    TT = &H44
                Else
                    TT = &H54
                End If


                If (Disc2_data_w_ready = False) And (Disc2_data_read = TT) Then

                    Octet_C = TT
                    Disc2_data_write = Fichier(Pointeur)
                    Pointeur += 1
              
                    If (Disc2_data_write And 1) = 1 Then ' Détection de fin de fichier
                        Pas_Fonction += 1
                        Exit Select
                    End If

                End If
            Case 4
                date2 = Now
                Dim TempsMis As TimeSpan
                TempsMis = (date2 - date1)
                If TempsMis.Ticks > 0 Then
                    Tmp = "Temps mis :" & TempsMis.ToString & "  soit : " & Longueur.ToString & vbCrLf & " Freq =" & (Int(Longueur * 10000000 / TempsMis.Ticks))
                    Tmp += vbCrLf & "Sur Hector reel Freq = 59169 hz"
                Else
                    Tmp = "???"
                End If
                Pas_Fonction += 1
            Case 5
                If Ecrit_Ligne(Tmp) Then
                    Pointeur = 0
                    Pas_Fonction += 1
                End If
            Case 6

                Pas_Fonction = 0
                number = 0
                Play = True


                ' Traitement des erreurs !
            Case 98
                If Ecrit_Ligne("File exist?") Then
                    Pas_Fonction = 0
                    Play = True
                End If
            Case 99
                If Ecrit_Ligne("Error file too big!") Then
                    Pas_Fonction = 0
                    Play = True
                End If

        End Select

    End Function      ' permet de tester les codes fonction du microcode !
    Private Function Batch() As Boolean          ' Batch contenu dans un fichier
        Batch = False

    End Function
    Private Function DEL() As Boolean
        'Effacement fichier
   
        DEL = False

        Select Pas_Fonction
            Case 0
                Try
                    Microsoft.VisualBasic.FileIO.FileSystem.DeleteFile(Directory & "\" & Param_Fonction(1))
                    Pas_Fonction += 1
                Catch
                    'Error sur fichier ! 
                    Pas_Fonction = 98
                End Try
      
            Case 1
                DEL = True
                ' Traitement des erreurs !

            Case 98
                If Ecrit_Ligne("File exist?") Then
                    Pas_Fonction = 0
                    DEL = True
                End If

        End Select

    End Function

    Public Function Execute_Commande() As Boolean

        Execute_Commande = False

        Select Case Fonction
            Case 1
                ' On est dans l'exéctution de la fonction DIR
                Execute_Commande = DIR()
            Case 2
                Execute_Commande = LOAD()
            Case 3
                Execute_Commande = GO()
            Case 4
                Execute_Commande = CODE()
            Case 5
                Execute_Commande = Poke()
            Case 6
                Execute_Commande = CLS()
            Case 7
                Execute_Commande = RESETCMD()
            Case 8
                Execute_Commande = Peek()
            Case 9
                Execute_Commande = SAVE()
            Case 10
                Execute_Commande = Play()
            Case 11
                Execute_Commande = DEL()
            Case 20
                Execute_Commande = VIDEO()
            Case 23
                Execute_Commande = CD()
            Case 24
                Execute_Commande = CD__()
            Case 30
                Execute_Commande = Type_File()
            Case 97
                Execute_Commande = HELP()
            Case 98
                Execute_Commande = SYNTAXE()
            Case 99
                Execute_Commande = REDO()
            Case Else
                'Autre cas => sortie directe !
                Execute_Commande = True
        End Select

    End Function      ' Switch pour l'execution des commandes saisies!
    Public Sub Analyse_Commande(ByRef Ligne As String)
        ' Suite à la saisie d'une commande on arrive ici !
        Dim Trouve As Boolean = False
        Dim Car As String
        Dim Ind As Integer
        Dim Num_Param As Integer = 0
        Dim Started As Boolean = False

        Strg_ARD += "Commande : " & Ligne & vbCrLf

        Pas_Fonction = 0 ' pour le pas à pas des fonctions
        Param_Fonction(0) = ""
        Param_Fonction(1) = ""
        Param_Fonction(2) = ""
        Param_Fonction(3) = ""
        Param_Fonction(4) = ""
        Param_Fonction(5) = ""

        ' recupération des paramétres de la ligne de commande
        ' On separe dans un tableau les différents mots de la phrase !

        For Ind = 1 To Ligne.Length
            Car = Mid(Ligne, Ind, 1)
            If (Car = " ") And (Started) Then
                'On passe au paramtre suivant.
                Num_Param += 1
                If Num_Param > 4 Then
                    Num_Param = 4
                End If
                Started = False
            End If
            If Car <> " " Then
                ' on se mets sur le parametre suivant
                Param_Fonction(Num_Param) = Param_Fonction(Num_Param) & Car
                Started = True
            End If
        Next Ind

        'Analyse Commande : DIR
        ' sans parametres !
        If UCase(Param_Fonction(0)) = "DIR" Then
            Fonction = 1 'Dir sera exécuté !
            Trouve = True
        End If

        'Analyse Commande : LOAD
        If UCase(Param_Fonction(0)) = "LOAD" Then
            Fonction = 2 'Load sera exécuté !
            PVideo = False
            Trouve = True
            If Num_Param <> 2 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : VLOAD
        If UCase(Param_Fonction(0)) = "VLOAD" Then
            Fonction = 2 'Load sera exécuté !
            Trouve = True
            PVideo = True 'mais en page vidéo ! 
            If Num_Param <> 2 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : GO
        If UCase(Param_Fonction(0)) = "GO" Then
            Fonction = 3 'GO sera exécuté !

            ' controle recupération des paramétres de la ligne de commande
            If Num_Param <> 1 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
            Trouve = True
        End If

        'Analyse Commande : CODE
        If UCase(Param_Fonction(0)) = "CODE" Then
            Fonction = 4 'Code sera exécuté !

            Trouve = True
        End If

        'Analyse Commande : POKE
        If UCase(Param_Fonction(0)) = "POKE" Then
            Fonction = 5 'POKE sera exécuté !
            PVideo = False ' Mais en page programme !

            ' controle recupération des paramétres de la ligne de commande
            If Num_Param <> 2 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If

            Trouve = True
        End If

        'Analyse Commande : VPOKE
        If UCase(Param_Fonction(0)) = "VPOKE" Then
            Fonction = 5 'POKE sera exécuté !
            PVideo = True ' Mais en page vidéo !

            ' controle recupération des paramétres de la ligne de commande
            If Num_Param <> 2 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If

            Trouve = True
        End If

        'Analyse Commande : CLS
        If UCase(Param_Fonction(0)) = "CLS" Then
            Fonction = 6 'CLS sera exécuté !
            Trouve = True
        End If

        'Analyse Commande : RESET
        If UCase(Param_Fonction(0)) = "RESET" Then
            Fonction = 7 'RESETCMD sera exécuté !
            Trouve = True
        End If

        'Analyse Commande : PEEK
        If UCase(Param_Fonction(0)) = "PEEK" Then
            Fonction = 8 'PEEK sera exécuté !
            PVideo = False  ' Mais en page programme !

            ' controle recupération des paramétres de la ligne de commande
            If Num_Param <> 1 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If

            Trouve = True
        End If

        'Analyse Commande : VPEEK
        If UCase(Param_Fonction(0)) = "VPEEK" Then
            Fonction = 8 'PEEK sera exécuté !
            PVideo = True ' Mais en page vidéo !

            ' controle recupération des paramétres de la ligne de commande
            If Num_Param <> 1 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If

            Trouve = True
        End If

        'Analyse Commande : SAVE
        If UCase(Param_Fonction(0)) = "SAVE" Then
            Fonction = 9 'Save sera exécuté !
            PVideo = False
            Trouve = True
            If Num_Param <> 3 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : VSAVE
        If UCase(Param_Fonction(0)) = "VSAVE" Then
            Fonction = 9 'Save sera exécuté !
            PVideo = True
            Trouve = True
            If Num_Param <> 3 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : PLAY
        If UCase(Param_Fonction(0)) = "PLAY" Then
            Fonction = 10 'Save sera exécuté !
            Trouve = True
            If Num_Param <> 1 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : DEL
        If UCase(Param_Fonction(0)) = "DEL" Then
            Fonction = 11 'Save sera exécuté !
            Trouve = True
            If Num_Param <> 1 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : HELP
        If UCase(Param_Fonction(0)) = "HELP" Then
            Fonction = 97 'Help sera exécuté !
            Trouve = True
        End If

        'Analyse Commande : VIDEO
        If UCase(Param_Fonction(0)) = "VIDEO" Then
            Fonction = 20 'VIDEO sera exécuté !
            PVideo = False
            Trouve = True
            If Num_Param <> 1 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : CD
        If UCase(Param_Fonction(0)) = "CD" Then
            Fonction = 23 'CD sera exécuté !
            PVideo = False
            Trouve = True
            If Num_Param <> 1 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : CD..
        If UCase(Param_Fonction(0)) = "CD.." Then
            Fonction = 24 'CD sera exécuté !
            PVideo = False
            Trouve = True
            If Num_Param <> 0 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        'Analyse Commande : TYPE file
        If UCase(Param_Fonction(0)) = "TYPE" Then
            Fonction = 30 'TYPE sera exécuté !
            PVideo = False
            Trouve = True
            If Num_Param <> 1 Then
                Fonction = 98 'Error, il faut au moins un paramétre !
            End If
        End If

        If Not (Trouve) Or Num_Param > 3 Then
            'Erreur => REDO !
            Fonction = 99
        End If
    End Sub ' Analyseur syntaxtique
    'Fonction de BIOS
    Public Sub Reset()
        'On raz l'ensemble des pointeurs et des états
        PAS = 0
        PAS_SP = 0
        PAS_SP_N1 = 0
        Pas_Fonction = 0
        Fonction = 0
        Index = 0
        Recup_Caractere(0, True)
        Pointeur = 0
        Disc2_data_w_ready = False
        Disc2_data_r_ready = False
        Disc2_data_write = 0
        Disc2_data_read = 0

    End Sub
    Private Function Recup_Caractere(ByRef Octet As Byte, Optional ByRef Reset As Boolean = False) As Boolean
        Static PAS_SP As Integer = 0

        If Reset Then
            PAS_SP = 0
            Recup_Caractere = True
            Exit Function
        End If
        Recup_Caractere = False
        Select Case PAS_SP
            Case 0
                If Disc2_data_w_ready = False Then
                    ' C'est ok : on peu continuer
                    PAS_SP += 1
                End If
            Case 1
                'Envoi de l'octet 
                Disc2_data_write = 5
                Disc2_data_w_ready = True
                PAS_SP += 1
            Case 2
                If Disc2_data_r_ready = True Then
                    Octet = Disc2_data_read
                    Disc2_data_r_ready = False
                    Recup_Caractere = True
                    PAS_SP = 0
                End If
        End Select
    End Function
    Private Function Ecrit_Phrase(ByRef Phrase As String) As Boolean
        Static PAS_SP As Integer = 0
        Static Index As Integer = 0
        Dim Car As Char

        Ecrit_Phrase = False
        Select Case PAS_SP
            Case 0
                Index = Phrase.Length
                PAS_SP += 1
            Case 1
                Car = ChrW(Microsoft.VisualBasic.Asc(Microsoft.VisualBasic.Mid(Phrase, Phrase.Length - Index + 1, 1)))
                If Ecrit_Caractere(CByte(AscW(Car))) Then
                    PAS_SP += 1
                End If
            Case 2
                Index -= 1
                If Index > 0 Then
                    PAS_SP = 1
                Else
                    PAS_SP = 0
                    Ecrit_Phrase = True
                End If
        End Select

    End Function
    Private Function Ecrit_Octet(ByRef Adr As Integer, ByRef Value As Byte) As Boolean
        Static Adr_Low, Adr_High As Byte

        Ecrit_Octet = False

        Select Case PAS_SP_N1
            Case 0
                Adr_High = CByte(Adr >> 8)
                Adr_Low = CByte(Adr And &HFF)
                PAS_SP_N1 += 1
            Case 1
                If Envoi_Octet(9) Then 'Code 9 = ecriture d'un octet à l'adresse donnée !
                    PAS_SP_N1 += 1
                End If
            Case 2
                If Envoi_Octet(Adr_High) Then  ' Poids FORT : 00 adresse écriture
                    PAS_SP_N1 += 1
                End If
            Case 3
                If Envoi_Octet(Adr_Low) Then  ' Poids FAIBLE : 80 adresse écriture
                    PAS_SP_N1 += 1
                End If
            Case 4
                If Envoi_Octet(Value) Then  ' Valeur à écrire !
                    PAS_SP_N1 += 1
                End If
            Case 5
                PAS_SP_N1 = 0
                Ecrit_Octet = True
        End Select

    End Function
    Private Function Ecrit_Ligne(ByRef Phrase As String) As Boolean
        Dim Car As Char

        Ecrit_Ligne = False
        Select Case PAS_SP_N1
            Case 0
                Index = Phrase.Length
                PAS_SP_N1 += 1
            Case 1
                Car = ChrW(Microsoft.VisualBasic.Asc(Microsoft.VisualBasic.Mid(Phrase, Phrase.Length - Index + 1, 1)))
                If Ecrit_Caractere(CByte(AscW(Car))) Then
                    PAS_SP_N1 += 1
                End If
            Case 2
                Index -= 1
                If Index > 0 Then
                    PAS_SP_N1 = 1
                Else
                    PAS_SP_N1 += 1
                End If
            Case 3
                If Ecrit_Caractere(13) Then
                    PAS_SP_N1 += 1
                End If
            Case 4
                If Ecrit_Caractere(10) Then
                    PAS_SP_N1 = 0
                    Ecrit_Ligne = True
                End If
        End Select

    End Function
    Private Function Ecrit_Caractere(ByVal Code_Ascii As Byte) As Boolean

        Ecrit_Caractere = False

        Select Case PAS_SP
            Case 0
                If Disc2_data_w_ready = False Then
                    ' C'est ok : on peu continuer
                    PAS_SP += 1
                End If
            Case 1
                'Envoi de l'octet 
                Disc2_data_write = 6
                Disc2_data_w_ready = True
                PAS_SP += 1
            Case 2
                If Disc2_data_w_ready = False Then
                    ' C'est ok : on peu continuer
                    PAS_SP += 1
                End If
            Case 3
                'Envoi du Caractere 
                Disc2_data_write = Code_Ascii
                Disc2_data_w_ready = True
                PAS_SP = 0
                ' fin de travail 
                Ecrit_Caractere = True
        End Select

    End Function

    Private Function Pen(ByVal Color As Byte) As Boolean
        Static Pas_Pen As Integer = 0

        Pen = False

        Select Case Pas_Pen
            Case 0
                If Disc2_data_w_ready = False Then
                    ' C'est ok : on peu continuer
                    Pas_Pen += 1
                End If
            Case 1
                'Envoi de l'octet 
                Disc2_data_write = 11
                Disc2_data_w_ready = True
                Pas_Pen += 1
            Case 2
                If Disc2_data_w_ready = False Then
                    ' C'est ok : on peu continuer
                    Pas_Pen += 1
                End If
            Case 3
                'Envoi du Caractere 
                Disc2_data_write = Color
                Disc2_data_w_ready = True
                Pas_Pen = 0
                ' fin de travail 
                Pen = True
        End Select

    End Function
    Private Function Envoi_Octet(ByVal Octet As Byte) As Boolean
        ' A chaque appel on verifie la possibilité de le faire puis on envoi un octet (ATTENTION ON ATTEND PAS LA FIN DE RECEPTION)

        Envoi_Octet = False
        Select Case PAS_SP
            Case 0
                If Disc2_data_w_ready = False Then
                    ' C'est ok : on peu continuer
                    PAS_SP += 1
                End If
            Case 1
                'Envoi de l'octet 
                Disc2_data_write = Octet
                Disc2_data_w_ready = True
                PAS_SP = 0
                ' fin de travail 
                Envoi_Octet = True

        End Select
    End Function
    Private Function Lit_Octet(ByRef Octet As Byte) As Boolean
        ' A chaque appel on verifie la possibilité de le faire puis on envoi un octet (ATTENTION ON ATTEND PAS LA FIN DE RECEPTION)

        Lit_Octet = False
        Select Case PAS_SP
            Case 0
                If Disc2_data_r_ready = True Then
                    ' C'est ok : on peu continuer
                    PAS_SP += 1
                End If
            Case 1
                'Lecture de l'octet 
                Octet = Disc2_data_read
                Disc2_data_r_ready = False
                PAS_SP = 0
                ' fin de travail 
                Lit_Octet = True

        End Select
    End Function

End Module