
'Copyright  2016 Jean-Jacques STACINO
' author mail : jj.stac @ aliceadsl.fr


'This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


' This file is part of VBHector.

'    VBHector is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.

'    Foobar is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.

'    You should have received a copy of the GNU General Public License
'    along with VBHector.  If not, see <http://www.gnu.org/licenses/>.

' Several part such as modZ80, modAY8912 are from GPL project (VBSpec)
'   Tranlation from VB6 to VBNet and much more had been made.
'   Thanks' to them authors (Chris Cowley, Xavier) 
'   Note that the original files from Chris Cowley are joined to this project (Directory "Sources Licences" . 
' Emulation of the MEA8000 is from A.Mine, that I want to thank here for him's agreement.



'24.03.2005
' Cr par Yo_Fr


Public Class Transfert
    Inherits System.Windows.Forms.Form

    ' Dclarations
    Dim sFile As String
    Friend WithEvents Label2ligne As System.Windows.Forms.Label
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents ProgressBar1 As System.Windows.Forms.ProgressBar
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents CheckPhase As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBR As System.Windows.Forms.CheckBox
    Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents Button_option As System.Windows.Forms.Button
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents RadioButtonTimingP As System.Windows.Forms.RadioButton
    Friend WithEvents RadioButtonTimingS As System.Windows.Forms.RadioButton
    Friend WithEvents Label4 As System.Windows.Forms.Label
    Friend WithEvents Label6 As System.Windows.Forms.Label
    Friend WithEvents Label5 As System.Windows.Forms.Label
    Friend WithEvents TextBoxSynchro As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxZero As System.Windows.Forms.TextBox
    Friend WithEvents TextBoxUn As System.Windows.Forms.TextBox
    Friend WithEvents Label9 As System.Windows.Forms.Label
    Friend WithEvents Label8 As System.Windows.Forms.Label
    Friend WithEvents Label7 As System.Windows.Forms.Label
    Friend WithEvents Label10 As System.Windows.Forms.Label
    Friend WithEvents TextBoxFE As System.Windows.Forms.TextBox
    Friend WithEvents Label11 As System.Windows.Forms.Label
    Friend WithEvents Label12 As System.Windows.Forms.Label
    Friend WithEvents TextBoxAmorce As System.Windows.Forms.TextBox
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents RadioForth As System.Windows.Forms.RadioButton
    Friend WithEvents RadioBloc As System.Windows.Forms.RadioButton
    Friend WithEvents Label13 As System.Windows.Forms.Label
    Friend WithEvents TextBlocText As System.Windows.Forms.TextBox
    Friend WithEvents Label14 As System.Windows.Forms.Label
    Friend WithEvents RichHelper As System.Windows.Forms.RichTextBox
    Dim dFile As String

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer
    Friend WithEvents Button1 As System.Windows.Forms.Button
    Friend WithEvents LabelNom As System.Windows.Forms.Label
    Friend WithEvents Button_Quit As System.Windows.Forms.Button

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnSinusMono8 As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.btnSinusMono8 = New System.Windows.Forms.Button()
        Me.Button1 = New System.Windows.Forms.Button()
        Me.LabelNom = New System.Windows.Forms.Label()
        Me.Button_Quit = New System.Windows.Forms.Button()
        Me.Label2ligne = New System.Windows.Forms.Label()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.ProgressBar1 = New System.Windows.Forms.ProgressBar()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.CheckPhase = New System.Windows.Forms.CheckBox()
        Me.CheckBR = New System.Windows.Forms.CheckBox()
        Me.TextBox1 = New System.Windows.Forms.TextBox()
        Me.Label3 = New System.Windows.Forms.Label()
        Me.Button_option = New System.Windows.Forms.Button()
        Me.GroupBox1 = New System.Windows.Forms.GroupBox()
        Me.TextBoxZero = New System.Windows.Forms.TextBox()
        Me.TextBoxUn = New System.Windows.Forms.TextBox()
        Me.TextBoxSynchro = New System.Windows.Forms.TextBox()
        Me.Label6 = New System.Windows.Forms.Label()
        Me.Label5 = New System.Windows.Forms.Label()
        Me.Label9 = New System.Windows.Forms.Label()
        Me.Label8 = New System.Windows.Forms.Label()
        Me.Label7 = New System.Windows.Forms.Label()
        Me.Label4 = New System.Windows.Forms.Label()
        Me.RadioButtonTimingP = New System.Windows.Forms.RadioButton()
        Me.RadioButtonTimingS = New System.Windows.Forms.RadioButton()
        Me.Label10 = New System.Windows.Forms.Label()
        Me.TextBoxFE = New System.Windows.Forms.TextBox()
        Me.Label11 = New System.Windows.Forms.Label()
        Me.Label12 = New System.Windows.Forms.Label()
        Me.TextBoxAmorce = New System.Windows.Forms.TextBox()
        Me.GroupBox2 = New System.Windows.Forms.GroupBox()
        Me.Label14 = New System.Windows.Forms.Label()
        Me.Label13 = New System.Windows.Forms.Label()
        Me.TextBlocText = New System.Windows.Forms.TextBox()
        Me.RadioForth = New System.Windows.Forms.RadioButton()
        Me.RadioBloc = New System.Windows.Forms.RadioButton()
        Me.RichHelper = New System.Windows.Forms.RichTextBox()
        Me.GroupBox1.SuspendLayout()
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'btnSinusMono8
        '
        Me.btnSinusMono8.Location = New System.Drawing.Point(95, 175)
        Me.btnSinusMono8.Name = "btnSinusMono8"
        Me.btnSinusMono8.Size = New System.Drawing.Size(158, 23)
        Me.btnSinusMono8.TabIndex = 1
        Me.btnSinusMono8.Text = "Lancer conversion"
        Me.btnSinusMono8.Visible = False
        '
        'Button1
        '
        Me.Button1.Location = New System.Drawing.Point(23, 12)
        Me.Button1.Name = "Button1"
        Me.Button1.Size = New System.Drawing.Size(103, 28)
        Me.Button1.TabIndex = 2
        Me.Button1.Text = "Choisir fichier K7"
        Me.Button1.UseVisualStyleBackColor = True
        '
        'LabelNom
        '
        Me.LabelNom.AutoSize = True
        Me.LabelNom.Location = New System.Drawing.Point(20, 109)
        Me.LabelNom.Name = "LabelNom"
        Me.LabelNom.Size = New System.Drawing.Size(179, 13)
        Me.LabelNom.TabIndex = 3
        Me.LabelNom.Text = "Choisissez au pralable un fichier K7"
        '
        'Button_Quit
        '
        Me.Button_Quit.Location = New System.Drawing.Point(336, 370)
        Me.Button_Quit.Name = "Button_Quit"
        Me.Button_Quit.Size = New System.Drawing.Size(76, 28)
        Me.Button_Quit.TabIndex = 4
        Me.Button_Quit.Text = "Quitter"
        Me.Button_Quit.UseVisualStyleBackColor = True
        '
        'Label2ligne
        '
        Me.Label2ligne.AutoSize = True
        Me.Label2ligne.Location = New System.Drawing.Point(20, 143)
        Me.Label2ligne.Name = "Label2ligne"
        Me.Label2ligne.Size = New System.Drawing.Size(10, 13)
        Me.Label2ligne.TabIndex = 5
        Me.Label2ligne.Text = "."
        '
        'Label1
        '
        Me.Label1.AutoSize = True
        Me.Label1.Location = New System.Drawing.Point(20, 126)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(10, 13)
        Me.Label1.TabIndex = 6
        Me.Label1.Text = "."
        '
        'ProgressBar1
        '
        Me.ProgressBar1.Location = New System.Drawing.Point(12, 229)
        Me.ProgressBar1.Name = "ProgressBar1"
        Me.ProgressBar1.Size = New System.Drawing.Size(400, 23)
        Me.ProgressBar1.TabIndex = 7
        '
        'Label2
        '
        Me.Label2.AutoSize = True
        Me.Label2.Location = New System.Drawing.Point(79, 210)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(10, 13)
        Me.Label2.TabIndex = 8
        Me.Label2.Text = "-"
        '
        'CheckPhase
        '
        Me.CheckPhase.AutoSize = True
        Me.CheckPhase.Location = New System.Drawing.Point(430, 10)
        Me.CheckPhase.Name = "CheckPhase"
        Me.CheckPhase.Size = New System.Drawing.Size(187, 17)
        Me.CheckPhase.TabIndex = 10
        Me.CheckPhase.Text = "Inverser la phase du signal produit"
        Me.CheckPhase.UseVisualStyleBackColor = True
        '
        'CheckBR
        '
        Me.CheckBR.AutoSize = True
        Me.CheckBR.Location = New System.Drawing.Point(27, 57)
        Me.CheckBR.Name = "CheckBR"
        Me.CheckBR.Size = New System.Drawing.Size(242, 17)
        Me.CheckBR.TabIndex = 11
        Me.CheckBR.Text = "Obtimisation nb cycles inter-bloc hors FE (4/8)"
        Me.CheckBR.UseVisualStyleBackColor = True
        '
        'TextBox1
        '
        Me.TextBox1.Location = New System.Drawing.Point(283, 55)
        Me.TextBox1.Name = "TextBox1"
        Me.TextBox1.Size = New System.Drawing.Size(48, 20)
        Me.TextBox1.TabIndex = 12
        Me.TextBox1.Text = "4"
        Me.TextBox1.Visible = False
        '
        'Label3
        '
        Me.Label3.AutoSize = True
        Me.Label3.Location = New System.Drawing.Point(-2, 392)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(158, 13)
        Me.Label3.TabIndex = 13
        Me.Label3.Text = "JJS - 07/11/2009 - 01/01/2016"
        '
        'Button_option
        '
        Me.Button_option.Location = New System.Drawing.Point(286, 12)
        Me.Button_option.Name = "Button_option"
        Me.Button_option.Size = New System.Drawing.Size(126, 28)
        Me.Button_option.TabIndex = 15
        Me.Button_option.Text = "Options avances >>"
        Me.Button_option.UseVisualStyleBackColor = True
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.Add(Me.TextBoxZero)
        Me.GroupBox1.Controls.Add(Me.TextBoxUn)
        Me.GroupBox1.Controls.Add(Me.TextBoxSynchro)
        Me.GroupBox1.Controls.Add(Me.Label6)
        Me.GroupBox1.Controls.Add(Me.Label5)
        Me.GroupBox1.Controls.Add(Me.Label9)
        Me.GroupBox1.Controls.Add(Me.Label8)
        Me.GroupBox1.Controls.Add(Me.Label7)
        Me.GroupBox1.Controls.Add(Me.Label4)
        Me.GroupBox1.Controls.Add(Me.RadioButtonTimingP)
        Me.GroupBox1.Controls.Add(Me.RadioButtonTimingS)
        Me.GroupBox1.Location = New System.Drawing.Point(430, 229)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(306, 174)
        Me.GroupBox1.TabIndex = 16
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Timing Bit"
        '
        'TextBoxZero
        '
        Me.TextBoxZero.Location = New System.Drawing.Point(200, 136)
        Me.TextBoxZero.Name = "TextBoxZero"
        Me.TextBoxZero.Size = New System.Drawing.Size(77, 20)
        Me.TextBoxZero.TabIndex = 2
        '
        'TextBoxUn
        '
        Me.TextBoxUn.Location = New System.Drawing.Point(200, 101)
        Me.TextBoxUn.Name = "TextBoxUn"
        Me.TextBoxUn.Size = New System.Drawing.Size(77, 20)
        Me.TextBoxUn.TabIndex = 2
        '
        'TextBoxSynchro
        '
        Me.TextBoxSynchro.Location = New System.Drawing.Point(200, 68)
        Me.TextBoxSynchro.Name = "TextBoxSynchro"
        Me.TextBoxSynchro.Size = New System.Drawing.Size(77, 20)
        Me.TextBoxSynchro.TabIndex = 2
        '
        'Label6
        '
        Me.Label6.AutoSize = True
        Me.Label6.Location = New System.Drawing.Point(24, 139)
        Me.Label6.Name = "Label6"
        Me.Label6.Size = New System.Drawing.Size(90, 13)
        Me.Label6.TabIndex = 1
        Me.Label6.Text = "Zro        = 0.6ms"
        '
        'Label5
        '
        Me.Label5.AutoSize = True
        Me.Label5.Location = New System.Drawing.Point(24, 108)
        Me.Label5.Name = "Label5"
        Me.Label5.Size = New System.Drawing.Size(88, 13)
        Me.Label5.TabIndex = 1
        Me.Label5.Text = "Un          = 0.9ms"
        '
        'Label9
        '
        Me.Label9.AutoSize = True
        Me.Label9.Location = New System.Drawing.Point(280, 139)
        Me.Label9.Name = "Label9"
        Me.Label9.Size = New System.Drawing.Size(20, 13)
        Me.Label9.TabIndex = 1
        Me.Label9.Text = "ms"
        '
        'Label8
        '
        Me.Label8.AutoSize = True
        Me.Label8.Location = New System.Drawing.Point(280, 104)
        Me.Label8.Name = "Label8"
        Me.Label8.Size = New System.Drawing.Size(20, 13)
        Me.Label8.TabIndex = 1
        Me.Label8.Text = "ms"
        '
        'Label7
        '
        Me.Label7.AutoSize = True
        Me.Label7.Location = New System.Drawing.Point(280, 71)
        Me.Label7.Name = "Label7"
        Me.Label7.Size = New System.Drawing.Size(20, 13)
        Me.Label7.TabIndex = 1
        Me.Label7.Text = "ms"
        '
        'Label4
        '
        Me.Label4.AutoSize = True
        Me.Label4.Location = New System.Drawing.Point(24, 71)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(89, 13)
        Me.Label4.TabIndex = 1
        Me.Label4.Text = "Synchro  = 1.5ms"
        '
        'RadioButtonTimingP
        '
        Me.RadioButtonTimingP.AutoSize = True
        Me.RadioButtonTimingP.Location = New System.Drawing.Point(200, 28)
        Me.RadioButtonTimingP.Name = "RadioButtonTimingP"
        Me.RadioButtonTimingP.Size = New System.Drawing.Size(90, 17)
        Me.RadioButtonTimingP.TabIndex = 0
        Me.RadioButtonTimingP.TabStop = True
        Me.RadioButtonTimingP.Text = "Personnaliss"
        Me.RadioButtonTimingP.UseVisualStyleBackColor = True
        '
        'RadioButtonTimingS
        '
        Me.RadioButtonTimingS.AutoSize = True
        Me.RadioButtonTimingS.Location = New System.Drawing.Point(6, 28)
        Me.RadioButtonTimingS.Name = "RadioButtonTimingS"
        Me.RadioButtonTimingS.Size = New System.Drawing.Size(139, 17)
        Me.RadioButtonTimingS.TabIndex = 0
        Me.RadioButtonTimingS.TabStop = True
        Me.RadioButtonTimingS.Text = "Standard (Doc. Monitrix)"
        Me.RadioButtonTimingS.UseVisualStyleBackColor = True
        '
        'Label10
        '
        Me.Label10.AutoSize = True
        Me.Label10.Location = New System.Drawing.Point(20, 90)
        Me.Label10.Name = "Label10"
        Me.Label10.Size = New System.Drawing.Size(10, 13)
        Me.Label10.TabIndex = 17
        Me.Label10.Text = "."
        '
        'TextBoxFE
        '
        Me.TextBoxFE.Location = New System.Drawing.Point(283, 84)
        Me.TextBoxFE.Name = "TextBoxFE"
        Me.TextBoxFE.Size = New System.Drawing.Size(48, 20)
        Me.TextBoxFE.TabIndex = 18
        Me.TextBoxFE.Text = "150"
        '
        'Label11
        '
        Me.Label11.AutoSize = True
        Me.Label11.Location = New System.Drawing.Point(24, 86)
        Me.Label11.Name = "Label11"
        Me.Label11.Size = New System.Drawing.Size(243, 13)
        Me.Label11.TabIndex = 19
        Me.Label11.Text = "Nombre de cycle de synchro aprs bloc FE (150) :"
        '
        'Label12
        '
        Me.Label12.AutoSize = True
        Me.Label12.Location = New System.Drawing.Point(24, 115)
        Me.Label12.Name = "Label12"
        Me.Label12.Size = New System.Drawing.Size(232, 13)
        Me.Label12.TabIndex = 21
        Me.Label12.Text = "Nombre de cycle de synchro de l'amorce (768) :"
        '
        'TextBoxAmorce
        '
        Me.TextBoxAmorce.Location = New System.Drawing.Point(283, 113)
        Me.TextBoxAmorce.Name = "TextBoxAmorce"
        Me.TextBoxAmorce.Size = New System.Drawing.Size(48, 20)
        Me.TextBoxAmorce.TabIndex = 20
        Me.TextBoxAmorce.Text = "768"
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.Label14)
        Me.GroupBox2.Controls.Add(Me.Label13)
        Me.GroupBox2.Controls.Add(Me.TextBlocText)
        Me.GroupBox2.Controls.Add(Me.RadioForth)
        Me.GroupBox2.Controls.Add(Me.RadioBloc)
        Me.GroupBox2.Controls.Add(Me.TextBox1)
        Me.GroupBox2.Controls.Add(Me.Label12)
        Me.GroupBox2.Controls.Add(Me.TextBoxFE)
        Me.GroupBox2.Controls.Add(Me.Label11)
        Me.GroupBox2.Controls.Add(Me.TextBoxAmorce)
        Me.GroupBox2.Controls.Add(Me.CheckBR)
        Me.GroupBox2.Location = New System.Drawing.Point(430, 39)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(350, 179)
        Me.GroupBox2.TabIndex = 22
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "Gestion des Blocs"
        '
        'Label14
        '
        Me.Label14.AutoSize = True
        Me.Label14.Location = New System.Drawing.Point(71, 159)
        Me.Label14.Name = "Label14"
        Me.Label14.Size = New System.Drawing.Size(185, 13)
        Me.Label14.TabIndex = 25
        Me.Label14.Text = "(822 = cran FORTH, 0 = 1 seul bloc)"
        '
        'Label13
        '
        Me.Label13.AutoSize = True
        Me.Label13.Location = New System.Drawing.Point(24, 140)
        Me.Label13.Name = "Label13"
        Me.Label13.Size = New System.Drawing.Size(144, 13)
        Me.Label13.TabIndex = 24
        Me.Label13.Text = "Taille du bloc texte (en octet)"
        '
        'TextBlocText
        '
        Me.TextBlocText.Location = New System.Drawing.Point(283, 138)
        Me.TextBlocText.Name = "TextBlocText"
        Me.TextBlocText.Size = New System.Drawing.Size(48, 20)
        Me.TextBlocText.TabIndex = 23
        Me.TextBlocText.Text = "822"
        '
        'RadioForth
        '
        Me.RadioForth.AutoSize = True
        Me.RadioForth.Location = New System.Drawing.Point(200, 19)
        Me.RadioForth.Name = "RadioForth"
        Me.RadioForth.Size = New System.Drawing.Size(131, 17)
        Me.RadioForth.TabIndex = 22
        Me.RadioForth.TabStop = True
        Me.RadioForth.Text = "Bloc  taille fixe (Forth)"
        Me.RadioForth.UseVisualStyleBackColor = True
        '
        'RadioBloc
        '
        Me.RadioBloc.AutoSize = True
        Me.RadioBloc.Checked = True
        Me.RadioBloc.Location = New System.Drawing.Point(6, 19)
        Me.RadioBloc.Name = "RadioBloc"
        Me.RadioBloc.Size = New System.Drawing.Size(144, 17)
        Me.RadioBloc.TabIndex = 3
        Me.RadioBloc.TabStop = True
        Me.RadioBloc.Text = "Par Blocs standard (TOL)"
        Me.RadioBloc.UseVisualStyleBackColor = True
        '
        'RichHelper
        '
        Me.RichHelper.Location = New System.Drawing.Point(12, 268)
        Me.RichHelper.Name = "RichHelper"
        Me.RichHelper.Size = New System.Drawing.Size(400, 96)
        Me.RichHelper.TabIndex = 23
        Me.RichHelper.Text = ""
        '
        'Transfert
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(787, 407)
        Me.Controls.Add(Me.RichHelper)
        Me.Controls.Add(Me.GroupBox2)
        Me.Controls.Add(Me.Label10)
        Me.Controls.Add(Me.GroupBox1)
        Me.Controls.Add(Me.Button_option)
        Me.Controls.Add(Me.Label3)
        Me.Controls.Add(Me.CheckPhase)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.ProgressBar1)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.Label2ligne)
        Me.Controls.Add(Me.Button_Quit)
        Me.Controls.Add(Me.LabelNom)
        Me.Controls.Add(Me.Button1)
        Me.Controls.Add(Me.btnSinusMono8)
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow
        Me.Name = "Transfert"
        Me.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "Transfert K7 => WAV (Hector) - yo_fr"
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox1.PerformLayout()
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)
        Me.PerformLayout()

    End Sub

#End Region
    '13 champs a remplir
    Dim F1 As String = "RIFF"     ' RIFF-BlockIdentifyer
    Dim F2 As Integer             ' RIFF-BlockLength = Total Bytes minus 8
    Dim F3 As String = "WAVE"     ' identifyer
    Dim F4 As String = "fmt "     ' fmtBlock-identifyer
    Dim F5 As Integer = 16        ' fmtBlock-length , 16 voor PCMformat
    Dim F6 As Short = 1           ' 1 for PCM classic not compressed
    Dim F7 As Short               ' Number of channels (1=mono  2=stereo)
    Dim F8 As Integer             ' SamplingFreq
    Dim F9 As Integer             ' Bytes per second = BytesPerSample * SampleRate
    Dim F10 As Short              ' Bytes by sample = MS * BitR / 8
    Dim F11 As Short              ' bitResolution 
    Dim F12 As String = "data"    ' dataBlock-identifyer
    Dim F13 As Integer            ' dataBlock-length, inclusief de laste NUL-char. 
    Dim i1, i2 As Integer
    Dim S1, S2 As String
    Dim No_S, No_D As Integer
    Dim data(1) As Short          ' conteneur bloc data
    Dim Lon As Integer          ' longueur bloc data
    Dim Phase_on As Short
    Dim Phase_off As Short
    Dim HR_BR As Integer
    Dim Fixed_bloc As Boolean    ' pour les crans FORTH
    Dim Long_fixed_bloc As Integer


    Private Sub Remplir_bit(ByVal L As Integer)
        Dim i, Half As Integer
        Half = L / 2
        For i = 1 To L
            If i < Half Then
                data(Lon) = Phase_on ' 1ere phase    //////ATTENTION MON Cble est crois, faire inversion de phase!
            Else
                data(Lon) = Phase_off   ' 2eme phase
            End If
            'on monte le pointeur
            Lon += 1
        Next
    End Sub

    Private Sub btnSinusMono8_Click(ByVal sender As System.Object, _
                                    ByVal e As System.EventArgs) Handles btnSinusMono8.Click

        Dim SRate As Integer = 44100 ' sample frequence
        Dim Tsec As Integer = 3      ' dure en seconde
        Dim BitR As Short = 16       ' resolution en bits
        Dim MS As Short = 1          ' nombre de canaux (1=mono, 2=stereo)
        Dim Header_cycles As Integer
        Dim Zero_cycles As Integer
        Dim Un_cycles As Integer
        Dim I As Integer
        Dim Taille_Table As Integer
        Dim Nb_Cycle_Synchro As Integer
        Dim Nb_cycle_inter_bloc As Integer
        Dim Nb_cycle_inter_bloc_FE As Integer
        Dim Nb_cycle_bloc_Amorce As Integer


        'Mise en place de la phase demande
        If CheckPhase.Checked And (Me.Width >= 400) Then
            'inversion
            Phase_on = -32000
            Phase_off = +32000
        Else
            ' Normal
            Phase_on = +32000
            Phase_off = -32000
        End If

        '   Header 	400h cycles mini    =>  1,5ms mesur / dans MESS sur un wav reel = 1a / 1b
        '   0	                        =>	0,4ms mesur / dans MESS sur un wav reel = 9/a
        '   1	                        => 	0,9ms mesur / dans MESS sur un wav reel = 10/12

        ' Calcul des temps
        ' Hearder 1,5ms
        ' 44100 cycles / seconde
        If (Me.Width < 400) Or RadioButtonTimingS.Checked Then
            ' Valeurs standard
            Header_cycles = SRate * 1.5 / 1000  'mesure 10 sinus complete = 0,018 => 1,8ms 0,035 pour 20 => 1,75ms
            Zero_cycles = SRate * 0.4 / 1000    ' mesure 0,61ms
            Un_cycles = SRate * 0.9 / 1000      ' 1 mesure = 1,13
        Else
            ' Valeurs presonnalises
            Header_cycles = SRate * Microsoft.VisualBasic.Val(TextBoxSynchro.Text) / 1000  'mesure 10 sinus complete = 0,018 => 1,8ms 0,035 pour 20 => 1,75ms
            Zero_cycles = SRate * Microsoft.VisualBasic.Val(TextBoxZero.Text) / 1000    ' mesure 0,61ms
            Un_cycles = SRate * Microsoft.VisualBasic.Val(TextBoxUn.Text) / 1000      ' 1 mesure = 1,13
        End If

        'controle valeur
        If Header_cycles < 4 Or Zero_cycles < 4 Or Un_cycles < 4 Then
            Dim Str As String
            Str = "Le temps pour "
            If Header_cycles < 4 Then
                Str += "la synchronisation "
            End If
            If Zero_cycles < 4 Then
                Str += "un bit  ZERO "
            End If
            If Un_cycles < 4 Then
                Str += "un bit  UN "
            End If
            Str += " est trop court !"
            MsgBox(Str, MsgBoxStyle.OkOnly & MsgBoxStyle.Critical, "Erreur sur les timings de bit!")
            Label2.Text = "Relancez la conversion avec de nouveaux paramtres !"
            Exit Sub
        End If

        'mise en place nb cyles synchro entre 2 bloc hors bloc FE
        If (Me.Width > 400) And CheckBR.Checked Then
            Nb_cycle_inter_bloc = TextBox1.Text - 1
            If Nb_cycle_inter_bloc <= 0 Then
                MsgBox("Nombre de cycle inter-bloc normal n'est pas correct !", MsgBoxStyle.Critical & MsgBoxStyle.OkOnly, "Erreur sur le timing inter-bloc normal")
                Label2.Text = "Relancez la conversion avec de nouveaux paramtres !"
                Exit Sub
            End If
        Else
            Nb_cycle_inter_bloc = 80
        End If

        'mise en place nb cyles synchro entre 2 bloc : bloc FE
        If (Me.Width > 400) Then
            Nb_cycle_inter_bloc_FE = TextBoxFE.Text - 1
            If Nb_cycle_inter_bloc_FE <= 0 Then
                MsgBox("Nombre de cycle inter-bloc (type FE) n'est pas correct !", MsgBoxStyle.Critical & MsgBoxStyle.OkOnly, "Erreur sur le timing inter-bloc type FE")
                Label2.Text = "Relancez la conversion avec de nouveaux paramtres !"
                Exit Sub
            End If
        Else
            Nb_cycle_inter_bloc_FE = 140
        End If

        'mise en place nb cyles synchro en amorce
        If (Me.Width > 400) Then
            Nb_cycle_bloc_Amorce = TextBoxAmorce.Text - 1
            If Nb_cycle_bloc_Amorce <= 0 Then
                MsgBox("Nombre de cycle d'amorce n'est pas correct !", MsgBoxStyle.Critical & MsgBoxStyle.OkOnly, "Nombre de cycle d'amorce")
                Label2.Text = "Relancez la conversion avec de nouveaux paramtres !"
                Exit Sub
            End If
        Else
            Nb_cycle_bloc_Amorce = 3000
        End If

        ' Verification des donnes pour les fichiers texte, ventuellement dcoups en blocs
        ' de taille fixe (cas des crans du forth)
        Fixed_bloc = RadioForth.Checked
        Long_fixed_bloc = TextBlocText.Text

        ' ouverture fichier source :
        No_S = FreeFile()
        FileOpen(No_S, sFile, OpenMode.Binary)
        ProgressBar1.Maximum = FileLen(sFile)
        Label2.Text = "Phase 1 cration des donnes"
        Lon = 0

        ' init tableau
        Taille_Table = 1000000
        ReDim Preserve data(Taille_Table + 1)

        'Header
        For I = 0 To Nb_cycle_bloc_Amorce  '300h mini (768d)
            Remplir_bit(Header_cycles)
        Next I

        FileWidth(No_S, 1)
        Dim Val As Byte
        Dim Position As Integer
        Dim Masque As Byte
        Dim Start_TOL As Boolean
        Dim Taille_Bloc As Integer
        Dim Nb_bloc As Integer
        Dim Dernier_Octet As Byte

        Start_TOL = False
        Taille_Bloc = 0

        Do Until EOF(No_S)
            Position += 1
            'Controle taille table
            If Lon > (Taille_Table - Un_cycles * 8 * 2 - 1010 * Header_cycles) Then
                Taille_Table += 150000
                ReDim Preserve data(Taille_Table + 1)
                ProgressBar1.Value = Position
                System.Windows.Forms.Application.DoEvents()
            End If

            'Lecture octet du fichier *.k7
            FileGet(No_S, Val)


            ' Codage de l'octet lu
            Masque = 1
            For I = 0 To 7
                If (Val And Masque) <> 0 Then
                    Remplir_bit(Un_cycles)
                Else
                    Remplir_bit(Zero_cycles)
                End If

                Masque = Masque << 1
            Next I
            If Not (Fixed_bloc) Then
                ' cas des blocs standards 
                ' Dbut de Block de la TOL ?
                If Not (Start_TOL) Then
                    'Nouveau Block => init compteur d'octets
                    If Val <> 0 Then
                        Taille_Bloc = Val + 1
                    Else
                        Taille_Bloc = 257
                    End If
                    Start_TOL = True
                    Nb_bloc += 1
                End If
            Else
                'Cas des block texte
                If Not (Start_TOL) Then
                    If Long_fixed_bloc > 0 Then
                        Taille_Bloc = Long_fixed_bloc
                    Else
                        Taille_Bloc = 1
                    End If
                    Start_TOL = True
                    Nb_bloc += 1
                End If
            End If

            ' Verification de fin de Bloc
            Taille_Bloc -= 1

            If Taille_Bloc = 0 Then
                ' On est au bout du bloc => un peu de synchro SVP
                If Not (Fixed_bloc) Then
                    'Bloc de longeur variable,
                    ' Si le bloc prcdent se terminait par FE celui ci lancera l'execution de la 
                    ' commande de remplissage dans Hector => on agrandi le nb de synchro
                    If Dernier_Octet = &HFE Then
                        Nb_Cycle_Synchro = Nb_cycle_inter_bloc_FE
                    Else
                        Nb_Cycle_Synchro = Nb_cycle_inter_bloc
                    End If
                Else
                    ' cas des blocs de taille fixe
                    If Long_fixed_bloc > 0 Then
                        Nb_Cycle_Synchro = Nb_cycle_bloc_Amorce
                    Else
                        Nb_Cycle_Synchro = 0
                    End If
                End If
                If Nb_Cycle_Synchro <> 0 Then
                    'uniquement si des synchro doivent tre mis en place
                    For I = 0 To Nb_Cycle_Synchro
                        Remplir_bit(Header_cycles)
                    Next I
                    Start_TOL = False
                    Dernier_Octet = Val ' Dernier octet du bloc 
                End If
            End If

        Loop

        For I = 0 To 10
            Remplir_bit(Zero_cycles)
        Next I

        'Sauvegarde fichier
        If Dir(dFile) <> "" Then Kill(dFile)
        No_D = FreeFile()
        FileOpen(No_D, dFile, OpenMode.Binary)
        Label2.Text = "Phase 2 criture du fichier, nb bloc =" & Nb_bloc
        System.Windows.Forms.Application.DoEvents()


        '-----prepare headerfields --------
        F1 = "RIFF"
        F2 = F2                      ' not set yet 
        F3 = F3                      ' already set
        F4 = F4                      ' already set  
        F5 = 16                      ' fmtBlockLength
        F6 = 1                       ' 1=PCM classic, not compressed
        F7 = MS                      ' 1=mono, 2=stereo  
        F8 = SRate                   ' samplingRate(Frequency)
        F9 = MS * SRate * (BitR / 8) ' total number of bytes per sec
        F10 = MS * (BitR / 8)        ' BlockAlign
        F11 = BitR                   ' bits per sample ( resolution )
        F12 = "data"                 ' "data"
        F13 = MS * Lon * 2           ' dataBlock-length 
        F2 = F13 + 44 - 8            ' RiffBlock-length


        ' sauvegarde du header fichier RIFF
        FilePut(No_D, F1)    '  4 bytes
        FilePut(No_D, F2)    '  4 b
        FilePut(No_D, F3)    '  4 b
        FilePut(No_D, F4)    '  4 b
        FilePut(No_D, F5)    '  4 b
        FilePut(No_D, F6)    '  2 b
        FilePut(No_D, F7)    '  2 b
        FilePut(No_D, F8)    '  4 b
        FilePut(No_D, F9)    '  4 b
        FilePut(No_D, F10)   '  2 b
        FilePut(No_D, F11)   '  2 b
        FilePut(No_D, F12)   '  4 b
        FilePut(No_D, F13)   '  4 b 

        'On rajuste la taille du buffer au juste necessaire
        ReDim Preserve data(Lon + 10)

        'sauvegarde des donnes chunck
        FilePutObject(No_D, data)

        'On libre les fichiers ...
        FileClose(No_S)
        FileClose(No_D)

        'Indication de fin
        'Label2.Text = "Termin !"

    End Sub

    Private Sub Button_Quit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Quit.Click
        Me.Visible = False
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim dialogOpen As New OpenFileDialog

        With dialogOpen
            .InitialDirectory = "C:\MinGW\MESS\Cassette"        'rpertoire sur lequel s'ouvrira la boite
            .Title = "Choisir un fichier source K7"           'titre de la barre  
            .Filter = "Fichiers cassette HECTOR (*.k7)|*.k7"  'filtre, seules les fichiers FNE apparatront
            .ShowDialog()                           ' on ouvre la boite de dialogue enfin
            'Retour aprs la fermeture de la boite de dialogue
            If Err.Number = 32755 Then End 'le bouton 'annuler' a t'il t cliqu?
            If Len(.FileName) = 0 Then End 'aucun choix

            sFile = .FileName                       'nom du fichier choisi ( avec extension) 
            LabelNom.Text = sFile
            dFile = Microsoft.VisualBasic.Left(sFile, Microsoft.VisualBasic.Len(sFile) - 2) & "wav"
            Label2ligne.Text = dFile
            Label1.Text = "sera transform en : "
            Label10.Text = "Le fichier cassette :"
        End With

        btnSinusMono8.Visible = True

    End Sub

    Private Sub CheckBR_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBR.CheckedChanged
        If CheckBR.Checked Then
            TextBox1.Visible = True
            TextBox1.Text = 4
        Else
            TextBox1.Visible = False
        End If
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'Taille normale fentre
        Me.Width = 440
        ' Documentation des timming
        TextBoxSynchro.Text = "1.75"
        TextBoxUn.Text = "1.15"
        TextBoxZero.Text = "0.55"
        'docu radio bouton
        RadioButtonTimingS.Checked = True
        'ainsi que les text box associs
        TextBoxSynchro.Visible = False
        TextBoxUn.Visible = False
        TextBoxZero.Visible = False
        Label7.Visible = False
        Label8.Visible = False
        Label9.Visible = False
        TextBlocText.Visible = False
        Label13.Visible = False
        RichHelper.Text = " Cet utilitaire permet de re crer des fichiers WAV avec des fichiers K7 et FOR" & vbCrLf
        RichHelper.Text += " L'extention K7 est pour les fichiers de cassette classique et" & vbCrLf
        RichHelper.Text += " l'extention FOR pour les sauvegardes d'cran FORTH de 822 octets" & vbCrLf
        RichHelper.Text += " Les timings peuvent tre ajusts." & vbCrLf
        RichHelper.Text += "Pour mmoire les bloc FE sont des blocs de remplissage et donc utilisent le Z80 d'Hector lors du chargement des cassettes, un blanc de synchro est donc ncessaire lors du chargement !" & vbCrLf
        RichHelper.Text += " L'inversion de phase permet d'inverser le signal (+ et -) du fichier WAV pour prvenir les cbles croiss"
    End Sub

    Private Sub Button_option_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_option.Click
        If Me.Width <= 440 Then
            ' Ajout de la page des options
            Me.Width = 800
            Button_option.Text = "Options avances <<"
        Else
            ' suppression de la page des options
            Me.Width = 440
            Button_option.Text = "Options avances >>"
        End If
    End Sub

    Private Sub RadioButtonTimingS_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonTimingS.CheckedChanged
        If RadioButtonTimingP.Checked Then
            TextBoxSynchro.Visible = True
            TextBoxUn.Visible = True
            TextBoxZero.Visible = True
            Label7.Visible = True
            Label8.Visible = True
            Label9.Visible = True

        Else
            TextBoxSynchro.Visible = False
            TextBoxUn.Visible = False
            TextBoxZero.Visible = False
            Label7.Visible = False
            Label8.Visible = False
            Label9.Visible = False

        End If
    End Sub

    Private Sub RadioBloc_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioBloc.CheckedChanged
        If RadioBloc.Checked Then
            TextBlocText.Visible = False
            Label13.Visible = False
            Label14.Visible = False
            Label11.Visible = True

            TextBoxFE.Visible = True
            TextBox1.Visible = CheckBR.Checked
            CheckBR.Visible = True
        Else
            TextBlocText.Visible = True
            Label13.Visible = True
            Label14.Visible = True
            Label11.Visible = False

            TextBoxFE.Visible = False
            TextBox1.Visible = False
            CheckBR.Visible = False

        End If
    End Sub


End Class