Option Explicit On

' /*******************************************************************************
'   modZ80.bas within vb81.vbp
'
'   Complete Z80 emulation, including (as far as I know) the
'   correct emulation of bits 3 and 5 of F, and undocumented ops.
'   Please mail me if you find any bugs in the emulation!
'
'   Author: Chris Cowley <ccowley@grok.co.uk>
'
'   Copyright (C)1999-2002  Grok Developments Ltd.
'   http:www.grok.co.uk/
'
'   This program is free software; you can redistribute it and/or
'   modify it under the terms of the GNU General Public License
'   as published by the Free Software Foundation; either version 2
'   of the License, or (at your option) any later version.
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   ainteger with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'
' *******************************************************************************/

'Source info KERNEL  : http:www.pinvoke.net/default.aspx/kernel32.sleep
Public Class Z80

    ' Module essentiellement rcupr de VB81 avec l'aimable accord de XAVIER
    ' Disponible ici : http:freestuff.grok.co.uk/vb81/
    ' ou sur le site de XAVIER
    ' J'ai namoins transform de VB6 en Net les appels.
    ' et ajout un dbugger complet...
    ' Yo_fr :  JJ.stac @ aliceadsl.fr

    '  Main registers 
    Public regA As Integer
    Public regHL As integer
    Public regB As integer
    Public regC As integer
    Public regDE As integer

    Public fS As integer
    Public fZ As integer
    Public f5 As integer
    Public fH As integer
    Public f3 As integer
    Public fPV As integer
    Public fN As integer
    Public fC As integer

    '  Flag positions
    Public Const F_C = 1
    Public Const F_N = 2
    Public Const F_PV = 4
    Public Const F_3 = 8
    Public Const F_H = 16
    Public Const F_5 = 32
    Public Const F_Z = 64
    Public Const F_S = 128

    '  Alternate registers 
    Public regAF_ As integer
    Public regHL_ As integer
    Public regBC_ As integer
    Public regDE_ As integer

    '  Index registers  - ID used as temp for ix/iy 
    Public regIX As integer
    Public regIY As integer
    Public regID As integer
    Public regID_Name As String ' for debug

    '  Stack pointer and program counter
    Public regSP As integer
    Public regPC As integer

    '  Interrupt registers and flip-flops and refresh registers 
    Public intI As integer
    Public intR As integer
    Public intRTemp As integer
    Public intIFF1 As integer
    Public intIFF2 As integer
    Public intIM As integer
   Public Halt As Boolean = False



    '  Lookup tables for speed division
    Public TabMemAddrDiv256(81919) As integer
    Public TabMemAddrDiv2(81919) As integer

    Public Parity(256) As integer

    Dim isHector As Boolean 'Distinction Z80 Hector // Disc2 

    Public Sub Init_Processeur(ByVal Machine As Boolean)
        'On initialise les tables et le type de machine
        isHector = Machine
        InitDivisionTables()
        initParity()
    End Sub
    Private Function Caractere_char(ByRef A As Byte) As String
        'N'affiche que les caractres ASCII "printable"
        If A > 32 And A < Asc("z") Then
            Caractere_char = Chr(A)
        Else
            Caractere_char = "."
        End If
    End Function
    Private Function Caractere_hex(ByRef A As String) As String
        Caractere_hex = Microsoft.VisualBasic.Right("00" + Hex(A), 2)
    End Function
    Private Function Caractere_hex4(ByRef A As String) As String
        Caractere_hex4 = Microsoft.VisualBasic.Right("0000" + Hex(A), 4)
    End Function


    Private Sub InitDivisionTables()
        'Helper functions div 2 and div 256
        Dim n As Integer

        For n = 0 To 81919 ' 16384 + 65535
            TabMemAddrDiv256(n) = (n And 65535) \ 256
            TabMemAddrDiv2(n) = (n And 65535) \ 2

        Next n
    End Sub
    Private Sub initParity()
        Dim iCounter As Integer, j As Byte, p As Integer

        For iCounter = 0 To 255
            p = True
            For j = 0 To 7
                If (iCounter And (2 ^ j)) <> 0 Then p = Not p
            Next j
            Parity(iCounter) = p
        Next iCounter
    End Sub
    Private Sub adc_a(ByVal b As integer)
        Dim wans, ans, c As Integer

        If fC Then c = 1

        wans = regA + b + c
        ans = wans And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fC = (wans And &H100&) <> 0
        fPV = ((regA Xor ((Not b) And &HFFFF&)) And (regA Xor ans) And &H80&) <> 0

        fH = (((regA And &HF&) + (b And &HF&) + c) And F_H) <> 0
        fN = False

        regA = ans
    End Sub
    Private Sub add_a(ByVal b As integer)
        Dim wans As integer, ans As integer

        wans = regA + b
        ans = wans And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fC = (wans And &H100&) <> 0
        fPV = ((regA Xor ((Not (b)) And &HFFFF&)) And (regA Xor ans) And &H80&) <> 0
        fH = (((regA And &HF&) + (b And &HF&)) And F_H) <> 0
        fN = False

        regA = ans
    End Sub
    Private Function adc16(ByVal a As integer, ByVal b As integer) As integer
        Dim c As integer, lans As integer, ans As integer

        If fC Then c = 1

        lans = a + b + c
        ans = lans And &HFFFF&

        fS = (ans And (F_S * 256&)) <> 0
        f3 = (ans And (F_3 * 256&)) <> 0
        f5 = (ans And (F_5 * 256&)) <> 0
        fZ = (ans = 0)
        fC = (lans And &H10000) <> 0
        fPV = ((a Xor ((Not b) And &HFFFF&)) And (a Xor ans) And &H8000&) <> 0
        fH = (((a And &HFFF&) + (b And &HFFF&) + c) And &H1000&) <> 0
        fN = False

        adc16 = ans
    End Function
    Private Function add16(ByVal a As integer, ByVal b As integer) As integer
        Dim lans As integer
        Dim ans As integer

        lans = a + b
        ans = lans And &HFFFF&

        f3 = (ans And (F_3 * 256&)) <> 0
        f5 = (ans And (F_5 * 256&)) <> 0
        fC = (lans And &H10000) <> 0
        fH = (((a And &HFFF&) + (b And &HFFF&)) And &H1000&) <> 0
        fN = False

        add16 = ans
    End Function
    Private Sub and_a(ByVal b As integer)
        regA = (regA And b)

        fS = (regA And F_S) <> 0
        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fH = True
        fPV = Parity(regA)
        fZ = (regA = 0)
        fN = False
        fC = False
    End Sub
    Private Sub bit(ByVal b As integer, ByVal r As integer)
        Dim IsbitSet As integer

        IsbitSet = (r And b) <> 0
        fN = False
        fH = True
        f3 = (r And F_3) <> 0
        f5 = (r And F_5) <> 0

        If b = F_S Then fS = IsbitSet Else fS = False

        fZ = Not IsbitSet
        fPV = fZ
    End Sub
    Private Function bitRes(ByVal bit As integer, ByVal val As integer) As integer
        bitRes = val And (Not (bit) And &HFFFF&)
    End Function
    Public Function bitSet(ByVal bit As integer, ByVal val As integer) As integer
        bitSet = val Or bit
    End Function
    Private Sub ccf()
        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fH = fC
        fN = False
        fC = Not fC
    End Sub
    Public Sub cp_a(ByVal b As integer)
        Dim a As integer, wans As integer, ans As integer

        a = regA
        wans = a - b
        ans = wans And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (b And F_3) <> 0
        f5 = (b And F_5) <> 0
        fN = True
        fZ = (ans = 0)
        fC = (wans And &H100&) <> 0
        fH = (((a And &HF&) - (b And &HF&)) And F_H) <> 0
        fPV = ((a Xor b) And (a Xor ans) And &H80&) <> 0

    End Sub
    Private Sub cpl_a()
        regA = (regA Xor &HFF&) And &HFF&

        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fH = True
        fN = True
    End Sub
    Private Sub daa_a()
        Dim ans As integer, incr As integer, carry As integer

        ans = regA
        carry = fC

        If (fH = True) Or ((ans And &HF&) > &H9&) Then
            incr = incr Or &H6&
        End If

        If (carry = True) Or (ans > &H9F&) Then
            incr = incr Or &H60&
        End If

        If ((ans > &H8F&) And ((ans And &HF&) > 9&)) Then
            incr = incr Or &H60&
        End If

        If (ans > &H99&) Then
            carry = True
        End If
        If (fN = True) Then
            sub_a(incr)
        Else
            add_a(incr)
        End If

        ans = regA
        fC = carry
        fPV = Parity(ans)
    End Sub
    Private Function dec16(ByVal a As integer) As integer
        dec16 = (a - 1) And &HFFFF&
    End Function
    Private Sub ex_af_af()
        Dim t As integer

        t = getAF()
        setAF(regAF_)
        regAF_ = t
    End Sub
    Private Function execute_cb() As integer
        Dim xxx As integer

        '  Yes, I appreciate that GOTO's and labels are a hideous blashphemy!
        '  However, this code is the fastest possible way of fetching and handling
        '  Z80 instructions I could come up with. There are only 8 compares per
        '  instruction fetch rather than between 1 and 255 as required in
        '  the previous version of vb81 with it's huge Case statement.
        ' 
        '  I know it's slightly harder to follow the new code, but I think the
        '  speed increase justifies it. <CC>


        '  REFRESH 1
        intRTemp = intRTemp + 1

        xxx = nxtpcb()

        If (xxx And 128) Then GoTo ex_cb128_255 Else GoTo ex_cb0_127

ex_cb0_127:
        If (xxx And 64) Then GoTo ex_cb64_127 Else GoTo ex_cb0_63

ex_cb0_63:
        If (xxx And 32) Then GoTo ex_cb32_63 Else GoTo ex_cb0_31

ex_cb0_31:
        If (xxx And 16) Then GoTo ex_cb16_31 Else GoTo ex_cb0_15

ex_cb0_15:
        If (xxx And 8) Then GoTo ex_cb8_15 Else GoTo ex_cb0_7

ex_cb0_7:
        If (xxx And 4) Then GoTo ex_cb4_7 Else GoTo ex_cb0_3

ex_cb0_3:
        If (xxx And 2) Then GoTo ex_cb2_3 Else GoTo ex_cb0_1

ex_cb0_1:
        If xxx = 0 Then
            ' 000 RLC B
            regB = rlc(regB)
            execute_cb = 8
        Else
            ' 001 RLC C
            regC = rlc(regC)
            execute_cb = 8
        End If
        Exit Function

ex_cb2_3:
        If xxx = 2 Then
            ' 002 RLC D
            setD(rlc(getD))
            execute_cb = 8
        Else
            ' 003 RLC E
            setE(rlc(getE))
            execute_cb = 8
        End If
        Exit Function

ex_cb4_7:
        If (xxx And 2) Then GoTo ex_cb6_7 Else GoTo ex_cb4_5

ex_cb4_5:
        If xxx = 4 Then
            ' 004 RLC H
            setH(rlc(getH))
            execute_cb = 8
        Else
            ' 005 RLC L
            setL(rlc(getL))
            execute_cb = 8
        End If
        Exit Function

ex_cb6_7:
        If xxx = 6 Then
            ' 006 RLC (HL)
            pokeb(regHL, rlc(peekb(regHL)))
            execute_cb = 15
        Else
            ' 007 RLC A
            regA = rlc(regA)
            execute_cb = 8
        End If
        Exit Function

ex_cb8_15:
        If (xxx And 4) Then GoTo ex_cb12_15 Else GoTo ex_cb8_11

ex_cb8_11:
        If (xxx And 2) Then GoTo ex_cb10_11 Else GoTo ex_cb8_9

ex_cb8_9:
        If xxx = 8 Then
            ' 008 RRC B
            regB = rrc(regB)
            execute_cb = 8
        Else
            ' 009 RRC C
            regC = rrc(regC)
            execute_cb = 8
        End If
        Exit Function

ex_cb10_11:
        If xxx = 10 Then
            ' 010 RRC D
            setD(rrc(getD))
            execute_cb = 8
        Else
            ' 011 RRC E
            setE(rrc(getE))
            execute_cb = 8
        End If
        Exit Function

ex_cb12_15:
        If (xxx And 2) Then GoTo ex_cb14_15 Else GoTo ex_cb12_13

ex_cb12_13:
        If xxx = 12 Then
            ' 012 RRC H
            setH(rrc(getH))
            execute_cb = 8
        Else
            ' 013 RRC L
            setL(rrc(getL))
            execute_cb = 8
        End If
        Exit Function

ex_cb14_15:
        If xxx = 14 Then
            ' 014 RRC (HL)
            pokeb(regHL, rrc(peekb(regHL)))
            execute_cb = 15
        Else
            ' 015 RRC A
            regA = rrc(regA)
            execute_cb = 8
        End If
        Exit Function

ex_cb16_31:
        If (xxx And 8) Then GoTo ex_cb24_31 Else GoTo ex_cb16_23

ex_cb16_23:
        If (xxx And 4) Then GoTo ex_cb20_23 Else GoTo ex_cb16_19

ex_cb16_19:
        If (xxx And 2) Then GoTo ex_cb18_19 Else GoTo ex_cb16_17

ex_cb16_17:
        If xxx = 16 Then
            ' 016 RL B
            regB = rl(regB)
            execute_cb = 8
        Else
            ' 017 RL C
            regC = rl(regC)
            execute_cb = 8
        End If
        Exit Function

ex_cb18_19:
        If xxx = 18 Then
            ' 018 RL D
            setD(rl(getD))
            execute_cb = 8
        Else
            ' 019 RL E
            setE(rl(getE))
            execute_cb = 8
        End If
        Exit Function

ex_cb20_23:
        If (xxx And 2) Then GoTo ex_cb22_23 Else GoTo ex_cb20_21

ex_cb20_21:
        If xxx = 20 Then
            ' 020 RL H
            setH(rl(getH))
            execute_cb = 8
        Else
            ' 021 RL L
            setL(rl(getL))
            execute_cb = 8
        End If
        Exit Function

ex_cb22_23:
        If xxx = 22 Then
            ' 022 RL (HL)
            pokeb(regHL, rl(peekb(regHL)))
            execute_cb = 15
        Else
            ' 023 RL A
            regA = rl(regA)
            execute_cb = 8
        End If
        Exit Function

ex_cb24_31:
        If (xxx And 4) Then GoTo ex_cb28_31 Else GoTo ex_cb24_27

ex_cb24_27:
        If (xxx And 2) Then GoTo ex_cb26_27 Else GoTo ex_cb24_25

ex_cb24_25:
        If xxx = 24 Then
            ' 024 RR B
            regB = rr(regB)
            execute_cb = 8
        Else
            ' 025 RR C
            regC = rr(regC)
            execute_cb = 8
        End If
        Exit Function

ex_cb26_27:
        If xxx = 26 Then
            ' 026 RR D
            setD(rr(getD))
            execute_cb = 8
        Else
            ' 027 RR E
            setE(rr(getE))
            execute_cb = 8
        End If
        Exit Function

ex_cb28_31:
        If (xxx And 2) Then GoTo ex_cb30_31 Else GoTo ex_cb28_29

ex_cb28_29:
        If xxx = 28 Then
            ' 028 RR H
            setH(rr(getH))
            execute_cb = 8
        Else
            ' 029 RR L
            setL(rr(getL))
            execute_cb = 8
        End If
        Exit Function

ex_cb30_31:
        If xxx = 30 Then
            ' 030 RR (HL)
            pokeb(regHL, rr(peekb(regHL)))
            execute_cb = 15
        Else
            ' 031 RR A
            regA = rr(regA)
            execute_cb = 8
        End If
        Exit Function

ex_cb32_63:
        Select Case xxx
            Case 32 ' SLA B
                regB = sla(regB)
                execute_cb = 8
            Case 33 ' SLA C
                regC = sla(regC)
                execute_cb = 8
            Case 34 ' SLA D
                setD(sla(getD))
                execute_cb = 8
            Case 35 ' SLA E
                setE(sla(getE))
                execute_cb = 8
            Case 36 ' SLA H
                setH(sla(getH))
                execute_cb = 8
            Case 37 ' SLA L
                setL(sla(getL))
                execute_cb = 8
            Case 38 ' SLA (HL)
                pokeb(regHL, sla(peekb(regHL)))
                execute_cb = 15
            Case 39 ' SLA A
                regA = sla(regA)
                execute_cb = 8
            Case 40 ' SRA B
                regB = sra(regB)
                execute_cb = 8
            Case 41 ' SRA C
                regC = sra(regC)
                execute_cb = 8
            Case 42 ' SRA D
                setD(sra(getD))
                execute_cb = 8
            Case 43 ' SRA E
                setE(sra(getE))
                execute_cb = 8
            Case 44 ' SRA H
                setH(sra(getH))
                execute_cb = 8
            Case 45  ' SRA L
                setL(sra(getL))
                execute_cb = 8
            Case 46 ' SRA (HL)
                pokeb(regHL, sra(peekb(regHL)))
                execute_cb = 15
            Case 47 ' SRA A
                regA = sra(regA)
                execute_cb = 8
            Case 48 ' SLS B
                regB = sls(regB)
                execute_cb = 8
            Case 49 ' SLS C
                regC = sls(regC)
                execute_cb = 8
            Case 50 ' SLS D
                setD(sls(getD))
                execute_cb = 8
            Case 51 ' SLS E
                setE(sls(getE))
                execute_cb = 8
            Case 52 ' SLS H
                setH(sls(getH))
                execute_cb = 8
            Case 53 ' SLS L
                setL(sls(getL))
                execute_cb = 8
            Case 54 ' SLS (HL)
                pokeb(regHL, sls(peekb(regHL)))
                execute_cb = 15
            Case 55 ' SLS A
                regA = sls(regA)
                execute_cb = 8
            Case 56 ' SRL B
                regB = srl(regB)
                execute_cb = 8
            Case 57 ' SRL C
                regC = srl(regC)
                execute_cb = 8
            Case 58 ' SRL D
                setD(srl(getD))
                execute_cb = 8
            Case 59 ' SRL E
                setE(srl(getE))
                execute_cb = 8
            Case 60 ' SRL H
                setH(srl(getH))
                execute_cb = 8
            Case 61 ' SRL L
                setL(srl(getL))
                execute_cb = 8
            Case 62 ' SRL (HL)
                pokeb(regHL, srl(peekb(regHL)))
                execute_cb = 15
            Case 63 ' SRL A
                regA = srl(regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select

        Exit Function

ex_cb64_127:
        If (xxx And 32) Then GoTo ex_cb96_127 Else GoTo ex_cb64_95

ex_cb64_95:
        If (xxx And 16) Then GoTo ex_cb80_95 Else GoTo ex_cb64_79

ex_cb64_79:
        If (xxx And 8) Then GoTo ex_cb72_79 Else GoTo ex_cb64_71

ex_cb64_71:
        If (xxx And 4) Then GoTo ex_cb68_71 Else GoTo ex_cb64_67

ex_cb64_67:
        If (xxx And 2) Then GoTo ex_cb66_67 Else GoTo ex_cb64_65

ex_cb64_65:
        If xxx = 64 Then
            ' 064 BIT 0,B
            bit(&H1&, regB)
            execute_cb = 8
        Else
            ' 065 ' BIT 0,C
            bit(1&, regC)
            execute_cb = 8
        End If
        Exit Function

ex_cb66_67:
        If xxx = 66 Then
            ' 066 BIT 0,D
            bit(1&, getD)
            execute_cb = 8
        Else
            ' 067 BIT 0,E
            bit(1&, getE)
            execute_cb = 8
        End If
        Exit Function

ex_cb68_71:
        If (xxx And 2) Then GoTo ex_cb70_71 Else GoTo ex_cb68_69

ex_cb68_69:
        If xxx = 68 Then
            ' 068 BIT 0,H
            bit(1&, getH)
            execute_cb = 8
        Else
            ' 069 BIT 0,L
            bit(1&, getL)
            execute_cb = 8
        End If
        Exit Function

ex_cb70_71:
        If xxx = 70 Then
            ' 070 BIT 0,(HL)
            bit(1&, peekb(regHL))
            execute_cb = 12
        Else
            ' 071 BIT 0,A
            bit(1&, regA)
            execute_cb = 8
        End If
        Exit Function

ex_cb72_79:
        Select Case xxx
            Case 72 ' BIT 1,B
                bit(2&, regB)
                execute_cb = 8
            Case 73 ' BIT 1,C
                bit(2&, regC)
                execute_cb = 8
            Case 74 ' BIT 1,D
                bit(2&, getD)
                execute_cb = 8
            Case 75 ' BIT 1,E
                bit(2&, getE)
                execute_cb = 8
            Case 76 ' BIT 1,H
                bit(2&, getH)
                execute_cb = 8
            Case 77 ' BIT 1,L
                bit(2&, getL)
                execute_cb = 8
            Case 78 ' BIT 1,(HL)
                bit(2&, peekb(regHL))
                execute_cb = 12
            Case 79 ' BIT 1,A
                bit(2&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb80_95:
        Select Case xxx
            Case 80 ' BIT 2,B
                bit(4&, regB)
                execute_cb = 8
            Case 81 ' BIT 2,C
                bit(4&, regC)
                execute_cb = 8
            Case 82 ' BIT 2,D
                bit(4&, getD)
                execute_cb = 8
            Case 83 ' BIT 2,E
                bit(4&, getE)
                execute_cb = 8
            Case 84 ' BIT 2,H
                bit(4&, getH)
                execute_cb = 8
            Case 85 ' BIT 2,L
                bit(4&, getL)
                execute_cb = 8
            Case 86 ' BIT 2,(HL)
                bit(4&, peekb(regHL))
                execute_cb = 12
            Case 87 ' BIT 2,A
                bit(4&, regA)
                execute_cb = 8
            Case 88 ' BIT 3,B
                bit(8&, regB)
                execute_cb = 8
            Case 89 ' BIT 3,C
                bit(8&, regC)
                execute_cb = 8
            Case 90 ' BIT 3,D
                bit(8&, getD)
                execute_cb = 8
            Case 91 ' BIT 3,E
                bit(8&, getE)
                execute_cb = 8
            Case 92 ' BIT 3,H
                bit(8&, getH)
                execute_cb = 8
            Case 93 ' BIT 3,L
                bit(8&, getL)
                execute_cb = 8
            Case 94 ' BIT 3,(HL)
                bit(8&, peekb(regHL))
                execute_cb = 12
            Case 95 ' BIT 3,A
                bit(8&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select

        Exit Function

ex_cb96_127:
        If (xxx And 16) Then GoTo ex_cb112_127 Else GoTo ex_cb96_111

ex_cb96_111:
        If (xxx And 8) Then GoTo ex_cb104_111 Else GoTo ex_cb96_103

ex_cb96_103:
        Select Case xxx
            Case 96 ' BIT 4,B
                bit(&H10&, regB)
                execute_cb = 8
            Case 97 ' BIT 4,C
                bit(&H10&, regC)
                execute_cb = 8
            Case 98 ' BIT 4,D
                bit(&H10&, getD)
                execute_cb = 8
            Case 99 ' BIT 4,E
                bit(&H10&, getE)
                execute_cb = 8
            Case 100 ' BIT 4,H
                bit(&H10&, getH)
                execute_cb = 8
            Case 101 ' BIT 4,L
                bit(&H10&, getL)
                execute_cb = 8
            Case 102 ' BIT 4,(HL)
                bit(&H10&, peekb(regHL))
                execute_cb = 12
            Case 103 ' BIT 4,A
                bit(&H10&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb104_111:
        Select Case xxx
            Case 104 ' BIT 5,B
                bit(&H20&, regB)
                execute_cb = 8
            Case 105 ' BIT 5,C
                bit(&H20&, regC)
                execute_cb = 8
            Case 106 ' BIT 5,D
                bit(&H20&, getD)
                execute_cb = 8
            Case 107 ' BIT 5,E
                bit(&H20&, getE)
                execute_cb = 8
            Case 108 ' BIT 5,H
                bit(&H20&, getH)
                execute_cb = 8
            Case 109 ' BIT 5,L
                bit(&H20&, getL)
                execute_cb = 8
            Case 110 ' BIT 5,(HL)
                bit(&H20&, peekb(regHL))
                execute_cb = 12
            Case 111 ' BIT 5,A
                bit(&H20&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb112_127:
        If (xxx And 8) Then GoTo ex_cb120_127 Else GoTo ex_cb112_119

ex_cb112_119:
        If (xxx And 4) Then GoTo ex_cb116_119 Else GoTo ex_cb112_115

ex_cb112_115:
        If (xxx And 2) Then GoTo ex_cb114_115 Else GoTo ex_cb112_113

ex_cb112_113:
        If xxx = 112 Then
            ' 112 BIT 6,B
            bit(&H40&, regB)
            execute_cb = 8
        Else
            ' 113 BIT 6,C
            bit(&H40&, regC)
            execute_cb = 8
        End If
        Exit Function

ex_cb114_115:
        If xxx = 114 Then
            ' 114 BIT 6,D
            bit(&H40&, getD)
            execute_cb = 8
        Else
            ' 115 BIT 6,E
            bit(&H40&, getE)
            execute_cb = 8
        End If
        Exit Function

ex_cb116_119:
        If (xxx And 2) Then GoTo ex_cb118_119 Else GoTo ex_cb116_117

ex_cb116_117:
        If xxx = 116 Then
            ' 116 BIT 6,H
            bit(&H40&, getH)
            execute_cb = 8
        Else
            ' 117 BIT 6,L
            bit(&H40&, getL)
            execute_cb = 8
        End If
        Exit Function

ex_cb118_119:
        If xxx = 118 Then
            ' 118 BIT 6,(HL)
            bit(&H40&, peekb(regHL))
            execute_cb = 12
        Else
            ' 119 ' BIT 6,A
            bit(&H40&, regA)
            execute_cb = 8
        End If
        Exit Function

ex_cb120_127:
        If (xxx And 4) Then GoTo ex_cb124_127 Else GoTo ex_cb120_123

ex_cb120_123:
        If (xxx And 2) Then GoTo ex_cb122_123 Else GoTo ex_cb120_121

ex_cb120_121:
        If xxx = 120 Then
            ' 120 BIT 7,B
            bit(&H80&, regB)
            execute_cb = 8
        Else
            ' 121 BIT 7,C
            bit(&H80&, regC)
            execute_cb = 8
        End If
        Exit Function

ex_cb122_123:
        If xxx = 122 Then
            ' 122 BIT 7,D
            bit(&H80&, getD)
            execute_cb = 8
        Else
            ' 123 BIT 7,E
            bit(&H80&, getE)
            execute_cb = 8
        End If
        Exit Function

ex_cb124_127:
        If (xxx And 2) Then GoTo ex_cb126_127 Else GoTo ex_cb124_125

ex_cb124_125:
        If xxx = 124 Then
            ' 124 BIT 7,H
            bit(&H80&, getH)
            execute_cb = 8
        Else
            ' 125 BIT 7,L
            bit(&H80&, getL)
            execute_cb = 8
        End If
        Exit Function

ex_cb126_127:
        If xxx = 126 Then
            ' 126 BIT 7,(HL)
            bit(&H80&, peekb(regHL))
            execute_cb = 12
        Else
            ' 127 BIT 7,A
            bit(&H80&, regA)
            execute_cb = 8
        End If
        Exit Function

ex_cb128_255:
        If (xxx And 64) Then GoTo ex_cb192_255 Else GoTo ex_cb128_191

ex_cb128_191:
        If (xxx And 32) Then GoTo ex_cb160_191 Else GoTo ex_cb128_159

ex_cb128_159:
        If (xxx And 16) Then GoTo ex_cb144_159 Else GoTo ex_cb128_143

ex_cb128_143:
        Select Case xxx
            Case 128 ' RES 0,B
                regB = bitRes(1&, regB)
                execute_cb = 8
            Case 129 ' RES 0,C
                regC = bitRes(1&, regC)
                execute_cb = 8
            Case 130 ' RES 0,D
                setD(bitRes(1&, getD))
                execute_cb = 8
            Case 131 ' RES 0,E
                setE(bitRes(1&, getE))
                execute_cb = 8
            Case 132 ' RES 0,H
                setH(bitRes(1&, getH))
                execute_cb = 8
            Case 133 ' RES 0,L
                setL(bitRes(1&, getL))
                execute_cb = 8
            Case 134 ' RES 0,(HL)
                pokeb(regHL, bitRes(&H1&, peekb(regHL)))
                execute_cb = 15
            Case 135 ' RES 0,A
                regA = bitRes(1&, regA)
                execute_cb = 8
            Case 136 ' RES 1,B
                regB = bitRes(2&, regB)
                execute_cb = 8
            Case 137 ' RES 1,C
                regC = bitRes(2&, regC)
                execute_cb = 8
            Case 138 ' RES 1,D
                setD(bitRes(2&, getD))
                execute_cb = 8
            Case 139 ' RES 1,E
                setE(bitRes(2&, getE))
                execute_cb = 8
            Case 140 ' RES 1,H
                setH(bitRes(2&, getH))
                execute_cb = 8
            Case 141 ' RES 1,L
                setL(bitRes(2&, getL))
                execute_cb = 8
            Case 142 ' RES 1,(HL)
                pokeb(regHL, bitRes(2&, peekb(regHL)))
                execute_cb = 15
            Case 143 ' RES 1,A
                regA = bitRes(2&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select

        Exit Function

ex_cb144_159:
        Select Case xxx
            Case 144 ' RES 2,B
                regB = bitRes(4&, regB)
                execute_cb = 8
            Case 145 ' RES 2,C
                regC = bitRes(4&, regC)
                execute_cb = 8
            Case 146 ' RES 2,D
                setD(bitRes(4&, getD))
                execute_cb = 8
            Case 147 ' RES 2,E
                setE(bitRes(4&, getE))
                execute_cb = 8
            Case 148 ' RES 2,H
                setH(bitRes(4&, getH))
                execute_cb = 8
            Case 149 ' RES 2,L
                setL(bitRes(4&, getL))
                execute_cb = 8
            Case 150 ' RES 2,(HL)
                pokeb(regHL, bitRes(4&, peekb(regHL)))
                execute_cb = 15
            Case 151 ' RES 2,A
                regA = bitRes(4&, regA)
                execute_cb = 8
            Case 152 ' RES 3,B
                regB = bitRes(8&, regB)
                execute_cb = 8
            Case 153 ' RES 3,C
                regC = bitRes(8&, regC)
                execute_cb = 8
            Case 154 ' RES 3,D
                setD(bitRes(8&, getD))
                execute_cb = 8
            Case 155 ' RES 3,E
                setE(bitRes(8&, getE))
                execute_cb = 8
            Case 156 ' RES 3,H
                setH(bitRes(8&, getH))
                execute_cb = 8
            Case 157 ' RES 3,L
                setL(bitRes(8&, getL))
                execute_cb = 8
            Case 158 ' RES 3,(HL)
                pokeb(regHL, bitRes(8&, peekb(regHL)))
                execute_cb = 15
            Case 159 ' RES 3,A
                regA = bitRes(8&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select

        Exit Function

ex_cb160_191:
        If (xxx And 16) Then GoTo ex_cb176_191 Else GoTo ex_cb160_175

ex_cb160_175:
        If (xxx And 8) Then GoTo ex_cb168_175 Else GoTo ex_cb160_167

ex_cb160_167:
        Select Case xxx
            Case 160 ' RES 4,B
                regB = bitRes(&H10&, regB)
                execute_cb = 8
            Case 161 ' RES 4,C
                regC = bitRes(&H10&, regC)
                execute_cb = 8
            Case 162 ' RES 4,D
                setD(bitRes(&H10&, getD))
                execute_cb = 8
            Case 163 ' RES 4,E
                setE(bitRes(&H10&, getE))
                execute_cb = 8
            Case 164 ' RES 4,H
                setH(bitRes(&H10&, getH))
                execute_cb = 8
            Case 165 ' RES 4,L
                setL(bitRes(&H10&, getL))
                execute_cb = 8
            Case 166 ' RES 4,(HL)
                pokeb(regHL, bitRes(&H10&, peekb(regHL)))
                execute_cb = 15
            Case 167 ' RES 4,A
                regA = bitRes(&H10&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb168_175:
        If (xxx And 4) Then GoTo ex_cb172_175 Else GoTo ex_cb168_171

ex_cb168_171:
        If (xxx And 2) Then GoTo ex_cb170_171 Else GoTo ex_cb168_169

ex_cb168_169:
        If xxx = 168 Then
            ' 168 RES 5,B
            regB = bitRes(&H20&, regB)
            execute_cb = 8
        Else
            ' 169 RES 5,C
            regC = bitRes(&H20&, regC)
            execute_cb = 8
        End If
        Exit Function

ex_cb170_171:
        If xxx = 170 Then
            ' 170 RES 5,D
            setD(bitRes(&H20&, getD))
            execute_cb = 8
        Else
            ' 171 RES 5,E
            setE(bitRes(&H20&, getE))
            execute_cb = 8
        End If
        Exit Function

ex_cb172_175:
        Select Case xxx
            Case 172 ' RES 5,H
                setH(bitRes(&H20&, getH))
                execute_cb = 8
            Case 173 ' RES 5,L
                setL(bitRes(&H20&, getL))
                execute_cb = 8
            Case 174 ' RES 5,(HL)
                pokeb(regHL, bitRes(&H20&, peekb(regHL)))
                execute_cb = 15
            Case 175 ' RES 5,A
                regA = bitRes(&H20&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb176_191:
        Select Case xxx
            Case 176 ' RES 6,B
                regB = bitRes(&H40&, regB)
                execute_cb = 8
            Case 177 ' RES 6,C
                regC = bitRes(&H40&, regC)
                execute_cb = 8
            Case 178 ' RES 6,D
                setD(bitRes(&H40&, getD))
                execute_cb = 8
            Case 179 ' RES 6,E
                setE(bitRes(&H40&, getE))
                execute_cb = 8
            Case 180 ' RES 6,H
                setH(bitRes(&H40&, getH))
                execute_cb = 8
            Case 181 ' RES 6,L
                setL(bitRes(&H40&, getL))
                execute_cb = 8
            Case 182 ' RES 6,(HL)
                pokeb(regHL, bitRes(&H40&, peekb(regHL)))
                execute_cb = 15
            Case 183 ' RES 6,A
                regA = bitRes(&H40&, regA)
                execute_cb = 8
            Case 184 ' RES 7,B
                regB = bitRes(&H80&, regB)
                execute_cb = 8
            Case 185 ' RES 7,C
                regC = bitRes(&H80&, regC)
                execute_cb = 8
            Case 186 ' RES 7,D
                setD(bitRes(&H80&, getD))
                execute_cb = 8
            Case 187 ' RES 7,E
                setE(bitRes(&H80&, getE))
                execute_cb = 8
            Case 188 ' RES 7,H
                setH(bitRes(&H80&, getH))
                execute_cb = 8
            Case 189 ' RES 7,L
                setL(bitRes(&H80&, getL))
                execute_cb = 8
            Case 190 ' RES 7,(HL)
                pokeb(regHL, bitRes(&H80&, peekb(regHL)))
                execute_cb = 15
            Case 191 ' RES 7,A
                regA = bitRes(&H80&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select

        Exit Function

ex_cb192_255:
        If (xxx And 32) Then GoTo ex_cb224_255 Else GoTo ex_cb192_223

ex_cb192_223:
        If (xxx And 16) Then GoTo ex_cb208_223 Else GoTo ex_cb192_207

ex_cb192_207:
        If (xxx And 8) Then GoTo ex_cb200_207 Else GoTo ex_cb192_199

ex_cb192_199:
        Select Case xxx
            Case 192 ' SET 0,B
                regB = bitSet(1&, regB)
                execute_cb = 8
            Case 193 ' SET 0,C
                regC = bitSet(1&, regC)
                execute_cb = 8
            Case 194 ' SET 0,D
                setD(bitSet(1&, getD))
                execute_cb = 8
            Case 195 ' SET 0,E
                setE(bitSet(1&, getE))
                execute_cb = 8
            Case 196 ' SET 0,H
                setH(bitSet(1&, getH))
                execute_cb = 8
            Case 197 ' SET 0,L
                setL(bitSet(1&, getL))
                execute_cb = 8
            Case 198 ' SET 0,(HL)
                pokeb(regHL, bitSet(1&, peekb(regHL)))
                execute_cb = 15
            Case 199 ' SET 0,A
                regA = bitSet(1&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb200_207:
        Select Case xxx
            Case 200 ' SET 1,B
                regB = bitSet(2&, regB)
                execute_cb = 8
            Case 201 ' SET 1,C
                regC = bitSet(2&, regC)
                execute_cb = 8
            Case 202 ' SET 1,D
                setD(bitSet(2&, getD))
                execute_cb = 8
            Case 203 ' SET 1,E
                setE(bitSet(2&, getE))
                execute_cb = 8
            Case 204 ' SET 1,H
                setH(bitSet(2&, getH))
                execute_cb = 8
            Case 205 ' SET 1,L
                setL(bitSet(2&, getL))
                execute_cb = 8
            Case 206 ' SET 1,(HL)
                pokeb(regHL, bitSet(2&, peekb(regHL)))
                execute_cb = 15
            Case 207 ' SET 1,A
                regA = bitSet(2&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb208_223:
        Select Case xxx
            Case 208 ' SET 2,B
                regB = bitSet(4&, regB)
                execute_cb = 8
            Case 209 ' SET 2,C
                regC = bitSet(4&, regC)
                execute_cb = 8
            Case 210 ' SET 2,D
                setD(bitSet(4&, getD))
                execute_cb = 8
            Case 211 ' SET 2,E
                setE(bitSet(4&, getE))
                execute_cb = 8
            Case 212 ' SET 2,H
                setH(bitSet(4&, getH))
                execute_cb = 8
            Case 213 ' SET 2,L
                setL(bitSet(4&, getL))
                execute_cb = 8
            Case 214 ' SET 2,(HL)
                pokeb(regHL, bitSet(&H4&, peekb(regHL)))
                execute_cb = 15
            Case 215 ' SET 2,A
                regA = bitSet(4&, regA)
                execute_cb = 8
            Case 216 ' SET 3,B
                regB = bitSet(8&, regB)
                execute_cb = 8
            Case 217 ' SET 3,C
                regC = bitSet(8&, regC)
                execute_cb = 8
            Case 218 ' SET 3,D
                setD(bitSet(8&, getD))
                execute_cb = 8
            Case 219 ' SET 3,E
                setE(bitSet(8&, getE))
                execute_cb = 8
            Case 220 ' SET 3,H
                setH(bitSet(8&, getH))
                execute_cb = 8
            Case 221 ' SET 3,L
                setL(bitSet(8&, getL))
                execute_cb = 8
            Case 222 ' SET 3,(HL)
                pokeb(regHL, bitSet(&H8&, peekb(regHL)))
                execute_cb = 15
            Case 223 ' SET 3,A
                regA = bitSet(8&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb224_255:
        If (xxx And 16) Then GoTo ex_cb240_255 Else GoTo ex_cb224_239

ex_cb224_239:
        Select Case xxx
            Case 224 ' SET 4,B
                regB = bitSet(&H10&, regB)
                execute_cb = 8
            Case 225 ' SET 4,C
                regC = bitSet(&H10&, regC)
                execute_cb = 8
            Case 226 ' SET 4,D
                setD(bitSet(&H10&, getD))
                execute_cb = 8
            Case 227 ' SET 4,E
                setE(bitSet(&H10&, getE))
                execute_cb = 8
            Case 228 ' SET 4,H
                setH(bitSet(&H10&, getH))
                execute_cb = 8
            Case 229 ' SET 4,L
                setL(bitSet(&H10&, getL))
                execute_cb = 8
            Case 230 ' SET 4,(HL)
                pokeb(regHL, bitSet(&H10&, peekb(regHL)))
                execute_cb = 15
            Case 231 ' SET 4,A
                regA = bitSet(&H10&, regA)
                execute_cb = 8
            Case 232 ' SET 5,B
                regB = bitSet(&H20&, regB)
                execute_cb = 8
            Case 233 ' SET 5,C
                regC = bitSet(&H20&, regC)
                execute_cb = 8
            Case 234 ' SET 5,D
                setD(bitSet(&H20&, getD))
                execute_cb = 8
            Case 235 ' SET 5,E
                setE(bitSet(&H20&, getE))
                execute_cb = 8
            Case 236 ' SET 5,H
                setH(bitSet(&H20&, getH))
                execute_cb = 8
            Case 237 ' SET 5,L
                setL(bitSet(&H20&, getL))
                execute_cb = 8
            Case 238 ' SET 5,(HL)
                pokeb(regHL, bitSet(&H20&, peekb(regHL)))
                execute_cb = 15
            Case 239 ' SET 5,A
                regA = bitSet(&H20&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb240_255:
        If (xxx And 8) Then GoTo ex_cb248_255 Else GoTo ex_cb240_247

ex_cb240_247:
        Select Case xxx
            Case 240 ' SET 6,B
                regB = bitSet(&H40&, regB)
                execute_cb = 8
            Case 241 ' SET 6,C
                regC = bitSet(&H40&, regC)
                execute_cb = 8
            Case 242 ' SET 6,D
                setD(bitSet(&H40&, getD))
                execute_cb = 8
            Case 243 ' SET 6,E
                setE(bitSet(&H40&, getE))
                execute_cb = 8
            Case 244 ' SET 6,H
                setH(bitSet(&H40&, getH))
                execute_cb = 8
            Case 245 ' SET 6,L
                setL(bitSet(&H40&, getL))
                execute_cb = 8
            Case 246 ' SET 6,(HL)
                pokeb(regHL, bitSet(&H40&, peekb(regHL)))
                execute_cb = 15
            Case 247 ' SET 6,A
                regA = bitSet(&H40&, regA)
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb248_255:
        If (xxx And 4) Then GoTo ex_cb252_255 Else GoTo ex_cb248_251

ex_cb248_251:
        Select Case xxx
            Case 248 ' SET 7,B
                regB = bitSet(&H80&, regB)
                execute_cb = 8
            Case 249 ' SET 7,C
                regC = bitSet(&H80&, regC)
                execute_cb = 8
            Case 250 ' SET 7,D
                setD(bitSet(&H80&, getD))
                execute_cb = 8
            Case 251 ' SET 7,E
                setE(bitSet(&H80&, getE))
                execute_cb = 8
            Case Else
                execute_cb = 0
        End Select
        Exit Function

ex_cb252_255:
        If (xxx And 2) Then GoTo ex_cb254_255 Else GoTo ex_cb252_253

ex_cb252_253:
        If xxx = 252 Then
            ' 252 SET 7,H
            setH(bitSet(&H80&, getH))
            execute_cb = 8
        Else
            ' 253 SET 7,L
            setL(bitSet(&H80&, getL))
            execute_cb = 8
        End If
        Exit Function

ex_cb254_255:
        If xxx = 254 Then
            ' 254 SET 7,(HL)
            pokeb(regHL, bitSet(&H80&, peekb(regHL)))
            execute_cb = 15
        Else
            ' 255 SET 7,A
            regA = bitSet(&H80&, regA)
            execute_cb = 8
        End If
    End Function

 
 
 
    Function sla(ByVal ans As integer) As integer
        Dim c As integer

        c = (ans And &H80&) <> 0
        ans = (ans * 2) And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False
        fC = c

        sla = ans
    End Function

    Private Sub execute_ed(ByRef local_tstates As Integer)
        Dim xxx As Integer, count As Integer, dest As Integer, Source As Integer
        Dim c As Integer, b As Integer

        '  Yes, I appreciate that GOTO's and labels are a hideous blashphemy!
        '  However, this code is the fastest possible way of fetching and handling
        '  Z80 instructions I could come up with. There are only 8 compares per
        '  instruction fetch rather than between 1 and 255 as required in
        '  the previous version of vb81 with it's huge Case statement.
        ' 
        '  I know it's slightly harder to follow the new code, but I think the
        '  speed increase justifies it. <CC>


        '  REFRESH 1
        intRTemp = intRTemp + 1

        xxx = nxtpcb()

        'par defaut retour avec 0
        local_tstates += 0
        If (xxx And 128) Then GoTo ex_ed128_255 Else GoTo ex_ed0_127

ex_ed0_127:
        If (xxx And 64) Then
            GoTo ex_ed64_127
        Else
            ' 000 to 063 = NOP
            local_tstates += 8
            Exit Sub
        End If

ex_ed64_127:
        If (xxx And 32) Then GoTo ex_ed96_127 Else GoTo ex_ed64_95

ex_ed64_95:
        If (xxx And 16) Then GoTo ex_ed80_95 Else GoTo ex_ed64_79

ex_ed64_79:
        If (xxx And 8) Then GoTo ex_ed72_79 Else GoTo ex_ed64_71

ex_ed64_71:
        If (xxx And 4) Then GoTo ex_ed68_71 Else GoTo ex_ed64_67

ex_ed64_67:
        If (xxx And 2) Then GoTo ex_ed66_67 Else GoTo ex_ed64_65

ex_ed64_65:
        If xxx = 64 Then
            ' 064 IN B,(c)
            regB = in_bc()
            local_tstates += 12
        Else
            ' 065 OUT (c),B
            If isHector Then
                Hector.outb(getBC, regB)
            Else
                Disc2.outb(getBC, regB)
            End If
            local_tstates += 12
        End If
        Exit Sub

ex_ed66_67:
        If xxx = 66 Then
            ' 066 SBC HL,BC
            regHL = sbc16(regHL, getBC)
            local_tstates += 15
        Else
            ' 067 LD (nn),BC
            pokew(nxtpcw(), getBC)
            local_tstates += 20
        End If
        Exit Sub

ex_ed68_71:
        If (xxx And 2) Then GoTo ex_ed70_71 Else GoTo ex_ed68_69

ex_ed68_69:
        If xxx = 68 Then
            ' 068 NEG
            neg_a()
            local_tstates += 8
        Else
            ' 069 RETn
            intIFF1 = intIFF2
            poppc()
            local_tstates += 14
        End If
        Exit Sub

ex_ed70_71:
        If xxx = 70 Then
            ' 070 IM 0
            intIM = 0
            local_tstates += 8
        Else
            ' 071 LD I,A
            intI = regA
            local_tstates += 9
        End If
        Exit Sub

ex_ed72_79:
        If (xxx And 4) Then GoTo ex_ed76_79 Else GoTo ex_ed72_75

ex_ed72_75:
        If (xxx And 2) Then GoTo ex_ed74_75 Else GoTo ex_ed72_73

ex_ed72_73:
        If xxx = 72 Then
            ' 072 IN C,(c)
            regC = in_bc()
            local_tstates += 12
        Else
            ' 073 OUT (c),C
            If isHector Then
                Hector.outb(getBC, regC)
            Else
                Disc2.outb(getBC, regC)
            End If
            local_tstates += 12
        End If
        Exit Sub

ex_ed74_75:
        If xxx = 74 Then
            ' 074 ADC HL,BC
            regHL = adc16(regHL, getBC)
            local_tstates += 15
        Else
            ' 075 LD BC,(nn)
            setBC(peekw(nxtpcw()))
            local_tstates += 20
        End If
        Exit Sub

ex_ed76_79:
        If (xxx And 2) Then GoTo ex_ed78_79 Else GoTo ex_ed76_77

ex_ed76_77:
        If xxx = 76 Then
            ' 076 NEG
            neg_a()
            local_tstates += 8
        Else
            ' 077 RETI
            '  TOCHECK: according to the official Z80 docs, IFF2 does not get
            '           copied to IFF1 for RETI - but in a real Z80 it is
            intIFF1 = intIFF2
            poppc()
            local_tstates += 14
        End If
        Exit Sub

ex_ed78_79:
        If xxx = 78 Then
            ' 078 IM 0
            intIM = 0
            local_tstates += 8
        Else
            ' 079 LD R,A
            intR = (regA And 128)
            intRTemp = intR
            local_tstates += 9
        End If
        Exit Sub

ex_ed80_95:
        If (xxx And 8) Then GoTo ex_ed88_95 Else GoTo ex_ed80_87

ex_ed80_87:
        If (xxx And 4) Then GoTo ex_ed84_87 Else GoTo ex_ed80_83

ex_ed80_83:
        If (xxx And 2) Then GoTo ex_ed82_83 Else GoTo ex_ed80_81

ex_ed80_81:
        If xxx = 80 Then
            ' 080 IN D,(c)
            setD(in_bc())
            local_tstates += 12
        Else
            ' 081 OUT (c),D
            If isHector Then
                Hector.outb(getBC, getD)
            Else
                Disc2.outb(getBC, getD)
            End If
            local_tstates += 12
        End If
        Exit Sub

ex_ed82_83:
        If xxx = 82 Then
            ' 082 SBC HL,DE
            regHL = sbc16(regHL, regDE)
            local_tstates += 15
        Else
            ' 083 LD (nn),DE
            pokew(nxtpcw(), regDE)
            local_tstates += 20
        End If
        Exit Sub

ex_ed84_87:
        If (xxx And 2) Then GoTo ex_ed86_87 Else GoTo ex_ed84_85

ex_ed84_85:
        If xxx = 84 Then
            ' NEG
            neg_a()
            local_tstates += 8
        Else
            ' 85 RETn
            intIFF1 = intIFF2
            poppc()
            local_tstates += 14
        End If
        Exit Sub

ex_ed86_87:
        If xxx = 86 Then
            ' 86 ' IM 1
            intIM = 1
            local_tstates += 8
        Else
            ' 87 ' LD A,I
            ld_a_i()
            local_tstates += 9
        End If
        Exit Sub

ex_ed88_95:
        If (xxx And 4) Then GoTo ex_ed92_95 Else GoTo ex_ed88_91

ex_ed88_91:
        If (xxx And 2) Then GoTo ex_ed90_91 Else GoTo ex_ed88_89

ex_ed88_89:
        If xxx = 88 Then
            ' 088 IN E,(c)
            setE(in_bc())
            local_tstates += 12
        Else
            ' 089 OUT (c),E
            If isHector Then
                Hector.outb(getBC, getE)
            Else
                Disc2.outb(getBC, getE)
            End If
            local_tstates += 12
        End If
        Exit Sub

ex_ed90_91:
        If xxx = 90 Then
            ' 090 ADC HL,DE
            regHL = adc16(regHL, regDE)
            local_tstates += 15
        Else
            ' 091 LD DE,(nn)
            regDE = peekw(nxtpcw())
            local_tstates += 20
        End If
        Exit Sub

ex_ed92_95:
        If (xxx And 2) Then GoTo ex_ed94_95 Else GoTo ex_ed92_93

ex_ed92_93:
        If xxx = 92 Then
            ' NEG
            neg_a()
            local_tstates += 8
        Else
            ' 93 RETI
            '  TOCHECK: according to the official Z80 docs, IFF2 does not get
            '           copied to IFF1 for RETI - but in a real Z80 it is
            intIFF1 = intIFF2
            poppc()
            local_tstates += 14
        End If
        Exit Sub

ex_ed94_95:
        If xxx = 94 Then
            ' IM 2
            intIM = 2
            local_tstates += 8
        Else
            ' 95 LD A,R
            ld_a_r()
            local_tstates += 9
        End If
        Exit Sub

ex_ed96_127:
        If (xxx And 16) Then GoTo ex_ed112_127 Else GoTo ex_ed96_111

ex_ed96_111:
        If (xxx And 8) Then GoTo ex_ed104_111 Else GoTo ex_ed96_103

ex_ed96_103:
        Select Case xxx
            Case 96 ' IN H,(c)
                setH(in_bc())
                local_tstates += 12
            Case 97 ' OUT (c),H
                If isHector Then
                    Hector.outb(getBC, getH)
                Else
                    Disc2.outb(getBC, getH)
                End If
                local_tstates += 12
            Case 98 ' SBC HL,HL
                regHL = sbc16(regHL, regHL)
                local_tstates += 15
            Case 99 ' LD (nn),HL
                pokew(nxtpcw(), regHL)
                local_tstates += 20
            Case 100 ' NEG
                neg_a()
                local_tstates += 8
            Case 101 ' RETn
                intIFF1 = intIFF2
                poppc()
                local_tstates += 14
            Case 102 ' IM 0
                intIM = 0
                local_tstates += 8
            Case 103 ' RRD
                rrd_a()
                local_tstates += 18
            Case Else
                local_tstates += 0
        End Select
        Exit Sub

ex_ed104_111:
        Select Case xxx
            Case 104 ' IN L,(c)
                setL(in_bc())
                local_tstates += 12
            Case 105 ' OUT (c),L
                If isHector Then
                    Hector.outb(getBC, getL)
                Else
                    Disc2.outb(getBC, getL)
                End If
                local_tstates += 12
            Case 106 ' ADC HL,HL
                regHL = adc16(regHL, regHL)
                local_tstates += 15
            Case 107 ' LD HL,(nn)
                regHL = peekw(nxtpcw())
                local_tstates += 20
            Case 108 ' NEG
                neg_a()
                local_tstates += 8
            Case 109 ' RETI
                '  TOCHECK: according to the official Z80 docs, IFF2 does not get
                '           copied to IFF1 for RETI - but in a real Z80 it is
                intIFF1 = intIFF2
                poppc()
                local_tstates += 14
            Case 110 ' IM 0
                intIM = 0
                local_tstates += 8
            Case 111  ' RLD
                rld_a()
                local_tstates += 18
        End Select
        ' Return 0
        Exit Sub

ex_ed112_127:
        If (xxx And 8) Then GoTo ex_ed120_127 Else GoTo ex_ed112_119

ex_ed112_119:
        Select Case xxx
            Case 112 ' IN (c)
                in_bc()
                local_tstates += 12
            Case 113 ' OUT (c),0
                If isHector Then
                    Hector.outb(getBC, 0)
                Else
                    Disc2.outb(getBC, 0)
                End If
                local_tstates += 12
            Case 114 ' SBC HL,SP
                regHL = sbc16(regHL, regSP)
                local_tstates += 15
            Case 115 ' LD (nn),SP
                pokew(nxtpcw(), regSP)
                local_tstates += 20
            Case 116 ' NEG
                neg_a()
                local_tstates += 8
            Case 117 ' RETn
                intIFF1 = intIFF2
                poppc()
                local_tstates += 14
            Case 118 ' IM 1
                intIM = 1
                local_tstates += 8
            Case 119
                MsgBox("Unknown opcode 0xED 119")
        End Select
        '        Return 0
        Exit Sub

ex_ed120_127:
        Select Case xxx
            Case 120 ' IN A,(c)
                regA = in_bc()
                local_tstates += 12
            Case 121 ' OUT (c),A
                If isHector Then
                    Hector.outb(getBC, regA)
                Else
                    Disc2.outb(getBC, regA)
                End If
                local_tstates += 12
            Case 122 ' ADC HL,SP
                regHL = adc16(regHL, regSP)
                local_tstates += 15
            Case 123 ' LD SP,(nn)
                regSP = peekw(nxtpcw())
                local_tstates += 20
            Case 124 ' NEG
                neg_a()
                local_tstates += 8
            Case 125 ' RETI
                '           copied to IFF1 for RETI - but in a real Z80 it is
                intIFF1 = intIFF2
                poppc()
                local_tstates += 14
            Case 126 ' IM 2
                intIM = 2
                local_tstates += 8
            Case 127 ' NOP
                local_tstates += 8
        End Select

        '       Return 0
        Exit Sub

ex_ed128_255:
        If (xxx And 64) Then GoTo ex_ed192_255 Else GoTo ex_ed128_191

ex_ed128_191:
        If (xxx And 32) Then
            GoTo ex_ed160_191
        Else
            ' NOP
            local_tstates += 8
            Exit Sub
        End If

ex_ed160_191:
        Select Case xxx  '  xxI
            Case 160 ' LDI
                pokeb(regDE, peekb(regHL))

                f3 = (F_3 And (peekb(regHL) + regA)) '  TOCHECK: Is this correct?
                f5 = (2 And (peekb(regHL) + regA))   '  TOCHECK: Is this correct?

                regDE = inc16(regDE)
                regHL = inc16(regHL)
                setBC(dec16(getBC))

                fPV = (getBC() <> 0)
                fH = False
                fN = False

                local_tstates += 16
            Case 161 ' CPI
                c = fC

                cp_a(peekb(regHL))
                regHL = inc16(regHL)
                setBC(dec16(getBC))

                fPV = (getBC() <> 0)
                fC = c

                local_tstates += 16
            Case 162 ' INI

                If isHector Then
                    pokeb(regHL, Hector.inb(getBC))
                Else
                    pokeb(regHL, Disc2.inb(getBC))
                End If
                b = qdec8(regB)
                regB = b
                regHL = inc16(regHL)

                fZ = (b = 0)
                fN = True

                local_tstates += 16
            Case 163 ' OUTI
                b = qdec8(regB)
                regB = b
                If isHector Then
                    Hector.outb(getBC, peekb(regHL))
                Else
                    Disc2.outb(getBC, peekb(regHL))
                End If
                regHL = inc16(regHL)

                fZ = (b = 0)
                fN = True

                local_tstates += 16

                ' /* xxD */
            Case 168 ' LDD
                pokeb(regDE, peekb(regHL))

                f3 = (F_3 And (peekb(regHL) + regA)) '  TOCHECK: Is this correct?
                f5 = (2 And (peekb(regHL) + regA))   '  TOCHECK: Is this correct?

                regDE = dec16(regDE)
                regHL = dec16(regHL)
                setBC(dec16(getBC()))

                fPV = (getBC() <> 0)
                fH = False
                fN = False


                local_tstates += 16
            Case 169 ' CPD
                c = fC

                cp_a(peekb(regHL))
                regHL = dec16(regHL)
                setBC(dec16(getBC))

                fPV = (getBC() <> 0)
                fC = c

                local_tstates += 16
            Case 170 ' IND

                If isHector Then
                    pokeb(regHL, Hector.inb(getBC))
                Else
                    pokeb(regHL, Disc2.inb(getBC))
                End If
                b = qdec8(regB)
                regB = b
                regHL = dec16(regHL)

                fZ = (b = 0)
                fN = True

                local_tstates += 16
            Case 171 ' OUTD
                count = qdec8(regB)
                regB = count
                If isHector Then
                    Hector.outb(getBC, peekb(regHL))
                Else
                    Disc2.outb(getBC, peekb(regHL))
                End If
                regHL = dec16(regHL)

                fZ = (count = 0)
                fN = True

                local_tstates += 16

                '  xxIR
            Case 176 ' LDIR
                count = getBC()
                dest = regDE
                Source = regHL

                '  REFRESH -2
                intRTemp = intRTemp - 2
                Do
                    pokeb(dest, peekb(Source))
                    Source = (Source + 1) And 65535
                    dest = (dest + 1) And 65535
                    count = count - 1

                    local_tstates += 21
                    '  REFRESH (2)
                    intRTemp = intRTemp + 2
                    If (local_tstates >= MainForm.TstatesPerInterrupt) Then
                        '  Pas de chance : au  milieu d'un LDIR, une interruption !
                        '  interruptTriggered
                        intRTemp = intRTemp
                        Exit Do
                    End If
                Loop While count <> 0

                regPC = regPC - 2
                fH = False
                fN = False
                fPV = True
                f3 = (F_3 And (peekb(Source - 1) + regA)) '  TOCHECK: Is this correct?
                f5 = (2 And (peekb(Source - 1) + regA))   '  TOCHECK: Is this correct?

                If count = 0 Then
                    regPC = regPC + 2
                    local_tstates -= 5
                    fPV = False
                End If
                regDE = dest
                regHL = Source
                setBC(count)

            Case 177 ' CPIR
                c = fC

                cp_a(peekb(regHL))
                regHL = inc16(regHL)
                setBC(dec16(getBC))

                fC = c
                c = getBC() <> 0
                fPV = c
                If (fPV) And (fZ = False) Then
                    regPC = regPC - 2
                    local_tstates += 21
                Else
                    local_tstates += 16
                End If
            Case 178 ' INIR

                If isHector Then
                    pokeb(regHL, Hector.inb(getBC))
                Else
                    pokeb(regHL, Disc2.inb(getBC))
                End If
                b = qdec8(regB)
                regB = b
                regHL = inc16(regHL)

                fZ = True
                fN = True
                If (b <> 0) Then
                    regPC = regPC - 2
                    local_tstates += 21
                Else
                    local_tstates += 16
                End If
            Case 179 ' OTIR
                b = qdec8(regB)
                regB = b
                If isHector Then
                    Hector.outb(getBC, peekb(regHL))
                Else
                    Disc2.outb(getBC, peekb(regHL))
                End If
                regHL = inc16(regHL)

                fZ = True
                fN = True
                If (b <> 0) Then
                    regPC = regPC - 2
                    local_tstates += 21
                Else
                    local_tstates += 16
                End If

                '  xxDR
            Case 184 ' LDDR
                count = getBC()
                dest = regDE
                Source = regHL

                '  REFRESH -2
                intRTemp = intRTemp - 2
                Do
                    pokeb(dest, peekb(Source))
                    Source = (Source - 1) And 65535
                    dest = (dest - 1) And 65535
                    count = count - 1

                    local_tstates += 21

                    '  REFRESH (2)
                    intRTemp = intRTemp + 2

                    If (local_tstates >= MainForm.TstatesPerInterrupt) Then
                        '  Pas de chance : au  milieu d'un LDDR, une interruption !
                        '     Exit Do
                    End If
                Loop While count <> 0
                regPC = regPC - 2
                fH = False
                fN = False
                fPV = True

                f3 = (F_3 And (peekb(Source - 1) + regA)) '  TOCHECK: Is this correct?
                f5 = (2 And (peekb(Source - 1) + regA))   '  TOCHECK: Is this correct?

                If count = 0 Then
                    regPC = regPC + 2
                    local_tstates -= 5
                    fPV = False
                End If

                regDE = dest
                regHL = Source
                setBC(count)

            Case 185 ' CPDR
                c = fC

                cp_a(peekb(regHL))
                regHL = dec16(regHL)
                setBC(dec16(getBC))

                fPV = getBC() <> 0
                fC = c
                If (fPV) And (fZ = False) Then
                    regPC = regPC - 2
                    local_tstates += 21
                Else
                    local_tstates += 16
                End If
            Case 186 ' INDR

                If isHector Then
                    pokeb(regHL, Hector.inb(getBC))
                Else
                    pokeb(regHL, Disc2.inb(getBC))
                End If
                b = qdec8(regB)
                regB = b
                regHL = dec16(regHL)

                fZ = True
                fN = True
                If (b <> 0) Then
                    regPC = regPC - 2
                    local_tstates += 21
                Else
                    local_tstates += 16
                End If
            Case 187 ' OTDR
                b = qdec8(regB)
                regB = b
                If isHector Then
                    Hector.outb(getBC, peekb(regHL))
                Else
                    Disc2.outb(getBC, peekb(regHL))
                End If
                regHL = dec16(regHL)

                fZ = True
                fN = True
                If (b <> 0) Then
                    regPC = regPC - 2
                    local_tstates += 21
                Else
                    local_tstates += 16
                End If
            Case 187 To 191
                MsgBox("Unknown ED instruction " & xxx & " at " & regPC)
            Case Else ' (164 To 167, 172 To 175, 180 To 183)
                ' NOP
                local_tstates += 8

        End Select
        '       Return 0
        Exit Sub

ex_ed192_255:
        MsgBox("Unknown ED instruction " & xxx & " at " & regPC)
        local_tstates += 8
    End Sub
    Private Sub rld_a()
        Dim ans As Integer, t As Integer, q As Integer

        ans = regA
        t = peekb(regHL)
        q = t

        t = (t * 16) Or (ans And &HF&)
        ans = (ans And &HF0&) Or q \ 16&
        pokeb(regHL, (t And &HFF&))

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
                fPV = Parity(ans) ' taf controler a
        fH = False
        fN = False

       regA = ans
    End Sub
    Private Sub rrd_a()
        Dim ans As Integer, t As Integer, q As Integer

        ans = regA
        t = peekb(regHL)
        q = t

        t = (t \ 16&) Or (ans * 16&)
        ans = (ans And &HF0&) Or (q And &HF&)
        pokeb(regHL, t)

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False

        regA = ans
    End Sub
    Private Sub neg_a()
        Dim t As Integer

        t = regA
        regA = 0
        sub_a(t)
    End Sub

	
	
	
   Private Sub execute_id_cb(ByVal op As Integer, ByVal z As Integer)
        Dim tmp As Integer
        Select Case op
            Case 0 ' RLC B
                tmp = rlc(peekb(z)) 'jjs3
                regB = tmp
                pokeb(z, tmp)
            Case 1 ' RLC C
                tmp = rlc(peekb(z))
                regC = tmp
                pokeb(z, tmp)
            Case 2 ' RLC D
                tmp = rlc(peekb(z))
                setD(tmp)
                pokeb(z, tmp)
            Case 3 ' RLC E
                tmp = rlc(peekb(z))
                setE(tmp)
                pokeb(z, tmp)
            Case 4 ' RLC H
                tmp = rlc(peekb(z))
                setH(tmp)
                pokeb(z, tmp)
            Case 5 ' RLC L
                tmp = rlc(peekb(z))
                setL(tmp)
                pokeb(z, tmp)
            Case 6 ' RLC (HL)
                pokeb(z, rlc(peekb(z)))
            Case 7 ' RLC A
                tmp = rlc(peekb(z))
                regA = tmp
                pokeb(z, tmp)

            Case 8 ' RRC B
                tmp = rrc(peekb(z))
                regB = tmp
                pokeb(z, tmp)
            Case 9 ' RRC C
                tmp = rrc(peekb(z))
                regC = tmp
                pokeb(z, tmp)
            Case 10 ' RRC D
                tmp = rrc(peekb(z))
                setD(tmp)
                pokeb(z, tmp)
            Case 11 ' RRC E
                tmp = rrc(peekb(z))
                setE(tmp)
                pokeb(z, tmp)
            Case 12 ' RRC H
                tmp = rrc(peekb(z))
                setH(tmp)
                pokeb(z, tmp)
            Case 13 ' RRC L
                tmp = rrc(peekb(z))
                setL(tmp)
                pokeb(z, tmp)
            Case 14 ' RRC (HL)
                pokeb(z, rrc(peekb(z)))
            Case 15 ' RRC A
                tmp = rrc(peekb(z))
                regA = tmp
                pokeb(z, tmp)
            Case 16 ' RL B
                tmp = rl(peekb(z))
                regB = tmp
                pokeb(z, tmp)
            Case 17 ' RL C
                tmp = rl(peekb(z))
                regC = tmp
                pokeb(z, tmp)
            Case 18 ' RL D
                tmp = rl(peekb(z))
                setD(tmp)
                pokeb(z, tmp)
            Case 19 ' RL E
                tmp = rl(peekb(z))
                setE(tmp)
                pokeb(z, tmp)
            Case 20 ' RL H
                tmp = rl(peekb(z))
                setH(tmp)
                pokeb(z, tmp)
            Case 21 ' RL L
                tmp = rl(peekb(z))
                setL(tmp)
                pokeb(z, tmp)
            Case 22 ' RL (HL)
                pokeb(z, rl(peekb(z)))
            Case 23 ' RL A
                tmp = rl(peekb(z))
                regA = tmp
                pokeb(z, tmp)
            Case 24 ' RR B
                tmp = rr(peekb(z))
                regB = tmp
                pokeb(z, tmp)
            Case 25 ' RR C
                tmp = rr(peekb(z))
                regC = tmp
                pokeb(z, tmp)
            Case 26 ' RR D
                tmp = rr(peekb(z))
                setD(tmp)
                pokeb(z, tmp)
            Case 27 ' RR E
                tmp = rr(peekb(z))
                setE(tmp)
                pokeb(z, tmp)
            Case 28 ' RR H
                tmp = rr(peekb(z))
                setH(tmp)
                pokeb(z, tmp)
            Case 29 ' RR L
                tmp = rr(peekb(z))
                setL(tmp)
                pokeb(z, tmp)
            Case 30 ' RR (HL)
                pokeb(z, rl(peekb(z)))
            Case 31 ' RR A
                tmp = rr(peekb(z))
                regA = tmp
                pokeb(z, tmp)
            Case 32 ' SLA B
                tmp = sla(peekb(z))
                regB = tmp
                pokeb(z, tmp)
            Case 33 ' SLA C
                tmp = sla(peekb(z))
                regC = tmp
                pokeb(z, tmp)
            Case 34 ' SLA D
                tmp = sla(peekb(z))
                setD(tmp)
                pokeb(z, tmp)
            Case 35 ' SLA E
                tmp = sla(peekb(z))
                setE(tmp)
                pokeb(z, tmp)
            Case 36 ' SLA H
                tmp = sla(peekb(z))
                setH(tmp)
                pokeb(z, tmp)
            Case 37 ' SLA L
                tmp = sla(peekb(z))
                setL(tmp)
                pokeb(z, tmp)
            Case 38 ' SLA (HL)
                pokeb(z, sla(peekb(z)))
            Case 39 ' SLA A
                tmp = sla(peekb(z))
                regA = tmp
                pokeb(z, tmp)
            Case 40 ' SRA B
                tmp = sra(peekb(z))
                regB = tmp
                pokeb(z, tmp)
            Case 41 ' SRA C
                tmp = sra(peekb(z))
                regC = tmp
                pokeb(z, tmp)
            Case 42 ' SRA D
                tmp = sra(peekb(z))
                setD(tmp)
                pokeb(z, tmp)
            Case 43 ' SRA E
                tmp = sra(peekb(z))
                setE(tmp)
                pokeb(z, tmp)
            Case 44 ' SRA H
                tmp = sra(peekb(z))
                setH(tmp)
                pokeb(z, tmp)
            Case 45 ' SRA L
                tmp = sra(peekb(z))
                setL(tmp)
                pokeb(z, tmp)
            Case 46 ' SRA (HL)
                pokeb(z, sra(peekb(z)))
            Case 47 ' SRA A
                tmp = sra(peekb(z))
                regA = tmp
                pokeb(z, tmp)
            Case 48 ' SLS B
                tmp = sls(peekb(z))
                regB = tmp
                pokeb(z, tmp)
            Case 49 ' SLS C
                tmp = sls(peekb(z))
                regC = tmp
                pokeb(z, tmp)
            Case 50 ' SLS D
                tmp = sls(peekb(z))
                setD(tmp)
                pokeb(z, tmp)
            Case 51 ' SLS E
                tmp = sls(peekb(z))
                setE(tmp)
                pokeb(z, tmp)
            Case 52 ' SLS H
                tmp = sls(peekb(z))
                setH(tmp)
                pokeb(z, tmp)
            Case 53 ' SLS L
                tmp = sls(peekb(z))
                setL(tmp)
                pokeb(z, tmp)
            Case 54 ' SLS (HL)
                pokeb(z, sls(peekb(z)))
            Case 55 ' SLS A
                tmp = sls(peekb(z))
                regA = tmp
                pokeb(z, tmp)


            Case 62 ' SRL (HL)
                pokeb(z, srl(peekb(z)))
            Case 63 ' SRL A
                tmp = srl(peekb(z))
                regA = tmp
                pokeb(z, tmp)
            Case 64 To 71 ' BIT 0,B
                bit(&H1&, peekb(z))
            Case 72 To 79 ' BIT 1,B
                bit(&H2&, peekb(z))
            Case 80 To 87 ' BIT 2,B
                bit(&H4&, peekb(z))
            Case 88 To 95 ' BIT 3,B
                bit(&H8&, peekb(z))

            Case 96 To 103 ' BIT 4,B
                bit(&H10&, peekb(z))
            Case 104 To 111 ' BIT 5,B
                bit(&H20&, peekb(z))
            Case 112 To 119 ' BIT 6,B
                bit(&H40&, peekb(z))
            Case 120 To 127 ' BIT 7,B
                bit(&H80&, peekb(z))
            Case 134 ' RES 0,(HL)
                pokeb(z, bitRes(&H1&, peekb(z)))
            Case 142 ' RES 1,(HL)
                pokeb(z, bitRes(&H2&, peekb(z)))
            Case 150 ' RES 2,(HL)
                pokeb(z, bitRes(&H4&, peekb(z)))
            Case 158 ' RES 3,(HL)
                pokeb(z, bitRes(&H8&, peekb(z)))
            Case 166 ' RES 4,(HL)
                pokeb(z, bitRes(&H10&, peekb(z)))
            Case 172 ' RES 5,H
                setH(bitRes(&H20&, peekb(z)))
                pokeb(z, getH)
            Case 174 ' RES 5,(HL)
                pokeb(z, bitRes(&H20&, peekb(z)))
            Case 175 ' RES 5,A
                regA = bitRes(&H20&, peekb(z))   'tiens celui l est fait !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
                pokeb(z, regA)
            Case 182 ' RES 6,(HL)
                pokeb(z, bitRes(&H40&, peekb(z)))
            Case 190 ' RES 7,(HL)
                pokeb(z, bitRes(&H80&, peekb(z)))
            Case 198 ' SET 0,(HL)
                pokeb(z, bitSet(&H1&, peekb(z)))
            Case 206 ' SET 1,(HL)
                pokeb(z, bitSet(&H2&, peekb(z)))
            Case 214 ' SET 2,(HL)
                pokeb(z, bitSet(&H4&, peekb(z)))
            Case 222 ' SET 3,(HL)
                pokeb(z, bitSet(&H8&, peekb(z)))
            Case 230 ' SET 4,(HL)
                pokeb(z, bitSet(&H10&, peekb(z)))
            Case 238 ' SET 5,(HL)
                pokeb(z, bitSet(&H20&, peekb(z)))
            Case 246 ' SET 6,(HL)
                pokeb(z, bitSet(&H40&, peekb(z)))  'taf : mettre en place les instructions non document du genre : SET A,7,(IX+nn)
            Case 254 ' SET 7,(HL)
                pokeb(z, bitSet(&H80&, peekb(z)))   ' JJS SET 7,(IX+n)
            Case 255 ' SET 7,A
                regA = bitSet(&H80&, peekb(z))
                pokeb(z, regA)
            Case Else
                MsgBox("Invalid ID CB tmp=" & tmp & " z=" & z & "pourrait tre programm !")
        End Select
    End Sub
 
    Private Sub exx()
        Dim t As Integer

        t = regHL
        regHL = regHL_
        regHL_ = t

        t = regDE
        regDE = regDE_
        regDE_ = t

        t = getBC()
        setBC(regBC_)
        regBC_ = t
    End Sub
    Private Function getAF() As Integer
        getAF = (regA * 256&) Or getF()
    End Function
    Private Function getBC() As Integer
        getBC = (regB * 256&) Or regC
    End Function
    Private Function getD() As Integer
        getD = TabMemAddrDiv256(regDE)
    End Function
    Private Function getE() As Integer
        getE = regDE And &HFF&
    End Function
    Private Function getF() As Integer
        getF = 0 ' JJ Ajout 
        If fS Then getF = getF Or F_S
        If fZ Then getF = getF Or F_Z
        If f5 Then getF = getF Or F_5
        If fH Then getF = getF Or F_H
        If f3 Then getF = getF Or F_3
        If fPV Then getF = getF Or F_PV
        If fN Then getF = getF Or F_N
        If fC Then getF = getF Or F_C
    End Function
    Private Function getH() As Integer
        getH = TabMemAddrDiv256(regHL)
    End Function
    Private Function getL() As Integer
        getL = regHL And &HFF&
    End Function
    Private Function getR() As Integer
        getR = intR
    End Function
    Private Function id_d() As Integer
        Dim d As Integer

        d = nxtpcb()
        If d And 128 Then d = -(256 - d)
        id_d = (regID + d) And &HFFFF&
    End Function
    Private Function desa_id_d() As String
        Dim d As Integer

        d = nxtpcb()
        If d And 128 Then d = -(256 - d) 'JJS3
        desa_id_d = regID_Name & " + " & d.ToString ' + d) And &HFFFF&).ToString
    End Function
    Private Sub ld_a_i()
        fS = (intI And F_S) <> 0
        f3 = (intI And F_3) <> 0
        f5 = (intI And F_5) <> 0
        fZ = (intI = 0)
        fPV = intIFF2
        fH = False
        fN = False

        regA = intI
    End Sub
    Private Sub ld_a_r()
        '    If ((intRTemp \ 128) And 1) = 1 Then
        '        intR = 0
        '    Else
        '        intR = 128
        '    End If

        intRTemp = intRTemp And &H7F&
        regA = (intR And &H80&) Or intRTemp
        fS = (regA And F_S) <> 0
        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fZ = (regA = 0)
        fPV = intIFF2
        fH = False
        fN = False
    End Sub
   Private Function Calcul_Flag(ByRef ans As Byte) As Byte
        'Fonction passe travers pour 
        'mise en place des flag avec la valeur passe en parametres
        fC = 0
        fZ = (ans = 0)
        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fPV = Parity(ans)
        fN = False
        fH = False
        Calcul_Flag = ans
    End Function
    Private Function in_bc() As Integer
        Dim ans As Integer


        If isHector Then
            ans = Hector.inb(regC)
        Else
            ans = Disc2.inb(regC)
        End If
        fZ = (ans = 0)
        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fPV = Parity(ans)
        fN = False
        fH = False

        in_bc = ans
    End Function
    Private Function inc8(ByVal ans As Integer) As Integer
        fPV = (ans = &H7F&)
        fH = (((ans And &HF&) + 1) And F_H) <> 0

        ans = (ans + 1) And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fN = False

        inc8 = ans
    End Function
    Private Function dec8(ByVal ans As Integer) As Integer
        fPV = (ans = &H80&)
        fH = (((ans And &HF&) - 1) And F_H) <> 0

        ans = (ans - 1) And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)

        fN = True

        dec8 = ans
    End Function

    Function interrupt() As Integer
        '  PERFORM Z80 hardware functions

       'Before all if Z80 Halted, then continu !
        Halt = False
        '  If it's a maskable interrupt
        If intIFF1 = False Then
            'Interruption interdite out !
            interrupt = 0
        Else
            ' on lance l'interruption selon le mode d'interrupt programme !
    
            Select Case intIM
                Case 0, 1
                    pushpc()

                    ' 069 RETn
                    ' intIFF1 = intIFF2

                    intIFF2 = True ' intIFF1
                    intIFF1 = False
                    regPC = &H38
                    interrupt = 13
                Case 2 'au lieu de 2...
                    pushpc()
                    intIFF2 = True 'intIFF1
                    intIFF1 = False
                    regPC = peekw((intI * 256&) Or &HFF&)
                    interrupt = 19
                Case Else
                    interrupt = 0 ' cas impossible mais c'est pour VBNet...
            End Select
        End If

    End Function

    Function NMI() As Integer
        '  PERFORM Z80 hardware functions

        '  it's a NO maskable interrupt

        ' Lancement du Z80  la bonne adresse pour la NMI...
        pushpc()

        'Gestion des flags d'interruption
        intIFF2 = True 'intIFF1
        intIFF1 = False
        ' @ de branchement
        regPC = &H66
        NMI = 13

    End Function

    Private Function interruptTriggered(ByVal tstates As Integer) As Integer  ' NMI ?
        interruptTriggered = (tstates >= 0)
    End Function
    Private Sub or_a(ByVal b As Integer)
        regA = (regA Or b)

        fS = (regA And F_S) <> 0
        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fH = False
        fPV = Parity(regA)
        fZ = (regA = 0)
        fN = False
        fC = False
    End Sub
    Public Function peekw(ByVal addr As Integer) As Integer
        peekw = peekb(addr) Or (peekb((addr + 1)) * 256&)
    End Function
    Sub pokeb(ByVal addr As Integer, ByVal newByte As Integer)
        'Ecriture mmoire selon le type de machine
        If isHector Then
            Hector.MemW(addr, newByte)
        Else
            Disc2.MemW(addr, newByte)
        End If
    End Sub
    Sub pokew(ByVal addr As Integer, ByVal word As Integer)
        pokeb(addr, word And &HFF&)

        pokeb((addr + 1) And &HFFFF&, TabMemAddrDiv256(word And &HFF00&))
    End Sub
    Sub poppc()
        regPC = popw()
    End Sub
    Private Function popw() As Integer
        popw = peekb(regSP) Or (peekb(regSP + 1) * 256&)
        regSP = (regSP + 2 And &HFFFF&)
    End Function
    Sub pushpc()
        pushw(regPC)
    End Sub
    Private Sub pushw(ByVal word As Integer)
        regSP = (regSP - 2) And &HFFFF&
        pokew(regSP, word)
    End Sub
    Private Function rl(ByVal ans As Integer) As Integer
        Dim c As Integer

        c = (ans And &H80&) <> 0

        If fC Then
            ans = (ans * 2) Or &H1&
        Else
            ans = ans * 2
        End If
        ans = ans And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False
        fC = c

        rl = ans
    End Function
    Private Sub rl_a()
        Dim ans As Integer, c As Integer

        ans = regA
        c = (ans And &H80&) <> 0

        If fC Then
            ans = (ans * 2) Or &H1&
        Else
            ans = (ans * 2)
        End If
        ans = ans And &HFF&

        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fN = False
        fH = False
        fC = c

        regA = ans
    End Sub
    Private Function rlc(ByVal ans As Integer) As Integer
        Dim c As Integer

        c = (ans And &H80&) <> 0

        If c Then
            ans = (ans * 2) Or &H1&
        Else
            ans = (ans * 2)
        End If

        ans = ans And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False
        fC = c

        rlc = ans
    End Function
    Private Sub rlc_a()
        Dim c As Integer

        c = (regA And &H80&) <> 0

        If c Then
            regA = (regA * 2) Or 1
        Else
            regA = (regA * 2)
        End If
        regA = regA And &HFF&

        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fN = False
        fH = False
        fC = c
    End Sub
    Private Function rr(ByVal ans As Integer) As Integer
        Dim c As Integer

        c = (ans And &H1&) <> 0

        If fC Then
            ans = TabMemAddrDiv2(ans) Or &H80&
        Else
            ans = TabMemAddrDiv2(ans)
        End If

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False
        fC = c

        rr = ans
    End Function
    Private Sub rr_a()
        Dim ans As Integer, c As Integer

        ans = regA
        c = (ans And &H1&) <> 0

        If fC Then
            ans = TabMemAddrDiv2(ans) Or &H80&
        Else
            ans = TabMemAddrDiv2(ans)
        End If

        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fN = False
        fH = False
        fC = c

        regA = ans
    End Sub
    Private Function rrc(ByVal ans As Integer) As Integer
        Dim c As Integer

        c = (ans And &H1&) <> 0

        If c Then
            ans = TabMemAddrDiv2(ans) Or &H80&
        Else
            ans = TabMemAddrDiv2(ans)
        End If

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False
        fC = c

        rrc = ans
    End Function
    Private Sub rrc_a()
        Dim c As Integer

        c = (regA And 1) <> 0

        If c Then
            regA = TabMemAddrDiv2(regA) Or &H80&
        Else
            regA = TabMemAddrDiv2(regA)
        End If

        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fN = False
        fH = False
        fC = c
    End Sub
    Private Sub sbc_a(ByVal b As Integer)
        Dim a As Integer, wans As Integer, ans As Integer, c As Integer

        a = regA

        If fC Then c = 1

        wans = a - b - c
        ans = wans And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fC = (wans And &H100&) <> 0
        fPV = ((a Xor b) And (a Xor ans) And &H80&) <> 0
        fH = (((a And &HF&) - (b And &HF&) - c) And F_H) <> 0
        fN = True

        regA = ans
    End Sub
    Private Function sbc16(ByVal a As Integer, ByVal b As Integer) As Integer
        Dim c As Integer, lans As Integer, ans As Integer

        If fC Then c = 1

        lans = a - b - c
        ans = lans And &HFFFF&

        fS = (ans And (F_S * 256&)) <> 0
        f3 = (ans And (F_3 * 256&)) <> 0
        f5 = (ans And (F_5 * 256&)) <> 0
        fZ = (ans = 0)
        fC = (lans And &H10000) <> 0
        fPV = ((a Xor b) And (a Xor ans) And &H8000&) <> 0
        fH = (((a And &HFFF&) - (b And &HFFF&) - c) And &H1000&) <> 0
        fN = True

        sbc16 = ans
    End Function
    Private Sub scf()
        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fN = False
        fH = False
        fC = True
    End Sub
    Public Sub setAF(ByVal v As Integer)
        regA = TabMemAddrDiv256(v And &HFF00&)
        setF(v And &HFF&)
    End Sub
    Sub setBC(ByVal nn As Integer)
        regB = TabMemAddrDiv256(nn And &HFF00&)
        regC = nn And &HFF&
    End Sub

    Public Sub execute_OneShot(ByRef local_tstates As Long)  'MAIN
        Dim d As Integer, lTemp As Integer
        Dim xxx As Integer
        '  Yes, I appreciate that GOTO's and labels are a hideous blashphemy!
        '  However, this code is the fastest possible way of fetching and handling
        '  Z80 instructions I could come up with. There are only 8 compares per
        '  instruction fetch rather than between 1 and 255 as required in
        '  the previous version of vb81 with it's huge Case statement.
        ' 
        '  I know it's slightly harder to follow the new code, but I think the
        '  speed increase justifies it. <CC>

        ' Point de retour suite  excution de l'instruction courante,
        ' remplac par un exit sub pour boucle remise dans le mainform.
        'fetch_next:

        '  REFRESH 1
        intRTemp = (intRTemp + 1) And &HFFFF

        ' ******************************************************************************
        ' Instruction du Z80
        ' ******************************************************************************

        ' if Z80 halted  => out !
        If Halt Then
            local_tstates += 4 ' Generate NOP (waiting INT, if any...)
            Exit Sub
        End If

		xxx = nxtpcb()

        If (xxx And 128) Then GoTo ex128_255 Else GoTo ex0_127
ex0_127:
        If (xxx And 64) Then GoTo ex64_127 Else GoTo ex0_63
ex0_63:
        If (xxx And 32) Then GoTo ex32_63 Else GoTo ex0_31
ex0_31:
        If (xxx And 16) Then GoTo ex16_31 Else GoTo ex0_15
ex0_15:
        If (xxx And 8) Then GoTo ex8_15 Else GoTo ex0_7

ex0_7:
        If (xxx And 4) Then GoTo ex4_7 Else GoTo ex0_3

ex0_3:
        If (xxx And 2) Then GoTo ex2_3 Else GoTo ex0_1

ex0_1:
        If xxx = 0 Then
            ' 000 NOP
            local_tstates += 4
        Else
            ' 001 LD BC,nn
            setBC(nxtpcw())
            local_tstates += 10
        End If
        Exit Sub

ex2_3:
        If xxx = 2 Then
            ' 002 LD (BC),A
            pokeb(getBC, regA)
            local_tstates += 7
        Else
            ' 003 INC BC
            setBC(inc16(getBC))
            local_tstates += 6
        End If
        Exit Sub

ex4_7:
        If (xxx And 2) Then GoTo ex6_7 Else GoTo ex4_5

ex4_5:
        If xxx = 4 Then
            ' 004 INC B
            regB = inc8(regB)
            local_tstates += 4
        Else
            ' 005 DEC B
            regB = dec8(regB)
            local_tstates += 4
        End If
        Exit Sub

ex6_7:
        If xxx = 6 Then
            ' 006 LD B,n
            regB = nxtpcb()
            local_tstates += 7
        Else
            ' 007 RLCA
            rlc_a()
            local_tstates += 4
        End If
        Exit Sub

ex8_15:
        If (xxx And 4) Then GoTo ex12_15 Else GoTo ex8_11

ex8_11:
        If (xxx And 2) Then GoTo ex10_11 Else GoTo ex8_9

ex8_9:
        If xxx = 8 Then
            ' 008 EX AF,AF'
            ex_af_af()
            local_tstates += 4
        Else
            '009 ADD HL,BC
            regHL = add16(regHL, getBC())
            local_tstates += 11
        End If
        Exit Sub

ex10_11:
        If xxx = 10 Then
            ' 010 LD A,(BC)
            regA = peekb(getBC)
            local_tstates += 7
        Else
            ' 011 DEC BC
            setBC(dec16(getBC))
            local_tstates += 6
        End If
        Exit Sub

ex12_15:
        If (xxx And 2) Then GoTo ex14_15 Else GoTo ex12_13

ex12_13:
        If xxx = 12 Then
            ' 012 INC C
            regC = inc8(regC)
            local_tstates += 4
        Else
            ' 013 DEC C
            regC = dec8(regC)
            local_tstates += 4
        End If
        Exit Sub

ex14_15:
        If xxx = 14 Then
            ' 014 LD C,n
            regC = nxtpcb()
            local_tstates += 7
        Else
            ' 015 RRCA
            rrc_a()
            local_tstates += 4
        End If
        Exit Sub

ex16_31:
        If (xxx And 8) Then GoTo ex24_31 Else GoTo ex16_23

ex16_23:
        If (xxx And 4) Then GoTo ex20_23 Else GoTo ex16_19

ex16_19:
        If (xxx And 2) Then GoTo ex18_19 Else GoTo ex16_17

ex16_17:
        If xxx = 16 Then
            ' 016 DJNZ dis
            lTemp = qdec8(regB)

            regB = lTemp
            If lTemp <> 0 Then
                d = nxtpcb()
                If d And 128 Then d = -(256 - d)
                regPC = (regPC + d) And &HFFFF&
                local_tstates += 13
            Else
                regPC = inc16(regPC) ' simulation du nxpcb() non utilis
                local_tstates += 8
            End If
        Else
            ' 017 LD DE,nn
            regDE = nxtpcw()
            local_tstates += 10
        End If
        Exit Sub

ex18_19:
        If xxx = 18 Then
            ' 018 LD (DE),A
            pokeb(regDE, regA)
            local_tstates += 7
        Else
            ' 019 INC DE
            regDE = inc16(regDE)
            local_tstates += 6
        End If
        Exit Sub

ex20_23:
        If (xxx And 2) Then GoTo ex22_23 Else GoTo ex20_21

ex20_21:
        If xxx = 20 Then
            ' 020 INC D
            setD(inc8(getD))
            local_tstates += 4
        Else
            ' 021 DEC D
            setD(dec8(getD))
            local_tstates += 4
        End If
        Exit Sub

ex22_23:
        If xxx = 22 Then
            ' 022 LD D,n
            setD(nxtpcb())
            local_tstates += 7
        Else
            ' 023 ' RLA
            rl_a()
            local_tstates += 4
        End If
        Exit Sub

ex24_31:
        If (xxx And 4) Then GoTo ex28_31 Else GoTo ex24_27

ex24_27:
        If (xxx And 2) Then GoTo ex26_27 Else GoTo ex24_25

ex24_25:
        If xxx = 24 Then
            ' 024 JR dis
            d = nxtpcb()
            If d And 128 Then d = -(256 - d)
            regPC = (regPC + d) And &HFFFF&
            local_tstates += 12
        Else
            ' 025 ADD HL,DE
            regHL = add16(regHL, regDE)
            local_tstates += 11
        End If
        Exit Sub

ex26_27:
        If xxx = 26 Then
            ' 026 LD A,(DE)
            regA = peekb(regDE)
            local_tstates += 7
        Else
            ' 027 DEC DE
            regDE = dec16(regDE)
            local_tstates += 6
        End If
        Exit Sub

ex28_31:
        If (xxx And 2) Then GoTo ex30_31 Else GoTo ex28_29

ex28_29:
        If xxx = 28 Then
            ' 028 INC E
            setE(inc8(getE))
            local_tstates += 4
        Else
            ' 029 DEC E
            setE(dec8(getE))
            local_tstates += 4
        End If
        Exit Sub

ex30_31:
        If xxx = 30 Then
            ' 030 LD E,n
            setE(nxtpcb())
            local_tstates += 7
        Else
            ' 031 RRA
            rr_a()
            local_tstates += 4
        End If
        Exit Sub

ex32_63:
        If (xxx And 16) Then GoTo ex48_63 Else GoTo ex32_47

ex32_47:
        If (xxx And 8) Then GoTo ex40_47 Else GoTo ex32_39

ex32_39:
        If (xxx And 4) Then GoTo ex36_39 Else GoTo ex32_35

ex32_35:
        If (xxx And 2) Then GoTo ex34_35 Else GoTo ex32_33

ex32_33:
        If xxx = 32 Then
            ' 032 JR NZ dis
            If fZ = False Then
                d = nxtpcb()
                If d And 128 Then d = -(256 - d)
                regPC = ((regPC + d) And &HFFFF&)
                local_tstates += 12
            Else
                regPC = inc16(regPC)
                local_tstates += 7
            End If
        Else
            ' 033 LD HL,nn
            regHL = nxtpcw()
            local_tstates += 10
        End If
        Exit Sub

ex34_35:
        If xxx = 34 Then
            ' 034 LD (nn),HL
            pokew(nxtpcw(), regHL)
            local_tstates += 16
        Else
            ' 035 INC HL
            regHL = inc16(regHL)
            local_tstates += 6
        End If
        Exit Sub

ex36_39:
        If (xxx And 2) Then GoTo ex38_39 Else GoTo ex36_37

ex36_37:
        If xxx = 36 Then
            ' 036 INC H
            setH(inc8(getH))
            local_tstates += 4
        Else
            ' 037 DEC H
            setH(dec8(getH))
            local_tstates += 4
        End If
        Exit Sub

ex38_39:
        If xxx = 38 Then
            ' 038 LD H,n
            setH(nxtpcb())
            local_tstates += 7
        Else
            ' 039 DAA
            daa_a()
            local_tstates += 4
        End If
        Exit Sub

ex40_47:
        If (xxx And 4) Then GoTo ex44_47 Else GoTo ex40_43

ex40_43:
        If (xxx And 2) Then GoTo ex42_43 Else GoTo ex40_41

ex40_41:
        If xxx = 40 Then
            ' 040 JR Z dis
            If fZ = True Then
                d = nxtpcb()
                If d And 128 Then d = -(256 - d)
                regPC = ((regPC + d) And &HFFFF&)
                local_tstates += 12
            Else
                regPC = inc16(regPC)
                local_tstates += 7
            End If
        Else
            ' 041 ADD HL,HL
            regHL = add16(regHL, regHL)
            local_tstates += 11
        End If
        Exit Sub

ex42_43:
        If xxx = 42 Then
            ' 042 LD HL,(nn)
            regHL = peekw(nxtpcw())
            local_tstates += 16
        Else
            ' 043 DEC HL
            regHL = dec16(regHL)
            local_tstates += 6
        End If
        Exit Sub

ex44_47:
        If (xxx And 2) Then GoTo ex46_47 Else GoTo ex44_45

ex44_45:
        If xxx = 44 Then
            ' 044 INC L
            setL(inc8(getL))
            local_tstates += 4
        Else
            ' 045 DEC L
            setL(dec8(getL))
            local_tstates += 4
        End If
        Exit Sub

ex46_47:
        If xxx = 46 Then
            ' 046 LD L,n
            setL(nxtpcb())
            local_tstates += 7
        Else
            ' 047 CPL
            cpl_a()
            local_tstates += 4
        End If
        Exit Sub

ex48_63:
        If (xxx And 8) Then GoTo ex56_63 Else GoTo ex48_55

ex48_55:
        If (xxx And 4) Then GoTo ex52_55 Else GoTo ex48_51

ex48_51:
        If (xxx And 2) Then GoTo ex50_51 Else GoTo ex48_49

ex48_49:
        If xxx = 48 Then
            ' 048 JR NC dis
            If fC = False Then
                d = nxtpcb()
                If d And 128 Then d = -(256 - d)
                regPC = ((regPC + d) And &HFFFF&)
                local_tstates += 12
            Else
                regPC = inc16(regPC)
                local_tstates += 7
            End If
        Else
            ' 049 LD SP,nn
            regSP = nxtpcw()
            local_tstates += 10
        End If
        Exit Sub

ex50_51:
        If xxx = 50 Then
            ' 050 LD (nn),A
            pokeb(nxtpcw, regA)
            local_tstates += 13
        Else
            ' 051 INC SP
            regSP = inc16(regSP)
            local_tstates += 6
        End If
        Exit Sub

ex52_55:
        If (xxx And 2) Then GoTo ex54_55 Else GoTo ex52_53

ex52_53:
        If xxx = 52 Then
            ' 052 INC (HL)
            pokeb(regHL, inc8(peekb(regHL)))
            local_tstates += 11
        Else
            ' 053 DEC (HL)
            pokeb(regHL, dec8(peekb(regHL)))
            local_tstates += 11
        End If
        Exit Sub

ex54_55:
        If xxx = 54 Then
            ' 054 LD (HL),n
            pokeb(regHL, nxtpcb())
            local_tstates += 10
        Else
            ' 055 SCF
            scf()
            local_tstates += 4
        End If
        Exit Sub

ex56_63:
        If (xxx And 4) Then GoTo ex60_63 Else GoTo ex56_59

ex56_59:
        If (xxx And 2) Then GoTo ex58_59 Else GoTo ex56_57

ex56_57:
        If xxx = 56 Then
            ' 056 JR C dis
            If fC = True Then
                d = nxtpcb()
                If d And 128 Then d = -(256 - d)
                regPC = ((regPC + d) And &HFFFF&)
                local_tstates += 12
            Else
                regPC = inc16(regPC)
                local_tstates += 7
            End If
        Else
            ' 057 ADD HL,SP
            regHL = add16(regHL, regSP)
            local_tstates += 11
        End If
        Exit Sub

ex58_59:
        If xxx = 58 Then
            ' 058 LD A,(nn)
            regA = peekb(nxtpcw())
            local_tstates += 13
        Else
            ' 059 DEC SP
            regSP = dec16(regSP)
            local_tstates += 6
        End If
        Exit Sub

ex60_63:
        If (xxx And 2) Then GoTo ex62_63 Else GoTo ex60_61

ex60_61:
        If xxx = 60 Then
            ' 060 INC A
            regA = inc8(regA)
            local_tstates += 4
        Else
            ' 061 DEC A
            regA = dec8(regA)
            local_tstates += 4
        End If
        Exit Sub

ex62_63:
        If xxx = 62 Then
            ' 062 LD A,n
            regA = nxtpcb()
            local_tstates += 7
        Else
            ' 063 CCF
            ccf()
            local_tstates += 4
        End If
        Exit Sub

ex64_127:
        If (xxx And 32) Then GoTo ex96_127 Else GoTo ex64_95

ex64_95:
        If (xxx And 16) Then GoTo ex80_95 Else GoTo ex64_79

ex64_79:
        If (xxx And 8) Then GoTo ex72_79 Else GoTo ex64_71

ex64_71:
        If (xxx And 4) Then GoTo ex68_71 Else GoTo ex64_67

ex64_67:
        If (xxx And 2) Then GoTo ex66_67 Else GoTo ex64_65

ex64_65:
        If xxx = 64 Then
            ' LD B,B
            local_tstates += 4
        Else
            ' 65 ' LD B,C
            regB = regC
            local_tstates += 4
        End If
        Exit Sub

ex66_67:
        If xxx = 66 Then
            ' LD B,D
            regB = getD()
            local_tstates += 4
        Else
            ' 67 ' LD B,E
            regB = getE()
            local_tstates += 4
        End If
        Exit Sub

ex68_71:
        If (xxx And 2) Then GoTo ex70_71 Else GoTo ex68_69

ex68_69:
        If xxx = 68 Then
            ' LD B,H
            regB = getH()
            local_tstates += 4
        Else
            ' 69 ' LD B,L
            regB = getL()
            local_tstates += 4
        End If
        Exit Sub

ex70_71:
        If xxx = 70 Then
            ' LD B,(HL)
            regB = peekb(regHL)
            local_tstates += 7
        Else
            ' 71 ' LD B,A
            regB = regA
            local_tstates += 4
        End If
        Exit Sub

ex72_79:
        If (xxx And 4) Then GoTo ex76_79 Else GoTo ex72_75

ex72_75:
        If (xxx And 2) Then GoTo ex74_75 Else GoTo ex72_73

ex72_73:
        If xxx = 72 Then
            ' 72 ' LD C,B
            regC = regB
            local_tstates += 4
        Else
            ' 73 ' LD C,C
            local_tstates += 4
        End If
        Exit Sub

ex74_75:
        If xxx = 74 Then
            ' 74 ' LD C,D
            regC = getD()
            local_tstates += 4
        Else
            ' 75 ' LD C,E
            regC = getE()
            local_tstates += 4
        End If
        Exit Sub

ex76_79:
        If (xxx And 2) Then GoTo ex78_79 Else GoTo ex76_77

ex76_77:
        If xxx = 76 Then
            ' 76 ' LD C,H
            regC = getH()
            local_tstates += 4
        Else
            ' 77 ' LD C,L
            regC = getL()
            local_tstates += 4
        End If
        Exit Sub

ex78_79:
        If xxx = 78 Then
            ' 78 ' LD C,(HL)
            regC = peekb(regHL)
            local_tstates += 7
        Else
            ' 79 ' LD C,A
            regC = regA
            local_tstates += 4
        End If
        Exit Sub

ex80_95:
        Select Case xxx
            Case 80 ' LD D,B
                setD(regB)
                local_tstates += 4
            Case 81 ' LD D,C
                setD(regC)
                local_tstates += 4
            Case 82 ' LD D,D
                local_tstates += 4
            Case 83 ' LD D,E
                setD(getE)
                local_tstates += 4
            Case 84 ' LD D,H
                setD(getH)
                local_tstates += 4
            Case 85 ' LD D,L
                setD(getL)
                local_tstates += 4
            Case 86 ' LD D,(HL)
                setD(peekb(regHL))
                local_tstates += 7
            Case 87 ' LD D,A
                setD(regA)
                local_tstates += 4
                '  LD E,*
            Case 88 ' LD E,B
                setE(regB)
                local_tstates += 4
            Case 89 ' LD E,C
                setE(regC)
                local_tstates += 4
            Case 90 ' LD E,D
                setE(getD)
                local_tstates += 4
            Case 91 ' LD E,E
                local_tstates += 4
            Case 92 ' LD E,H
                setE(getH)
                local_tstates += 4
            Case 93 ' LD E,L
                setE(getL)
                local_tstates += 4
            Case 94 ' LD E,(HL)
                setE(peekb(regHL))
                local_tstates += 7
            Case 95 ' LD E,A
                setE(regA)
                local_tstates += 4
        End Select
        Exit Sub

ex96_127:
        If (xxx And 16) Then GoTo ex112_127 Else GoTo ex96_111

ex96_111:
        Select Case xxx
            Case 96 ' LD H,B
                setH(regB)
                local_tstates += 4
            Case 97 ' LD H,C
                setH(regC)
                local_tstates += 4
            Case 98 ' LD H,D
                setH(getD)
                local_tstates += 4
            Case 99 ' LD H,E
                setH(getE)
                local_tstates += 4
            Case 100 ' LD H,H
                local_tstates += 4
            Case 101 ' LD H,L
                setH(getL)
                local_tstates += 4
            Case 102 ' LD H,(HL)
                setH(peekb(regHL))
                local_tstates += 7
            Case 103 ' LD H,A
                setH(regA)
                local_tstates += 4
                '  LD L,*
            Case 104 ' LD L,B
                setL(regB)
                local_tstates += 4
            Case 105 ' LD L,C
                setL(regC)
                local_tstates += 4
            Case 106 ' LD L,D
                setL(getD)
                local_tstates += 4
            Case 107 ' LD L,E
                setL(getE)
                local_tstates += 4
            Case 108 ' LD L,H
                setL(getH)
                local_tstates += 4
            Case 109 ' LD L,L
                local_tstates += 4
            Case 110 ' LD L,(HL)
                setL(peekb(regHL))
                local_tstates += 7
            Case 111 ' LD L,A
                setL(regA)
                local_tstates += 4
        End Select
        Exit Sub

ex112_127:
        If (xxx And 8) Then GoTo ex120_127 Else GoTo ex112_119

ex112_119:
        If (xxx And 4) Then GoTo ex116_119 Else GoTo ex112_115

ex112_115:
        If (xxx And 2) Then GoTo ex114_115 Else GoTo ex112_113

ex112_113:
        If xxx = 112 Then
            ' 112 ' LD (HL),B
            pokeb(regHL, regB)
            local_tstates += 7
        Else
            ' 113 ' LD (HL),C
            pokeb(regHL, regC)
            local_tstates += 7
        End If
        Exit Sub

ex114_115:
        If xxx = 114 Then
            ' 114 ' LD (HL),D
            pokeb(regHL, getD)
            local_tstates += 7
        Else
            ' 115 ' LD (HL),E
            pokeb(regHL, getE)
            local_tstates += 7
        End If
        Exit Sub

ex116_119:
        Select Case xxx
            Case 116 ' LD (HL),H
                pokeb(regHL, getH)
                local_tstates += 7
            Case 117 ' LD (HL),L
                pokeb(regHL, getL)
                local_tstates += 7
            Case 118 ' HALT
                'Set Halt bit to stop the Z80 one shot execution
                Halt = True

                local_tstates += 4
            Case 119 ' LD (HL),A
                pokeb(regHL, regA)
                local_tstates += 7
        End Select
        Exit Sub

ex120_127:
        If (xxx And 4) Then GoTo ex124_127 Else GoTo ex120_123

ex120_123:
        If (xxx And 2) Then GoTo ex122_123 Else GoTo ex120_121

ex120_121:
        If xxx = 120 Then
            ' 120 ' LD A,B
            regA = regB
            local_tstates += 4
        Else
            ' 121 ' LD A,C
            regA = regC
            local_tstates += 4
        End If
        Exit Sub

ex122_123:
        If xxx = 122 Then
            ' 122 ' LD A,D
            regA = getD()
            local_tstates += 4
        Else
            ' 123 ' LD A,E
            regA = getE()
            local_tstates += 4
        End If
        Exit Sub

ex124_127:
        If (xxx And 2) Then GoTo ex126_127 Else GoTo ex124_125

ex124_125:
        If xxx = 124 Then
            ' 124 ' LD A,H
            regA = getH()
            local_tstates += 4
        Else
            ' 125 ' LD A,L
            regA = getL()
            local_tstates += 4
        End If
        Exit Sub

ex126_127:
        If xxx = 126 Then
            ' 126 ' LD A,(HL)
            regA = peekb(regHL)
            local_tstates += 7
        Else
            ' 127 ' LD A,A
            local_tstates += 4
        End If
        Exit Sub

ex128_255:
        If (xxx And 64) Then GoTo ex192_255 Else GoTo ex128_191

ex128_191:
        If (xxx And 32) Then GoTo ex160_191 Else GoTo ex128_159

ex128_159:
        Select Case xxx    '  ADD A,*
            Case 128 ' ADD A,B
                add_a(regB)
                local_tstates += 4
            Case 129 ' ADD A,C
                add_a(regC)
                local_tstates += 4
            Case 130 ' ADD A,D
                add_a(getD)
                local_tstates += 4
            Case 131 ' ADD A,E
                add_a(getE)
                local_tstates += 4
            Case 132 ' ADD A,H
                add_a(getH)
                local_tstates += 4
            Case 133 ' ADD A,L
                add_a(getL)
                local_tstates += 4
            Case 134 ' ADD A,(HL)
                add_a(peekb(regHL))
                local_tstates += 7
            Case 135 ' ADD A,A
                add_a(regA)
                local_tstates += 4
            Case 136 ' ADC A,B
                adc_a(regB)
                local_tstates += 4
            Case 137 ' ADC A,C
                adc_a(regC)
                local_tstates += 4
            Case 138 ' ADC A,D
                adc_a(getD)
                local_tstates += 4
            Case 139 ' ADC A,E
                adc_a(getE)
                local_tstates += 4
            Case 140 ' ADC A,H
                adc_a(getH)
                local_tstates += 4
            Case 141 ' ADC A,L
                adc_a(getL)
                local_tstates += 4
            Case 142 ' ADC A,(HL)
                adc_a(peekb(regHL))
                local_tstates += 7
            Case 143 ' ADC A,A
                adc_a(regA)
                local_tstates += 4
            Case 144 ' SUB B
                sub_a(regB)
                local_tstates += 4
            Case 145 ' SUB C
                sub_a(regC)
                local_tstates += 4
            Case 146 ' SUB D
                sub_a(getD)
                local_tstates += 4
            Case 147 ' SUB E
                sub_a(getE)
                local_tstates += 4
            Case 148 ' SUB H
                sub_a(getH)
                local_tstates += 4
            Case 149 ' SUB L
                sub_a(getL)
                local_tstates += 4
            Case 150 ' SUB (HL)
                sub_a(peekb(regHL))
                local_tstates += 7
            Case 151 ' SUB A
                sub_a(regA)
                local_tstates += 4
            Case 152 ' SBC A,B
                sbc_a(regB)
                local_tstates += 4
            Case 153 ' SBC A,C
                sbc_a(regC)
                local_tstates += 4
            Case 154 ' SBC A,D
                sbc_a(getD)
                local_tstates += 4
            Case 155 ' SBC A,E
                sbc_a(getE)
                local_tstates += 4
            Case 156 ' SBC A,H
                sbc_a(getH)
                local_tstates += 4
            Case 157 ' SBC A,L
                sbc_a(getL)
                local_tstates += 4
            Case 158 ' SBC A,(HL)
                sbc_a(peekb(regHL))
                local_tstates += 7
            Case 159 ' SBC A,A
                sbc_a(regA)
                local_tstates += 4
        End Select
        Exit Sub

ex160_191:
        If (xxx And 16) Then GoTo ex176_191 Else GoTo ex160_175

ex160_175:
        If (xxx And 8) Then GoTo ex168_175 Else GoTo ex160_167

ex160_167:
        If (xxx And 4) Then GoTo ex164_167 Else GoTo ex160_163

ex160_163:
        Select Case xxx
            Case 160 ' AND B
                and_a(regB)
                local_tstates += 4
            Case 161 ' AND C
                and_a(regC)
                local_tstates += 4
            Case 162 ' AND D
                and_a(getD)
                local_tstates += 4
            Case 163 ' AND E
                and_a(getE)
                local_tstates += 4
        End Select
        Exit Sub

ex164_167:
        Select Case xxx
            Case 164 ' AND H
                and_a(getH)
                local_tstates += 4
            Case 165 ' AND L
                and_a(getL)
                local_tstates += 4
            Case 166 ' AND (HL)
                and_a(peekb(regHL))
                local_tstates += 7
            Case 167 ' AND A
                and_a(regA)
                local_tstates += 4
        End Select
        Exit Sub

ex168_175:
        If (xxx And 4) Then GoTo ex172_175 Else GoTo ex168_171

ex168_171:
        Select Case xxx
            Case 168 ' XOR B
                xor_a(regB)
                local_tstates += 4
            Case 169 ' XOR C
                xor_a(regC)
                local_tstates += 4
            Case 170 ' XOR D
                xor_a(getD)
                local_tstates += 4
            Case 171 ' XOR E
                xor_a(getE)
                local_tstates += 4
        End Select
        Exit Sub

ex172_175:
        Select Case xxx
            Case 172 ' XOR H
                xor_a(getH)
                local_tstates += 4
            Case 173 ' XOR L
                xor_a(getL)
                local_tstates += 4
            Case 174 ' XOR (HL)
                xor_a(peekb(regHL))
                local_tstates += 7
            Case 175 ' XOR A
                regA = 0
                fS = False
                f3 = False
                f5 = False
                fH = False
                fPV = True
                fZ = True
                fN = False
                fC = False
                local_tstates += 4
        End Select
        Exit Sub

ex176_191:
        Select Case xxx
            Case 176 ' OR B
                or_a(regB)
                local_tstates += 4
            Case 177 ' OR C
                or_a(regC)
                local_tstates += 4
            Case 178 ' OR D'
                or_a(getD)
                local_tstates += 4
            Case 179 ' OR E
                or_a(getE)
                local_tstates += 4
            Case 180 ' OR H
                or_a(getH)
                local_tstates += 4
            Case 181 ' OR L
                or_a(getL)
                local_tstates += 4
            Case 182 ' OR (HL)
                or_a(peekb(regHL))
                local_tstates += 7
            Case 183 ' OR A
                or_a(regA)
                local_tstates += 4
                '  CP
            Case 184 ' CP B
                cp_a(regB)
                local_tstates += 4
            Case 185 ' CP C
                cp_a(regC)
                local_tstates += 4
            Case 186 ' CP D
                cp_a(getD)
                local_tstates += 4
            Case 187 ' CP E
                cp_a(getE)
                local_tstates += 4
            Case 188 ' CP H
                cp_a(getH)
                local_tstates += 4
            Case 189 ' CP L
                cp_a(getL)
                local_tstates += 4
            Case 190 ' CP (HL)
                cp_a(peekb(regHL))
                local_tstates += 7
            Case 191 ' CP A
                cp_a(regA)
                local_tstates += 4
        End Select
        Exit Sub

ex192_255:
        If (xxx And 32) Then GoTo ex224_255 Else GoTo ex192_223

ex192_223:
        If (xxx And 16) Then GoTo ex208_223 Else GoTo ex192_207

ex192_207:
        Select Case xxx
            Case 192 ' RET NZ
                If fZ = False Then
                    poppc()
                    local_tstates += 11
                Else
                    local_tstates += 5
                End If
            Case 193 ' POP BC
                setBC(popw)
                local_tstates += 10
            Case 194 ' JP NZ,nn
                If fZ = False Then
                    regPC = nxtpcw()
                Else
                    regPC = regPC + 2
                End If
                local_tstates += 10
            Case 195 ' JP nn
                regPC = peekw(regPC)
                local_tstates += 10
            Case 196 ' CALL NZ,nn
                If fZ = False Then
                    pushw(regPC + 2)
                    regPC = nxtpcw()
                    local_tstates += 17
                Else
                    regPC = regPC + 2
                    local_tstates += 10
                End If
            Case 197 ' PUSH BC
                pushw(getBC)
                local_tstates += 11
            Case 198 ' ADD A,n
                add_a(nxtpcb())
                local_tstates += 7
            Case 199 ' RST 0
                pushpc()
                regPC = 0
                local_tstates += 11
            Case 200 ' RET Z
                If fZ Then
                    poppc()
                    local_tstates += 11
                Else
                    local_tstates += 5
                End If
            Case 201 ' RET
                poppc()
                local_tstates += 10
            Case 202 ' JP Z,nn
                If fZ Then
                    regPC = nxtpcw()
                Else
                    regPC = regPC + 2
                End If
                local_tstates += 10
            Case 203 ' Prefix CB
                local_tstates += execute_cb()   'excution code CB
            Case 204 ' CALL Z,nn
                If fZ Then
                    pushw(regPC + 2)
                    regPC = nxtpcw()
                    local_tstates += 17
                Else
                    regPC = regPC + 2
                    local_tstates += 10
                End If
            Case 205 ' CALL nn
                pushw(regPC + 2)
                regPC = nxtpcw()
                local_tstates += 17
            Case 206 ' ADC A,n
                adc_a(nxtpcb())
                local_tstates += 7
            Case 207 ' RST 8
                pushpc()
                regPC = 8
                local_tstates += 11
        End Select
        Exit Sub

ex208_223:
        If (xxx And 8) Then GoTo ex216_223 Else GoTo ex208_215

ex208_215:
        Select Case xxx
            Case 208 ' RET NC
                If fC = False Then
                    poppc()
                    local_tstates += 11
                Else
                    local_tstates += 5
                End If
            Case 209 ' POP DE
                regDE = popw()
                local_tstates += 10
            Case 210 '  JP NC,nn
                If fC = False Then
                    regPC = nxtpcw()
                Else
                    regPC = regPC + 2
                End If
                local_tstates += 10
            Case 211 ' OUT (n),A

                If isHector Then
                    Hector.outb(nxtpcb, regA)
                Else
                    Disc2.outb(nxtpcb, regA)
                End If
                local_tstates += 11
            Case 212 ' CALL NC,nn
                If fC = False Then
                    pushw(regPC + 2)
                    regPC = nxtpcw()
                    local_tstates += 17
                Else
                    regPC = regPC + 2
                    local_tstates += 10
                End If
            Case 213 ' PUSH DE
                pushw(regDE)
                local_tstates += 11
            Case 214 ' SUB n
                sub_a(nxtpcb())
                local_tstates += 7
            Case 215 ' RST 16
                pushpc()
                regPC = 16
                local_tstates += 11
        End Select
        Exit Sub

ex216_223:
        If (xxx And 4) Then GoTo ex220_223 Else GoTo ex216_219

ex216_219:
        Select Case xxx
            Case 216 ' RET C
                If fC Then
                    poppc()
                    local_tstates += 11
                Else
                    local_tstates += 5
                End If
            Case 217 ' EXX
                exx()
                local_tstates += 4
            Case 218 ' JP C,nn
                If fC Then
                    regPC = nxtpcw()
                Else
                    regPC = regPC + 2
                End If
                local_tstates += 10
            Case 219 ' IN A,(n)
                If isHector Then
                    regA = Hector.inb((regA * 256) Or nxtpcb())
                Else
                    regA = Disc2.inb((regA * 256) Or nxtpcb())
                End If
                local_tstates += 11
        End Select
        Exit Sub

ex220_223:
        Select Case xxx
            Case 220 ' CALL C,nn
                If fC Then
                    pushw(regPC + 2)
                    regPC = nxtpcw()
                    local_tstates += 17
                Else
                    regPC = regPC + 2
                    local_tstates += 10
                End If
            Case 221 ' prefix IX  '             inversion IX/ID !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  bug !!!!!
                regID = regIX
                regID_Name = "IX"
                local_tstates += execute_id()        'excution code ID
                regIX = regID
            Case 222 ' SBC n
                sbc_a(nxtpcb())
                local_tstates += 7
            Case 223 ' RST 24
                pushpc()
                regPC = 24
                local_tstates += 11
        End Select
        Exit Sub

ex224_255:
        If (xxx And 16) Then GoTo ex240_255 Else GoTo ex224_239

ex224_239:
        If (xxx And 8) Then GoTo ex232_239 Else GoTo ex224_231

ex224_231:
        If (xxx And 4) Then GoTo ex228_231 Else GoTo ex224_227

ex224_227:
        If (xxx And 2) Then GoTo ex226_227 Else GoTo ex224_225

ex224_225:
        If xxx = 224 Then
            ' 224 ' RET PO
            If fPV = False Then
                poppc()
                local_tstates += 11
            Else
                local_tstates += 5
            End If
        Else
            ' 225 ' POP HL
            regHL = popw()
            local_tstates += 10
        End If
        Exit Sub

ex226_227:
        If xxx = 226 Then
            ' 226 JP PO,nn
            If fPV = False Then
                regPC = nxtpcw()
            Else
                regPC = regPC + 2
            End If
            local_tstates += 10
        Else
            ' 227 ' EX (SP),HL
            lTemp = regHL
            regHL = peekw(regSP)
            pokew(regSP, lTemp)
            local_tstates += 19
        End If
        Exit Sub

ex228_231:
        If (xxx And 2) Then GoTo ex230_231 Else GoTo ex228_229

ex228_229:
        If xxx = 228 Then
            ' 228 ' CALL PO,nn
            If fPV = False Then
                pushw(regPC + 2)
                regPC = nxtpcw()
                local_tstates += 17
            Else
                regPC = regPC + 2
                local_tstates += 10
            End If
        Else
            ' 229 ' PUSH HL
            pushw(regHL)
            local_tstates += 11
        End If
        Exit Sub

ex230_231:
        If xxx = 230 Then
            ' 230 ' AND n
            and_a(nxtpcb())
            local_tstates += 7
        Else
            ' 231 ' RST 32
            pushpc()
            regPC = 32
            local_tstates += 11
        End If
        Exit Sub

ex232_239:
        If (xxx And 4) Then GoTo ex236_239 Else GoTo ex232_235

ex232_235:
        If (xxx And 2) Then GoTo ex234_235 Else GoTo ex232_233

ex232_233:
        If xxx = 232 Then
            ' 232 ' RET PE
            If fPV Then
                poppc()
                local_tstates += 11
            Else
                local_tstates += 5
            End If
        Else
            ' 233 ' JP HL
            regPC = regHL
            local_tstates += 4
        End If
        Exit Sub

ex234_235:
        If xxx = 234 Then
            ' 234 ' JP PE,nn
            If fPV Then
                regPC = nxtpcw()
            Else
                regPC = regPC + 2
            End If
            local_tstates += 10
        Else
            ' 235 ' EX DE,HL
            lTemp = regHL
            regHL = regDE
            regDE = lTemp
            local_tstates += 4
        End If
        Exit Sub

ex236_239:
        If (xxx And 2) Then GoTo ex238_239 Else GoTo ex236_237

ex236_237:
        If xxx = 236 Then
            ' 236 ' CALL PE,nn
            If fPV Then
                pushw(regPC + 2)
                regPC = nxtpcw()
                local_tstates += 17
            Else
                regPC = regPC + 2
                local_tstates += 10
            End If
        Else
            ' 237 ' prefix ED
            execute_ed(local_tstates)      'excution code ED
        End If
        Exit Sub

ex238_239:
        If xxx = 238 Then
            ' 238 ' XOR n
            xor_a(nxtpcb())
            local_tstates += 7
        Else
            ' 239 ' RST 40
            pushpc()
            regPC = 40
            local_tstates += 11
        End If
        Exit Sub

ex240_255:
        If (xxx And 8) Then GoTo ex248_255 Else GoTo ex240_247

ex240_247:
        If (xxx And 4) Then GoTo ex244_247 Else GoTo ex240_243

ex240_243:
        If (xxx And 2) Then GoTo ex242_243 Else GoTo ex240_241

ex240_241:
        If xxx = 240 Then
            ' 240 RET P
            If fS = False Then
                poppc()
                local_tstates += 11
            Else
                local_tstates += 5
            End If
        Else
            ' 241 POP AF
            setAF(popw)
            local_tstates += 10
        End If
        Exit Sub

ex242_243:
        If xxx = 242 Then
            ' 242 JP P,nn
            If fS = False Then
                regPC = nxtpcw()
            Else
                regPC = regPC + 2
            End If
            local_tstates += 10
        Else
            ' 243 DI
            intIFF1 = False
            intIFF2 = False
            local_tstates += 4
        End If
        Exit Sub

ex244_247:
        If (xxx And 2) Then GoTo ex246_247 Else GoTo ex244_245

ex244_245:
        If xxx = 244 Then
            ' 244 CALL P,nn
            If fS = False Then
                pushw(regPC + 2)
                regPC = nxtpcw()
                local_tstates += 17
            Else
                regPC = regPC + 2
                local_tstates += 10
            End If
        Else
            ' 245 PUSH AF
            pushw(getAF)
            local_tstates += 11
        End If
        Exit Sub

ex246_247:
        If xxx = 246 Then
            ' 246 OR n
            or_a(nxtpcb())
            local_tstates += 7
        Else
            ' 247 RST 48
            pushpc()
            regPC = 48
            local_tstates += 11
        End If
        Exit Sub

ex248_255:
        If (xxx And 4) Then GoTo ex252_255 Else GoTo ex248_251

ex248_251:
        If (xxx And 2) Then GoTo ex250_251 Else GoTo ex248_249

ex248_249:
        If xxx = 248 Then
            ' 248 RET M
            If fS Then
                poppc()
                local_tstates += 11
            Else
                local_tstates += 5
            End If
        Else
            ' 249 LD SP,HL
            regSP = regHL
            local_tstates += 6
        End If
        Exit Sub

ex250_251:
        If xxx = 250 Then
            ' 250 JP M,nn
            If fS Then
                regPC = nxtpcw()
            Else
                regPC = regPC + 2
            End If
            local_tstates += 10
        Else
            ' 251 EI
            intIFF1 = True
            intIFF2 = True
            local_tstates += 4
        End If
        Exit Sub

ex252_255:
        If (xxx And 2) Then GoTo ex254_255 Else GoTo ex252_253

ex252_253:
        If xxx = 252 Then
            ' 252 CALL M,nn
            If fS Then
                pushw(regPC + 2)
                regPC = nxtpcw()
                local_tstates += 17
            Else
                regPC = regPC + 2
                local_tstates += 10
            End If
        Else
            ' 253 prefix IY
            regID = regIY
            local_tstates += execute_id()
            regIY = regID
        End If
        Exit Sub

ex254_255:
        If xxx = 254 Then
            ' 254 CP n
            cp_a(nxtpcb())
            local_tstates += 7
        Else
            ' 255 RST 56
            pushpc()
            regPC = 56
            local_tstates += 11
        End If
        Exit Sub
    End Sub

    ' Fonctions simplifies pour le dessassemblage Z80 textuel...
    Private Function Desa_ed() As String
        Dim xxx As Integer

        '  Yes, I appreciate that GOTO's and labels are a hideous blashphemy!
        '  However, this code is the fastest possible way of fetching and handling
        '  Z80 instructions I could come up with. There are only 8 compares per
        '  instruction fetch rather than between 1 and 255 as required in
        '  the previous version of vb81 with it's huge Case statement.
        ' 
        '  I know it's slightly harder to follow the new code, but I think the
        '  speed increase justifies it. <CC>


        xxx = nxtpcb()
        Desa_ed = " code ED non trouv"
        If (xxx And 128) Then GoTo ex_ed128_255 Else GoTo ex_ed0_127

ex_ed0_127:
        If (xxx And 64) Then
            GoTo ex_ed64_127
        Else
            ' 000 to 063 = NOP
            Desa_ed = " NOP   "
            Exit Function
        End If

ex_ed64_127:
        If (xxx And 32) Then GoTo ex_ed96_127 Else GoTo ex_ed64_95

ex_ed64_95:
        If (xxx And 16) Then GoTo ex_ed80_95 Else GoTo ex_ed64_79

ex_ed64_79:
        If (xxx And 8) Then GoTo ex_ed72_79 Else GoTo ex_ed64_71

ex_ed64_71:
        If (xxx And 4) Then GoTo ex_ed68_71 Else GoTo ex_ed64_67

ex_ed64_67:
        If (xxx And 2) Then GoTo ex_ed66_67 Else GoTo ex_ed64_65

ex_ed64_65:
        If xxx = 64 Then
            ' 064 IN B,(c)
            Desa_ed = " IN    B,(c)"
        Else
            ' 065 OUT (c),B
            Desa_ed = " OUT   (c),B"
        End If
        Exit Function

ex_ed66_67:
        If xxx = 66 Then
            ' 066 SBC HL,BC
            Desa_ed = " SBC   HL,BC"
        Else
            ' 067 LD (nn),BC
            Desa_ed = " LD    ("
            Desa_ed = Desa_ed + Caractere_hex4(nxtpcw()) + "),BC"
        End If
        Exit Function

ex_ed68_71:
        If (xxx And 2) Then GoTo ex_ed70_71 Else GoTo ex_ed68_69

ex_ed68_69:
        If xxx = 68 Then
            ' 068 NEG
            Desa_ed = " NEG   A"
        Else
            ' 069 RETn
            Desa_ed = " RETn   "
        End If
        Exit Function

ex_ed70_71:
        If xxx = 70 Then
            ' 070 IM 0
            Desa_ed = " IM    0"
        Else
            ' 071 LD I,A
            Desa_ed = " LD    I,A"
        End If
        Exit Function

ex_ed72_79:
        If (xxx And 4) Then GoTo ex_ed76_79 Else GoTo ex_ed72_75

ex_ed72_75:
        If (xxx And 2) Then GoTo ex_ed74_75 Else GoTo ex_ed72_73

ex_ed72_73:
        If xxx = 72 Then
            ' 072 IN C,(c)
            Desa_ed = " IN    C,(c)"
        Else
            ' 073 OUT (c),C
            Desa_ed = " OUT   (c),C"
        End If
        Exit Function

ex_ed74_75:
        If xxx = 74 Then
            ' 074 ADC HL,BC
            Desa_ed = " ADC   HL,BC"
        Else
            ' 075 LD BC,(nn)
            Desa_ed = " LD    BC,("
            Desa_ed = Desa_ed + Caractere_hex4(nxtpcw()) + ")"
        End If
        Exit Function

ex_ed76_79:
        If (xxx And 2) Then GoTo ex_ed78_79 Else GoTo ex_ed76_77

ex_ed76_77:
        If xxx = 76 Then
            ' 076 NEG
            Desa_ed = " NEG   A"
        Else
            ' 077 RETI
            Desa_ed = " RETI"
        End If
        Exit Function

ex_ed78_79:
        If xxx = 78 Then
            ' 078 IM 0
            Desa_ed = " IM    0"
        Else
            ' 079 LD R,A
            Desa_ed = " LD    R,A"
        End If
        Exit Function

ex_ed80_95:
        If (xxx And 8) Then GoTo ex_ed88_95 Else GoTo ex_ed80_87

ex_ed80_87:
        If (xxx And 4) Then GoTo ex_ed84_87 Else GoTo ex_ed80_83

ex_ed80_83:
        If (xxx And 2) Then GoTo ex_ed82_83 Else GoTo ex_ed80_81

ex_ed80_81:
        If xxx = 80 Then
            ' 080 IN D,(c)
            Desa_ed = " IN    D,(c)"
        Else
            ' 081 OUT (c),D
            Desa_ed = " OUT   (c),D"
        End If
        Exit Function

ex_ed82_83:
        If xxx = 82 Then
            ' 082 SBC HL,DE
            Desa_ed = " SBC   HL,DE"
        Else
            ' 083 LD (nn),DE
            Desa_ed = " LD    ("
            Desa_ed = Desa_ed + Caractere_hex4(nxtpcw()) + "),DE"
        End If
        Exit Function

ex_ed84_87:
        If (xxx And 2) Then GoTo ex_ed86_87 Else GoTo ex_ed84_85

ex_ed84_85:
        If xxx = 84 Then
            ' NEG
            Desa_ed = " NEG   A"
        Else
            ' 85 RETn
            Desa_ed = " RETn"
        End If
        Exit Function

ex_ed86_87:
        If xxx = 86 Then
            ' 86 ' IM 1
            Desa_ed = " IM    1"
        Else
            ' 87 ' LD A,I
            Desa_ed = " LD    A,I"
        End If
        Exit Function

ex_ed88_95:
        If (xxx And 4) Then GoTo ex_ed92_95 Else GoTo ex_ed88_91

ex_ed88_91:
        If (xxx And 2) Then GoTo ex_ed90_91 Else GoTo ex_ed88_89

ex_ed88_89:
        If xxx = 88 Then
            ' 088 IN E,(c)
            Desa_ed = " IN    E,(c)"
        Else
            ' 089 OUT (c),E
            Desa_ed = " OUT    (c),E"
        End If
        Exit Function

ex_ed90_91:
        If xxx = 90 Then
            ' 090 ADC HL,DE
            Desa_ed = " ADC   HL,DE"
        Else
            ' 091 LD DE,(nn)
            Desa_ed = " LD    DE,("
            Desa_ed = Desa_ed + Caractere_hex4(nxtpcw()) + ")"
        End If
        Exit Function

ex_ed92_95:
        If (xxx And 2) Then GoTo ex_ed94_95 Else GoTo ex_ed92_93

ex_ed92_93:
        If xxx = 92 Then
            ' NEG
            Desa_ed = " NEG   A"
        Else
            ' 93 RETI
            Desa_ed = " RETI"
        End If
        Exit Function

ex_ed94_95:
        If xxx = 94 Then
            ' IM 2
            Desa_ed = " IM    2"
        Else
            ' 95 LD A,R
            Desa_ed = " LD    A,R"
        End If
        Exit Function

ex_ed96_127:
        If (xxx And 16) Then GoTo ex_ed112_127 Else GoTo ex_ed96_111

ex_ed96_111:
        If (xxx And 8) Then GoTo ex_ed104_111 Else GoTo ex_ed96_103

ex_ed96_103:
        Select Case xxx
            Case 96 ' IN H,(c)
                Desa_ed = " IN    H,(c)"
            Case 97 ' OUT (c),H
                Desa_ed = " OUT   (c),H"
            Case 98 ' SBC HL,HL
                Desa_ed = " SBC   HL,HL"
            Case 99 ' LD (nn),HL
                Desa_ed = " LD    ("
                Desa_ed = Desa_ed + Caractere_hex4(nxtpcw()) + "),HL"
            Case 100 ' NEG
                Desa_ed = " NEG   A"
            Case 101 ' RETn
                Desa_ed = " RETn"
            Case 102 ' IM 0
                Desa_ed = " IM    0"
            Case 103 ' RRD
                Desa_ed = " RRD"
            Case Else
                Desa_ed = " ie..."
        End Select
        Exit Function

ex_ed104_111:
        Select Case xxx
            Case 104 ' IN L,(c)
                Desa_ed = " IN    L,(c)"
            Case 105 ' OUT (c),L
                Desa_ed = " OUT   (c),L"
            Case 106 ' ADC HL,HL
                Desa_ed = " ADC   HL,HL"
            Case 107 ' LD HL,(nn)
                Desa_ed = " LD    HL,("
                Desa_ed = Desa_ed + Caractere_hex4(nxtpcw()) + ")"
            Case 108 ' NEG
                Desa_ed = " NEG   A"
            Case 109 ' RETI
                Desa_ed = " RETI"
            Case 110 ' IM 0
                Desa_ed = " IM    0"
            Case 111  ' RLD
                Desa_ed = " RLD"
        End Select
        '   Return 0
        Exit Function

ex_ed112_127:
        If (xxx And 8) Then GoTo ex_ed120_127 Else GoTo ex_ed112_119

ex_ed112_119:
        Select Case xxx
            Case 112 ' IN (c)
                Desa_ed = " IN    (C)"
            Case 113 ' OUT (c),0
                Desa_ed = " OUT   (c),0"
            Case 114 ' SBC HL,SP
                Desa_ed = " SUB   HL,SP"
            Case 115 ' LD (nn),SP
                Desa_ed = " LD    ("
                Desa_ed = Desa_ed + Caractere_hex4(nxtpcw()) + "),SP"
            Case 116 ' NEG
                Desa_ed = " NEG    A"
            Case 117 ' RETn
                Desa_ed = " RETn"
            Case 118 ' IM 1
                Desa_ed = " IM     1"
            Case 119
                MsgBox("Unknown opcode 0xED 119")
        End Select
        '   Return 0
        Exit Function

ex_ed120_127:
        Select Case xxx
            Case 120 ' IN A,(c)
                Desa_ed = " IN    A,(c)"
            Case 121 ' OUT (c),A
                Desa_ed = " OUT   (c),A"
            Case 122 ' ADC HL,SP
                Desa_ed = " ADC   HL,SP"
            Case 123 ' LD SP,(nn)
                Desa_ed = " LD    SP,("
                Desa_ed = Desa_ed + Caractere_hex4(nxtpcw()) + ")"
            Case 124 ' NEG
                Desa_ed = " NEG   A"
            Case 125 ' RETI
                Desa_ed = " RETI"
            Case 126 ' IM 2
                Desa_ed = " IM    2"
            Case 127 ' NOP
                Desa_ed = " NOP"
        End Select

        '   Return 0
        Exit Function

ex_ed128_255:
        If (xxx And 64) Then GoTo ex_ed192_255 Else GoTo ex_ed128_191

ex_ed128_191:
        If (xxx And 32) Then
            GoTo ex_ed160_191
        Else
            ' NOP
            Desa_ed = " NOP"
            Exit Function
        End If

ex_ed160_191:
        Select Case xxx           '  xxI
            Case 160 ' LDI
                Desa_ed = " LDI"
            Case 161 ' CPI
                Desa_ed = " CPI"
            Case 162 ' INI
                Desa_ed = " INI"
            Case 163 ' OUTI
                Desa_ed = " OUTI"

                ' /* xxD */
            Case 168 ' LDD
                Desa_ed = " LDD"
            Case 169 ' CPD
                Desa_ed = " CPD"
            Case 170 ' IND
                Desa_ed = " IND"
            Case 171 ' OUTD
                Desa_ed = " OUTD"

                '  xxIR
            Case 176 ' LDIR
                Desa_ed = " LDIR"
            Case 177 ' CPIR
                Desa_ed = " CPIR"
            Case 178 ' INIR
                Desa_ed = " INIR"
            Case 179 ' OTIR
                Desa_ed = " OTIR"

                '  xxDR
            Case 184 ' LDDR
                Desa_ed = " LDDR"
            Case 185 ' CPDR
                Desa_ed = " CPDR"
            Case 186 ' INDR
                Desa_ed = " INDR"
            Case 187 ' OTDR
                Desa_ed = " OTDR"
            Case 187 To 191
                MsgBox("Unknown ED instruction " & xxx & " at " & regPC)
            Case Else ' (164 To 167, 172 To 175, 180 To 183)
                ' NOP
                Desa_ed = " NOP"

        End Select
        '  Return 0
        Exit Function

ex_ed192_255:

        Desa_ed = "Unknown ED instruction " & xxx & " at " & regPC
    End Function

    'Documentation Du deplacement dans les instructions (IX + d)
    Private Function desa_dpl() As String
        ' Function qui documente le dplacement lors des utilisations des
        ' fonctions (IX+d) 
        Dim xxx As Integer
        ' Lecture de l'octet suivant
        xxx = nxtpcb()
        desa_dpl = xxx.ToString ' Mise en place de l'octet lu !
    End Function

    Private Function desa_id(ByVal RegID As String) As String
        Dim xxx As Integer, op As Integer


        '  Yes, I appreciate that GOTO's and labels are a hideous blashphemy!
        '  However, this code is the fastest possible way of fetching and handling
        '  Z80 instructions I could come up with. There are only 8 compares per
        '  instruction fetch rather than between 1 and 255 as required in
        '  the previous version of vb81 with it's huge Case statement.
        ' 
        '  I know it's slightly harder to follow the new code, but I think the
        '  speed increase justifies it. <CC>
        desa_id = "Inconnu"


        xxx = nxtpcb()

        If (xxx And 128) Then GoTo ex_id128_255 Else GoTo ex_id0_127

ex_id0_127:
        If (xxx And 64) Then GoTo ex_id64_127 Else GoTo ex_id0_63

ex_id0_63:
        If (xxx And 32) Then GoTo ex_id32_63 Else GoTo ex_id0_31

ex_id0_31:
        Select Case xxx
            Case 0 To 8
                desa_id = " DEC  PC ?? (desa_id)"
            Case 9 ' ADD ID,BC
                desa_id = " ADD    " + RegID + ",BC"
            Case 10 To 24
                desa_id = " DEC  PC ?? (desa_id)"
            Case 25 ' ADD ID,DE
                desa_id = " ADD    " + RegID + ",DE"
            Case 26 To 31
                desa_id = " DEC  PC ?? (desa_id)"
            Case Else
                desa_id = "Inconnu"
        End Select
        GoTo execute_id_end

ex_id32_63:
        Select Case xxx
            Case 32
                desa_id = " DEC  PC ?? (desa_id)"
            Case 33 ' LD ID,nn
                desa_id = " LD    " + RegID + ","
                desa_id = desa_id + Caractere_hex4(nxtpcw())
            Case 34 ' LD (nn),ID
                desa_id = " LD    ("
                desa_id = desa_id + Caractere_hex4(nxtpcw()) + ")," + RegID + ""
            Case 35 ' INC ID
                desa_id = " INC   " + RegID + ""
            Case 36 ' INC IDH
                desa_id = " INC   " + RegID + "H"
            Case 37 ' DEC IDH
                desa_id = " DEC   " + RegID + "H"
            Case 38 ' LD IDH,n
                desa_id = " LD    " + RegID + "H,"
                desa_id = desa_id + Caractere_hex(nxtpcb())
            Case 39, 40
                desa_id = " DEC  PC ?? (desa_id)"
            Case 41 ' ADD ID,ID
                desa_id = " ADD   " + RegID + "," + RegID + ""
            Case 42 ' LD ID,(nn)
                desa_id = " LD    " + RegID + ",("
                desa_id = desa_id + Caractere_hex4(nxtpcw()) + ")"
            Case 43 ' DEC ID
                desa_id = " DEC   " + RegID + ""
            Case 44 ' INC IDL
                desa_id = " INC   " + RegID + "L"
            Case 45 ' DEC IDL
                desa_id = " DEC   " + RegID + "L"
            Case 46 ' LD IDL,n
                desa_id = " LD    " + RegID + "L,"
                desa_id = desa_id + Caractere_hex(nxtpcb())
            Case 47 To 51
                desa_id = " DEC  PC ?? (desa_id)"
            Case 52 ' INC (ID+d)
                desa_id = " INC   (" + RegID + " +" + desa_dpl() + ")"
            Case 53 ' DEC (" + regID + "+d)
                desa_id = " DEC   (" + RegID + " +" + desa_dpl() + ")"
            Case 54 ' LD (ID+d),n
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + "),"
                desa_id = desa_id + Caractere_hex(nxtpcb())
            Case 55, 56
                desa_id = " DEC  PC ?? (desa_id)" + desa_dpl()
            Case 57 ' ADD ID,SP
                desa_id = " LD    " + RegID + ",SP"
            Case 58 To 63
                desa_id = " DEC  PC ?? (desa_id)" + desa_dpl()
            Case Else
                desa_id = "Inconnu"
        End Select
        GoTo execute_id_end

ex_id64_127:
        Select Case xxx
            Case 64 To 67
                desa_id = " DEC  PC ?? (desa_id)" + desa_dpl()
            Case 68 ' LD B,IDH
                desa_id = " LD    B," + RegID + "H"
            Case 69 ' LD B,IDL
                desa_id = " LD    B," + RegID + "L"
            Case 70 ' LD B,(ID+d)
                desa_id = " LD    B,(" + RegID + " +" + desa_dpl() + ")"
            Case 71 To 75
                desa_id = " DEC  PC ?? (desa_id)" + desa_dpl()
            Case 76 ' LD C,IDH
                desa_id = " LD    C," + RegID + "H"
            Case 77 ' LD C,IDL
                desa_id = " LD    C," + RegID + "L"
            Case 78 ' LD C,(ID+d)
                desa_id = " LD    C,(" + RegID + " +" + desa_dpl() + ")"
            Case 79 To 83
                desa_id = " DEC  PC ?? (desa_id)" + desa_dpl()
            Case 84 ' LD D,IDH
                desa_id = " LD    D," + RegID + "H"
            Case 85 ' LD D,IDL
                desa_id = " LD    D," + RegID + "L"
            Case 86 ' LD D,(ID+d)
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + ")"
            Case 87 To 91
                desa_id = " DEC  PC ?? (desa_id)" + desa_dpl()
            Case 92 ' LD E,IDH
                desa_id = " LD    E," + RegID + "H"
            Case 93 ' LD E,IDL
                desa_id = " LD    E," + RegID + "L"
            Case 94 ' LD E,(ID+d)
                desa_id = " LD    E,(" + RegID + "L)"
            Case 95
                desa_id = " DEC  PC ?? (desa_id)" + desa_dpl()
            Case 96 ' LD IDH,B
                desa_id = " LD    " + RegID + "H,B"
            Case 97 ' LD IDH,C
                desa_id = " LD    " + RegID + "H,C"
            Case 98 ' LD IDH,D
                desa_id = " LD    " + RegID + "H,D"
            Case 99 ' LD IDH,E
                desa_id = " LD    " + RegID + "H,E"
            Case 100 ' LD IDH,IDH
                desa_id = " LD    " + RegID + "H," + RegID + "H"
            Case 101 ' LD IDH,IDL
                desa_id = " LD    " + RegID + "H," + RegID + "L"
            Case 102 ' LD H,(ID+d)
                desa_id = " LD    H,(" + RegID + " +" + desa_dpl() + ")"
            Case 103 ' LD IDH,A
                desa_id = " LD    " + RegID + "H,A"
            Case 104 ' LD IDL,B
                desa_id = " LD    " + RegID + "L,B"
            Case 105 ' LD IDL,C
                desa_id = " LD    " + RegID + "L,C"
            Case 106 ' LD IDL,D
                desa_id = " LD    " + RegID + "L,D"
            Case 107 ' LD IDL,E
                desa_id = " LD    " + RegID + "L,E"
            Case 108 ' LD IDL,IDH
                desa_id = " LD    " + RegID + "L," + RegID + "H"
            Case 109 ' LD IDL,IDL
                desa_id = " LD    " + RegID + "L," + RegID + "L"
            Case 110 ' LD L,(" + regID + "+d)
                desa_id = " LD    L,(" + RegID + " +" + desa_dpl() + ")"
            Case 111 ' LD IDL,A
                desa_id = " LD    " + RegID + "L,A"
            Case 112 ' LD (ID+d),B
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + "),B"
            Case 113 ' LD (ID+d),C
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + "),C"
            Case 114 ' LD (ID+d),D
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + "),D"
            Case 115 ' LD (ID+d),E
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + "),E"
            Case 116 ' LD (ID+d),H
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + "),H"
            Case 117 ' LD (ID+d),L
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + "),L"
            Case 118 ' UNKNOWN
                MsgBox("Unknown ID instruction " & xxx & " at " & regPC)
            Case 119 ' LD (ID+d),A
                desa_id = " LD    (" + RegID + " +" + desa_dpl() + "),A"
            Case 120 To 123
                desa_id = " DEC  PC ?? (desa_id)"
            Case 124 ' LD A,IDH
                desa_id = " LD    A," + RegID + "H"
            Case 125 ' LD A,IDL
                desa_id = " LD    A," + RegID + "L"
            Case 126 ' LD A,(ID+d)
                desa_id = " LD    A,(" + RegID + " +" + desa_dpl() + ")"
            Case 127
                desa_id = " DEC  PC ?? (desa_id)"
            Case Else
                desa_id = "Inconnu"
        End Select
        GoTo execute_id_end

ex_id128_255:
        If (xxx And 64) Then GoTo ex_id192_255 Else GoTo ex_id128_191

ex_id128_191:
        If (xxx And 32) Then GoTo ex_id160_191 Else GoTo ex_id128_159

ex_id128_159:
        Select Case xxx
            Case 128 To 131
                desa_id = " DEC  PC ?? (desa_id)"
            Case 132 ' ADD A,IDH
                desa_id = " ADD   A," + RegID + "H"
            Case 133 ' ADD A,IDL
                desa_id = " ADD   A," + RegID + "L"
            Case 134 ' ADD A,(ID+d)
                desa_id = " ADD   A,(" + RegID + " +" + desa_dpl() + ")"
            Case 135 To 139
                desa_id = " DEC  PC ?? (desa_id)"
            Case 140 ' ADC A,IDH
                desa_id = " ADC   A," + RegID + "H"
            Case 141 ' ADC A,IDL
                desa_id = " ADC   A," + RegID + "L"
            Case 142 ' ADC A,(ID+d)
                desa_id = " ADc   A,(" + RegID + " +" + desa_dpl() + ")"
            Case 143 To 147
                desa_id = " DEC  PC ?? (desa_id)"
            Case 148 ' SUB IDH
                desa_id = " SUB   " + RegID + "H"
            Case 149 ' SUB IDL
                desa_id = " SUB   " + RegID + "L"
            Case 150 ' SUB (ID+d)
                desa_id = " SUB   (" + RegID + " +" + desa_dpl() + ")"
            Case 151 To 155
                desa_id = " DEC  PC ?? (desa_id)"
            Case 156 ' SBC A,IDH
                desa_id = " SBC   A," + RegID + "H"
            Case 157 ' SBC A,IDL
                desa_id = " SBC   A," + RegID + "L"
            Case 158 ' SBC A,(ID+d)
                desa_id = " SBC   A,(" + RegID + " +" + desa_dpl() + ")"
            Case 159
                desa_id = " DEC  PC ?? (desa_id)"
            Case Else
                desa_id = "Inconnu"
        End Select
        GoTo execute_id_end

ex_id160_191:
        Select Case xxx
            Case 160 To 163
                desa_id = " DEC  PC ?? (desa_id)"
            Case 164 ' AND IDH
                desa_id = " AND   " + RegID + "H"
            Case 165 ' AND IDL
                desa_id = " AND   " + RegID + "L"
            Case 166 ' AND (ID+d)
                desa_id = " AND   (" + RegID + " +" + desa_dpl() + ")"
            Case 167 To 171
                desa_id = " DEC  PC ?? (desa_id)"
            Case 172 ' XOR IDH
                desa_id = " XOR   " + RegID + "H"
            Case 173 ' XOR IDL
                desa_id = " XOR   " + RegID + "L"
            Case 174 'XOR (ID+d)
                desa_id = " XOR   (" + RegID + " +" + desa_dpl() + ")"
            Case 175 To 179
                desa_id = " DEC  PC ?? (desa_id)"
            Case 180 ' OR IDH
                desa_id = " OR    " + RegID + "H"
            Case 181 ' OR IDL
                desa_id = " OR    " + RegID + "L"
            Case 182 ' OR (ID+d)
                desa_id = " OR    (" + RegID + " +" + desa_dpl() + ")"
            Case 183 To 187
                desa_id = " DEC  PC ?? (desa_id)"
            Case 188 ' CP IDH
                desa_id = " CP    " + RegID + "H"
            Case 189 ' CP IDL
                desa_id = " CP    " + RegID + "L"
            Case 190 ' CP (ID+d)
                desa_id = " CP    (" + RegID + " +" + desa_dpl() + ")"
            Case 191
                desa_id = " DEC  PC ?? (desa_id)"
            Case Else
                desa_id = "Inconnu"
        End Select
        GoTo execute_id_end

ex_id192_255:
        Select Case xxx
            Case 192 To 202
                desa_id = " DEC  PC ?? (desa_id)"
            Case 203 ' prefix CB
                Dim VAR As String
                desa_id = "oh"
                VAR = "(" & desa_id_d() & ")"

                op = nxtpcb()
                desa_id = Desa_id_cb(op, VAR)                'JJS                     'excution code CB avec ID
            Case 204 To 224
                desa_id = " DEC  PC ?? (desa_id)"
            Case 225 ' POP ID
                desa_id = " POP    " + RegID + ""
            Case 226
                desa_id = " DEC  PC ?? (desa_id)"
            Case 227 ' EX (SP),ID
                desa_id = " EX    (SP)," + RegID + ""
            Case 228
                desa_id = " DEC  PC ?? (desa_id)"
            Case 229 ' PUSH ID
                desa_id = " PUSH  " + RegID + ""
            Case 230 To 232
                desa_id = " DEC  PC ?? (desa_id)"
            Case 233 ' JP ID
                desa_id = " JP    " + RegID + ""
            Case 234 To 248
                desa_id = " DEC  PC ?? (desa_id)"
            Case 249 ' LD SP,ID
                desa_id = " LD    SP," + RegID + ""
            Case Else
                desa_id = "Inconnu"
        End Select
execute_id_end:
    End Function

    Private Function Fin_Desa(ByVal Code As Integer) As String
        Code = Code And 7
        Dim ASCII As String = ""
        Select Case Code
            Case 0
                ASCII = ",B"
                Exit Select
            Case 1
                ASCII = ",C"
                Exit Select
            Case 2
                ASCII = ",D"
                Exit Select
            Case 3
                ASCII = ",E"
                Exit Select
            Case 4
                ASCII = ",H"
                Exit Select
            Case 5
                ASCII = ",L"
                Exit Select
            Case 6
                ASCII = ""
                Exit Select
            Case 7
                ASCII = ",A"
                Exit Select
            Case Else
                ASCII = ""
        End Select
        Fin_Desa = ASCII
    End Function
    Private Function Desa_id_cb(ByVal op As Integer, ByVal Z As String) As String 'repris 2016

        Select Case op
            Case 0 To &H7 ' RLC 
                Desa_id_cb = " RLC    " & Z & Fin_Desa(op)

            Case 8 To &HF ' RRC 
                Desa_id_cb = " RRC    " & Z & Fin_Desa(op)

            Case &H10 To &H17 ' RL B
                Desa_id_cb = " RL     " & Z & Fin_Desa(op)

            Case &H18 To &H1F ' RR 
                Desa_id_cb = " RR     " & Z & Fin_Desa(op)

            Case &H20 To &H27 ' SLA 
                Desa_id_cb = " SLA    " & Z & Fin_Desa(op)

            Case &H28 To &H2F ' SRA 
                Desa_id_cb = " SRA    " & Z & Fin_Desa(op)

            Case &H30 To &H37 ' SLL 
                Desa_id_cb = " SLL    " & Z & Fin_Desa(op)

            Case &H38 To &H3F ' SRL 
                Desa_id_cb = " SRL    " & Z & Fin_Desa(op)

            Case &H40 To &H47 ' BIT 0,
                Desa_id_cb = " BIT    0," & Z & Fin_Desa(op)

            Case &H48 To &H4F ' BIT 1,
                Desa_id_cb = " BIT    1," & Z & Fin_Desa(op)

            Case &H50 To &H57 ' BIT 2,
                Desa_id_cb = " BIT    2," & Z & Fin_Desa(op)

            Case &H58 To &H5F ' BIT 3,
                Desa_id_cb = " BIT    3," & Z & Fin_Desa(op)

            Case &H60 To &H67 ' BIT 4,
                Desa_id_cb = " BIT    4," & Z & Fin_Desa(op)

            Case &H68 To &H6F ' BIT 5,
                Desa_id_cb = " BIT    5," & Z & Fin_Desa(op)

            Case &H70 To &H77 ' BIT 6,
                Desa_id_cb = " BIT    6," & Z & Fin_Desa(op)

            Case &H78 To &H7F ' BIT 7,B
                Desa_id_cb = " BIT    7," & Z & Fin_Desa(op)

            Case &H80 To &H87 ' RES 0,
                Desa_id_cb = " RES    0," & Z & Fin_Desa(op)

            Case &H88 To &H8F ' RES 1,
                Desa_id_cb = " RES    1," & Z & Fin_Desa(op)

            Case &H90 To &H97 ' RES 2,
                Desa_id_cb = " RES    2," & Z & Fin_Desa(op)
            Case &H98 To &H9F ' RES 3,xx
                Desa_id_cb = " RES    3," & Z & Fin_Desa(op)
            Case &HA0 To &HA7 ' RES 4,xx
                Desa_id_cb = " RES    4," & Z & Fin_Desa(op)
            Case &HA8 To &HAF ' RES 5,xx
                Desa_id_cb = " RES    5," & Z & Fin_Desa(op)
            Case &HB0 To &HB7 ' RES 6,xx
                Desa_id_cb = " RES    6," & Z & Fin_Desa(op)
            Case &HB8 To &HBF ' RES 7,xx
                Desa_id_cb = " RES    7," & Z & Fin_Desa(op)
            Case &HC0 To &HC7 ' SET 0,xx
                Desa_id_cb = " SET    0," & Z & Fin_Desa(op)
            Case &HC8 To &HCF ' SET 1,xx
                Desa_id_cb = " SET    1," & Z & Fin_Desa(op)
            Case &HD0 To &HD7 ' SET 2,xx
                Desa_id_cb = " SET    2," & Z & Fin_Desa(op)
            Case &HD8 To &HDF ' SET 3,xx
                Desa_id_cb = " SET    3," & Z & Fin_Desa(op)
            Case &HE0 To &HE7 ' SET 4,xx
                Desa_id_cb = " SET    4," & Z & Fin_Desa(op)
            Case &HE8 To &HEF ' SET 5,xx
                Desa_id_cb = " SET    5," & Z & Fin_Desa(op)
            Case &HF0 To &HF7 ' SET 6,xx
                Desa_id_cb = " SET    6," & Z & Fin_Desa(op)
            Case &HF8 To &HFF ' SET 7,xx
                Desa_id_cb = " SET    7," & Z & Fin_Desa(op)
            Case Else
                Desa_id_cb = " Aie code invalide"
        End Select
    End Function
    Private Function Desa_cb() As String
        Dim xxx As Integer

        '  Yes, I appreciate that GOTO's and labels are a hideous blashphemy!
        '  However, this code is the fastest possible way of fetching and handling
        '  Z80 instructions I could come up with. There are only 8 compares per
        '  instruction fetch rather than between 1 and 255 as required in
        '  the previous version of vb81 with it's huge Case statement.
        ' 
        '  I know it's slightly harder to follow the new code, but I think the
        '  speed increase justifies it. <CC>



        xxx = nxtpcb()

        If (xxx And 128) Then GoTo ex_cb128_255 Else GoTo ex_cb0_127

ex_cb0_127:
        If (xxx And 64) Then GoTo ex_cb64_127 Else GoTo ex_cb0_63

ex_cb0_63:
        If (xxx And 32) Then GoTo ex_cb32_63 Else GoTo ex_cb0_31

ex_cb0_31:
        If (xxx And 16) Then GoTo ex_cb16_31 Else GoTo ex_cb0_15

ex_cb0_15:
        If (xxx And 8) Then GoTo ex_cb8_15 Else GoTo ex_cb0_7

ex_cb0_7:
        If (xxx And 4) Then GoTo ex_cb4_7 Else GoTo ex_cb0_3

ex_cb0_3:
        If (xxx And 2) Then GoTo ex_cb2_3 Else GoTo ex_cb0_1

ex_cb0_1:
        If xxx = 0 Then
            ' 000 RLC B
            Desa_cb = " RLC    B"
        Else
            ' 001 RLC C
            Desa_cb = " RLC    C"
        End If
        Exit Function

ex_cb2_3:
        If xxx = 2 Then
            ' 002 RLC D
            Desa_cb = " RLC    D"
        Else
            ' 003 RLC E
            Desa_cb = " RLC    E"
        End If
        Exit Function

ex_cb4_7:
        If (xxx And 2) Then GoTo ex_cb6_7 Else GoTo ex_cb4_5

ex_cb4_5:
        If xxx = 4 Then
            ' 004 RLC H
            Desa_cb = " RLC    H"
        Else
            ' 005 RLC L
            Desa_cb = " RLC    L"
        End If
        Exit Function

ex_cb6_7:
        If xxx = 6 Then
            ' 006 RLC (HL)
            Desa_cb = " RLC    (HL)"
        Else
            ' 007 RLC A
            Desa_cb = " RLC    A"
        End If
        Exit Function

ex_cb8_15:
        If (xxx And 4) Then GoTo ex_cb12_15 Else GoTo ex_cb8_11

ex_cb8_11:
        If (xxx And 2) Then GoTo ex_cb10_11 Else GoTo ex_cb8_9

ex_cb8_9:
        If xxx = 8 Then
            ' 008 RRC B
            Desa_cb = " RRC    B"
        Else
            ' 009 RRC C
            Desa_cb = " RRC    C"
        End If
        Exit Function

ex_cb10_11:
        If xxx = 10 Then
            ' 010 RRC D
            Desa_cb = " RRC    D"
        Else
            ' 011 RRC E
            Desa_cb = " RRC    E"
        End If
        Exit Function

ex_cb12_15:
        If (xxx And 2) Then GoTo ex_cb14_15 Else GoTo ex_cb12_13

ex_cb12_13:
        If xxx = 12 Then
            ' 012 RRC H
            Desa_cb = " RRC    H"
        Else
            ' 013 RRC L
            Desa_cb = " RRC    L"
        End If
        Exit Function

ex_cb14_15:
        If xxx = 14 Then
            ' 014 RRC (HL)
            Desa_cb = " RRC    (HL)"
        Else
            ' 015 RRC A
            Desa_cb = " RRC    A"
        End If
        Exit Function

ex_cb16_31:
        If (xxx And 8) Then GoTo ex_cb24_31 Else GoTo ex_cb16_23

ex_cb16_23:
        If (xxx And 4) Then GoTo ex_cb20_23 Else GoTo ex_cb16_19

ex_cb16_19:
        If (xxx And 2) Then GoTo ex_cb18_19 Else GoTo ex_cb16_17

ex_cb16_17:
        If xxx = 16 Then
            ' 016 RL B
            Desa_cb = " RL     B"
        Else
            ' 017 RL C
            Desa_cb = " RL     C"
        End If
        Exit Function

ex_cb18_19:
        If xxx = 18 Then
            ' 018 RL D
            Desa_cb = " RL     D"
        Else
            ' 019 RL E
            Desa_cb = " RL     E"
        End If
        Exit Function

ex_cb20_23:
        If (xxx And 2) Then GoTo ex_cb22_23 Else GoTo ex_cb20_21

ex_cb20_21:
        If xxx = 20 Then
            ' 020 RL H
            Desa_cb = " RL     H"
        Else
            ' 021 RL L
            Desa_cb = " RL     L"
        End If
        Exit Function

ex_cb22_23:
        If xxx = 22 Then
            ' 022 RL (HL)
            Desa_cb = " RL     (HL)"
        Else
            ' 023 RL A
            Desa_cb = " RL     A"
        End If
        Exit Function

ex_cb24_31:
        If (xxx And 4) Then GoTo ex_cb28_31 Else GoTo ex_cb24_27

ex_cb24_27:
        If (xxx And 2) Then GoTo ex_cb26_27 Else GoTo ex_cb24_25

ex_cb24_25:
        If xxx = 24 Then
            ' 024 RR B
            Desa_cb = " RR     B"
        Else
            ' 025 RR C
            Desa_cb = " RR     C"
        End If
        Exit Function

ex_cb26_27:
        If xxx = 26 Then
            ' 026 RR D
            Desa_cb = " RR     D"
        Else
            ' 027 RR E
            Desa_cb = " RR     E"
        End If
        Exit Function

ex_cb28_31:
        If (xxx And 2) Then GoTo ex_cb30_31 Else GoTo ex_cb28_29

ex_cb28_29:
        If xxx = 28 Then
            ' 028 RR H
            Desa_cb = " RR     H"
        Else
            ' 029 RR L
            Desa_cb = " RR     L"
        End If
        Exit Function

ex_cb30_31:
        If xxx = 30 Then
            ' 030 RR (HL)
            Desa_cb = " RR     (HL)"
        Else
            ' 031 RR A
            Desa_cb = " RR     A"
        End If
        Exit Function

ex_cb32_63:
        Select Case xxx
            Case 32 ' SLA B
                Desa_cb = " SLA    B"
            Case 33 ' SLA C
                Desa_cb = " SLA    C"
            Case 34 ' SLA D
                Desa_cb = " SLA    D"
            Case 35 ' SLA E
                Desa_cb = " SLA    E"
            Case 36 ' SLA H
                Desa_cb = " SLA    H"
            Case 37 ' SLA L
                Desa_cb = " SLA    L"
            Case 38 ' SLA (HL)
                Desa_cb = " SLA    (HL)"
            Case 39 ' SLA A
                Desa_cb = " SLA    A"
            Case 40 ' SRA B
                Desa_cb = " SRA    B"
            Case 41 ' SRA C
                Desa_cb = " SRA    C"
            Case 42 ' SRA D
                Desa_cb = " SRA    D"
            Case 43 ' SRA E
                Desa_cb = " SRA    E"
            Case 44 ' SRA H
                Desa_cb = " SRA    H"
            Case 45  ' SRA L
                Desa_cb = " SRA    L"
            Case 46 ' SRA (HL)
                Desa_cb = " SRA    (HL)"
            Case 47 ' SRA A
                Desa_cb = " SRA    A"
            Case 48 ' SLS B
                Desa_cb = " SLS    B"
            Case 49 ' SLS C
                Desa_cb = " SLS    C"
            Case 50 ' SLS D
                Desa_cb = " SLS    D"
            Case 51 ' SLS E
                Desa_cb = " SLS    E"
            Case 52 ' SLS H
                Desa_cb = " SLS    H"
            Case 53 ' SLS L
                Desa_cb = " SLS    L"
            Case 54 ' SLS (HL)
                Desa_cb = " SLS    (HL)"
            Case 55 ' SLS A
                Desa_cb = " SLS    A"
            Case 56 ' SRL B
                Desa_cb = " SRL    B"
            Case 57 ' SRL C
                Desa_cb = " SRL    C"
            Case 58 ' SRL D
                Desa_cb = " SRL    D"
            Case 59 ' SRL E
                Desa_cb = " SRL    E"
            Case 60 ' SRL H
                Desa_cb = " SRL    H"
            Case 61 ' SRL L
                Desa_cb = " SRL    L"
            Case 62 ' SRL (HL)
                Desa_cb = " SRL    (HL)"
            Case 63 ' SRL A
                Desa_cb = " SRL    A"
            Case Else
                Desa_cb = " Aie..."
        End Select

        Exit Function

ex_cb64_127:
        If (xxx And 32) Then GoTo ex_cb96_127 Else GoTo ex_cb64_95

ex_cb64_95:
        If (xxx And 16) Then GoTo ex_cb80_95 Else GoTo ex_cb64_79

ex_cb64_79:
        If (xxx And 8) Then GoTo ex_cb72_79 Else GoTo ex_cb64_71

ex_cb64_71:
        If (xxx And 4) Then GoTo ex_cb68_71 Else GoTo ex_cb64_67

ex_cb64_67:
        If (xxx And 2) Then GoTo ex_cb66_67 Else GoTo ex_cb64_65

ex_cb64_65:
        If xxx = 64 Then
            ' 064 BIT 0,B
            Desa_cb = " BIT    0,B"
        Else
            ' 065 ' BIT 0,C
            Desa_cb = " BIT    0,C"
        End If
        Exit Function

ex_cb66_67:
        If xxx = 66 Then
            ' 066 BIT 0,D
            Desa_cb = " BIT    0,D"
        Else
            ' 067 BIT 0,E
            Desa_cb = " BIT    0,E"
        End If
        Exit Function

ex_cb68_71:
        If (xxx And 2) Then GoTo ex_cb70_71 Else GoTo ex_cb68_69

ex_cb68_69:
        If xxx = 68 Then
            ' 068 BIT 0,H
            Desa_cb = " BIT    0,H"
        Else
            ' 069 BIT 0,L
            Desa_cb = " BIT    0,L"
        End If
        Exit Function

ex_cb70_71:
        If xxx = 70 Then
            ' 070 BIT 0,(HL)
            Desa_cb = " BIT    0,(HL)"
        Else
            ' 071 BIT 0,A
            Desa_cb = " BIT    0,A"
        End If
        Exit Function

ex_cb72_79:
        Select Case xxx
            Case 72 ' BIT 1,B
                Desa_cb = " BIT    1,B"
            Case 73 ' BIT 1,C
                Desa_cb = " BIT    1,C"
            Case 74 ' BIT 1,D
                Desa_cb = " BIT    1,D"
            Case 75 ' BIT 1,E
                Desa_cb = " BIT    1,E"
            Case 76 ' BIT 1,H
                Desa_cb = " BIT    1,H"
            Case 77 ' BIT 1,L
                Desa_cb = " BIT    1,L"
            Case 78 ' BIT 1,(HL)
                Desa_cb = " BIT    1,(HL)"
            Case 79 ' BIT 1,A
                Desa_cb = " BIT    1,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb80_95:
        Select Case xxx
            Case 80 ' BIT 2,B
                Desa_cb = " BIT    2,B"
            Case 81 ' BIT 2,C
                Desa_cb = " BIT    2,C"
            Case 82 ' BIT 2,D
                Desa_cb = " BIT    2,D"
            Case 83 ' BIT 2,E
                Desa_cb = " BIT    2,E"
            Case 84 ' BIT 2,H
                Desa_cb = " BIT    2,H"
            Case 85 ' BIT 2,L
                Desa_cb = " BIT    2,L"
            Case 86 ' BIT 2,(HL)
                Desa_cb = " BIT    2,(HL)"
            Case 87 ' BIT 2,A
                Desa_cb = " BIT    2,A"
            Case 88 ' BIT 3,B
                Desa_cb = " BIT    3,B"
            Case 89 ' BIT 3,C
                Desa_cb = " BIT    3,C"
            Case 90 ' BIT 3,D
                Desa_cb = " BIT    3,D"
            Case 91 ' BIT 3,E
                Desa_cb = " BIT    3,E"
            Case 92 ' BIT 3,H
                Desa_cb = " BIT    3,H"
            Case 93 ' BIT 3,L
                Desa_cb = " BIT    3,L"
            Case 94 ' BIT 3,(HL)
                Desa_cb = " BIT    3,(HL)"
            Case 95 ' BIT 3,A
                Desa_cb = " BIT    3,A"
            Case Else
                Desa_cb = " Aie..."
        End Select

        Exit Function

ex_cb96_127:
        If (xxx And 16) Then GoTo ex_cb112_127 Else GoTo ex_cb96_111

ex_cb96_111:
        If (xxx And 8) Then GoTo ex_cb104_111 Else GoTo ex_cb96_103

ex_cb96_103:
        Select Case xxx
            Case 96 ' BIT 4,B
                Desa_cb = " BIT    4,B"
            Case 97 ' BIT 4,C
                Desa_cb = " BIT    4,C"
            Case 98 ' BIT 4,D
                Desa_cb = " BIT    4,D"
            Case 99 ' BIT 4,E
                Desa_cb = " BIT    4,E"
            Case 100 ' BIT 4,H
                Desa_cb = " BIT    4,H"
            Case 101 ' BIT 4,L
                Desa_cb = " BIT    4,L"
            Case 102 ' BIT 4,(HL)
                Desa_cb = " BIT    4,(HL)"
            Case 103 ' BIT 4,A
                Desa_cb = " BIT    4,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb104_111:
        Select Case xxx
            Case 104 ' BIT 5,B
                Desa_cb = " BIT    5,B"
            Case 105 ' BIT 5,C
                Desa_cb = " BIT    5,C"
            Case 106 ' BIT 5,D
                Desa_cb = " BIT    5,D"
            Case 107 ' BIT 5,E
                Desa_cb = " BIT    5,E"
            Case 108 ' BIT 5,H
                Desa_cb = " BIT    5,H"
            Case 109 ' BIT 5,L
                Desa_cb = " BIT    5,L"
            Case 110 ' BIT 5,(HL)
                Desa_cb = " BIT    5,(HL)"
            Case 111 ' BIT 5,A
                Desa_cb = " BIT    5,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb112_127:
        If (xxx And 8) Then GoTo ex_cb120_127 Else GoTo ex_cb112_119

ex_cb112_119:
        If (xxx And 4) Then GoTo ex_cb116_119 Else GoTo ex_cb112_115

ex_cb112_115:
        If (xxx And 2) Then GoTo ex_cb114_115 Else GoTo ex_cb112_113

ex_cb112_113:
        If xxx = 112 Then
            ' 112 BIT 6,B
            Desa_cb = " BIT    6,B"
        Else
            ' 113 BIT 6,C
            Desa_cb = " BIT    6,C"
        End If
        Exit Function

ex_cb114_115:
        If xxx = 114 Then
            ' 114 BIT 6,D
            Desa_cb = " BIT    6,D"
        Else
            ' 115 BIT 6,E
            Desa_cb = " BIT    6,E"
        End If
        Exit Function

ex_cb116_119:
        If (xxx And 2) Then GoTo ex_cb118_119 Else GoTo ex_cb116_117

ex_cb116_117:
        If xxx = 116 Then
            ' 116 BIT 6,H
            Desa_cb = " BIT    6,H"
        Else
            ' 117 BIT 6,L
            Desa_cb = " BIT    6,L"
        End If
        Exit Function

ex_cb118_119:
        If xxx = 118 Then
            ' 118 BIT 6,(HL)
            Desa_cb = " BIT    6,(HL)"
        Else
            ' 119 ' BIT 6,A
            Desa_cb = " BIT    6,A"
        End If
        Exit Function

ex_cb120_127:
        If (xxx And 4) Then GoTo ex_cb124_127 Else GoTo ex_cb120_123

ex_cb120_123:
        If (xxx And 2) Then GoTo ex_cb122_123 Else GoTo ex_cb120_121

ex_cb120_121:
        If xxx = 120 Then
            ' 120 BIT 7,B
            Desa_cb = " BIT    7,B"
        Else
            ' 121 BIT 7,C
            Desa_cb = " BIT    7,C"
        End If
        Exit Function

ex_cb122_123:
        If xxx = 122 Then
            ' 122 BIT 7,D
            Desa_cb = " BIT    7,D"
        Else
            ' 123 BIT 7,E
            Desa_cb = " BIT    7,E"
        End If
        Exit Function

ex_cb124_127:
        If (xxx And 2) Then GoTo ex_cb126_127 Else GoTo ex_cb124_125

ex_cb124_125:
        If xxx = 124 Then
            ' 124 BIT 7,H
            Desa_cb = " BIT    7,H"
        Else
            ' 125 BIT 7,L
            Desa_cb = " BIT    7,L"
        End If
        Exit Function

ex_cb126_127:
        If xxx = 126 Then
            ' 126 BIT 7,(HL)
            Desa_cb = " BIT    7,(HL)"
        Else
            ' 127 BIT 7,A
            Desa_cb = " BIT    7,A"
        End If
        Exit Function

ex_cb128_255:
        If (xxx And 64) Then GoTo ex_cb192_255 Else GoTo ex_cb128_191

ex_cb128_191:
        If (xxx And 32) Then GoTo ex_cb160_191 Else GoTo ex_cb128_159

ex_cb128_159:
        If (xxx And 16) Then GoTo ex_cb144_159 Else GoTo ex_cb128_143

ex_cb128_143:
        Select Case xxx
            Case 128 ' RES 0,B
                Desa_cb = " RES    0,B"
            Case 129 ' RES 0,C
                Desa_cb = " RES    0,C"
            Case 130 ' RES 0,D
                Desa_cb = " RES    0,D"
            Case 131 ' RES 0,E
                Desa_cb = " RES    0,E"
            Case 132 ' RES 0,H
                Desa_cb = " RES    0,H"
            Case 133 ' RES 0,L
                Desa_cb = " RES    0,L"
            Case 134 ' RES 0,(HL)
                Desa_cb = " RES    0,(HL)"
            Case 135 ' RES 0,A
                Desa_cb = " RES    0,A"
            Case 136 ' RES 1,B
                Desa_cb = " RES    1,B"
            Case 137 ' RES 1,C
                Desa_cb = " RES    1,C"
            Case 138 ' RES 1,D
                Desa_cb = " RES    1,D"
            Case 139 ' RES 1,E
                Desa_cb = " RES    1,E"
            Case 140 ' RES 1,H
                Desa_cb = " RES    1,H"
            Case 141 ' RES 1,L
                Desa_cb = " RES    1,L"
            Case 142 ' RES 1,(HL)
                Desa_cb = " RES    1,(HL)"
            Case 143 ' RES 1,A
                Desa_cb = " RES    1,A"
            Case Else
                Desa_cb = " Aie..."
        End Select

        Exit Function

ex_cb144_159:
        Select Case xxx
            Case 144 ' RES 2,B
                Desa_cb = " RES    2,B"
            Case 145 ' RES 2,C
                Desa_cb = " RES    2,C"
            Case 146 ' RES 2,D
                Desa_cb = " RES    2,D"
            Case 147 ' RES 2,E
                Desa_cb = " RES    2,E"
            Case 148 ' RES 2,H
                Desa_cb = " RES    2,H"
            Case 149 ' RES 2,L
                Desa_cb = " RES    2,L"
            Case 150 ' RES 2,(HL)
                Desa_cb = " RES    2,(HL)"
            Case 151 ' RES 2,A
                Desa_cb = " RES    2,A"
            Case 152 ' RES 3,B
                Desa_cb = " RES    3,B"
            Case 153 ' RES 3,C
                Desa_cb = " RES    3,C"
            Case 154 ' RES 3,D
                Desa_cb = " RES    3,D"
            Case 155 ' RES 3,E
                Desa_cb = " RES    3,E"
            Case 156 ' RES 3,H
                Desa_cb = " RES    3,H"
            Case 157 ' RES 3,L
                Desa_cb = " RES    3,L"
            Case 158 ' RES 3,(HL)
                Desa_cb = " RES    3,(HL)"
            Case 159 ' RES 3,A
                Desa_cb = " RES    3,A"
            Case Else
                Desa_cb = " Aie..."
        End Select

        Exit Function

ex_cb160_191:
        If (xxx And 16) Then GoTo ex_cb176_191 Else GoTo ex_cb160_175

ex_cb160_175:
        If (xxx And 8) Then GoTo ex_cb168_175 Else GoTo ex_cb160_167

ex_cb160_167:
        Select Case xxx
            Case 160 ' RES 4,B
                Desa_cb = " RES    4,B"
            Case 161 ' RES 4,C
                Desa_cb = " RES    4,C"
            Case 162 ' RES 4,D
                Desa_cb = " RES    4,D"
            Case 163 ' RES 4,E
                Desa_cb = " RES    4,E"
            Case 164 ' RES 4,H
                Desa_cb = " RES    4,H"
            Case 165 ' RES 4,L
                Desa_cb = " RES    4,L"
            Case 166 ' RES 4,(HL)
                Desa_cb = " RES    4,(HL)"
            Case 167 ' RES 4,A
                Desa_cb = " RES    4,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb168_175:
        If (xxx And 4) Then GoTo ex_cb172_175 Else GoTo ex_cb168_171

ex_cb168_171:
        If (xxx And 2) Then GoTo ex_cb170_171 Else GoTo ex_cb168_169

ex_cb168_169:
        If xxx = 168 Then
            ' 168 RES 5,B
            Desa_cb = " RES    5,B"
        Else
            ' 169 RES 5,C
            Desa_cb = " RES    5,C"
        End If
        Exit Function

ex_cb170_171:
        If xxx = 170 Then
            ' 170 RES 5,D
            Desa_cb = " RES    5,D"
        Else
            ' 171 RES 5,E
            Desa_cb = " RES    5,E"
        End If
        Exit Function

ex_cb172_175:
        Select Case xxx
            Case 172 ' RES 5,H
                Desa_cb = " RES    5,H"
            Case 173 ' RES 5,L
                Desa_cb = " RES    5,L"
            Case 174 ' RES 5,(HL)
                Desa_cb = " RES    5,(HL)"
            Case 175 ' RES 5,A
                Desa_cb = " RES    5,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb176_191:
        Select Case xxx
            Case 176 ' RES 6,B
                Desa_cb = " RES    6,B"
            Case 177 ' RES 6,C
                Desa_cb = " RES    6,C"
            Case 178 ' RES 6,D
                Desa_cb = " RES    6,D"
            Case 179 ' RES 6,E
                Desa_cb = " RES    6,E"
            Case 180 ' RES 6,H
                Desa_cb = " RES    6,H"
            Case 181 ' RES 6,L
                Desa_cb = " RES    6,L"
            Case 182 ' RES 6,(HL)
                Desa_cb = " RES    6,(HL)"
            Case 183 ' RES 6,A
                Desa_cb = " RES    6,A"
            Case 184 ' RES 7,B
                Desa_cb = " RES    7,B"
            Case 185 ' RES 7,C
                Desa_cb = " RES    7,C"
            Case 186 ' RES 7,D
                Desa_cb = " RES    7,D"
            Case 187 ' RES 7,E
                Desa_cb = " RES    7,E"
            Case 188 ' RES 7,H
                Desa_cb = " RES    7,H"
            Case 189 ' RES 7,L
                Desa_cb = " RES    7,L"
            Case 190 ' RES 7,(HL)
                Desa_cb = " RES    7,(HL)"
            Case 191 ' RES 7,A
                Desa_cb = " RES    7,A"
            Case Else
                Desa_cb = " Aie"
        End Select

        Exit Function

ex_cb192_255:
        If (xxx And 32) Then GoTo ex_cb224_255 Else GoTo ex_cb192_223

ex_cb192_223:
        If (xxx And 16) Then GoTo ex_cb208_223 Else GoTo ex_cb192_207

ex_cb192_207:
        If (xxx And 8) Then GoTo ex_cb200_207 Else GoTo ex_cb192_199

ex_cb192_199:
        Select Case xxx
            Case 192 ' SET 0,B
                Desa_cb = " SET    0,B"
            Case 193 ' SET 0,C
                Desa_cb = " SET    0,C"
            Case 194 ' SET 0,D
                Desa_cb = " SET    0,D"
            Case 195 ' SET 0,E
                Desa_cb = " SET    0,E"
            Case 196 ' SET 0,H
                Desa_cb = " SET    0,H"
            Case 197 ' SET 0,L
                Desa_cb = " SET    0,L"
            Case 198 ' SET 0,(HL)
                Desa_cb = " SET    0,(HL)"
            Case 199 ' SET 0,A
                Desa_cb = " SET    0,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb200_207:
        Select Case xxx
            Case 200 ' SET 1,B
                Desa_cb = " SET    1,B"
            Case 201 ' SET 1,C
                Desa_cb = " SET    1,C"
            Case 202 ' SET 1,D
                Desa_cb = " SET    1,D"
            Case 203 ' SET 1,E
                Desa_cb = " SET    1,E"
            Case 204 ' SET 1,H
                Desa_cb = " SET    1,H"
            Case 205 ' SET 1,L
                Desa_cb = " SET    1,L"
            Case 206 ' SET 1,(HL)
                Desa_cb = " SET    1,(HL)"
            Case 207 ' SET 1,A
                Desa_cb = " SET    1,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb208_223:
        Select Case xxx
            Case 208 ' SET 2,B
                Desa_cb = " SET    2,B"
            Case 209 ' SET 2,C
                Desa_cb = " SET    2,C"
            Case 210 ' SET 2,D
                Desa_cb = " SET    2,D"
            Case 211 ' SET 2,E
                Desa_cb = " SET    2,E"
            Case 212 ' SET 2,H
                Desa_cb = " SET    2,H"
            Case 213 ' SET 2,L
                Desa_cb = " SET    2,L"
            Case 214 ' SET 2,(HL)
                Desa_cb = " SET    2,(HL)"
            Case 215 ' SET 2,A
                Desa_cb = " SET    2,A"
            Case 216 ' SET 3,B
                Desa_cb = " SET    3,B"
            Case 217 ' SET 3,C
                Desa_cb = " SET    3,C"
            Case 218 ' SET 3,D
                Desa_cb = " SET    3,D"
            Case 219 ' SET 3,E
                Desa_cb = " SET    3,E"
            Case 220 ' SET 3,H
                Desa_cb = " SET    3,H"
            Case 221 ' SET 3,L
                Desa_cb = " SET    3,L"
            Case 222 ' SET 3,(HL)
                Desa_cb = " SET    3,(HL)"
            Case 223 ' SET 3,A
                Desa_cb = " SET    3,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb224_255:
        If (xxx And 16) Then GoTo ex_cb240_255 Else GoTo ex_cb224_239

ex_cb224_239:
        Select Case xxx
            Case 224 ' SET 4,B
                Desa_cb = " SET    4,B"
            Case 225 ' SET 4,C
                Desa_cb = " SET    4,C"
            Case 226 ' SET 4,D
                Desa_cb = " SET    4,D"
            Case 227 ' SET 4,E
                Desa_cb = " SET    4,E"
            Case 228 ' SET 4,H
                Desa_cb = " SET    4,H"
            Case 229 ' SET 4,L
                Desa_cb = " SET    4,L"
            Case 230 ' SET 4,(HL)
                Desa_cb = " SET    4,(HL)"
            Case 231 ' SET 4,A
                Desa_cb = " SET    4,A"
            Case 232 ' SET 5,B
                Desa_cb = " SET    5,B"
            Case 233 ' SET 5,C
                Desa_cb = " SET    5,C"
            Case 234 ' SET 5,D
                Desa_cb = " SET    5,D"
            Case 235 ' SET 5,E
                Desa_cb = " SET    5,E"
            Case 236 ' SET 5,H
                Desa_cb = " SET    5,H"
            Case 237 ' SET 5,L
                Desa_cb = " SET    5,L"
            Case 238 ' SET 5,(HL)
                Desa_cb = " SET    5,(HL)"
            Case 239 ' SET 5,A
                Desa_cb = " SET    5,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb240_255:
        If (xxx And 8) Then GoTo ex_cb248_255 Else GoTo ex_cb240_247

ex_cb240_247:
        Select Case xxx
            Case 240 ' SET 6,B
                Desa_cb = " SET    6,B"
            Case 241 ' SET 6,C
                Desa_cb = " SET    6,C"
            Case 242 ' SET 6,D
                Desa_cb = " SET    6,D"
            Case 243 ' SET 6,E
                Desa_cb = " SET    6,E"
            Case 244 ' SET 6,H
                Desa_cb = " SET    6,H"
            Case 245 ' SET 6,L
                Desa_cb = " SET    6,L"
            Case 246 ' SET 6,(HL)
                Desa_cb = " SET    6,(HL)"
            Case 247 ' SET 6,A
                Desa_cb = " SET    6,A"
            Case Else
                Desa_cb = " Aie..."
        End Select
        Exit Function

ex_cb248_255:
        If (xxx And 4) Then GoTo ex_cb252_255 Else GoTo ex_cb248_251

ex_cb248_251:
        Select Case xxx
            Case 248 ' SET 7,B
                Desa_cb = " SET    7,B"
            Case 249 ' SET 7,C
                Desa_cb = " SET    7,C"
            Case 250 ' SET 7,D
                Desa_cb = " SET    7,D"
            Case 251 ' SET 7,E
                Desa_cb = " SET    7,E"
            Case Else
                Desa_cb = " Aie"
        End Select
        Exit Function

ex_cb252_255:
        If (xxx And 2) Then GoTo ex_cb254_255 Else GoTo ex_cb252_253

ex_cb252_253:
        If xxx = 252 Then
            ' 252 SET 7,H
            Desa_cb = " SET    7,H"
        Else
            ' 253 SET 7,L
            Desa_cb = " SET    7,L"
        End If
        Exit Function

ex_cb254_255:
        If xxx = 254 Then
            ' 254 SET 7,(HL)
            Desa_cb = " SET    7,(HL)"
        Else
            ' 255 SET 7,A
            Desa_cb = " SET    7,A"
        End If
    End Function
    Public Function desa_Z80() As String

        Dim xxx As Integer
        '  Yes, I appreciate that GOTO's and labels are a hideous blashphemy!
        '  However, this code is the fastest possible way of fetching and handling
        '  Z80 instructions I could come up with. There are only 8 compares per
        '  instruction fetch rather than between 1 and 255 as required in
        '  the previous version of vb81 with it's huge Case statement.
        ' 
        '  I know it's slightly harder to follow the new code, but I think the
        '  speed increase justifies it. <CC>




        ' ******************************************************************************
        ' Instruction du Z80
        ' ******************************************************************************

        xxx = nxtpcb()

        If (xxx And 128) Then GoTo ex128_255 Else GoTo ex0_127
ex0_127:
        If (xxx And 64) Then GoTo ex64_127 Else GoTo ex0_63
ex0_63:
        If (xxx And 32) Then GoTo ex32_63 Else GoTo ex0_31
ex0_31:
        If (xxx And 16) Then GoTo ex16_31 Else GoTo ex0_15
ex0_15:
        If (xxx And 8) Then GoTo ex8_15 Else GoTo ex0_7

ex0_7:
        If (xxx And 4) Then GoTo ex4_7 Else GoTo ex0_3

ex0_3:
        If (xxx And 2) Then GoTo ex2_3 Else GoTo ex0_1

ex0_1:
        If xxx = 0 Then
            ' 000 NOP
            desa_Z80 = " NOP"
        Else
            ' 001 LD BC,nn
            desa_Z80 = " LD    BC,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        End If
        Exit Function

ex2_3:
        If xxx = 2 Then
            ' 002 LD (BC),A
            desa_Z80 = " LD    (BC),A"

        Else
            ' 003 INC BC
            desa_Z80 = " INC   BC"
        End If
        Exit Function

ex4_7:
        If (xxx And 2) Then GoTo ex6_7 Else GoTo ex4_5

ex4_5:
        If xxx = 4 Then
            ' 004 INC B
            desa_Z80 = " INC    B"
        Else
            ' 005 DEC B
            desa_Z80 = " DEC    B"
        End If
        Exit Function

ex6_7:
        If xxx = 6 Then
            ' 006 LD B,n
            desa_Z80 = " LD    B,"
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 007 RLCA
            desa_Z80 = " RCL   B,"
        End If
        Exit Function

ex8_15:
        If (xxx And 4) Then GoTo ex12_15 Else GoTo ex8_11

ex8_11:
        If (xxx And 2) Then GoTo ex10_11 Else GoTo ex8_9

ex8_9:
        If xxx = 8 Then
            ' 008 EX AF,AF'
            desa_Z80 = " EX    AF,AF',"
        Else
            '009 ADD HL,BC
            desa_Z80 = " ADD   HL,BC"
        End If
        Exit Function

ex10_11:
        If xxx = 10 Then
            ' 010 LD A,(BC)
            desa_Z80 = " LD    A,(BC)"
        Else
            ' 011 DEC BC
            desa_Z80 = " DEC   BC"
        End If
        Exit Function

ex12_15:
        If (xxx And 2) Then GoTo ex14_15 Else GoTo ex12_13

ex12_13:
        If xxx = 12 Then
            ' 012 INC C
            desa_Z80 = " INC   C"
        Else
            ' 013 DEC C
            desa_Z80 = " DEC   C"
        End If
        Exit Function

ex14_15:
        If xxx = 14 Then
            ' 014 LD C,n
            desa_Z80 = " LD    C,"
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 015 RRCA
            desa_Z80 = " RRCA  "
        End If
        Exit Function

ex16_31:
        If (xxx And 8) Then GoTo ex24_31 Else GoTo ex16_23

ex16_23:
        If (xxx And 4) Then GoTo ex20_23 Else GoTo ex16_19

ex16_19:
        If (xxx And 2) Then GoTo ex18_19 Else GoTo ex16_17

ex16_17:
        If xxx = 16 Then
            ' 016 DJNZ dis
            desa_Z80 = " DJNZ  "
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 017 LD DE,nn
            desa_Z80 = " LD    DE,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        End If
        Exit Function

ex18_19:
        If xxx = 18 Then
            ' 018 LD (DE),A
            desa_Z80 = " LD    (DE),A"
        Else
            ' 019 INC DE
            desa_Z80 = " INC   DE"
        End If
        Exit Function

ex20_23:
        If (xxx And 2) Then GoTo ex22_23 Else GoTo ex20_21

ex20_21:
        If xxx = 20 Then
            ' 020 INC D
            desa_Z80 = " INC   D"
        Else
            ' 021 DEC D
            desa_Z80 = " DEC   D"
        End If
        Exit Function

ex22_23:
        If xxx = 22 Then
            ' 022 LD D,n
            desa_Z80 = " LD    D,"
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 023 ' RLA
            desa_Z80 = " RLA     "
        End If
        Exit Function

ex24_31:
        If (xxx And 4) Then GoTo ex28_31 Else GoTo ex24_27

ex24_27:
        If (xxx And 2) Then GoTo ex26_27 Else GoTo ex24_25

ex24_25:
        If xxx = 24 Then
            ' 024 JR dis
            desa_Z80 = " JR    "
            Dim ADDr As Integer
            ADDr = nxtpcb()
            If ADDr > &H7F Then
                ADDr = ADDr - 256
            End If

            desa_Z80 = desa_Z80 & Caractere_hex(ADDr) & " (" & Caractere_hex4(regPC + ADDr) & ")"
        Else
            ' 025 ADD HL,DE
            desa_Z80 = " ADD   HL,DE"
        End If
        Exit Function

ex26_27:
        If xxx = 26 Then
            ' 026 LD A,(DE)
            desa_Z80 = " LD    A,(DE)"
        Else
            ' 027 DEC DE
            desa_Z80 = " DEC   DE"
        End If
        Exit Function

ex28_31:
        If (xxx And 2) Then GoTo ex30_31 Else GoTo ex28_29

ex28_29:
        If xxx = 28 Then
            ' 028 INC E
            desa_Z80 = " INC   C"
        Else
            ' 029 DEC E
            desa_Z80 = " DEC   E"
        End If
        Exit Function

ex30_31:
        If xxx = 30 Then
            ' 030 LD E,n
            desa_Z80 = " LD    E,"
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 031 RRA
            desa_Z80 = " RRA   "
        End If
        Exit Function

ex32_63:
        If (xxx And 16) Then GoTo ex48_63 Else GoTo ex32_47

ex32_47:
        If (xxx And 8) Then GoTo ex40_47 Else GoTo ex32_39

ex32_39:
        If (xxx And 4) Then GoTo ex36_39 Else GoTo ex32_35

ex32_35:
        If (xxx And 2) Then GoTo ex34_35 Else GoTo ex32_33

ex32_33:
        If xxx = 32 Then
            ' 032 JR NZ dis
            desa_Z80 = " JR    NZ,"
            Dim ADDr As Integer
            ADDr = nxtpcb()
            If ADDr > &H7F Then
                ADDr = ADDr - 256
            End If
            desa_Z80 = desa_Z80 & Caractere_hex(ADDr) & " (" & Caractere_hex4(regPC + ADDr) & ")"
        Else
            ' 033 LD HL,nn
            desa_Z80 = " LD    HL,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        End If
        Exit Function

ex34_35:
        If xxx = 34 Then
            ' 034 LD (nn),HL
            desa_Z80 = " LD    ("
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw()) + "),HL"
        Else
            ' 035 INC HL
            desa_Z80 = " INC   HL"
        End If
        Exit Function

ex36_39:
        If (xxx And 2) Then GoTo ex38_39 Else GoTo ex36_37

ex36_37:
        If xxx = 36 Then
            ' 036 INC H
            desa_Z80 = " INC   H"
        Else
            ' 037 DEC H
            desa_Z80 = " DEC   H"
        End If
        Exit Function

ex38_39:
        If xxx = 38 Then
            ' 038 LD H,n
            desa_Z80 = " LD    H,"
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 039 DAA
            desa_Z80 = " DAA     "
        End If
        Exit Function

ex40_47:
        If (xxx And 4) Then GoTo ex44_47 Else GoTo ex40_43

ex40_43:
        If (xxx And 2) Then GoTo ex42_43 Else GoTo ex40_41

ex40_41:
        If xxx = 40 Then
            ' 040 JR Z dis
            desa_Z80 = " JR    Z,"
            Dim ADDr As Integer
            ADDr = nxtpcb()
            If ADDr > &H7F Then
                ADDr = ADDr - 256
            End If
            desa_Z80 = desa_Z80 & Caractere_hex(ADDr) & " (" & Caractere_hex4(regPC + ADDr) & ")"
        Else
            ' 041 ADD HL,HL
            desa_Z80 = " ADD   HL,HL"
        End If
        Exit Function

ex42_43:
        If xxx = 42 Then
            ' 042 LD HL,(nn)
            desa_Z80 = " LD    HL,("
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw()) + ")"
        Else
            ' 043 DEC HL
            desa_Z80 = " DEC   HL"
        End If
        Exit Function

ex44_47:
        If (xxx And 2) Then GoTo ex46_47 Else GoTo ex44_45

ex44_45:
        If xxx = 44 Then
            ' 044 INC L
            desa_Z80 = " INC   L"
        Else
            ' 045 DEC L
            desa_Z80 = " DEC   L"
        End If
        Exit Function

ex46_47:
        If xxx = 46 Then
            ' 046 LD L,n
            desa_Z80 = " LD    L,"
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 047 CPL
            desa_Z80 = " CPL     "
        End If
        Exit Function

ex48_63:
        If (xxx And 8) Then GoTo ex56_63 Else GoTo ex48_55

ex48_55:
        If (xxx And 4) Then GoTo ex52_55 Else GoTo ex48_51

ex48_51:
        If (xxx And 2) Then GoTo ex50_51 Else GoTo ex48_49

ex48_49:
        If xxx = 48 Then
            ' 048 JR NC dis
            desa_Z80 = " JR    NC,"
            Dim ADDr As Integer
            ADDr = nxtpcb()
            If ADDr > &H7F Then
                ADDr = ADDr - 256
            End If
            desa_Z80 = desa_Z80 & Caractere_hex(ADDr) & " (" & Caractere_hex4(regPC + ADDr) & ")"
        Else
            ' 049 LD SP,nn
            desa_Z80 = " LD    SP,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        End If
        Exit Function

ex50_51:
        If xxx = 50 Then
            ' 050 LD (nn),A
            desa_Z80 = " LD    ("
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw()) + "),A"
        Else
            ' 051 INC SP
            desa_Z80 = " INC   SP"
        End If
        Exit Function

ex52_55:
        If (xxx And 2) Then GoTo ex54_55 Else GoTo ex52_53

ex52_53:
        If xxx = 52 Then
            ' 052 INC (HL)
            desa_Z80 = " INC   (HL)"
        Else
            ' 053 DEC (HL)
            desa_Z80 = " DEC   (HL)"
        End If
        Exit Function

ex54_55:
        If xxx = 54 Then
            ' 054 LD (HL),n
            desa_Z80 = " LD    (HL),"
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 055 SCF
            desa_Z80 = " SCF     "
        End If
        Exit Function

ex56_63:
        If (xxx And 4) Then GoTo ex60_63 Else GoTo ex56_59

ex56_59:
        If (xxx And 2) Then GoTo ex58_59 Else GoTo ex56_57

ex56_57:
        If xxx = 56 Then
            ' 056 JR C dis
            desa_Z80 = " JR    C,"
            Dim ADDr As Integer
            ADDr = nxtpcb()
            If ADDr > &H7F Then
                ADDr = ADDr - 256
            End If
            desa_Z80 = desa_Z80 & Caractere_hex(ADDr) & " (" & Caractere_hex4(regPC + ADDr) & ")"
        Else
            ' 057 ADD HL,SP
            desa_Z80 = " ADD   HL,SP"
        End If
        Exit Function

ex58_59:
        If xxx = 58 Then
            ' 058 LD A,(nn)
            desa_Z80 = " LD    A,("
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw()) + ")"
        Else
            ' 059 DEC SP
            desa_Z80 = " DEC   SP"
        End If
        Exit Function

ex60_63:
        If (xxx And 2) Then GoTo ex62_63 Else GoTo ex60_61

ex60_61:
        If xxx = 60 Then
            ' 060 INC A
            desa_Z80 = " INC   A"
        Else
            ' 061 DEC A
            desa_Z80 = " DEC   A"
        End If
        Exit Function

ex62_63:
        If xxx = 62 Then
            ' 062 LD A,n
            desa_Z80 = " LD    A,"
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 063 CCF
            desa_Z80 = " CCF     "
        End If
        Exit Function

ex64_127:
        If (xxx And 32) Then GoTo ex96_127 Else GoTo ex64_95

ex64_95:
        If (xxx And 16) Then GoTo ex80_95 Else GoTo ex64_79

ex64_79:
        If (xxx And 8) Then GoTo ex72_79 Else GoTo ex64_71

ex64_71:
        If (xxx And 4) Then GoTo ex68_71 Else GoTo ex64_67

ex64_67:
        If (xxx And 2) Then GoTo ex66_67 Else GoTo ex64_65

ex64_65:
        If xxx = 64 Then
            ' LD B,B
            desa_Z80 = " LD    B,B"
        Else
            ' 65 ' LD B,C
            desa_Z80 = " LD    B,C"
        End If
        Exit Function

ex66_67:
        If xxx = 66 Then
            ' LD B,D
            desa_Z80 = " LD    B,D"
        Else
            ' 67 ' LD B,E
            desa_Z80 = " LD    B,E"
        End If
        Exit Function

ex68_71:
        If (xxx And 2) Then GoTo ex70_71 Else GoTo ex68_69

ex68_69:
        If xxx = 68 Then
            ' LD B,H
            desa_Z80 = " LD    B,H"
        Else
            ' 69 ' LD B,L
            desa_Z80 = " LD    B,L"
        End If
        Exit Function

ex70_71:
        If xxx = 70 Then
            ' LD B,(HL)
            desa_Z80 = " LD    B,(HL)"
        Else
            ' 71 ' LD B,A
            desa_Z80 = " LD    B,A"
        End If
        Exit Function

ex72_79:
        If (xxx And 4) Then GoTo ex76_79 Else GoTo ex72_75

ex72_75:
        If (xxx And 2) Then GoTo ex74_75 Else GoTo ex72_73

ex72_73:
        If xxx = 72 Then
            ' 72 ' LD C,B
            desa_Z80 = " LD    C,B"
        Else
            ' 73 ' LD C,C
            desa_Z80 = " LD    C,C"
        End If
        Exit Function

ex74_75:
        If xxx = 74 Then
            ' 74 ' LD C,D
            desa_Z80 = " LD    C,D"
        Else
            ' 75 ' LD C,E
            desa_Z80 = " LD    C,E"
        End If
        Exit Function

ex76_79:
        If (xxx And 2) Then GoTo ex78_79 Else GoTo ex76_77

ex76_77:
        If xxx = 76 Then
            ' 76 ' LD C,H
            desa_Z80 = " LD    C,H"
        Else
            ' 77 ' LD C,L
            desa_Z80 = " LD    C,L"
        End If
        Exit Function

ex78_79:
        If xxx = 78 Then
            ' 78 ' LD C,(HL)
            desa_Z80 = " LD    C,(HL)"
        Else
            ' 79 ' LD C,A
            desa_Z80 = " LD    C,A"
        End If
        Exit Function

ex80_95:
        Select Case xxx
            Case 80 ' LD D,B
                desa_Z80 = " LD    D,B"
            Case 81 ' LD D,C
                desa_Z80 = " LD    D,C"
            Case 82 ' LD D,D
                desa_Z80 = " LD    D,D"
            Case 83 ' LD D,E
                desa_Z80 = " LD    D,E"
            Case 84 ' LD D,H
                desa_Z80 = " LD    D,H"
            Case 85 ' LD D,L
                desa_Z80 = " LD    D,L"
            Case 86 ' LD D,(HL)
                desa_Z80 = " LD    D,(HL)"
            Case 87 ' LD D,A
                desa_Z80 = " LD    D,A"
                '  LD E,*
            Case 88 ' LD E,B
                desa_Z80 = " LD    E,B"
            Case 89 ' LD E,C
                desa_Z80 = " LD    E,C"
            Case 90 ' LD E,D
                desa_Z80 = " LD    E,D"
            Case 91 ' LD E,E
                desa_Z80 = " LD    E,E"
            Case 92 ' LD E,H
                desa_Z80 = " LD    E,H"
            Case 93 ' LD E,L
                desa_Z80 = " LD    E,L"
            Case 94 ' LD E,(HL)
                desa_Z80 = " LD    E,(HL)"
            Case 95 ' LD E,A
                desa_Z80 = " LD    E,A"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex96_127:
        If (xxx And 16) Then GoTo ex112_127 Else GoTo ex96_111

ex96_111:
        Select Case xxx
            Case 96 ' LD H,B
                desa_Z80 = " LD    H,B"
            Case 97 ' LD H,C
                desa_Z80 = " LD    H,C"
            Case 98 ' LD H,D
                desa_Z80 = " LD    H,D"
            Case 99 ' LD H,E
                desa_Z80 = " LD    H,E"
            Case 100 ' LD H,H
                desa_Z80 = " LD    H,H"
            Case 101 ' LD H,L
                desa_Z80 = " LD    H,L"
            Case 102 ' LD H,(HL)
                desa_Z80 = " LD    H,(HL)"
            Case 103 ' LD H,A
                desa_Z80 = " LD    H,A"
                '  LD L,*
            Case 104 ' LD L,B
                desa_Z80 = " LD    L,B"
            Case 105 ' LD L,C
                desa_Z80 = " LD    L,C"
            Case 106 ' LD L,D
                desa_Z80 = " LD    L,D"
            Case 107 ' LD L,E
                desa_Z80 = " LD    L,E"
            Case 108 ' LD L,H
                desa_Z80 = " LD    L,H"
            Case 109 ' LD L,L
                desa_Z80 = " LD    L,L"
            Case 110 ' LD L,(HL)
                desa_Z80 = " LD    L,(HL)"
            Case 111 ' LD L,A
                desa_Z80 = " LD    L,A"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex112_127:
        If (xxx And 8) Then GoTo ex120_127 Else GoTo ex112_119

ex112_119:
        If (xxx And 4) Then GoTo ex116_119 Else GoTo ex112_115

ex112_115:
        If (xxx And 2) Then GoTo ex114_115 Else GoTo ex112_113

ex112_113:
        If xxx = 112 Then
            ' 112 ' LD (HL),B
            desa_Z80 = " LD    (HL),B"
        Else
            ' 113 ' LD (HL),C
            desa_Z80 = " LD    (HL),C"
        End If
        Exit Function

ex114_115:
        If xxx = 114 Then
            ' 114 ' LD (HL),D
            desa_Z80 = " LD    (HL),D"
        Else
            ' 115 ' LD (HL),E
            desa_Z80 = " LD    (HL),E"
        End If
        Exit Function

ex116_119:
        Select Case xxx
            Case 116 ' LD (HL),H
                desa_Z80 = " LD    (HL),H"
            Case 117 ' LD (HL),L
                desa_Z80 = " LD    (HL),L"
            Case 118 ' HALT
                desa_Z80 = " HALT      "
            Case 119 ' LD (HL),A
                desa_Z80 = " LD    (HL),A"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex120_127:
        If (xxx And 4) Then GoTo ex124_127 Else GoTo ex120_123

ex120_123:
        If (xxx And 2) Then GoTo ex122_123 Else GoTo ex120_121

ex120_121:
        If xxx = 120 Then
            ' 120 ' LD A,B
            desa_Z80 = " LD    A,B"
        Else
            ' 121 ' LD A,C
            desa_Z80 = " LD    A,C"
        End If
        Exit Function

ex122_123:
        If xxx = 122 Then
            ' 122 ' LD A,D
            desa_Z80 = " LD    A,D"
        Else
            ' 123 ' LD A,E
            desa_Z80 = " LD    A,E"
        End If
        Exit Function

ex124_127:
        If (xxx And 2) Then GoTo ex126_127 Else GoTo ex124_125

ex124_125:
        If xxx = 124 Then
            ' 124 ' LD A,H
            desa_Z80 = " LD    A,H"
        Else
            ' 125 ' LD A,L
            desa_Z80 = " LD    A,L"
        End If
        Exit Function

ex126_127:
        If xxx = 126 Then
            ' 126 ' LD A,(HL)
            desa_Z80 = " LD    A,(HL)"
        Else
            ' 127 ' LD A,A
            desa_Z80 = " LD    A,A"
        End If
        Exit Function

ex128_255:
        If (xxx And 64) Then GoTo ex192_255 Else GoTo ex128_191

ex128_191:
        If (xxx And 32) Then GoTo ex160_191 Else GoTo ex128_159

ex128_159:
        Select Case xxx    '  ADD A,*
            Case 128 ' ADD A,B
                desa_Z80 = " ADD   A,B"
            Case 129 ' ADD A,C
                desa_Z80 = " ADD   A,C"
            Case 130 ' ADD A,D
                desa_Z80 = " ADD   A,D"
            Case 131 ' ADD A,E
                desa_Z80 = " ADD   A,E"
            Case 132 ' ADD A,H
                desa_Z80 = " ADD   A,H"
            Case 133 ' ADD A,L
                desa_Z80 = " ADD   A,L"
            Case 134 ' ADD A,(HL)
                desa_Z80 = " ADD   A,(HL)"
            Case 135 ' ADD A,A
                desa_Z80 = " ADD   A,A"
            Case 136 ' ADC A,B
                desa_Z80 = " ADC   A,B"
            Case 137 ' ADC A,C
                desa_Z80 = " ADC   A,C"
            Case 138 ' ADC A,D
                desa_Z80 = " ADC   A,D"
            Case 139 ' ADC A,E
                desa_Z80 = " ADC   A,E"
            Case 140 ' ADC A,H
                desa_Z80 = " ADC   A,H"
            Case 141 ' ADC A,L
                desa_Z80 = " ADC   A,L"
            Case 142 ' ADC A,(HL)
                desa_Z80 = " ADC   A,(HL)"
            Case 143 ' ADC A,A
                desa_Z80 = " ADC   A,A"
            Case 144 ' SUB B
                desa_Z80 = " SUB   B"
            Case 145 ' SUB C
                desa_Z80 = " SUB   C"
            Case 146 ' SUB D
                desa_Z80 = " SUB   D"
            Case 147 ' SUB E
                desa_Z80 = " SUB   E"
            Case 148 ' SUB H
                desa_Z80 = " SUB   H"
            Case 149 ' SUB L
                desa_Z80 = " SUB   L"
            Case 150 ' SUB (HL)
                desa_Z80 = " SUB   (HL)"
            Case 151 ' SUB A
                desa_Z80 = " SUB   A"
            Case 152 ' SBC A,B
                desa_Z80 = " SBC   A,B"
            Case 153 ' SBC A,C
                desa_Z80 = " SBC   A,C"
            Case 154 ' SBC A,D
                desa_Z80 = " SBC   A,D"
            Case 155 ' SBC A,E
                desa_Z80 = " SBC   A,E"
            Case 156 ' SBC A,H
                desa_Z80 = " SBC   A,H"
            Case 157 ' SBC A,L
                desa_Z80 = " SBC   A,L"
            Case 158 ' SBC A,(HL)
                desa_Z80 = " SBC   A,(HL)"
            Case 159 ' SBC A,A
                desa_Z80 = " SBC   A,A"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex160_191:
        If (xxx And 16) Then GoTo ex176_191 Else GoTo ex160_175

ex160_175:
        If (xxx And 8) Then GoTo ex168_175 Else GoTo ex160_167

ex160_167:
        If (xxx And 4) Then GoTo ex164_167 Else GoTo ex160_163

ex160_163:
        Select Case xxx
            Case 160 ' AND B
                desa_Z80 = " AND   B"
            Case 161 ' AND C
                desa_Z80 = " AND   C"
            Case 162 ' AND D
                desa_Z80 = " AND   D"
            Case 163 ' AND E
                desa_Z80 = " AND   E"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex164_167:
        Select Case xxx
            Case 164 ' AND H
                desa_Z80 = " AND   H"
            Case 165 ' AND L
                desa_Z80 = " AND   L"
            Case 166 ' AND (HL)
                desa_Z80 = " AND   (HL)"
            Case 167 ' AND A
                desa_Z80 = " AND   A"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex168_175:
        If (xxx And 4) Then GoTo ex172_175 Else GoTo ex168_171

ex168_171:
        Select Case xxx
            Case 168 ' XOR B
                desa_Z80 = " XOR   B"
            Case 169 ' XOR C
                desa_Z80 = " XOR   C"
            Case 170 ' XOR D
                desa_Z80 = " XOR   D"
            Case 171 ' XOR E
                desa_Z80 = " XOR   E"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex172_175:
        Select Case xxx
            Case 172 ' XOR H
                desa_Z80 = " XOR   H"
            Case 173 ' XOR L
                desa_Z80 = " XOR   L"
            Case 174 ' XOR (HL)
                desa_Z80 = " XOR   (HL)"
            Case 175 ' XOR A
                desa_Z80 = " XOR   A"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex176_191:
        Select Case xxx
            Case 176 ' OR B
                desa_Z80 = " OR    B"
            Case 177 ' OR C
                desa_Z80 = " OR    C"
            Case 178 ' OR D'
                desa_Z80 = " OR    D"
            Case 179 ' OR E
                desa_Z80 = " OR    E"
            Case 180 ' OR H
                desa_Z80 = " OR    H"
            Case 181 ' OR L
                desa_Z80 = " OR    L"
            Case 182 ' OR (HL)
                desa_Z80 = " OR    (HL)"
            Case 183 ' OR A
                desa_Z80 = " OR    A"
                '  CP
            Case 184 ' CP B
                desa_Z80 = " CP    B"
            Case 185 ' CP C
                desa_Z80 = " CP    C"
            Case 186 ' CP D
                desa_Z80 = " CP    D"
            Case 187 ' CP E
                desa_Z80 = " CP    E"
            Case 188 ' CP H
                desa_Z80 = " CP    H"
            Case 189 ' CP L
                desa_Z80 = " CP    L"
            Case 190 ' CP (HL)
                desa_Z80 = " CP    (HL)"
            Case 191 ' CP A
                desa_Z80 = " CP    A"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex192_255:
        If (xxx And 32) Then GoTo ex224_255 Else GoTo ex192_223

ex192_223:
        If (xxx And 16) Then GoTo ex208_223 Else GoTo ex192_207

ex192_207:
        Select Case xxx
            Case 192 ' RET NZ
                desa_Z80 = " RET   NZ"
            Case 193 ' POP BC
                desa_Z80 = " POP   BC"
            Case 194 ' JP NZ,nn
                desa_Z80 = " JP    NZ,"
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 195 ' JP nn
                desa_Z80 = " JP    "
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 196 ' CALL NZ,nn
                desa_Z80 = " CALL  NZ,"
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 197 ' PUSH BC
                desa_Z80 = " PUSH  BC"
            Case 198 ' ADD A,n
                desa_Z80 = " ADD   A,"
                desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
            Case 199 ' RST 0
                desa_Z80 = " RST  0 "
            Case 200 ' RET Z
                desa_Z80 = " RET    Z"
            Case 201 ' RET
                desa_Z80 = " RET   "
            Case 202 ' JP Z,nn
                desa_Z80 = " JP    Z,"
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 203 ' Prefix CB
                '           local_tstates +=  execute_cb()   'excution code CB
                desa_Z80 = "" + Desa_cb()
            Case 204 ' CALL Z,nn
                desa_Z80 = " CALL  Z,"
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 205 ' CALL nn
                desa_Z80 = " CALL  "
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 206 ' ADC A,n
                desa_Z80 = " ADC    A,"
                desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
            Case 207 ' RST 8
                desa_Z80 = " RST   8"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex208_223:
        If (xxx And 8) Then GoTo ex216_223 Else GoTo ex208_215

ex208_215:
        Select Case xxx
            Case 208 ' RET NC
                desa_Z80 = " RET   NC"
            Case 209 ' POP DE
                desa_Z80 = " POP   DE"
            Case 210 '  JP NC,nn
                desa_Z80 = " JP    NC,"
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 211 ' OUT (n),A
                desa_Z80 = " OUT   ("
                desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb()) + "),A"
            Case 212 ' CALL NC,nn
                desa_Z80 = " CALL  NC,"
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 213 ' PUSH DE
                desa_Z80 = " PUSH  DE"
            Case 214 ' SUB n
                desa_Z80 = " SUB   "
                desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
            Case 215 ' RST 16
                desa_Z80 = " RST    16"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex216_223:
        If (xxx And 4) Then GoTo ex220_223 Else GoTo ex216_219

ex216_219:
        Select Case xxx
            Case 216 ' RET C
                desa_Z80 = " RET    C"
            Case 217 ' EXX
                desa_Z80 = " EXX    "
            Case 218 ' JP C,nn
                desa_Z80 = " JP    C,"
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 219 ' IN A,(n)
                desa_Z80 = " IN    A,("
                desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb()) + ")"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex220_223:
        Select Case xxx
            Case 220 ' CALL C,nn
                desa_Z80 = " CALL  C,"
                desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
            Case 221 ' prefix IX
                '                regID = regIX
                regID_Name = "IX"
                '                local_tstates +=  execute_id()        'excution code ID000000000000000000000000000000000000000000
                desa_Z80 = desa_id("IX")  'Code IX
            Case 222 ' SBC n
                desa_Z80 = " SBC   "
                desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
            Case 223 ' RST 24
                desa_Z80 = " RST    24"
            Case Else
                desa_Z80 = "inconnu"
        End Select
        Exit Function

ex224_255:
        If (xxx And 16) Then GoTo ex240_255 Else GoTo ex224_239

ex224_239:
        If (xxx And 8) Then GoTo ex232_239 Else GoTo ex224_231

ex224_231:
        If (xxx And 4) Then GoTo ex228_231 Else GoTo ex224_227

ex224_227:
        If (xxx And 2) Then GoTo ex226_227 Else GoTo ex224_225

ex224_225:
        If xxx = 224 Then
            ' 224 ' RET PO
            desa_Z80 = " RET    PO"
        Else
            ' 225 ' POP HL
            desa_Z80 = " POP    HL"
        End If
        Exit Function

ex226_227:
        If xxx = 226 Then
            ' 226 JP PO,nn
            desa_Z80 = " JP    PO,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        Else
            ' 227 ' EX (SP),HL
            desa_Z80 = " EX    (SP),HL"
        End If
        Exit Function

ex228_231:
        If (xxx And 2) Then GoTo ex230_231 Else GoTo ex228_229

ex228_229:
        If xxx = 228 Then
            ' 228 ' CALL PO,nn
            desa_Z80 = " JP    PO,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        Else
            ' 229 ' PUSH HL
            desa_Z80 = " PUSH  HL"
        End If
        Exit Function

ex230_231:
        If xxx = 230 Then
            ' 230 ' AND n
            desa_Z80 = " AND    "
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 231 ' RST 32
            desa_Z80 = " RST   32"
        End If
        Exit Function

ex232_239:
        If (xxx And 4) Then GoTo ex236_239 Else GoTo ex232_235

ex232_235:
        If (xxx And 2) Then GoTo ex234_235 Else GoTo ex232_233

ex232_233:
        If xxx = 232 Then
            ' 232 ' RET PE
            desa_Z80 = " RET    PE"
        Else
            ' 233 ' JP HL
            desa_Z80 = " JP     HL"
        End If
        Exit Function

ex234_235:
        If xxx = 234 Then
            ' 234 ' JP PE,nn
            desa_Z80 = " JP    PE,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        Else
            ' 235 ' EX DE,HL
            desa_Z80 = " EX    DE,HL"
        End If
        Exit Function

ex236_239:
        If (xxx And 2) Then GoTo ex238_239 Else GoTo ex236_237

ex236_237:
        If xxx = 236 Then
            ' 236 ' CALL PE,nn
            desa_Z80 = " CALL  PE,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        Else
            ' 237 ' prefix ED
            '      local_tstates +=  execute_ed(local_tstates)      'excution code ED 
            desa_Z80 = "" & Desa_ed()
        End If
        Exit Function

ex238_239:
        If xxx = 238 Then
            ' 238 ' XOR n
            desa_Z80 = " XOR    "
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 239 ' RST 40
            desa_Z80 = " RST    40"
        End If
        Exit Function

ex240_255:
        If (xxx And 8) Then GoTo ex248_255 Else GoTo ex240_247

ex240_247:
        If (xxx And 4) Then GoTo ex244_247 Else GoTo ex240_243

ex240_243:
        If (xxx And 2) Then GoTo ex242_243 Else GoTo ex240_241

ex240_241:
        If xxx = 240 Then
            ' 240 RET P
            desa_Z80 = " RET    P"
        Else
            ' 241 POP AF
            desa_Z80 = " POP    AF"
        End If
        Exit Function

ex242_243:
        If xxx = 242 Then
            ' 242 JP P,nn
            desa_Z80 = " JP    P,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        Else
            ' 243 DI
            desa_Z80 = " DI    "
        End If
        Exit Function

ex244_247:
        If (xxx And 2) Then GoTo ex246_247 Else GoTo ex244_245

ex244_245:
        If xxx = 244 Then
            ' 244 CALL P,nn
            desa_Z80 = " CALL  P,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        Else
            ' 245 PUSH AF
            desa_Z80 = " PUSH  AF"
        End If
        Exit Function

ex246_247:
        If xxx = 246 Then
            ' 246 OR n
            desa_Z80 = " OR    "
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 247 RST 48
            desa_Z80 = " RST    48"
        End If
        Exit Function

ex248_255:
        If (xxx And 4) Then GoTo ex252_255 Else GoTo ex248_251

ex248_251:
        If (xxx And 2) Then GoTo ex250_251 Else GoTo ex248_249

ex248_249:
        If xxx = 248 Then
            ' 248 RET M
            desa_Z80 = " RET    M"
        Else
            ' 249 LD SP,HL
            desa_Z80 = " LD     SP,HL"
        End If
        Exit Function

ex250_251:
        If xxx = 250 Then
            ' 250 JP M,nn
            desa_Z80 = " JP    M,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        Else
            ' 251 EI
            desa_Z80 = " EI"
        End If
        Exit Function

ex252_255:
        If (xxx And 2) Then GoTo ex254_255 Else GoTo ex252_253

ex252_253:
        If xxx = 252 Then
            ' 252 CALL M,nn
            desa_Z80 = " CALL  M,"
            desa_Z80 = desa_Z80 & Caractere_hex4(nxtpcw())
        Else
            ' 253 prefix IY
            regID = regIY
            regID_Name = "IY"  'jjs3

            '     local_tstates +=  execute_id()  '*************************************************idididid
            desa_Z80 = "" & desa_id("IY")   ' code IY ! 
            '    regIY = regID
        End If
        Exit Function

ex254_255:
        If xxx = 254 Then
            ' 254 CP n
            desa_Z80 = " CP    "
            desa_Z80 = desa_Z80 & Caractere_hex(nxtpcb())
        Else
            ' 255 RST 56
            desa_Z80 = " RST    56"
        End If
        Exit Function
    End Function

    Private Function qdec8(ByVal a As Integer) As Integer
        qdec8 = (a - 1) And &HFF&
    End Function
    Private Function execute_id() As Integer
        Dim xxx As Integer, lTemp As Integer, op As Integer


        '  Yes, I appreciate that GOTO's and labels are a hideous blashphemy!
        '  However, this code is the fastest possible way of fetching and handling
        '  Z80 instructions I could come up with. There are only 8 compares per
        '  instruction fetch rather than between 1 and 255 as required in
        '  the previous version of vb81 with it's huge Case statement.
        ' 
        '  I know it's slightly harder to follow the new code, but I think the
        '  speed increase justifies it. <CC>


        '  REFRESH 1
        intRTemp = intRTemp + 1

        xxx = nxtpcb()

        If (xxx And 128) Then GoTo ex_id128_255 Else GoTo ex_id0_127

ex_id0_127:
        If (xxx And 64) Then GoTo ex_id64_127 Else GoTo ex_id0_63

ex_id0_63:
        If (xxx And 32) Then GoTo ex_id32_63 Else GoTo ex_id0_31

ex_id0_31:
        Select Case xxx
            Case 0 To 8
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 9 ' ADD ID,BC
                regID = add16(regID, getBC)
                execute_id = 15
            Case 10 To 24
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 25 ' ADD ID,DE
                regID = add16(regID, regDE)
                execute_id = 15
            Case 26 To 31
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
        End Select
        GoTo execute_id_end

ex_id32_63:
        Select Case xxx
            Case 32
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 33 ' LD ID,nn
                regID = nxtpcw()
                execute_id = 14
            Case 34 ' LD (nn),ID
                pokew(nxtpcw, regID)
                execute_id = 20
            Case 35 ' INC ID
                regID = inc16(regID)
                execute_id = 10
            Case 36 ' INC IDH
                setIDH(inc8(getIDH))
                execute_id = 9
            Case 37 ' DEC IDH
                setIDH(dec8(getIDH))
                execute_id = 9
            Case 38 ' LD IDH,n
                setIDH(nxtpcb())
                execute_id = 11
            Case 39, 40
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 41 ' ADD ID,ID
                lTemp = regID
                regID = add16(lTemp, lTemp)
                execute_id = 15
            Case 42 ' LD ID,(nn)
                regID = peekw(nxtpcw)
                execute_id = 20
            Case 43 ' DEC ID
                regID = dec16(regID)
                execute_id = 10
            Case 44 ' INC IDL
                setIDL(inc8(getIDL))
                execute_id = 9
            Case 45 ' DEC IDL
                setIDL(dec8(getIDL))
                execute_id = 9
            Case 46 ' LD IDL,n
                setIDL(nxtpcb())
                execute_id = 11
            Case 47 To 51
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 52 ' INC (ID+d)
                lTemp = id_d()
                pokeb(lTemp, inc8(peekb(lTemp)))
                execute_id = 23
            Case 53 ' DEC (ID+d)
                lTemp = id_d()
                pokeb(lTemp, dec8(peekb(lTemp)))
                execute_id = 23
            Case 54 ' LD (ID+d),n
                lTemp = id_d()
                pokeb(lTemp, nxtpcb())
                execute_id = 19
            Case 55, 56
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 57 ' ADD ID,SP
                regID = add16(regID, regSP)
                execute_id = 15
            Case 58 To 63
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
        End Select
        GoTo execute_id_end

ex_id64_127:
        Select Case xxx
            Case 64 To 67
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 68 ' LD B,IDH
                regB = getIDH()
                execute_id = 9
            Case 69 ' LD B,IDL
                regB = getIDL()
                execute_id = 9
            Case 70 ' LD B,(ID+d)
                regB = peekb(id_d)
                execute_id = 19
            Case 71 To 75
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 76 ' LD C,IDH
                regC = getIDH()
                execute_id = 9
            Case 77 ' LD C,IDL
                regC = getIDL()
                execute_id = 9
            Case 78 ' LD C,(ID+d)
                regC = peekb(id_d)
                execute_id = 19
            Case 79 To 83
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 84 ' LD D,IDH
                setD(getIDH)
                execute_id = 9
            Case 85 ' LD D,IDL
                setD(getIDL)
                execute_id = 9
            Case 86 ' LD D,(ID+d)
                setD(peekb(id_d))
                execute_id = 19
            Case 87 To 91
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 92 ' LD E,IDH
                setE(getIDH)
                execute_id = 9
            Case 93 ' LD E,IDL
                setE(getIDL)
                execute_id = 9
            Case 94 ' LD E,(ID+d)
                setE(peekb(id_d))
                execute_id = 19
            Case 95
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 96 ' LD IDH,B
                setIDH(regB)
                execute_id = 9
            Case 97 ' LD IDH,C
                setIDH(regC)
                execute_id = 9
            Case 98 ' LD IDH,D
                setIDH(getD)
                execute_id = 9
            Case 99 ' LD IDH,E
                setIDH(getE)
                execute_id = 9
            Case 100 ' LD IDH,IDH
                execute_id = 9
            Case 101 ' LD IDH,IDL
                setIDH(getIDL)
                execute_id = 9
            Case 102 ' LD H,(ID+d)
                setH(peekb(id_d))
                execute_id = 19
            Case 103 ' LD IDH,A
                setIDH(regA)
                execute_id = 9
            Case 104 ' LD IDL,B
                setIDL(regB)
                execute_id = 9
            Case 105 ' LD IDL,C
                setIDL(regC)
                execute_id = 9
            Case 106 ' LD IDL,D
                setIDL(getD)
                execute_id = 9
            Case 107 ' LD IDL,E
                setIDL(getE)
                execute_id = 9
            Case 108 ' LD IDL,IDH
                setIDL(getIDH)
                execute_id = 9
            Case 109 ' LD IDL,IDL
                execute_id = 9
            Case 110 ' LD L,(ID+d)
                setL(peekb(id_d))
                execute_id = 19
            Case 111 ' LD IDL,A
                setIDL(regA)
                execute_id = 9
            Case 112 ' LD (ID+d),B
                pokeb(id_d, regB)
                execute_id = 19
            Case 113 ' LD (ID+d),C
                pokeb(id_d, regC)
                execute_id = 19
            Case 114 ' LD (ID+d),D
                pokeb(id_d, getD)
                execute_id = 19
            Case 115 ' LD (ID+d),E
                pokeb(id_d, getE)
                execute_id = 19
            Case 116 ' LD (ID+d),H
                pokeb(id_d, getH)
                execute_id = 19
            Case 117 ' LD (ID+d),L
                pokeb(id_d, getL)
                execute_id = 19
            Case 118 ' UNKNOWN
                MsgBox("Unknown ID instruction " & xxx & " at " & regPC)
            Case 119 ' LD (ID+d),A
                pokeb(id_d, regA)
                execute_id = 19
            Case 120 To 123
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 124 ' LD A,IDH
                regA = getIDH()
                execute_id = 9
            Case 125 ' LD A,IDL
                regA = getIDL()
                execute_id = 9
            Case 126 ' LD A,(ID+d)
                regA = peekb(id_d)
                execute_id = 19
            Case 127
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
        End Select
        GoTo execute_id_end

ex_id128_255:
        If (xxx And 64) Then GoTo ex_id192_255 Else GoTo ex_id128_191

ex_id128_191:
        If (xxx And 32) Then GoTo ex_id160_191 Else GoTo ex_id128_159

ex_id128_159:
        Select Case xxx
            Case 128 To 131
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 132 ' ADD A,IDH
                add_a(getIDH)
                execute_id = 9
            Case 133 ' ADD A,IDL
                add_a(getIDL)
                execute_id = 9
            Case 134 ' ADD A,(ID+d)
                add_a(peekb(id_d))
                execute_id = 19
            Case 135 To 139
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 140 ' ADC A,IDH
                adc_a(getIDH)
                execute_id = 9
            Case 141 ' ADC A,IDL
                adc_a(getIDL)
                execute_id = 9
            Case 142 ' ADC A,(ID+d)
                adc_a(peekb(id_d))
                execute_id = 19
            Case 143 To 147
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 148 ' SUB IDH
                sub_a(getIDH)
                execute_id = 9
            Case 149 ' SUB IDL
                sub_a(getIDL)
                execute_id = 9
            Case 150 ' SUB (ID+d)
                sub_a(peekb(id_d))
                execute_id = 19
            Case 151 To 155
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 156 ' SBC A,IDH
                sbc_a(getIDH)
                execute_id = 9
            Case 157 ' SBC A,IDL
                sbc_a(getIDL)
                execute_id = 9
            Case 158 ' SBC A,(ID+d)
                sbc_a(peekb(id_d))
                execute_id = 19
            Case 159
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
        End Select
        GoTo execute_id_end

ex_id160_191:
        Select Case xxx
            Case 160 To 163
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 164 ' AND IDH
                and_a(getIDH)
                execute_id = 9
            Case 165 ' AND IDL
                and_a(getIDL)
                execute_id = 9
            Case 166 ' AND (ID+d)
                and_a(peekb(id_d))
                execute_id = 19
            Case 167 To 171
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 172 ' XOR IDH
                xor_a(getIDH)
                execute_id = 9
            Case 173 ' XOR IDL
                xor_a(getIDL)
                execute_id = 9
            Case 174 'XOR (ID+d)
                xor_a(peekb(id_d))
                execute_id = 19
            Case 175 To 179
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 180 ' OR IDH
                or_a(getIDH)
                execute_id = 9
            Case 181 ' OR IDL
                or_a(getIDL)
                execute_id = 9
            Case 182 ' OR (ID+d)
                or_a(peekb(id_d))
                execute_id = 19
            Case 183 To 187
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 188 ' CP IDH
                cp_a(getIDH)
                execute_id = 9
            Case 189 ' CP IDL
                cp_a(getIDL)
                execute_id = 9
            Case 190 ' CP (ID+d)
                cp_a(peekb(id_d))
                execute_id = 19
            Case 191
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
        End Select
        GoTo execute_id_end

ex_id192_255:
        Select Case xxx
            Case 192 To 202
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 203 ' prefix CB
                lTemp = id_d()
                op = nxtpcb()
                execute_id_cb(op, lTemp)                                     'excution code CB avec ID
                If ((op And &HC0&) = &H40&) Then execute_id = 20 Else execute_id = 23
            Case 204 To 224
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 225 ' POP ID
                regID = popw()
                execute_id = 14
            Case 226
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 227 ' EX (SP),ID
                lTemp = regID
                regID = peekw(regSP)
                pokew(regSP, lTemp)
                execute_id = 23
            Case 228
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 229 ' PUSH ID
                pushw(regID)
                execute_id = 15
            Case 230 To 232
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 233 ' JP ID
                regPC = regID
                execute_id = 8
            Case 234 To 248
                regPC = dec16(regPC)
                '  REFRESH -1
                intRTemp = intRTemp - 1
                execute_id = 4
            Case 249 ' LD SP,ID
                regSP = regID
                execute_id = 10
            Case Else
                MsgBox("Unknown ID instruction " & xxx & " at " & regPC)
        End Select

execute_id_end:
        Return 0
    End Function

    Private Sub setIDH(ByVal byteval As Integer)
        regID = ((byteval * 256&) And &HFF00&) Or (regID And &HFF&)
    End Sub
    Private Sub setIDL(ByVal byteval As Integer)
        regID = (regID And &HFF00&) Or (byteval And &HFF&)
    End Sub
    Private Function getIDH() As Integer
        getIDH = TabMemAddrDiv256(regID) And &HFF&
    End Function
    Private Function getIDL() As Integer
        getIDL = regID And &HFF&
    End Function
    Private Function inc16(ByVal a As Integer) As Integer
        inc16 = (a + 1) And &HFFFF&
    End Function
    Function nxtpcw() As Integer
        nxtpcw = peekb(regPC) + (peekb(regPC + 1) * 256&)
        regPC = regPC + 2
    End Function
    Function nxtpcb() As Integer
        nxtpcb = peekb(regPC)
        regPC = regPC + 1
    End Function
    Function peekb(ByVal addr As Integer) As Integer
        If isHector Then
            ' Hector !
            peekb = (Hector.MemR(addr)) And &HFF
        Else
            'Disc 2 ! 
            peekb = (Disc2.MemR(addr)) And &HFF
        End If
    End Function
    Sub setD(ByVal l As Integer)
        regDE = (l * 256.0#) Or (regDE And &HFF&)
    End Sub
    Sub setE(ByVal l As Integer)
        regDE = (regDE And &HFF00&) Or l
    End Sub
    Sub setF(ByVal b As Byte)
        fS = (b And F_S) <> 0
        fZ = (b And F_Z) <> 0
        f5 = (b And F_5) <> 0
        fH = (b And F_H) <> 0
        f3 = (b And F_3) <> 0
        fPV = (b And F_PV) <> 0
        fN = (b And F_N) <> 0
        fC = (b And F_C) <> 0
    End Sub
    Sub setH(ByVal l As Integer)
        regHL = (l * 256.0#) Or (regHL And &HFF&)
    End Sub
    Sub setL(ByVal l As Integer)
        regHL = (regHL And &HFF00&) Or l
    End Sub
    Function sra(ByVal ans As Integer) As Integer
        Dim c As Integer

        c = (ans And &H1&) <> 0
        ans = TabMemAddrDiv2(ans) Or (ans And &H80&)

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False
        fC = c

        sra = ans
    End Function
    Function srl(ByVal ans As Integer) As Integer
        Dim c As Integer

        c = (ans And &H1&) <> 0
        ans = TabMemAddrDiv2(ans)

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False
        fC = c

        srl = ans
    End Function
    Function sls(ByVal ans As Integer) As Integer
        Dim c As Integer

        c = (ans And &H80&) <> 0
        ans = ((ans * 2) Or &H1) And &HFF

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fPV = Parity(ans)
        fH = False
        fN = False
        fC = c

        sls = ans
    End Function
    Sub sub_a(ByVal b As Integer)
        Dim a As Integer, wans As Integer, ans As Integer

        a = regA
        wans = a - b
        ans = wans And &HFF&

        fS = (ans And F_S) <> 0
        f3 = (ans And F_3) <> 0
        f5 = (ans And F_5) <> 0
        fZ = (ans = 0)
        fC = (wans And &H100&) <> 0
        fPV = ((a Xor b) And (a Xor ans) And &H80&) <> 0

        fH = (((a And &HF&) - (b And &HF)) And F_H) <> 0
        fN = True

        regA = ans
    End Sub
    Sub xor_a(ByVal b As Integer)
        regA = (regA Xor b) And &HFF&

        fS = (regA And F_S) <> 0
        f3 = (regA And F_3) <> 0
        f5 = (regA And F_5) <> 0
        fH = False
        fPV = Parity(regA)
        fZ = (regA = 0)
        fN = False
        fC = False
    End Sub

    Public Sub Z80Reset(ByRef local_tstates As Long, ByRef TstatesPerInterrupt As Long)
        'RAZ des registres
        regPC = 0
        regSP = 0
        regA = 0
        setF(0)
        setBC(0)
        regDE = 0
        regHL = 0

        exx()
        ex_af_af()

        regIX = 0
        regIY = 0

        intR = 128
        intRTemp = 128

        intI = 0
        intIFF1 = False
        intIFF2 = False
        intIM = 0

        'init des interrutions
        local_tstates = TstatesPerInterrupt
    End Sub

End Class